/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.newgamescreen;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.utils.Array;
import com.unciv.UncivGame;
import com.unciv.models.metadata.GameParameters;
import com.unciv.models.ruleset.nation.Nation;
import com.unciv.models.ruleset.unique.IHasUniques;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.widgets.AutoScrollPane;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.popups.Popup;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.newgamescreen.IPreviousScreen;
import com.unciv.ui.screens.newgamescreen.NationTable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0002\u0018\u0000 /2\u00020\u0001:\u0001/B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0006\u0010\u001e\u001a\u00020\bJ8\u0010\u001f\u001a\u00020\b2\u0006\u0010 \u001a\u00020\u00112\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001c0\"2\u0018\u0010#\u001a\u0014\u0012\u0004\u0012\u00020%\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070$H\u0002J\u0014\u0010&\u001a\u00020'*\u00020\u001c2\u0006\u0010(\u001a\u00020)H\u0002J\u0010\u0010*\u001a\u00020\b2\u0006\u0010+\u001a\u00020%H\u0002J\u0010\u0010,\u001a\u00020\b2\u0006\u0010+\u001a\u00020%H\u0002J\b\u0010-\u001a\u00020\bH\u0002J\b\u0010.\u001a\u00020\bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0016\u001a\u0012\u0012\u0004\u0012\u00020\u00180\u0017j\b\u0012\u0004\u0012\u00020\u0018`\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/unciv/ui/screens/newgamescreen/RandomNationPickerPopup;", "Lcom/unciv/ui/popups/Popup;", "previousScreen", "Lcom/unciv/ui/screens/newgamescreen/IPreviousScreen;", "gameParameters", "Lcom/unciv/models/metadata/GameParameters;", "onExit", "Lkotlin/Function0;", "", "<init>", "(Lcom/unciv/ui/screens/newgamescreen/IPreviousScreen;Lcom/unciv/models/metadata/GameParameters;Lkotlin/jvm/functions/Function0;)V", "isPortrait", "", "civBlocksWidth", "", "partHeight", "availableNationsListTable", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "availableNationsListScroll", "Lcom/unciv/ui/components/widgets/AutoScrollPane;", "selectedNationsListTable", "selectedNationsListScroll", "allNationTables", "Ljava/util/ArrayList;", "Lcom/unciv/ui/screens/newgamescreen/NationTable;", "Lkotlin/collections/ArrayList;", "availableNations", "", "", "selectedNations", "update", "updateNationListTable", "table", "nations", "", "actionFactory", "Lkotlin/Function1;", "Lcom/unciv/models/ruleset/nation/Nation;", "toImageButton", "Lcom/badlogic/gdx/scenes/scene2d/Group;", "overColor", "Lcom/badlogic/gdx/graphics/Color;", "addNationToPool", "nation", "removeNationFromPool", "returnSelected", "switchAllNations", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nGameOptionsTable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GameOptionsTable.kt\ncom/unciv/ui/screens/newgamescreen/RandomNationPickerPopup\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,636:1\n774#2:637\n865#2,2:638\n827#2:640\n855#2,2:641\n1563#2:643\n1634#2,3:644\n1563#2:647\n1634#2,3:648\n1#3:651\n*S KotlinDebug\n*F\n+ 1 GameOptionsTable.kt\ncom/unciv/ui/screens/newgamescreen/RandomNationPickerPopup\n*L\n540#1:637\n540#1:638,2\n541#1:640\n541#1:641,2\n544#1:643\n544#1:644,3\n546#1:647\n546#1:648,3\n*E\n"})
final class RandomNationPickerPopup
extends Popup {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final GameParameters gameParameters;
    @NotNull
    private final Function0<Unit> onExit;
    private final boolean isPortrait;
    private final float civBlocksWidth;
    private final float partHeight;
    @NotNull
    private final Table availableNationsListTable;
    @NotNull
    private final AutoScrollPane availableNationsListScroll;
    @NotNull
    private final Table selectedNationsListTable;
    @NotNull
    private final AutoScrollPane selectedNationsListScroll;
    @NotNull
    private final ArrayList<NationTable> allNationTables;
    @NotNull
    private Set<String> availableNations;
    @NotNull
    private Set<String> selectedNations;
    public static final float buttonsCircleSize = 70.0f;
    public static final float buttonsIconSize = 50.0f;
    public static final float buttonsOffsetFromEdge = 5.0f;
    @NotNull
    private static final Color buttonsBackColor;

    /*
     * WARNING - void declaration
     */
    public RandomNationPickerPopup(@NotNull IPreviousScreen previousScreen, @NotNull GameParameters gameParameters, @NotNull Function0<Unit> onExit) {
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        void $this$filterNotTo$iv$iv;
        Object $this$filterNot$iv;
        Nation it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter(previousScreen, "previousScreen");
        Intrinsics.checkNotNullParameter(gameParameters, "gameParameters");
        Intrinsics.checkNotNullParameter(onExit, "onExit");
        super((BaseScreen)((Object)previousScreen), null, 0.0f, 6, null);
        this.gameParameters = gameParameters;
        this.onExit = onExit;
        this.isPortrait = ((BaseScreen)((Object)previousScreen)).isPortrait();
        this.civBlocksWidth = this.getStageToShowOn().getWidth() / (float)3 - 5.0f;
        this.partHeight = this.getStageToShowOn().getHeight() * (this.isPortrait ? 0.45f : 0.8f);
        this.availableNationsListTable = new Table();
        this.availableNationsListScroll = new AutoScrollPane((Actor)this.availableNationsListTable, null, 2, null);
        this.selectedNationsListTable = new Table();
        this.selectedNationsListScroll = new AutoScrollPane((Actor)this.selectedNationsListTable, null, 2, null);
        Collection<Nation> collection = previousScreen.getRuleset().getNations().values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Iterable iterable = collection;
        boolean $i$f$filter = false;
        void var7_7 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Nation)element$iv$iv;
            boolean bl = false;
            if (!it.isMajorCiv()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filterNot = false;
        $this$filterTo$iv$iv = $this$filterNot$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (Nation)element$iv$iv;
            boolean bl = false;
            if (IHasUniques.hasUnique$default(it, UniqueType.WillNotBeChosenForNewGames, null, 2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterNot$iv = UncivGame.Companion.getCurrent().getSettings().getCollatorFromLocale();
        List sortedNations = CollectionsKt.sortedWith((List)destination$iv$iv, new Comparator((Comparator)$this$filterNot$iv){
            final /* synthetic */ Comparator $comparator;
            {
                this.$comparator = $comparator;
            }

            public final int compare(T a, T b) {
                Nation nation = (Nation)a;
                Comparator comparator = this.$comparator;
                boolean bl = false;
                Nation it = (Nation)b;
                String string = TranslationsKt.tr$default(it.getName(), true, false, 2, null);
                bl = false;
                String string2 = TranslationsKt.tr$default(it.getName(), true, false, 2, null);
                return comparator.compare(string, string2);
            }
        });
        $this$filterNot$iv = sortedNations;
        RandomNationPickerPopup randomNationPickerPopup = this;
        boolean $i$f$map = false;
        $this$filterNotTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Nation)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull(it);
            collection2.add(new NationTable(it, this.civBlocksWidth, 0.0f, null, 8, null));
        }
        Collection collection3 = (List)destination$iv$iv;
        randomNationPickerPopup.allNationTables = new ArrayList(collection3);
        $this$map$iv = sortedNations;
        randomNationPickerPopup = this;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Nation)item$iv$iv;
            Collection collection4 = destination$iv$iv;
            boolean bl = false;
            collection4.add(it.getName());
        }
        randomNationPickerPopup.availableNations = CollectionsKt.toMutableSet((List)destination$iv$iv);
        Set set = CollectionsKt.intersect((Iterable)this.gameParameters.getRandomNationsPool(), (Iterable)this.availableNations);
        Intrinsics.checkNotNull(set, "null cannot be cast to non-null type kotlin.collections.MutableSet<kotlin.String>");
        this.selectedNations = TypeIntrinsics.asMutableSet(set);
        this.availableNations.removeAll((Collection)this.selectedNations);
        this.availableNationsListScroll.setOverscroll(false, false);
        this.add((CharSequence)TranslationsKt.tr$default("Banned nations", false, false, 3, null));
        if (this.isPortrait) {
            this.row();
            this.add((Actor)this.availableNationsListScroll).size(this.civBlocksWidth + 10.0f, this.partHeight).row();
            Popup.addSeparator$default(this, null, 0, 0.0f, 7, null);
            this.add((CharSequence)TranslationsKt.tr$default("Available nations", false, false, 3, null)).row();
        } else {
            this.add((CharSequence)TranslationsKt.tr$default("Available nations", false, false, 3, null)).row();
            this.add((Actor)this.availableNationsListScroll).size(this.civBlocksWidth + 10.0f, this.partHeight);
        }
        this.selectedNationsListScroll.setOverscroll(false, false);
        this.add((Actor)this.selectedNationsListScroll).size(this.civBlocksWidth + 10.0f, this.partHeight);
        this.update();
        this.pack();
        Color color = Color.FIREBRICK;
        Intrinsics.checkNotNullExpressionValue(color, "FIREBRICK");
        Group closeButton = Scene2dExtensionsKt.getCloseButton(70.0f, 50.0f, buttonsBackColor, color, () -> RandomNationPickerPopup._init_$lambda$5(this));
        closeButton.setPosition(5.0f, 5.0f, 12);
        this.getInnerTable().addActor(closeButton);
        this.setClickBehindToClose(true);
        Color color2 = Color.LIME;
        Intrinsics.checkNotNullExpressionValue(color2, "LIME");
        Group okButton = this.toImageButton("OtherIcons/Checkmark", color2);
        ActivationExtensionsKt.onClick(okButton, () -> RandomNationPickerPopup._init_$lambda$6(this));
        okButton.setPosition(this.getInnerTable().getWidth() - 5.0f, 5.0f, 20);
        this.getInnerTable().addActor(okButton);
        Color color3 = Color.YELLOW;
        Intrinsics.checkNotNullExpressionValue(color3, "YELLOW");
        Group switchButton = this.toImageButton("OtherIcons/NationSwap", color3);
        ActivationExtensionsKt.onClick(switchButton, () -> RandomNationPickerPopup._init_$lambda$7(this));
        switchButton.setPosition(this.getInnerTable().getWidth() / (float)2, 40.0f, 1);
        this.getInnerTable().addActor(switchButton);
        this.selectedNationsListTable.setTouchable(Touchable.enabled);
    }

    public final void update() {
        this.updateNationListTable(this.availableNationsListTable, this.availableNations, arg_0 -> RandomNationPickerPopup.update$lambda$9(this, arg_0));
        this.updateNationListTable(this.selectedNationsListTable, this.selectedNations, arg_0 -> RandomNationPickerPopup.update$lambda$11(this, arg_0));
    }

    private final void updateNationListTable(Table table2, Set<String> nations, Function1<? super Nation, ? extends Function0<Unit>> actionFactory) {
        Iterator<NationTable> iterator2 = table2.getChildren().iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator<NationTable> iterator3 = iterator2;
        while (((Array.ArrayIterator)iterator3).hasNext()) {
            Actor child = (Actor)((Array.ArrayIterator)iterator3).next();
            child.getListeners().clear();
        }
        table2.clear();
        Iterator<NationTable> iterator4 = this.allNationTables.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator4, "iterator(...)");
        iterator3 = iterator4;
        while (iterator3.hasNext()) {
            NationTable nationTable;
            Intrinsics.checkNotNullExpressionValue(iterator3.next(), "next(...)");
            if (!nations.contains(nationTable.getNation().getName())) continue;
            ActivationExtensionsKt.onClick(nationTable, actionFactory.invoke(nationTable.getNation()));
            table2.add((Actor)nationTable).row();
        }
    }

    private final Group toImageButton(String $this$toImageButton, Color overColor) {
        return Scene2dExtensionsKt.toImageButton($this$toImageButton, 50.0f, 70.0f, buttonsBackColor, overColor);
    }

    private final void addNationToPool(Nation nation) {
        this.availableNations.remove(nation.getName());
        this.selectedNations.add(nation.getName());
        this.update();
    }

    private final void removeNationFromPool(Nation nation) {
        this.availableNations.add(nation.getName());
        this.selectedNations.remove(nation.getName());
        this.update();
    }

    private final void returnSelected() {
        this.close();
        this.gameParameters.setRandomNationsPool(new ArrayList<String>((Collection)this.selectedNations));
        this.onExit.invoke();
    }

    private final void switchAllNations() {
        Set<String> tempNations = this.availableNations;
        this.availableNations = this.selectedNations;
        this.selectedNations = tempNations;
        this.update();
    }

    private static final Unit _init_$lambda$5(RandomNationPickerPopup this$0) {
        this$0.close();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$6(RandomNationPickerPopup this$0) {
        this$0.returnSelected();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$7(RandomNationPickerPopup this$0) {
        this$0.switchAllNations();
        return Unit.INSTANCE;
    }

    private static final Unit update$lambda$9$lambda$8(RandomNationPickerPopup this$0, Nation $nation) {
        this$0.addNationToPool($nation);
        return Unit.INSTANCE;
    }

    private static final Function0 update$lambda$9(RandomNationPickerPopup this$0, Nation nation) {
        Intrinsics.checkNotNullParameter(nation, "nation");
        return () -> RandomNationPickerPopup.update$lambda$9$lambda$8(this$0, nation);
    }

    private static final Unit update$lambda$11$lambda$10(RandomNationPickerPopup this$0, Nation $nation) {
        this$0.removeNationFromPool($nation);
        return Unit.INSTANCE;
    }

    private static final Function0 update$lambda$11(RandomNationPickerPopup this$0, Nation nation) {
        Intrinsics.checkNotNullParameter(nation, "nation");
        return () -> RandomNationPickerPopup.update$lambda$11$lambda$10(this$0, nation);
    }

    static {
        Color color;
        Companion = new Companion(null);
        Color $this$buttonsBackColor_u24lambda_u2412 = color = ImageGetter.INSTANCE.getCHARCOAL().cpy();
        boolean bl = false;
        $this$buttonsBackColor_u24lambda_u2412.a = 0.67f;
        Color color2 = color;
        Intrinsics.checkNotNullExpressionValue(color2, "apply(...)");
        buttonsBackColor = color2;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/unciv/ui/screens/newgamescreen/RandomNationPickerPopup$Companion;", "", "<init>", "()V", "buttonsCircleSize", "", "buttonsIconSize", "buttonsOffsetFromEdge", "buttonsBackColor", "Lcom/badlogic/gdx/graphics/Color;", "getButtonsBackColor", "()Lcom/badlogic/gdx/graphics/Color;", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Color getButtonsBackColor() {
            return buttonsBackColor;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

