/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.multiplayerscreens;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.CheckBox;
import com.unciv.UncivGame;
import com.unciv.logic.GameInfoPreview;
import com.unciv.logic.civilization.CivilizationInfoPreview;
import com.unciv.logic.multiplayer.FriendList;
import com.unciv.logic.multiplayer.Multiplayer;
import com.unciv.logic.multiplayer.MultiplayerGamePreview;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.components.extensions.FormattingExtensionsKt;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.popups.Popup;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.savescreens.LoadGameScreen;
import com.unciv.ui.screens.savescreens.LoadOrSaveScreen;
import com.unciv.utils.Concurrency;
import com.unciv.utils.ConcurrencyKt;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\tJ\u000e\u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\u000e"}, d2={"Lcom/unciv/ui/screens/multiplayerscreens/MultiplayerHelpers;", "", "<init>", "()V", "loadMultiplayerGame", "", "screen", "Lcom/unciv/ui/screens/basescreen/BaseScreen;", "selectedGame", "Lcom/unciv/logic/multiplayer/MultiplayerGamePreview;", "buildDescriptionText", "", "multiplayerGamePreview", "showDropboxWarning", "core"})
@SourceDebugExtension(value={"SMAP\nMultiplayerHelpers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MultiplayerHelpers.kt\ncom/unciv/ui/screens/multiplayerscreens/MultiplayerHelpers\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,96:1\n295#2,2:97\n295#2,2:99\n*S KotlinDebug\n*F\n+ 1 MultiplayerHelpers.kt\ncom/unciv/ui/screens/multiplayerscreens/MultiplayerHelpers\n*L\n56#1:97,2\n64#1:99,2\n*E\n"})
public final class MultiplayerHelpers {
    @NotNull
    public static final MultiplayerHelpers INSTANCE = new MultiplayerHelpers();

    private MultiplayerHelpers() {
    }

    public final void loadMultiplayerGame(@NotNull BaseScreen screen, @NotNull MultiplayerGamePreview selectedGame) {
        Intrinsics.checkNotNullParameter(screen, "screen");
        Intrinsics.checkNotNullParameter(selectedGame, "selectedGame");
        Popup loadingGamePopup = new Popup(screen, null, 0.0f, 6, null);
        Popup.addGoodSizedLabel$default(loadingGamePopup, "Loading latest game state...", 0, false, null, 14, null);
        Popup.open$default(loadingGamePopup, false, 1, null);
        Concurrency.run$default(Concurrency.INSTANCE, "JoinMultiplayerGame", null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(selectedGame, loadingGamePopup, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ MultiplayerGamePreview $selectedGame;
            final /* synthetic */ Popup $loadingGamePopup;
            {
                this.$selectedGame = $selectedGame;
                this.$loadingGamePopup = $loadingGamePopup;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                CoroutineScope coroutineScope = (CoroutineScope)this.L$0;
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$run;
                        ResultKt.throwOnFailure($result);
                        this.L$0 = $this$run;
                        this.label = 1;
                        Object object2 = UncivGame.Companion.getCurrent().getOnlineMultiplayer().downloadGame(this.$selectedGame, this);
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        Object object2;
                        void $this$run;
                        try {
                            ResultKt.throwOnFailure($result);
                            object2 = $result;
                            return Unit.INSTANCE;
                        }
                        catch (Exception ex) {
                            String message = (String)LoadOrSaveScreen.Helpers.getLoadExceptionMessage$default(LoadGameScreen.Companion, ex, null, null, 6, null).component1();
                            ConcurrencyKt.launchOnGLThread$default((CoroutineScope)$this$run, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$loadingGamePopup, message, null){
                                int label;
                                final /* synthetic */ Popup $loadingGamePopup;
                                final /* synthetic */ String $message;
                                {
                                    this.$loadingGamePopup = $loadingGamePopup;
                                    this.$message = $message;
                                    super(2, $completion);
                                }

                                public final Object invokeSuspend(Object $result) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure($result);
                                            this.$loadingGamePopup.reuseWith(this.$message, true);
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }, 1, null);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)((Object)function2);
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String buildDescriptionText(@NotNull MultiplayerGamePreview multiplayerGamePreview) {
        GameInfoPreview preview;
        CharSequence message;
        Intrinsics.checkNotNullParameter(multiplayerGamePreview, "multiplayerGamePreview");
        StringBuilder descriptionText = new StringBuilder();
        Throwable ex = multiplayerGamePreview.getError();
        if (ex != null) {
            message = (String)LoadOrSaveScreen.Helpers.getLoadExceptionMessage$default(LoadGameScreen.Companion, ex, "Error while refreshing:", null, 4, null).component1();
            descriptionText.append((String)message).append('\n');
        }
        Instant lastUpdate = multiplayerGamePreview.getLastUpdate();
        message = descriptionText;
        StringBuilder stringBuilder = new StringBuilder().append("Last refresh: [");
        Duration duration = Duration.between(lastUpdate, Instant.now());
        Intrinsics.checkNotNullExpressionValue(duration, "between(...)");
        ((StringBuilder)message).append(TranslationsKt.tr$default(stringBuilder.append(FormattingExtensionsKt.formatShort(duration)).append("] ago").toString(), false, false, 3, null)).append('\n');
        GameInfoPreview gameInfoPreview = preview = multiplayerGamePreview.getPreview();
        if ((gameInfoPreview != null ? gameInfoPreview.getCurrentPlayer() : null) != null) {
            Object v7;
            Object object;
            block9: {
                void $this$firstOrNull$iv;
                StringBuilder $this$firstOrNull$iv2;
                Object object2;
                Instant currentTurnStartTime = Instant.ofEpochMilli(preview.getCurrentTurnStartTime());
                CivilizationInfoPreview currentPlayer = preview.getCurrentPlayerCiv();
                if (Intrinsics.areEqual(currentPlayer.getPlayerId(), UncivGame.Companion.getCurrent().getSettings().getMultiplayer().getUserId())) {
                    object2 = "You";
                } else {
                    FriendList.Friend friend;
                    Object v4;
                    block8: {
                        Iterable iterable = UncivGame.Companion.getCurrent().getSettings().getMultiplayer().getFriendList();
                        boolean $i$f$firstOrNull = false;
                        object = $this$firstOrNull$iv2.iterator();
                        while (object.hasNext()) {
                            Object element$iv = object.next();
                            FriendList.Friend it = (FriendList.Friend)element$iv;
                            boolean bl = false;
                            if (!Intrinsics.areEqual(it.getPlayerID(), currentPlayer.getPlayerId())) continue;
                            v4 = element$iv;
                            break block8;
                        }
                        v4 = null;
                    }
                    if ((object2 = (friend = (FriendList.Friend)v4)) == null || (object2 = ((FriendList.Friend)object2).getName()) == null) {
                        object2 = "Unknown";
                    }
                }
                String playerDescriptor = object2;
                String playerText = '{' + preview.getCurrentPlayer() + "}{ }({" + playerDescriptor + "})";
                $this$firstOrNull$iv2 = descriptionText;
                StringBuilder stringBuilder2 = new StringBuilder().append("Current Turn: [").append(playerText).append("] since [");
                Duration duration2 = Duration.between(currentTurnStartTime, Instant.now());
                Intrinsics.checkNotNullExpressionValue(duration2, "between(...)");
                $this$firstOrNull$iv2.append(TranslationsKt.tr$default(stringBuilder2.append(FormattingExtensionsKt.formatShort(duration2)).append("] ago").toString(), false, false, 3, null)).append('\n');
                object = preview.getCivilizations();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    CivilizationInfoPreview it = (CivilizationInfoPreview)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual(it.getPlayerId(), UncivGame.Companion.getCurrent().getSettings().getMultiplayer().getUserId())) continue;
                    v7 = element$iv;
                    break block9;
                }
                v7 = null;
            }
            CivilizationInfoPreview civilizationInfoPreview = v7;
            String playerCivName = civilizationInfoPreview != null && (object = civilizationInfoPreview.getCivName()) != null ? object : "Unknown";
            descriptionText.append('{' + playerCivName + "}, " + TranslationsKt.tr$default(preview.getDifficulty(), false, false, 3, null) + ", \u23f3" + preview.getTurns()).append('\n');
            descriptionText.append("{Base ruleset:} " + preview.getGameParameters().getBaseRuleset()).append('\n');
            if (!((Collection)preview.getGameParameters().getMods()).isEmpty()) {
                descriptionText.append("{Mods:} " + CollectionsKt.joinToString$default(preview.getGameParameters().getMods(), null, null, null, 0, null, null, 63, null)).append('\n');
            }
        }
        String string = descriptionText.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return TranslationsKt.tr$default(string, false, false, 3, null);
    }

    public final void showDropboxWarning(@NotNull BaseScreen screen) {
        Intrinsics.checkNotNullParameter(screen, "screen");
        if (!Multiplayer.Companion.usesDropbox() || UncivGame.Companion.getCurrent().getSettings().getMultiplayer().getHideDropboxWarning()) {
            return;
        }
        Popup dropboxWarning = new Popup(screen, null, 0.0f, 6, null);
        Popup.addGoodSizedLabel$default(dropboxWarning, "You're currently using the default multiplayer server, which is based on a free Dropbox account. Because a lot of people use this, it is uncertain if you'll actually be able to access it consistently. Consider using a custom server instead.", 0, false, null, 14, null).colspan(2).row();
        Popup.addButton$default(dropboxWarning, "Open Documentation", null, null, MultiplayerHelpers::showDropboxWarning$lambda$2, 6, null).colspan(2).row();
        CheckBox checkBox = Scene2dExtensionsKt.toCheckBox$default("Don't show again", false, null, 3, null);
        dropboxWarning.add((Actor)checkBox);
        Popup.addCloseButton$default(dropboxWarning, null, null, null, () -> MultiplayerHelpers.showDropboxWarning$lambda$3(checkBox), 7, null);
        Popup.open$default(dropboxWarning, false, 1, null);
    }

    private static final Unit showDropboxWarning$lambda$2() {
        Gdx.net.openURI("https://yairm210.github.io/Unciv/Other/Multiplayer/#hosting-a-multiplayer-server");
        return Unit.INSTANCE;
    }

    private static final Unit showDropboxWarning$lambda$3(CheckBox $checkBox) {
        UncivGame.Companion.getCurrent().getSettings().getMultiplayer().setHideDropboxWarning($checkBox.isChecked());
        return Unit.INSTANCE;
    }
}

