/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.mapeditorscreen.tabs;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.unciv.UncivGame;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.tile.Terrain;
import com.unciv.ui.components.NonTransformGroup;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.tilegroups.TileGroup;
import com.unciv.ui.components.tilegroups.TileSetStrings;
import com.unciv.ui.components.widgets.TabbedPager;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.mapeditorscreen.tabs.IMapEditorEditSubTabs;
import com.unciv.ui.screens.mapeditorscreen.tabs.MapEditorEditTab;
import java.util.Collection;
import java.util.Comparator;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003:\u0001!B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\f\u0010\u0018\u001a\u00020\u0019*\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\b\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010 \u001a\u00020\u001f2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/unciv/ui/screens/mapeditorscreen/tabs/MapEditorEditRiversTab;", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "Lcom/unciv/ui/screens/mapeditorscreen/tabs/IMapEditorEditSubTabs;", "Lcom/unciv/ui/components/widgets/TabbedPager$IPageExtensions;", "editTab", "Lcom/unciv/ui/screens/mapeditorscreen/tabs/MapEditorEditTab;", "ruleset", "Lcom/unciv/models/ruleset/Ruleset;", "<init>", "(Lcom/unciv/ui/screens/mapeditorscreen/tabs/MapEditorEditTab;Lcom/unciv/models/ruleset/Ruleset;)V", "iconSize", "", "showOnTerrain", "Lcom/unciv/models/ruleset/tile/Terrain;", "isDisabled", "", "activated", "", "index", "", "caption", "", "pager", "Lcom/unciv/ui/components/widgets/TabbedPager;", "makeTileGroup", "Lcom/unciv/ui/components/tilegroups/TileGroup;", "Lcom/unciv/logic/map/tile/Tile;", "getTileGroupWithRivers", "edge", "Lcom/unciv/ui/screens/mapeditorscreen/tabs/MapEditorEditRiversTab$RiverEdge;", "getRemoveRiverIcon", "Lcom/unciv/ui/components/NonTransformGroup;", "getRiverIcon", "RiverEdge", "core"})
@SourceDebugExtension(value={"SMAP\nMapEditorEditSubTabs.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MapEditorEditSubTabs.kt\ncom/unciv/ui/screens/mapeditorscreen/tabs/MapEditorEditRiversTab\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,494:1\n622#2:495\n*S KotlinDebug\n*F\n+ 1 MapEditorEditSubTabs.kt\ncom/unciv/ui/screens/mapeditorscreen/tabs/MapEditorEditRiversTab\n*L\n352#1:495\n*E\n"})
public final class MapEditorEditRiversTab
extends Table
implements IMapEditorEditSubTabs,
TabbedPager.IPageExtensions {
    @NotNull
    private final MapEditorEditTab editTab;
    @NotNull
    private final Ruleset ruleset;
    private final float iconSize;
    @NotNull
    private final Terrain showOnTerrain;

    /*
     * WARNING - void declaration
     */
    public MapEditorEditRiversTab(@NotNull MapEditorEditTab editTab, @NotNull Ruleset ruleset) {
        Table table2;
        void $this$sortedByDescending$iv;
        Intrinsics.checkNotNullParameter(editTab, "editTab");
        Intrinsics.checkNotNullParameter(ruleset, "ruleset");
        super(BaseScreen.Companion.getSkin());
        this.editTab = editTab;
        this.ruleset = ruleset;
        this.iconSize = 50.0f;
        Collection<Terrain> collection = this.ruleset.getTerrains().values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Sequence<Terrain> sequence = SequencesKt.filter(CollectionsKt.asSequence((Iterable)collection), MapEditorEditRiversTab::showOnTerrain$lambda$0);
        boolean $i$f$sortedByDescending = false;
        Terrain terrain = (Terrain)SequencesKt.firstOrNull(SequencesKt.sortedWith($this$sortedByDescending$iv, new Comparator(){

            public final int compare(T a, T b) {
                Terrain it = (Terrain)b;
                boolean bl = false;
                Comparable comparable = Float.valueOf(it.getProduction() * (float)2 + it.getFood());
                it = (Terrain)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, (Comparable)Float.valueOf(it.getProduction() * (float)2 + it.getFood()));
            }
        }));
        if (terrain == null && (terrain = this.ruleset.getTerrains().get("Plains")) == null) {
            Collection<Terrain> collection2 = this.ruleset.getTerrains().values();
            Intrinsics.checkNotNullExpressionValue(collection2, "<get-values>(...)");
            Object t = CollectionsKt.first((Iterable)collection2);
            Intrinsics.checkNotNullExpressionValue(t, "first(...)");
            terrain = (Terrain)t;
        }
        this.showOnTerrain = terrain;
        String pediaLink = "Terrain/River";
        this.top();
        this.defaults().pad(10.0f).left();
        Table $this$_init__u24lambda_u244 = $i$f$sortedByDescending = new Table();
        boolean bl = false;
        $this$_init__u24lambda_u244.add((Actor)this.getRemoveRiverIcon()).padRight(10.0f);
        $this$_init__u24lambda_u244.add((Actor)Scene2dExtensionsKt.toLabel$default("Remove rivers", null, 32, 0, false, 13, null));
        ActivationExtensionsKt.onClick($this$_init__u24lambda_u244, () -> MapEditorEditRiversTab.lambda$4$lambda$3(this, pediaLink));
        Table removeLine = $i$f$sortedByDescending;
        this.add((Actor)removeLine).row();
        Table $this$_init__u24lambda_u247 = $this$_init__u24lambda_u244 = new Table();
        boolean bl2 = false;
        $this$_init__u24lambda_u247.add((Actor)this.getRiverIcon(RiverEdge.Left)).padRight(10.0f);
        $this$_init__u24lambda_u247.add((Actor)Scene2dExtensionsKt.toLabel$default("Bottom left river", null, 32, 0, false, 13, null));
        ActivationExtensionsKt.onClick($this$_init__u24lambda_u247, () -> MapEditorEditRiversTab.lambda$7$lambda$6(this, pediaLink));
        Table leftRiverLine = $this$_init__u24lambda_u244;
        this.add((Actor)leftRiverLine).row();
        Table $this$_init__u24lambda_u2410 = $this$_init__u24lambda_u247 = new Table();
        boolean bl3 = false;
        $this$_init__u24lambda_u2410.add((Actor)this.getRiverIcon(RiverEdge.Bottom)).padRight(10.0f);
        $this$_init__u24lambda_u2410.add((Actor)Scene2dExtensionsKt.toLabel$default("Bottom river", null, 32, 0, false, 13, null));
        ActivationExtensionsKt.onClick($this$_init__u24lambda_u2410, () -> MapEditorEditRiversTab.lambda$10$lambda$9(this, pediaLink));
        Table bottomRiverLine = $this$_init__u24lambda_u247;
        this.add((Actor)bottomRiverLine).row();
        Table $this$_init__u24lambda_u2413 = $this$_init__u24lambda_u2410 = new Table();
        boolean bl4 = false;
        $this$_init__u24lambda_u2413.add((Actor)this.getRiverIcon(RiverEdge.Right)).padRight(10.0f);
        $this$_init__u24lambda_u2413.add((Actor)Scene2dExtensionsKt.toLabel$default("Bottom right river", null, 32, 0, false, 13, null));
        ActivationExtensionsKt.onClick($this$_init__u24lambda_u2413, () -> MapEditorEditRiversTab.lambda$13$lambda$12(this, pediaLink));
        Table rightRiverLine = $this$_init__u24lambda_u2410;
        this.add((Actor)rightRiverLine).row();
        Table $this$_init__u24lambda_u2416 = table2 = new Table();
        boolean bl5 = false;
        $this$_init__u24lambda_u2416.add((Actor)this.getRiverIcon(RiverEdge.All)).padRight(10.0f);
        $this$_init__u24lambda_u2416.add((Actor)Scene2dExtensionsKt.toLabel$default("Spawn river from/to", null, 32, 0, false, 13, null));
        ActivationExtensionsKt.onClick($this$_init__u24lambda_u2416, () -> MapEditorEditRiversTab.lambda$16$lambda$15(this, pediaLink));
        Table spawnRiverLine = table2;
        this.add((Actor)spawnRiverLine).row();
    }

    @Override
    public boolean isDisabled() {
        return false;
    }

    @Override
    public void activated(int index, @NotNull String caption, @NotNull TabbedPager pager) {
        Intrinsics.checkNotNullParameter(caption, "caption");
        Intrinsics.checkNotNullParameter(pager, "pager");
        this.editTab.setBrushSize$core(1);
    }

    private final TileGroup makeTileGroup(Tile $this$makeTileGroup) {
        TileGroup tileGroup;
        $this$makeTileGroup.setRuleset(this.ruleset);
        $this$makeTileGroup.setTerrainTransients();
        TileGroup $this$makeTileGroup_u24lambda_u2417 = tileGroup = new TileGroup($this$makeTileGroup, new TileSetStrings($this$makeTileGroup.getRuleset(), UncivGame.Companion.getCurrent().getSettings()), this.iconSize * 36.0f / 54.0f);
        boolean bl = false;
        $this$makeTileGroup_u24lambda_u2417.setForceVisible(true);
        $this$makeTileGroup_u24lambda_u2417.setForMapEditorIcon(true);
        TileGroup.update$default($this$makeTileGroup_u24lambda_u2417, null, null, 3, null);
        return tileGroup;
    }

    /*
     * WARNING - void declaration
     */
    private final TileGroup getTileGroupWithRivers(RiverEdge edge) {
        void $this$getTileGroupWithRivers_u24lambda_u2418;
        Tile tile;
        Tile tile2 = tile = new Tile();
        MapEditorEditRiversTab mapEditorEditRiversTab = this;
        boolean bl = false;
        $this$getTileGroupWithRivers_u24lambda_u2418.setBaseTerrain(this.showOnTerrain.getName());
        switch (WhenMappings.$EnumSwitchMapping$0[edge.ordinal()]) {
            case 1: {
                $this$getTileGroupWithRivers_u24lambda_u2418.setHasBottomLeftRiver(true);
                break;
            }
            case 2: {
                $this$getTileGroupWithRivers_u24lambda_u2418.setHasBottomRiver(true);
                break;
            }
            case 3: {
                $this$getTileGroupWithRivers_u24lambda_u2418.setHasBottomRightRiver(true);
                break;
            }
            case 4: {
                $this$getTileGroupWithRivers_u24lambda_u2418.setHasBottomLeftRiver(true);
                $this$getTileGroupWithRivers_u24lambda_u2418.setHasBottomRightRiver(true);
                $this$getTileGroupWithRivers_u24lambda_u2418.setHasBottomRiver(true);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return mapEditorEditRiversTab.makeTileGroup(tile);
    }

    private final NonTransformGroup getRemoveRiverIcon() {
        return ImageGetter.INSTANCE.getCrossedImage(this.getTileGroupWithRivers(RiverEdge.All), this.iconSize);
    }

    private final NonTransformGroup getRiverIcon(RiverEdge edge) {
        NonTransformGroup nonTransformGroup;
        NonTransformGroup $this$getRiverIcon_u24lambda_u2419 = nonTransformGroup = new NonTransformGroup();
        boolean bl = false;
        $this$getRiverIcon_u24lambda_u2419.setSize(this.iconSize, this.iconSize);
        TileGroup tileGroup = this.getTileGroupWithRivers(edge);
        Scene2dExtensionsKt.center((Actor)tileGroup, $this$getRiverIcon_u24lambda_u2419);
        $this$getRiverIcon_u24lambda_u2419.addActor(tileGroup);
        return nonTransformGroup;
    }

    @Override
    public void deactivated(int index, @NotNull String caption, @NotNull TabbedPager pager) {
        TabbedPager.IPageExtensions.super.deactivated(index, caption, pager);
    }

    @Override
    @Nullable
    public Actor getFixedContent() {
        return TabbedPager.IPageExtensions.super.getFixedContent();
    }

    private static final boolean showOnTerrain$lambda$0(Terrain it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getType().isBaseTerrain() && !it.isRough();
    }

    private static final Unit lambda$4$lambda$3$lambda$2(Tile tile) {
        block2: {
            Intrinsics.checkNotNullParameter(tile, "tile");
            tile.setHasBottomLeftRiver(false);
            tile.setHasBottomRightRiver(false);
            tile.setHasBottomRiver(false);
            int x = (int)tile.getPosition().x;
            int y = (int)tile.getPosition().y;
            Tile tile2 = tile.getTileMap().getIfTileExistsOrNull(x, y + 1);
            if (tile2 != null) {
                tile2.setHasBottomLeftRiver(false);
            }
            Tile tile3 = tile.getTileMap().getIfTileExistsOrNull(x + 1, y);
            if (tile3 != null) {
                tile3.setHasBottomRightRiver(false);
            }
            Tile tile4 = tile.getTileMap().getIfTileExistsOrNull(x + 1, y + 1);
            if (tile4 == null) break block2;
            tile4.setHasBottomRiver(false);
        }
        return Unit.INSTANCE;
    }

    private static final Unit lambda$4$lambda$3(MapEditorEditRiversTab this$0, String $pediaLink) {
        this$0.editTab.setBrush(MapEditorEditTab.BrushHandlerType.River, "Remove rivers", this$0.getRemoveRiverIcon(), $pediaLink, MapEditorEditRiversTab::lambda$4$lambda$3$lambda$2);
        return Unit.INSTANCE;
    }

    private static final Unit lambda$7$lambda$6$lambda$5(Tile tile) {
        Intrinsics.checkNotNullParameter(tile, "tile");
        tile.setHasBottomLeftRiver(!tile.getHasBottomLeftRiver());
        return Unit.INSTANCE;
    }

    private static final Unit lambda$7$lambda$6(MapEditorEditRiversTab this$0, String $pediaLink) {
        this$0.editTab.setBrush(MapEditorEditTab.BrushHandlerType.Direct, "Bottom left river", this$0.getTileGroupWithRivers(RiverEdge.Left), $pediaLink, MapEditorEditRiversTab::lambda$7$lambda$6$lambda$5);
        return Unit.INSTANCE;
    }

    private static final Unit lambda$10$lambda$9$lambda$8(Tile tile) {
        Intrinsics.checkNotNullParameter(tile, "tile");
        tile.setHasBottomRiver(!tile.getHasBottomRiver());
        return Unit.INSTANCE;
    }

    private static final Unit lambda$10$lambda$9(MapEditorEditRiversTab this$0, String $pediaLink) {
        this$0.editTab.setBrush(MapEditorEditTab.BrushHandlerType.Direct, "Bottom river", this$0.getTileGroupWithRivers(RiverEdge.Bottom), $pediaLink, MapEditorEditRiversTab::lambda$10$lambda$9$lambda$8);
        return Unit.INSTANCE;
    }

    private static final Unit lambda$13$lambda$12$lambda$11(Tile tile) {
        Intrinsics.checkNotNullParameter(tile, "tile");
        tile.setHasBottomRightRiver(!tile.getHasBottomRightRiver());
        return Unit.INSTANCE;
    }

    private static final Unit lambda$13$lambda$12(MapEditorEditRiversTab this$0, String $pediaLink) {
        this$0.editTab.setBrush(MapEditorEditTab.BrushHandlerType.Direct, "Bottom right river", this$0.getTileGroupWithRivers(RiverEdge.Right), $pediaLink, MapEditorEditRiversTab::lambda$13$lambda$12$lambda$11);
        return Unit.INSTANCE;
    }

    private static final Unit lambda$16$lambda$15$lambda$14(Tile it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return Unit.INSTANCE;
    }

    private static final Unit lambda$16$lambda$15(MapEditorEditRiversTab this$0, String $pediaLink) {
        this$0.editTab.setBrush(MapEditorEditTab.BrushHandlerType.RiverFromTo, "Spawn river from/to", this$0.getTileGroupWithRivers(RiverEdge.All), $pediaLink, MapEditorEditRiversTab::lambda$16$lambda$15$lambda$14);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lcom/unciv/ui/screens/mapeditorscreen/tabs/MapEditorEditRiversTab$RiverEdge;", "", "<init>", "(Ljava/lang/String;I)V", "Left", "Bottom", "Right", "All", "core"})
    private static final class RiverEdge
    extends Enum<RiverEdge> {
        public static final /* enum */ RiverEdge Left = new RiverEdge();
        public static final /* enum */ RiverEdge Bottom = new RiverEdge();
        public static final /* enum */ RiverEdge Right = new RiverEdge();
        public static final /* enum */ RiverEdge All = new RiverEdge();
        private static final /* synthetic */ RiverEdge[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static RiverEdge[] values() {
            return (RiverEdge[])$VALUES.clone();
        }

        public static RiverEdge valueOf(String value) {
            return Enum.valueOf(RiverEdge.class, value);
        }

        @NotNull
        public static EnumEntries<RiverEdge> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = riverEdgeArray = new RiverEdge[]{RiverEdge.Left, RiverEdge.Bottom, RiverEdge.Right, RiverEdge.All};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RiverEdge.values().length];
            try {
                nArray[RiverEdge.Left.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RiverEdge.Bottom.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RiverEdge.Right.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RiverEdge.All.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

