/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.devconsole;

import com.unciv.logic.city.City;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.ruleset.RulesetObject;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueTarget;
import com.unciv.models.ruleset.unique.UniqueTriggerActivation;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.ruleset.validation.RulesetErrorList;
import com.unciv.models.ruleset.validation.UniqueValidator;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.screens.devconsole.CliInput;
import com.unciv.ui.screens.devconsole.ConsoleAction;
import com.unciv.ui.screens.devconsole.ConsoleErrorException;
import com.unciv.ui.screens.devconsole.DevConsolePopup;
import com.unciv.ui.screens.devconsole.DevConsoleResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00062\u00020\u0001:\u0001\u0006B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0007"}, d2={"Lcom/unciv/ui/screens/devconsole/ConsoleTriggerAction;", "Lcom/unciv/ui/screens/devconsole/ConsoleAction;", "topLevelCommand", "", "<init>", "(Ljava/lang/String;)V", "Companion", "core"})
public final class ConsoleTriggerAction
extends ConsoleAction {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public ConsoleTriggerAction(@NotNull String topLevelCommand) {
        Intrinsics.checkNotNullParameter(topLevelCommand, "topLevelCommand");
        super(topLevelCommand + " activatetrigger <triggeredUnique|triggeredUniqueTemplate> [uniqueParam]...", ConsoleTriggerAction.Companion.getAction(topLevelCommand));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0016B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0004\u0012\u00020\t0\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0002J(\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u0010H\u0002J\u001e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u00062\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u0010H\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\bH\u0002\u00a8\u0006\u0017"}, d2={"Lcom/unciv/ui/screens/devconsole/ConsoleTriggerAction$Companion;", "", "<init>", "()V", "getAction", "Lkotlin/Function2;", "Lcom/unciv/ui/screens/devconsole/DevConsolePopup;", "", "Lcom/unciv/ui/screens/devconsole/CliInput;", "Lcom/unciv/ui/screens/devconsole/DevConsoleResponse;", "topLevelCommand", "", "getCiv", "Lcom/unciv/logic/civilization/Civilization;", "console", "paramStack", "Lkotlin/collections/ArrayDeque;", "getUnique", "Lcom/unciv/models/ruleset/unique/Unique;", "getUniqueType", "Lcom/unciv/models/ruleset/unique/UniqueType;", "param", "ConsoleRulesetObject", "core"})
    @SourceDebugExtension(value={"SMAP\nConsoleTriggerAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConsoleTriggerAction.kt\ncom/unciv/ui/screens/devconsole/ConsoleTriggerAction$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,102:1\n1563#2:103\n1634#2,3:104\n37#3:107\n36#3,3:108\n*S KotlinDebug\n*F\n+ 1 ConsoleTriggerAction.kt\ncom/unciv/ui/screens/devconsole/ConsoleTriggerAction$Companion\n*L\n69#1:103\n69#1:104,3\n69#1:107\n69#1:108,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final Function2<DevConsolePopup, List<CliInput>, DevConsoleResponse> getAction(String topLevelCommand) {
            return (arg_0, arg_1) -> Companion.getAction$lambda$0(topLevelCommand, arg_0, arg_1);
        }

        private final Civilization getCiv(DevConsolePopup console, String topLevelCommand, ArrayDeque<CliInput> paramStack) {
            if (!Intrinsics.areEqual(topLevelCommand, "civ")) {
                return null;
            }
            CliInput cliInput = paramStack.firstOrNull();
            if (cliInput == null) {
                return null;
            }
            CliInput name = cliInput;
            Civilization civilization = console.getCivByNameOrNull$core(name);
            if (civilization == null) {
                return console.getScreen().getSelectedCiv();
            }
            Civilization civ = civilization;
            paramStack.removeFirst();
            return civ;
        }

        /*
         * WARNING - void declaration
         */
        private final Unique getUnique(DevConsolePopup console, ArrayDeque<CliInput> paramStack) {
            CliInput cliInput = paramStack.removeFirstOrNull();
            if (cliInput == null || (cliInput = cliInput.toMethod(CliInput.Method.Quoted)) == null) {
                throw new ConsoleErrorException("Parameter triggeredUnique missing");
            }
            CliInput uniqueText = cliInput;
            UniqueType uniqueType = this.getUniqueType(uniqueText);
            if (!((Collection)paramStack).isEmpty() && uniqueText.equals(uniqueType.getText())) {
                void $this$toTypedArray$iv;
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = paramStack;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    CliInput cliInput2 = (CliInput)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.originalUnquoted());
                }
                $this$map$iv = (List)destination$iv$iv;
                boolean $i$f$toTypedArray = false;
                void thisCollection$iv = $this$toTypedArray$iv;
                String[] params = thisCollection$iv.toArray(new String[0]);
                uniqueText = new CliInput(TranslationsKt.fillPlaceholders(uniqueType.getPlaceholderText(), Arrays.copyOf(params, params.length)), CliInput.Method.Quoted);
            }
            Unique unique = new Unique(uniqueText.getContent(), UniqueTarget.Triggerable, "DevConsole");
            UniqueValidator validator = new UniqueValidator(console.getGameInfo$core().getRuleset());
            RulesetErrorList errors = validator.checkUnique(unique, false, new ConsoleRulesetObject(), true);
            if (errors.isNotOK()) {
                throw new ConsoleErrorException(errors.getErrorText(true));
            }
            return unique;
        }

        private final UniqueType getUniqueType(CliInput param) {
            CliInput filterText = new CliInput(TranslationsKt.getPlaceholderText(param.getContent()), param.getMethod());
            List<UniqueType> uniqueTypes = SequencesKt.toList(SequencesKt.take(SequencesKt.filter(CollectionsKt.asSequence((Iterable)UniqueType.getEntries()), arg_0 -> Companion.getUniqueType$lambda$2(param, filterText, arg_0)), 4));
            if (uniqueTypes.isEmpty()) {
                throw new ConsoleErrorException("" + '`' + param + "` not found in UniqueTypes");
            }
            if (uniqueTypes.size() > 1) {
                throw new ConsoleErrorException("" + '`' + param + "` has ambiguous UniqueType: " + CollectionsKt.joinToString$default(uniqueTypes, null, null, null, 3, null, Companion::getUniqueType$lambda$3, 23, null) + '?');
            }
            UniqueType uniqueType = CollectionsKt.first(uniqueTypes);
            if (uniqueType.canAcceptUniqueTarget(UniqueTarget.Triggerable)) {
                return uniqueType;
            }
            throw new ConsoleErrorException("" + '`' + param + "` is not a Triggerable");
        }

        private static final DevConsoleResponse getAction$lambda$0(String $topLevelCommand, DevConsolePopup console, List params) {
            Tile ex3;
            MapUnit ex22;
            City city;
            Intrinsics.checkNotNullParameter(console, "console");
            Intrinsics.checkNotNullParameter(params, "params");
            ArrayDeque<CliInput> paramStack = new ArrayDeque<CliInput>(params);
            try {
                city = console.getSelectedCity$core();
            }
            catch (ConsoleErrorException ex22) {
                if (Intrinsics.areEqual($topLevelCommand, "city")) {
                    throw ex22;
                }
                city = null;
            }
            City city2 = city;
            try {
                ex22 = console.getSelectedUnit$core();
            }
            catch (ConsoleErrorException ex3) {
                if (Intrinsics.areEqual($topLevelCommand, "unit")) {
                    throw ex3;
                }
                ex22 = null;
            }
            MapUnit unit = ex22;
            try {
                ex3 = console.getSelectedTile$core();
            }
            catch (ConsoleErrorException ex4) {
                if (Intrinsics.areEqual($topLevelCommand, "tile")) {
                    throw ex4;
                }
                ex3 = null;
            }
            Tile tile = ex3;
            Civilization civilization = Companion.getCiv(console, $topLevelCommand, paramStack);
            if (civilization == null) {
                City city3 = city2;
                civilization = city3 != null ? city3.getCiv() : null;
                if (civilization == null) {
                    MapUnit mapUnit = unit;
                    civilization = mapUnit != null ? mapUnit.getCiv() : null;
                    if (civilization == null) {
                        Tile tile2 = tile;
                        civilization = tile2 != null ? tile2.getOwner() : null;
                        if (civilization == null) {
                            throw new ConsoleErrorException("A trigger command needs a Civilization from some source");
                        }
                    }
                }
            }
            Civilization civ = civilization;
            Unique unique = Companion.getUnique(console, paramStack);
            return UniqueTriggerActivation.INSTANCE.triggerUnique(unique, civ, city2, unit, tile, null, "due to cheating") ? DevConsoleResponse.Companion.getOK() : DevConsoleResponse.Companion.error("The `triggerUnique` call failed");
        }

        private static final boolean getUniqueType$lambda$2(CliInput $param, CliInput $filterText, UniqueType it) {
            Intrinsics.checkNotNullParameter((Object)it, "it");
            return Intrinsics.areEqual(new CliInput(it.getPlaceholderText(), $param.getMethod()), $filterText);
        }

        private static final CharSequence getUniqueType$lambda$3(UniqueType it) {
            Intrinsics.checkNotNullParameter((Object)it, "it");
            return it.getText();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u0005H\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\r"}, d2={"Lcom/unciv/ui/screens/devconsole/ConsoleTriggerAction$Companion$ConsoleRulesetObject;", "Lcom/unciv/models/ruleset/RulesetObject;", "<init>", "()V", "name", "", "getName", "()Ljava/lang/String;", "setName", "(Ljava/lang/String;)V", "getUniqueTarget", "Lcom/unciv/models/ruleset/unique/UniqueTarget;", "makeLink", "core"})
        private static final class ConsoleRulesetObject
        extends RulesetObject {
            @NotNull
            private String name = "DevConsole";

            @Override
            @NotNull
            public String getName() {
                return this.name;
            }

            @Override
            public void setName(@NotNull String string) {
                Intrinsics.checkNotNullParameter(string, "<set-?>");
                this.name = string;
            }

            @Override
            @NotNull
            public UniqueTarget getUniqueTarget() {
                return UniqueTarget.Triggerable;
            }

            @Override
            @NotNull
            public String makeLink() {
                return "";
            }
        }
    }
}

