/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.cityscreen;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.unciv.logic.city.CityStats;
import com.unciv.logic.city.StatTreeNode;
import com.unciv.models.skins.SkinStrings;
import com.unciv.models.stats.Stat;
import com.unciv.models.stats.Stats;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.input.KeyCharAndCode;
import com.unciv.ui.components.input.KeyboardBinding;
import com.unciv.ui.components.widgets.AutoScrollPane;
import com.unciv.ui.images.IconCircleGroup;
import com.unciv.ui.popups.Popup;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.cityscreen.CityScreen;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000eH\u0002JD\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u00072\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\f0\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\b\b\u0002\u0010 \u001a\u00020\u000e2\b\b\u0002\u0010!\u001a\u00020\u000e2\b\b\u0002\u0010\"\u001a\u00020#H\u0002J(\u0010$\u001a\u00020\u00072\b\u0010%\u001a\u0004\u0018\u00010&2\n\b\u0002\u0010'\u001a\u0004\u0018\u00010\u00102\b\b\u0002\u0010(\u001a\u00020#H\u0002J\f\u0010)\u001a\u00020&*\u00020*H\u0002J\f\u0010+\u001a\u00020&*\u00020*H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/unciv/ui/screens/cityscreen/DetailedStatsPopup;", "Lcom/unciv/ui/popups/Popup;", "cityScreen", "Lcom/unciv/ui/screens/cityscreen/CityScreen;", "<init>", "(Lcom/unciv/ui/screens/cityscreen/CityScreen;)V", "headerTable", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "totalTable", "sourceHighlighted", "", "onlyWithStat", "Lcom/unciv/models/stats/Stat;", "isDetailed", "", "colorTotal", "Lcom/badlogic/gdx/graphics/Color;", "colorSelector", "percentFormatter", "Ljava/text/DecimalFormat;", "decimalFormatter", "update", "", "getToggleButton", "Lcom/unciv/ui/images/IconCircleGroup;", "showDetails", "traverseTree", "table", "stats", "", "statTreeNode", "Lcom/unciv/logic/city/StatTreeNode;", "mergeHappiness", "percentage", "indentation", "", "wrapInTable", "label", "Lcom/badlogic/gdx/scenes/scene2d/ui/Label;", "color", "align", "toPercentLabel", "", "toOneDecimalLabel", "core"})
@SourceDebugExtension(value={"SMAP\nDetailedStatsPopup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DetailedStatsPopup.kt\ncom/unciv/ui/screens/cityscreen/DetailedStatsPopup\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,292:1\n1#2:293\n774#3:294\n865#3,2:295\n1740#3,3:297\n*S KotlinDebug\n*F\n+ 1 DetailedStatsPopup.kt\ncom/unciv/ui/screens/cityscreen/DetailedStatsPopup\n*L\n75#1:294\n75#1:295,2\n218#1:297,3\n*E\n"})
public final class DetailedStatsPopup
extends Popup {
    @NotNull
    private final CityScreen cityScreen;
    @NotNull
    private final Table headerTable;
    @NotNull
    private final Table totalTable;
    @Nullable
    private String sourceHighlighted;
    @Nullable
    private Stat onlyWithStat;
    private boolean isDetailed;
    @NotNull
    private final Color colorTotal;
    @NotNull
    private final Color colorSelector;
    @NotNull
    private final DecimalFormat percentFormatter;
    @NotNull
    private final DecimalFormat decimalFormatter;

    /*
     * WARNING - void declaration
     */
    public DetailedStatsPopup(@NotNull CityScreen cityScreen) {
        void $this$percentFormatter_u24lambda_u240;
        DecimalFormat decimalFormat;
        Intrinsics.checkNotNullParameter(cityScreen, "cityScreen");
        super(cityScreen, Popup.Scrollability.None, 0.0f, 4, null);
        this.cityScreen = cityScreen;
        this.headerTable = new Table();
        this.totalTable = new Table();
        Color color = Color.BLUE;
        Intrinsics.checkNotNullExpressionValue(color, "BLUE");
        this.colorTotal = Scene2dExtensionsKt.brighten(color, 0.5f);
        Color color2 = Color.GREEN;
        Intrinsics.checkNotNullExpressionValue(color2, "GREEN");
        this.colorSelector = Scene2dExtensionsKt.darken(color2, 0.5f);
        DecimalFormat decimalFormat2 = decimalFormat = new DecimalFormat("0.#%");
        DetailedStatsPopup detailedStatsPopup = this;
        boolean bl = false;
        $this$percentFormatter_u24lambda_u240.setPositivePrefix("+");
        $this$percentFormatter_u24lambda_u240.setMultiplier(1);
        detailedStatsPopup.percentFormatter = decimalFormat;
        this.decimalFormatter = new DecimalFormat("0.#");
        Cell cell = this.headerTable.defaults();
        Intrinsics.checkNotNullExpressionValue(cell, "defaults(...)");
        Scene2dExtensionsKt.pad(cell, 3.0f, 0.0f);
        this.add((Actor)this.headerTable).padBottom(0.0f).row();
        Cell cell2 = this.totalTable.defaults();
        Intrinsics.checkNotNullExpressionValue(cell2, "defaults(...)");
        Scene2dExtensionsKt.pad(cell2, 3.0f, 0.0f);
        AutoScrollPane scrollPane = new AutoScrollPane((Actor)this.totalTable, null, 2, null);
        scrollPane.setOverscroll(false, false);
        Cell<Actor> scrollPaneCell = this.add((Actor)scrollPane).padTop(0.0f);
        scrollPaneCell.maxHeight(this.cityScreen.getStage().getHeight() * (float)3 / (float)4);
        this.row();
        Popup.addCloseButton$default(this, null, KeyCharAndCode.Companion.getSPACE(), null, null, 13, null);
        this.update();
        this.getShowListeners().add(() -> DetailedStatsPopup._init_$lambda$1(this));
        this.getCloseListeners().add(() -> DetailedStatsPopup._init_$lambda$2(this));
    }

    /*
     * WARNING - void declaration
     */
    private final void update() {
        void $this$update_u24lambda_u247;
        Object $this$update_u24lambda_u246;
        Object $this$update_u24lambda_u245;
        Object stat;
        Object $this$filterTo$iv$iv;
        List list2;
        this.headerTable.clear();
        this.totalTable.clear();
        CityStats cityStats = this.cityScreen.getCity$core().getCityStats();
        boolean showFaith = this.cityScreen.getCity$core().getCiv().getGameInfo().isReligionEnabled();
        if (this.onlyWithStat != null) {
            list2 = CollectionsKt.listOfNotNull(this.onlyWithStat);
        } else if (!showFaith) {
            Iterable $this$filter$iv = Stat.getEntries();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            Map.Entry entry = $this$filterTo$iv$iv.iterator();
            while (entry.hasNext()) {
                Object element$iv$iv = entry.next();
                Stat it = (Stat)element$iv$iv;
                boolean bl = false;
                if (!(it != Stat.Faith)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list2 = (List)destination$iv$iv;
        } else {
            list2 = Stat.getEntries();
        }
        List stats = list2;
        int columnCount = stats.size() + 1;
        float statColMinWidth = this.onlyWithStat != null ? 150.0f : 110.0f;
        this.headerTable.add((Actor)this.getToggleButton(this.isDetailed)).minWidth(150.0f).grow();
        $this$filterTo$iv$iv = stats.iterator();
        while ($this$filterTo$iv$iv.hasNext()) {
            stat = (Stat)$this$filterTo$iv$iv.next();
            Label label = Scene2dExtensionsKt.toLabel(((Enum)stat).name());
            ActivationExtensionsKt.onClick(label, () -> DetailedStatsPopup.update$lambda$4(this, (Stat)stat));
            this.headerTable.add((Actor)DetailedStatsPopup.wrapInTable$default(this, label, this.onlyWithStat == stat ? this.colorSelector : null, 0, 4, null)).minWidth(statColMinWidth).grow();
        }
        this.headerTable.row();
        Scene2dExtensionsKt.addSeparator$default(this.headerTable, null, 0, 0.0f, 7, null).padBottom(2.0f);
        stat = $this$filterTo$iv$iv = Scene2dExtensionsKt.toLabel("Base values");
        Table table2 = this.totalTable;
        boolean bl = false;
        ((Label)$this$update_u24lambda_u245).setAlignment(1);
        table2.add((Actor)$this$filterTo$iv$iv).colspan(columnCount).growX().row();
        Scene2dExtensionsKt.addSeparator$default(this.totalTable, null, columnCount, 0.0f, 5, null).padTop(2.0f);
        DetailedStatsPopup.traverseTree$default(this, this.totalTable, stats, cityStats.getBaseStatTree(), true, false, 0, 32, null);
        Scene2dExtensionsKt.addSeparator$default(this.totalTable, null, 0, 0.0f, 7, null).padBottom(2.0f);
        $this$update_u24lambda_u245 = $this$filterTo$iv$iv = Scene2dExtensionsKt.toLabel("Bonuses");
        table2 = this.totalTable;
        boolean bl2 = false;
        ((Label)$this$update_u24lambda_u246).setAlignment(1);
        table2.add((Actor)$this$filterTo$iv$iv).colspan(columnCount).growX().row();
        Scene2dExtensionsKt.addSeparator$default(this.totalTable, null, 0, 0.0f, 7, null).padTop(2.0f);
        DetailedStatsPopup.traverseTree$default(this, this.totalTable, stats, cityStats.getStatPercentBonusTree(), false, true, 0, 40, null);
        Scene2dExtensionsKt.addSeparator$default(this.totalTable, null, 0, 0.0f, 7, null).padBottom(2.0f);
        $this$update_u24lambda_u246 = $this$filterTo$iv$iv = Scene2dExtensionsKt.toLabel("Final");
        table2 = this.totalTable;
        boolean bl3 = false;
        $this$update_u24lambda_u247.setAlignment(1);
        table2.add((Actor)$this$filterTo$iv$iv).colspan(columnCount).growX().row();
        Scene2dExtensionsKt.addSeparator$default(this.totalTable, null, 0, 0.0f, 7, null).padTop(2.0f);
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        SortedMap map2 = MapsKt.toSortedMap((Map)cityStats.getFinalStatList());
        for (Map.Entry entry : ((Map)this.cityScreen.getCity$core().getCityStats().getHappinessList()).entrySet()) {
            String key = (String)entry.getKey();
            float value = ((Number)entry.getValue()).floatValue();
            if (!map2.containsKey(key)) {
                ((Map)map2).put(key, new Stats(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, value, 0.0f, 95, null));
                continue;
            }
            Object v = map2.get(key);
            Intrinsics.checkNotNull(v);
            if (!(((Stats)v).get(Stat.Happiness) == 0.0f)) continue;
            Object v2 = map2.get(key);
            Intrinsics.checkNotNull(v2);
            ((Stats)v2).set(Stat.Happiness, value);
        }
        for (Map.Entry entry : ((Map)map2).entrySet()) {
            Label label;
            String source = (String)entry.getKey();
            Stats finalStats = (Stats)entry.getValue();
            if (finalStats.isEmpty()) continue;
            if (this.onlyWithStat != null) {
                Stat stat2 = this.onlyWithStat;
                Intrinsics.checkNotNull(stat2);
                if (finalStats.get(stat2) == 0.0f) continue;
            }
            Intrinsics.checkNotNull(source);
            Label $this$update_u24lambda_u249 = label = Scene2dExtensionsKt.toLabel$default(source, null, 0, 0, true, 7, null);
            boolean bl4 = false;
            $this$update_u24lambda_u249.setAlignment(8);
            ActivationExtensionsKt.onClick($this$update_u24lambda_u249, () -> DetailedStatsPopup.update$lambda$9$lambda$8(this, source));
            Label label2 = label;
            Color color = this.colorSelector;
            Color it = color;
            boolean bl5 = false;
            Color color2 = Intrinsics.areEqual(this.sourceHighlighted, source) ? color : null;
            this.totalTable.add((Actor)this.wrapInTable(label2, color2, 8)).grow();
            for (Stat stat3 : stats) {
                float value = finalStats.get(stat3);
                Label cell = value == 0.0f ? Scene2dExtensionsKt.toLabel("-") : this.toOneDecimalLabel(value);
                this.totalTable.add((Actor)DetailedStatsPopup.wrapInTable$default(this, cell, color2, 0, 4, null)).grow();
                Float f = (Float)linkedHashMap.get(stat3);
                if (f == null) {
                    f = Float.valueOf(0.0f);
                }
                f = Float.valueOf(f.floatValue() + value);
                ((Map)linkedHashMap).put(stat3, f);
            }
            this.totalTable.row();
        }
        this.totalTable.add((Actor)DetailedStatsPopup.wrapInTable$default(this, Scene2dExtensionsKt.toLabel("Total"), this.colorTotal, 0, 4, null)).grow();
        for (Stat stat4 : stats) {
            Float f = (Float)linkedHashMap.get(stat4);
            this.totalTable.add((Actor)DetailedStatsPopup.wrapInTable$default(this, f != null ? this.toOneDecimalLabel(f.floatValue()) : null, this.colorTotal, 0, 4, null)).minWidth(statColMinWidth).grow();
        }
        this.totalTable.row();
        Scene2dExtensionsKt.packIfNeeded(this.headerTable);
        Scene2dExtensionsKt.packIfNeeded(this.totalTable);
        float firstColumnWidth = Math.max(this.totalTable.getColumnWidth(0), this.headerTable.getColumnWidth(0));
        this.headerTable.getCells().first().minWidth(firstColumnWidth);
        this.totalTable.getCells().first().minWidth(firstColumnWidth);
        this.headerTable.invalidate();
        this.totalTable.invalidate();
    }

    private final IconCircleGroup getToggleButton(boolean showDetails) {
        Label label = Scene2dExtensionsKt.toLabel(showDetails ? "-" : "+");
        label.setAlignment(1);
        IconCircleGroup button = Scene2dExtensionsKt.surroundWithCircle$default(Scene2dExtensionsKt.surroundWithCircle$default(label, 25.0f, false, BaseScreen.Companion.getSkinStrings().getSkinConfig().getBaseColor(), null, 10, null), 27.0f, false, null, null, 12, null);
        ActivationExtensionsKt.onActivation$default(button, null, KeyboardBinding.ShowStatDetails, () -> DetailedStatsPopup.getToggleButton$lambda$11(this), 1, null);
        ActivationExtensionsKt.getKeyShortcuts(button).add(81);
        return button;
    }

    private final void traverseTree(Table table2, List<? extends Stat> stats, StatTreeNode statTreeNode, boolean mergeHappiness, boolean percentage, int indentation) {
        LinkedHashMap total = new LinkedHashMap();
        SortedMap map2 = MapsKt.toSortedMap((Map)statTreeNode.getChildren());
        if (mergeHappiness) {
            for (Map.Entry entry : ((Map)this.cityScreen.getCity$core().getCityStats().getHappinessList()).entrySet()) {
                String key = (String)entry.getKey();
                float value = ((Number)entry.getValue()).floatValue();
                if (!map2.containsKey(key)) {
                    ((Map)map2).put(key, new StatTreeNode());
                    StatTreeNode statTreeNode2 = (StatTreeNode)map2.get(key);
                    if (statTreeNode2 != null) {
                        statTreeNode2.setInnerStat(Stat.Happiness, value);
                    }
                    continue;
                }
                Object v = map2.get(key);
                Intrinsics.checkNotNull(v);
                if (!(((StatTreeNode)v).getTotalStats().getHappiness() == 0.0f)) continue;
                StatTreeNode statTreeNode3 = (StatTreeNode)map2.get(key);
                if (statTreeNode3 != null) {
                    statTreeNode3.setInnerStat(Stat.Happiness, value);
                }
            }
        }
        for (Map.Entry entry : ((Map)map2).entrySet()) {
            Label $i$f$all22;
            boolean bl;
            String text;
            StatTreeNode child;
            block18: {
                String name = (String)entry.getKey();
                child = (StatTreeNode)entry.getValue();
                StringBuilder stringBuilder = new StringBuilder().append(StringsKt.repeat("- ", indentation));
                Intrinsics.checkNotNull(name);
                text = stringBuilder.append(TranslationsKt.tr$default(name, false, false, 3, null)).toString();
                Iterable $this$all$iv = child.getTotalStats();
                boolean $i$f$all22 = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object t : $this$all$iv) {
                        Stats.StatValuePair it = (Stats.StatValuePair)t;
                        boolean bl2 = false;
                        if (it.getValue() == 0.0f) continue;
                        bl = false;
                        break block18;
                    }
                    bl = true;
                }
            }
            if (bl) {
                table2.row();
                continue;
            }
            if (this.onlyWithStat != null) {
                Stats stats2 = child.getTotalStats();
                Stat stat = this.onlyWithStat;
                Intrinsics.checkNotNull(stat);
                if (stats2.get(stat) == 0.0f) {
                    table2.row();
                    continue;
                }
            }
            Label $this$traverseTree_u24lambda_u2414 = $i$f$all22 = Scene2dExtensionsKt.toLabel$default(text, null, 0, 0, true, 7, null);
            boolean bl2 = false;
            $this$traverseTree_u24lambda_u2414.setAlignment(8);
            ActivationExtensionsKt.onClick($this$traverseTree_u24lambda_u2414, () -> DetailedStatsPopup.traverseTree$lambda$14$lambda$13(this, text));
            Label label = $i$f$all22;
            Color color = null;
            if (Intrinsics.areEqual(this.sourceHighlighted, text)) {
                color = this.colorSelector;
            }
            table2.add((Actor)this.wrapInTable(label, color, 8)).fill().left();
            for (Stat stat : stats) {
                float value = child.getTotalStats().get(stat);
                Label cell = value == 0.0f ? Scene2dExtensionsKt.toLabel("-") : (percentage ? this.toPercentLabel(value) : this.toOneDecimalLabel(value));
                table2.add((Actor)DetailedStatsPopup.wrapInTable$default(this, cell, color, 0, 4, null)).grow();
                if (indentation != 0) continue;
                Float current = (Float)total.get(stat);
                if (current == null) {
                    current = Float.valueOf(0.0f);
                }
                ((Map)total).put(stat, Float.valueOf(current.floatValue() + value));
            }
            table2.row();
            if (!this.isDetailed) continue;
            Intrinsics.checkNotNull(child);
            DetailedStatsPopup.traverseTree$default(this, table2, stats, child, false, percentage, indentation + 1, 8, null);
        }
        if (indentation == 0) {
            table2.add((Actor)DetailedStatsPopup.wrapInTable$default(this, Scene2dExtensionsKt.toLabel("Total"), this.colorTotal, 0, 4, null)).grow();
            for (Stat stat : stats) {
                Cell<Actor> cell;
                if (percentage) {
                    Float f = (Float)total.get(stat);
                    cell = table2.add((Actor)DetailedStatsPopup.wrapInTable$default(this, f != null ? this.toPercentLabel(f.floatValue()) : null, this.colorTotal, 0, 4, null)).grow();
                    continue;
                }
                Float f = (Float)total.get(stat);
                cell = table2.add((Actor)DetailedStatsPopup.wrapInTable$default(this, f != null ? this.toOneDecimalLabel(f.floatValue()) : null, this.colorTotal, 0, 4, null)).grow();
            }
            table2.row();
        }
    }

    static /* synthetic */ void traverseTree$default(DetailedStatsPopup detailedStatsPopup, Table table2, List list2, StatTreeNode statTreeNode, boolean bl, boolean bl2, int n, int n2, Object object) {
        if ((n2 & 8) != 0) {
            bl = false;
        }
        if ((n2 & 0x10) != 0) {
            bl2 = false;
        }
        if ((n2 & 0x20) != 0) {
            n = 0;
        }
        detailedStatsPopup.traverseTree(table2, list2, statTreeNode, bl, bl2, n);
    }

    private final Table wrapInTable(Label label, Color color, int align) {
        Table tbl = new Table();
        Label label2 = label;
        if (label2 != null) {
            label2.setAlignment(align);
        }
        if (color != null) {
            tbl.setBackground(SkinStrings.getUiBackground$default(BaseScreen.Companion.getSkinStrings(), "General/Border", null, color, 2, null));
        }
        tbl.add((Actor)label).growX();
        return tbl;
    }

    static /* synthetic */ Table wrapInTable$default(DetailedStatsPopup detailedStatsPopup, Label label, Color color, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            color = null;
        }
        if ((n2 & 4) != 0) {
            n = 1;
        }
        return detailedStatsPopup.wrapInTable(label, color, n);
    }

    private final Label toPercentLabel(float $this$toPercentLabel) {
        String string = this.percentFormatter.format(Float.valueOf($this$toPercentLabel));
        Intrinsics.checkNotNullExpressionValue(string, "format(...)");
        return Scene2dExtensionsKt.toLabel(string);
    }

    private final Label toOneDecimalLabel(float $this$toOneDecimalLabel) {
        String string = this.decimalFormatter.format(Float.valueOf($this$toOneDecimalLabel));
        Intrinsics.checkNotNullExpressionValue(string, "format(...)");
        return Scene2dExtensionsKt.toLabel(string);
    }

    private static final Unit _init_$lambda$1(DetailedStatsPopup this$0) {
        this$0.cityScreen.setPauseFireworks$core(true);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$2(DetailedStatsPopup this$0) {
        this$0.cityScreen.setPauseFireworks$core(false);
        return Unit.INSTANCE;
    }

    private static final Unit update$lambda$4(DetailedStatsPopup this$0, Stat $stat) {
        this$0.onlyWithStat = this$0.onlyWithStat == null ? $stat : null;
        this$0.update();
        return Unit.INSTANCE;
    }

    private static final Unit update$lambda$9$lambda$8(DetailedStatsPopup this$0, String $source) {
        this$0.sourceHighlighted = Intrinsics.areEqual(this$0.sourceHighlighted, $source) ? null : $source;
        this$0.update();
        return Unit.INSTANCE;
    }

    private static final Unit getToggleButton$lambda$11(DetailedStatsPopup this$0) {
        this$0.isDetailed = !this$0.isDetailed;
        this$0.update();
        return Unit.INSTANCE;
    }

    private static final Unit traverseTree$lambda$14$lambda$13(DetailedStatsPopup this$0, String $text) {
        this$0.sourceHighlighted = Intrinsics.areEqual(this$0.sourceHighlighted, $text) ? null : $text;
        this$0.update();
        return Unit.INSTANCE;
    }
}

