/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.components.tilegroups.layers;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.utils.Array;
import com.unciv.UncivGame;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.models.ruleset.unique.LocalUniqueCache;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.tilegroups.TileGroup;
import com.unciv.ui.components.tilegroups.layers.TileLayer;
import com.unciv.ui.components.widgets.UnitIconGroup;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.screens.basescreen.BaseScreen;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0005H\u0016J\u001a\u0010\u0010\u001a\u00020\u000e2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0005H\u0016J\b\u0010\u0014\u001a\u00020\u000eH\u0002J\u0010\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u000bH\u0002J.\u0010\u001c\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020\t2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002J\u0010\u0010 \u001a\u00020!2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u000e\u0010\"\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u001eJ\u0010\u0010#\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u001d\u001a\u00020\u001eJ\b\u0010$\u001a\u00020\u000eH\u0002J\u0012\u0010%\u001a\u00020\u000e2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002J\u001a\u0010&\u001a\u00020\u000e2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010'\u001a\u00020(H\u0014J\u0006\u0010)\u001a\u00020\u000eR\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/unciv/ui/components/tilegroups/layers/TileLayerUnitFlag;", "Lcom/unciv/ui/components/tilegroups/layers/TileLayer;", "tileGroup", "Lcom/unciv/ui/components/tilegroups/TileGroup;", "size", "", "<init>", "(Lcom/unciv/ui/components/tilegroups/TileGroup;F)V", "noIcons", "", "civilianUnitIcon", "Lcom/unciv/ui/components/widgets/UnitIconGroup;", "militaryUnitIcon", "act", "", "delta", "draw", "batch", "Lcom/badlogic/gdx/graphics/g2d/Batch;", "parentAlpha", "clearSlots", "showMilitaryUnit", "viewingCiv", "Lcom/unciv/logic/civilization/Civilization;", "setIconPosition", "slot", "", "icon", "newUnitIcon", "unit", "Lcom/unciv/logic/map/mapunit/MapUnit;", "isViewable", "getAirUnitTable", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "selectFlag", "getIcon", "highlightRed", "fillSlots", "doUpdate", "localUniqueCache", "Lcom/unciv/models/ruleset/unique/LocalUniqueCache;", "reset", "core"})
@SourceDebugExtension(value={"SMAP\nTileLayerUnitFlag.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TileLayerUnitFlag.kt\ncom/unciv/ui/components/tilegroups/layers/TileLayerUnitFlag\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,171:1\n1761#2,3:172\n*S KotlinDebug\n*F\n+ 1 TileLayerUnitFlag.kt\ncom/unciv/ui/components/tilegroups/layers/TileLayerUnitFlag\n*L\n72#1:172,3\n*E\n"})
public final class TileLayerUnitFlag
extends TileLayer {
    private boolean noIcons;
    @Nullable
    private UnitIconGroup civilianUnitIcon;
    @Nullable
    private UnitIconGroup militaryUnitIcon;

    public TileLayerUnitFlag(@NotNull TileGroup tileGroup, float size) {
        Intrinsics.checkNotNullParameter(tileGroup, "tileGroup");
        super(tileGroup, size);
        this.noIcons = true;
        this.setTouchable(Touchable.disabled);
    }

    @Override
    public void act(float delta) {
        if (this.noIcons) {
            return;
        }
        Iterator iterator2 = this.getChildren().iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator iterator3 = iterator2;
        while (((Array.ArrayIterator)iterator3).hasNext()) {
            Actor child = (Actor)((Array.ArrayIterator)iterator3).next();
            child.act(delta);
        }
    }

    @Override
    public void draw(@Nullable Batch batch, float parentAlpha) {
        if (this.noIcons) {
            return;
        }
        super.draw(batch, parentAlpha);
    }

    private final void clearSlots() {
        block1: {
            UnitIconGroup unitIconGroup = this.civilianUnitIcon;
            if (unitIconGroup != null) {
                unitIconGroup.remove();
            }
            UnitIconGroup unitIconGroup2 = this.militaryUnitIcon;
            if (unitIconGroup2 == null) break block1;
            unitIconGroup2.remove();
        }
    }

    private final boolean showMilitaryUnit(Civilization viewingCiv) {
        return this.getTileGroup().isForceVisible() || viewingCiv.getViewableInvisibleUnitsTiles().contains(this.getTileGroup().getTile()) || !this.getTileGroup().getTile().hasEnemyInvisibleUnit(viewingCiv);
    }

    private final void setIconPosition(int slot, UnitIconGroup icon) {
        switch (slot) {
            case 0: {
                Scene2dExtensionsKt.center((Actor)icon, this);
                icon.setY(icon.getY() + -20.0f);
                break;
            }
            case 1: {
                Scene2dExtensionsKt.center((Actor)icon, this);
                icon.setY(icon.getY() + 20.0f);
            }
        }
    }

    private final UnitIconGroup newUnitIcon(int slot, MapUnit unit, boolean isViewable, Civilization viewingCiv) {
        UnitIconGroup newIcon = null;
        if (unit != null && isViewable) {
            Object object;
            boolean bl;
            block7: {
                newIcon = new UnitIconGroup(unit, 30.0f);
                this.addActor(newIcon);
                this.setIconPosition(slot, newIcon);
                Iterable $this$any$iv = unit.getTile().getAirUnits();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        MapUnit it = (MapUnit)element$iv;
                        boolean bl2 = false;
                        if (!unit.isTransportTypeOf(it)) continue;
                        bl = true;
                        break block7;
                    }
                    bl = false;
                }
            }
            if (bl && !unit.getTile().isCityCenter()) {
                Table table2 = this.getAirUnitTable(unit);
                newIcon.addActor(table2);
                table2.toBack();
                table2.setY(newIcon.getHeight() / (float)2 - table2.getHeight() / (float)2);
                table2.setX(newIcon.getWidth() - table2.getWidth() * 0.45f);
            }
            if (Intrinsics.areEqual(unit.getCiv(), viewingCiv) && !MapUnit.isIdle$default(unit, false, 1, null) && UncivGame.Companion.getCurrent().getSettings().getUnitIconOpacity() == 1.0f && (object = newIcon.getActionGroup()) != null && (object = ((Actor)object).getColor()) != null) {
                ((Color)object).a = 0.5f;
            }
            if (Intrinsics.areEqual(unit.getCiv(), viewingCiv) && !unit.hasMovement()) {
                newIcon.getColor().a = 0.5f * UncivGame.Companion.getCurrent().getSettings().getUnitIconOpacity();
            }
        }
        return newIcon;
    }

    private final Table getAirUnitTable(MapUnit unit) {
        Color iconColor = unit.getCiv().getNation().getOuterColor();
        Color bgColor = unit.getCiv().getNation().getInnerColor();
        Table airUnitTable = new Table();
        airUnitTable.setBackground(BaseScreen.Companion.getSkinStrings().getUiBackground("WorldScreen/AirUnitTable", "", bgColor));
        airUnitTable.pad(0.0f).defaults().pad(0.0f);
        airUnitTable.setSize(28.0f, 12.0f);
        Table table2 = new Table();
        Image aircraftImage = ImageGetter.getImage$default(ImageGetter.INSTANCE, "OtherIcons/Aircraft", null, 2, null);
        aircraftImage.setColor(iconColor);
        table2.add((Actor)aircraftImage).size(8.0f);
        table2.add((Actor)Scene2dExtensionsKt.toLabel$default(TranslationsKt.tr(unit.getTile().getAirUnits().size()), iconColor, 10, 1, false, 8, null));
        airUnitTable.add((Actor)table2).expand().center().right();
        return airUnitTable;
    }

    public final void selectFlag(@NotNull MapUnit unit) {
        block0: {
            Intrinsics.checkNotNullParameter(unit, "unit");
            UnitIconGroup unitIconGroup = this.getIcon(unit);
            if (unitIconGroup == null) break block0;
            unitIconGroup.selectUnit();
        }
    }

    @Nullable
    public final UnitIconGroup getIcon(@NotNull MapUnit unit) {
        Intrinsics.checkNotNullParameter(unit, "unit");
        UnitIconGroup unitIconGroup = this.civilianUnitIcon;
        if (Intrinsics.areEqual(unitIconGroup != null ? unitIconGroup.getUnit() : null, unit)) {
            return this.civilianUnitIcon;
        }
        UnitIconGroup unitIconGroup2 = this.militaryUnitIcon;
        if (Intrinsics.areEqual(unitIconGroup2 != null ? unitIconGroup2.getUnit() : null, unit)) {
            return this.militaryUnitIcon;
        }
        return null;
    }

    private final void highlightRed() {
        block1: {
            UnitIconGroup unitIconGroup = this.civilianUnitIcon;
            if (unitIconGroup != null) {
                unitIconGroup.highlightRed();
            }
            UnitIconGroup unitIconGroup2 = this.militaryUnitIcon;
            if (unitIconGroup2 == null) break block1;
            unitIconGroup2.highlightRed();
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void fillSlots(Civilization viewingCiv) {
        v0 = isForceVisible = viewingCiv == null || this.getTileGroup().isForceVisible() != false;
        if (isForceVisible) ** GOTO lbl-1000
        v1 = viewingCiv;
        Intrinsics.checkNotNull(v1);
        if (this.isViewable(v1)) lbl-1000:
        // 2 sources

        {
            v2 = true;
        } else {
            v2 = isViewable = false;
        }
        if (isForceVisible) ** GOTO lbl-1000
        v3 = viewingCiv;
        Intrinsics.checkNotNull(v3);
        if (this.showMilitaryUnit(v3)) lbl-1000:
        // 2 sources

        {
            v4 = true;
        } else {
            v4 = false;
        }
        isVisibleMilitary = v4;
        isCivilianShown = isViewable;
        isMilitaryShown = isViewable != false && isVisibleMilitary != false;
        this.civilianUnitIcon = this.newUnitIcon(0, this.getTileGroup().getTile().getCivilianUnit(), isCivilianShown, viewingCiv);
        this.militaryUnitIcon = this.newUnitIcon(1, this.getTileGroup().getTile().getMilitaryUnit(), isMilitaryShown, viewingCiv);
        this.noIcons = this.civilianUnitIcon == null && this.militaryUnitIcon == null;
    }

    @Override
    protected void doUpdate(@Nullable Civilization viewingCiv, @NotNull LocalUniqueCache localUniqueCache) {
        Intrinsics.checkNotNullParameter(localUniqueCache, "localUniqueCache");
        this.clearSlots();
        this.fillSlots(viewingCiv);
        if (viewingCiv != null) {
            boolean shouldBeHighlighted;
            Sequence<MapUnit> unitsInTile = this.getTile().getUnits();
            boolean bl = shouldBeHighlighted = SequencesKt.any(unitsInTile) && SequencesKt.first(unitsInTile).getCiv().isAtWarWith(viewingCiv) && this.isViewable(viewingCiv) && this.showMilitaryUnit(viewingCiv);
            if (shouldBeHighlighted) {
                this.highlightRed();
            }
        }
    }

    public final void reset() {
        this.clearSlots();
        this.noIcons = true;
    }
}

