/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.components.tilegroups;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.unciv.UncivGame;
import com.unciv.logic.city.City;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.ruleset.unique.LocalUniqueCache;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.tilegroups.TileGroup;
import com.unciv.ui.components.tilegroups.TileSetStrings;
import com.unciv.ui.images.ImageGetter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001a\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\b\u0010\u000f\u001a\u00020\u0000H\u0016\u00a8\u0006\u0010"}, d2={"Lcom/unciv/ui/components/tilegroups/WorldTileGroup;", "Lcom/unciv/ui/components/tilegroups/TileGroup;", "tile", "Lcom/unciv/logic/map/tile/Tile;", "tileSetStrings", "Lcom/unciv/ui/components/tilegroups/TileSetStrings;", "<init>", "(Lcom/unciv/logic/map/tile/Tile;Lcom/unciv/ui/components/tilegroups/TileSetStrings;)V", "update", "", "viewingCiv", "Lcom/unciv/logic/civilization/Civilization;", "localUniqueCache", "Lcom/unciv/models/ruleset/unique/LocalUniqueCache;", "updateWorkedIcon", "clone", "core"})
@SourceDebugExtension(value={"SMAP\nWorldTileGroup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WorldTileGroup.kt\ncom/unciv/ui/components/tilegroups/WorldTileGroup\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,55:1\n1#2:56\n*E\n"})
public final class WorldTileGroup
extends TileGroup {
    public WorldTileGroup(@NotNull Tile tile, @NotNull TileSetStrings tileSetStrings) {
        Intrinsics.checkNotNullParameter(tile, "tile");
        Intrinsics.checkNotNullParameter(tileSetStrings, "tileSetStrings");
        super(tile, tileSetStrings, 0.0f, 4, null);
        this.getLayerMisc().setTouchable(Touchable.disabled);
    }

    @Override
    public void update(@Nullable Civilization viewingCiv, @NotNull LocalUniqueCache localUniqueCache) {
        Intrinsics.checkNotNullParameter(localUniqueCache, "localUniqueCache");
        super.update(viewingCiv, localUniqueCache);
        Civilization civilization = viewingCiv;
        Intrinsics.checkNotNull(civilization);
        this.updateWorkedIcon(civilization);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void updateWorkedIcon(Civilization viewingCiv) {
        Actor actor;
        Image image;
        this.getLayerMisc().removeWorkedIcon();
        if (!UncivGame.Companion.getCurrent().getSettings().getShowWorkedTiles()) return;
        if (!this.isViewable(viewingCiv)) return;
        City city = this.getTile().getCity();
        if (!Intrinsics.areEqual(city != null ? city.getCiv() : null, viewingCiv)) return;
        if (!this.getTile().isWorked()) return;
        boolean bl = true;
        boolean shouldShowWorkedIcon = bl;
        if (!shouldShowWorkedIcon) {
            return;
        }
        if (this.getTile().isLocked()) {
            Image $this$updateWorkedIcon_u24lambda_u240 = image = ImageGetter.getImage$default(ImageGetter.INSTANCE, "TileIcons/Locked", null, 2, null);
            boolean bl2 = false;
            Color color = Color.WHITE;
            Intrinsics.checkNotNullExpressionValue(color, "WHITE");
            $this$updateWorkedIcon_u24lambda_u240.setColor(Scene2dExtensionsKt.darken(color, 0.5f));
            actor = image;
        } else {
            if (!this.getTile().isWorked()) return;
            if (!this.getTile().providesYield()) return;
            Image $this$updateWorkedIcon_u24lambda_u241 = image = ImageGetter.getImage$default(ImageGetter.INSTANCE, "TileIcons/Worked", null, 2, null);
            boolean bl3 = false;
            Color color = Color.WHITE;
            Intrinsics.checkNotNullExpressionValue(color, "WHITE");
            $this$updateWorkedIcon_u24lambda_u241.setColor(Scene2dExtensionsKt.darken(color, 0.5f));
            actor = image;
        }
        Actor icon = actor;
        if (icon == null) return;
        icon.setSize(20.0f, 20.0f);
        Scene2dExtensionsKt.center(icon, this);
        icon.setX(icon.getX() + 20.0f);
        this.getLayerMisc().addWorkedIcon(icon);
    }

    @Override
    @NotNull
    public WorldTileGroup clone() {
        return new WorldTileGroup(this.getTile(), this.getTileSetStrings());
    }
}

