/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.components.tilegroups;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.unciv.logic.civilization.diplomacy.RelationshipLevel;
import com.unciv.models.skins.SkinStrings;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.screens.basescreen.BaseScreen;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0004\b\b\u0010\tJ\u001a\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u0003H\u0016J \u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u00a8\u0006\u0015"}, d2={"Lcom/unciv/ui/components/tilegroups/InfluenceTable;", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "influence", "", "relationshipLevel", "Lcom/unciv/logic/civilization/diplomacy/RelationshipLevel;", "width", "height", "<init>", "(FLcom/unciv/logic/civilization/diplomacy/RelationshipLevel;FF)V", "draw", "", "batch", "Lcom/badlogic/gdx/graphics/g2d/Batch;", "parentAlpha", "getBarPiece", "percentage", "color", "Lcom/badlogic/gdx/graphics/Color;", "negative", "", "core"})
public final class InfluenceTable
extends Table {
    public InfluenceTable(float influence, @NotNull RelationshipLevel relationshipLevel, float width, float height) {
        Color color;
        Intrinsics.checkNotNullParameter((Object)relationshipLevel, "relationshipLevel");
        this.defaults().pad(1.0f);
        this.setSize(width, height);
        this.setBackground(SkinStrings.getUiBackground$default(BaseScreen.Companion.getSkinStrings(), "WorldScreen/CityButton/InfluenceBar", null, ImageGetter.INSTANCE.getCHARCOAL(), 2, null));
        float normalizedInfluence = Math.max(-60.0f, Math.min(influence, 60.0f)) / 30.0f;
        switch (WhenMappings.$EnumSwitchMapping$0[relationshipLevel.ordinal()]) {
            case 1: {
                color = Color.RED;
                break;
            }
            case 2: {
                color = Color.ORANGE;
                break;
            }
            case 3: {
                color = Color.YELLOW;
                break;
            }
            case 4: 
            case 5: {
                color = Color.LIME;
                break;
            }
            case 6: {
                color = Color.SKY;
                break;
            }
            default: {
                color = Color.DARK_GRAY;
            }
        }
        Color color2 = color;
        Float[] floatArray = new Float[]{Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f)};
        ArrayList<Float> percentages = CollectionsKt.arrayListOf(floatArray);
        if (normalizedInfluence < -1.0f) {
            percentages.set(0, Float.valueOf(-normalizedInfluence - 1.0f));
            percentages.set(1, Float.valueOf(1.0f));
        } else if (normalizedInfluence < 0.0f) {
            percentages.set(1, Float.valueOf(-normalizedInfluence));
        } else if (normalizedInfluence < 1.0f) {
            percentages.set(2, Float.valueOf(normalizedInfluence));
        } else {
            percentages.set(2, Float.valueOf(1.0f));
            percentages.set(3, Float.valueOf(normalizedInfluence - 1.0f));
        }
        for (int i = 0; i < 4; ++i) {
            Float f = percentages.get(i);
            Intrinsics.checkNotNullExpressionValue(f, "get(...)");
            float f2 = ((Number)f).floatValue();
            Intrinsics.checkNotNull(color2);
            this.add((Actor)this.getBarPiece(f2, color2, i < 2));
        }
    }

    public /* synthetic */ InfluenceTable(float f, RelationshipLevel relationshipLevel, float f2, float f3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            f2 = 100.0f;
        }
        if ((n & 8) != 0) {
            f3 = 5.0f;
        }
        this(f, relationshipLevel, f2, f3);
    }

    @Override
    public void draw(@Nullable Batch batch, float parentAlpha) {
        super.draw(batch, parentAlpha);
    }

    private final Table getBarPiece(float percentage, Color color, boolean negative) {
        Cell<Actor> cell;
        float barPieceSize = this.getWidth() / 4.0f;
        Table barPiece = new Table();
        Image full = ImageGetter.INSTANCE.getWhiteDot();
        Image empty = ImageGetter.INSTANCE.getWhiteDot();
        full.setColor(color);
        empty.setColor(Color.DARK_GRAY);
        if (negative) {
            barPiece.add((Actor)empty).size((1.0f - percentage) * barPieceSize, this.getHeight());
            cell = barPiece.add((Actor)full).size(percentage * barPieceSize, this.getHeight());
        } else {
            barPiece.add((Actor)full).size(percentage * barPieceSize, this.getHeight());
            cell = barPiece.add((Actor)empty).size((1.0f - percentage) * barPieceSize, this.getHeight());
        }
        return barPiece;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RelationshipLevel.values().length];
            try {
                nArray[RelationshipLevel.Unforgivable.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RelationshipLevel.Enemy.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RelationshipLevel.Afraid.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RelationshipLevel.Neutral.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RelationshipLevel.Friend.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RelationshipLevel.Ally.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

