/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.models.ruleset.tile;

import com.unciv.logic.MultiFilter;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.map.tile.Tile;
import com.unciv.logic.map.tile.TileImprovementFunctions;
import com.unciv.models.ruleset.Belief;
import com.unciv.models.ruleset.Building;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.RulesetStatsObject;
import com.unciv.models.ruleset.tile.ResourceType;
import com.unciv.models.ruleset.tile.Terrain;
import com.unciv.models.ruleset.tile.TileImprovement;
import com.unciv.models.ruleset.unique.GameContext;
import com.unciv.models.ruleset.unique.IHasUniques;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueTarget;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.ruleset.unit.BaseUnit;
import com.unciv.models.stats.GameResource;
import com.unciv.models.stats.Stats;
import com.unciv.ui.objectdescriptions.DescriptionHelpersKt;
import com.unciv.ui.screens.civilopediascreen.FormattedLine;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import yairm210.purity.annotations.Cache;
import yairm210.purity.annotations.Readonly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002:\u0001LB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000e\u00108\u001a\b\u0012\u0004\u0012\u00020\r04H\u0007J\u000e\u00109\u001a\u00020:2\u0006\u00106\u001a\u000207J\b\u0010;\u001a\u00020<H\u0016J\b\u0010=\u001a\u00020\rH\u0016J\u0016\u0010>\u001a\b\u0012\u0004\u0012\u00020?0\f2\u0006\u00106\u001a\u000207H\u0016J\u0010\u0010@\u001a\u00020-2\u0006\u0010A\u001a\u00020\rH\u0007J\u001a\u0010B\u001a\u0004\u0018\u00010\r2\u0006\u0010C\u001a\u00020D2\u0006\u0010E\u001a\u00020FH\u0007J\u001c\u0010G\u001a\u00020-2\u0006\u0010H\u001a\u00020\r2\n\b\u0002\u0010I\u001a\u0004\u0018\u00010FH\u0007J\u0010\u0010J\u001a\u00020-2\u0006\u0010H\u001a\u00020\rH\u0007J\u0010\u0010K\u001a\u00020-2\u0006\u0010C\u001a\u00020DH\u0007R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR \u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001c\u0010\u0018\u001a\u0004\u0018\u00010\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001c\u0010\u001d\u001a\u0004\u0018\u00010\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001a\"\u0004\b\u001f\u0010\u001cR \u0010 \u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u000f\"\u0004\b\"\u0010\u0011R\u001a\u0010#\u001a\u00020$X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u001a\u0010)\u001a\u00020$X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010&\"\u0004\b+\u0010(R\u001b\u0010,\u001a\u00020-8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b/\u00100\u001a\u0004\b,\u0010.R\u001b\u00101\u001a\u00020-8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b2\u00100\u001a\u0004\b1\u0010.R \u00103\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u0001048\u0002@\u0002X\u0083\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b5\u0010\u0004R\u0010\u00106\u001a\u0004\u0018\u000107X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006M"}, d2={"Lcom/unciv/models/ruleset/tile/TileResource;", "Lcom/unciv/models/ruleset/RulesetStatsObject;", "Lcom/unciv/models/stats/GameResource;", "<init>", "()V", "resourceType", "Lcom/unciv/models/ruleset/tile/ResourceType;", "getResourceType", "()Lcom/unciv/models/ruleset/tile/ResourceType;", "setResourceType", "(Lcom/unciv/models/ruleset/tile/ResourceType;)V", "terrainsCanBeFoundOn", "", "", "getTerrainsCanBeFoundOn", "()Ljava/util/List;", "setTerrainsCanBeFoundOn", "(Ljava/util/List;)V", "improvementStats", "Lcom/unciv/models/stats/Stats;", "getImprovementStats", "()Lcom/unciv/models/stats/Stats;", "setImprovementStats", "(Lcom/unciv/models/stats/Stats;)V", "revealedBy", "getRevealedBy", "()Ljava/lang/String;", "setRevealedBy", "(Ljava/lang/String;)V", "improvement", "getImprovement", "setImprovement", "improvedBy", "getImprovedBy", "setImprovedBy", "majorDepositAmount", "Lcom/unciv/models/ruleset/tile/TileResource$DepositAmount;", "getMajorDepositAmount", "()Lcom/unciv/models/ruleset/tile/TileResource$DepositAmount;", "setMajorDepositAmount", "(Lcom/unciv/models/ruleset/tile/TileResource$DepositAmount;)V", "minorDepositAmount", "getMinorDepositAmount", "setMinorDepositAmount", "isCityWide", "", "()Z", "isCityWide$delegate", "Lkotlin/Lazy;", "isStockpiled", "isStockpiled$delegate", "allImprovements", "", "getAllImprovements$annotations", "ruleset", "Lcom/unciv/models/ruleset/Ruleset;", "getImprovements", "setTransients", "", "getUniqueTarget", "Lcom/unciv/models/ruleset/unique/UniqueTarget;", "makeLink", "getCivilopediaTextLines", "Lcom/unciv/ui/screens/civilopediascreen/FormattedLine;", "isImprovedBy", "improvementName", "getImprovingImprovement", "tile", "Lcom/unciv/logic/map/tile/Tile;", "gameContext", "Lcom/unciv/models/ruleset/unique/GameContext;", "matchesFilter", "filter", "state", "matchesSingleFilter", "generatesNaturallyOn", "DepositAmount", "core"})
@SourceDebugExtension(value={"SMAP\nTileResource.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TileResource.kt\ncom/unciv/models/ruleset/tile/TileResource\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,253:1\n1255#2,2:254\n1255#2,2:294\n1869#3,2:256\n774#3:258\n865#3:259\n1761#3,3:260\n866#3:263\n1869#3,2:264\n774#3:266\n865#3:267\n1761#3,3:268\n866#3:271\n1869#3,2:272\n774#3:274\n865#3,2:275\n1869#3,2:277\n774#3:279\n865#3,2:280\n1869#3,2:282\n774#3:284\n865#3,2:285\n1869#3,2:287\n295#3,2:289\n1761#3,3:291\n*S KotlinDebug\n*F\n+ 1 TileResource.kt\ncom/unciv/models/ruleset/tile/TileResource\n*L\n69#1:254,2\n236#1:294,2\n116#1:256,2\n130#1:258\n130#1:259\n131#1:260,3\n130#1:263\n138#1:264,2\n144#1:266\n144#1:267\n145#1:268,3\n144#1:271\n156#1:272,2\n161#1:274\n161#1:275,2\n166#1:277,2\n171#1:279\n171#1:280,2\n176#1:282,2\n181#1:284\n181#1:285,2\n187#1:287,2\n207#1:289,2\n228#1:291,3\n*E\n"})
public final class TileResource
extends RulesetStatsObject
implements GameResource {
    @NotNull
    private ResourceType resourceType = ResourceType.Bonus;
    @NotNull
    private List<String> terrainsCanBeFoundOn = CollectionsKt.emptyList();
    @Nullable
    private Stats improvementStats;
    @Nullable
    private String revealedBy;
    @Nullable
    private String improvement;
    @NotNull
    private List<String> improvedBy = CollectionsKt.emptyList();
    @NotNull
    private DepositAmount majorDepositAmount = new DepositAmount();
    @NotNull
    private DepositAmount minorDepositAmount = new DepositAmount();
    @NotNull
    private final Lazy isCityWide$delegate = LazyKt.lazy(() -> TileResource.isCityWide_delegate$lambda$0(this));
    @NotNull
    private final Lazy isStockpiled$delegate = LazyKt.lazy(() -> TileResource.isStockpiled_delegate$lambda$1(this));
    @Nullable
    private Set<String> allImprovements;
    @Nullable
    private Ruleset ruleset;

    @NotNull
    public final ResourceType getResourceType() {
        return this.resourceType;
    }

    public final void setResourceType(@NotNull ResourceType resourceType) {
        Intrinsics.checkNotNullParameter((Object)resourceType, "<set-?>");
        this.resourceType = resourceType;
    }

    @NotNull
    public final List<String> getTerrainsCanBeFoundOn() {
        return this.terrainsCanBeFoundOn;
    }

    public final void setTerrainsCanBeFoundOn(@NotNull List<String> list2) {
        Intrinsics.checkNotNullParameter(list2, "<set-?>");
        this.terrainsCanBeFoundOn = list2;
    }

    @Nullable
    public final Stats getImprovementStats() {
        return this.improvementStats;
    }

    public final void setImprovementStats(@Nullable Stats stats) {
        this.improvementStats = stats;
    }

    @Nullable
    public final String getRevealedBy() {
        return this.revealedBy;
    }

    public final void setRevealedBy(@Nullable String string) {
        this.revealedBy = string;
    }

    @Nullable
    public final String getImprovement() {
        return this.improvement;
    }

    public final void setImprovement(@Nullable String string) {
        this.improvement = string;
    }

    @NotNull
    public final List<String> getImprovedBy() {
        return this.improvedBy;
    }

    public final void setImprovedBy(@NotNull List<String> list2) {
        Intrinsics.checkNotNullParameter(list2, "<set-?>");
        this.improvedBy = list2;
    }

    @NotNull
    public final DepositAmount getMajorDepositAmount() {
        return this.majorDepositAmount;
    }

    public final void setMajorDepositAmount(@NotNull DepositAmount depositAmount) {
        Intrinsics.checkNotNullParameter(depositAmount, "<set-?>");
        this.majorDepositAmount = depositAmount;
    }

    @NotNull
    public final DepositAmount getMinorDepositAmount() {
        return this.minorDepositAmount;
    }

    public final void setMinorDepositAmount(@NotNull DepositAmount depositAmount) {
        Intrinsics.checkNotNullParameter(depositAmount, "<set-?>");
        this.minorDepositAmount = depositAmount;
    }

    public final boolean isCityWide() {
        Lazy lazy = this.isCityWide$delegate;
        return (Boolean)lazy.getValue();
    }

    public final boolean isStockpiled() {
        Lazy lazy = this.isStockpiled$delegate;
        return (Boolean)lazy.getValue();
    }

    @Cache
    private static /* synthetic */ void getAllImprovements$annotations() {
    }

    @Readonly
    @NotNull
    public final Set<String> getImprovements() {
        if (this.allImprovements != null) {
            Set<String> set = this.allImprovements;
            Intrinsics.checkNotNull(set);
            return set;
        }
        Ruleset ruleset = this.ruleset;
        if (ruleset == null) {
            throw new IllegalStateException("No ruleset on TileResource when initializing improvements");
        }
        Ruleset ruleset2 = ruleset;
        Set allImprovementsLocal = new LinkedHashSet();
        if (this.improvement != null) {
            Collection collection = allImprovementsLocal;
            String string = this.improvement;
            Intrinsics.checkNotNull(string);
            collection.add(string);
        }
        allImprovementsLocal.addAll((Collection)this.improvedBy);
        Iterator<TileImprovement> iterator2 = ruleset2.getTileImprovements().values().iterator();
        while (iterator2.hasNext()) {
            boolean bl;
            TileImprovement improvement;
            block5: {
                Intrinsics.checkNotNullExpressionValue(iterator2.next(), "next(...)");
                Sequence $this$any$iv = IHasUniques.getMatchingUniques$default(improvement, UniqueType.ImprovesResources, null, 2, null);
                boolean $i$f$any = false;
                Iterator iterator3 = $this$any$iv.iterator();
                while (iterator3.hasNext()) {
                    Object element$iv = iterator3.next();
                    Unique it = (Unique)element$iv;
                    boolean bl2 = false;
                    if (!TileResource.matchesFilter$default(this, it.getParams().get(0), null, 2, null)) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
            if (!bl && !CollectionsKt.contains(allImprovementsLocal, improvement.getReplaces())) continue;
            ((Collection)allImprovementsLocal).add(improvement.getName());
        }
        this.allImprovements = allImprovementsLocal;
        return allImprovementsLocal;
    }

    public final void setTransients(@NotNull Ruleset ruleset) {
        Intrinsics.checkNotNullParameter(ruleset, "ruleset");
        this.allImprovements = null;
        this.ruleset = ruleset;
    }

    @Override
    @NotNull
    public UniqueTarget getUniqueTarget() {
        return UniqueTarget.Resource;
    }

    @Override
    @NotNull
    public String makeLink() {
        return "Resource/" + this.getName();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<FormattedLine> getCivilopediaTextLines(@NotNull Ruleset ruleset) {
        void $this$filterTo$iv$iv;
        Iterable element$iv8;
        Iterator $this$filterTo$iv$iv2;
        Iterable element$iv22;
        Iterator $this$filterTo$iv$iv3;
        Iterable element$iv32;
        Object element$iv$iv;
        Iterator $this$filterTo$iv$iv4;
        void $this$filter$iv;
        Object element$iv42;
        Object element$iv$iv2;
        Iterator $this$filterTo$iv$iv5;
        void $this$filter$iv2;
        Object element$iv5;
        Intrinsics.checkNotNullParameter(ruleset, "ruleset");
        ArrayList textList = new ArrayList();
        ((Collection)textList).add(new FormattedLine(this.resourceType.name() + " resource", null, null, null, 0.0f, 0, 4, 0, 0.0f, this.resourceType.getColor(), false, false, false, false, 15806, null));
        ((Collection)textList).add(new FormattedLine(null, null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16383, null));
        DescriptionHelpersKt.uniquesToCivilopediaTextLines$default(this, textList, null, false, null, 14, null);
        ((Collection)textList).add(new FormattedLine(this.cloneStats().toString(), null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16382, null));
        if (this.revealedBy != null) {
            ((Collection)textList).add(new FormattedLine(null, null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16383, null));
            ((Collection)textList).add(new FormattedLine("{Revealed by:}", null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16382, null));
            Collection collection = textList;
            String string = this.revealedBy;
            Intrinsics.checkNotNull(string);
            collection.add(new FormattedLine(string, "Technology/" + this.revealedBy, null, null, 0.0f, 0, 0, 1, 0.0f, null, false, false, false, false, 16252, null));
        }
        if (!((Collection)this.terrainsCanBeFoundOn).isEmpty()) {
            ((Collection)textList).add(new FormattedLine(null, null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16383, null));
            if (this.terrainsCanBeFoundOn.size() == 1) {
                String terrainName = this.terrainsCanBeFoundOn.get(0);
                ((Collection)textList).add(new FormattedLine("{Can be found on} {" + terrainName + '}', "Terrain/" + terrainName, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16380, null));
            } else {
                ((Collection)textList).add(new FormattedLine("{Can be found on}:", null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16382, null));
                Iterable $this$forEach$iv = this.terrainsCanBeFoundOn;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv.iterator();
                while (iterator2.hasNext()) {
                    element$iv5 = iterator2.next();
                    String it = (String)element$iv5;
                    boolean bl = false;
                    ((Collection)textList).add(new FormattedLine(it, "Terrain/" + it, null, null, 0.0f, 0, 0, 1, 0.0f, null, false, false, false, false, 16252, null));
                }
            }
        }
        for (String improvement : this.getImprovements()) {
            ((Collection)textList).add(new FormattedLine(null, null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16383, null));
            ((Collection)textList).add(new FormattedLine("Improved by [" + improvement + ']', "Improvement/" + improvement, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16380, null));
            if (this.improvementStats == null) continue;
            Stats stats = this.improvementStats;
            Intrinsics.checkNotNull(stats);
            if (stats.isEmpty()) continue;
            ((Collection)textList).add(new FormattedLine("{Bonus stats for improvement}: " + this.improvementStats, null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16382, null));
        }
        Collection<TileImprovement> collection = ruleset.getTileImprovements().values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Iterable improvement = collection;
        boolean $i$f$filter = false;
        element$iv5 = $this$filter$iv2;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator3 = $this$filterTo$iv$iv5.iterator();
        while (iterator3.hasNext()) {
            boolean bl;
            block31: {
                element$iv$iv2 = iterator3.next();
                TileImprovement improvement2 = (TileImprovement)element$iv$iv2;
                boolean bl2 = false;
                Iterable $this$any$iv = improvement2.getUniqueObjects();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv6 : $this$any$iv) {
                        Unique unique = (Unique)element$iv6;
                        boolean bl3 = false;
                        if (!(unique.getType() == UniqueType.ProvidesResources && Intrinsics.areEqual(unique.getParams().get(1), this.getName()))) continue;
                        bl = true;
                        break block31;
                    }
                    bl = false;
                }
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv2);
        }
        List improvementsThatProvideThis = (List)destination$iv$iv;
        if (!((Collection)improvementsThatProvideThis).isEmpty()) {
            ((Collection)textList).add(new FormattedLine(null, null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16383, null));
            ((Collection)textList).add(new FormattedLine("{Improvements that provide this resource}:", null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16382, null));
            Iterable $this$forEach$iv = improvementsThatProvideThis;
            boolean $i$f$forEach = false;
            for (Object element$iv42 : $this$forEach$iv) {
                TileImprovement it = (TileImprovement)element$iv42;
                boolean bl = false;
                ((Collection)textList).add(new FormattedLine(it.getName(), it.makeLink(), null, null, 0.0f, 0, 0, 1, 0.0f, null, false, false, false, false, 16252, null));
            }
        }
        Collection<Building> collection2 = ruleset.getBuildings().values();
        Intrinsics.checkNotNullExpressionValue(collection2, "<get-values>(...)");
        Iterable $i$f$forEach = collection2;
        boolean $i$f$filter2 = false;
        element$iv42 = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        element$iv$iv2 = $this$filterTo$iv$iv4.iterator();
        while (element$iv$iv2.hasNext()) {
            boolean bl;
            block32: {
                element$iv$iv = element$iv$iv2.next();
                Building building = (Building)element$iv$iv;
                boolean bl4 = false;
                Iterable $this$any$iv = building.getUniqueObjects();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv7 : $this$any$iv) {
                        boolean bl5;
                        Unique unique = (Unique)element$iv7;
                        boolean bl6 = false;
                        UniqueType uniqueType = unique.getType();
                        switch (uniqueType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[uniqueType.ordinal()]) {
                            case 1: {
                                bl5 = Intrinsics.areEqual(unique.getParams().get(1), this.getName());
                                break;
                            }
                            case 2: {
                                bl5 = Intrinsics.areEqual(unique.getParams().get(3), this.getName());
                                break;
                            }
                            default: {
                                bl5 = false;
                            }
                        }
                        if (!bl5) continue;
                        bl = true;
                        break block32;
                    }
                    bl = false;
                }
            }
            if (!bl) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List buildingsThatProvideThis = (List)destination$iv$iv2;
        if (!((Collection)buildingsThatProvideThis).isEmpty()) {
            ((Collection)textList).add(new FormattedLine(null, null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16383, null));
            ((Collection)textList).add(new FormattedLine("{Buildings that provide this resource}:", null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16382, null));
            Iterable $this$forEach$iv = buildingsThatProvideThis;
            boolean $i$f$forEach2 = false;
            for (Iterable element$iv32 : $this$forEach$iv) {
                Building it = (Building)element$iv32;
                boolean bl = false;
                ((Collection)textList).add(new FormattedLine(it.getName(), it.makeLink(), null, null, 0.0f, 0, 0, 1, 0.0f, null, false, false, false, false, 16252, null));
            }
        }
        Collection<Building> collection3 = ruleset.getBuildings().values();
        Intrinsics.checkNotNullExpressionValue(collection3, "<get-values>(...)");
        Iterable $this$filter$iv3 = collection3;
        boolean $i$f$filter3 = false;
        element$iv32 = $this$filter$iv3;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$filterTo3 = false;
        element$iv$iv = $this$filterTo$iv$iv3.iterator();
        while (element$iv$iv.hasNext()) {
            Object element$iv$iv3 = element$iv$iv.next();
            Building it = (Building)element$iv$iv3;
            boolean bl = false;
            if (!it.getResourceRequirementsPerTurn(GameContext.Companion.getIgnoreConditionals()).containsKey(this.getName())) continue;
            destination$iv$iv3.add(element$iv$iv3);
        }
        List buildingsThatConsumeThis = (List)destination$iv$iv3;
        if (!((Collection)buildingsThatConsumeThis).isEmpty()) {
            ((Collection)textList).add(new FormattedLine(null, null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16383, null));
            ((Collection)textList).add(new FormattedLine("{Buildings that consume this resource}:", null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16382, null));
            Iterable $this$forEach$iv = buildingsThatConsumeThis;
            boolean $i$f$forEach3 = false;
            for (Iterable element$iv22 : $this$forEach$iv) {
                Building it = (Building)element$iv22;
                boolean bl = false;
                ((Collection)textList).add(new FormattedLine(it.getName(), it.makeLink(), null, null, 0.0f, 0, 0, 1, 0.0f, null, false, false, false, false, 16252, null));
            }
        }
        Collection<BaseUnit> collection4 = ruleset.getUnits().values();
        Intrinsics.checkNotNullExpressionValue(collection4, "<get-values>(...)");
        Iterable $this$filter$iv4 = collection4;
        boolean $i$f$filter4 = false;
        element$iv22 = $this$filter$iv4;
        Collection destination$iv$iv4 = new ArrayList();
        boolean $i$f$filterTo4 = false;
        Iterator element$iv$iv3 = $this$filterTo$iv$iv2.iterator();
        while (element$iv$iv3.hasNext()) {
            Object element$iv$iv4 = element$iv$iv3.next();
            BaseUnit it = (BaseUnit)element$iv$iv4;
            boolean bl = false;
            if (!it.getResourceRequirementsPerTurn(GameContext.Companion.getIgnoreConditionals()).containsKey(this.getName())) continue;
            destination$iv$iv4.add(element$iv$iv4);
        }
        List unitsThatConsumeThis = (List)destination$iv$iv4;
        if (!((Collection)unitsThatConsumeThis).isEmpty()) {
            ((Collection)textList).add(new FormattedLine(null, null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16383, null));
            ((Collection)textList).add(new FormattedLine("{Units that consume this resource}: ", null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16382, null));
            Iterable $this$forEach$iv = unitsThatConsumeThis;
            boolean $i$f$forEach4 = false;
            for (Iterable element$iv8 : $this$forEach$iv) {
                BaseUnit it = (BaseUnit)((Object)element$iv8);
                boolean bl = false;
                ((Collection)textList).add(new FormattedLine(it.getName(), it.makeLink(), null, null, 0.0f, 0, 0, 1, 0.0f, null, false, false, false, false, 16252, null));
            }
        }
        Collection<Building> collection5 = ruleset.getBuildings().values();
        Intrinsics.checkNotNullExpressionValue(collection5, "<get-values>(...)");
        Iterable $this$filter$iv5 = collection5;
        boolean $i$f$filter5 = false;
        element$iv8 = $this$filter$iv5;
        Collection destination$iv$iv5 = new ArrayList();
        boolean $i$f$filterTo5 = false;
        for (Object element$iv$iv5 : $this$filterTo$iv$iv) {
            Building it = (Building)element$iv$iv5;
            boolean bl = false;
            List<String> list2 = it.getRequiredNearbyImprovedResources();
            boolean bl7 = list2 != null ? list2.contains(this.getName()) : false;
            if (!bl7) continue;
            destination$iv$iv5.add(element$iv$iv5);
        }
        List buildingsRequiringThis = (List)destination$iv$iv5;
        if (!((Collection)buildingsRequiringThis).isEmpty()) {
            ((Collection)textList).add(new FormattedLine(null, null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16383, null));
            ((Collection)textList).add(new FormattedLine("{Buildings that require this resource improved near the city}: ", null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16382, null));
            Iterable $this$forEach$iv = buildingsRequiringThis;
            boolean $i$f$forEach5 = false;
            for (Object element$iv9 : $this$forEach$iv) {
                Building it = (Building)element$iv9;
                boolean bl = false;
                ((Collection)textList).add(new FormattedLine(it.getName(), it.makeLink(), null, null, 0.0f, 0, 0, 1, 0.0f, null, false, false, false, false, 16252, null));
            }
        }
        CollectionsKt.addAll((Collection)textList, Belief.Companion.getCivilopediaTextMatching$default(Belief.Companion, this.getName(), ruleset, false, 4, null));
        return textList;
    }

    @Readonly
    public final boolean isImprovedBy(@NotNull String improvementName) {
        Intrinsics.checkNotNullParameter(improvementName, "improvementName");
        return this.getImprovements().contains(improvementName);
    }

    @Readonly
    @Nullable
    public final String getImprovingImprovement(@NotNull Tile tile, @NotNull GameContext gameContext) {
        Intrinsics.checkNotNullParameter(tile, "tile");
        Intrinsics.checkNotNullParameter(gameContext, "gameContext");
        if (gameContext.getCivInfo() != null) {
            Object v2;
            block2: {
                Civilization civ = gameContext.getCivInfo();
                Iterable $this$firstOrNull$iv = this.getImprovements();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    String it = (String)element$iv;
                    boolean bl = false;
                    TileImprovementFunctions tileImprovementFunctions = tile.getImprovementFunctions();
                    TileImprovement tileImprovement = civ.getGameInfo().getRuleset().getTileImprovements().get(it);
                    Intrinsics.checkNotNull(tileImprovement);
                    if (!tileImprovementFunctions.canBuildImprovement(tileImprovement, gameContext)) continue;
                    v2 = element$iv;
                    break block2;
                }
                v2 = null;
            }
            return v2;
        }
        return null;
    }

    @Readonly
    public final boolean matchesFilter(@NotNull String filter2, @Nullable GameContext state) {
        Intrinsics.checkNotNullParameter(filter2, "filter");
        return MultiFilter.multiFilter$default(MultiFilter.INSTANCE, filter2, arg_0 -> TileResource.matchesFilter$lambda$17(this, filter2, state, arg_0), false, 4, null);
    }

    public static /* synthetic */ boolean matchesFilter$default(TileResource tileResource, String string, GameContext gameContext, int n, Object object) {
        if ((n & 2) != 0) {
            gameContext = null;
        }
        return tileResource.matchesFilter(string, gameContext);
    }

    @Readonly
    public final boolean matchesSingleFilter(@NotNull String filter2) {
        boolean bl;
        Intrinsics.checkNotNullParameter(filter2, "filter");
        String string = filter2;
        if (Intrinsics.areEqual(string, this.getName())) {
            bl = true;
        } else if (Intrinsics.areEqual(string, "any")) {
            bl = true;
        } else if (Intrinsics.areEqual(string, "all")) {
            bl = true;
        } else if (Intrinsics.areEqual(string, this.resourceType.name())) {
            bl = true;
        } else {
            Stats stats = this.improvementStats;
            if (stats != null) {
                boolean bl2;
                block13: {
                    Iterable $this$any$iv = stats;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl2 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            Stats.StatValuePair it = (Stats.StatValuePair)element$iv;
                            boolean bl3 = false;
                            if (!Intrinsics.areEqual(filter2, it.getKey().name())) continue;
                            bl2 = true;
                            break block13;
                        }
                        bl2 = false;
                    }
                }
                bl = bl2;
            } else {
                bl = false;
            }
        }
        return bl;
    }

    @Readonly
    public final boolean generatesNaturallyOn(@NotNull Tile tile) {
        boolean bl;
        GameContext gameContext;
        block7: {
            Intrinsics.checkNotNullParameter(tile, "tile");
            if (!this.terrainsCanBeFoundOn.contains(tile.getLastTerrain().getName())) {
                return false;
            }
            gameContext = new GameContext(null, null, null, tile, null, null, null, null, null, null, false, 2039, null);
            if (this.hasUnique(UniqueType.NoNaturalGeneration, gameContext)) {
                return false;
            }
            Sequence<Terrain> $this$any$iv = tile.getAllTerrains();
            boolean $i$f$any = false;
            Iterator<Terrain> iterator2 = $this$any$iv.iterator();
            while (iterator2.hasNext()) {
                Terrain element$iv;
                Terrain it = element$iv = iterator2.next();
                boolean bl2 = false;
                if (!it.hasUnique(UniqueType.BlocksResources, gameContext)) continue;
                bl = true;
                break block7;
            }
            bl = false;
        }
        if (bl) {
            return false;
        }
        if (tile.getTemperature() != null && tile.getHumidity() != null) {
            Iterator<Unique> iterator3 = this.getMatchingUniques(UniqueType.TileGenerationConditions, gameContext).iterator();
            while (iterator3.hasNext()) {
                Unique unique = iterator3.next();
                double d = Double.parseDouble(unique.getParams().get(0));
                double d2 = Double.parseDouble(unique.getParams().get(1));
                Double d3 = tile.getTemperature();
                Intrinsics.checkNotNull(d3);
                double d4 = d3;
                if (!(d <= d4 ? d4 <= d2 : false)) {
                    return false;
                }
                d = Double.parseDouble(unique.getParams().get(2));
                d2 = Double.parseDouble(unique.getParams().get(3));
                Double d5 = tile.getHumidity();
                Intrinsics.checkNotNull(d5);
                d4 = d5;
                if (d <= d4 ? d4 <= d2 : false) continue;
                return false;
            }
        }
        return true;
    }

    private static final boolean isCityWide_delegate$lambda$0(TileResource this$0) {
        return this$0.hasUnique(UniqueType.CityResource, GameContext.Companion.getIgnoreConditionals());
    }

    private static final boolean isStockpiled_delegate$lambda$1(TileResource this$0) {
        return this$0.hasUnique(UniqueType.Stockpiled, GameContext.Companion.getIgnoreConditionals());
    }

    private static final boolean matchesFilter$lambda$17(TileResource this$0, String $filter, GameContext $state, String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return this$0.matchesSingleFilter($filter) || $state != null && this$0.hasTagUnique($filter, $state) || $state == null && this$0.hasTagUnique($filter);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\tR\u001a\u0010\r\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u0007\"\u0004\b\u000f\u0010\t\u00a8\u0006\u0010"}, d2={"Lcom/unciv/models/ruleset/tile/TileResource$DepositAmount;", "", "<init>", "()V", "sparse", "", "getSparse", "()I", "setSparse", "(I)V", "default", "getDefault", "setDefault", "abundant", "getAbundant", "setAbundant", "core"})
    public static final class DepositAmount {
        private int sparse = 1;
        private int default = 2;
        private int abundant = 3;

        public final int getSparse() {
            return this.sparse;
        }

        public final void setSparse(int n) {
            this.sparse = n;
        }

        public final int getDefault() {
            return this.default;
        }

        public final void setDefault(int n) {
            this.default = n;
        }

        public final int getAbundant() {
            return this.abundant;
        }

        public final void setAbundant(int n) {
            this.abundant = n;
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[UniqueType.values().length];
            try {
                nArray[UniqueType.ProvidesResources.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.StatPercentFromObjectToResource.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

