/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.multiplayer.storage;

import com.unciv.UncivGame;
import com.unciv.json.UncivJsonKt;
import com.unciv.logic.GameInfo;
import com.unciv.logic.GameInfoPreview;
import com.unciv.logic.files.UncivFiles;
import com.unciv.logic.multiplayer.ServerFeatureSet;
import com.unciv.logic.multiplayer.storage.DropBox;
import com.unciv.logic.multiplayer.storage.FileStorage;
import com.unciv.logic.multiplayer.storage.MultiplayerServer;
import com.unciv.logic.multiplayer.storage.SimpleHttp;
import com.unciv.logic.multiplayer.storage.UncivServerFileStorage;
import com.unciv.models.metadata.GameSettings;
import com.unciv.ui.screens.worldscreen.WorldScreen;
import com.unciv.ui.screens.worldscreen.chat.ChatButton;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B+\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0016\b\u0002\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\f\u001a\u00020\u000bJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000bJ\u0006\u0010\u0010\u001a\u00020\u0003J\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0013\u001a\u00020\u0014J\u0010\u0010\u0015\u001a\u00020\u00142\b\u0010\u0016\u001a\u0004\u0018\u00010\u0003J\u000e\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0003J\u001e\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0014H\u0086@\u00a2\u0006\u0002\u0010\u001cJ\u0016\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u001eH\u0086@\u00a2\u0006\u0002\u0010\u001fJ\u0016\u0010 \u001a\u00020\u001a2\u0006\u0010!\u001a\u00020\u0003H\u0086@\u00a2\u0006\u0002\u0010\"J\u0016\u0010#\u001a\u00020\u001a2\u0006\u0010!\u001a\u00020\u0003H\u0086@\u00a2\u0006\u0002\u0010\"J\u0016\u0010$\u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\u0003H\u0086@\u00a2\u0006\u0002\u0010\"R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001c\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/unciv/logic/multiplayer/storage/MultiplayerServer;", "", "fileStorageIdentifier", "", "authenticationHeader", "", "<init>", "(Ljava/lang/String;Ljava/util/Map;)V", "getFileStorageIdentifier", "()Ljava/lang/String;", "featureSet", "Lcom/unciv/logic/multiplayer/ServerFeatureSet;", "getFeatureSet", "setFeatureSet", "", "value", "getServerUrl", "fileStorage", "Lcom/unciv/logic/multiplayer/storage/FileStorage;", "checkServerStatus", "", "authenticate", "password", "setPassword", "uploadGame", "gameInfo", "Lcom/unciv/logic/GameInfo;", "withPreview", "(Lcom/unciv/logic/GameInfo;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "tryUploadGamePreview", "Lcom/unciv/logic/GameInfoPreview;", "(Lcom/unciv/logic/GameInfoPreview;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "tryDownloadGame", "gameId", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "downloadGame", "tryDownloadGamePreview", "core"})
public final class MultiplayerServer {
    @Nullable
    private final String fileStorageIdentifier;
    @Nullable
    private Map<String, String> authenticationHeader;
    @NotNull
    private ServerFeatureSet featureSet;

    public MultiplayerServer(@Nullable String fileStorageIdentifier, @Nullable Map<String, String> authenticationHeader) {
        this.fileStorageIdentifier = fileStorageIdentifier;
        this.authenticationHeader = authenticationHeader;
        this.featureSet = new ServerFeatureSet(0, 0, 3, null);
    }

    public /* synthetic */ MultiplayerServer(String string, Map map2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            map2 = null;
        }
        this(string, map2);
    }

    @Nullable
    public final String getFileStorageIdentifier() {
        return this.fileStorageIdentifier;
    }

    @NotNull
    public final ServerFeatureSet getFeatureSet() {
        return this.featureSet;
    }

    public final void setFeatureSet(@NotNull ServerFeatureSet value) {
        Intrinsics.checkNotNullParameter(value, "value");
        if (!Intrinsics.areEqual(this.featureSet, value)) {
            Object object = UncivGame.Companion.getCurrent().getWorldScreen();
            if (object != null && (object = ((WorldScreen)object).getChatButton$core()) != null) {
                ((ChatButton)object).refreshVisibility();
            }
            this.featureSet = value;
        }
    }

    @NotNull
    public final String getServerUrl() {
        String string = this.fileStorageIdentifier;
        if (string == null) {
            string = UncivGame.Companion.getCurrent().getSettings().getMultiplayer().getServer();
        }
        return string;
    }

    @NotNull
    public final FileStorage fileStorage() {
        FileStorage fileStorage;
        Map<String, String> authHeader;
        Map<String, String> map2;
        if (this.authenticationHeader == null) {
            GameSettings.GameSettingsMultiplayer settings = UncivGame.Companion.getCurrent().getSettings().getMultiplayer();
            map2 = MapsKt.mapOf(TuplesKt.to("Authorization", settings.getAuthHeader()));
        } else {
            map2 = authHeader = this.authenticationHeader;
        }
        if (Intrinsics.areEqual(this.getServerUrl(), "Dropbox")) {
            fileStorage = DropBox.INSTANCE;
        } else {
            UncivServerFileStorage uncivServerFileStorage;
            UncivServerFileStorage $this$fileStorage_u24lambda_u240 = uncivServerFileStorage = UncivServerFileStorage.INSTANCE;
            boolean bl = false;
            $this$fileStorage_u24lambda_u240.setServerUrl(this.getServerUrl());
            $this$fileStorage_u24lambda_u240.setAuthHeader(authHeader);
            fileStorage = uncivServerFileStorage;
        }
        return fileStorage;
    }

    public final boolean checkServerStatus() {
        Ref.BooleanRef statusOk = new Ref.BooleanRef();
        SimpleHttp.sendGetRequest$default(SimpleHttp.INSTANCE, this.getServerUrl() + "/isalive", 0, null, (arg_0, arg_1, arg_2) -> MultiplayerServer.checkServerStatus$lambda$1(statusOk, this, arg_0, arg_1, arg_2), 6, null);
        return statusOk.element;
    }

    public final boolean authenticate(@Nullable String password) {
        if (this.featureSet.getAuthVersion() == 0) {
            return true;
        }
        GameSettings.GameSettingsMultiplayer settings = UncivGame.Companion.getCurrent().getSettings().getMultiplayer();
        FileStorage fileStorage = this.fileStorage();
        String string = settings.getUserId();
        String string2 = password;
        if (string2 == null && (string2 = settings.getCurrentServerPassword()) == null) {
            string2 = "";
        }
        boolean success = fileStorage.authenticate(string, string2);
        if (password != null && success) {
            settings.setCurrentServerPassword(password);
        }
        return success;
    }

    public final boolean setPassword(@NotNull String password) {
        Intrinsics.checkNotNullParameter(password, "password");
        if (this.featureSet.getAuthVersion() > 0 && this.fileStorage().setPassword(password)) {
            UncivGame.Companion.getCurrent().getSettings().getMultiplayer().setCurrentServerPassword(password);
            return true;
        }
        return false;
    }

    @Nullable
    public final Object uploadGame(@NotNull GameInfo gameInfo, boolean withPreview, @NotNull Continuation<? super Unit> $completion) {
        String zippedGameInfo = UncivFiles.Companion.gameInfoToString(gameInfo, Boxing.boxBoolean(true), true);
        this.fileStorage().saveFileData(gameInfo.getGameId(), zippedGameInfo);
        if (withPreview) {
            Object object = this.tryUploadGamePreview(gameInfo.asPreview(), $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public final Object tryUploadGamePreview(@NotNull GameInfoPreview gameInfo, @NotNull Continuation<? super Unit> $completion) {
        String zippedGameInfo = UncivFiles.Companion.gameInfoToString(gameInfo);
        this.fileStorage().saveFileData(gameInfo.getGameId() + "_Preview", zippedGameInfo);
        return Unit.INSTANCE;
    }

    @Nullable
    public final Object tryDownloadGame(@NotNull String gameId, @NotNull Continuation<? super GameInfo> $completion) {
        String zippedGameInfo = this.fileStorage().loadFileData(gameId);
        GameInfo gameInfo = UncivFiles.Companion.gameInfoFromString(zippedGameInfo);
        gameInfo.getGameParameters().setMultiplayerServerUrl(UncivGame.Companion.getCurrent().getSettings().getMultiplayer().getServer());
        return gameInfo;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object downloadGame(@NotNull String gameId, @NotNull Continuation<? super GameInfo> $completion) {
        if (!($completion instanceof downloadGame.1)) ** GOTO lbl-1000
        var5_3 = $completion;
        if ((var5_3.label & -2147483648) != 0) {
            var5_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ MultiplayerServer this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.downloadGame(null, this);
                }
            };
        }
        $result = $continuation.result;
        var6_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure($result);
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable(gameId);
                $continuation.label = 1;
                v0 = this.tryDownloadGame(gameId, $continuation);
                if (v0 == var6_5) {
                    return var6_5;
                }
                ** GOTO lbl22
            }
            case 1: {
                gameId = (String)$continuation.L$0;
                ResultKt.throwOnFailure($result);
                v0 = $result;
lbl22:
                // 2 sources

                latestGame = (GameInfo)v0;
                latestGame.setUpToDate(true);
                return latestGame;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Nullable
    public final Object tryDownloadGamePreview(@NotNull String gameId, @NotNull Continuation<? super GameInfoPreview> $completion) {
        String zippedGameInfo = this.fileStorage().loadFileData(gameId + "_Preview");
        return UncivFiles.Companion.gameInfoPreviewFromString(zippedGameInfo);
    }

    private static final Unit checkServerStatus$lambda$1(Ref.BooleanRef $statusOk, MultiplayerServer this$0, boolean success, String result2, Integer n) {
        Intrinsics.checkNotNullParameter(result2, "result");
        $statusOk.element = success;
        if (((CharSequence)result2).length() > 0) {
            ServerFeatureSet serverFeatureSet;
            MultiplayerServer multiplayerServer;
            MultiplayerServer multiplayerServer2 = this$0;
            try {
                multiplayerServer = multiplayerServer2;
                serverFeatureSet = UncivJsonKt.json().fromJson(ServerFeatureSet.class, result2);
            }
            catch (Exception exception2) {
                multiplayerServer = multiplayerServer2;
                serverFeatureSet = new ServerFeatureSet(0, 0, 3, null);
            }
            ServerFeatureSet serverFeatureSet2 = serverFeatureSet;
            Intrinsics.checkNotNull(serverFeatureSet2);
            multiplayerServer.setFeatureSet(serverFeatureSet2);
        }
        return Unit.INSTANCE;
    }

    public MultiplayerServer() {
        this(null, null, 3, null);
    }
}

