/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.map.mapgenerator.mapregions;

import com.unciv.logic.map.mapgenerator.mapregions.MapRegions;
import com.unciv.logic.map.mapgenerator.mapregions.Region;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.tile.Terrain;
import com.unciv.models.ruleset.tile.TileImprovement;
import com.unciv.models.ruleset.unique.GameContext;
import com.unciv.models.ruleset.unique.IHasUniques;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u000fJ\u0010\u0010+\u001a\u00020)2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R-\u0010\u0014\u001a\u001e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u000f0\u0015j\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u000f`\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001e\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001a\u001a\u00020\u001b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u001e\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001a\u001a\u00020\u001b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001dR\u001e\u0010\u001f\u001a\u00020\u001b2\u0006\u0010\u001a\u001a\u00020\u001b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001dR\u001e\u0010 \u001a\u00020\u001b2\u0006\u0010\u001a\u001a\u00020\u001b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001dR\u001e\u0010!\u001a\u00020\u001b2\u0006\u0010\u001a\u001a\u00020\u001b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u001dR\u001a\u0010\"\u001a\u00020\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u001d\"\u0004\b#\u0010$R\u001a\u0010%\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\u0011\"\u0004\b'\u0010\u0013\u00a8\u0006,"}, d2={"Lcom/unciv/logic/map/mapgenerator/mapregions/MapGenTileData;", "", "tile", "Lcom/unciv/logic/map/tile/Tile;", "region", "Lcom/unciv/logic/map/mapgenerator/mapregions/Region;", "ruleset", "Lcom/unciv/models/ruleset/Ruleset;", "<init>", "(Lcom/unciv/logic/map/tile/Tile;Lcom/unciv/logic/map/mapgenerator/mapregions/Region;Lcom/unciv/models/ruleset/Ruleset;)V", "getTile", "()Lcom/unciv/logic/map/tile/Tile;", "getRegion", "()Lcom/unciv/logic/map/mapgenerator/mapregions/Region;", "closeStartPenalty", "", "getCloseStartPenalty", "()I", "setCloseStartPenalty", "(I)V", "impacts", "Ljava/util/HashMap;", "Lcom/unciv/logic/map/mapgenerator/mapregions/MapRegions$ImpactType;", "Lkotlin/collections/HashMap;", "getImpacts", "()Ljava/util/HashMap;", "value", "", "isFood", "()Z", "isProd", "isGood", "isJunk", "isTwoFromCoast", "isGoodStart", "setGoodStart", "(Z)V", "startScore", "getStartScore", "setStartScore", "addCloseStartPenalty", "", "penalty", "evaluate", "core"})
@SourceDebugExtension(value={"SMAP\nMapGenTileData.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MapGenTileData.kt\ncom/unciv/logic/map/mapgenerator/mapregions/MapGenTileData\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,95:1\n1255#2,2:96\n295#3,2:98\n2746#3,3:100\n774#3:103\n865#3,2:104\n1#4:106\n*S KotlinDebug\n*F\n+ 1 MapGenTileData.kt\ncom/unciv/logic/map/mapgenerator/mapregions/MapGenTileData\n*L\n45#1:96,2\n50#1:98,2\n67#1:100,3\n77#1:103\n77#1:104,2\n*E\n"})
public final class MapGenTileData {
    @NotNull
    private final Tile tile;
    @Nullable
    private final Region region;
    private int closeStartPenalty;
    @NotNull
    private final HashMap<MapRegions.ImpactType, Integer> impacts;
    private boolean isFood;
    private boolean isProd;
    private boolean isGood;
    private boolean isJunk;
    private boolean isTwoFromCoast;
    private boolean isGoodStart;
    private int startScore;

    public MapGenTileData(@NotNull Tile tile, @Nullable Region region, @NotNull Ruleset ruleset) {
        Intrinsics.checkNotNullParameter(tile, "tile");
        Intrinsics.checkNotNullParameter(ruleset, "ruleset");
        this.tile = tile;
        this.region = region;
        this.impacts = new HashMap();
        this.isGoodStart = true;
        this.evaluate(ruleset);
    }

    @NotNull
    public final Tile getTile() {
        return this.tile;
    }

    @Nullable
    public final Region getRegion() {
        return this.region;
    }

    public final int getCloseStartPenalty() {
        return this.closeStartPenalty;
    }

    public final void setCloseStartPenalty(int n) {
        this.closeStartPenalty = n;
    }

    @NotNull
    public final HashMap<MapRegions.ImpactType, Integer> getImpacts() {
        return this.impacts;
    }

    public final boolean isFood() {
        return this.isFood;
    }

    public final boolean isProd() {
        return this.isProd;
    }

    public final boolean isGood() {
        return this.isGood;
    }

    public final boolean isJunk() {
        return this.isJunk;
    }

    public final boolean isTwoFromCoast() {
        return this.isTwoFromCoast;
    }

    public final boolean isGoodStart() {
        return this.isGoodStart;
    }

    public final void setGoodStart(boolean bl) {
        this.isGoodStart = bl;
    }

    public final int getStartScore() {
        return this.startScore;
    }

    public final void setStartScore(int n) {
        this.startScore = n;
    }

    public final void addCloseStartPenalty(int penalty) {
        if (this.closeStartPenalty == 0) {
            this.closeStartPenalty = penalty;
        } else {
            this.closeStartPenalty = Math.max(this.closeStartPenalty, penalty);
            this.closeStartPenalty = Math.min(97, (int)((float)this.closeStartPenalty * 1.2f));
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void evaluate(Ruleset ruleset) {
        Float f;
        Float f2;
        Float f3;
        Float f4;
        boolean bl;
        Terrain terrain;
        if (!this.tile.isCoastalTile()) {
            boolean bl2;
            block33: {
                Sequence<Tile> $this$any$iv = this.tile.getNeighbors();
                boolean $i$f$any = false;
                Iterator<Tile> iterator2 = $this$any$iv.iterator();
                while (iterator2.hasNext()) {
                    Tile element$iv;
                    Tile tile = element$iv = iterator2.next();
                    boolean bl3 = false;
                    if (!tile.isCoastalTile()) continue;
                    bl2 = true;
                    break block33;
                }
                bl2 = false;
            }
            if (bl2) {
                this.isTwoFromCoast = true;
            }
        }
        if (this.tile.getTerrainFeatures().isEmpty()) {
            terrain = this.tile.getBaseTerrain();
        } else {
            Object v2;
            block34: {
                Iterable $this$firstOrNull$iv = this.tile.getTerrainFeatureObjects();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Terrain it = (Terrain)element$iv;
                    boolean bl4 = false;
                    if (!it.getUnbuildable()) continue;
                    v2 = element$iv;
                    break block34;
                }
                v2 = null;
            }
            if ((terrain = (Terrain)v2) == null) {
                terrain = CollectionsKt.first(this.tile.getTerrainFeatureObjects());
            }
        }
        Terrain terrainToCheck = terrain;
        Iterator<Unique> $i$f$any = terrainToCheck.getMatchingUniques(UniqueType.HasQuality, new GameContext(null, null, null, null, null, null, null, null, this.region, null, false, 1791, null)).iterator();
        while ($i$f$any.hasNext()) {
            block36: {
                block35: {
                    block37: {
                        Unique unique = $i$f$any.next();
                        String $i$f$firstOrNull = unique.getParams().get(0);
                        switch ($i$f$firstOrNull.hashCode()) {
                            case -887256580: {
                                if ($i$f$firstOrNull.equals("Undesirable")) break block35;
                                break block36;
                            }
                            case -619596683: {
                                if ($i$f$firstOrNull.equals("Desirable")) break;
                                break block36;
                            }
                            case -548483879: {
                                if ($i$f$firstOrNull.equals("Production")) break block37;
                                break block36;
                            }
                            case 2195582: {
                                if ($i$f$firstOrNull.equals("Food")) {
                                    this.isFood = true;
                                }
                                break block36;
                            }
                        }
                        this.isGood = true;
                        continue;
                    }
                    this.isProd = true;
                    continue;
                }
                this.isJunk = true;
            }
        }
        Iterable $this$none$iv = terrainToCheck.getUniqueObjects();
        boolean $i$f$none = false;
        if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
            bl = true;
        } else {
            for (Object e : $this$none$iv) {
                Unique it = (Unique)e;
                boolean bl5 = false;
                if (it.getType() == UniqueType.HasQuality) {
                    return;
                }
                boolean bl6 = false;
                if (!bl6) continue;
                return;
            }
            bl = true;
        }
        if (!bl) return;
        if (this.tile.isWater()) {
            return;
        }
        if (terrainToCheck.getImpassable()) {
            this.isJunk = true;
            return;
        }
        Collection<TileImprovement> collection = ruleset.getTileImprovements().values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterator destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : iterable) {
            TileImprovement it = (TileImprovement)element$iv$iv;
            boolean bl7 = false;
            if (!(it.getTerrainsCanBeBuiltOn().contains(terrainToCheck.getName()) && it.getUniqueTo() == null && !IHasUniques.hasUnique$default(it, UniqueType.GreatImprovement, null, 2, null))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List improvements = (List)((Object)destination$iv$iv);
        Iterable iterable2 = improvements;
        float f5 = terrainToCheck.getFood();
        destination$iv$iv = iterable2.iterator();
        if (!destination$iv$iv.hasNext()) {
            f4 = null;
        } else {
            TileImprovement it = (TileImprovement)destination$iv$iv.next();
            boolean bl8 = false;
            float f6 = it.getFood();
            while (destination$iv$iv.hasNext()) {
                TileImprovement it22 = (TileImprovement)destination$iv$iv.next();
                $i$a$-maxOfOrNull-MapGenTileData$evaluate$maxFood$1 = false;
                float it22 = it22.getFood();
                f6 = Math.max(f6, it22);
            }
            f4 = Float.valueOf(f6);
        }
        Float f7 = f3 = f4;
        float maxFood = f5 + (f7 != null ? f7.floatValue() : 0.0f);
        destination$iv$iv = improvements;
        f5 = terrainToCheck.getProduction();
        Iterator iterator3 = destination$iv$iv.iterator();
        if (!iterator3.hasNext()) {
            f2 = null;
        } else {
            TileImprovement it = (TileImprovement)iterator3.next();
            boolean bl9 = false;
            float f8 = it.getProduction();
            while (iterator3.hasNext()) {
                TileImprovement it32 = (TileImprovement)iterator3.next();
                $i$a$-maxOfOrNull-MapGenTileData$evaluate$maxProd$1 = false;
                float it32 = it32.getProduction();
                f8 = Math.max(f8, it32);
            }
            f2 = Float.valueOf(f8);
        }
        Float f9 = f3 = f2;
        float maxProd = f5 + (f9 != null ? f9.floatValue() : 0.0f);
        Iterator iterator4 = ((Iterable)improvements).iterator();
        if (!iterator4.hasNext()) {
            f = null;
        } else {
            TileImprovement it = (TileImprovement)iterator4.next();
            boolean bl10 = false;
            float f10 = it.getFood() + it.getProduction() + it.getGold() + it.getCulture() + it.getScience() + it.getFaith();
            while (iterator4.hasNext()) {
                TileImprovement it2 = (TileImprovement)iterator4.next();
                $i$a$-maxOfOrNull-MapGenTileData$evaluate$bestImprovementValue$1 = false;
                float f11 = it2.getFood() + it2.getProduction() + it2.getGold() + it2.getCulture() + it2.getScience() + it2.getFaith();
                f10 = Math.max(f10, f11);
            }
            f = Float.valueOf(f10);
        }
        float f12 = f != null ? f.floatValue() : 0.0f;
        float maxOverall = terrainToCheck.getFood() + terrainToCheck.getProduction() + terrainToCheck.getGold() + terrainToCheck.getCulture() + terrainToCheck.getScience() + terrainToCheck.getFaith() + f12;
        if (maxFood >= 2.0f) {
            this.isFood = true;
        }
        if (maxProd >= 2.0f) {
            this.isProd = true;
        }
        if (!(maxOverall >= 3.0f)) return;
        this.isGood = true;
    }
}

