/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.map.mapgenerator;

import com.unciv.logic.map.TileMap;
import com.unciv.logic.map.mapgenerator.MapGenerationRandomness;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.ModConstants;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.tile.Terrain;
import com.unciv.models.ruleset.tile.TerrainType;
import com.unciv.models.ruleset.unique.GameContext;
import com.unciv.models.ruleset.unique.IHasUniques;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.utils.LogKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J,\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00152\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0019H\u0002J\u001e\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001d2\u0006\u0010\u001e\u001a\u00020\u0017H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001e\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\u000e0\rj\b\u0012\u0004\u0012\u00020\u000e`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/unciv/logic/map/mapgenerator/NaturalWonderGenerator;", "", "ruleset", "Lcom/unciv/models/ruleset/Ruleset;", "randomness", "Lcom/unciv/logic/map/mapgenerator/MapGenerationRandomness;", "<init>", "(Lcom/unciv/models/ruleset/Ruleset;Lcom/unciv/logic/map/mapgenerator/MapGenerationRandomness;)V", "getRuleset", "()Lcom/unciv/models/ruleset/Ruleset;", "getRandomness", "()Lcom/unciv/logic/map/mapgenerator/MapGenerationRandomness;", "blockedTiles", "Ljava/util/HashSet;", "Lcom/unciv/logic/map/tile/Tile;", "Lkotlin/collections/HashSet;", "spawnNaturalWonders", "", "tileMap", "Lcom/unciv/logic/map/TileMap;", "getCandidateTilesForWonder", "", "naturalWonder", "Lcom/unciv/models/ruleset/tile/Terrain;", "tilesTooCloseToSpawnLocations", "", "trySpawnOnSuitableLocation", "", "suitableLocations", "", "wonder", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nNaturalWonderGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NaturalWonderGenerator.kt\ncom/unciv/logic/map/mapgenerator/NaturalWonderGenerator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,320:1\n774#2:321\n865#2,2:322\n1387#2:325\n1475#2,5:326\n1869#2,2:331\n1011#2,2:333\n774#2:335\n865#2,2:336\n1869#2,2:338\n1011#2,2:340\n774#2:342\n865#2,2:343\n774#2:345\n865#2,2:346\n1387#2:348\n1475#2,5:349\n774#2:354\n865#2,2:355\n1#3:324\n*S KotlinDebug\n*F\n+ 1 NaturalWonderGenerator.kt\ncom/unciv/logic/map/mapgenerator/NaturalWonderGenerator\n*L\n39#1:321\n39#1:322,2\n56#1:325\n56#1:326,5\n59#1:331,2\n62#1:333,2\n64#1:335\n64#1:336,2\n72#1:338,2\n75#1:340,2\n77#1:342\n77#1:343,2\n90#1:345\n90#1:346,2\n120#1:348\n120#1:349,5\n121#1:354\n121#1:355,2\n*E\n"})
public final class NaturalWonderGenerator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Ruleset ruleset;
    @NotNull
    private final MapGenerationRandomness randomness;
    @NotNull
    private final HashSet<Tile> blockedTiles;

    public NaturalWonderGenerator(@NotNull Ruleset ruleset, @NotNull MapGenerationRandomness randomness) {
        Intrinsics.checkNotNullParameter(ruleset, "ruleset");
        Intrinsics.checkNotNullParameter(randomness, "randomness");
        this.ruleset = ruleset;
        this.randomness = randomness;
        this.blockedTiles = new HashSet();
    }

    @NotNull
    public final Ruleset getRuleset() {
        return this.ruleset;
    }

    @NotNull
    public final MapGenerationRandomness getRandomness() {
        return this.randomness;
    }

    /*
     * WARNING - void declaration
     */
    public final void spawnNaturalWonders(@NotNull TileMap tileMap) {
        Tile it;
        Iterable $this$filter$iv;
        Iterable $this$flatMapTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        void $this$filter$iv2;
        Intrinsics.checkNotNullParameter(tileMap, "tileMap");
        if (tileMap.getMapParameters().getNoNaturalWonders()) {
            return;
        }
        int mapRadius = tileMap.getMapParameters().getMapSize().getRadius();
        ModConstants $this$spawnNaturalWonders_u24lambda_u240 = this.ruleset.getModOptions().getConstants();
        boolean bl = false;
        int numberToSpawn = MathKt.roundToInt((float)mapRadius * $this$spawnNaturalWonders_u24lambda_u240.getNaturalWonderCountMultiplier() + $this$spawnNaturalWonders_u24lambda_u240.getNaturalWonderCountAddedConstant());
        List chosenWonders = new ArrayList();
        Map wonderCandidateTiles = new LinkedHashMap();
        Collection<Terrain> collection = this.ruleset.getTerrains().values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Iterable iterable = collection;
        boolean $i$f$filter = false;
        Object object = $this$filter$iv2;
        Collection destination$iv$iv22 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Terrain it2 = (Terrain)element$iv$iv;
            boolean bl2 = false;
            if (!(it2.getType() == TerrainType.NaturalWonder)) continue;
            destination$iv$iv22.add(element$iv$iv);
        }
        List allNaturalWonders = CollectionsKt.toMutableList((List)destination$iv$iv22);
        List spawned = new ArrayList();
        block1: while (!((Collection)allNaturalWonders).isEmpty() && chosenWonders.size() < numberToSpawn) {
            Iterator<Object> iterator222;
            $this$filterTo$iv$iv = allNaturalWonders;
            int destination$iv$iv22 = 0;
            for (Iterator<Object> iterator222 : $this$filterTo$iv$iv) {
                void it3;
                Object element$iv$iv;
                element$iv$iv = (Terrain)((Object)iterator222);
                int n = destination$iv$iv22;
                boolean bl3 = false;
                int n2 = it3.getWeight();
                destination$iv$iv22 = n + n2;
            }
            float totalWeight = destination$iv$iv22;
            double random = this.randomness.getRNG().nextDouble();
            float sum = 0.0f;
            iterator222 = allNaturalWonders.iterator();
            while (iterator222.hasNext()) {
                Object object2 = iterator222.next();
                Intrinsics.checkNotNullExpressionValue(object2, "next(...)");
                Terrain wonder = (Terrain)object2;
                if (!(random <= (double)(sum += (float)wonder.getWeight() / totalWeight))) continue;
                chosenWonders.add(wonder);
                allNaturalWonders.remove(wonder);
                continue block1;
            }
        }
        Collection<HashSet<Tile>> collection2 = tileMap.getStartingLocationsByNation().values();
        Intrinsics.checkNotNullExpressionValue(collection2, "<get-values>(...)");
        Iterable $this$flatMap$iv = CollectionsKt.flatten((Iterable)collection2);
        boolean $i$f$flatMapSequence = false;
        Iterable sum = $this$flatMap$iv;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$flatMapSequenceTo = false;
        Iterator bl3 = $this$flatMapTo$iv$iv.iterator();
        while (bl3.hasNext()) {
            Object element$iv$iv = bl3.next();
            Tile it4 = (Tile)element$iv$iv;
            boolean bl4 = false;
            Sequence<Tile> list$iv$iv = it4.getTilesInDistance(5);
            CollectionsKt.addAll(destination$iv$iv3, list$iv$iv);
        }
        Set<Tile> tilesTooCloseToSpawnLocations = CollectionsKt.toSet((List)destination$iv$iv3);
        Iterable $this$forEach$iv = chosenWonders;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Terrain it5 = (Terrain)element$iv;
            boolean bl5 = false;
            wonderCandidateTiles.put(it5, this.getCandidateTilesForWonder(tileMap, it5, tilesTooCloseToSpawnLocations));
        }
        List $this$sortBy$iv = chosenWonders;
        boolean $i$f$sortBy = false;
        if ($this$sortBy$iv.size() > 1) {
            CollectionsKt.sortWith($this$sortBy$iv, new Comparator(wonderCandidateTiles){
                final /* synthetic */ Map $wonderCandidateTiles$inlined;
                {
                    this.$wonderCandidateTiles$inlined = map2;
                }

                public final int compare(T a, T b) {
                    Terrain it = (Terrain)a;
                    boolean bl = false;
                    V v = this.$wonderCandidateTiles$inlined.get(it);
                    Intrinsics.checkNotNull(v);
                    it = (Terrain)b;
                    Comparable comparable = Integer.valueOf(((Collection)v).size());
                    bl = false;
                    V v2 = this.$wonderCandidateTiles$inlined.get(it);
                    Intrinsics.checkNotNull(v2);
                    return ComparisonsKt.compareValues(comparable, ((Collection)v2).size());
                }
            });
        }
        for (Object e : chosenWonders) {
            void $this$filterTo$iv$iv2;
            Intrinsics.checkNotNullExpressionValue(e, "next(...)");
            Terrain wonder = (Terrain)e;
            Object v = wonderCandidateTiles.get(wonder);
            Intrinsics.checkNotNull(v);
            $this$flatMapTo$iv$iv = (Iterable)v;
            NaturalWonderGenerator naturalWonderGenerator = this;
            boolean $i$f$filter2 = false;
            Iterator it5 = $this$filter$iv;
            Collection destination$iv$iv4 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                it = (Tile)element$iv$iv;
                boolean bl6 = false;
                if (!(!this.blockedTiles.contains(it))) continue;
                destination$iv$iv4.add(element$iv$iv);
            }
            if (!naturalWonderGenerator.trySpawnOnSuitableLocation((List)destination$iv$iv4, wonder)) continue;
            spawned.add(wonder);
        }
        if (spawned.size() < numberToSpawn) {
            $this$forEach$iv = allNaturalWonders;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Terrain it6 = (Terrain)element$iv;
                boolean bl7 = false;
                Intrinsics.checkNotNull(it6);
                wonderCandidateTiles.put(it6, this.getCandidateTilesForWonder(tileMap, it6, tilesTooCloseToSpawnLocations));
            }
            $this$sortBy$iv = allNaturalWonders;
            $i$f$sortBy = false;
            if ($this$sortBy$iv.size() > 1) {
                CollectionsKt.sortWith($this$sortBy$iv, new Comparator(wonderCandidateTiles){
                    final /* synthetic */ Map $wonderCandidateTiles$inlined;
                    {
                        this.$wonderCandidateTiles$inlined = map2;
                    }

                    public final int compare(T a, T b) {
                        Terrain it = (Terrain)a;
                        boolean bl = false;
                        V v = this.$wonderCandidateTiles$inlined.get(it);
                        Intrinsics.checkNotNull(v);
                        it = (Terrain)b;
                        Comparable comparable = Integer.valueOf(((Collection)v).size());
                        bl = false;
                        V v2 = this.$wonderCandidateTiles$inlined.get(it);
                        Intrinsics.checkNotNull(v2);
                        return ComparisonsKt.compareValues(comparable, ((Collection)v2).size());
                    }
                });
            }
            for (Object e : allNaturalWonders) {
                void $this$filterTo$iv$iv3;
                Intrinsics.checkNotNullExpressionValue(e, "next(...)");
                Terrain wonder = (Terrain)e;
                Object v = wonderCandidateTiles.get(wonder);
                Intrinsics.checkNotNull(v);
                $this$filter$iv = (Iterable)v;
                NaturalWonderGenerator naturalWonderGenerator = this;
                boolean $i$f$filter3 = false;
                Iterable it6 = $this$filter$iv;
                Collection destination$iv$iv5 = new ArrayList();
                boolean $i$f$filterTo3 = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv3) {
                    it = (Tile)element$iv$iv;
                    boolean bl8 = false;
                    if (!(!this.blockedTiles.contains(it))) continue;
                    destination$iv$iv5.add(element$iv$iv);
                }
                if (naturalWonderGenerator.trySpawnOnSuitableLocation(CollectionsKt.toList((List)destination$iv$iv5), wonder)) {
                    spawned.add(wonder);
                }
                if (spawned.size() < numberToSpawn) continue;
            }
        }
        object = new Object[]{spawned};
        LogKt.debug("Natural Wonders for this game: %s", (Object[])object);
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<Tile> getCandidateTilesForWonder(TileMap tileMap, Terrain naturalWonder, Set<Tile> tilesTooCloseToSpawnLocations) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = tileMap.getValues();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Tile tile = (Tile)element$iv$iv;
            boolean bl = false;
            if (!(tile.getResource() == null && !tilesTooCloseToSpawnLocations.contains(tile) && naturalWonder.getOccursOn().contains(tile.getLastTerrain().getName()) && Companion.fitsTerrainUniques(naturalWonder, tile))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List suitableLocations = (List)destination$iv$iv;
        return suitableLocations;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean trySpawnOnSuitableLocation(List<Tile> suitableLocations, Terrain wonder) {
        int targetGroupSize;
        int minGroupSize = 0;
        int maxGroupSize = 0;
        Unique groupUnique = (Unique)SequencesKt.firstOrNull(IHasUniques.getMatchingUniques$default(wonder, UniqueType.NaturalWonderGroups, null, 2, null));
        if (groupUnique == null) {
            minGroupSize = 1;
            maxGroupSize = 1;
        } else {
            minGroupSize = NaturalWonderGenerator.Companion.getIntParam(groupUnique, 0);
            maxGroupSize = NaturalWonderGenerator.Companion.getIntParam(groupUnique, 1);
        }
        int n = targetGroupSize = minGroupSize == maxGroupSize ? maxGroupSize : RangesKt.random(new IntRange(minGroupSize, maxGroupSize), this.randomness.getRNG());
        if (suitableLocations.size() >= minGroupSize) {
            Tile location = (Tile)CollectionsKt.random((Collection)suitableLocations, this.randomness.getRNG());
            Object object = new Tile[]{location};
            List<Tile> list2 = CollectionsKt.mutableListOf(object);
            while (list2.size() < targetGroupSize) {
                void $this$filterTo$iv$iv;
                void $this$flatMapTo$iv$iv;
                Iterable $this$flatMap$iv = list2;
                boolean $i$f$flatMapSequence = false;
                Iterable iterable = $this$flatMap$iv;
                Iterable destination$iv$iv = new ArrayList();
                boolean $i$f$flatMapSequenceTo = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                    Tile it = (Tile)element$iv$iv;
                    boolean bl = false;
                    Sequence<Tile> list$iv$iv = it.getNeighbors();
                    CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
                }
                HashSet allNeighbors = CollectionsKt.toHashSet(CollectionsKt.minus((Iterable)((List)destination$iv$iv), (Iterable)list2));
                Iterable $this$filter$iv = suitableLocations;
                boolean $i$f$filter = false;
                destination$iv$iv = $this$filter$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    Tile it = (Tile)element$iv$iv;
                    boolean bl = false;
                    if (!allNeighbors.contains(it)) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                List candidates = (List)destination$iv$iv2;
                if (candidates.isEmpty()) break;
                list2.add((Tile)CollectionsKt.random(candidates, this.randomness.getRNG()));
            }
            if (list2.size() >= minGroupSize) {
                for (Object e : list2) {
                    Intrinsics.checkNotNullExpressionValue(e, "next(...)");
                    Tile tileToConvert = (Tile)e;
                    Companion.placeNaturalWonder(wonder, tileToConvert);
                    CollectionsKt.addAll((Collection)this.blockedTiles, tileToConvert.getTilesInDistance(tileToConvert.getTileMap().getMapParameters().getMapSize().getHeight() / 5));
                }
                object = new Object[]{wonder.getName(), location.getPosition()};
                LogKt.debug("Natural Wonder %s @%s", (Object[])object);
                return true;
            }
        }
        Object[] objectArray = new Object[]{wonder.getName()};
        LogKt.debug("No suitable location for %s", objectArray);
        return false;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\tJ\u0014\u0010\u000e\u001a\u00020\u000f*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000fH\u0002J\u0018\u0010\u0012\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\tH\u0002J\u0014\u0010\u0013\u001a\u00020\u000b*\u00020\t2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J \u0010\u0016\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\t2\u000e\b\u0002\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00150\u0018H\u0002\u00a8\u0006\u0019"}, d2={"Lcom/unciv/logic/map/mapgenerator/NaturalWonderGenerator$Companion;", "", "<init>", "()V", "placeNaturalWonder", "", "wonder", "Lcom/unciv/models/ruleset/tile/Terrain;", "location", "Lcom/unciv/logic/map/tile/Tile;", "fitsTerrainUniques", "", "naturalWonderOrTerrainFeature", "tile", "getIntParam", "", "Lcom/unciv/models/ruleset/unique/Unique;", "index", "removeLakesNextToFutureCoast", "matchesWonderFilter", "filter", "", "clearTile", "exceptFeatures", "", "core"})
    @SourceDebugExtension(value={"SMAP\nNaturalWonderGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NaturalWonderGenerator.kt\ncom/unciv/logic/map/mapgenerator/NaturalWonderGenerator$Companion\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,320:1\n622#2:321\n1276#2,3:324\n1276#2,3:327\n1740#3,2:322\n1742#3:330\n774#3:331\n865#3,2:332\n*S KotlinDebug\n*F\n+ 1 NaturalWonderGenerator.kt\ncom/unciv/logic/map/mapgenerator/NaturalWonderGenerator$Companion\n*L\n188#1:321\n196#1:324,3\n203#1:327,3\n193#1:322,2\n193#1:330\n257#1:331\n257#1:332,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final void placeNaturalWonder(@NotNull Terrain wonder, @NotNull Tile location) {
            Intrinsics.checkNotNullParameter(wonder, "wonder");
            Intrinsics.checkNotNullParameter(location, "location");
            location.setNaturalWonder(wonder.getName());
            Terrain turnsIntoObject = (Terrain)((Map)location.getRuleset().getTerrains()).get(wonder.getTurnsInto());
            if (turnsIntoObject != null) {
                com.unciv.logic.map.mapgenerator.NaturalWonderGenerator$Companion.clearTile$default(this, location, null, 2, null);
                location.setBaseTerrain(turnsIntoObject);
            } else {
                this.clearTile(location, (List<String>)wonder.getOccursOn());
            }
            Sequence<Unique> conversionUniques = wonder.getMatchingUniques(UniqueType.NaturalWonderConvertNeighbors, GameContext.Companion.getIgnoreConditionals());
            if (SequencesKt.none(conversionUniques)) {
                return;
            }
            Iterator<Tile> iterator2 = location.getNeighbors().iterator();
            while (iterator2.hasNext()) {
                Tile tile = iterator2.next();
                GameContext state = new GameContext(null, null, null, tile, null, null, null, null, null, null, false, 2039, null);
                Iterator<Unique> iterator3 = conversionUniques.iterator();
                while (iterator3.hasNext()) {
                    Terrain terrainObject;
                    Unique unique = iterator3.next();
                    if (!unique.conditionalsApply(state)) continue;
                    String convertTo = unique.getParams().get(0);
                    if (Intrinsics.areEqual(tile.getBaseTerrain(), convertTo) || tile.getTerrainFeatures().contains(convertTo) || Intrinsics.areEqual(convertTo, "Lakes") && tile.isCoastalTile() || location.getRuleset().getTerrains().get(convertTo) == null || terrainObject.getType() == TerrainType.TerrainFeature && !terrainObject.getOccursOn().contains(tile.getBaseTerrain())) continue;
                    if (Intrinsics.areEqual(convertTo, "Coast")) {
                        this.removeLakesNextToFutureCoast(location, tile);
                    }
                    if (terrainObject.getType().isBaseTerrain()) {
                        com.unciv.logic.map.mapgenerator.NaturalWonderGenerator$Companion.clearTile$default(this, tile, null, 2, null);
                        tile.setBaseTerrain(terrainObject);
                    }
                    if (terrainObject.getType() != TerrainType.TerrainFeature) continue;
                    this.clearTile(tile, tile.getTerrainFeatures());
                    tile.addTerrainFeature(convertTo);
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        public final boolean fitsTerrainUniques(@NotNull Terrain naturalWonderOrTerrainFeature, @NotNull Tile tile) {
            boolean bl;
            block20: {
                List<Object> list2;
                boolean continentsRelevant;
                Intrinsics.checkNotNullParameter(naturalWonderOrTerrainFeature, "naturalWonderOrTerrainFeature");
                Intrinsics.checkNotNullParameter(tile, "tile");
                boolean bl2 = continentsRelevant = IHasUniques.hasUnique$default(naturalWonderOrTerrainFeature, UniqueType.NaturalWonderLargerLandmass, null, 2, null) || IHasUniques.hasUnique$default(naturalWonderOrTerrainFeature, UniqueType.NaturalWonderSmallerLandmass, null, 2, null);
                if (continentsRelevant) {
                    void $this$sortedByDescending$iv;
                    Sequence sequence = MapsKt.asSequence((Map)tile.getTileMap().getContinentSizes());
                    boolean $i$f$sortedByDescending = false;
                    list2 = SequencesKt.toList(SequencesKt.map(SequencesKt.sortedWith($this$sortedByDescending$iv, new Comparator(){

                        public final int compare(T a, T b) {
                            Map.Entry it = (Map.Entry)b;
                            boolean bl = false;
                            Comparable comparable = (Integer)it.getValue();
                            it = (Map.Entry)a;
                            Comparable comparable2 = comparable;
                            bl = false;
                            return ComparisonsKt.compareValues(comparable2, (Comparable)((Integer)it.getValue()));
                        }
                    }), Companion::fitsTerrainUniques$lambda$1));
                } else {
                    list2 = CollectionsKt.emptyList();
                }
                List sortedContinents = list2;
                Iterable $this$all$iv = naturalWonderOrTerrainFeature.getUniqueObjects();
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        boolean bl3;
                        Unique unique = (Unique)element$iv;
                        boolean bl4 = false;
                        UniqueType uniqueType = unique.getType();
                        switch (uniqueType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[uniqueType.ordinal()]) {
                            case 1: {
                                Tile it;
                                Tile element$iv2;
                                Sequence<Tile> $this$count$iv = tile.getNeighbors();
                                boolean $i$f$count = false;
                                int count$iv = 0;
                                Iterator<Tile> iterator2 = $this$count$iv.iterator();
                                while (iterator2.hasNext()) {
                                    it = element$iv2 = iterator2.next();
                                    boolean bl5 = false;
                                    if (!Companion.matchesWonderFilter(it, unique.getParams().get(1)) || ++count$iv >= 0) continue;
                                    CollectionsKt.throwCountOverflow();
                                }
                                int count2 = count$iv;
                                if (count2 == Companion.getIntParam(unique, 0)) {
                                    bl3 = true;
                                    break;
                                }
                                bl3 = false;
                                break;
                            }
                            case 2: {
                                Tile it;
                                Tile element$iv2;
                                Sequence<Tile> $this$count$iv = tile.getNeighbors();
                                boolean $i$f$count = false;
                                int count$iv = 0;
                                Iterator<Tile> iterator2 = $this$count$iv.iterator();
                                while (iterator2.hasNext()) {
                                    it = element$iv2 = iterator2.next();
                                    boolean bl6 = false;
                                    if (!Companion.matchesWonderFilter(it, unique.getParams().get(2)) || ++count$iv >= 0) continue;
                                    CollectionsKt.throwCountOverflow();
                                }
                                int count3 = count$iv;
                                int $this$count$iv2 = Companion.getIntParam(unique, 0);
                                if (count3 <= Companion.getIntParam(unique, 1)) {
                                    if ($this$count$iv2 <= count3) {
                                        bl3 = true;
                                        break;
                                    }
                                    bl3 = false;
                                    break;
                                }
                                bl3 = false;
                                break;
                            }
                            case 3: {
                                if (!CollectionsKt.take(sortedContinents, Companion.getIntParam(unique, 0)).contains(tile.getContinent())) {
                                    bl3 = true;
                                    break;
                                }
                                bl3 = false;
                                break;
                            }
                            case 4: {
                                bl3 = CollectionsKt.take(sortedContinents, Companion.getIntParam(unique, 0)).contains(tile.getContinent());
                                break;
                            }
                            case 5: {
                                float lower = tile.getTileMap().getMaxLatitude() * (float)Companion.getIntParam(unique, 0) * 0.01f;
                                float upper = tile.getTileMap().getMaxLatitude() * (float)Companion.getIntParam(unique, 1) * 0.01f;
                                float f = Math.abs(tile.getLatitude());
                                if (lower <= f) {
                                    if (f <= upper) {
                                        bl3 = true;
                                        break;
                                    }
                                    bl3 = false;
                                    break;
                                }
                                bl3 = false;
                                break;
                            }
                            default: {
                                bl3 = true;
                            }
                        }
                        if (bl3) continue;
                        bl = false;
                        break block20;
                    }
                    bl = true;
                }
            }
            return bl;
        }

        private final int getIntParam(Unique $this$getIntParam, int index) {
            return Integer.parseInt($this$getIntParam.getParams().get(index));
        }

        private final void removeLakesNextToFutureCoast(Tile location, Tile tile) {
            Iterator<Tile> iterator2 = tile.getNeighbors().iterator();
            while (iterator2.hasNext()) {
                Tile neighbor = iterator2.next();
                if (!Intrinsics.areEqual(neighbor.getBaseTerrain(), "Lakes")) continue;
                com.unciv.logic.map.mapgenerator.NaturalWonderGenerator$Companion.clearTile$default(this, neighbor, null, 2, null);
                neighbor.setBaseTerrain(tile.getBaseTerrain());
                neighbor.setTerrainTransients();
            }
            Tile.setConnectedByRiver$default(location, tile, false, false, 4, null);
        }

        private final boolean matchesWonderFilter(Tile $this$matchesWonderFilter, String filter2) {
            String string = filter2;
            return Intrinsics.areEqual(string, "Elevated") ? Intrinsics.areEqual($this$matchesWonderFilter.getBaseTerrain(), "Mountain") || $this$matchesWonderFilter.isHill() : (Intrinsics.areEqual(string, "Water") ? $this$matchesWonderFilter.isWater() : (Intrinsics.areEqual(string, "Land") ? $this$matchesWonderFilter.isLand() : (Intrinsics.areEqual(string, "Hill") ? $this$matchesWonderFilter.isHill() : (Intrinsics.areEqual(string, $this$matchesWonderFilter.getNaturalWonder()) ? true : (Intrinsics.areEqual(string, $this$matchesWonderFilter.getLastTerrain().getName()) ? true : Intrinsics.areEqual($this$matchesWonderFilter.getBaseTerrain(), filter2))))));
        }

        /*
         * WARNING - void declaration
         */
        private final void clearTile(Tile tile, List<String> exceptFeatures) {
            if (!((Collection)tile.getTerrainFeatures()).isEmpty() && !Intrinsics.areEqual(exceptFeatures, tile.getTerrainFeatures())) {
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                Iterable iterable = tile.getTerrainFeatures();
                Tile tile2 = tile;
                boolean $i$f$filter = false;
                void var5_6 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    String it = (String)element$iv$iv;
                    boolean bl = false;
                    if (!exceptFeatures.contains(it)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                tile2.setTerrainFeatures((List)destination$iv$iv);
            }
            tile.setResource(null);
            tile.removeImprovement();
            tile.setTerrainTransients();
        }

        static /* synthetic */ void clearTile$default(Companion companion, Tile tile, List list2, int n, Object object) {
            if ((n & 2) != 0) {
                list2 = CollectionsKt.emptyList();
            }
            companion.clearTile(tile, list2);
        }

        private static final int fitsTerrainUniques$lambda$1(Map.Entry it) {
            Intrinsics.checkNotNullParameter(it, "it");
            return ((Number)it.getKey()).intValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[UniqueType.values().length];
                try {
                    nArray[UniqueType.NaturalWonderNeighborCount.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[UniqueType.NaturalWonderNeighborsRange.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[UniqueType.NaturalWonderSmallerLandmass.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[UniqueType.NaturalWonderLargerLandmass.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[UniqueType.NaturalWonderLatitude.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

