/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.github;

import com.unciv.utils.LogKt;
import java.net.HttpURLConnection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u000e\u001a\u00020\u0007H\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0002J\u0006\u0010\u0011\u001a\u00020\u0010J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0016"}, d2={"Lcom/unciv/logic/github/RateLimit;", "", "<init>", "()V", "maxRequestsPerInterval", "", "intervalInMilliSeconds", "", "maxWaitLoop", "account", "firstRequest", "millis", "getMillis", "()J", "getWaitLength", "isLimitReached", "", "waitForLimit", "notifyHttpResponse", "", "response", "Ljava/net/HttpURLConnection;", "core"})
public final class RateLimit {
    @NotNull
    public static final RateLimit INSTANCE = new RateLimit();
    private static final int maxRequestsPerInterval = 10;
    private static final long intervalInMilliSeconds = 60000L;
    private static final int maxWaitLoop = 3;
    private static int account;
    private static long firstRequest;

    private RateLimit() {
    }

    private final long getMillis() {
        return System.currentTimeMillis();
    }

    private final long getWaitLength() {
        return firstRequest + 60000L - this.getMillis();
    }

    private final boolean isLimitReached() {
        long elapsed;
        long now = this.getMillis();
        long l = elapsed = firstRequest == 0L ? 60000L : now - firstRequest;
        if (elapsed >= 60000L) {
            firstRequest = now;
            account = 1;
            return false;
        }
        if (account >= 10) {
            return true;
        }
        int n = account;
        account = n + 1;
        return false;
    }

    public final boolean waitForLimit() {
        int loopCount = 0;
        while (this.isLimitReached()) {
            long waitLength = this.getWaitLength();
            try {
                Thread.sleep(waitLength);
            }
            catch (InterruptedException ex) {
                return true;
            }
            if (++loopCount < 3) continue;
            return true;
        }
        return false;
    }

    public final void notifyHttpResponse(@NotNull HttpURLConnection response2) {
        Intrinsics.checkNotNullParameter(response2, "response");
        if (!Intrinsics.areEqual(response2.getResponseMessage(), "rate limit exceeded") && response2.getResponseCode() != 200) {
            return;
        }
        int limit = (int)RateLimit.notifyHttpResponse$getHeaderLong(response2, "X-RateLimit-Limit", 10L);
        int remaining = (int)RateLimit.notifyHttpResponse$getHeaderLong$default(response2, "X-RateLimit-Remaining", 0L, 4, null);
        long reset = RateLimit.notifyHttpResponse$getHeaderLong$default(response2, "X-RateLimit-Reset", 0L, 4, null);
        if (limit != 10) {
            Object[] objectArray = new Object[]{limit, 10};
            LogKt.debug("GitHub API Limit reported via http (%s) not equal assumed value (%s)", objectArray);
        }
        account = 10 - remaining;
        if (reset == 0L) {
            return;
        }
        firstRequest = (reset + 1L) * 1000L - 60000L;
    }

    private static final long notifyHttpResponse$getHeaderLong(HttpURLConnection $response, String name, long l) {
        List<String> list2 = $response.getHeaderFields().get(name);
        return list2 != null && (list2 = list2.get(0)) != null && (list2 = StringsKt.toLongOrNull((String)((Object)list2))) != null ? (Long)((Object)list2) : l;
    }

    static /* synthetic */ long notifyHttpResponse$getHeaderLong$default(HttpURLConnection httpURLConnection, String string, long l, int n, Object object) {
        if ((n & 4) != 0) {
            l = 0L;
        }
        return RateLimit.notifyHttpResponse$getHeaderLong(httpURLConnection, string, l);
    }
}

