/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.github;

import com.badlogic.gdx.Files;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.utils.Json;
import com.unciv.json.UncivJsonKt;
import com.unciv.logic.BackwardCompatibility;
import com.unciv.logic.UncivShowableException;
import com.unciv.logic.github.Github;
import com.unciv.logic.github.GithubAPI;
import com.unciv.logic.github.KtorGithubAPI;
import com.unciv.logic.github.Zip;
import com.unciv.models.ruleset.ModOptions;
import com.unciv.utils.Concurrency;
import com.unciv.utils.Log;
import io.ktor.client.statement.HttpResponse;
import io.ktor.client.statement.HttpResponseKt;
import io.ktor.http.HttpStatusCodeKt;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.zip.ZipException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.CharsKt;
import kotlin.text.Charsets;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\f\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0003DEFB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00052\b\b\u0002\u0010\u0011\u001a\u00020\u00122\u0014\b\u0002\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u0014J0\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00182\u0016\b\u0002\u0010\u001c\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u0014J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0005H\u0002J\u001a\u0010 \u001a\u00020\u00052\b\u0010!\u001a\u0004\u0018\u00010\u00052\u0006\u0010\"\u001a\u00020\u0005H\u0002J\u0010\u0010#\u001a\u00020\u00122\u0006\u0010$\u001a\u00020\u0018H\u0002J$\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00050&2\u0006\u0010$\u001a\u00020\u00182\u0006\u0010'\u001a\u00020\u0005H\u0002J\u0018\u0010(\u001a\u00020\u00052\u0006\u0010)\u001a\u00020\u00052\u0006\u0010'\u001a\u00020\u0005H\u0002J\u0014\u0010*\u001a\u00020\u0016*\u00020\u00182\u0006\u0010+\u001a\u00020\u0018H\u0002J*\u0010,\u001a\u0004\u0018\u00010-2\u0006\u0010.\u001a\u00020\n2\u0006\u0010/\u001a\u00020\n2\b\b\u0002\u00100\u001a\u00020\u0005H\u0086@\u00a2\u0006\u0002\u00101J*\u00102\u001a\u0004\u0018\u0001032\u0006\u00104\u001a\u00020\u00052\u0006\u00105\u001a\u00020\u00052\b\u00106\u001a\u0004\u0018\u00010\u0005H\u0086@\u00a2\u0006\u0002\u00107J\u0016\u00108\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u001aH\u0086@\u00a2\u0006\u0002\u00109J\u0010\u0010:\u001a\u0004\u0018\u00010;H\u0086@\u00a2\u0006\u0002\u0010<J\u0016\u0010=\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010>\u001a\u00020\u0018J\u0014\u0010A\u001a\u00020\u0005*\u00020\u00052\b\b\u0002\u0010B\u001a\u00020\u0012J\n\u0010C\u001a\u00020\u0005*\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010?\u001a\u00020@X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006G"}, d2={"Lcom/unciv/logic/github/Github;", "", "<init>", "()V", "contentDispositionHeader", "", "parseAttachmentDispositionRegex", "Lkotlin/text/Regex;", "redirectingResponseCodes", "", "", "goodFolders", "", "goodFiles", "download", "Ljava/io/InputStream;", "url", "shouldLogError", "", "preDownloadAction", "Lkotlin/Function1;", "Ljava/net/HttpURLConnection;", "", "downloadAndExtract", "Lcom/badlogic/gdx/files/FileHandle;", "repo", "Lcom/unciv/logic/github/GithubAPI$Repo;", "modsFolder", "updateProgressPercent", "processRequestHandlingRedirects", "Lcom/unciv/logic/github/Github$RequestHandlingRedirectsResult;", "zipUrl", "parseNameFromDisposition", "disposition", "default", "isValidModFolder", "dir", "resolveZipStructure", "Lkotlin/Pair;", "defaultModName", "choosePrettierName", "folderName", "renameOrMove", "dest", "tryGetGithubReposWithTopic", "Lcom/unciv/logic/github/GithubAPI$RepoSearch;", "page", "amountPerPage", "searchRequest", "(IILjava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getPreviewImageOrNull", "Lcom/badlogic/gdx/graphics/Pixmap;", "modUrl", "defaultBranch", "avatarUrl", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getRepoSize", "(Lcom/unciv/logic/github/GithubAPI$Repo;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "tryGetGithubTopics", "Lcom/unciv/logic/github/GithubAPI$TopicSearchResponse;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "rewriteModOptions", "modFolder", "outerBlankReplacement", "", "repoNameToFolderName", "onlyOuterBlanks", "folderNameToRepoName", "RedirectionException", "RequestHandlingRedirectsResult", "CountingInputStream", "core"})
@SourceDebugExtension(value={"SMAP\nGithub.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Github.kt\ncom/unciv/logic/github/Github\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,478:1\n6482#2:479\n1761#3,3:480\n1563#3:484\n1634#3,3:485\n1563#3:488\n1634#3,3:489\n1#4:483\n*S KotlinDebug\n*F\n+ 1 Github.kt\ncom/unciv/logic/github/Github\n*L\n165#1:479\n302#1:480,3\n51#1:484\n51#1:485,3\n53#1:488\n53#1:489,3\n*E\n"})
public final class Github {
    @NotNull
    public static final Github INSTANCE;
    @NotNull
    private static final String contentDispositionHeader = "Content-Disposition";
    @NotNull
    private static final Regex parseAttachmentDispositionRegex;
    @NotNull
    private static final Set<Integer> redirectingResponseCodes;
    @NotNull
    private static final List<Regex> goodFolders;
    @NotNull
    private static final List<Regex> goodFiles;
    private static final char outerBlankReplacement = '=';

    private Github() {
    }

    @Nullable
    public final InputStream download(@NotNull String url, boolean shouldLogError, @NotNull Function1<? super HttpURLConnection, Unit> preDownloadAction) {
        Intrinsics.checkNotNullParameter(url, "url");
        Intrinsics.checkNotNullParameter(preDownloadAction, "preDownloadAction");
        try {
            URLConnection uRLConnection = new URI(url).toURL().openConnection();
            Intrinsics.checkNotNull(uRLConnection, "null cannot be cast to non-null type java.net.HttpURLConnection");
            HttpURLConnection $this$download_u24lambda_u243 = (HttpURLConnection)uRLConnection;
            boolean bl = false;
            preDownloadAction.invoke($this$download_u24lambda_u243);
            try {
                return $this$download_u24lambda_u243.getInputStream();
            }
            catch (Exception ex) {
                BufferedReader reader2 = new BufferedReader(new InputStreamReader($this$download_u24lambda_u243.getErrorStream(), Charsets.UTF_8));
                Object[] objectArray = new Object[]{TextStreamsKt.readText(reader2)};
                Log.INSTANCE.error("Message from GitHub: %s", objectArray);
                throw ex;
            }
        }
        catch (UncivShowableException ex) {
            throw ex;
        }
        catch (RedirectionException redirectionException) {
            return null;
        }
        catch (Exception ex) {
            if (shouldLogError) {
                Log.INSTANCE.error("Exception during GitHub download", ex);
            }
            return null;
        }
    }

    public static /* synthetic */ InputStream download$default(Github github, String string, boolean bl, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            function1 = Github::download$lambda$2;
        }
        return github.download(string, bl, function1);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final FileHandle downloadAndExtract(@NotNull GithubAPI.Repo repo, @NotNull FileHandle modsFolder, @Nullable Function1<? super Integer, Unit> updateProgressPercent) {
        void $this$sortedBy$iv;
        Intrinsics.checkNotNullParameter(repo, "repo");
        Intrinsics.checkNotNullParameter(modsFolder, "modsFolder");
        String modNameFromFileName = repo.getName();
        String defaultBranch = repo.getDefault_branch();
        String zipUrl = null;
        String tempName = null;
        if (((CharSequence)repo.getDirect_zip_url()).length() == 0) {
            String gitRepoUrl = repo.getHtml_url();
            zipUrl = GithubAPI.INSTANCE.getUrlForBranchZip$core(gitRepoUrl, defaultBranch);
            StringBuilder stringBuilder = new StringBuilder().append("temp-");
            String string = Integer.toString(gitRepoUrl.hashCode(), CharsKt.checkRadix(16));
            Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
            tempName = stringBuilder.append(string).toString();
        } else {
            zipUrl = repo.getDirect_zip_url();
            StringBuilder stringBuilder = new StringBuilder().append("temp-");
            String string = Integer.toString(repo.toString().hashCode(), CharsKt.checkRadix(16));
            Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
            tempName = stringBuilder.append(string).toString();
        }
        RequestHandlingRedirectsResult requestHandlingRedirectsResult = this.processRequestHandlingRedirects(zipUrl);
        InputStream inputStream = requestHandlingRedirectsResult.component1();
        Integer contentLength = requestHandlingRedirectsResult.component2();
        String disposition = requestHandlingRedirectsResult.component3();
        if (inputStream == null) {
            return null;
        }
        modNameFromFileName = this.parseNameFromDisposition(disposition, modNameFromFileName);
        Integer n = contentLength;
        int progressEndsAtSize = n != null ? n : repo.getSize() * 1024 * 4 / 5;
        InputStream countingStream = CountingInputStream.Companion.create(inputStream, progressEndsAtSize, updateProgressPercent);
        FileHandle tempZipFileHandle = modsFolder.child(tempName + ".zip");
        tempZipFileHandle.write(countingStream, false);
        FileHandle unzipDestination = tempZipFileHandle.sibling(tempName);
        if (unzipDestination.exists()) {
            boolean bl = unzipDestination.isDirectory() ? unzipDestination.deleteDirectory() : unzipDestination.delete();
        }
        try {
            Intrinsics.checkNotNull(tempZipFileHandle);
            Intrinsics.checkNotNull(unzipDestination);
            Zip.INSTANCE.extractFolder(tempZipFileHandle, unzipDestination);
        }
        catch (ZipException ex) {
            throw new UncivShowableException("That is not a valid ZIP file", ex);
        }
        Pair<FileHandle, String> pair = this.resolveZipStructure(unzipDestination, modNameFromFileName);
        FileHandle innerFolder = pair.component1();
        String modName = pair.component2();
        String finalDestinationName = Github.repoNameToFolderName$default(this, StringsKt.replace$default(modName, '-' + defaultBranch, "", false, 4, null), false, 1, null);
        FileHandle finalDestination = modsFolder.child(finalDestinationName);
        FileHandle tempBackup = null;
        if (finalDestination.exists()) {
            tempBackup = finalDestination.sibling(finalDestinationName + ".updating");
            Intrinsics.checkNotNull(finalDestination);
            FileHandle fileHandle = tempBackup;
            Intrinsics.checkNotNull(fileHandle);
            this.renameOrMove(finalDestination, fileHandle);
        }
        finalDestination.mkdirs();
        FileHandle[] fileHandleArray = innerFolder.list();
        Intrinsics.checkNotNullExpressionValue(fileHandleArray, "list(...)");
        Object[] objectArray = fileHandleArray;
        boolean $i$f$sortedBy = false;
        for (FileHandle innerFileOrFolder : ArraysKt.sortedWith($this$sortedBy$iv, new Comparator(){

            public final int compare(T a, T b) {
                FileHandle file = (FileHandle)a;
                boolean bl = false;
                Comparable comparable = Boolean.valueOf(Intrinsics.areEqual(file.extension(), "atlas"));
                file = (FileHandle)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, Intrinsics.areEqual(file.extension(), "atlas"));
            }
        })) {
            Intrinsics.checkNotNull(innerFileOrFolder);
            Intrinsics.checkNotNull(finalDestination);
            this.renameOrMove(innerFileOrFolder, finalDestination);
        }
        tempZipFileHandle.delete();
        unzipDestination.deleteDirectory();
        if (tempBackup != null) {
            boolean bl = tempBackup.isDirectory() ? tempBackup.deleteDirectory() : tempBackup.delete();
        }
        return finalDestination;
    }

    public static /* synthetic */ FileHandle downloadAndExtract$default(Github github, GithubAPI.Repo repo, FileHandle fileHandle, Function1 function1, int n, Object object) {
        if ((n & 4) != 0) {
            function1 = null;
        }
        return github.downloadAndExtract(repo, fileHandle, function1);
    }

    private final RequestHandlingRedirectsResult processRequestHandlingRedirects(String zipUrl) {
        Ref.IntRef redirectCount = new Ref.IntRef();
        Ref.ObjectRef currentUrl = new Ref.ObjectRef();
        currentUrl.element = zipUrl;
        InputStream inputStream = null;
        Ref.ObjectRef contentLength = new Ref.ObjectRef();
        Ref.ObjectRef disposition = new Ref.ObjectRef();
        while (redirectCount.element < 2 && (inputStream = Github.download$default(this, (String)currentUrl.element, false, arg_0 -> Github.processRequestHandlingRedirects$lambda$5(currentUrl, redirectCount, disposition, contentLength, arg_0), 2, null)) == null) {
        }
        return new RequestHandlingRedirectsResult(inputStream, (Integer)contentLength.element, (String)disposition.element);
    }

    private final String parseNameFromDisposition(String disposition, String string) {
        if (disposition == null) {
            return Github.parseNameFromDisposition$removeZipExtension(string);
        }
        MatchResult matchResult = parseAttachmentDispositionRegex.matchAt(disposition, 0);
        if (matchResult == null) {
            return Github.parseNameFromDisposition$removeZipExtension(string);
        }
        MatchResult match = matchResult;
        MatchGroup matchGroup = match.getGroups().get(2);
        Intrinsics.checkNotNull(matchGroup);
        return Github.parseNameFromDisposition$removeZipExtension(matchGroup.getValue());
    }

    private final boolean isValidModFolder(FileHandle dir) {
        int good = 0;
        int bad = 0;
        Iterator<FileHandle> iterator2 = ArrayIteratorKt.iterator(dir.list());
        while (iterator2.hasNext()) {
            boolean bl;
            block5: {
                FileHandle file = iterator2.next();
                List<Regex> goodList = file.isDirectory() ? goodFolders : goodFiles;
                Iterable $this$any$iv = goodList;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Regex it = (Regex)element$iv;
                        boolean bl2 = false;
                        String string = file.name();
                        Intrinsics.checkNotNullExpressionValue(string, "name(...)");
                        if (!it.matches(string)) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
            if (bl) {
                ++good;
                continue;
            }
            ++bad;
        }
        return good > 0 && good > bad;
    }

    private final Pair<FileHandle, String> resolveZipStructure(FileHandle dir, String defaultModName) {
        FileHandle[] subdirs;
        block5: {
            block4: {
                if (this.isValidModFolder(dir)) {
                    return TuplesKt.to(dir, defaultModName);
                }
                subdirs = dir.list(Github::resolveZipStructure$lambda$7);
                if (subdirs.length != 1) break block4;
                FileHandle fileHandle = subdirs[0];
                Intrinsics.checkNotNullExpressionValue(fileHandle, "get(...)");
                if (this.isValidModFolder(fileHandle)) break block5;
            }
            throw new UncivShowableException("Invalid Mod archive structure", null, 2, null);
        }
        FileHandle fileHandle = subdirs[0];
        String string = subdirs[0].name();
        Intrinsics.checkNotNullExpressionValue(string, "name(...)");
        return TuplesKt.to(fileHandle, this.choosePrettierName(string, defaultModName));
    }

    private final String choosePrettierName(String folderName, String defaultModName) {
        if (StringsKt.startsWith(defaultModName, folderName, true) && Github.choosePrettierName$isMixedCase(defaultModName) && !Github.choosePrettierName$isMixedCase(folderName)) {
            return StringsKt.removeSuffix(StringsKt.removeSuffix(defaultModName, (CharSequence)"-main"), (CharSequence)"-master");
        }
        return folderName;
    }

    private final void renameOrMove(FileHandle $this$renameOrMove, FileHandle dest) {
        if ($this$renameOrMove.type() == Files.FileType.Local && $this$renameOrMove.isDirectory()) {
            if ($this$renameOrMove.file().renameTo(dest.child($this$renameOrMove.name()).file())) {
                return;
            }
            if ($this$renameOrMove.file().renameTo(dest.file())) {
                return;
            }
        }
        $this$renameOrMove.moveTo(dest);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object tryGetGithubReposWithTopic(int page, int amountPerPage, @NotNull String searchRequest, @NotNull Continuation<? super GithubAPI.RepoSearch> $completion) {
        if (!($completion instanceof tryGetGithubReposWithTopic.1)) ** GOTO lbl-1000
        var9_5 = $completion;
        if ((var9_5.label & -2147483648) != 0) {
            var9_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                int I$0;
                int I$1;
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ Github this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.tryGetGithubReposWithTopic(0, 0, null, this);
                }
            };
        }
        $result = $continuation.result;
        var10_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure($result);
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable(searchRequest);
                $continuation.I$0 = page;
                $continuation.I$1 = amountPerPage;
                $continuation.label = 1;
                v0 = KtorGithubAPI.INSTANCE.fetchGithubReposWithTopic(searchRequest, page, amountPerPage, $continuation);
                if (v0 == var10_7) {
                    return var10_7;
                }
                ** GOTO lbl26
            }
            case 1: {
                amountPerPage = $continuation.I$1;
                page = $continuation.I$0;
                searchRequest = (String)$continuation.L$0;
                ResultKt.throwOnFailure($result);
                v0 = $result;
lbl26:
                // 2 sources

                if (!HttpStatusCodeKt.isSuccess((resp = (HttpResponse)v0).getStatus())) break;
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable(searchRequest);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable(resp);
                $continuation.I$0 = page;
                $continuation.I$1 = amountPerPage;
                $continuation.label = 2;
                v1 = HttpResponseKt.bodyAsText$default(resp, null, $continuation, 1, null);
                if (v1 == var10_7) {
                    return var10_7;
                }
                ** GOTO lbl43
            }
            case 2: {
                amountPerPage = $continuation.I$1;
                page = $continuation.I$0;
                resp = (HttpResponse)$continuation.L$1;
                searchRequest = (String)$continuation.L$0;
                ResultKt.throwOnFailure($result);
                v1 = $result;
lbl43:
                // 2 sources

                text = (String)v1;
                try {
                    return UncivJsonKt.json().fromJson(GithubAPI.RepoSearch.class, text);
                }
                catch (Throwable <unused var>) {
                    throw new Exception("Failed to parse Github response as json - " + text);
                }
            }
        }
        return null;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static /* synthetic */ Object tryGetGithubReposWithTopic$default(Github github, int n, int n2, String string, Continuation continuation2, int n3, Object object) {
        if ((n3 & 4) != 0) {
            string = "";
        }
        return github.tryGetGithubReposWithTopic(n, n2, string, continuation2);
    }

    /*
     * Exception decompiling
     */
    @Nullable
    public final Object getPreviewImageOrNull(@NotNull String modUrl, @NotNull String defaultBranch, @Nullable String avatarUrl, @NotNull Continuation<? super Pixmap> $completion) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[SWITCH], 9[CASE]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object getRepoSize(@NotNull GithubAPI.Repo repo, @NotNull Continuation<? super Integer> $completion) {
        if (!($completion instanceof getRepoSize.1)) ** GOTO lbl-1000
        var13_3 = $completion;
        if ((var13_3.label & -2147483648) != 0) {
            var13_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                /* synthetic */ Object result;
                final /* synthetic */ Github this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.getRepoSize(null, this);
                }
            };
        }
        $result = $continuation.result;
        var14_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure($result);
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable(repo);
                $continuation.label = 1;
                v0 = GithubAPI.INSTANCE.fetchReleaseZip$core(repo, $continuation);
                if (v0 == var14_5) {
                    return var14_5;
                }
                ** GOTO lbl22
            }
            case 1: {
                repo = (GithubAPI.Repo)$continuation.L$0;
                ResultKt.throwOnFailure($result);
                v0 = $result;
lbl22:
                // 2 sources

                if (!HttpStatusCodeKt.isSuccess((resp = (HttpResponse)v0).getStatus())) break;
                var10_7 = GithubAPI.Tree.class;
                var9_8 = UncivJsonKt.json();
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable(repo);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable(resp);
                $continuation.L$2 = var9_8;
                $continuation.L$3 = var10_7;
                $continuation.label = 2;
                v1 = HttpResponseKt.bodyAsText$default(resp, null, $continuation, 1, null);
                if (v1 == var14_5) {
                    return var14_5;
                }
                ** GOTO lbl41
            }
            case 2: {
                var10_7 = (Class<GithubAPI.Tree>)$continuation.L$3;
                var9_8 = (Json)$continuation.L$2;
                resp = (HttpResponse)$continuation.L$1;
                repo = (GithubAPI.Repo)$continuation.L$0;
                ResultKt.throwOnFailure($result);
                v1 = $result;
lbl41:
                // 2 sources

                if ((tree = var9_8.fromJson(var10_7, (String)(var11_9 = v1))).getTruncated()) {
                    return Boxing.boxInt(-1);
                }
                totalSizeBytes = 0L;
                v2 = tree.getTree().iterator();
                Intrinsics.checkNotNullExpressionValue(v2, "iterator(...)");
                var7_12 = v2;
                while (var7_12.hasNext()) {
                    Intrinsics.checkNotNullExpressionValue(var7_12.next(), "next(...)");
                    totalSizeBytes += file.getSize();
                }
                return Boxing.boxInt((int)((totalSizeBytes + (long)512) / (long)1024));
            }
        }
        return Boxing.boxInt(-1);
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object tryGetGithubTopics(@NotNull Continuation<? super GithubAPI.TopicSearchResponse> $completion) {
        if (!($completion instanceof tryGetGithubTopics.1)) ** GOTO lbl-1000
        var7_2 = $completion;
        if ((var7_2.label & -2147483648) != 0) {
            var7_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ Github this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.tryGetGithubTopics(this);
                }
            };
        }
        $result = $continuation.result;
        var8_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure($result);
                $continuation.label = 1;
                v0 = KtorGithubAPI.INSTANCE.fetchGithubTopics($continuation);
                if (v0 == var8_4) {
                    return var8_4;
                }
                ** GOTO lbl20
            }
            case 1: {
                ResultKt.throwOnFailure($result);
                v0 = $result;
lbl20:
                // 2 sources

                if (!HttpStatusCodeKt.isSuccess((resp = (HttpResponse)v0).getStatus())) break;
                var4_6 = GithubAPI.TopicSearchResponse.class;
                var3_7 = UncivJsonKt.json();
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable(resp);
                $continuation.L$1 = var3_7;
                $continuation.L$2 = var4_6;
                $continuation.label = 2;
                v1 = HttpResponseKt.bodyAsText$default(resp, null, $continuation, 1, null);
                if (v1 == var8_4) {
                    return var8_4;
                }
                ** GOTO lbl37
            }
            case 2: {
                var4_6 = (Class<GithubAPI.TopicSearchResponse>)$continuation.L$2;
                var3_7 = (Json)$continuation.L$1;
                resp = (HttpResponse)$continuation.L$0;
                ResultKt.throwOnFailure($result);
                v1 = $result;
lbl37:
                // 2 sources

                var5_8 = v1;
                return var3_7.fromJson(var4_6, (String)var5_8);
            }
        }
        return null;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public final void rewriteModOptions(@NotNull GithubAPI.Repo repo, @NotNull FileHandle modFolder) {
        boolean overwriteAlways;
        ModOptions modOptions;
        Intrinsics.checkNotNullParameter(repo, "repo");
        Intrinsics.checkNotNullParameter(modFolder, "modFolder");
        FileHandle modOptionsFile = modFolder.child("jsons/ModOptions.json");
        if (modOptionsFile.exists()) {
            Json json = UncivJsonKt.json();
            Intrinsics.checkNotNull(modOptionsFile);
            modOptions = UncivJsonKt.fromJsonFile(json, ModOptions.class, modOptionsFile);
        } else {
            modOptions = new ModOptions();
        }
        ModOptions modOptions2 = modOptions;
        boolean bl = overwriteAlways = ((CharSequence)repo.getDirect_zip_url()).length() == 0;
        if (overwriteAlways || ((CharSequence)modOptions2.getModUrl()).length() == 0) {
            modOptions2.setModUrl(repo.getHtml_url());
        }
        if (overwriteAlways || Intrinsics.areEqual(modOptions2.getDefaultBranch(), "master") && ((CharSequence)repo.getDefault_branch()).length() > 0) {
            modOptions2.setDefaultBranch(repo.getDefault_branch());
        }
        if (overwriteAlways || ((CharSequence)modOptions2.getLastUpdated()).length() == 0) {
            modOptions2.setLastUpdated(repo.getPushed_at());
        }
        if (overwriteAlways || ((CharSequence)modOptions2.getAuthor()).length() == 0) {
            modOptions2.setAuthor(repo.getOwner().getLogin());
        }
        if (overwriteAlways || modOptions2.getModSize() == 0) {
            modOptions2.setModSize(repo.getSize());
        }
        if (overwriteAlways || modOptions2.getTopics().isEmpty()) {
            modOptions2.setTopics(repo.getTopics());
        }
        BackwardCompatibility.INSTANCE.updateDeprecations(modOptions2);
        UncivJsonKt.json().toJson((Object)modOptions2, modOptionsFile);
    }

    @NotNull
    public final String repoNameToFolderName(@NotNull String $this$repoNameToFolderName, boolean onlyOuterBlanks) {
        String result2;
        Intrinsics.checkNotNullParameter($this$repoNameToFolderName, "<this>");
        String string = result2 = onlyOuterBlanks ? $this$repoNameToFolderName : StringsKt.replace$default($this$repoNameToFolderName, '-', ' ', false, 4, null);
        if (StringsKt.endsWith$default((CharSequence)result2, ' ', false, 2, null)) {
            result2 = ((Object)StringsKt.trimEnd((CharSequence)result2)).toString() + '=';
        }
        if (StringsKt.startsWith$default((CharSequence)result2, ' ', false, 2, null)) {
            char c = '=';
            String string2 = ((Object)StringsKt.trimStart((CharSequence)result2)).toString();
            result2 = c + string2;
        }
        return result2;
    }

    public static /* synthetic */ String repoNameToFolderName$default(Github github, String string, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return github.repoNameToFolderName(string, bl);
    }

    @NotNull
    public final String folderNameToRepoName(@NotNull String $this$folderNameToRepoName) {
        Intrinsics.checkNotNullParameter($this$folderNameToRepoName, "<this>");
        String result2 = StringsKt.replace$default($this$folderNameToRepoName, ' ', '-', false, 4, null);
        if (StringsKt.endsWith$default((CharSequence)result2, '=', false, 2, null)) {
            char[] cArray = new char[]{'='};
            result2 = StringsKt.trimEnd(result2, cArray) + '-';
        }
        if (StringsKt.startsWith$default((CharSequence)result2, '=', false, 2, null)) {
            char c = '-';
            Object object = new char[]{'='};
            object = StringsKt.trimStart(result2, object);
            result2 = c + (String)object;
        }
        return result2;
    }

    private static final Unit download$lambda$2(HttpURLConnection it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return Unit.INSTANCE;
    }

    private static final Unit processRequestHandlingRedirects$lambda$5(Ref.ObjectRef $currentUrl, Ref.IntRef $redirectCount, Ref.ObjectRef $disposition, Ref.ObjectRef $contentLength, HttpURLConnection it) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter(it, "it");
        int responseCode = it.getResponseCode();
        String location = it.getHeaderField("Location");
        if (redirectingResponseCodes.contains(responseCode) && !((charSequence = (CharSequence)location) == null || charSequence.length() == 0)) {
            $currentUrl.element = location;
            int n = $redirectCount.element;
            $redirectCount.element = n + 1;
            throw new RedirectionException();
        }
        if (responseCode == 403 && it.getHeaderField("CF-RAY") != null) {
            String string = it.getHeaderField("cf-mitigated");
            if (string == null) {
                string = "";
            }
            if (Intrinsics.areEqual(string, "challenge")) {
                throw new UncivShowableException("Blocked by Cloudflare", null, 2, null);
            }
        }
        boolean bl = 401 <= responseCode ? responseCode < 404 : false;
        if (bl || responseCode == 407) {
            throw new UncivShowableException("Servers requiring authentication are not supported", null, 2, null);
        }
        boolean bl2 = 300 <= responseCode ? responseCode < 500 : false;
        if (bl2) {
            throw new UncivShowableException("Unexpected response: [" + it.getResponseMessage() + ']', null, 2, null);
        }
        boolean bl3 = 500 <= responseCode ? responseCode < 600 : false;
        if (bl3) {
            throw new UncivShowableException("Server failure: [" + it.getResponseMessage() + ']', null, 2, null);
        }
        $disposition.element = it.getHeaderField(contentDispositionHeader);
        String string = it.getHeaderField("Content-Length");
        $contentLength.element = string != null ? StringsKt.toIntOrNull(string) : null;
        return Unit.INSTANCE;
    }

    private static final String parseNameFromDisposition$removeZipExtension(String $this$parseNameFromDisposition_u24removeZipExtension) {
        return StringsKt.replace$default(StringsKt.removeSuffix($this$parseNameFromDisposition_u24removeZipExtension, (CharSequence)".zip"), '.', ' ', false, 4, null);
    }

    private static final boolean resolveZipStructure$lambda$7(File it) {
        return it.isDirectory();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean choosePrettierName$isMixedCase(String $this$choosePrettierName_u24isMixedCase) {
        String string = $this$choosePrettierName_u24isMixedCase.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
        if (Intrinsics.areEqual($this$choosePrettierName_u24isMixedCase, string)) return false;
        String string2 = $this$choosePrettierName_u24isMixedCase.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string2, "toUpperCase(...)");
        if (Intrinsics.areEqual($this$choosePrettierName_u24isMixedCase, string2)) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        String it;
        Collection collection;
        Object item$iv$iv;
        Object $this$mapTo$iv$iv;
        INSTANCE = new Github();
        parseAttachmentDispositionRegex = new Regex("attachment;\\s*filename\\s*=\\s*([\"'])?(.*?)\\1(;|$)");
        Object[] objectArray = new Integer[]{301, 302, 303, 307, 308};
        redirectingResponseCodes = SetsKt.setOf(objectArray);
        objectArray = new String[]{"Images", "jsons", "maps", "music", "sounds", "Images\\..*", "scenarios", ".github"};
        Object $this$map$iv = (String[])CollectionsKt.listOf(objectArray);
        boolean $i$f$map = false;
        String[] stringArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            item$iv$iv = iterator2.next();
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Regex(it, RegexOption.IGNORE_CASE));
        }
        goodFolders = (List)destination$iv$iv;
        $this$map$iv = new String[]{".*\\.atlas", ".*\\.png", "preview.jpg", ".*\\.md", "Atlases.json", ".nomedia", "license", "contribute.md", "readme.md", "credits.md"};
        $this$map$iv = CollectionsKt.listOf($this$map$iv);
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        $i$f$mapTo = false;
        iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            item$iv$iv = iterator2.next();
            it = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Regex(it, RegexOption.IGNORE_CASE));
        }
        goodFiles = (List)var3_3;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0002\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B-\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\r\u001a\u00020\u0004H\u0016J\b\u0010\u000e\u001a\u00020\u0007H\u0016J\u0006\u0010\u000f\u001a\u00020\u0004J\b\u0010\u0010\u001a\u00020\u0007H\u0002J\b\u0010\u0011\u001a\u00020\u0007H\u0002R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/unciv/logic/github/Github$CountingInputStream;", "Ljava/io/InputStream;", "wrapped", "contentLength", "", "updateProgressPercent", "Lkotlin/Function1;", "", "<init>", "(Ljava/io/InputStream;ILkotlin/jvm/functions/Function1;)V", "count", "trackerThread", "Lkotlinx/coroutines/Job;", "read", "close", "bytesRead", "startTracking", "stopTracking", "Companion", "core"})
    private static final class CountingInputStream
    extends InputStream {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final InputStream wrapped;
        private final int contentLength;
        @NotNull
        private final Function1<Integer, Unit> updateProgressPercent;
        private int count;
        @Nullable
        private Job trackerThread;

        private CountingInputStream(InputStream wrapped, int contentLength, Function1<? super Integer, Unit> updateProgressPercent) {
            this.wrapped = wrapped;
            this.contentLength = contentLength;
            this.updateProgressPercent = updateProgressPercent;
        }

        @Override
        public int read() {
            int n = this.count;
            this.count = n + 1;
            return this.wrapped.read();
        }

        @Override
        public void close() {
            this.stopTracking();
            super.close();
        }

        public final int bytesRead() {
            return this.count;
        }

        private final void startTracking() {
            this.trackerThread = Concurrency.run$default(Concurrency.INSTANCE, "Downloading mod progress", null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int I$0;
                int label;
                private /* synthetic */ Object L$0;
                final /* synthetic */ CountingInputStream this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object $result) {
                    var2_2 = (CoroutineScope)this.L$0;
                    var4_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    block0 : switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure($result);
lbl6:
                            // 3 sources

                            while (CoroutineScopeKt.isActive((CoroutineScope)$this$run)) {
                                percentage = (int)((long)this.this$0.bytesRead() * 100L / (long)CountingInputStream.access$getContentLength$p(this.this$0));
                                CountingInputStream.access$getUpdateProgressPercent$p(this.this$0).invoke(Boxing.boxInt(RangesKt.coerceIn(percentage, 0, 100)));
                                if (percentage >= 100) {
                                    CountingInputStream.access$stopTracking(this.this$0);
                                    break block0;
                                }
                                this.L$0 = $this$run;
                                this.I$0 = percentage;
                                this.label = 1;
                                v0 = DelayKt.delay(100L, this);
                                if (v0 != var4_3) continue;
                                return var4_3;
                            }
                            break;
                        }
                        case 1: {
                            percentage = this.I$0;
                            ResultKt.throwOnFailure($result);
                            v0 = $result;
                            ** GOTO lbl6
                        }
                    }
                    return Unit.INSTANCE;
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                    function2.L$0 = value;
                    return (Continuation)((Object)function2);
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }, 2, null);
        }

        private final void stopTracking() {
            Job job2 = this.trackerThread;
            if (job2 != null) {
                Job.DefaultImpls.cancel$default(job2, null, 1, null);
            }
            this.trackerThread = null;
        }

        public /* synthetic */ CountingInputStream(InputStream wrapped, int contentLength, Function1 updateProgressPercent, DefaultConstructorMarker $constructor_marker) {
            this(wrapped, contentLength, updateProgressPercent);
        }

        public static final /* synthetic */ int access$getContentLength$p(CountingInputStream $this) {
            return $this.contentLength;
        }

        public static final /* synthetic */ Function1 access$getUpdateProgressPercent$p(CountingInputStream $this) {
            return $this.updateProgressPercent;
        }

        public static final /* synthetic */ void access$stopTracking(CountingInputStream $this) {
            $this.stopTracking();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0014\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n\u00a8\u0006\f"}, d2={"Lcom/unciv/logic/github/Github$CountingInputStream$Companion;", "", "<init>", "()V", "create", "Ljava/io/InputStream;", "originalStream", "contentLength", "", "updateProgressPercent", "Lkotlin/Function1;", "", "core"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final InputStream create(@NotNull InputStream originalStream, int contentLength, @Nullable Function1<? super Integer, Unit> updateProgressPercent) {
                Intrinsics.checkNotNullParameter(originalStream, "originalStream");
                if (updateProgressPercent == null || contentLength <= 0) {
                    return originalStream;
                }
                CountingInputStream newStream = new CountingInputStream(originalStream, contentLength, updateProgressPercent, null);
                newStream.startTracking();
                return newStream;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lcom/unciv/logic/github/Github$RedirectionException;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "<init>", "()V", "core"})
    private static final class RedirectionException
    extends Exception {
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0082\b\u0018\u00002\u00020\u0001B%\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000b\u0010\u0011\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003\u00a2\u0006\u0002\u0010\rJ\u000b\u0010\u0013\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J2\u0010\u0014\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0015J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u0007H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0015\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001b"}, d2={"Lcom/unciv/logic/github/Github$RequestHandlingRedirectsResult;", "", "stream", "Ljava/io/InputStream;", "length", "", "disposition", "", "<init>", "(Ljava/io/InputStream;Ljava/lang/Integer;Ljava/lang/String;)V", "getStream", "()Ljava/io/InputStream;", "getLength", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getDisposition", "()Ljava/lang/String;", "component1", "component2", "component3", "copy", "(Ljava/io/InputStream;Ljava/lang/Integer;Ljava/lang/String;)Lcom/unciv/logic/github/Github$RequestHandlingRedirectsResult;", "equals", "", "other", "hashCode", "toString", "core"})
    private static final class RequestHandlingRedirectsResult {
        @Nullable
        private final InputStream stream;
        @Nullable
        private final Integer length;
        @Nullable
        private final String disposition;

        public RequestHandlingRedirectsResult(@Nullable InputStream stream, @Nullable Integer length, @Nullable String disposition) {
            this.stream = stream;
            this.length = length;
            this.disposition = disposition;
        }

        @Nullable
        public final InputStream getStream() {
            return this.stream;
        }

        @Nullable
        public final Integer getLength() {
            return this.length;
        }

        @Nullable
        public final String getDisposition() {
            return this.disposition;
        }

        @Nullable
        public final InputStream component1() {
            return this.stream;
        }

        @Nullable
        public final Integer component2() {
            return this.length;
        }

        @Nullable
        public final String component3() {
            return this.disposition;
        }

        @NotNull
        public final RequestHandlingRedirectsResult copy(@Nullable InputStream stream, @Nullable Integer length, @Nullable String disposition) {
            return new RequestHandlingRedirectsResult(stream, length, disposition);
        }

        public static /* synthetic */ RequestHandlingRedirectsResult copy$default(RequestHandlingRedirectsResult requestHandlingRedirectsResult, InputStream inputStream, Integer n, String string, int n2, Object object) {
            if ((n2 & 1) != 0) {
                inputStream = requestHandlingRedirectsResult.stream;
            }
            if ((n2 & 2) != 0) {
                n = requestHandlingRedirectsResult.length;
            }
            if ((n2 & 4) != 0) {
                string = requestHandlingRedirectsResult.disposition;
            }
            return requestHandlingRedirectsResult.copy(inputStream, n, string);
        }

        @NotNull
        public String toString() {
            return "RequestHandlingRedirectsResult(stream=" + this.stream + ", length=" + this.length + ", disposition=" + this.disposition + ')';
        }

        public int hashCode() {
            int result2 = this.stream == null ? 0 : this.stream.hashCode();
            result2 = result2 * 31 + (this.length == null ? 0 : ((Object)this.length).hashCode());
            result2 = result2 * 31 + (this.disposition == null ? 0 : this.disposition.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RequestHandlingRedirectsResult)) {
                return false;
            }
            RequestHandlingRedirectsResult requestHandlingRedirectsResult = (RequestHandlingRedirectsResult)other;
            if (!Intrinsics.areEqual(this.stream, requestHandlingRedirectsResult.stream)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.length, requestHandlingRedirectsResult.length)) {
                return false;
            }
            return Intrinsics.areEqual(this.disposition, requestHandlingRedirectsResult.disposition);
        }
    }
}

