/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.files;

import com.badlogic.gdx.Files;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.GlyphLayout;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.List;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.ui.TextField;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.utils.Array;
import com.unciv.UncivGame;
import com.unciv.logic.files.UncivFiles;
import com.unciv.models.UncivSound;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.widgets.AutoScrollPane;
import com.unciv.ui.components.widgets.UncivTextField;
import com.unciv.ui.popups.ConfirmPopup;
import com.unciv.ui.popups.Popup;
import java.io.File;
import java.io.FileFilter;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0017\b\u0016\u0018\u0000 Q2\u00020\u0001:\u0003OPQBg\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012@\b\u0002\u0010\b\u001a:\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\u000e\u0012\u0004\u0012\u00020\u000f\u0018\u00010\tj\u0004\u0018\u0001`\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012J\b\u0010B\u001a\u00020;H\u0016J\u0010\u0010C\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\nH\u0002J\u0010\u0010D\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0007H\u0002J\u0010\u0010E\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0007H\u0002J\u0012\u0010F\u001a\u00020\u000f2\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0002J\b\u0010G\u001a\u00020\u000fH\u0002J\u0010\u0010H\u001a\u00020\u000f2\u0006\u0010I\u001a\u00020\u0007H\u0002J\b\u0010J\u001a\u00020\u0007H\u0002J\b\u0010K\u001a\u00020\u000fH\u0002J\b\u0010L\u001a\u00020\u000fH\u0002J\u000e\u0010M\u001a\u00020\u000f2\u0006\u0010N\u001a\u00020\u0005RF\u0010\b\u001a:\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\u000e\u0012\u0004\u0012\u00020\u000f\u0018\u00010\tj\u0004\u0018\u0001`\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u0014@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R$\u0010\u001a\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\n@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR$\u0010\u001f\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\n@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u001c\"\u0004\b!\u0010\u001eR$\u0010\"\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\n@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u001c\"\u0004\b$\u0010\u001eR$\u0010%\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\n8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b&\u0010\u001c\"\u0004\b'\u0010\u001eR\u000e\u0010(\u001a\u00020)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020+X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020-X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010.\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001000/X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u00020+X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00102\u001a\u00020+X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00103\u001a\u00020-X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00104\u001a\u000205X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00106\u001a\u000207X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00108\u001a\u000209X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010:\u001a\u00020;X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010<\u001a\n =*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010>\u001a\n =*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010?\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010@\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010A\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006R"}, d2={"Lcom/unciv/logic/files/FileChooser;", "Lcom/unciv/ui/popups/Popup;", "stageToShowOn", "Lcom/badlogic/gdx/scenes/scene2d/Stage;", "title", "", "startFile", "Lcom/badlogic/gdx/files/FileHandle;", "resultListener", "Lkotlin/Function2;", "", "Lkotlin/ParameterName;", "name", "success", "file", "", "Lcom/unciv/logic/files/ResultListener;", "<init>", "(Lcom/badlogic/gdx/scenes/scene2d/Stage;Ljava/lang/String;Lcom/badlogic/gdx/files/FileHandle;Lkotlin/jvm/functions/Function2;)V", "value", "Ljava/io/FileFilter;", "filter", "getFilter", "()Ljava/io/FileFilter;", "setFilter", "(Ljava/io/FileFilter;)V", "directoryBrowsingEnabled", "getDirectoryBrowsingEnabled", "()Z", "setDirectoryBrowsingEnabled", "(Z)V", "allowFolderSelect", "getAllowFolderSelect", "setAllowFolderSelect", "showAbsolutePath", "getShowAbsolutePath", "setShowAbsolutePath", "fileNameEnabled", "getFileNameEnabled", "setFileNameEnabled", "fileNameInput", "Lcom/unciv/ui/components/widgets/UncivTextField;", "fileNameLabel", "Lcom/badlogic/gdx/scenes/scene2d/ui/Label;", "fileNameWrapper", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "fileNameCell", "Lcom/badlogic/gdx/scenes/scene2d/ui/Cell;", "Lcom/badlogic/gdx/scenes/scene2d/Actor;", "dirTypeLabel", "pathLabel", "pathLabelWrapper", "fileList", "Lcom/unciv/logic/files/FileChooser$FileList;", "fileScroll", "Lcom/unciv/ui/components/widgets/AutoScrollPane;", "okButton", "Lcom/badlogic/gdx/scenes/scene2d/ui/TextButton;", "maxHeight", "", "absoluteLocalPath", "kotlin.jvm.PlatformType", "absoluteExternalPath", "currentDir", "result", "filterWithFolders", "getMaxHeight", "reportResult", "makeAbsolute", "makeRelative", "initialDirectory", "switchDomain", "changeDirectory", "directory", "getResult", "resetList", "enableOKButton", "setOkButtonText", "text", "FileListItem", "FileList", "Companion", "core"})
public class FileChooser
extends Popup {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Function2<Boolean, FileHandle, Unit> resultListener;
    @NotNull
    private FileFilter filter;
    private boolean directoryBrowsingEnabled;
    private boolean allowFolderSelect;
    private boolean showAbsolutePath;
    @NotNull
    private final UncivTextField fileNameInput;
    @NotNull
    private final Label fileNameLabel;
    @NotNull
    private final Table fileNameWrapper;
    @NotNull
    private final Cell<Actor> fileNameCell;
    @NotNull
    private final Label dirTypeLabel;
    @NotNull
    private final Label pathLabel;
    @NotNull
    private final Table pathLabelWrapper;
    @NotNull
    private final FileList fileList;
    @NotNull
    private final AutoScrollPane fileScroll;
    @NotNull
    private final TextButton okButton;
    private final float maxHeight;
    private final String absoluteLocalPath;
    private final String absoluteExternalPath;
    @Nullable
    private FileHandle currentDir;
    @Nullable
    private String result;
    @NotNull
    private final FileFilter filterWithFolders;
    @NotNull
    private static final Comparator<FileListItem> dirListComparator = FileChooser::dirListComparator$lambda$13;

    /*
     * WARNING - void declaration
     */
    public FileChooser(@NotNull Stage stageToShowOn, @Nullable String title, @Nullable FileHandle startFile, @Nullable Function2<? super Boolean, ? super FileHandle, Unit> resultListener) {
        void $this$pathLabelWrapper_u24lambda_u242;
        Table $this$fileNameWrapper_u24lambda_u241;
        Table table2;
        Intrinsics.checkNotNullParameter(stageToShowOn, "stageToShowOn");
        super(stageToShowOn, Popup.Scrollability.None, 0.0f, 4, null);
        this.resultListener = resultListener;
        this.filter = FileChooser::filter$lambda$0;
        this.directoryBrowsingEnabled = true;
        this.fileNameInput = new UncivTextField("Please enter a file name", null, null, 6, null);
        this.fileNameLabel = Scene2dExtensionsKt.toLabel("File name:");
        Table table3 = table2 = new Table();
        FileChooser fileChooser = this;
        boolean bl = false;
        $this$fileNameWrapper_u24lambda_u241.defaults().space(10.0f);
        $this$fileNameWrapper_u24lambda_u241.add((Actor)this.fileNameLabel).growX().row();
        $this$fileNameWrapper_u24lambda_u241.add((Actor)this.fileNameInput).growX().row();
        Scene2dExtensionsKt.addSeparator$default($this$fileNameWrapper_u24lambda_u241, null, 0, 1.0f, 3, null);
        fileChooser.fileNameWrapper = table2;
        Color color = Color.GRAY;
        Intrinsics.checkNotNullExpressionValue(color, "GRAY");
        this.dirTypeLabel = Scene2dExtensionsKt.toLabel$default("", color, 0, 0, false, 14, null);
        Color color2 = Color.GRAY;
        Intrinsics.checkNotNullExpressionValue(color2, "GRAY");
        this.pathLabel = Scene2dExtensionsKt.toLabel$default("", color2, 0, 8, false, 10, null);
        $this$fileNameWrapper_u24lambda_u241 = table2 = new Table();
        fileChooser = this;
        boolean bl2 = false;
        $this$pathLabelWrapper_u24lambda_u242.setTouchable(Touchable.enabled);
        $this$pathLabelWrapper_u24lambda_u242.defaults().space(10.0f);
        $this$pathLabelWrapper_u24lambda_u242.add((Actor)this.dirTypeLabel).pad(2.0f);
        $this$pathLabelWrapper_u24lambda_u242.add((Actor)this.pathLabel).left().growX();
        fileChooser.pathLabelWrapper = table2;
        Skin skin = this.getSkin();
        Intrinsics.checkNotNullExpressionValue(skin, "getSkin(...)");
        this.fileList = new FileList(skin);
        this.fileScroll = new AutoScrollPane((Actor)this.fileList, null, 2, null);
        this.maxHeight = stageToShowOn.getHeight() * 0.6f;
        this.absoluteLocalPath = UncivGame.Companion.getCurrent().getFiles().getDataFolder().file().getAbsoluteFile().getCanonicalPath();
        this.absoluteExternalPath = Gdx.files.isExternalStorageAvailable() ? Gdx.files.external("").file().getAbsoluteFile().getCanonicalPath() : "/\\/\\/";
        this.filterWithFolders = arg_0 -> FileChooser.filterWithFolders$lambda$3(this, arg_0);
        this.getInnerTable().top().left();
        this.fileList.getSelection().setProgrammaticChangeEvents(false);
        this.fileNameInput.setTextFieldListener((arg_0, arg_1) -> FileChooser._init_$lambda$4(this, arg_0, arg_1));
        this.fileNameInput.setTextFieldFilter(UncivFiles.Companion.fileNameTextFieldFilter());
        if (title != null) {
            Popup.addGoodSizedLabel$default(this, title, 0, false, null, 14, null).colspan(2).center().row();
            Popup.addSeparator$default(this, null, 0, 1.0f, 3, null);
        }
        this.add((Actor)this.pathLabelWrapper).colspan(2).fillX().row();
        Popup popup2 = this;
        Color color3 = Color.GRAY;
        Intrinsics.checkNotNullExpressionValue(color3, "GRAY");
        Popup.addSeparator$default(popup2, color3, 0, 1.0f, 2, null);
        this.add((Actor)this.fileScroll).colspan(2).fill().row();
        Popup.addSeparator$default(this, null, 0, 1.0f, 3, null);
        Cell<Actor> cell = this.add().colspan(2).growX();
        Intrinsics.checkNotNullExpressionValue(cell, "growX(...)");
        this.fileNameCell = cell;
        super.row();
        Popup.addCloseButton$default(this, "Cancel", null, null, () -> FileChooser._init_$lambda$5(this), 6, null);
        Object t = Popup.addOKButton$default(this, "OK", null, null, null, () -> FileChooser._init_$lambda$6(this), 14, null).getActor();
        Intrinsics.checkNotNullExpressionValue(t, "getActor(...)");
        this.okButton = (TextButton)t;
        this.equalizeLastTwoButtonWidths();
        ActivationExtensionsKt.onChange(this.fileList, arg_0 -> FileChooser._init_$lambda$7(this, arg_0));
        ActivationExtensionsKt.onDoubleClick(this.fileList, UncivSound.Companion.getSilent(), () -> FileChooser._init_$lambda$8(this));
        ActivationExtensionsKt.onClick(this.pathLabelWrapper, UncivSound.Companion.getSwap(), () -> FileChooser._init_$lambda$9(this));
        this.getShowListeners().add(() -> FileChooser._init_$lambda$10(this, startFile, stageToShowOn));
    }

    public /* synthetic */ FileChooser(Stage stage, String string, FileHandle fileHandle, Function2 function2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            fileHandle = null;
        }
        if ((n & 8) != 0) {
            function2 = null;
        }
        this(stage, string, fileHandle, function2);
    }

    @NotNull
    public final FileFilter getFilter() {
        return this.filter;
    }

    public final void setFilter(@NotNull FileFilter value) {
        Intrinsics.checkNotNullParameter(value, "value");
        this.filter = value;
        this.resetList();
    }

    public final boolean getDirectoryBrowsingEnabled() {
        return this.directoryBrowsingEnabled;
    }

    public final void setDirectoryBrowsingEnabled(boolean value) {
        this.directoryBrowsingEnabled = value;
        this.resetList();
    }

    public final boolean getAllowFolderSelect() {
        return this.allowFolderSelect;
    }

    public final void setAllowFolderSelect(boolean value) {
        this.allowFolderSelect = value;
        this.resetList();
    }

    public final boolean getShowAbsolutePath() {
        return this.showAbsolutePath;
    }

    public final void setShowAbsolutePath(boolean value) {
        this.showAbsolutePath = value;
        this.resetList();
    }

    public final boolean getFileNameEnabled() {
        return this.fileNameCell.hasActor();
    }

    public final void setFileNameEnabled(boolean value) {
        Cell<Actor> cell = value ? this.fileNameCell.setActor((Actor)this.fileNameWrapper) : this.fileNameCell.clearActor();
    }

    @Override
    public float getMaxHeight() {
        return this.maxHeight;
    }

    private final void reportResult(boolean success) {
        FileHandle file = this.getResult();
        if (!(success && this.getFileNameEnabled() && file.exists())) {
            Function2<Boolean, FileHandle, Unit> function2 = this.resultListener;
            if (function2 != null) {
                function2.invoke(success, file);
            }
            return;
        }
        new ConfirmPopup(this.getStageToShowOn(), "Do you want to overwrite " + file.name() + '?', "Overwrite", false, () -> FileChooser.reportResult$lambda$11(this, file), () -> FileChooser.reportResult$lambda$12(this, file), 8, null).open(true);
    }

    private final FileHandle makeAbsolute(FileHandle file) {
        if (file.type() == Files.FileType.Absolute) {
            return file;
        }
        FileHandle fileHandle = Gdx.files.absolute(file.file().getAbsoluteFile().getCanonicalPath());
        Intrinsics.checkNotNullExpressionValue(fileHandle, "absolute(...)");
        return fileHandle;
    }

    private final FileHandle makeRelative(FileHandle file) {
        if (file.type() != Files.FileType.Absolute) {
            return file;
        }
        String path = file.path();
        Intrinsics.checkNotNull(path);
        String string = this.absoluteLocalPath;
        Intrinsics.checkNotNullExpressionValue(string, "absoluteLocalPath");
        if (StringsKt.startsWith$default(path, string, false, 2, null)) {
            UncivFiles uncivFiles = UncivGame.Companion.getCurrent().getFiles();
            String string2 = this.absoluteLocalPath;
            Intrinsics.checkNotNullExpressionValue(string2, "absoluteLocalPath");
            String string3 = StringsKt.removePrefix(path, (CharSequence)string2);
            String string4 = File.separator;
            Intrinsics.checkNotNullExpressionValue(string4, "separator");
            return uncivFiles.getLocalFile(StringsKt.removePrefix(string3, (CharSequence)string4));
        }
        String string5 = this.absoluteExternalPath;
        Intrinsics.checkNotNullExpressionValue(string5, "absoluteExternalPath");
        if (StringsKt.startsWith$default(path, string5, false, 2, null)) {
            String string6 = this.absoluteExternalPath;
            Intrinsics.checkNotNullExpressionValue(string6, "absoluteExternalPath");
            String string7 = StringsKt.removePrefix(path, (CharSequence)string6);
            String string8 = File.separator;
            Intrinsics.checkNotNullExpressionValue(string8, "separator");
            FileHandle fileHandle = Gdx.files.external(StringsKt.removePrefix(string7, (CharSequence)string8));
            Intrinsics.checkNotNullExpressionValue(fileHandle, "external(...)");
            return fileHandle;
        }
        return file;
    }

    private final void initialDirectory(FileHandle startFile) {
        FileHandle fileHandle;
        if (startFile == null && Gdx.files.isExternalStorageAvailable()) {
            fileHandle = Gdx.files.absolute(this.absoluteExternalPath);
        } else if (startFile == null) {
            fileHandle = Gdx.files.absolute(this.absoluteLocalPath);
        } else if (startFile.isDirectory()) {
            fileHandle = startFile;
        } else {
            this.fileNameInput.setText(startFile.name());
            this.result = startFile.name();
            fileHandle = startFile.parent();
        }
        FileHandle fileHandle2 = fileHandle;
        Intrinsics.checkNotNull(fileHandle2);
        this.changeDirectory(this.makeAbsolute(fileHandle2));
    }

    /*
     * Unable to fully structure code
     */
    private final void switchDomain() {
        block4: {
            block3: {
                v0 = this.currentDir;
                if (v0 == null || (v0 = v0.path()) == null) {
                    return;
                }
                current = v0;
                if (Gdx.files.isExternalStorageAvailable()) break block3;
                v1 = this.absoluteLocalPath;
                break block4;
            }
            v2 = this.absoluteExternalPath;
            Intrinsics.checkNotNullExpressionValue(v2, "absoluteExternalPath");
            if (!StringsKt.startsWith$default((String)current, v2, false, 2, null)) ** GOTO lbl-1000
            v3 = this.absoluteLocalPath;
            Intrinsics.checkNotNullExpressionValue(v3, "absoluteLocalPath");
            if (!StringsKt.startsWith$default((String)current, v3, false, 2, null)) {
                v1 = this.absoluteLocalPath;
            } else lbl-1000:
            // 2 sources

            {
                v1 = this.absoluteExternalPath;
            }
        }
        var2_2 = Gdx.files.absolute(v1);
        Intrinsics.checkNotNullExpressionValue(var2_2, "absolute(...)");
        this.changeDirectory(var2_2);
    }

    private final void changeDirectory(FileHandle directory) {
        Pair<String, Color> pair;
        this.currentDir = directory;
        FileHandle relativeFile = this.showAbsolutePath ? directory : this.makeRelative(directory);
        Files.FileType fileType = relativeFile.type();
        switch (fileType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[fileType.ordinal()]) {
            case 1: {
                pair = TuplesKt.to("\u24ba", Color.CHARTREUSE);
                break;
            }
            case 2: {
                pair = TuplesKt.to("\u24c1", Color.TAN);
                break;
            }
            default: {
                pair = TuplesKt.to("", Color.WHITE);
            }
        }
        Pair<String, Color> pair2 = pair;
        String label = pair2.component1();
        Color color = pair2.component2();
        this.dirTypeLabel.setText(label);
        this.dirTypeLabel.getColor().set(color);
        this.pathLabel.setText(relativeFile.path());
        FileHandle[] list2 = directory.list(this.filterWithFolders);
        Array<FileListItem> items = new Array<FileListItem>(list2.length);
        Iterator<FileHandle> iterator2 = ArrayIteratorKt.iterator(list2);
        while (iterator2.hasNext()) {
            FileHandle handle = iterator2.next();
            if (!this.directoryBrowsingEnabled && handle.isDirectory() || handle.file().isHidden()) continue;
            Intrinsics.checkNotNull(handle);
            items.add(new FileListItem(handle));
        }
        items.sort(dirListComparator);
        if (this.directoryBrowsingEnabled && directory.file().getParentFile() != null) {
            FileHandle fileHandle = directory.parent();
            Intrinsics.checkNotNullExpressionValue(fileHandle, "parent(...)");
            items.insert(0, new FileListItem("  ..", fileHandle, true));
        }
        this.fileList.setSelected(null);
        this.fileList.setItems(items);
        this.enableOKButton();
    }

    private final FileHandle getResult() {
        FileHandle fileHandle;
        CharSequence charSequence = this.result;
        if (charSequence == null || charSequence.length() == 0) {
            FileHandle fileHandle2 = this.currentDir;
            fileHandle = fileHandle2;
            Intrinsics.checkNotNull(fileHandle2);
        } else {
            FileHandle fileHandle3 = this.currentDir;
            Intrinsics.checkNotNull(fileHandle3);
            fileHandle = fileHandle3.child(this.result);
        }
        FileHandle fileHandle4 = fileHandle;
        Intrinsics.checkNotNull(fileHandle4);
        return this.makeRelative(fileHandle4);
    }

    private final void resetList() {
        if (!this.hasParent()) {
            return;
        }
        FileHandle fileHandle = this.currentDir;
        Intrinsics.checkNotNull(fileHandle);
        this.changeDirectory(fileHandle);
    }

    private final void enableOKButton() {
        Scene2dExtensionsKt.setEnabled(this.okButton, this.getFileNameEnabled() ? FileChooser.enableOKButton$getSaveEnable(this) : FileChooser.enableOKButton$getLoadEnable(this));
    }

    public final void setOkButtonText(@NotNull String text) {
        Intrinsics.checkNotNullParameter(text, "text");
        this.okButton.setText(TranslationsKt.tr$default(text, false, false, 3, null));
    }

    private static final boolean filter$lambda$0(File it) {
        return true;
    }

    private static final boolean filterWithFolders$lambda$3(FileChooser this$0, File it) {
        return this$0.directoryBrowsingEnabled && it.isDirectory() || this$0.filter.accept(it);
    }

    private static final void _init_$lambda$4(FileChooser this$0, TextField textField, char c) {
        this$0.result = textField.getText();
        this$0.enableOKButton();
    }

    private static final Unit _init_$lambda$5(FileChooser this$0) {
        this$0.reportResult(false);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$6(FileChooser this$0) {
        this$0.reportResult(true);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$7(FileChooser this$0, ChangeListener.ChangeEvent it) {
        FileListItem fileListItem = (FileListItem)this$0.fileList.getSelected();
        if (fileListItem == null) {
            return Unit.INSTANCE;
        }
        FileListItem selected = fileListItem;
        if (!selected.getFile().isDirectory()) {
            this$0.result = selected.getFile().name();
            this$0.fileNameInput.setText(this$0.result);
        }
        this$0.enableOKButton();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$8(FileChooser this$0) {
        FileListItem fileListItem = (FileListItem)this$0.fileList.getSelected();
        if (fileListItem == null) {
            return Unit.INSTANCE;
        }
        FileListItem selected = fileListItem;
        if (selected.getFile().isDirectory()) {
            this$0.changeDirectory(selected.getFile());
        } else {
            this$0.reportResult(true);
            this$0.close();
        }
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$9(FileChooser this$0) {
        this$0.switchDomain();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$10(FileChooser this$0, FileHandle $startFile, Stage $stageToShowOn) {
        if (this$0.currentDir == null) {
            this$0.initialDirectory($startFile);
        }
        $stageToShowOn.setScrollFocus(this$0.fileScroll);
        $stageToShowOn.setKeyboardFocus(this$0.fileNameInput);
        return Unit.INSTANCE;
    }

    private static final Unit reportResult$lambda$11(FileChooser this$0, FileHandle $file) {
        block0: {
            Function2<Boolean, FileHandle, Unit> function2 = this$0.resultListener;
            if (function2 == null) break block0;
            function2.invoke(false, $file);
        }
        return Unit.INSTANCE;
    }

    private static final Unit reportResult$lambda$12(FileChooser this$0, FileHandle $file) {
        block0: {
            Function2<Boolean, FileHandle, Unit> function2 = this$0.resultListener;
            if (function2 == null) break block0;
            function2.invoke(true, $file);
        }
        return Unit.INSTANCE;
    }

    private static final boolean enableOKButton$getLoadEnable(FileChooser this$0) {
        Object object = (FileListItem)this$0.fileList.getSelected();
        if (object == null || (object = ((FileListItem)object).getFile()) == null) {
            return false;
        }
        Object file = object;
        if (!((FileHandle)file).exists()) {
            return false;
        }
        return this$0.allowFolderSelect || !((FileHandle)file).isDirectory();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean enableOKButton$getSaveEnable(FileChooser this$0) {
        FileHandle fileHandle = this$0.currentDir;
        if (fileHandle == null) return false;
        if (!fileHandle.exists()) return false;
        boolean bl = true;
        if (!bl) {
            return false;
        }
        if (this$0.allowFolderSelect) {
            return true;
        }
        if (this$0.result == null) return false;
        String string = this$0.result;
        Intrinsics.checkNotNull(string);
        if (!UncivFiles.Companion.isValidFileName(string)) return false;
        return true;
    }

    private static final int dirListComparator$lambda$13(FileListItem file1, FileListItem file2) {
        int n;
        if (file1.getFile().isDirectory() && !file2.getFile().isDirectory()) {
            n = -1;
        } else if (!file1.getFile().isDirectory() && file2.getFile().isDirectory()) {
            n = 1;
        } else {
            String string = file1.getFile().name();
            String string2 = file2.getFile().name();
            Intrinsics.checkNotNullExpressionValue(string2, "name(...)");
            n = string.compareTo(string2);
        }
        return n;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003Jf\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f2@\b\u0002\u0010\u0010\u001a:\u0012\u0013\u0012\u00110\u0012\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0015\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0016\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u0011j\u0004\u0018\u0001`\u0018Jf\u0010\u0019\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f2@\b\u0002\u0010\u0010\u001a:\u0012\u0013\u0012\u00110\u0012\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0015\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0016\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u0011j\u0004\u0018\u0001`\u0018J\u001f\u0010\u001a\u001a\u00020\u001b2\u0012\u0010\u001c\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\u001d\"\u00020\r\u00a2\u0006\u0002\u0010\u001eR\u001e\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u00060\u0005j\b\u0012\u0004\u0012\u00020\u0006`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/unciv/logic/files/FileChooser$Companion;", "", "<init>", "()V", "dirListComparator", "Ljava/util/Comparator;", "Lcom/unciv/logic/files/FileChooser$FileListItem;", "Lkotlin/Comparator;", "createSaveDialog", "Lcom/unciv/logic/files/FileChooser;", "stage", "Lcom/badlogic/gdx/scenes/scene2d/Stage;", "title", "", "path", "Lcom/badlogic/gdx/files/FileHandle;", "resultListener", "Lkotlin/Function2;", "", "Lkotlin/ParameterName;", "name", "success", "file", "", "Lcom/unciv/logic/files/ResultListener;", "createLoadDialog", "createExtensionFilter", "Ljava/io/FileFilter;", "extensions", "", "([Ljava/lang/String;)Ljava/io/FileFilter;", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FileChooser createSaveDialog(@NotNull Stage stage, @Nullable String title, @Nullable FileHandle path, @Nullable Function2<? super Boolean, ? super FileHandle, Unit> resultListener) {
            FileChooser fileChooser;
            Intrinsics.checkNotNullParameter(stage, "stage");
            FileChooser $this$createSaveDialog_u24lambda_u240 = fileChooser = new FileChooser(stage, title, path, resultListener);
            boolean bl = false;
            $this$createSaveDialog_u24lambda_u240.setFileNameEnabled(true);
            $this$createSaveDialog_u24lambda_u240.setOkButtonText("Save");
            return fileChooser;
        }

        public static /* synthetic */ FileChooser createSaveDialog$default(Companion companion, Stage stage, String string, FileHandle fileHandle, Function2 function2, int n, Object object) {
            if ((n & 4) != 0) {
                fileHandle = null;
            }
            if ((n & 8) != 0) {
                function2 = null;
            }
            return companion.createSaveDialog(stage, string, fileHandle, function2);
        }

        @NotNull
        public final FileChooser createLoadDialog(@NotNull Stage stage, @Nullable String title, @Nullable FileHandle path, @Nullable Function2<? super Boolean, ? super FileHandle, Unit> resultListener) {
            FileChooser fileChooser;
            Intrinsics.checkNotNullParameter(stage, "stage");
            FileChooser $this$createLoadDialog_u24lambda_u241 = fileChooser = new FileChooser(stage, title, path, resultListener);
            boolean bl = false;
            $this$createLoadDialog_u24lambda_u241.setFileNameEnabled(false);
            $this$createLoadDialog_u24lambda_u241.setOkButtonText("Load");
            return fileChooser;
        }

        public static /* synthetic */ FileChooser createLoadDialog$default(Companion companion, Stage stage, String string, FileHandle fileHandle, Function2 function2, int n, Object object) {
            if ((n & 4) != 0) {
                fileHandle = null;
            }
            if ((n & 8) != 0) {
                function2 = null;
            }
            return companion.createLoadDialog(stage, string, fileHandle, function2);
        }

        @NotNull
        public final FileFilter createExtensionFilter(String ... extensions) {
            Intrinsics.checkNotNullParameter(extensions, "extensions");
            return arg_0 -> Companion.createExtensionFilter$lambda$2(extensions, arg_0);
        }

        private static final boolean createExtensionFilter$lambda$2(String[] $extensions, File it) {
            Intrinsics.checkNotNull(it);
            String string = FilesKt.getExtension(it).toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
            return ArraysKt.contains($extensions, string);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J@\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u0017H\u0014R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\n\u00a8\u0006\u001a"}, d2={"Lcom/unciv/logic/files/FileChooser$FileList;", "Lcom/badlogic/gdx/scenes/scene2d/ui/List;", "Lcom/unciv/logic/files/FileChooser$FileListItem;", "skin", "Lcom/badlogic/gdx/scenes/scene2d/ui/Skin;", "<init>", "(Lcom/badlogic/gdx/scenes/scene2d/ui/Skin;)V", "saveColor", "Lcom/badlogic/gdx/graphics/Color;", "getSaveColor", "()Lcom/badlogic/gdx/graphics/Color;", "folderColor", "getFolderColor", "drawItem", "Lcom/badlogic/gdx/graphics/g2d/GlyphLayout;", "batch", "Lcom/badlogic/gdx/graphics/g2d/Batch;", "font", "Lcom/badlogic/gdx/graphics/g2d/BitmapFont;", "index", "", "item", "x", "", "y", "width", "core"})
    private static final class FileList
    extends List<FileListItem> {
        @NotNull
        private final Color saveColor;
        @NotNull
        private final Color folderColor;

        public FileList(@NotNull Skin skin) {
            Intrinsics.checkNotNullParameter(skin, "skin");
            super(skin);
            this.saveColor = new Color();
            this.folderColor = new Color(1.0f, 0.86f, 0.5f, 1.0f);
        }

        @NotNull
        public final Color getSaveColor() {
            return this.saveColor;
        }

        @NotNull
        public final Color getFolderColor() {
            return this.folderColor;
        }

        @Override
        @NotNull
        protected GlyphLayout drawItem(@NotNull Batch batch, @NotNull BitmapFont font, int index, @NotNull FileListItem item, float x, float y, float width) {
            Intrinsics.checkNotNullParameter(batch, "batch");
            Intrinsics.checkNotNullParameter(font, "font");
            Intrinsics.checkNotNullParameter(item, "item");
            this.saveColor.set(font.getColor());
            font.setColor(item.isFolder() ? this.folderColor : Color.WHITE);
            GlyphLayout layout = super.drawItem(batch, font, index, item, x, y, width);
            font.setColor(this.saveColor);
            Intrinsics.checkNotNull(layout);
            return layout;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tB\u0011\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\nJ\b\u0010\u0010\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u000f\u00a8\u0006\u0011"}, d2={"Lcom/unciv/logic/files/FileChooser$FileListItem;", "", "label", "", "file", "Lcom/badlogic/gdx/files/FileHandle;", "isFolder", "", "<init>", "(Ljava/lang/String;Lcom/badlogic/gdx/files/FileHandle;Z)V", "(Lcom/badlogic/gdx/files/FileHandle;)V", "getLabel", "()Ljava/lang/String;", "getFile", "()Lcom/badlogic/gdx/files/FileHandle;", "()Z", "toString", "core"})
    private static final class FileListItem {
        @NotNull
        private final String label;
        @NotNull
        private final FileHandle file;
        private final boolean isFolder;

        public FileListItem(@NotNull String label, @NotNull FileHandle file, boolean isFolder) {
            Intrinsics.checkNotNullParameter(label, "label");
            Intrinsics.checkNotNullParameter(file, "file");
            this.label = label;
            this.file = file;
            this.isFolder = isFolder;
        }

        @NotNull
        public final String getLabel() {
            return this.label;
        }

        @NotNull
        public final FileHandle getFile() {
            return this.file;
        }

        public final boolean isFolder() {
            return this.isFolder;
        }

        public FileListItem(@NotNull FileHandle file) {
            Intrinsics.checkNotNullParameter(file, "file");
            this((file.isDirectory() ? "  " : "") + file.name(), file, file.isDirectory());
        }

        @NotNull
        public String toString() {
            return this.label;
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Files.FileType.values().length];
            try {
                nArray[Files.FileType.External.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Files.FileType.Local.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

