/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.civilization;

import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.NotificationAction;
import com.unciv.ui.screens.diplomacyscreen.DiplomacyScreen;
import com.unciv.ui.screens.worldscreen.WorldScreen;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/unciv/logic/civilization/DiplomacyAction;", "Lcom/unciv/logic/civilization/NotificationAction;", "otherCivName", "", "showTrade", "", "<init>", "(Ljava/lang/String;Z)V", "execute", "", "worldScreen", "Lcom/unciv/ui/screens/worldscreen/WorldScreen;", "core"})
public final class DiplomacyAction
implements NotificationAction {
    @NotNull
    private final String otherCivName;
    private boolean showTrade;

    public DiplomacyAction(@NotNull String otherCivName, boolean showTrade) {
        Intrinsics.checkNotNullParameter(otherCivName, "otherCivName");
        this.otherCivName = otherCivName;
        this.showTrade = showTrade;
    }

    public /* synthetic */ DiplomacyAction(String string, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "";
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        this(string, bl);
    }

    @Override
    public void execute(@NotNull WorldScreen worldScreen) {
        Intrinsics.checkNotNullParameter(worldScreen, "worldScreen");
        Civilization currentCiv = worldScreen.getSelectedCiv();
        Civilization otherCiv = worldScreen.getGameInfo().getCivilization(this.otherCivName);
        if (this.showTrade && Intrinsics.areEqual(otherCiv, currentCiv)) {
            return;
        }
        if (this.showTrade && (otherCiv.isCityState() || currentCiv.isCityState())) {
            this.showTrade = false;
        }
        if (this.showTrade && currentCiv.isAtWarWith(otherCiv)) {
            this.showTrade = false;
        }
        worldScreen.getGame().pushScreen(new DiplomacyScreen(currentCiv, otherCiv, null, this.showTrade, 4, null));
    }

    public DiplomacyAction() {
        this(null, false, 3, null);
    }
}

