/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.civilization;

import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonValue;
import com.unciv.logic.IsPartOfGameInfoSerialization;
import com.unciv.logic.civilization.Civilization;
import com.unciv.ui.screens.victoryscreen.RankingType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u000026\u0012\u0004\u0012\u00020\u0002\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020\u00030\u0001j\u001a\u0012\u0004\u0012\u00020\u0002\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020\u0003`\u00052\u00020\u00062\u00020\u0007B\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\n\u001a\u00020\u0000H\u0016J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/unciv/logic/civilization/CivRankingHistory;", "Ljava/util/HashMap;", "", "", "Lcom/unciv/ui/screens/victoryscreen/RankingType;", "Lkotlin/collections/HashMap;", "Lcom/unciv/logic/IsPartOfGameInfoSerialization;", "Lcom/badlogic/gdx/utils/Json$Serializable;", "<init>", "()V", "clone", "recordRankingStats", "", "civilization", "Lcom/unciv/logic/civilization/Civilization;", "write", "json", "Lcom/badlogic/gdx/utils/Json;", "nonNumber", "Lkotlin/text/Regex;", "read", "jsonData", "Lcom/badlogic/gdx/utils/JsonValue;", "core"})
@SourceDebugExtension(value={"SMAP\nCivRankingHistory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CivRankingHistory.kt\ncom/unciv/logic/civilization/CivRankingHistory\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,71:1\n1285#2,2:72\n1299#2,4:74\n774#2:78\n865#2,2:79\n*S KotlinDebug\n*F\n+ 1 CivRankingHistory.kt\ncom/unciv/logic/civilization/CivRankingHistory\n*L\n23#1:72,2\n23#1:74,4\n49#1:78\n49#1:79,2\n*E\n"})
public final class CivRankingHistory
extends HashMap<Integer, Map<RankingType, ? extends Integer>>
implements IsPartOfGameInfoSerialization,
Json.Serializable {
    @NotNull
    private final Regex nonNumber = new Regex("[^\\d-]");

    @Override
    @NotNull
    public CivRankingHistory clone() {
        CivRankingHistory toReturn = new CivRankingHistory();
        toReturn.putAll(this);
        return toReturn;
    }

    /*
     * WARNING - void declaration
     */
    public final void recordRankingStats(@NotNull Civilization civilization) {
        Intrinsics.checkNotNullParameter(civilization, "civilization");
        Map map2 = this;
        Integer n = civilization.getGameInfo().getTurns();
        Iterable $this$associateWith$iv = RankingType.getEntries();
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateWith$iv, 10)), 16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void it;
            RankingType rankingType = (RankingType)((Object)element$iv$iv);
            Object t = element$iv$iv;
            Map map3 = result$iv;
            boolean bl = false;
            Integer n2 = civilization.getStatForRanking((RankingType)it);
            map3.put(t, n2);
        }
        Map map4 = result$iv;
        map2.put(n, map4);
    }

    @Override
    public void write(@NotNull Json json) {
        Intrinsics.checkNotNullParameter(json, "json");
        for (Map.Entry entry : ((Map)this).entrySet()) {
            int turn = ((Number)entry.getKey()).intValue();
            Map rankings = (Map)entry.getValue();
            String rankingsString = CollectionsKt.joinToString$default(rankings.entrySet(), "", null, null, 0, null, CivRankingHistory::write$lambda$1, 30, null);
            json.writeValue(String.valueOf(turn), rankingsString);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void read(@NotNull Json json, @NotNull JsonValue jsonData) {
        Intrinsics.checkNotNullParameter(json, "json");
        Intrinsics.checkNotNullParameter(jsonData, "jsonData");
        JsonValue.JsonIterator jsonIterator = jsonData.iterator();
        Intrinsics.checkNotNullExpressionValue(jsonIterator, "iterator(...)");
        JsonValue.JsonIterator jsonIterator2 = jsonIterator;
        while (jsonIterator2.hasNext()) {
            JsonValue entry = jsonIterator2.next();
            String string = entry.name;
            Intrinsics.checkNotNullExpressionValue(string, "name");
            int turn = Integer.parseInt(string);
            Map rankings = new LinkedHashMap();
            if (entry.isString()) {
                void $this$filterTo$iv$iv;
                Iterator $this$filter$iv;
                String string2 = entry.asString();
                Intrinsics.checkNotNullExpressionValue(string2, "asString(...)");
                Object object = (String[])string2;
                Regex regex = this.nonNumber;
                String string3 = " $0";
                CharSequence charSequence = regex.replace((CharSequence)object, string3);
                object = new String[]{" "};
                object = StringsKt.split$default(charSequence, object, false, 0, 6, null);
                boolean $i$f$filter = false;
                string3 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    String it = (String)element$iv$iv;
                    boolean bl = false;
                    boolean bl2 = ((CharSequence)it).length() > 0;
                    if (!bl2) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List pairs = (List)destination$iv$iv;
                $this$filter$iv = pairs.iterator();
                while ($this$filter$iv.hasNext()) {
                    RankingType rankingType;
                    String pair = (String)$this$filter$iv.next();
                    if (RankingType.Companion.fromIdForSerialization(pair.charAt(0)) == null) continue;
                    String string4 = pair.substring(1);
                    Intrinsics.checkNotNullExpressionValue(string4, "substring(...)");
                    Integer n = StringsKt.toIntOrNull(string4);
                    if (n == null) {
                        continue;
                    }
                    int value = n;
                    rankings.put(rankingType, value);
                }
            } else {
                JsonValue.JsonIterator jsonIterator3;
                Intrinsics.checkNotNullExpressionValue(entry.iterator(), "iterator(...)");
                while (jsonIterator3.hasNext()) {
                    RankingType rankingType;
                    JsonValue rankingEntry = jsonIterator3.next();
                    if (rankingEntry.name.length() != 1 || RankingType.Companion.fromIdForSerialization(rankingEntry.name.charAt(0)) == null) continue;
                    rankings.put(rankingType, rankingEntry.asInt());
                }
            }
            ((Map)this).put(turn, rankings);
        }
    }

    private static final CharSequence write$lambda$1(Map.Entry it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return "" + ((RankingType)((Object)it.getKey())).getIdForSerialization() + ((Number)it.getValue()).intValue();
    }
}

