/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.battle;

import com.unciv.logic.automation.unit.HeadTowardsEnemyCityAutomation;
import com.unciv.logic.battle.CombatAction;
import com.unciv.logic.battle.ICombatant;
import com.unciv.logic.battle.MapUnitCombatant;
import com.unciv.logic.city.City;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.logic.map.mapunit.movement.UnitMovement;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.ruleset.unique.GameContext;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueType;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import yairm210.purity.annotations.Readonly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0012B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007\u00a8\u0006\u0013"}, d2={"Lcom/unciv/logic/battle/GreatGeneralImplementation;", "", "<init>", "()V", "getGreatGeneralBonus", "Lkotlin/Pair;", "", "", "ourUnitCombatant", "Lcom/unciv/logic/battle/MapUnitCombatant;", "enemy", "Lcom/unciv/logic/battle/ICombatant;", "combatAction", "Lcom/unciv/logic/battle/CombatAction;", "getBestAffectedTroopsTile", "Lcom/unciv/logic/map/tile/Tile;", "general", "Lcom/unciv/logic/map/mapunit/MapUnit;", "GeneralBonusData", "core"})
@SourceDebugExtension(value={"SMAP\nGreatGeneralImplementation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GreatGeneralImplementation.kt\ncom/unciv/logic/battle/GreatGeneralImplementation\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,99:1\n1463#2,14:100\n183#2,2:114\n1463#2,5:116\n1276#2,3:121\n1276#2,3:124\n1469#2,2:127\n1276#2,3:129\n1276#2,3:132\n1471#2,6:135\n*S KotlinDebug\n*F\n+ 1 GreatGeneralImplementation.kt\ncom/unciv/logic/battle/GreatGeneralImplementation\n*L\n56#1:100,14\n85#1:114,2\n88#1:116,5\n89#1:121,3\n90#1:124,3\n88#1:127,2\n89#1:129,3\n90#1:132,3\n88#1:135,6\n*E\n"})
public final class GreatGeneralImplementation {
    @NotNull
    public static final GreatGeneralImplementation INSTANCE = new GreatGeneralImplementation();

    private GreatGeneralImplementation() {
    }

    @Readonly
    @NotNull
    public final Pair<String, Integer> getGreatGeneralBonus(@NotNull MapUnitCombatant ourUnitCombatant, @NotNull ICombatant enemy, @NotNull CombatAction combatAction) {
        GeneralBonusData generalBonusData;
        Sequence<GeneralBonusData> greatGeneral;
        Intrinsics.checkNotNullParameter(ourUnitCombatant, "ourUnitCombatant");
        Intrinsics.checkNotNullParameter(enemy, "enemy");
        Intrinsics.checkNotNullParameter((Object)combatAction, "combatAction");
        MapUnit unit = ourUnitCombatant.getUnit();
        Civilization civInfo = ourUnitCombatant.getUnit().getCiv();
        Sequence<MapUnit> allGenerals = SequencesKt.filter(civInfo.getUnits().getCivUnits(), GreatGeneralImplementation::getGreatGeneralBonus$lambda$0);
        if (SequencesKt.none(allGenerals)) {
            return new Pair<String, Integer>("", 0);
        }
        Sequence<GeneralBonusData> $this$maxByOrNull$iv = greatGeneral = SequencesKt.filter(SequencesKt.flatMap(allGenerals, arg_0 -> GreatGeneralImplementation.getGreatGeneralBonus$lambda$2(unit, ourUnitCombatant, enemy, combatAction, arg_0)), arg_0 -> GreatGeneralImplementation.getGreatGeneralBonus$lambda$3(unit, arg_0));
        boolean $i$f$maxByOrNull = false;
        Iterator<GeneralBonusData> iterator$iv = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            generalBonusData = null;
        } else {
            GeneralBonusData maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                generalBonusData = maxElem$iv;
            } else {
                GeneralBonusData it = maxElem$iv;
                boolean bl = false;
                int maxValue$iv = it.getBonus();
                do {
                    GeneralBonusData e$iv;
                    GeneralBonusData it2 = e$iv = iterator$iv.next();
                    $i$a$-maxByOrNull-GreatGeneralImplementation$getGreatGeneralBonus$greatGeneralModifier$1 = false;
                    int v$iv = it2.getBonus();
                    if (maxValue$iv >= v$iv) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                generalBonusData = maxElem$iv;
            }
        }
        GeneralBonusData generalBonusData2 = generalBonusData;
        if (generalBonusData2 == null) {
            return new Pair<String, Integer>("", 0);
        }
        GeneralBonusData greatGeneralModifier = generalBonusData2;
        if (MapUnit.hasUnique$default(unit, UniqueType.GreatGeneralProvidesDoubleCombatBonus, null, true, 2, null) && greatGeneralModifier.getGeneral().isGreatPersonOfType("War")) {
            return new Pair<String, Integer>(greatGeneralModifier.getGeneral().getName(), greatGeneralModifier.getBonus() * 2);
        }
        return new Pair<String, Integer>(greatGeneralModifier.getGeneral().getName(), greatGeneralModifier.getBonus());
    }

    /*
     * WARNING - void declaration
     */
    @Readonly
    @Nullable
    public final Tile getBestAffectedTroopsTile(@NotNull MapUnit general) {
        Tile tile;
        Object v0;
        Sequence<Tile> militaryUnitTilesInDistance;
        block10: {
            void $this$firstOrNull$iv;
            Intrinsics.checkNotNullParameter(general, "general");
            militaryUnitTilesInDistance = SequencesKt.filter(SequencesKt.map(MapsKt.asSequence(UnitMovement.getDistanceToTiles$default(general.getMovement(), false, null, null, false, 15, null)), GreatGeneralImplementation::getBestAffectedTroopsTile$lambda$5), arg_0 -> GreatGeneralImplementation.getBestAffectedTroopsTile$lambda$6(general, arg_0));
            Sequence<City> sequence = HeadTowardsEnemyCityAutomation.INSTANCE.getEnemyCitiesByPriority(general);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                City it = (City)element$iv;
                boolean bl = false;
                if (!general.getMovement().canReach(it.getCenterTile())) continue;
                v0 = element$iv;
                break block10;
            }
            v0 = null;
        }
        City closestReachableEnemyCity = v0;
        Sequence<Tile> $this$maxByOrNull$iv = militaryUnitTilesInDistance;
        boolean $i$f$maxByOrNull = false;
        Iterator<Tile> iterator$iv = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            tile = null;
        } else {
            Tile maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                tile = maxElem$iv;
            } else {
                Tile it;
                Object element$iv;
                Sequence<Tile> $this$count$iv;
                Tile unitTile = maxElem$iv;
                boolean bl = false;
                Sequence<Tile> sequence = unitTile.getTilesInDistance(2);
                int n = 2;
                boolean $i$f$count = false;
                int count$iv = 0;
                Iterator<Object> iterator2 = $this$count$iv.iterator();
                while (iterator2.hasNext()) {
                    element$iv = iterator2.next();
                    it = (Tile)element$iv;
                    boolean bl2 = false;
                    MapUnit mapUnit = it.getMilitaryUnit();
                    if (!Intrinsics.areEqual(mapUnit != null ? mapUnit.getCiv() : null, general.getCiv()) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                int n2 = count$iv;
                $this$count$iv = unitTile.getTilesInDistance(2);
                n *= n2;
                $i$f$count = false;
                count$iv = 0;
                iterator2 = $this$count$iv.iterator();
                while (iterator2.hasNext()) {
                    element$iv = iterator2.next();
                    it = (Tile)element$iv;
                    boolean bl3 = false;
                    MapUnit mapUnit = it.getMilitaryUnit();
                    if (!(!Intrinsics.areEqual(mapUnit != null ? mapUnit.getCiv() : null, general.getCiv())) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n2 = count$iv;
                int maxValue$iv = n - n2 - (closestReachableEnemyCity != null ? 3 * unitTile.aerialDistanceTo(closestReachableEnemyCity.getCenterTile()) : 0);
                do {
                    Sequence<Tile> $this$count$iv2;
                    Tile e$iv;
                    Tile unitTile2 = e$iv = iterator$iv.next();
                    $i$a$-maxByOrNull-GreatGeneralImplementation$getBestAffectedTroopsTile$militaryUnitTile$1 = false;
                    Sequence<Tile> $i$f$count2 = unitTile2.getTilesInDistance(2);
                    int n3 = 2;
                    boolean $i$f$count3 = false;
                    int count$iv2 = 0;
                    Iterator<Object> iterator3 = $this$count$iv2.iterator();
                    while (iterator3.hasNext()) {
                        Object element$iv2 = iterator3.next();
                        Tile it2 = (Tile)element$iv2;
                        boolean bl4 = false;
                        MapUnit mapUnit = it2.getMilitaryUnit();
                        if (!Intrinsics.areEqual(mapUnit != null ? mapUnit.getCiv() : null, general.getCiv()) || ++count$iv2 >= 0) continue;
                        CollectionsKt.throwCountOverflow();
                    }
                    int n4 = count$iv2;
                    $this$count$iv2 = unitTile2.getTilesInDistance(2);
                    n3 *= n4;
                    $i$f$count3 = false;
                    count$iv2 = 0;
                    iterator3 = $this$count$iv2.iterator();
                    while (iterator3.hasNext()) {
                        Object element$iv3 = iterator3.next();
                        Tile it3 = (Tile)element$iv3;
                        boolean bl5 = false;
                        MapUnit mapUnit = it3.getMilitaryUnit();
                        if (!(!Intrinsics.areEqual(mapUnit != null ? mapUnit.getCiv() : null, general.getCiv())) || ++count$iv2 >= 0) continue;
                        CollectionsKt.throwCountOverflow();
                    }
                    n4 = count$iv2;
                    int v$iv = n3 - n4 - (closestReachableEnemyCity != null ? 3 * unitTile2.aerialDistanceTo(closestReachableEnemyCity.getCenterTile()) : 0);
                    if (maxValue$iv >= v$iv) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                tile = maxElem$iv;
            }
        }
        Tile militaryUnitTile = tile;
        return militaryUnitTile;
    }

    private static final boolean getGreatGeneralBonus$lambda$0(MapUnit it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getCache().getHasStrengthBonusInRadiusUnique();
    }

    private static final GeneralBonusData getGreatGeneralBonus$lambda$2$lambda$1(MapUnit $general, Unique it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return new GeneralBonusData($general, it);
    }

    private static final Sequence getGreatGeneralBonus$lambda$2(MapUnit $unit, MapUnitCombatant $ourUnitCombatant, ICombatant $enemy, CombatAction $combatAction, MapUnit general) {
        Intrinsics.checkNotNullParameter(general, "general");
        return SequencesKt.map(MapUnit.getMatchingUniques$default(general, UniqueType.StrengthBonusInRadius, new GameContext($unit.getCiv(), null, null, null, $ourUnitCombatant, $enemy, null, $combatAction, null, null, false, 1870, null), false, 4, null), arg_0 -> GreatGeneralImplementation.getGreatGeneralBonus$lambda$2$lambda$1(general, arg_0));
    }

    private static final boolean getGreatGeneralBonus$lambda$3(MapUnit $unit, GeneralBonusData it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getGeneral().getCurrentTile().aerialDistanceTo($unit.getTile()) <= it.getRadius() && (Intrinsics.areEqual(it.getFilter(), "Military") || MapUnit.matchesFilter$default($unit, it.getFilter(), false, 2, null));
    }

    private static final Tile getBestAffectedTroopsTile$lambda$5(Map.Entry it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return (Tile)it.getKey();
    }

    private static final boolean getBestAffectedTroopsTile$lambda$6(MapUnit $general, Tile tile) {
        Intrinsics.checkNotNullParameter(tile, "tile");
        MapUnit militaryUnit = tile.getMilitaryUnit();
        return militaryUnit != null && Intrinsics.areEqual(militaryUnit.getCiv(), $general.getCiv()) && (tile.getCivilianUnit() == null || Intrinsics.areEqual(tile.getCivilianUnit(), $general));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0082\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0004\b\t\u0010\nB\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\t\u0010\rJ\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00c6\u0003J1\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u0007H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0011\u00a8\u0006\u001f"}, d2={"Lcom/unciv/logic/battle/GreatGeneralImplementation$GeneralBonusData;", "", "general", "Lcom/unciv/logic/map/mapunit/MapUnit;", "radius", "", "filter", "", "bonus", "<init>", "(Lcom/unciv/logic/map/mapunit/MapUnit;ILjava/lang/String;I)V", "unique", "Lcom/unciv/models/ruleset/unique/Unique;", "(Lcom/unciv/logic/map/mapunit/MapUnit;Lcom/unciv/models/ruleset/unique/Unique;)V", "getGeneral", "()Lcom/unciv/logic/map/mapunit/MapUnit;", "getRadius", "()I", "getFilter", "()Ljava/lang/String;", "getBonus", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toString", "core"})
    private static final class GeneralBonusData {
        @NotNull
        private final MapUnit general;
        private final int radius;
        @NotNull
        private final String filter;
        private final int bonus;

        public GeneralBonusData(@NotNull MapUnit general, int radius, @NotNull String filter2, int bonus) {
            Intrinsics.checkNotNullParameter(general, "general");
            Intrinsics.checkNotNullParameter(filter2, "filter");
            this.general = general;
            this.radius = radius;
            this.filter = filter2;
            this.bonus = bonus;
        }

        @NotNull
        public final MapUnit getGeneral() {
            return this.general;
        }

        public final int getRadius() {
            return this.radius;
        }

        @NotNull
        public final String getFilter() {
            return this.filter;
        }

        public final int getBonus() {
            return this.bonus;
        }

        public GeneralBonusData(@NotNull MapUnit general, @NotNull Unique unique) {
            Intrinsics.checkNotNullParameter(general, "general");
            Intrinsics.checkNotNullParameter(unique, "unique");
            Integer n = StringsKt.toIntOrNull(unique.getParams().get(2));
            Integer n2 = StringsKt.toIntOrNull(unique.getParams().get(0));
            this(general, n != null ? n : 0, unique.getParams().get(1), n2 != null ? n2 : 0);
        }

        @NotNull
        public final MapUnit component1() {
            return this.general;
        }

        public final int component2() {
            return this.radius;
        }

        @NotNull
        public final String component3() {
            return this.filter;
        }

        public final int component4() {
            return this.bonus;
        }

        @NotNull
        public final GeneralBonusData copy(@NotNull MapUnit general, int radius, @NotNull String filter2, int bonus) {
            Intrinsics.checkNotNullParameter(general, "general");
            Intrinsics.checkNotNullParameter(filter2, "filter");
            return new GeneralBonusData(general, radius, filter2, bonus);
        }

        public static /* synthetic */ GeneralBonusData copy$default(GeneralBonusData generalBonusData, MapUnit mapUnit, int n, String string, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                mapUnit = generalBonusData.general;
            }
            if ((n3 & 2) != 0) {
                n = generalBonusData.radius;
            }
            if ((n3 & 4) != 0) {
                string = generalBonusData.filter;
            }
            if ((n3 & 8) != 0) {
                n2 = generalBonusData.bonus;
            }
            return generalBonusData.copy(mapUnit, n, string, n2);
        }

        @NotNull
        public String toString() {
            return "GeneralBonusData(general=" + this.general + ", radius=" + this.radius + ", filter=" + this.filter + ", bonus=" + this.bonus + ')';
        }

        public int hashCode() {
            int result2 = this.general.hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.radius);
            result2 = result2 * 31 + this.filter.hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.bonus);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof GeneralBonusData)) {
                return false;
            }
            GeneralBonusData generalBonusData = (GeneralBonusData)other;
            if (!Intrinsics.areEqual(this.general, generalBonusData.general)) {
                return false;
            }
            if (this.radius != generalBonusData.radius) {
                return false;
            }
            if (!Intrinsics.areEqual(this.filter, generalBonusData.filter)) {
                return false;
            }
            return this.bonus == generalBonusData.bonus;
        }
    }
}

