/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.automation.unit;

import com.unciv.UncivGame;
import com.unciv.logic.automation.Automation;
import com.unciv.logic.automation.ThreatLevel;
import com.unciv.logic.automation.civilization.NextTurnAutomation;
import com.unciv.logic.automation.unit.RoadBetweenCitiesAutomation;
import com.unciv.logic.automation.unit.RoadToAutomation;
import com.unciv.logic.automation.unit.UnitAutomation;
import com.unciv.logic.city.City;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.MapUnitAction;
import com.unciv.logic.civilization.Notification;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.logic.map.mapunit.movement.UnitMovement;
import com.unciv.logic.map.tile.Tile;
import com.unciv.logic.map.tile.TileStatFunctions;
import com.unciv.logic.map.tile.TileStatFunctionsKt;
import com.unciv.models.UnitAction;
import com.unciv.models.UnitActionType;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.tile.ResourceType;
import com.unciv.models.ruleset.tile.Terrain;
import com.unciv.models.ruleset.tile.TileImprovement;
import com.unciv.models.ruleset.tile.TileResource;
import com.unciv.models.ruleset.unique.GameContext;
import com.unciv.models.ruleset.unique.IHasUniques;
import com.unciv.models.ruleset.unique.LocalUniqueCache;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.stats.Stat;
import com.unciv.models.stats.Stats;
import com.unciv.ui.screens.worldscreen.unit.actions.UnitActions;
import com.unciv.ui.screens.worldscreen.unit.actions.UnitActionsFromUniques;
import com.unciv.utils.LogKt;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import yairm210.purity.annotations.Cache;
import yairm210.purity.annotations.Readonly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\n\u0018\u0000 I2\u00020\u0001:\u0002HIB#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\u0004\b\u0007\u0010\bJ0\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0016\u0010\"\u001a\u0012\u0012\u0004\u0012\u00020\u00190#j\b\u0012\u0004\u0012\u00020\u0019`$2\b\b\u0002\u0010%\u001a\u00020&J \u0010'\u001a\u00020(2\u0006\u0010 \u001a\u00020!2\u0006\u0010%\u001a\u00020&2\u0006\u0010)\u001a\u00020\u0019H\u0002J\u0010\u0010*\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002J \u0010+\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010,\u001a\u00020\u00192\u0006\u0010%\u001a\u00020&H\u0002J(\u0010-\u001a\u0004\u0018\u00010\u00192\u0006\u0010 \u001a\u00020!2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00190/2\u0006\u0010%\u001a\u00020&H\u0003J.\u00100\u001a\u00020(2\u0006\u00101\u001a\u00020\u00192\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00190/2\u0006\u0010)\u001a\u00020\u00192\u0006\u0010 \u001a\u00020!H\u0003J\u0018\u00102\u001a\u0002032\u0006\u00101\u001a\u00020\u00192\u0006\u0010 \u001a\u00020!H\u0007J \u00104\u001a\u0002032\u0006\u00101\u001a\u00020\u00192\u0006\u0010 \u001a\u00020!2\u0006\u0010%\u001a\u00020&H\u0003J \u00105\u001a\u0002032\u0006\u00101\u001a\u00020\u00192\u0006\u0010 \u001a\u00020!2\u0006\u0010%\u001a\u00020&H\u0003J \u00106\u001a\u00020(2\u0006\u00101\u001a\u00020\u00192\u0006\u0010 \u001a\u00020!2\u0006\u0010%\u001a\u00020&H\u0003J\"\u00107\u001a\u0004\u0018\u0001082\u0006\u0010 \u001a\u00020!2\u0006\u00101\u001a\u00020\u00192\u0006\u0010%\u001a\u00020&H\u0003J4\u00109\u001a\u0002032\u0006\u00101\u001a\u00020\u00192\u0006\u0010 \u001a\u00020!2\u0006\u0010:\u001a\u00020;2\u0006\u0010%\u001a\u00020&2\n\b\u0002\u0010<\u001a\u0004\u0018\u00010=H\u0003J$\u0010>\u001a\u00020(2\u0006\u00101\u001a\u00020\u00192\u0012\u0010?\u001a\u000e\u0012\u0004\u0012\u00020;\u0012\u0004\u0012\u0002080@H\u0003J\u0010\u0010A\u001a\u00020(2\u0006\u00101\u001a\u00020\u0019H\u0003J\u0018\u0010B\u001a\u0002032\u0006\u00101\u001a\u00020\u00192\u0006\u0010C\u001a\u00020(H\u0003J\u0018\u0010D\u001a\u00020(2\u0006\u00101\u001a\u00020\u00192\u0006\u0010C\u001a\u00020(H\u0007J\u0010\u0010E\u001a\u00020(2\u0006\u0010:\u001a\u00020;H\u0007J\u0010\u0010E\u001a\u00020(2\u0006\u0010F\u001a\u000208H\u0007J\u000e\u0010G\u001a\u00020(2\u0006\u0010 \u001a\u00020!R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u0017\u001a\u001e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a0\u0018j\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a`\u001b8\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u001c\u0010\u001d\u00a8\u0006J"}, d2={"Lcom/unciv/logic/automation/unit/WorkerAutomation;", "", "civInfo", "Lcom/unciv/logic/civilization/Civilization;", "cachedForTurn", "", "cloningSource", "<init>", "(Lcom/unciv/logic/civilization/Civilization;ILcom/unciv/logic/automation/unit/WorkerAutomation;)V", "getCivInfo", "()Lcom/unciv/logic/civilization/Civilization;", "getCachedForTurn", "()I", "roadToAutomation", "Lcom/unciv/logic/automation/unit/RoadToAutomation;", "getRoadToAutomation", "()Lcom/unciv/logic/automation/unit/RoadToAutomation;", "roadBetweenCitiesAutomation", "Lcom/unciv/logic/automation/unit/RoadBetweenCitiesAutomation;", "getRoadBetweenCitiesAutomation", "()Lcom/unciv/logic/automation/unit/RoadBetweenCitiesAutomation;", "ruleSet", "Lcom/unciv/models/ruleset/Ruleset;", "tileRankings", "Ljava/util/HashMap;", "Lcom/unciv/logic/map/tile/Tile;", "Lcom/unciv/logic/automation/unit/WorkerAutomation$TileImprovementRank;", "Lkotlin/collections/HashMap;", "getTileRankings$annotations", "()V", "automateWorkerAction", "", "unit", "Lcom/unciv/logic/map/mapunit/MapUnit;", "dangerousTiles", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "localUniqueCache", "Lcom/unciv/models/ruleset/unique/LocalUniqueCache;", "tryHeadTowardsUndevelopedCity", "", "currentTile", "startWorkOnCurrentTile", "headTowardsTileToWork", "tileToWork", "findTileToWork", "tilesToAvoid", "", "isAutomationWorkableTile", "tile", "getBasePriority", "", "getImprovementPriority", "getFullPriority", "tileHasWorkToDo", "chooseImprovement", "Lcom/unciv/models/ruleset/tile/TileImprovement;", "getImprovementRanking", "improvementName", "", "currentTileStats", "Lcom/unciv/models/stats/Stats;", "isResourceImprovementAllowedOnFeature", "potentialTileImprovements", "", "isAcceptableTileForFort", "evaluateFortSurroundings", "isCitadel", "evaluateFortPlacement", "isImprovementProbablyAFort", "improvement", "automateWorkBoats", "TileImprovementRank", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nWorkerAutomation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WorkerAutomation.kt\ncom/unciv/logic/automation/unit/WorkerAutomation\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,718:1\n1276#2,2:719\n2275#2,2:721\n1278#2:723\n622#2:724\n183#2,2:725\n996#2:727\n1025#2,3:728\n1028#2,3:738\n622#2:741\n2275#2,2:743\n1255#2,2:745\n1463#2,14:754\n1255#2,2:785\n1232#2,2:795\n608#2:852\n183#2,2:853\n382#3,7:731\n536#3:747\n521#3,6:748\n1056#4:742\n774#4:768\n865#4,2:769\n1999#4,14:771\n295#4,2:787\n1761#4,2:789\n1761#4,3:791\n1763#4:794\n774#4:797\n865#4,2:798\n1869#4:800\n1563#4:801\n1634#4,3:802\n1870#4:805\n2423#4,14:806\n2423#4,14:820\n1563#4:834\n1634#4,3:835\n2393#4,14:838\n*S KotlinDebug\n*F\n+ 1 WorkerAutomation.kt\ncom/unciv/logic/automation/unit/WorkerAutomation\n*L\n126#1:719,2\n128#1:721,2\n126#1:723\n135#1:724\n136#1:725,2\n226#1:727\n226#1:728,3\n226#1:738,3\n227#1:741\n266#1:743,2\n296#1:745,2\n390#1:754,14\n464#1:785,2\n572#1:795,2\n677#1:852\n678#1:853,2\n226#1:731,7\n379#1:747\n379#1:748,6\n234#1:742\n413#1:768\n413#1:769,2\n414#1:771,14\n475#1:787,2\n533#1:789,2\n536#1:791,3\n533#1:794\n617#1:797\n617#1:798,2\n624#1:800\n624#1:801\n624#1:802,3\n624#1:805\n627#1:806,14\n630#1:820,14\n633#1:834\n633#1:835,3\n633#1:838,14\n*E\n"})
public final class WorkerAutomation {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Civilization civInfo;
    private final int cachedForTurn;
    @NotNull
    private final RoadToAutomation roadToAutomation;
    @NotNull
    private final RoadBetweenCitiesAutomation roadBetweenCitiesAutomation;
    @NotNull
    private final Ruleset ruleSet;
    @NotNull
    private final HashMap<Tile, TileImprovementRank> tileRankings;

    public WorkerAutomation(@NotNull Civilization civInfo, int cachedForTurn, @Nullable WorkerAutomation cloningSource) {
        Intrinsics.checkNotNullParameter(civInfo, "civInfo");
        this.civInfo = civInfo;
        this.cachedForTurn = cachedForTurn;
        this.roadToAutomation = new RoadToAutomation(this.civInfo);
        WorkerAutomation workerAutomation = cloningSource;
        this.roadBetweenCitiesAutomation = new RoadBetweenCitiesAutomation(this.civInfo, this.cachedForTurn, workerAutomation != null ? workerAutomation.roadBetweenCitiesAutomation : null);
        this.ruleSet = this.civInfo.getGameInfo().getRuleset();
        this.tileRankings = new HashMap();
    }

    public /* synthetic */ WorkerAutomation(Civilization civilization, int n, WorkerAutomation workerAutomation, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            workerAutomation = null;
        }
        this(civilization, n, workerAutomation);
    }

    @NotNull
    public final Civilization getCivInfo() {
        return this.civInfo;
    }

    public final int getCachedForTurn() {
        return this.cachedForTurn;
    }

    @NotNull
    public final RoadToAutomation getRoadToAutomation() {
        return this.roadToAutomation;
    }

    @NotNull
    public final RoadBetweenCitiesAutomation getRoadBetweenCitiesAutomation() {
        return this.roadBetweenCitiesAutomation;
    }

    @Cache
    private static /* synthetic */ void getTileRankings$annotations() {
    }

    public final void automateWorkerAction(@NotNull MapUnit unit, @NotNull HashSet<Tile> dangerousTiles, @NotNull LocalUniqueCache localUniqueCache) {
        Intrinsics.checkNotNullParameter(unit, "unit");
        Intrinsics.checkNotNullParameter(dangerousTiles, "dangerousTiles");
        Intrinsics.checkNotNullParameter(localUniqueCache, "localUniqueCache");
        Tile currentTile = unit.getTile();
        List<City> citiesToConnect = this.roadBetweenCitiesAutomation.getNearbyCitiesToConnect$core(unit);
        if (currentTile.getImprovementInProgress() != null && !dangerousTiles.contains(currentTile) && this.getFullPriority(unit.getTile(), unit, localUniqueCache) >= 2.0f) {
            return;
        }
        Tile tileToWork = this.findTileToWork(unit, (Set<Tile>)dangerousTiles, localUniqueCache);
        if (!Intrinsics.areEqual(tileToWork, currentTile) && tileToWork != null) {
            this.headTowardsTileToWork(unit, tileToWork, localUniqueCache);
            return;
        }
        if (currentTile.getImprovementInProgress() != null) {
            return;
        }
        if (Intrinsics.areEqual(tileToWork, currentTile) && this.tileHasWorkToDo(currentTile, unit, localUniqueCache)) {
            this.startWorkOnCurrentTile(unit);
            return;
        }
        if (unit.getCache().getHasUniqueToCreateWaterImprovements() && this.automateWorkBoats(unit)) {
            return;
        }
        if (this.tryHeadTowardsUndevelopedCity(unit, localUniqueCache, currentTile)) {
            return;
        }
        if (this.roadBetweenCitiesAutomation.tryConnectingCities$core(unit, citiesToConnect)) {
            return;
        }
        Object[] objectArray = new Object[]{unit.toString()};
        LogKt.debug("WorkerAutomation: %s -> nothing to do", objectArray);
        objectArray = new String[]{unit.getName(), "OtherIcons/Sleep"};
        unit.getCiv().addNotification(unit.shortDisplayName() + " has no work to do.", new MapUnitAction(unit), Notification.NotificationCategory.Units, (String[])objectArray);
        if (unit.getCiv().isCityState()) {
            UnitAutomation.INSTANCE.wander(unit, true, (Set<Tile>)dangerousTiles);
        }
    }

    public static /* synthetic */ void automateWorkerAction$default(WorkerAutomation workerAutomation, MapUnit mapUnit, HashSet hashSet, LocalUniqueCache localUniqueCache, int n, Object object) {
        if ((n & 4) != 0) {
            localUniqueCache = new LocalUniqueCache(false, 1, null);
        }
        workerAutomation.automateWorkerAction(mapUnit, hashSet, localUniqueCache);
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private final boolean tryHeadTowardsUndevelopedCity(MapUnit unit, LocalUniqueCache localUniqueCache, Tile currentTile) {
        block9: {
            citiesToNumberOfUnimprovedTiles = new HashMap<K, V>();
            for (Object city : unit.getCiv().getCities()) {
                var7_7 = citiesToNumberOfUnimprovedTiles;
                var8_9 = city.getId();
                var9_10 = city.getTiles();
                $i$f$count = false;
                count$iv = 0;
                var12_14 = $this$count$iv.iterator();
                while (var12_14.hasNext()) {
                    block8: {
                        element$iv = var12_14.next();
                        tile = (Tile)element$iv;
                        $i$a$-count-WorkerAutomation$tryHeadTowardsUndevelopedCity$1 = false;
                        if (!tile.isLand()) ** GOTO lbl-1000
                        $this$none$iv = tile.getUnits();
                        $i$f$none = false;
                        var18_20 = $this$none$iv.iterator();
                        while (var18_20.hasNext()) {
                            unit = element$iv = var18_20.next();
                            $i$a$-none-WorkerAutomation$tryHeadTowardsUndevelopedCity$1$1 = false;
                            if (!unit.getCache().getHasUniqueToBuildImprovements()) continue;
                            v0 = false;
                            break block8;
                        }
                        v0 = true;
                    }
                    if (v0 && (tile.isPillaged() || this.tileHasWorkToDo(tile, unit, localUniqueCache))) {
                        v1 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v1 = false;
                    }
                    if (!v1 || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                $this$count$iv = count$iv;
                var7_7.put(var8_9, $this$count$iv);
            }
            city = SequencesKt.filter(CollectionsKt.asSequence((Iterable)unit.getCiv().getCities()), (Function1<City, Boolean>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, tryHeadTowardsUndevelopedCity$lambda$2(java.util.HashMap com.unciv.logic.city.City ), (Lcom/unciv/logic/city/City;)Ljava/lang/Boolean;)(citiesToNumberOfUnimprovedTiles));
            $i$f$sortedByDescending = false;
            $this$sortedByDescending$iv = SequencesKt.sortedWith($this$sortedByDescending$iv, new Comparator(currentTile){
                final /* synthetic */ Tile $currentTile$inlined;
                {
                    this.$currentTile$inlined = tile;
                }

                public final int compare(T a, T b) {
                    City it = (City)b;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it.getCenterTile().aerialDistanceTo(this.$currentTile$inlined));
                    it = (City)a;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues(comparable2, it.getCenterTile().aerialDistanceTo(this.$currentTile$inlined));
                }
            });
            $i$f$firstOrNull = false;
            for (E element$iv : $this$firstOrNull$iv) {
                it = (City)element$iv;
                $i$a$-firstOrNull-WorkerAutomation$tryHeadTowardsUndevelopedCity$closestUndevelopedCity$3 = false;
                if (!unit.getMovement().canReach(it.getCenterTile())) continue;
                v2 = element$iv;
                break block9;
            }
            v2 = null;
        }
        closestUndevelopedCity = v2;
        if (closestUndevelopedCity != null && !Intrinsics.areEqual(closestUndevelopedCity, currentTile.getOwningCity())) {
            $this$firstOrNull$iv = new Object[]{unit, closestUndevelopedCity.getName()};
            LogKt.debug("WorkerAutomation: %s -> head towards undeveloped city %s", $this$firstOrNull$iv);
            reachedTile = unit.getMovement().headTowards(closestUndevelopedCity.getCenterTile());
            if (!Intrinsics.areEqual(reachedTile, currentTile)) {
                unit.doAction();
            }
            return true;
        }
        return false;
    }

    private final void startWorkOnCurrentTile(MapUnit unit) {
        Tile currentTile = unit.getCurrentTile();
        TileImprovementRank tileImprovementRank = this.tileRankings.get(currentTile);
        Intrinsics.checkNotNull(tileImprovementRank);
        TileImprovementRank tileRanking = tileImprovementRank;
        if (Intrinsics.areEqual(tileRanking.getRepairImprovment(), true)) {
            LogKt.debug("WorkerAutomation: " + unit + " -> repairs " + currentTile, new Object[0]);
            Object object = UnitActionsFromUniques.INSTANCE.getRepairAction(unit);
            if (object != null && (object = ((UnitAction)object).getAction()) != null) {
                object.invoke();
            }
            return;
        }
        if (tileRanking.getBestImprovement() != null) {
            LogKt.debug("WorkerAutomation: " + unit + "} -> start improving " + currentTile, new Object[0]);
            TileImprovement tileImprovement = tileRanking.getBestImprovement();
            Intrinsics.checkNotNull(tileImprovement);
            currentTile.startWorkingOnImprovement(tileImprovement, this.civInfo, unit);
            return;
        }
        throw new IllegalStateException("We didn't find anything to improve on this tile even though there was supposed to be something to improve!");
    }

    private final void headTowardsTileToWork(MapUnit unit, Tile tileToWork, LocalUniqueCache localUniqueCache) {
        Object[] objectArray = new Object[]{unit.toString(), tileToWork};
        LogKt.debug("WorkerAutomation: %s -> head towards %s", objectArray);
        Tile currentTile = unit.getTile();
        Tile reachedTile = unit.getMovement().headTowards(tileToWork);
        if (SequencesKt.contains(reachedTile.getNeighbors(), tileToWork) && UnitMovement.canMoveTo$default(unit.getMovement(), tileToWork, false, true, false, 10, null) && !UnitMovement.canMoveTo$default(unit.getMovement(), tileToWork, false, false, false, 10, null) && unit.getMovement().canUnitSwapTo(tileToWork)) {
            unit.getMovement().swapMoveToTile(tileToWork);
        }
        if (!Intrinsics.areEqual(reachedTile, currentTile)) {
            unit.doAction();
        }
        if (Intrinsics.areEqual(reachedTile, tileToWork) && Intrinsics.areEqual(reachedTile.getImprovementInProgress(), "Fort") && this.evaluateFortSurroundings(currentTile, false) <= 0.0f) {
            LogKt.debug("Replacing fort in progress with new improvement", new Object[0]);
            reachedTile.stopWorkingOnImprovement();
        }
        if (!unit.hasMovement() || !Intrinsics.areEqual(reachedTile, tileToWork)) {
            return;
        }
        if (this.tileHasWorkToDo(unit.getCurrentTile(), unit, localUniqueCache)) {
            this.startWorkOnCurrentTile(unit);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Readonly
    private final Tile findTileToWork(MapUnit unit, Set<Tile> tilesToAvoid, LocalUniqueCache localUniqueCache) {
        void $this$groupByTo$iv$iv;
        Sequence<Tile> workableTilesCenterFirst;
        Tile currentTile = unit.getTile();
        if (this.isAutomationWorkableTile(currentTile, tilesToAvoid, currentTile, unit) && this.getBasePriority(currentTile, unit) >= 5.0f && (currentTile.isPillaged() || currentTile.hasFalloutEquivalent() || this.tileHasWorkToDo(currentTile, unit, localUniqueCache))) {
            return currentTile;
        }
        Sequence<Tile> $this$groupBy$iv = workableTilesCenterFirst = SequencesKt.filter(currentTile.getTilesInDistance(3), arg_0 -> WorkerAutomation.findTileToWork$lambda$5(this, tilesToAvoid, currentTile, unit, arg_0));
        boolean $i$f$groupBy = false;
        Sequence<Tile> sequence = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            Tile it = (Tile)element$iv$iv;
            boolean bl = false;
            Float key$iv$iv = Float.valueOf(this.getBasePriority(it, unit));
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Sequence $this$sortedByDescending$iv = MapsKt.asSequence(destination$iv$iv);
        boolean $i$f$sortedByDescending = false;
        Sequence workableTilesPrioritized = SequencesKt.sortedWith($this$sortedByDescending$iv, new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry it = (Map.Entry)b;
                boolean bl = false;
                Comparable comparable = (Float)it.getKey();
                it = (Map.Entry)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, (Comparable)((Float)it.getKey()));
            }
        });
        Iterator iterator2 = workableTilesPrioritized.iterator();
        while (iterator2.hasNext()) {
            Map.Entry tilePriorityGroup = iterator2.next();
            Tile bestTile = null;
            Iterable $this$sortedBy$iv = (Iterable)tilePriorityGroup.getValue();
            boolean $i$f$sortedBy = false;
            for (Tile tileInGroup : CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(unit){
                final /* synthetic */ MapUnit $unit$inlined;
                {
                    this.$unit$inlined = mapUnit;
                }

                public final int compare(T a, T b) {
                    Tile it = (Tile)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(this.$unit$inlined.getTile().aerialDistanceTo(it));
                    it = (Tile)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues(comparable2, this.$unit$inlined.getTile().aerialDistanceTo(it));
                }
            })) {
                if (!this.tileHasWorkToDo(tileInGroup, unit, localUniqueCache)) continue;
                if (Intrinsics.areEqual(unit.getTile(), tileInGroup)) {
                    return unit.getTile();
                }
                if (!unit.getMovement().canReach(tileInGroup) || bestTile != null && !(this.getFullPriority(tileInGroup, unit, localUniqueCache) > this.getFullPriority(bestTile, unit, localUniqueCache))) continue;
                bestTile = tileInGroup;
            }
            if (bestTile == null) continue;
            return bestTile;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Readonly
    private final boolean isAutomationWorkableTile(Tile tile, Set<Tile> tilesToAvoid, Tile currentTile, MapUnit unit) {
        block13: {
            block14: {
                if (tilesToAvoid.contains(tile)) {
                    return false;
                }
                if (Intrinsics.areEqual(tile, currentTile)) break block13;
                if (!unit.isCivilian()) break block14;
                if (tile.getCivilianUnit() == null) break block13;
                MapUnit mapUnit = tile.getCivilianUnit();
                Intrinsics.checkNotNull(mapUnit);
                if (!mapUnit.getCache().getHasUniqueToBuildImprovements()) break block13;
            }
            if (!unit.isMilitary()) return false;
            if (tile.getMilitaryUnit() != null) {
                MapUnit mapUnit = tile.getMilitaryUnit();
                Intrinsics.checkNotNull(mapUnit);
                if (mapUnit.getCache().getHasUniqueToBuildImprovements()) {
                    return false;
                }
            }
        }
        if (tile.getOwningCity() != null && !Intrinsics.areEqual(tile.getOwner(), this.civInfo)) {
            return false;
        }
        if (tile.isCityCenter()) {
            return false;
        }
        if (!tile.hasViewableResource(this.civInfo)) {
            boolean bl;
            void $this$none$iv;
            Sequence<Tile> sequence = tile.getTilesInDistance(this.civInfo.getGameInfo().getRuleset().getModOptions().getConstants().getCityWorkRange());
            boolean $i$f$none = false;
            Iterator iterator2 = $this$none$iv.iterator();
            do {
                if (!iterator2.hasNext()) return false;
                Object element$iv = iterator2.next();
                Tile it = (Tile)element$iv;
                boolean bl2 = false;
                if (it.isCityCenter()) {
                    City city = it.getCity();
                    if (Intrinsics.areEqual(city != null ? city.getCiv() : null, this.civInfo)) {
                        bl = true;
                        continue;
                    }
                }
                bl = false;
            } while (!bl);
            boolean bl3 = false;
            if (bl3) {
                return false;
            }
        }
        TileImprovement tileImprovement = tile.getTileImprovement();
        if (tileImprovement == null) return true;
        if (!IHasUniques.hasUnique$default(tileImprovement, UniqueType.AutomatedUnitsWillNotReplace, null, 2, null)) return true;
        boolean bl = true;
        if (!bl) return true;
        if (tile.isPillaged()) return true;
        return false;
    }

    @Readonly
    public final float getBasePriority(@NotNull Tile tile, @NotNull MapUnit unit) {
        Intrinsics.checkNotNullParameter(tile, "tile");
        Intrinsics.checkNotNullParameter(unit, "unit");
        float unitSpecificPriority = (float)2 - RangesKt.coerceIn((float)tile.aerialDistanceTo(unit.getTile()) / 2.0f, 0.0f, 2.0f) * (float)3;
        if (this.tileRankings.containsKey(tile)) {
            TileImprovementRank tileImprovementRank = this.tileRankings.get(tile);
            Intrinsics.checkNotNull(tileImprovementRank);
            return tileImprovementRank.getTilePriority() + unitSpecificPriority;
        }
        float priority = 0.0f;
        if (Intrinsics.areEqual(tile.getOwner(), this.civInfo)) {
            priority += Automation.INSTANCE.rankStatsValue(TileStatFunctionsKt.toStats(TileStatFunctions.getTerrainStatsBreakdown$default(tile.getStats(), null, 1, null)), this.civInfo);
            if (tile.providesYield()) {
                priority += (float)2;
            }
            if (tile.isPillaged()) {
                priority += 1.0f;
            }
            if (tile.hasFalloutEquivalent()) {
                priority += 1.0f;
            }
            if (!((Collection)tile.getTerrainFeatures()).isEmpty()) {
                if (IHasUniques.hasUnique$default(tile.getLastTerrain(), UniqueType.ProductionBonusWhenRemoved, null, 2, null)) {
                    priority += 0.5f;
                } else if (IHasUniques.hasUnique$default(tile.getLastTerrain(), UniqueType.Vegetation, null, 2, null)) {
                    priority -= 0.3f;
                }
            }
            if (Tile.terrainHasUnique$default(tile, UniqueType.FreshWater, null, 2, null)) {
                priority += 1.0f;
            }
        } else if (tile.getOwner() == null) {
            boolean bl;
            block16: {
                Sequence<Tile> $this$any$iv = tile.getNeighbors();
                boolean $i$f$any = false;
                Iterator<Tile> iterator2 = $this$any$iv.iterator();
                while (iterator2.hasNext()) {
                    Tile element$iv;
                    Tile it = element$iv = iterator2.next();
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual(it.getOwner(), this.civInfo)) continue;
                    bl = true;
                    break block16;
                }
                bl = false;
            }
            if (bl) {
                priority += 1.0f;
            }
        }
        if (tile.hasViewableResource(this.civInfo)) {
            priority += 1.0f;
            if (tile.getTileResource().getResourceType() == ResourceType.Luxury) {
                priority += (float)5;
            }
        }
        ((Map)this.tileRankings).put(tile, new TileImprovementRank(priority, null, null, null, 14, null));
        return priority + unitSpecificPriority;
    }

    @Readonly
    private final float getImprovementPriority(Tile tile, MapUnit unit, LocalUniqueCache localUniqueCache) {
        TileImprovementRank rank;
        block8: {
            block9: {
                this.getBasePriority(tile, unit);
                TileImprovementRank tileImprovementRank = rank = this.tileRankings.get(tile);
                Intrinsics.checkNotNull(tileImprovementRank);
                if (tileImprovementRank.getImprovementPriority() == null) {
                    rank.setImprovementPriority(Float.valueOf(-100.0f));
                    rank.setBestImprovement(null);
                    rank.setRepairImprovment(false);
                    TileImprovement bestImprovement = this.chooseImprovement(unit, tile, localUniqueCache);
                    if (bestImprovement != null) {
                        rank.setBestImprovement(bestImprovement);
                        int timeSpentPriority = Intrinsics.areEqual(tile.getImprovementInProgress(), bestImprovement.getName()) ? bestImprovement.getTurnsToBuild(unit.getCiv(), unit) - tile.getTurnsToImprovement() : 0;
                        TileImprovement tileImprovement = rank.getBestImprovement();
                        Intrinsics.checkNotNull(tileImprovement);
                        rank.setImprovementPriority(Float.valueOf(WorkerAutomation.getImprovementRanking$default(this, tile, unit, tileImprovement.getName(), localUniqueCache, null, 16, null) + (float)timeSpentPriority));
                    }
                    if (tile.getImprovement() != null && tile.isPillaged() && tile.getOwningCity() != null) {
                        TileImprovement tileImprovement = tile.getImprovementToRepair();
                        Intrinsics.checkNotNull(tileImprovement);
                        int repairBonusPriority = tileImprovement.getTurnsToBuild(unit.getCiv(), unit) - UnitActionsFromUniques.INSTANCE.getRepairTurns$core(unit);
                        if (Intrinsics.areEqual(tile.getImprovementInProgress(), "Repair")) {
                            repairBonusPriority += UnitActionsFromUniques.INSTANCE.getRepairTurns$core(unit) - tile.getTurnsToImprovement();
                        }
                        float f = repairBonusPriority;
                        TileStatFunctions tileStatFunctions = tile.getStats();
                        TileImprovement tileImprovement2 = tile.getTileImprovement();
                        Intrinsics.checkNotNull(tileImprovement2);
                        float repairPriority = f + Automation.INSTANCE.rankStatsValue(TileStatFunctions.getStatDiffForImprovement$default(tileStatFunctions, tileImprovement2, unit.getCiv(), tile.getOwningCity(), null, null, 24, null), unit.getCiv());
                        Float f2 = rank.getImprovementPriority();
                        Intrinsics.checkNotNull(f2);
                        if (repairPriority > f2.floatValue()) {
                            rank.setImprovementPriority(Float.valueOf(repairPriority));
                            rank.setBestImprovement(null);
                            rank.setRepairImprovment(true);
                        }
                    }
                }
                Boolean bl = rank.getRepairImprovment();
                Intrinsics.checkNotNull(bl);
                if (bl.booleanValue()) break block8;
                if (rank.getBestImprovement() == null) break block9;
                TileImprovement tileImprovement = rank.getBestImprovement();
                Intrinsics.checkNotNull(tileImprovement);
                if (unit.canBuildImprovement(tileImprovement, tile)) break block8;
            }
            return -100.0f;
        }
        Float f = rank.getImprovementPriority();
        Intrinsics.checkNotNull(f);
        return f.floatValue();
    }

    @Readonly
    private final float getFullPriority(Tile tile, MapUnit unit, LocalUniqueCache localUniqueCache) {
        return this.getBasePriority(tile, unit) + this.getImprovementPriority(tile, unit, localUniqueCache);
    }

    @Readonly
    private final boolean tileHasWorkToDo(Tile tile, MapUnit unit, LocalUniqueCache localUniqueCache) {
        if (this.getImprovementPriority(tile, unit, localUniqueCache) <= 0.0f) {
            return false;
        }
        TileImprovementRank tileImprovementRank = this.tileRankings.get(tile);
        Intrinsics.checkNotNull(tileImprovementRank);
        if (tileImprovementRank.getBestImprovement() == null) {
            TileImprovementRank tileImprovementRank2 = this.tileRankings.get(tile);
            Intrinsics.checkNotNull(tileImprovementRank2);
            Boolean bl = tileImprovementRank2.getRepairImprovment();
            Intrinsics.checkNotNull(bl);
            if (!bl.booleanValue()) {
                throw new IllegalStateException("There was an improvementPriority > 0 and nothing to do");
            }
        }
        return true;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Readonly
    private final TileImprovement chooseImprovement(MapUnit unit, Tile tile, LocalUniqueCache localUniqueCache) {
        block27: {
            block29: {
                block28: {
                    block26: {
                        if (tile.getImprovementInProgress() != null) {
                            v0 = this.ruleSet.getTileImprovements();
                            v1 = tile.getImprovementInProgress();
                            Intrinsics.checkNotNull(v1);
                            return v0.get(v1);
                        }
                        gameContext = new GameContext(unit.getCiv(), null, unit, tile, null, null, null, null, null, null, false, 2034, null);
                        $this$filter$iv = this.ruleSet.getTileImprovements();
                        $i$f$filter = false;
                        var8_8 = $this$filter$iv;
                        destination$iv$iv = new LinkedHashMap<K, V>();
                        $i$f$filterTo = false;
                        for (Map.Entry<K, V> element$iv$iv : $this$filterTo$iv$iv.entrySet()) {
                            block25: {
                                it = element$iv$iv;
                                $i$a$-filter-WorkerAutomation$chooseImprovement$potentialTileImprovements$1 = false;
                                if (((TileImprovement)it.getValue()).getUniqueTo() == null) break block25;
                                v2 = unit.getCiv();
                                v3 = ((TileImprovement)it.getValue()).getUniqueTo();
                                Intrinsics.checkNotNull(v3);
                                if (!Civilization.matchesFilter$default(v2, v3, gameContext, false, 4, null)) ** GOTO lbl-1000
                            }
                            if (unit.canBuildImprovement((TileImprovement)it.getValue(), tile) && tile.getImprovementFunctions().canBuildImprovement((TileImprovement)it.getValue(), gameContext)) {
                                v4 = true;
                            } else lbl-1000:
                            // 2 sources

                            {
                                v4 = false;
                            }
                            if (!v4) continue;
                            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
                        }
                        potentialTileImprovements = destination$iv$iv;
                        if (potentialTileImprovements.isEmpty()) {
                            return null;
                        }
                        currentTileStats = tile.getStats().getTileStats(tile.getCity(), this.civInfo, localUniqueCache);
                        destination$iv$iv = SequencesKt.filter(SequencesKt.map(CollectionsKt.asSequence((Iterable)potentialTileImprovements.values()), (Function1<TileImprovement, Pair>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, chooseImprovement$lambda$12(com.unciv.logic.automation.unit.WorkerAutomation com.unciv.logic.map.tile.Tile com.unciv.logic.map.mapunit.MapUnit com.unciv.models.ruleset.unique.LocalUniqueCache com.unciv.models.stats.Stats com.unciv.models.ruleset.tile.TileImprovement ), (Lcom/unciv/models/ruleset/tile/TileImprovement;)Lkotlin/Pair;)((WorkerAutomation)this, (Tile)tile, (MapUnit)unit, (LocalUniqueCache)localUniqueCache, (Stats)currentTileStats)), (Function1<Pair, Boolean>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, chooseImprovement$lambda$13(kotlin.Pair ), (Lkotlin/Pair;)Ljava/lang/Boolean;)());
                        $i$f$maxByOrNull = false;
                        iterator$iv = $this$maxByOrNull$iv.iterator();
                        if (!iterator$iv.hasNext()) {
                            v5 = null;
                        } else {
                            maxElem$iv /* !! */  = iterator$iv.next();
                            if (!iterator$iv.hasNext()) {
                                v5 = maxElem$iv /* !! */ ;
                            } else {
                                it = (Pair)maxElem$iv /* !! */ ;
                                $i$a$-maxByOrNull-WorkerAutomation$chooseImprovement$bestBuildableImprovement$3 = false;
                                maxValue$iv = ((Number)it.getSecond()).floatValue();
                                do {
                                    e$iv = iterator$iv.next();
                                    it = (Pair)e$iv;
                                    $i$a$-maxByOrNull-WorkerAutomation$chooseImprovement$bestBuildableImprovement$3 = false;
                                    v$iv = ((Number)it.getSecond()).floatValue();
                                    if (Float.compare(maxValue$iv, v$iv) >= 0) continue;
                                    maxElem$iv /* !! */  = e$iv;
                                    maxValue$iv = v$iv;
                                } while (iterator$iv.hasNext());
                                v5 = maxElem$iv /* !! */ ;
                            }
                        }
                        $this$filterTo$iv$iv = v5;
                        v6 = bestBuildableImprovement = $this$filterTo$iv$iv != null ? (TileImprovement)$this$filterTo$iv$iv.getFirst() : null;
                        if (tile.getImprovement() != null && this.civInfo.isHuman() && !UncivGame.Companion.getCurrent().getSettings().getAutomatedWorkersReplaceImprovements()) {
                            v7 = UncivGame.Companion.getCurrent().getWorldScreen();
                            v8 = v7 != null && (v7 = v7.getAutoPlay()) != null ? !v7.isAutoPlayingAndFullAutoPlayAI() : false;
                            if (v8) {
                                bestBuildableImprovement = null;
                            }
                        }
                        lastTerrain = tile.getLastTerrain();
                        if (tile.getResource() == null || !tile.hasViewableResource(this.civInfo)) {
                            v9 = null;
                        } else if (((Collection)tile.getTerrainFeatures()).isEmpty() == false && lastTerrain.getUnbuildable() && WorkerAutomation.chooseImprovement$isRemovable((Map<String, TileImprovement>)potentialTileImprovements, lastTerrain) && !tile.providesResources(this.civInfo) && !this.isResourceImprovementAllowedOnFeature(tile, (Map<String, TileImprovement>)potentialTileImprovements)) {
                            v9 = "Remove " + lastTerrain.getName();
                        } else {
                            $this$filter$iv = tile.getTileResource().getImprovements();
                            $i$f$filter = false;
                            maxElem$iv /* !! */  = $this$filter$iv;
                            destination$iv$iv = new ArrayList<E>();
                            $i$f$filterTo = false;
                            for (T element$iv$iv : $this$filterTo$iv$iv) {
                                it = (String)element$iv$iv;
                                $i$a$-filter-WorkerAutomation$chooseImprovement$improvementStringForResource$1 = false;
                                if (!(potentialTileImprovements.containsKey(it) != false || Intrinsics.areEqual(it, tile.getImprovement()) != false)) continue;
                                destination$iv$iv.add(element$iv$iv);
                            }
                            $this$filter$iv = (List)destination$iv$iv;
                            $i$f$maxByOrNull = false;
                            iterator$iv = $this$maxByOrNull$iv.iterator();
                            if (!iterator$iv.hasNext()) {
                                v10 = null;
                            } else {
                                maxElem$iv = iterator$iv.next();
                                if (!iterator$iv.hasNext()) {
                                    v10 = maxElem$iv;
                                } else {
                                    it = (String)maxElem$iv;
                                    $i$a$-maxByOrNull-WorkerAutomation$chooseImprovement$improvementStringForResource$2 = false;
                                    maxValue$iv = WorkerAutomation.getImprovementRanking$default(this, tile, unit, it, localUniqueCache, null, 16, null);
                                    do {
                                        e$iv = iterator$iv.next();
                                        it = (String)e$iv;
                                        $i$a$-maxByOrNull-WorkerAutomation$chooseImprovement$improvementStringForResource$2 = false;
                                        v$iv = WorkerAutomation.getImprovementRanking$default(this, tile, unit, it, localUniqueCache, null, 16, null);
                                        if (Float.compare(maxValue$iv, v$iv) >= 0) continue;
                                        maxElem$iv = e$iv;
                                        maxValue$iv = v$iv;
                                    } while (iterator$iv.hasNext());
                                    v10 = maxElem$iv;
                                }
                            }
                            v9 = v10;
                        }
                        improvementStringForResource = v9;
                        if (bestBuildableImprovement == null || !bestBuildableImprovement.isRoad()) break block26;
                        v11 /* !! */  = bestBuildableImprovement.getName();
                        break block27;
                    }
                    if (improvementStringForResource == null || tile.getTileResource().getResourceType() == ResourceType.Bonus) break block28;
                    v11 /* !! */  = Intrinsics.areEqual(improvementStringForResource, tile.getImprovement()) ? null : improvementStringForResource;
                    break block27;
                }
                if (tile.getResource() != null && tile.hasViewableResource(this.civInfo) && tile.getTileResource().getResourceType() != ResourceType.Bonus && CollectionsKt.any((Iterable)tile.getTileResource().getImprovements())) {
                    return null;
                }
                if (bestBuildableImprovement != null) break block29;
                v11 /* !! */  = null;
                break block27;
            }
            if (tile.getImprovement() == null) ** GOTO lbl-1000
            v12 = tile.getImprovement();
            Intrinsics.checkNotNull(v12);
            if (WorkerAutomation.getImprovementRanking$default(this, tile, unit, v12, localUniqueCache, null, 16, null) > WorkerAutomation.getImprovementRanking$default(this, tile, unit, bestBuildableImprovement.getName(), localUniqueCache, null, 16, null)) {
                v11 /* !! */  = null;
            } else lbl-1000:
            // 2 sources

            {
                it = lastTerrain;
                $i$a$-let-WorkerAutomation$chooseImprovement$improvementString$1 = false;
                v11 /* !! */  = (WorkerAutomation.chooseImprovement$isRemovable((Map<String, TileImprovement>)potentialTileImprovements, it) && (Automation.INSTANCE.rankStatsValue(it, this.civInfo) < 0.0f || IHasUniques.hasUnique$default(it, UniqueType.NullifyYields, null, 2, null))) != false ? "Remove " + lastTerrain.getName() : bestBuildableImprovement.getName();
            }
        }
        improvementString = v11 /* !! */ ;
        return (TileImprovement)((Map)this.ruleSet.getTileImprovements()).get(improvementString);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Readonly
    private final float getImprovementRanking(Tile tile, MapUnit unit, String improvementName, LocalUniqueCache localUniqueCache, Stats currentTileStats) {
        boolean isResourceImprovedByNewImprovement;
        TileImprovement tileImprovement = this.ruleSet.getTileImprovements().get(improvementName);
        Intrinsics.checkNotNull(tileImprovement);
        TileImprovement improvement = tileImprovement;
        if (improvement.isRoad() && Intrinsics.areEqual(this.roadBetweenCitiesAutomation.getBestRoadAvailable$core().improvement(this.ruleSet), improvement) && ((Map)this.roadBetweenCitiesAutomation.getTilesOfRoadsMap$core()).containsKey(tile)) {
            RoadBetweenCitiesAutomation.RoadPlan roadPlan = this.roadBetweenCitiesAutomation.getTilesOfRoadsMap$core().get(tile);
            Intrinsics.checkNotNull(roadPlan);
            RoadBetweenCitiesAutomation.RoadPlan roadPlan2 = roadPlan;
            return roadPlan2.getPriority() - (float)9;
        }
        if (!Intrinsics.areEqual(tile.getOwner(), unit.getCiv())) {
            boolean bl;
            TileImprovement tileImprovement2 = this.ruleSet.getTileImprovements().get(improvementName);
            Intrinsics.checkNotNull(tileImprovement2);
            if (!IHasUniques.hasUnique$default(tileImprovement2, UniqueType.CanBuildOutsideBorders, null, 2, null)) return 0.0f;
            Sequence<Tile> $this$any$iv = tile.getNeighbors();
            boolean $i$f$any = false;
            Iterator<Tile> iterator2 = $this$any$iv.iterator();
            do {
                Tile element$iv;
                if (!iterator2.hasNext()) return 0.0f;
                Tile it = element$iv = iterator2.next();
                boolean bl2 = false;
                if (Intrinsics.areEqual(it.getOwner(), unit.getCiv()) && it.getOwningCity() != null) {
                    City city = it.getOwningCity();
                    Intrinsics.checkNotNull(city);
                    if (tile.aerialDistanceTo(city.getCenterTile()) <= this.civInfo.getModConstants().getCityWorkRange()) {
                        bl = true;
                        continue;
                    }
                }
                bl = false;
            } while (!bl);
            boolean bl3 = true;
            if (!bl3) {
                return 0.0f;
            }
        }
        Stats stats = tile.getStats().getStatDiffForImprovement(improvement, this.civInfo, tile.getCity(), localUniqueCache, currentTileStats);
        boolean bl = isResourceImprovedByNewImprovement = tile.hasViewableResource(this.civInfo) && tile.getTileResource().isImprovedBy(improvementName);
        if (StringsKt.startsWith$default(improvementName, "Remove ", false, 2, null)) {
            String removedImprovement;
            Object v7;
            String removedObject;
            block20: {
                removedObject = StringsKt.replace$default(improvementName, "Remove ", "", false, 4, null);
                Iterable $this$firstOrNull$iv = tile.getTerrainFeatures();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    String it = (String)element$iv;
                    boolean bl4 = false;
                    if (!Intrinsics.areEqual(it, removedObject)) continue;
                    v7 = element$iv;
                    break block20;
                }
                v7 = null;
            }
            String removedFeature = v7;
            String string = removedImprovement = Intrinsics.areEqual(removedObject, tile.getImprovement()) ? removedObject : null;
            if (removedFeature != null || removedImprovement != null) {
                TileImprovement wantedFinalImprovement;
                Tile newTile = tile.clone(false);
                newTile.setTerrainTransients();
                if (removedFeature != null) {
                    newTile.removeTerrainFeature(removedFeature);
                }
                if (removedImprovement != null) {
                    newTile.removeImprovement();
                }
                if ((wantedFinalImprovement = this.chooseImprovement(unit, newTile, localUniqueCache)) != null) {
                    Stats statDiff = TileStatFunctions.getStatDiffForImprovement$default(newTile.getStats(), wantedFinalImprovement, this.civInfo, newTile.getCity(), localUniqueCache, null, 16, null);
                    stats.add(statDiff);
                    isResourceImprovedByNewImprovement = newTile.getResource() != null && newTile.getTileResource().isImprovedBy(wantedFinalImprovement.getName());
                    if (!((Collection)tile.getTerrainFeatures()).isEmpty() && IHasUniques.hasUnique$default(tile.getLastTerrain(), UniqueType.ProductionBonusWhenRemoved, null, 2, null)) {
                        stats.add(Stat.Production, 0.5f);
                    }
                }
            }
        }
        if (!Intrinsics.areEqual(tile.getOwner(), unit.getCiv())) {
            stats.div(3.0f);
        }
        float value = Automation.INSTANCE.rankStatsValue(stats, unit.getCiv());
        if (tile.getResource() != null && tile.getTileResource().getResourceType() != ResourceType.Bonus) {
            if (tile.getImprovement() != null) {
                TileResource tileResource = tile.getTileResource();
                String string = tile.getImprovement();
                Intrinsics.checkNotNull(string);
                if (tileResource.isImprovedBy(string)) {
                    value -= (float)RangesKt.coerceIn(tile.getResourceAmount() / 2, 1, 2);
                }
            }
            if (isResourceImprovedByNewImprovement) {
                value += (float)RangesKt.coerceIn(tile.getResourceAmount() / 2, 1, 2);
            }
        }
        if (this.isImprovementProbablyAFort(improvement)) {
            value += this.evaluateFortSurroundings(tile, IHasUniques.hasUnique$default(improvement, UniqueType.OneTimeTakeOverTilesInRadius, null, 2, null));
            return value;
        } else {
            if (tile.getTileImprovement() == null) return value;
            TileImprovement tileImprovement3 = tile.getTileImprovement();
            Intrinsics.checkNotNull(tileImprovement3);
            if (!this.isImprovementProbablyAFort(tileImprovement3)) return value;
            value /= (float)2;
        }
        return value;
    }

    static /* synthetic */ float getImprovementRanking$default(WorkerAutomation workerAutomation, Tile tile, MapUnit mapUnit, String string, LocalUniqueCache localUniqueCache, Stats stats, int n, Object object) {
        if ((n & 0x10) != 0) {
            stats = null;
        }
        return workerAutomation.getImprovementRanking(tile, mapUnit, string, localUniqueCache, stats);
    }

    @Readonly
    private final boolean isResourceImprovementAllowedOnFeature(Tile tile, Map<String, TileImprovement> potentialTileImprovements) {
        boolean bl;
        block9: {
            Iterable $this$any$iv = tile.getTileResource().getImprovements();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    boolean bl2;
                    block8: {
                        String resourceImprovementName = (String)element$iv;
                        boolean bl3 = false;
                        if (!potentialTileImprovements.containsKey(resourceImprovementName)) {
                            bl2 = false;
                        } else {
                            Intrinsics.checkNotNull(potentialTileImprovements.get(resourceImprovementName));
                            Iterable $this$any$iv2 = tile.getTerrainFeatureObjects();
                            boolean $i$f$any2 = false;
                            if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                                bl2 = false;
                            } else {
                                for (Object element$iv2 : $this$any$iv2) {
                                    TileImprovement resourceImprovement;
                                    Terrain it = (Terrain)element$iv2;
                                    boolean bl4 = false;
                                    if (!resourceImprovement.isAllowedOnFeature(it)) continue;
                                    bl2 = true;
                                    break block8;
                                }
                                bl2 = false;
                            }
                        }
                    }
                    if (!bl2) continue;
                    bl = true;
                    break block9;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Readonly
    private final boolean isAcceptableTileForFort(Tile tile) {
        return !tile.isCityCenter() && tile.isLand() && (!tile.hasViewableResource(this.civInfo) || tile.getTileResource().getResourceType() == ResourceType.Bonus) && !tile.containsGreatImprovement();
    }

    /*
     * WARNING - void declaration
     */
    @Readonly
    private final float evaluateFortSurroundings(Tile tile, boolean isCitadel) {
        Object t;
        void $this$minBy$iv;
        void $this$mapTo$iv$iv;
        Object v6;
        Object v5;
        Object it;
        void $this$filterTo$iv$iv;
        Object element$iv;
        block37: {
            block36: {
                block35: {
                    boolean bl;
                    block34: {
                        City city = tile.getOwningCity();
                        if (Intrinsics.areEqual(city != null ? city.getCiv() : null, this.civInfo)) break block35;
                        if (!isCitadel) break block36;
                        Sequence<Tile> $this$all$iv = tile.getNeighbors();
                        boolean $i$f$all = false;
                        Iterator<Tile> iterator2 = $this$all$iv.iterator();
                        while (iterator2.hasNext()) {
                            element$iv = iterator2.next();
                            Tile it2 = element$iv;
                            boolean bl2 = false;
                            if (!Intrinsics.areEqual(it2.getOwner(), this.civInfo)) continue;
                            bl = false;
                            break block34;
                        }
                        bl = true;
                    }
                    if (bl) break block36;
                }
                if (this.isAcceptableTileForFort(tile)) break block37;
            }
            return 0.0f;
        }
        List<Civilization> enemyCivs = this.civInfo.getCivsAtWarWith();
        if (CollectionsKt.none((Iterable)enemyCivs)) {
            return 0.0f;
        }
        float valueOfFort = 1.0f;
        if (this.civInfo.isCityState() && this.civInfo.getAllyCivName() != null) {
            valueOfFort -= 1.0f;
        }
        if (tile.hasViewableResource(this.civInfo)) {
            valueOfFort -= 1.0f;
        }
        Sequence<Tile> nearestTiles = SequencesKt.filter(tile.getTilesInDistance(1), arg_0 -> WorkerAutomation.evaluateFortSurroundings$lambda$23(this, arg_0));
        element$iv = nearestTiles.iterator();
        while (element$iv.hasNext()) {
            Tile closeTile;
            block40: {
                block39: {
                    block38: {
                        closeTile = (Tile)element$iv.next();
                        if (closeTile.isCityCenter()) {
                            valueOfFort -= 0.5f;
                            continue;
                        }
                        if (closeTile.getImprovement() == null) break block38;
                        TileImprovement tileImprovement = closeTile.getTileImprovement();
                        Intrinsics.checkNotNull(tileImprovement);
                        if (this.isImprovementProbablyAFort(tileImprovement)) break block39;
                    }
                    if (closeTile.getImprovementInProgress() == null) break block40;
                    String string = closeTile.getImprovementInProgress();
                    Intrinsics.checkNotNull(string);
                    if (!this.isImprovementProbablyAFort(string)) break block40;
                }
                valueOfFort -= 1.0f;
            }
            if (!tile.isHill() && closeTile.isHill() && this.isAcceptableTileForFort(closeTile)) {
                valueOfFort -= 0.2f;
            }
            if (!tile.isImpassible()) continue;
            valueOfFort += 0.2f;
        }
        Function1<Civilization, Integer> threatMapping = arg_0 -> WorkerAutomation.evaluateFortSurroundings$lambda$24(this, arg_0);
        Iterable $this$filter$iv = enemyCivs;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Civilization)element$iv$iv;
            boolean bl4 = false;
            boolean bl3 = NextTurnAutomation.INSTANCE.getMinDistanceBetweenCities(this.civInfo, (Civilization)it) <= ((Number)threatMapping.invoke((Civilization)it)).intValue();
            if (!bl3) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List enemyCivsIsCloseEnough = (List)destination$iv$iv;
        if (CollectionsKt.none(enemyCivsIsCloseEnough)) {
            return 0.0f;
        }
        List enemyCities = new ArrayList();
        Iterable $this$forEach$iv = enemyCivsIsCloseEnough;
        boolean $i$f$forEach = false;
        for (Object element$iv2 : $this$forEach$iv) {
            void $this$mapTo$iv$iv2;
            void $this$map$iv;
            Civilization it3 = (Civilization)element$iv2;
            boolean bl = false;
            it = it3.getCities();
            List bl4 = enemyCities;
            boolean $i$f$map = false;
            void var18_44 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void city;
                City city2 = (City)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl5 = false;
                collection.add(city.getCenterTile());
            }
            bl4.addAll((List)destination$iv$iv2);
        }
        Iterable $this$minByOrNull$iv = enemyCities;
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v5 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v5 = minElem$iv;
            } else {
                Tile it4 = (Tile)minElem$iv;
                boolean bl = false;
                int minValue$iv = it4.aerialDistanceTo(tile);
                do {
                    Object e$iv = iterator$iv.next();
                    Tile it5 = (Tile)e$iv;
                    $i$a$-minByOrNull-WorkerAutomation$evaluateFortSurroundings$closestEnemyCity$1 = false;
                    int v$iv = it5.aerialDistanceTo(tile);
                    if (minValue$iv <= v$iv) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v5 = minElem$iv;
            }
        }
        Intrinsics.checkNotNull(v5);
        Tile closestEnemyCity = v5;
        int distanceToEnemyCity = tile.aerialDistanceTo(closestEnemyCity);
        Iterable $this$minByOrNull$iv2 = this.civInfo.getCities();
        boolean $i$f$minByOrNull2 = false;
        Iterator iterator$iv2 = $this$minByOrNull$iv2.iterator();
        if (!iterator$iv2.hasNext()) {
            v6 = null;
        } else {
            Object minElem$iv = iterator$iv2.next();
            if (!iterator$iv2.hasNext()) {
                v6 = minElem$iv;
            } else {
                City it6 = (City)minElem$iv;
                boolean bl = false;
                int minValue$iv = it6.getCenterTile().aerialDistanceTo(tile);
                do {
                    Object e$iv = iterator$iv2.next();
                    City it7 = (City)e$iv;
                    $i$a$-minByOrNull-WorkerAutomation$evaluateFortSurroundings$closestCity$1 = false;
                    int v$iv = it7.getCenterTile().aerialDistanceTo(tile);
                    if (minValue$iv <= v$iv) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv2.hasNext());
                v6 = minElem$iv;
            }
        }
        Intrinsics.checkNotNull(v6);
        Tile closestCity = ((City)v6).getCenterTile();
        int distanceBetweenCities = closestEnemyCity.aerialDistanceTo(closestCity);
        Iterable $this$map$iv = this.civInfo.getCities();
        boolean $i$f$map = false;
        Iterable minValue$iv = $this$map$iv;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it8;
            City city = (City)item$iv$iv;
            Collection collection = destination$iv$iv3;
            boolean bl = false;
            collection.add(it8.getCenterTile().aerialDistanceTo(closestEnemyCity));
        }
        $this$map$iv = (List)destination$iv$iv3;
        boolean $i$f$minByOrThrow = false;
        Iterator iterator$iv3 = $this$minBy$iv.iterator();
        if (!iterator$iv3.hasNext()) {
            throw new NoSuchElementException();
        }
        Object minElem$iv = iterator$iv3.next();
        if (!iterator$iv3.hasNext()) {
            t = minElem$iv;
        } else {
            int it9 = ((Number)minElem$iv).intValue();
            boolean bl = false;
            int minValue$iv2 = it9;
            do {
                Object e$iv = iterator$iv3.next();
                int it10 = ((Number)e$iv).intValue();
                $i$a$-minByOrThrow-WorkerAutomation$evaluateFortSurroundings$distanceOfEnemyCityToClosestCityOfUs$2 = false;
                int v$iv = it10;
                if (minValue$iv2 <= v$iv) continue;
                minElem$iv = e$iv;
                minValue$iv2 = v$iv;
            } while (iterator$iv3.hasNext());
            t = minElem$iv;
        }
        int distanceOfEnemyCityToClosestCityOfUs = ((Number)t).intValue();
        if (distanceBetweenCities >= distanceOfEnemyCityToClosestCityOfUs + 2) {
            return 0.0f;
        }
        if (distanceToEnemyCity >= distanceBetweenCities || distanceToEnemyCity <= 2) {
            return 0.0f;
        }
        return RangesKt.coerceAtLeast(valueOfFort += (float)(2 - Math.abs(distanceBetweenCities - 1 - distanceToEnemyCity)), 0.0f);
    }

    @Readonly
    public final boolean evaluateFortPlacement(@NotNull Tile tile, boolean isCitadel) {
        Intrinsics.checkNotNullParameter(tile, "tile");
        return !Intrinsics.areEqual(tile.getImprovement(), "Fort") && this.evaluateFortSurroundings(tile, isCitadel) > 0.0f;
    }

    @Readonly
    public final boolean isImprovementProbablyAFort(@NotNull String improvementName) {
        Intrinsics.checkNotNullParameter(improvementName, "improvementName");
        TileImprovement tileImprovement = this.ruleSet.getTileImprovements().get(improvementName);
        Intrinsics.checkNotNull(tileImprovement);
        return this.isImprovementProbablyAFort(tileImprovement);
    }

    @Readonly
    public final boolean isImprovementProbablyAFort(@NotNull TileImprovement improvement) {
        Intrinsics.checkNotNullParameter(improvement, "improvement");
        return IHasUniques.hasUnique$default(improvement, UniqueType.DefensiveBonus, null, 2, null);
    }

    public final boolean automateWorkBoats(@NotNull MapUnit unit) {
        Tile tile;
        block3: {
            Intrinsics.checkNotNullParameter(unit, "unit");
            Sequence<Tile> $this$sortedBy$iv = SequencesKt.filter(SequencesKt.flatMap(CollectionsKt.asSequence((Iterable)unit.getCiv().getCities()), WorkerAutomation::automateWorkBoats$lambda$32), arg_0 -> WorkerAutomation.automateWorkBoats$lambda$33(unit, arg_0));
            boolean $i$f$sortedBy = false;
            Sequence<Tile> $this$firstOrNull$iv = SequencesKt.sortedWith($this$sortedBy$iv, new Comparator(unit){
                final /* synthetic */ MapUnit $unit$inlined;
                {
                    this.$unit$inlined = mapUnit;
                }

                public final int compare(T a, T b) {
                    Tile it = (Tile)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it.aerialDistanceTo(this.$unit$inlined.getCurrentTile()));
                    it = (Tile)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues(comparable2, it.aerialDistanceTo(this.$unit$inlined.getCurrentTile()));
                }
            });
            boolean $i$f$firstOrNull = false;
            Iterator<Tile> iterator2 = $this$firstOrNull$iv.iterator();
            while (iterator2.hasNext()) {
                Tile element$iv;
                Tile it = element$iv = iterator2.next();
                boolean bl = false;
                if (!(unit.getMovement().canReach(it) && Companion.isNotBonusResourceOrWorkable(it, unit.getCiv()))) continue;
                tile = element$iv;
                break block3;
            }
            tile = null;
        }
        Tile tile2 = tile;
        if (tile2 == null) {
            return false;
        }
        Tile closestReachableResource = tile2;
        unit.getMovement().headTowards(closestReachableResource);
        if (!Intrinsics.areEqual(unit.getCurrentTile(), closestReachableResource)) {
            return true;
        }
        return UnitActions.INSTANCE.invokeUnitAction(unit, UnitActionType.CreateImprovement);
    }

    private static final boolean tryHeadTowardsUndevelopedCity$lambda$2(HashMap $citiesToNumberOfUnimprovedTiles, City it) {
        Intrinsics.checkNotNullParameter(it, "it");
        Object v = $citiesToNumberOfUnimprovedTiles.get(it.getId());
        Intrinsics.checkNotNull(v);
        return ((Number)v).intValue() > 0;
    }

    private static final boolean findTileToWork$lambda$5(WorkerAutomation this$0, Set $tilesToAvoid, Tile $currentTile, MapUnit $unit, Tile it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return this$0.isAutomationWorkableTile(it, $tilesToAvoid, $currentTile, $unit) && this$0.getBasePriority(it, $unit) > 1.0f;
    }

    private static final Pair chooseImprovement$lambda$12(WorkerAutomation this$0, Tile $tile, MapUnit $unit, LocalUniqueCache $localUniqueCache, Stats $currentTileStats, TileImprovement it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return new Pair<TileImprovement, Float>(it, Float.valueOf(this$0.getImprovementRanking($tile, $unit, it.getName(), $localUniqueCache, $currentTileStats)));
    }

    private static final boolean chooseImprovement$lambda$13(Pair it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return ((Number)it.getSecond()).floatValue() > 0.0f;
    }

    @Readonly
    private static final boolean chooseImprovement$isRemovable(Map<String, TileImprovement> potentialTileImprovements, Terrain terrain) {
        return potentialTileImprovements.containsKey("Remove " + terrain.getName());
    }

    private static final boolean evaluateFortSurroundings$lambda$23(WorkerAutomation this$0, Tile it) {
        Intrinsics.checkNotNullParameter(it, "it");
        City city = it.getOwningCity();
        return Intrinsics.areEqual(city != null ? city.getCiv() : null, this$0.civInfo);
    }

    private static final int evaluateFortSurroundings$lambda$24(WorkerAutomation this$0, Civilization it) {
        int n;
        Intrinsics.checkNotNullParameter(it, "it");
        int n2 = this$0.civInfo.isAtWarWith(it) ? 5 : 0;
        switch (WhenMappings.$EnumSwitchMapping$0[Automation.INSTANCE.threatAssessment(this$0.civInfo, it).ordinal()]) {
            case 1: {
                n = 1;
                break;
            }
            case 2: {
                n = 6;
                break;
            }
            case 3: {
                n = 10;
                break;
            }
            case 4: {
                n = 15;
                break;
            }
            case 5: {
                n = 20;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return n2 + n;
    }

    private static final Sequence automateWorkBoats$lambda$32(City city) {
        Intrinsics.checkNotNullParameter(city, "city");
        return city.getTiles();
    }

    private static final boolean automateWorkBoats$lambda$33(MapUnit $unit, Tile it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return Companion.hasWorkableSeaResource(it, $unit.getCiv()) && (Intrinsics.areEqual($unit.getCurrentTile(), it) || UnitMovement.canMoveTo$default($unit.getMovement(), it, false, false, false, 14, null));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007\u00a8\u0006\u000b"}, d2={"Lcom/unciv/logic/automation/unit/WorkerAutomation$Companion;", "", "<init>", "()V", "hasWorkableSeaResource", "", "tile", "Lcom/unciv/logic/map/tile/Tile;", "civInfo", "Lcom/unciv/logic/civilization/Civilization;", "isNotBonusResourceOrWorkable", "core"})
    @SourceDebugExtension(value={"SMAP\nWorkerAutomation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WorkerAutomation.kt\ncom/unciv/logic/automation/unit/WorkerAutomation$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,718:1\n1761#2,3:719\n1761#2,3:722\n*S KotlinDebug\n*F\n+ 1 WorkerAutomation.kt\ncom/unciv/logic/automation/unit/WorkerAutomation$Companion\n*L\n701#1:719,3\n715#1:722,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Readonly
        public final boolean hasWorkableSeaResource(@NotNull Tile tile, @NotNull Civilization civInfo) {
            TileImprovement improvement;
            Intrinsics.checkNotNullParameter(tile, "tile");
            Intrinsics.checkNotNullParameter(civInfo, "civInfo");
            if (!tile.isWater()) {
                return false;
            }
            if (tile.getResource() == null) {
                return false;
            }
            if (tile.getImprovement() != null) {
                TileResource tileResource = tile.getTileResource();
                String string = tile.getImprovement();
                Intrinsics.checkNotNull(string);
                if (tileResource.isImprovedBy(string)) {
                    return false;
                }
            }
            if (!tile.hasViewableResource(civInfo)) {
                return false;
            }
            Iterable $this$any$iv = tile.getTileResource().getImprovements();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                return false;
            }
            Iterator iterator2 = $this$any$iv.iterator();
            do {
                if (!iterator2.hasNext()) return false;
                Object element$iv = iterator2.next();
                String it = (String)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull(civInfo.getGameInfo().getRuleset().getTileImprovements().get(it));
            } while (!tile.getImprovementFunctions().canBuildImprovement(improvement, civInfo.getState()));
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Readonly
        public final boolean isNotBonusResourceOrWorkable(@NotNull Tile tile, @NotNull Civilization civInfo) {
            City it;
            Intrinsics.checkNotNullParameter(tile, "tile");
            Intrinsics.checkNotNullParameter(civInfo, "civInfo");
            if (tile.getTileResource().getResourceType() != ResourceType.Bonus) return true;
            Iterable $this$any$iv = civInfo.getCities();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                return false;
            }
            Iterator iterator2 = $this$any$iv.iterator();
            do {
                if (!iterator2.hasNext()) return false;
                Object element$iv = iterator2.next();
                it = (City)element$iv;
                boolean bl = false;
            } while (!it.getTilesInRange().contains(tile));
            return true;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u001b\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\t\u0010\nJ\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\u000eJ\u000b\u0010\u001d\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J\u0010\u0010\u001e\u001a\u0004\u0018\u00010\bH\u00c6\u0003\u00a2\u0006\u0002\u0010\u0017J<\u0010\u001f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\bH\u00c6\u0001\u00a2\u0006\u0002\u0010 J\u0013\u0010!\u001a\u00020\b2\b\u0010\"\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010#\u001a\u00020$H\u00d6\u0001J\t\u0010%\u001a\u00020&H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001e\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0011\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001e\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u001a\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019\u00a8\u0006'"}, d2={"Lcom/unciv/logic/automation/unit/WorkerAutomation$TileImprovementRank;", "", "tilePriority", "", "improvementPriority", "bestImprovement", "Lcom/unciv/models/ruleset/tile/TileImprovement;", "repairImprovment", "", "<init>", "(FLjava/lang/Float;Lcom/unciv/models/ruleset/tile/TileImprovement;Ljava/lang/Boolean;)V", "getTilePriority", "()F", "getImprovementPriority", "()Ljava/lang/Float;", "setImprovementPriority", "(Ljava/lang/Float;)V", "Ljava/lang/Float;", "getBestImprovement", "()Lcom/unciv/models/ruleset/tile/TileImprovement;", "setBestImprovement", "(Lcom/unciv/models/ruleset/tile/TileImprovement;)V", "getRepairImprovment", "()Ljava/lang/Boolean;", "setRepairImprovment", "(Ljava/lang/Boolean;)V", "Ljava/lang/Boolean;", "component1", "component2", "component3", "component4", "copy", "(FLjava/lang/Float;Lcom/unciv/models/ruleset/tile/TileImprovement;Ljava/lang/Boolean;)Lcom/unciv/logic/automation/unit/WorkerAutomation$TileImprovementRank;", "equals", "other", "hashCode", "", "toString", "", "core"})
    public static final class TileImprovementRank {
        private final float tilePriority;
        @Nullable
        private Float improvementPriority;
        @Nullable
        private TileImprovement bestImprovement;
        @Nullable
        private Boolean repairImprovment;

        public TileImprovementRank(float tilePriority, @Nullable Float improvementPriority, @Nullable TileImprovement bestImprovement, @Nullable Boolean repairImprovment) {
            this.tilePriority = tilePriority;
            this.improvementPriority = improvementPriority;
            this.bestImprovement = bestImprovement;
            this.repairImprovment = repairImprovment;
        }

        public /* synthetic */ TileImprovementRank(float f, Float f2, TileImprovement tileImprovement, Boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                f2 = null;
            }
            if ((n & 4) != 0) {
                tileImprovement = null;
            }
            if ((n & 8) != 0) {
                bl = null;
            }
            this(f, f2, tileImprovement, bl);
        }

        public final float getTilePriority() {
            return this.tilePriority;
        }

        @Nullable
        public final Float getImprovementPriority() {
            return this.improvementPriority;
        }

        public final void setImprovementPriority(@Nullable Float f) {
            this.improvementPriority = f;
        }

        @Nullable
        public final TileImprovement getBestImprovement() {
            return this.bestImprovement;
        }

        public final void setBestImprovement(@Nullable TileImprovement tileImprovement) {
            this.bestImprovement = tileImprovement;
        }

        @Nullable
        public final Boolean getRepairImprovment() {
            return this.repairImprovment;
        }

        public final void setRepairImprovment(@Nullable Boolean bl) {
            this.repairImprovment = bl;
        }

        public final float component1() {
            return this.tilePriority;
        }

        @Nullable
        public final Float component2() {
            return this.improvementPriority;
        }

        @Nullable
        public final TileImprovement component3() {
            return this.bestImprovement;
        }

        @Nullable
        public final Boolean component4() {
            return this.repairImprovment;
        }

        @NotNull
        public final TileImprovementRank copy(float tilePriority, @Nullable Float improvementPriority, @Nullable TileImprovement bestImprovement, @Nullable Boolean repairImprovment) {
            return new TileImprovementRank(tilePriority, improvementPriority, bestImprovement, repairImprovment);
        }

        public static /* synthetic */ TileImprovementRank copy$default(TileImprovementRank tileImprovementRank, float f, Float f2, TileImprovement tileImprovement, Boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                f = tileImprovementRank.tilePriority;
            }
            if ((n & 2) != 0) {
                f2 = tileImprovementRank.improvementPriority;
            }
            if ((n & 4) != 0) {
                tileImprovement = tileImprovementRank.bestImprovement;
            }
            if ((n & 8) != 0) {
                bl = tileImprovementRank.repairImprovment;
            }
            return tileImprovementRank.copy(f, f2, tileImprovement, bl);
        }

        @NotNull
        public String toString() {
            return "TileImprovementRank(tilePriority=" + this.tilePriority + ", improvementPriority=" + this.improvementPriority + ", bestImprovement=" + this.bestImprovement + ", repairImprovment=" + this.repairImprovment + ')';
        }

        public int hashCode() {
            int result2 = Float.hashCode(this.tilePriority);
            result2 = result2 * 31 + (this.improvementPriority == null ? 0 : ((Object)this.improvementPriority).hashCode());
            result2 = result2 * 31 + (this.bestImprovement == null ? 0 : this.bestImprovement.hashCode());
            result2 = result2 * 31 + (this.repairImprovment == null ? 0 : ((Object)this.repairImprovment).hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TileImprovementRank)) {
                return false;
            }
            TileImprovementRank tileImprovementRank = (TileImprovementRank)other;
            if (Float.compare(this.tilePriority, tileImprovementRank.tilePriority) != 0) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.improvementPriority, (Object)tileImprovementRank.improvementPriority)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.bestImprovement, tileImprovementRank.bestImprovement)) {
                return false;
            }
            return Intrinsics.areEqual(this.repairImprovment, tileImprovementRank.repairImprovment);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ThreatLevel.values().length];
            try {
                nArray[ThreatLevel.VeryLow.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ThreatLevel.Low.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ThreatLevel.Medium.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ThreatLevel.High.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ThreatLevel.VeryHigh.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

