/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.automation.unit;

import com.badlogic.gdx.math.Vector2;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.MapUnitAction;
import com.unciv.logic.civilization.Notification;
import com.unciv.logic.map.MapPathing;
import com.unciv.logic.map.TileMap;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.logic.map.mapunit.movement.UnitMovement;
import com.unciv.logic.map.tile.RoadStatus;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.ruleset.tile.TileImprovement;
import com.unciv.utils.Log;
import com.unciv.utils.LogKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import yairm210.purity.annotations.Readonly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fJ\u000e\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0010H\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/unciv/logic/automation/unit/RoadToAutomation;", "", "civInfo", "Lcom/unciv/logic/civilization/Civilization;", "<init>", "(Lcom/unciv/logic/civilization/Civilization;)V", "getCivInfo", "()Lcom/unciv/logic/civilization/Civilization;", "actualBestRoadAvailable", "Lcom/unciv/logic/map/tile/RoadStatus;", "automateConnectRoad", "", "unit", "Lcom/unciv/logic/map/mapunit/MapUnit;", "tilesWhereWeWillBeCaptured", "", "Lcom/unciv/logic/map/tile/Tile;", "stopAndCleanAutomation", "shouldBuildRoadOnTile", "", "tile", "core"})
@SourceDebugExtension(value={"SMAP\nRoadToAutomation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RoadToAutomation.kt\ncom/unciv/logic/automation/unit/RoadToAutomation\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,153:1\n1563#2:154\n1634#2,3:155\n*S KotlinDebug\n*F\n+ 1 RoadToAutomation.kt\ncom/unciv/logic/automation/unit/RoadToAutomation\n*L\n64#1:154\n64#1:155,3\n*E\n"})
public final class RoadToAutomation {
    @NotNull
    private final Civilization civInfo;
    @NotNull
    private final RoadStatus actualBestRoadAvailable;

    public RoadToAutomation(@NotNull Civilization civInfo) {
        Intrinsics.checkNotNullParameter(civInfo, "civInfo");
        this.civInfo = civInfo;
        this.actualBestRoadAvailable = this.civInfo.getTech().getBestRoadAvailable();
    }

    @NotNull
    public final Civilization getCivInfo() {
        return this.civInfo;
    }

    /*
     * WARNING - void declaration
     */
    public final void automateConnectRoad(@NotNull MapUnit unit, @NotNull Set<Tile> tilesWhereWeWillBeCaptured) {
        int currTileIndex;
        Object[] $this$map$iv;
        Intrinsics.checkNotNullParameter(unit, "unit");
        Intrinsics.checkNotNullParameter(tilesWhereWeWillBeCaptured, "tilesWhereWeWillBeCaptured");
        if (this.actualBestRoadAvailable == RoadStatus.None) {
            return;
        }
        Tile currentTile = unit.getTile();
        if (unit.getAutomatedRoadConnectionDestination() == null) {
            this.stopAndCleanAutomation(unit);
            return;
        }
        TileMap tileMap = unit.getCiv().getGameInfo().getTileMap();
        Vector2 vector2 = unit.getAutomatedRoadConnectionDestination();
        Intrinsics.checkNotNull(vector2);
        Tile destinationTile = tileMap.get(vector2);
        List pathToDest = unit.getAutomatedRoadConnectionPath();
        if (pathToDest == null) {
            void $this$mapTo$iv$iv;
            List<Tile> foundPath = MapPathing.INSTANCE.getRoadPath(unit.getCiv(), unit.getTile(), destinationTile);
            if (foundPath == null) {
                Log.INSTANCE.debug("WorkerAutomation: " + unit + " -> connect road failed", new Object[0]);
                this.stopAndCleanAutomation(unit);
                String[] stringArray = new String[]{"StatIcons/Production"};
                unit.getCiv().addNotification("Connect road failed!", new MapUnitAction(unit), Notification.NotificationCategory.Units, stringArray);
                return;
            }
            Iterable iterable = foundPath;
            boolean $i$f$map = false;
            void var9_12 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Tile tile = (Tile)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getPosition());
            }
            pathToDest = (List)destination$iv$iv;
            unit.setAutomatedRoadConnectionPath(pathToDest);
            $this$map$iv = new Object[]{destinationTile, pathToDest};
            LogKt.debug("WorkerAutomation: " + unit + " -> found connect road path to destination tile: %s, %s", $this$map$iv);
        }
        if ((currTileIndex = pathToDest.indexOf(currentTile.getPosition())) == -1) {
            Log.INSTANCE.debug(unit + " -> was moved off its connect road path. Operation cancelled.", new Object[0]);
            this.stopAndCleanAutomation(unit);
            $this$map$iv = new String[]{unit.getName()};
            unit.getCiv().addNotification("Connect road cancelled!", new MapUnitAction(unit), Notification.NotificationCategory.Units, (String[])$this$map$iv);
            return;
        }
        if (unit.hasMovement() && !this.shouldBuildRoadOnTile(currentTile)) {
            if (currTileIndex == pathToDest.size() - 1) {
                this.stopAndCleanAutomation(unit);
                $this$map$iv = new String[]{unit.getName()};
                unit.getCiv().addNotification("Connect road completed", new MapUnitAction(unit), Notification.NotificationCategory.Units, (String[])$this$map$iv);
                return;
            }
            if (currTileIndex < pathToDest.size() - 1) {
                TileMap tileMap2 = unit.getCiv().getGameInfo().getTileMap();
                Tile nextTile = currentTile;
                Sequence<Tile> futureTiles = SequencesKt.map(SequencesKt.drop(SequencesKt.dropWhile(CollectionsKt.asSequence(pathToDest), arg_0 -> RoadToAutomation.automateConnectRoad$lambda$1(unit, arg_0)), 1), arg_0 -> RoadToAutomation.automateConnectRoad$lambda$2(tileMap2, arg_0));
                Iterator<Tile> iterator2 = futureTiles.iterator();
                while (iterator2.hasNext()) {
                    Tile futureTile = iterator2.next();
                    if (!unit.getMovement().canReachInCurrentTurn(futureTile) || !UnitMovement.canMoveTo$default(unit.getMovement(), futureTile, false, false, false, 14, null)) continue;
                    nextTile = futureTile;
                    if (!this.shouldBuildRoadOnTile(futureTile)) continue;
                }
                UnitMovement.moveToTile$default(unit.getMovement(), nextTile, false, 2, null);
                currentTile = unit.getTile();
            }
        }
        if (unit.hasMovement()) {
            if (currentTile.getRoadStatus() != RoadStatus.None && currentTile.getRoadIsPillaged()) {
                currentTile.setRepaired();
                return;
            }
            if (this.shouldBuildRoadOnTile(currentTile) && !Intrinsics.areEqual(currentTile.getImprovementInProgress(), this.actualBestRoadAvailable.name())) {
                TileImprovement tileImprovement = this.actualBestRoadAvailable.improvement(this.civInfo.getGameInfo().getRuleset());
                Intrinsics.checkNotNull(tileImprovement);
                TileImprovement improvement = tileImprovement;
                currentTile.startWorkingOnImprovement(improvement, this.civInfo, unit);
                return;
            }
        }
    }

    public final void stopAndCleanAutomation(@NotNull MapUnit unit) {
        Intrinsics.checkNotNullParameter(unit, "unit");
        unit.setAutomated(false);
        unit.setAction(null);
        unit.setAutomatedRoadConnectionDestination(null);
        unit.setAutomatedRoadConnectionPath(null);
        unit.getCurrentTile().stopWorkingOnImprovement();
    }

    @Readonly
    public final boolean shouldBuildRoadOnTile(@NotNull Tile tile) {
        Intrinsics.checkNotNullParameter(tile, "tile");
        if (tile.getRoadIsPillaged()) {
            return true;
        }
        return !tile.isCityCenter() && (!tile.hasConnection(this.civInfo) || this.actualBestRoadAvailable != RoadStatus.Road) && tile.getRoadStatus() != this.actualBestRoadAvailable;
    }

    private static final boolean automateConnectRoad$lambda$1(MapUnit $unit, Vector2 it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return !Intrinsics.areEqual(it, $unit.getCurrentTile().getPosition());
    }

    private static final Tile automateConnectRoad$lambda$2(TileMap $tileMap, Vector2 it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return $tileMap.get(it);
    }
}

