/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic;

import com.badlogic.gdx.files.FileHandle;
import com.unciv.UncivGame;
import com.unciv.logic.GameInfo;
import com.unciv.logic.civilization.AlertType;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.PlayerType;
import com.unciv.logic.civilization.PopupAlert;
import com.unciv.logic.civilization.managers.PolicyManager;
import com.unciv.logic.civilization.managers.UnitManager;
import com.unciv.logic.files.MapSaver;
import com.unciv.logic.map.HexMath;
import com.unciv.logic.map.TileMap;
import com.unciv.logic.map.mapgenerator.MapGenerator;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.metadata.GameParameters;
import com.unciv.models.metadata.GameSettings;
import com.unciv.models.metadata.GameSetupInfo;
import com.unciv.models.metadata.Player;
import com.unciv.models.ruleset.Policy;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.RulesetCache;
import com.unciv.models.ruleset.RulesetObject;
import com.unciv.models.ruleset.nation.Nation;
import com.unciv.models.ruleset.tech.Era;
import com.unciv.models.ruleset.tech.Technology;
import com.unciv.models.ruleset.tile.TileImprovement;
import com.unciv.models.ruleset.unique.GameContext;
import com.unciv.models.ruleset.unique.IHasUniques;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueTriggerActivation;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.ruleset.unit.BaseUnit;
import com.unciv.models.stats.Stats;
import com.unciv.models.translations.TranslationsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import yairm210.purity.annotations.Readonly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007J\u001e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\tH\u0002J \u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0018\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\tH\u0002J.\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u0005H\u0002J.\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0002J\u0010\u0010\u001f\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\tH\u0002J\u0010\u0010 \u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\"H\u0002J<\u0010#\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\t2\"\u0010$\u001a\u001e\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020\"0%j\u000e\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020\"`'2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J.\u0010(\u001a\b\u0012\u0004\u0012\u00020\r0)2\u0006\u0010*\u001a\u00020&2\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010+\u001a\u00020\rH\u0002J>\u0010,\u001a\u0004\u0018\u00010-2\u0006\u0010*\u001a\u00020&2\u0006\u0010.\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010/\u001a\u00020\r2\u0012\u00100\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020-01H\u0002J:\u00102\u001a\u00020\u000b2\u0006\u0010*\u001a\u00020&2\u0006\u0010\u0011\u001a\u00020\t2\f\u00103\u001a\b\u0012\u0004\u0012\u00020\r0)2\u0012\u00100\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020-01H\u0002JJ\u00104\u001a\u00020\u000b2\u0006\u0010*\u001a\u00020&2\u0006\u0010!\u001a\u00020\"2\f\u00103\u001a\b\u0012\u0004\u0012\u00020\r0)2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010/\u001a\u00020\r2\u0012\u00100\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020-01H\u0002JH\u00105\u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u000206012\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u00020:2\"\u0010;\u001a\u001e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u0002060%j\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u000206`'H\u0002Jr\u0010<\u001a\u001e\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020\"0%j\u000e\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020\"`'2\f\u0010=\u001a\b\u0012\u0004\u0012\u00020&0\u00182\u0006\u00109\u001a\u00020:2\u0012\u0010>\u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u000206012\"\u0010;\u001a\u001e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u0002060%j\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u000206`'H\u0002J$\u0010?\u001a\b\u0012\u0004\u0012\u00020&0\u00182\f\u0010=\u001a\b\u0012\u0004\u0012\u00020&0\u00182\u0006\u00109\u001a\u00020:H\u0002J2\u0010@\u001a\b\u0012\u0004\u0012\u00020\"0)2\u0006\u00109\u001a\u00020:2\u0012\u0010>\u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u000206012\u0006\u0010A\u001a\u000208H\u0003Jx\u0010B\u001a\"\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020\"\u0018\u00010%j\u0010\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020\"\u0018\u0001`'2\f\u0010C\u001a\b\u0012\u0004\u0012\u00020&0\u00182\u0006\u00109\u001a\u00020:2\f\u0010D\u001a\b\u0012\u0004\u0012\u00020\"0)2\"\u0010;\u001a\u001e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u0002060%j\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u000206`'2\u0006\u0010A\u001a\u000208H\u0002JL\u0010E\u001a\u0004\u0018\u00010\"2\u0006\u0010*\u001a\u00020&2\u0006\u00109\u001a\u00020:2\f\u0010D\u001a\b\u0012\u0004\u0012\u00020\"0)2\"\u0010;\u001a\u001e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u0002060%j\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u000206`'H\u0002JJ\u0010F\u001a\u00020\"2\u0006\u0010*\u001a\u00020&2\u0006\u00109\u001a\u00020:2\f\u0010D\u001a\b\u0012\u0004\u0012\u00020\"0)2\"\u0010;\u001a\u001e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u0002060%j\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u000206`'H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006G"}, d2={"Lcom/unciv/logic/GameStarter;", "", "<init>", "()V", "consoleTimings", "", "gameSetupInfo", "Lcom/unciv/models/metadata/GameSetupInfo;", "startNewGame", "Lcom/unciv/logic/GameInfo;", "runAndMeasure", "", "text", "", "action", "Lkotlin/Function0;", "addPlayerIntros", "gameInfo", "addCivTechs", "ruleset", "Lcom/unciv/models/ruleset/Ruleset;", "addCivPolicies", "addCivStats", "chooseCivilizations", "", "Lcom/unciv/models/metadata/Player;", "newGameParameters", "Lcom/unciv/models/metadata/GameParameters;", "existingMap", "addCivilizations", "chosenPlayers", "addCivStartingUnits", "removeAncientRuinsNearStartingLocation", "startingLocation", "Lcom/unciv/logic/map/tile/Tile;", "determineStartingUnitsAndLocations", "startingLocations", "Ljava/util/HashMap;", "Lcom/unciv/logic/civilization/Civilization;", "Lkotlin/collections/HashMap;", "getStartingUnitsForEraAndDifficulty", "", "civ", "startingEra", "getEquivalentUnit", "Lcom/unciv/models/ruleset/unit/BaseUnit;", "unitParam", "eraUnitReplacement", "settlerLikeUnits", "", "adjustStartingUnitsForCityStatesAndOneCityChallenge", "startingUnits", "placeStartingUnits", "getCandidateLand", "", "civCount", "", "tileMap", "Lcom/unciv/logic/map/TileMap;", "startScores", "getStartingLocations", "civs", "landTilesInBigEnoughGroup", "getCivsOrderedByAvailableLocations", "getFreeTiles", "minimumDistanceBetweenStartingLocations", "getStartingLocationsForCivs", "civsOrderedByAvailableLocations", "freeTiles", "getCivStartingLocation", "getOneStartingLocation", "core"})
@SourceDebugExtension(value={"SMAP\nGameStarter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GameStarter.kt\ncom/unciv/logic/GameStarter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,674:1\n295#2,2:675\n774#2:677\n865#2,2:678\n1869#2,2:680\n774#2:682\n865#2,2:683\n774#2:685\n865#2,2:686\n774#2:688\n865#2,2:689\n1563#2:691\n1634#2,3:692\n774#2:702\n865#2,2:703\n1788#2,4:705\n774#2:709\n865#2,2:710\n1068#2:712\n774#2:713\n865#2,2:714\n827#2:716\n855#2,2:717\n1563#2:720\n1634#2,3:721\n774#2:724\n865#2,2:725\n774#2:727\n865#2,2:728\n774#2:737\n865#2,2:738\n774#2:740\n865#2,2:741\n774#2:757\n865#2,2:758\n774#2:760\n865#2,2:761\n1056#2:771\n1068#2:772\n1761#2,3:774\n774#2:778\n865#2:779\n866#2:782\n774#2:783\n865#2:784\n866#2:787\n2746#2,3:788\n536#3:695\n521#3,6:696\n536#3:730\n521#3,6:731\n536#3:743\n521#3,6:744\n536#3:750\n521#3,6:751\n536#3:764\n521#3,6:765\n622#4:719\n622#4:763\n608#4:773\n622#4:777\n1255#4,2:780\n1255#4,2:785\n*S KotlinDebug\n*F\n+ 1 GameStarter.kt\ncom/unciv/logic/GameStarter\n*L\n47#1:675,2\n160#1:677\n160#1:678,2\n163#1:680,2\n179#1:682\n179#1:683,2\n209#1:685\n209#1:686,2\n233#1:688\n233#1:689,2\n249#1:691\n249#1:692,3\n263#1:702\n263#1:703,2\n277#1:705,4\n287#1:709\n287#1:710,2\n289#1:712\n314#1:713\n314#1:714,2\n315#1:716\n315#1:717,2\n361#1:720\n361#1:721,3\n397#1:724\n397#1:725,2\n402#1:727\n402#1:728,2\n436#1:737\n436#1:738,2\n448#1:740\n448#1:741,2\n504#1:757\n504#1:758,2\n512#1:760\n512#1:761,2\n570#1:771\n578#1:772\n643#1:774,3\n657#1:778\n657#1:779\n657#1:782\n664#1:783\n664#1:784\n664#1:787\n94#1:788,3\n254#1:695\n254#1:696,6\n434#1:730\n434#1:731,6\n478#1:743\n478#1:744,6\n486#1:750\n486#1:751,6\n547#1:764\n547#1:765,6\n342#1:719\n536#1:763\n587#1:773\n647#1:777\n658#1:780,2\n665#1:785,2\n*E\n"})
public final class GameStarter {
    @NotNull
    public static final GameStarter INSTANCE = new GameStarter();
    private static final boolean consoleTimings = false;
    private static GameSetupInfo gameSetupInfo;

    private GameStarter() {
    }

    @NotNull
    public final GameInfo startNewGame(@NotNull GameSetupInfo gameSetupInfo) {
        TileMap tileMap;
        TileMap tileMap2;
        TileMap tileMap3;
        Object v1;
        Ref.ObjectRef tileMap4;
        GameInfo gameInfo;
        block15: {
            Intrinsics.checkNotNullParameter(gameSetupInfo, "gameSetupInfo");
            GameStarter.gameSetupInfo = gameSetupInfo;
            gameInfo = new GameInfo();
            tileMap4 = new Ref.ObjectRef();
            CollectionsKt.removeAll((Iterable)gameSetupInfo.getGameParameters().getMods(), GameStarter::startNewGame$lambda$0);
            Iterable $this$firstOrNull$iv = gameSetupInfo.getGameParameters().getMods();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                Object object = RulesetCache.INSTANCE.get((Object)it);
                Intrinsics.checkNotNull(object);
                if (!((Ruleset)object).getModOptions().isBaseRuleset()) continue;
                v1 = element$iv;
                break block15;
            }
            v1 = null;
        }
        String baseRulesetInMods = v1;
        if (baseRulesetInMods != null) {
            gameSetupInfo.getGameParameters().setBaseRuleset(baseRulesetInMods);
        }
        if (!RulesetCache.INSTANCE.containsKey((Object)gameSetupInfo.getGameParameters().getBaseRuleset())) {
            gameSetupInfo.getGameParameters().setBaseRuleset(RulesetCache.INSTANCE.getVanillaRuleset().getName());
        }
        gameInfo.setGameParameters(gameSetupInfo.getGameParameters());
        Ruleset ruleset = RulesetCache.INSTANCE.getComplexRuleset(gameInfo.getGameParameters());
        MapGenerator mapGen = new MapGenerator(ruleset, null, 2, null);
        if (!ruleset.getSpeeds().containsKey(gameSetupInfo.getGameParameters().getSpeed())) {
            GameParameters gameParameters = gameSetupInfo.getGameParameters();
            Set<String> set = ruleset.getSpeeds().keySet();
            Intrinsics.checkNotNullExpressionValue(set, "<get-keys>(...)");
            gameParameters.setSpeed((String)CollectionsKt.first((Iterable)set));
        }
        Ref.ObjectRef phaseOneChosenCivs = new Ref.ObjectRef();
        phaseOneChosenCivs.element = CollectionsKt.emptyList();
        if (!Intrinsics.areEqual(gameSetupInfo.getMapParameters().getName(), "")) {
            this.runAndMeasure("loadMap", () -> GameStarter.startNewGame$lambda$2(tileMap4, gameSetupInfo, phaseOneChosenCivs, gameInfo, ruleset));
        } else {
            this.runAndMeasure("generateMap", () -> GameStarter.startNewGame$lambda$3(phaseOneChosenCivs, gameSetupInfo, gameInfo, ruleset, tileMap4, mapGen));
        }
        this.runAndMeasure("addCivilizations", () -> GameStarter.startNewGame$lambda$4(gameInfo, tileMap4, gameSetupInfo, ruleset, phaseOneChosenCivs));
        this.runAndMeasure("Remove units", () -> GameStarter.startNewGame$lambda$6(tileMap4, gameInfo, ruleset));
        if (tileMap4.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException("tileMap");
            tileMap3 = null;
        } else {
            tileMap3 = (TileMap)tileMap4.element;
        }
        if (tileMap3.getContinentSizes().isEmpty()) {
            this.runAndMeasure("assignContinents", () -> GameStarter.startNewGame$lambda$7(tileMap4));
        }
        this.runAndMeasure("setTransients", () -> GameStarter.startNewGame$lambda$8(gameInfo, tileMap4, ruleset, gameSetupInfo));
        this.runAndMeasure("addCivStartingUnits", () -> GameStarter.startNewGame$lambda$9(gameInfo));
        this.runAndMeasure("Policies", () -> GameStarter.startNewGame$lambda$10(gameInfo, ruleset));
        this.runAndMeasure("Techs and Stats", () -> GameStarter.startNewGame$lambda$11(gameInfo, ruleset, gameSetupInfo));
        this.runAndMeasure("Starting stats", () -> GameStarter.startNewGame$lambda$12(gameInfo));
        if (tileMap4.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException("tileMap");
            tileMap2 = null;
        } else {
            tileMap2 = (TileMap)tileMap4.element;
        }
        tileMap2.clearStartingLocations();
        if (tileMap4.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException("tileMap");
            tileMap = null;
        } else {
            tileMap = (TileMap)tileMap4.element;
        }
        Object object = tileMap.getValues().iterator();
        while (object.hasNext()) {
            Tile tile = object.next();
            Iterator<MapUnit> bl = tile.getUnits().iterator();
            while (bl.hasNext()) {
                MapUnit unit = bl.next();
                unit.setCurrentMovement(MapUnit.getMaxMovement$default(unit, false, 1, null));
            }
        }
        this.addPlayerIntros(gameInfo);
        Object $this$startNewGame_u24lambda_u2413 = object = UncivGame.Companion.getCurrent().getSettings();
        boolean bl = false;
        ((GameSettings)$this$startNewGame_u24lambda_u2413).setLastGameSetup(gameSetupInfo);
        ((GameSettings)$this$startNewGame_u24lambda_u2413).save();
        return gameInfo;
    }

    private final void runAndMeasure(String text, Function0<Unit> action2) {
        action2.invoke();
    }

    /*
     * WARNING - void declaration
     */
    private final void addPlayerIntros(GameInfo gameInfo) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = gameInfo.getCivilizations();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Civilization it = (Civilization)element$iv$iv;
            boolean bl = false;
            if (!(it.getPlayerType() == PlayerType.Human && ((CharSequence)it.getNation().getStartIntroPart1()).length() > 0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Civilization it = (Civilization)element$iv;
            boolean bl = false;
            it.getPopupAlerts().add(new PopupAlert(AlertType.StartIntro, ""));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void addCivTechs(GameInfo gameInfo, Ruleset ruleset, GameSetupInfo gameSetupInfo) {
        for (Civilization civInfo : gameInfo.getCivilizations()) {
            Iterator<Object> iterator2;
            Object tech;
            void $this$filterTo$iv$iv;
            if (civInfo.isBarbarian()) continue;
            Collection<Technology> collection = ruleset.getTechnologies().values();
            Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
            Iterable $this$filter$iv = collection;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Technology it = (Technology)element$iv$iv;
                boolean bl = false;
                if (!IHasUniques.hasUnique$default(it, UniqueType.StartingTech, null, 2, null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            for (Object e : (List)destination$iv$iv) {
                Intrinsics.checkNotNullExpressionValue(e, "next(...)");
                tech = (Technology)e;
                GameStarter.addCivTechs$addTechSilently(civInfo, ruleset, ((RulesetObject)tech).getName());
            }
            if (!civInfo.isHuman()) {
                Iterator<String> iterator3 = gameInfo.getDifficulty().getAiFreeTechs().iterator();
                Intrinsics.checkNotNullExpressionValue(iterator3, "iterator(...)");
                iterator2 = iterator3;
                while (iterator2.hasNext()) {
                    Object object = iterator2.next();
                    Intrinsics.checkNotNullExpressionValue(object, "next(...)");
                    tech = (String)object;
                    GameStarter.addCivTechs$addTechSilently(civInfo, ruleset, (String)tech);
                }
            }
            iterator2 = Civilization.getMatchingUniques$default(civInfo, UniqueType.StartsWithTech, null, 2, null).iterator();
            while (iterator2.hasNext()) {
                Unique unique = (Unique)iterator2.next();
                GameStarter.addCivTechs$addTechSilently(civInfo, ruleset, unique.getParams().get(0));
            }
            if (civInfo.isSpectator()) {
                for (Object object : ruleset.getTechnologies().values()) {
                    Intrinsics.checkNotNullExpressionValue(object, "next(...)");
                    tech = (Technology)object;
                    GameStarter.addCivTechs$addTechSilently(civInfo, ruleset, ((RulesetObject)tech).getName());
                }
            }
            Era era = ruleset.getEras().get(gameSetupInfo.getGameParameters().getStartingEra());
            Intrinsics.checkNotNull(era);
            int startingEraNumber = era.getEraNumber();
            Iterator<Technology> iterator4 = ruleset.getTechnologies().values().iterator();
            while (iterator4.hasNext()) {
                Technology tech2;
                Intrinsics.checkNotNullExpressionValue(iterator4.next(), "next(...)");
                Era era2 = ruleset.getEras().get(tech2.era());
                Intrinsics.checkNotNull(era2);
                if (era2.getEraNumber() >= startingEraNumber || civInfo.getTech().isUnresearchable(tech2)) continue;
                GameStarter.addCivTechs$addTechSilently(civInfo, ruleset, tech2.getName());
            }
            civInfo.getPopupAlerts().clear();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void addCivPolicies(GameInfo gameInfo, Ruleset ruleset) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = gameInfo.getCivilizations();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Civilization it = (Civilization)element$iv$iv;
            boolean bl = false;
            if (!(!it.isBarbarian())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (Civilization civInfo : (List)destination$iv$iv) {
            Iterator iterator2 = Civilization.getMatchingUniques$default(civInfo, UniqueType.StartsWithPolicy, null, 2, null).iterator();
            while (iterator2.hasNext()) {
                Policy policyToAdopt;
                Unique unique = (Unique)iterator2.next();
                String policyName = unique.getParams().get(0);
                if (!ruleset.getPolicies().containsKey(policyName) || civInfo.getPolicies().isAdopted(policyName)) continue;
                Intrinsics.checkNotNull(ruleset.getPolicies().get(policyName));
                PolicyManager $this$addCivPolicies_u24lambda_u2418 = civInfo.getPolicies();
                boolean bl = false;
                int n = $this$addCivPolicies_u24lambda_u2418.getFreePolicies();
                $this$addCivPolicies_u24lambda_u2418.setFreePolicies(n + 1);
                PolicyManager.adopt$default($this$addCivPolicies_u24lambda_u2418, policyToAdopt, false, 2, null);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void addCivStats(GameInfo gameInfo) {
        void $this$filterTo$iv$iv;
        Ruleset ruleSet = gameInfo.getRuleset();
        String startingEra = gameInfo.getGameParameters().getStartingEra();
        Era era = ruleSet.getEras().get(startingEra);
        Intrinsics.checkNotNull(era);
        Era era2 = era;
        Iterable $this$filter$iv = gameInfo.getCivilizations();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Civilization it = (Civilization)element$iv$iv;
            boolean bl = false;
            if (!(!it.isBarbarian() && !it.isSpectator())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (Civilization civInfo : (List)destination$iv$iv) {
            civInfo.addGold((int)((float)era2.getStartingGold() * gameInfo.getSpeed().getGoldCostModifier()));
            civInfo.getPolicies().addCulture((int)((float)era2.getStartingCulture() * gameInfo.getSpeed().getCultureCostModifier()));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<Player> chooseCivilizations(GameParameters newGameParameters, GameInfo gameInfo, Ruleset ruleset, boolean existingMap) {
        void $this$sortedByDescending$iv;
        int n;
        void $this$filterNotTo$iv$iv;
        void $this$filterTo$iv$iv;
        Player it;
        void $this$filterTo$iv$iv2;
        void $this$filter$iv;
        Set<Object> set;
        Iterable $this$filterTo$iv$iv3;
        Sequence sequence;
        Object object;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        List chosenPlayers = new ArrayList();
        int dequeCapacity = ruleset.getNations().size();
        Iterable iterable = newGameParameters.getPlayers();
        boolean $i$f$map = false;
        void var10_11 = $this$map$iv;
        Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            Player player = (Player)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(it2.getChosenCiv());
        }
        Set selectedPlayerNames = CollectionsKt.toSet((List)destination$iv$iv);
        GameSetupInfo gameSetupInfo = GameStarter.gameSetupInfo;
        if (gameSetupInfo == null) {
            Intrinsics.throwUninitializedPropertyAccessException("gameSetupInfo");
            gameSetupInfo = null;
        }
        if (gameSetupInfo.getGameParameters().getEnableRandomNationsPool()) {
            GameSetupInfo gameSetupInfo2 = GameStarter.gameSetupInfo;
            if (gameSetupInfo2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("gameSetupInfo");
                gameSetupInfo2 = null;
            }
            sequence = CollectionsKt.asSequence((Iterable)gameSetupInfo2.getGameParameters().getRandomNationsPool());
        } else {
            Object item$iv$iv;
            Map $this$filter$iv2 = ruleset.getNations();
            boolean $i$f$filter = false;
            destination$iv$iv = $this$filter$iv2;
            Map destination$iv$iv2 = new LinkedHashMap();
            boolean $i$f$filterTo = false;
            item$iv$iv = $this$filterTo$iv$iv3.entrySet().iterator();
            while (item$iv$iv.hasNext()) {
                Map.Entry element$iv$iv;
                Map.Entry it3 = element$iv$iv = (Map.Entry)item$iv$iv.next();
                boolean bl = false;
                if (!(((Nation)it3.getValue()).isMajorCiv() && !IHasUniques.hasUnique$default((IHasUniques)it3.getValue(), UniqueType.WillNotBeChosenForNewGames, null, 2, null))) continue;
                destination$iv$iv2.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            sequence = CollectionsKt.asSequence(destination$iv$iv2.keySet());
        }
        ArrayDeque randomNationsPool = (ArrayDeque)SequencesKt.toCollection(SequencesKt.shuffled(SequencesKt.filter(sequence, arg_0 -> GameStarter.chooseCivilizations$lambda$22(selectedPlayerNames, arg_0))), (Collection)new ArrayDeque(dequeCapacity));
        if (existingMap) {
            Set<String> set2 = gameInfo.getTileMap().getStartingLocationsByNation().keySet();
            set = set2;
            Intrinsics.checkNotNullExpressionValue(set2, "<get-keys>(...)");
        } else {
            set = SetsKt.emptySet();
        }
        Set civNamesWithStartingLocations = set;
        $this$filterTo$iv$iv3 = randomNationsPool;
        boolean $i$f$filter = false;
        void $i$f$filterTo = $this$filter$iv;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            String it4 = (String)element$iv$iv;
            boolean bl = false;
            if (!civNamesWithStartingLocations.contains(it4)) continue;
            destination$iv$iv3.add(element$iv$iv);
        }
        ArrayDeque presetRandomNationsPool = (ArrayDeque)CollectionsKt.toCollection(CollectionsKt.shuffled((List)destination$iv$iv3), (Collection)new ArrayDeque(dequeCapacity));
        randomNationsPool.removeAll(presetRandomNationsPool);
        int extraRandomAIPlayers = 0;
        Ref.ObjectRef selectedAIToSkip = new Ref.ObjectRef();
        selectedAIToSkip.element = CollectionsKt.emptyList();
        if (newGameParameters.getRandomNumberOfPlayers()) {
            int n2;
            int min = RangesKt.coerceAtMost(newGameParameters.getMinNumberOfPlayers(), newGameParameters.getMaxNumberOfPlayers());
            int max = RangesKt.coerceAtLeast(newGameParameters.getMaxNumberOfPlayers(), newGameParameters.getMinNumberOfPlayers());
            Iterable $this$count$iv = newGameParameters.getPlayers();
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n2 = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    it = (Player)element$iv;
                    boolean bl = false;
                    if (!(it.getPlayerType() == PlayerType.Human || it.getChosenCiv() == "Spectator") || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n2 = count$iv;
            }
            int nonAICount = n2;
            int desiredNumberOfPlayers = RangesKt.random(new IntRange(RangesKt.coerceAtLeast(min, nonAICount), RangesKt.coerceAtLeast(max, nonAICount)), (Random)Random.Default);
            if (desiredNumberOfPlayers > newGameParameters.getPlayers().size()) {
                extraRandomAIPlayers = desiredNumberOfPlayers - newGameParameters.getPlayers().size();
            } else if (desiredNumberOfPlayers < newGameParameters.getPlayers().size()) {
                void $this$sortedByDescending$iv2;
                void $this$filterTo$iv$iv4;
                Iterable $this$filter$iv3;
                Object element$iv;
                int extraPlayers = newGameParameters.getPlayers().size() - desiredNumberOfPlayers;
                Iterable count$iv = newGameParameters.getPlayers();
                object = selectedAIToSkip;
                boolean $i$f$filter2 = false;
                element$iv = $this$filter$iv3;
                Collection destination$iv$iv4 = new ArrayList();
                boolean $i$f$filterTo3 = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv4) {
                    Player it5 = (Player)element$iv$iv;
                    boolean bl = false;
                    if (!(it5.getPlayerType() == PlayerType.AI)) continue;
                    destination$iv$iv4.add(element$iv$iv);
                }
                $this$filter$iv3 = CollectionsKt.shuffled((List)destination$iv$iv4);
                boolean $i$f$sortedByDescending = false;
                ((Ref.ObjectRef)object).element = CollectionsKt.sortedWith($this$sortedByDescending$iv2, new Comparator(){

                    public final int compare(T a, T b) {
                        Player it = (Player)b;
                        boolean bl = false;
                        Comparable comparable = Boolean.valueOf(Intrinsics.areEqual(it.getChosenCiv(), "Random"));
                        it = (Player)a;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues(comparable2, Intrinsics.areEqual(it.getChosenCiv(), "Random"));
                    }
                }).subList(0, extraPlayers);
            }
        }
        Comparator min = new Comparator(){

            public final int compare(T a, T b) {
                Player it = (Player)a;
                boolean bl = false;
                Comparable comparable = Boolean.valueOf(Intrinsics.areEqual(it.getChosenCiv(), "Random"));
                it = (Player)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, Intrinsics.areEqual(it.getChosenCiv(), "Random"));
            }
        };
        SequencesKt.toCollection(SequencesKt.mapNotNull(SequencesKt.plus(SequencesKt.sortedWith(SequencesKt.filterNot(CollectionsKt.asSequence((Iterable)newGameParameters.getPlayers()), arg_0 -> GameStarter.chooseCivilizations$lambda$27(selectedAIToSkip, arg_0)), new Comparator(min){
            final /* synthetic */ Comparator $this_thenBy;
            {
                this.$this_thenBy = $receiver;
            }

            public final int compare(T a, T b) {
                int n;
                int previousCompare = this.$this_thenBy.compare(a, b);
                if (previousCompare != 0) {
                    n = previousCompare;
                } else {
                    Player it = (Player)a;
                    boolean bl = false;
                    boolean bl2 = it.getPlayerType() == PlayerType.AI;
                    it = (Player)b;
                    Comparable comparable = Boolean.valueOf(bl2);
                    bl = false;
                    n = ComparisonsKt.compareValues(comparable, it.getPlayerType() == PlayerType.AI);
                }
                return n;
            }
        }), SequencesKt.map(CollectionsKt.asSequence(RangesKt.until(0, extraRandomAIPlayers)), GameStarter::chooseCivilizations$lambda$30)), arg_0 -> GameStarter.chooseCivilizations$lambda$31(presetRandomNationsPool, randomNationsPool, arg_0)), (Collection)chosenPlayers);
        Iterable $this$filter$iv4 = chosenPlayers;
        boolean $i$f$filter3 = false;
        Iterable desiredNumberOfPlayers = $this$filter$iv4;
        Iterable destination$iv$iv5 = new ArrayList();
        boolean $i$f$filterTo4 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Player)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual(it.getChosenCiv(), "Spectator")) continue;
            destination$iv$iv5.add(element$iv$iv);
        }
        List spectators = (List)destination$iv$iv5;
        Iterable $this$filterNot$iv = chosenPlayers;
        boolean $i$f$filterNot = false;
        destination$iv$iv5 = $this$filterNot$iv;
        Collection destination$iv$iv6 = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            Player it6 = (Player)element$iv$iv;
            boolean bl = false;
            if (Intrinsics.areEqual(it6.getChosenCiv(), "Spectator")) continue;
            destination$iv$iv6.add(element$iv$iv);
        }
        List otherPlayers = CollectionsKt.toMutableList((List)destination$iv$iv6);
        if (newGameParameters.getShufflePlayerOrder()) {
            Collections.shuffle(otherPlayers);
        }
        chosenPlayers.clear();
        chosenPlayers.addAll(spectators);
        chosenPlayers.addAll(otherPlayers);
        if (newGameParameters.getRandomNumberOfCityStates()) {
            int min2 = RangesKt.coerceAtMost(newGameParameters.getMinNumberOfCityStates(), newGameParameters.getMaxNumberOfCityStates());
            int max = RangesKt.coerceAtLeast(newGameParameters.getMaxNumberOfCityStates(), newGameParameters.getMinNumberOfCityStates());
            n = RangesKt.random(new IntRange(min2, max), (Random)Random.Default);
        } else {
            n = newGameParameters.getNumberOfCityStates();
        }
        int numberOfCityStates = n;
        Sequence<String> min2 = SequencesKt.shuffled(SequencesKt.map(SequencesKt.filter(MapsKt.asSequence((Map)ruleset.getNations()), GameStarter::chooseCivilizations$lambda$34), GameStarter::chooseCivilizations$lambda$35));
        boolean $i$f$sortedByDescending = false;
        SequencesKt.toCollection(SequencesKt.map(SequencesKt.take(SequencesKt.sortedWith($this$sortedByDescending$iv, new Comparator(civNamesWithStartingLocations){
            final /* synthetic */ Set $civNamesWithStartingLocations$inlined;
            {
                this.$civNamesWithStartingLocations$inlined = set;
            }

            public final int compare(T a, T b) {
                String it = (String)b;
                boolean bl = false;
                Comparable comparable = Boolean.valueOf(this.$civNamesWithStartingLocations$inlined.contains(it));
                it = (String)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, this.$civNamesWithStartingLocations$inlined.contains(it));
            }
        }), numberOfCityStates), GameStarter::chooseCivilizations$lambda$37), (Collection)chosenPlayers);
        return chosenPlayers;
    }

    /*
     * WARNING - void declaration
     */
    private final void addCivilizations(GameParameters newGameParameters, GameInfo gameInfo, Ruleset ruleset, List<Player> chosenPlayers) {
        void $this$mapTo$iv$iv;
        if (!newGameParameters.getNoBarbarians() && ruleset.getNations().containsKey("Barbarians")) {
            Civilization barbarianCivilization = new Civilization("Barbarians");
            gameInfo.getCivilizations().add(barbarianCivilization);
        }
        Iterable $this$map$iv = chosenPlayers;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Player player = (Player)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getChosenCiv());
        }
        Set usedCivNames = CollectionsKt.toSet((List)destination$iv$iv);
        Sequence<String> usedMajorCivs = SequencesKt.filter(SequencesKt.map(SequencesKt.filter(MapsKt.asSequence((Map)ruleset.getNations()), GameStarter::addCivilizations$lambda$39), GameStarter::addCivilizations$lambda$40), arg_0 -> GameStarter.addCivilizations$lambda$41(usedCivNames, arg_0));
        for (Player player : chosenPlayers) {
            Civilization civ = new Civilization(player.getChosenCiv());
            String string = player.getChosenCiv();
            if (SequencesKt.contains(usedMajorCivs, string) || Intrinsics.areEqual(string, "Spectator")) {
                civ.setPlayerType(player.getPlayerType());
                civ.setPlayerId(player.getPlayerId());
            } else if (!civ.getCityStateFunctions().initCityState(ruleset, newGameParameters.getStartingEra(), usedMajorCivs)) continue;
            gameInfo.getCivilizations().add(civ);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void addCivStartingUnits(GameInfo gameInfo) {
        void $this$filterTo$iv$iv;
        void $this$filterTo$iv$iv2;
        Object object;
        Ruleset ruleSet = gameInfo.getRuleset();
        TileMap tileMap = gameInfo.getTileMap();
        Unique unique = (Unique)SequencesKt.firstOrNull(SequencesKt.flatMap(SequencesKt.filterNotNull(SequencesKt.sequenceOf(ruleSet.getTileImprovements().get("City center"))), GameStarter::addCivStartingUnits$lambda$42));
        Stats cityCenterMinStats = unique != null && (object = unique.getStats()) != null ? object : Stats.Companion.getDefaultCityCenterMinimum();
        HashMap<Tile, Float> startScores = new HashMap<Tile, Float>(tileMap.getValues().size());
        for (Tile tile : tileMap.getValues()) {
            ((Map)startScores).put(tile, Float.valueOf(tile.getStats().getTileStartScore(cityCenterMinStats)));
        }
        Iterable $this$filter$iv = gameInfo.getCivilizations();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            Civilization it = (Civilization)element$iv$iv;
            boolean bl = false;
            if (!(!it.isBarbarian())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List allCivs = (List)destination$iv$iv;
        Map<Tile, Float> landTilesInBigEnoughGroup = this.getCandidateLand(allCivs.size(), tileMap, startScores);
        Set<String> set = tileMap.getStartingLocationsByNation().keySet();
        Intrinsics.checkNotNullExpressionValue(set, "<get-keys>(...)");
        Set<String> civNamesWithStartingLocations = set;
        Iterable $this$filter$iv2 = allCivs;
        boolean $i$f$filter2 = false;
        Map.Entry entry2 = $this$filter$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Civilization it = (Civilization)element$iv$iv;
            boolean bl = false;
            if (!((!it.isCityState() || civNamesWithStartingLocations.contains(it.getCivName())) && !it.isSpectator())) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List bestCivs = (List)destination$iv$iv2;
        HashMap<Civilization, Tile> bestLocations = this.getStartingLocations(bestCivs, tileMap, landTilesInBigEnoughGroup, startScores);
        for (Map.Entry entry2 : ((Map)bestLocations).entrySet()) {
            Civilization civ = (Civilization)entry2.getKey();
            Tile tile = (Tile)entry2.getValue();
            tileMap.removeStartingLocations(civ.getCivName());
            TileMap.addStartingLocation$default(tileMap, civ.getCivName(), tile, null, 4, null);
        }
        HashMap<Civilization, Tile> startingLocations = this.getStartingLocations(allCivs, tileMap, landTilesInBigEnoughGroup, startScores);
        this.determineStartingUnitsAndLocations(gameInfo, startingLocations, ruleSet);
    }

    private final void removeAncientRuinsNearStartingLocation(Tile startingLocation) {
        Iterator<Tile> iterator2 = startingLocation.getTilesInDistance(3).iterator();
        while (iterator2.hasNext()) {
            Tile tile = iterator2.next();
            if (tile.getImprovement() == null) continue;
            TileImprovement tileImprovement = tile.getTileImprovement();
            Intrinsics.checkNotNull(tileImprovement);
            if (!tileImprovement.isAncientRuinsEquivalent()) continue;
            tile.removeImprovement();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void determineStartingUnitsAndLocations(GameInfo gameInfo, HashMap<Civilization, Tile> startingLocations, Ruleset ruleset) {
        void $this$filterTo$iv$iv;
        void $this$filterTo$iv$iv2;
        String startingEra = gameInfo.getGameParameters().getStartingEra();
        Map $this$filter$iv = ruleset.getUnits();
        boolean $i$f$filter = false;
        Map map2 = $this$filter$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator2 = $this$filterTo$iv$iv2.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry entry;
            Map.Entry it = entry = iterator2.next();
            boolean bl = false;
            if (!((BaseUnit)it.getValue()).isCityFounder()) continue;
            destination$iv$iv.put(entry.getKey(), entry.getValue());
        }
        Map settlerLikeUnits = destination$iv$iv;
        Iterable $this$filter$iv2 = gameInfo.getCivilizations();
        boolean $i$f$filter2 = false;
        destination$iv$iv = $this$filter$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Civilization it = (Civilization)element$iv$iv;
            boolean bl = false;
            if (!(!it.isBarbarian() && !it.isSpectator())) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        for (Civilization civ : (List)destination$iv$iv2) {
            void $this$filterTo$iv$iv3;
            Tile startingLocation;
            Intrinsics.checkNotNull(startingLocations.get(civ));
            this.removeAncientRuinsNearStartingLocation(startingLocation);
            List<String> startingUnits = this.getStartingUnitsForEraAndDifficulty(civ, gameInfo, ruleset, startingEra);
            this.adjustStartingUnitsForCityStatesAndOneCityChallenge(civ, gameInfo, startingUnits, settlerLikeUnits);
            Era era = ruleset.getEras().get(startingEra);
            Intrinsics.checkNotNull(era);
            this.placeStartingUnits(civ, startingLocation, startingUnits, ruleset, era.getStartingMilitaryUnit(), settlerLikeUnits);
            List startingTriggers = CollectionsKt.plus((Collection)gameInfo.getGlobalUniques().getUniqueObjects(), (Iterable)civ.getNation().getUniqueObjects());
            Iterable iterable = startingTriggers;
            boolean $i$f$filter3 = false;
            Iterable it = iterable;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$filterTo3 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv3) {
                Unique it2 = (Unique)element$iv$iv;
                boolean bl = false;
                if (!(!it2.hasTriggerConditional() && it2.conditionalsApply(civ.getState()))) continue;
                destination$iv$iv3.add(element$iv$iv);
            }
            for (Unique unique : (List)destination$iv$iv3) {
                UniqueTriggerActivation.triggerUnique$default(UniqueTriggerActivation.INSTANCE, unique, civ, null, null, startingLocation, null, null, 108, null);
            }
        }
    }

    private final List<String> getStartingUnitsForEraAndDifficulty(Civilization civ, GameInfo gameInfo, Ruleset ruleset, String startingEra) {
        Object object = ruleset.getEras().get(startingEra);
        if (object == null || (object = ((Era)object).getStartingUnits(ruleset)) == null) {
            throw new Exception("Era " + startingEra + " does not exist in the ruleset!");
        }
        Object startingUnits = object;
        startingUnits.addAll((Collection)(civ.isHuman() ? gameInfo.getDifficulty().getPlayerBonusStartingUnits() : (civ.isMajorCiv() ? gameInfo.getDifficulty().getAiMajorCivBonusStartingUnits() : gameInfo.getDifficulty().getAiCityStateBonusStartingUnits())));
        return startingUnits;
    }

    /*
     * WARNING - void declaration
     */
    private final BaseUnit getEquivalentUnit(Civilization civ, String unitParam, Ruleset ruleset, String eraUnitReplacement, Map<String, BaseUnit> settlerLikeUnits) {
        String unit = unitParam;
        if (Intrinsics.areEqual(unit, "Era Starting Unit")) {
            unit = eraUnitReplacement;
        }
        if (Intrinsics.areEqual(unit, "Settler") && !((Map)ruleset.getUnits()).containsKey("Settler")) {
            void $this$filterTo$iv$iv;
            Map<String, BaseUnit> $this$filter$iv = settlerLikeUnits;
            boolean $i$f$filter = false;
            Map<String, BaseUnit> map2 = $this$filter$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$filterTo = false;
            Iterator iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry element$iv$iv;
                Map.Entry it = element$iv$iv = iterator2.next();
                boolean bl = false;
                if (!(((BaseUnit)it.getValue()).isBuildable(civ) && ((BaseUnit)it.getValue()).isCivilian())) continue;
                destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            Map buildableSettlerLikeUnits = destination$iv$iv;
            if (buildableSettlerLikeUnits.isEmpty()) {
                return null;
            }
            return civ.getEquivalentUnit((String)CollectionsKt.random(buildableSettlerLikeUnits.keySet(), Random.Default));
        }
        if (Intrinsics.areEqual(unit, "Worker") && !((Map)ruleset.getUnits()).containsKey("Worker")) {
            Map $this$filter$iv = ruleset.getUnits();
            boolean $i$f$filter = false;
            Map $this$filterTo$iv$iv = $this$filter$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$filterTo = false;
            Iterator iterator3 = $this$filterTo$iv$iv.entrySet().iterator();
            while (iterator3.hasNext()) {
                Map.Entry element$iv$iv;
                Map.Entry it = element$iv$iv = iterator3.next();
                boolean bl = false;
                if (!(IHasUniques.hasUnique$default((IHasUniques)it.getValue(), UniqueType.BuildImprovements, null, 2, null) && ((BaseUnit)it.getValue()).isBuildable(civ) && ((BaseUnit)it.getValue()).isCivilian())) continue;
                destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            Map buildableWorkerLikeUnits = destination$iv$iv;
            if (buildableWorkerLikeUnits.isEmpty()) {
                return null;
            }
            return civ.getEquivalentUnit((String)CollectionsKt.random(buildableWorkerLikeUnits.keySet(), Random.Default));
        }
        return civ.getEquivalentUnit(unit);
    }

    private final void adjustStartingUnitsForCityStatesAndOneCityChallenge(Civilization civ, GameInfo gameInfo, List<String> startingUnits, Map<String, BaseUnit> settlerLikeUnits) {
        List startingSettlers;
        String it;
        Iterable $this$filterTo$iv$iv;
        boolean $i$f$filterTo;
        Collection destination$iv$iv;
        boolean $i$f$filter;
        Iterable $this$filter$iv;
        if (civ.isCityState() && !IHasUniques.hasUnique$default(gameInfo.getRuleset().getModOptions(), UniqueType.AllowCityStatesSpawnUnits, null, 2, null)) {
            $this$filter$iv = startingUnits;
            $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (String)element$iv$iv;
                boolean bl = false;
                if (!settlerLikeUnits.containsKey(it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            startingSettlers = (List)destination$iv$iv;
            startingUnits.clear();
            startingUnits.add((String)CollectionsKt.random(startingSettlers, Random.Default));
        }
        if (civ.getPlayerType() == PlayerType.Human && gameInfo.getGameParameters().getOneCityChallenge()) {
            $this$filter$iv = startingUnits;
            $i$f$filter = false;
            $this$filterTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (String)element$iv$iv;
                boolean bl = false;
                if (!settlerLikeUnits.containsKey(it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            startingSettlers = (List)destination$iv$iv;
            startingUnits.removeAll(startingSettlers);
            startingUnits.add((String)CollectionsKt.random(startingSettlers, Random.Default));
        }
    }

    private final void placeStartingUnits(Civilization civ, Tile startingLocation, List<String> startingUnits, Ruleset ruleset, String eraUnitReplacement, Map<String, BaseUnit> settlerLikeUnits) {
        Iterator<String> iterator2 = startingUnits.iterator();
        while (iterator2.hasNext()) {
            String unit;
            Intrinsics.checkNotNullExpressionValue(iterator2.next(), "next(...)");
            BaseUnit unitToAdd = this.getEquivalentUnit(civ, unit, ruleset, eraUnitReplacement, settlerLikeUnits);
            if (unitToAdd == null) continue;
            UnitManager.placeUnitNearTile$default(civ.getUnits(), startingLocation.getPosition(), unitToAdd, null, 4, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Map<Tile, Float> getCandidateLand(int civCount, TileMap tileMap, HashMap<Tile, Float> startScores) {
        void $this$filterTo$iv$iv;
        tileMap.assignContinents(TileMap.AssignContinentsMode.Ensure);
        Sequence $this$sortedByDescending$iv = MapsKt.asSequence((Map)tileMap.getContinentSizes());
        boolean $i$f$sortedByDescending = false;
        List orderedContinents = SequencesKt.toList(SequencesKt.sortedWith($this$sortedByDescending$iv, new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry it = (Map.Entry)b;
                boolean bl = false;
                Comparable comparable = (Integer)it.getValue();
                it = (Map.Entry)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, (Comparable)((Integer)it.getValue()));
            }
        }));
        Collection<Integer> collection = tileMap.getContinentSizes().values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        int totalArea = CollectionsKt.sumOfInt((Iterable<Integer>)collection);
        int candidateArea = 0;
        HashSet candidateContinents = new HashSet();
        Iterator iterator2 = ((Iterable)orderedContinents).iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int index = n++;
            Map.Entry continentSize = (Map.Entry)iterator2.next();
            candidateContinents.add(continentSize.getKey());
            if (!((float)(candidateArea += ((Number)continentSize.getValue()).intValue()) >= (float)totalArea * 0.9f) && index < civCount) continue;
        }
        Map $this$filter$iv = startScores;
        boolean $i$f$filter = false;
        Map index = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator3 = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator3.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator3.next();
            boolean bl = false;
            if (!candidateContinents.contains(((Tile)it.getKey()).getContinent())) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        return destination$iv$iv;
    }

    private final HashMap<Civilization, Tile> getStartingLocations(List<Civilization> civs, TileMap tileMap, Map<Tile, Float> landTilesInBigEnoughGroup, HashMap<Tile, Float> startScores) {
        List<Civilization> civsOrderedByAvailableLocations = this.getCivsOrderedByAvailableLocations(civs, tileMap);
        for (int minimumDistanceBetweenStartingLocations = tileMap.getTileMatrix().size() / 6; -1 < minimumDistanceBetweenStartingLocations; --minimumDistanceBetweenStartingLocations) {
            HashMap<Civilization, Tile> startingLocations;
            List<Tile> freeTiles = this.getFreeTiles(tileMap, landTilesInBigEnoughGroup, minimumDistanceBetweenStartingLocations);
            HashMap<Civilization, Tile> hashMap = startingLocations = this.getStartingLocationsForCivs(civsOrderedByAvailableLocations, tileMap, freeTiles, startScores, minimumDistanceBetweenStartingLocations);
            if (hashMap == null) continue;
            return hashMap;
        }
        throw new Exception("Didn't manage to get starting tiles even with distance of 1?");
    }

    private final List<Civilization> getCivsOrderedByAvailableLocations(List<Civilization> civs, TileMap tileMap) {
        Iterable $this$sortedBy$iv = CollectionsKt.shuffled((Iterable)civs);
        boolean $i$f$sortedBy = false;
        Iterable $this$sortedByDescending$iv = CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(tileMap){
            final /* synthetic */ TileMap $tileMap$inlined;
            {
                this.$tileMap$inlined = tileMap;
            }

            /*
             * Unable to fully structure code
             */
            public final int compare(T a, T b) {
                block23: {
                    block25: {
                        block24: {
                            block17: {
                                block22: {
                                    block19: {
                                        block21: {
                                            block20: {
                                                block16: {
                                                    block18: {
                                                        civ = (Civilization)a;
                                                        $i$a$-sortedBy-GameStarter$getCivsOrderedByAvailableLocations$1 = false;
                                                        if (!((Map)this.$tileMap$inlined.getStartingLocationsByNation()).containsKey(civ.getCivName())) break block18;
                                                        v0 = 1;
                                                        break block19;
                                                    }
                                                    $this$any$iv = civ.getNation().getStartBias();
                                                    $i$f$any = false;
                                                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                                        v1 = false;
                                                    } else {
                                                        for (T element$iv : $this$any$iv) {
                                                            it = (String)element$iv;
                                                            $i$a$-any-GameStarter$getCivsOrderedByAvailableLocations$1$1 = false;
                                                            if (!this.$tileMap$inlined.getNaturalWonders().contains(it)) continue;
                                                            v1 = true;
                                                            break block16;
                                                        }
                                                        v1 = false;
                                                    }
                                                }
                                                if (!v1) break block20;
                                                v2 = GameStarter.access$getGameSetupInfo$p();
                                                if (v2 == null) {
                                                    Intrinsics.throwUninitializedPropertyAccessException("gameSetupInfo");
                                                    v2 = null;
                                                }
                                                if (v2.getGameParameters().getNoStartBias()) break block20;
                                                v0 = 2;
                                                break block19;
                                            }
                                            if (!civ.getNation().getStartBias().contains("Tundra")) break block21;
                                            v3 = GameStarter.access$getGameSetupInfo$p();
                                            if (v3 == null) {
                                                Intrinsics.throwUninitializedPropertyAccessException("gameSetupInfo");
                                                v3 = null;
                                            }
                                            if (v3.getGameParameters().getNoStartBias()) break block21;
                                            v0 = 3;
                                            break block19;
                                        }
                                        if (!(((Collection)civ.getNation().getStartBias()).isEmpty() == false)) ** GOTO lbl-1000
                                        v4 = GameStarter.access$getGameSetupInfo$p();
                                        if (v4 == null) {
                                            Intrinsics.throwUninitializedPropertyAccessException("gameSetupInfo");
                                            v4 = null;
                                        }
                                        if (!v4.getGameParameters().getNoStartBias()) {
                                            v0 = 4;
                                        } else lbl-1000:
                                        // 2 sources

                                        {
                                            v0 = 5;
                                        }
                                    }
                                    civ = (Civilization)b;
                                    var11_11 = Integer.valueOf(v0);
                                    $i$a$-sortedBy-GameStarter$getCivsOrderedByAvailableLocations$1 = false;
                                    if (!((Map)this.$tileMap$inlined.getStartingLocationsByNation()).containsKey(civ.getCivName())) break block22;
                                    v5 = 1;
                                    break block23;
                                }
                                $this$any$iv = civ.getNation().getStartBias();
                                $i$f$any = false;
                                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                    v6 = false;
                                } else {
                                    for (T element$iv : $this$any$iv) {
                                        it = (String)element$iv;
                                        $i$a$-any-GameStarter$getCivsOrderedByAvailableLocations$1$1 = false;
                                        if (!this.$tileMap$inlined.getNaturalWonders().contains(it)) continue;
                                        v6 = true;
                                        break block17;
                                    }
                                    v6 = false;
                                }
                            }
                            if (!v6) break block24;
                            v7 = GameStarter.access$getGameSetupInfo$p();
                            if (v7 == null) {
                                Intrinsics.throwUninitializedPropertyAccessException("gameSetupInfo");
                                v7 = null;
                            }
                            if (v7.getGameParameters().getNoStartBias()) break block24;
                            v5 = 2;
                            break block23;
                        }
                        if (!civ.getNation().getStartBias().contains("Tundra")) break block25;
                        v8 = GameStarter.access$getGameSetupInfo$p();
                        if (v8 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException("gameSetupInfo");
                            v8 = null;
                        }
                        if (v8.getGameParameters().getNoStartBias()) break block25;
                        v5 = 3;
                        break block23;
                    }
                    if (!(((Collection)civ.getNation().getStartBias()).isEmpty() == false)) ** GOTO lbl-1000
                    v9 = GameStarter.access$getGameSetupInfo$p();
                    if (v9 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("gameSetupInfo");
                        v9 = null;
                    }
                    if (!v9.getGameParameters().getNoStartBias()) {
                        v5 = 4;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v5 = 5;
                    }
                }
                return ComparisonsKt.compareValues(var11_11, v5);
            }
        });
        boolean $i$f$sortedByDescending = false;
        return CollectionsKt.sortedWith($this$sortedByDescending$iv, new Comparator(){

            public final int compare(T a, T b) {
                Civilization it = (Civilization)b;
                boolean bl = false;
                Comparable comparable = Boolean.valueOf(it.isHuman());
                it = (Civilization)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, it.isHuman());
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @Readonly
    private final List<Tile> getFreeTiles(TileMap tileMap, Map<Tile, Float> landTilesInBigEnoughGroup, int minimumDistanceBetweenStartingLocations) {
        void $this$sortedBy$iv;
        Sequence<Map.Entry> sequence = SequencesKt.filter(MapsKt.asSequence(landTilesInBigEnoughGroup), arg_0 -> GameStarter.getFreeTiles$lambda$57(tileMap, minimumDistanceBetweenStartingLocations, arg_0));
        boolean $i$f$sortedBy = false;
        return SequencesKt.toMutableList(SequencesKt.map(SequencesKt.sortedWith($this$sortedBy$iv, new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry it = (Map.Entry)a;
                boolean bl = false;
                Comparable comparable = (Float)it.getValue();
                it = (Map.Entry)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, (Comparable)((Float)it.getValue()));
            }
        }), GameStarter::getFreeTiles$lambda$59));
    }

    private final HashMap<Civilization, Tile> getStartingLocationsForCivs(List<Civilization> civsOrderedByAvailableLocations, TileMap tileMap, List<Tile> freeTiles, HashMap<Tile, Float> startScores, int minimumDistanceBetweenStartingLocations) {
        Civilization civ;
        Tile startingLocation;
        HashMap<Civilization, Tile> startingLocations = new HashMap<Civilization, Tile>();
        Iterator<Civilization> iterator2 = civsOrderedByAvailableLocations.iterator();
        while (iterator2.hasNext() && (startingLocation = this.getCivStartingLocation(civ = iterator2.next(), tileMap, freeTiles, startScores)) != null) {
            ((Map)startingLocations).put(civ, startingLocation);
            int distanceToNext = minimumDistanceBetweenStartingLocations / (civ.isCityState() ? 2 : 1);
            freeTiles.removeAll((Collection)SequencesKt.toSet(tileMap.getTilesInDistance(startingLocation.getPosition(), distanceToNext)));
        }
        return startingLocations.size() < civsOrderedByAvailableLocations.size() ? null : startingLocations;
    }

    private final Tile getCivStartingLocation(Civilization civ, TileMap tileMap, List<Tile> freeTiles, HashMap<Tile, Float> startScores) {
        Tile startingLocation;
        HashSet<Tile> hashSet = tileMap.getStartingLocationsByNation().get(civ.getCivName());
        Tile tile = startingLocation = hashSet != null ? (Tile)CollectionsKt.randomOrNull((Collection)hashSet, Random.Default) : null;
        if (startingLocation == null) {
            HashSet<Tile> hashSet2 = tileMap.getStartingLocationsByNation().get("Spectator");
            Tile tile2 = startingLocation = hashSet2 != null ? (Tile)CollectionsKt.randomOrNull((Collection)hashSet2, Random.Default) : null;
            if (startingLocation != null) {
                HashSet<Tile> hashSet3 = tileMap.getStartingLocationsByNation().get("Spectator");
                if (hashSet3 != null) {
                    hashSet3.remove(startingLocation);
                }
            }
        }
        if (startingLocation == null && !((Collection)freeTiles).isEmpty()) {
            startingLocation = this.getOneStartingLocation(civ, tileMap, freeTiles, startScores);
        }
        return startingLocation;
    }

    /*
     * WARNING - void declaration
     */
    private final Tile getOneStartingLocation(Civilization civ, TileMap tileMap, List<Tile> freeTiles, HashMap<Tile, Float> startScores) {
        boolean bl;
        block17: {
            GameSetupInfo gameSetupInfo = GameStarter.gameSetupInfo;
            if (gameSetupInfo == null) {
                Intrinsics.throwUninitializedPropertyAccessException("gameSetupInfo");
                gameSetupInfo = null;
            }
            if (gameSetupInfo.getGameParameters().getNoStartBias()) {
                return (Tile)CollectionsKt.random((Collection)freeTiles, Random.Default);
            }
            Iterable $this$any$iv = civ.getNation().getStartBias();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!tileMap.getNaturalWonders().contains(it)) continue;
                    bl = true;
                    break block17;
                }
                bl = false;
            }
        }
        if (bl) {
            void $this$sortedByDescending$iv;
            Sequence<Tile> $i$f$any = SequencesKt.filter(CollectionsKt.asSequence((Iterable)tileMap.getValues()), arg_0 -> GameStarter.getOneStartingLocation$lambda$61(civ, arg_0));
            boolean $i$f$sortedByDescending = false;
            Tile wonderNeighbor = (Tile)SequencesKt.firstOrNull(SequencesKt.sortedWith($this$sortedByDescending$iv, new Comparator(startScores){
                final /* synthetic */ HashMap $startScores$inlined;
                {
                    this.$startScores$inlined = hashMap;
                }

                public final int compare(T a, T b) {
                    Tile it = (Tile)b;
                    boolean bl = false;
                    Comparable comparable = (Float)this.$startScores$inlined.get(it);
                    it = (Tile)a;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues(comparable2, (Comparable)((Float)this.$startScores$inlined.get(it)));
                }
            }));
            if (wonderNeighbor != null) {
                return wonderNeighbor;
            }
        }
        List preferredTiles = CollectionsKt.toList((Iterable)freeTiles);
        Iterator<String> iterator2 = civ.getNation().getStartBias().iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator<String> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            List list2;
            String startBias;
            Intrinsics.checkNotNullExpressionValue(iterator3.next(), "next(...)");
            if (TranslationsKt.equalsPlaceholderText(startBias, "Avoid []")) {
                void $this$filterTo$iv$iv;
                String tileToAvoid = TranslationsKt.getPlaceholderParameters(startBias).get(0);
                Iterable $this$filter$iv = preferredTiles;
                boolean $i$f$filter2 = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    boolean bl3;
                    block18: {
                        Tile tile = (Tile)element$iv$iv;
                        boolean bl4 = false;
                        Sequence<Tile> $this$any$iv = tile.getTilesInDistance(1);
                        boolean $i$f$any = false;
                        Iterator<Tile> iterator4 = $this$any$iv.iterator();
                        while (iterator4.hasNext()) {
                            Tile element$iv;
                            Tile it = element$iv = iterator4.next();
                            boolean bl5 = false;
                            if (!Tile.matchesTerrainFilter$default(it, tileToAvoid, null, false, 4, null)) continue;
                            bl3 = true;
                            break block18;
                        }
                        bl3 = false;
                    }
                    boolean bl6 = !bl3;
                    if (!bl6) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                list2 = (List)destination$iv$iv;
            } else if (tileMap.getNaturalWonders().contains(startBias)) {
                list2 = preferredTiles;
            } else {
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv = preferredTiles;
                boolean $i$f$filter = false;
                Iterable $i$f$filter2 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    boolean bl7;
                    block19: {
                        Tile tile = (Tile)element$iv$iv;
                        boolean bl8 = false;
                        Sequence<Tile> $this$any$iv = tile.getTilesInDistance(1);
                        boolean $i$f$any = false;
                        Iterator<Tile> iterator5 = $this$any$iv.iterator();
                        while (iterator5.hasNext()) {
                            Tile element$iv;
                            Tile it = element$iv = iterator5.next();
                            boolean bl9 = false;
                            if (!Tile.matchesTerrainFilter$default(it, startBias, null, false, 4, null)) continue;
                            bl7 = true;
                            break block19;
                        }
                        bl7 = false;
                    }
                    if (!bl7) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                list2 = (List)destination$iv$iv;
            }
            preferredTiles = list2;
        }
        Tile tile = (Tile)CollectionsKt.randomOrNull(preferredTiles, Random.Default);
        if (tile == null) {
            tile = (Tile)CollectionsKt.random((Collection)freeTiles, Random.Default);
        }
        return tile;
    }

    private static final boolean startNewGame$lambda$0(String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return !RulesetCache.INSTANCE.containsKey((Object)it);
    }

    private static final Unit startNewGame$lambda$2(Ref.ObjectRef $tileMap, GameSetupInfo $gameSetupInfo, Ref.ObjectRef $phaseOneChosenCivs, GameInfo $gameInfo, Ruleset $ruleset) {
        FileHandle fileHandle = $gameSetupInfo.getMapFile();
        Intrinsics.checkNotNull(fileHandle);
        $tileMap.element = MapSaver.INSTANCE.loadMap(fileHandle);
        $phaseOneChosenCivs.element = INSTANCE.chooseCivilizations($gameSetupInfo.getGameParameters(), $gameInfo, $ruleset, true);
        return Unit.INSTANCE;
    }

    private static final Unit startNewGame$lambda$3(Ref.ObjectRef $phaseOneChosenCivs, GameSetupInfo $gameSetupInfo, GameInfo $gameInfo, Ruleset $ruleset, Ref.ObjectRef $tileMap, MapGenerator $mapGen) {
        TileMap tileMap;
        $phaseOneChosenCivs.element = INSTANCE.chooseCivilizations($gameSetupInfo.getGameParameters(), $gameInfo, $ruleset, false);
        INSTANCE.addCivilizations($gameSetupInfo.getGameParameters(), $gameInfo, $ruleset, (List)$phaseOneChosenCivs.element);
        $tileMap.element = $mapGen.generateMap($gameSetupInfo.getMapParameters(), $gameSetupInfo.getGameParameters(), $gameInfo.getCivilizations());
        if ($tileMap.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException("tileMap");
            tileMap = null;
        } else {
            tileMap = (TileMap)$tileMap.element;
        }
        tileMap.setMapParameters($gameSetupInfo.getMapParameters());
        $gameInfo.getCivilizations().clear();
        return Unit.INSTANCE;
    }

    private static final Unit startNewGame$lambda$4(GameInfo $gameInfo, Ref.ObjectRef $tileMap, GameSetupInfo $gameSetupInfo, Ruleset $ruleset, Ref.ObjectRef $phaseOneChosenCivs) {
        TileMap tileMap;
        TileMap tileMap2;
        if ($tileMap.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException("tileMap");
            tileMap2 = null;
        } else {
            tileMap2 = (TileMap)$tileMap.element;
        }
        $gameInfo.setTileMap(tileMap2);
        if ($tileMap.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException("tileMap");
            tileMap = null;
        } else {
            tileMap = (TileMap)$tileMap.element;
        }
        tileMap.setGameInfo($gameInfo);
        INSTANCE.addCivilizations($gameSetupInfo.getGameParameters(), $gameInfo, $ruleset, (List)$phaseOneChosenCivs.element);
        return Unit.INSTANCE;
    }

    private static final Unit startNewGame$lambda$6(Ref.ObjectRef $tileMap, GameInfo $gameInfo, Ruleset $ruleset) {
        TileMap tileMap;
        if ($tileMap.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException("tileMap");
            tileMap = null;
        } else {
            tileMap = (TileMap)$tileMap.element;
        }
        for (Tile tile : tileMap.getValues()) {
            Iterator<MapUnit> iterator2 = tile.getUnits().iterator();
            while (iterator2.hasNext()) {
                boolean bl;
                MapUnit unit;
                block7: {
                    unit = iterator2.next();
                    Iterable $this$none$iv = $gameInfo.getCivilizations();
                    boolean $i$f$none = false;
                    if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$none$iv) {
                            Civilization it = (Civilization)element$iv;
                            boolean bl2 = false;
                            if (!Intrinsics.areEqual(it.getCivName(), unit.getOwner())) continue;
                            bl = false;
                            break block7;
                        }
                        bl = true;
                    }
                }
                if (!bl) continue;
                unit.setCurrentTile(tile);
                unit.setTransients($ruleset);
                unit.removeFromTile();
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit startNewGame$lambda$7(Ref.ObjectRef $tileMap) {
        TileMap tileMap;
        if ($tileMap.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException("tileMap");
            tileMap = null;
        } else {
            tileMap = (TileMap)$tileMap.element;
        }
        tileMap.assignContinents(TileMap.AssignContinentsMode.Ensure);
        return Unit.INSTANCE;
    }

    private static final Unit startNewGame$lambda$8(GameInfo $gameInfo, Ref.ObjectRef $tileMap, Ruleset $ruleset, GameSetupInfo $gameSetupInfo) {
        TileMap tileMap;
        TileMap tileMap2;
        $gameInfo.setHistoryStartTurn(0);
        if ($tileMap.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException("tileMap");
            tileMap2 = null;
        } else {
            tileMap2 = (TileMap)$tileMap.element;
        }
        TileMap.setTransients$default(tileMap2, $ruleset, false, 2, null);
        if ($tileMap.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException("tileMap");
            tileMap = null;
        } else {
            tileMap = (TileMap)$tileMap.element;
        }
        tileMap.setStartingLocationsTransients();
        $gameInfo.setDifficulty($gameSetupInfo.getGameParameters().getDifficulty());
        $gameInfo.setTransients();
        return Unit.INSTANCE;
    }

    private static final Unit startNewGame$lambda$9(GameInfo $gameInfo) {
        INSTANCE.addCivStartingUnits($gameInfo);
        return Unit.INSTANCE;
    }

    private static final Unit startNewGame$lambda$10(GameInfo $gameInfo, Ruleset $ruleset) {
        INSTANCE.addCivPolicies($gameInfo, $ruleset);
        return Unit.INSTANCE;
    }

    private static final Unit startNewGame$lambda$11(GameInfo $gameInfo, Ruleset $ruleset, GameSetupInfo $gameSetupInfo) {
        INSTANCE.addCivTechs($gameInfo, $ruleset, $gameSetupInfo);
        return Unit.INSTANCE;
    }

    private static final Unit startNewGame$lambda$12(GameInfo $gameInfo) {
        INSTANCE.addCivStats($gameInfo);
        return Unit.INSTANCE;
    }

    private static final void addCivTechs$addTechSilently(Civilization $this$addCivTechs_u24addTechSilently, Ruleset $ruleset, String name) {
        if (!$ruleset.getTechnologies().containsKey(name)) {
            return;
        }
        if ($this$addCivTechs_u24addTechSilently.getTech().isResearched(name)) {
            return;
        }
        $this$addCivTechs_u24addTechSilently.getTech().addTechnology(name, false);
    }

    private static final boolean chooseCivilizations$lambda$22(Set $selectedPlayerNames, String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return !$selectedPlayerNames.contains(it);
    }

    private static final boolean chooseCivilizations$lambda$27(Ref.ObjectRef $selectedAIToSkip, Player it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return ((List)$selectedAIToSkip.element).contains(it);
    }

    private static final Player chooseCivilizations$lambda$30(int it) {
        return new Player(null, null, null, 7, null);
    }

    private static final Player chooseCivilizations$lambda$31(ArrayDeque $presetRandomNationsPool, ArrayDeque $randomNationsPool, Player it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return !Intrinsics.areEqual(it.getChosenCiv(), "Random") ? it : (!((Collection)$presetRandomNationsPool).isEmpty() ? new Player((String)$presetRandomNationsPool.removeLast(), it.getPlayerType(), it.getPlayerId()) : (!((Collection)$randomNationsPool).isEmpty() ? new Player((String)$randomNationsPool.removeLast(), it.getPlayerType(), it.getPlayerId()) : null));
    }

    private static final boolean chooseCivilizations$lambda$34(Map.Entry it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return ((Nation)it.getValue()).isCityState() && !IHasUniques.hasUnique$default((IHasUniques)it.getValue(), UniqueType.WillNotBeChosenForNewGames, null, 2, null);
    }

    private static final String chooseCivilizations$lambda$35(Map.Entry it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return (String)it.getKey();
    }

    private static final Player chooseCivilizations$lambda$37(String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return new Player(it, null, null, 6, null);
    }

    private static final boolean addCivilizations$lambda$39(Map.Entry it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return ((Nation)it.getValue()).isMajorCiv();
    }

    private static final String addCivilizations$lambda$40(Map.Entry it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return (String)it.getKey();
    }

    private static final boolean addCivilizations$lambda$41(Set $usedCivNames, String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return $usedCivNames.contains(it);
    }

    private static final Sequence addCivStartingUnits$lambda$42(TileImprovement it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getMatchingUniques(UniqueType.EnsureMinimumStats, GameContext.Companion.getIgnoreConditionals());
    }

    private static final boolean getFreeTiles$lambda$57(TileMap $tileMap, int $minimumDistanceBetweenStartingLocations, Map.Entry it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return HexMath.INSTANCE.getDistanceFromEdge(((Tile)it.getKey()).getPosition(), $tileMap.getMapParameters()) >= $minimumDistanceBetweenStartingLocations * 2 / 3;
    }

    private static final Tile getFreeTiles$lambda$59(Map.Entry it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return (Tile)it.getKey();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean getOneStartingLocation$lambda$61(Civilization $civ, Tile it) {
        Intrinsics.checkNotNullParameter(it, "it");
        if (!it.isNaturalWonder()) return false;
        ArrayList<String> arrayList = $civ.getNation().getStartBias();
        String string = it.getNaturalWonder();
        Intrinsics.checkNotNull(string);
        if (!arrayList.contains(string)) return false;
        return true;
    }

    public static final /* synthetic */ GameSetupInfo access$getGameSetupInfo$p() {
        return gameSetupInfo;
    }
}

