/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.worldscreen.unit.presenter;

import com.badlogic.gdx.math.Vector2;
import com.unciv.logic.battle.CityCombatant;
import com.unciv.logic.battle.ICombatant;
import com.unciv.logic.city.City;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.screens.pickerscreens.CityRenamePopup;
import com.unciv.ui.screens.worldscreen.unit.UnitTable;
import com.unciv.ui.screens.worldscreen.unit.presenter.UnitPresenter;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\tJ\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\b\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0016\u0010\u000e\u001a\u0004\u0018\u00010\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0017"}, d2={"Lcom/unciv/ui/screens/worldscreen/unit/presenter/CityPresenter;", "Lcom/unciv/ui/screens/worldscreen/unit/UnitTable$Presenter;", "unitTable", "Lcom/unciv/ui/screens/worldscreen/unit/UnitTable;", "unitPresenter", "Lcom/unciv/ui/screens/worldscreen/unit/presenter/UnitPresenter;", "<init>", "(Lcom/unciv/ui/screens/worldscreen/unit/UnitTable;Lcom/unciv/ui/screens/worldscreen/unit/presenter/UnitPresenter;)V", "selectedCity", "Lcom/unciv/logic/city/City;", "getSelectedCity", "()Lcom/unciv/logic/city/City;", "setSelectedCity", "(Lcom/unciv/logic/city/City;)V", "position", "Lcom/badlogic/gdx/math/Vector2;", "getPosition", "()Lcom/badlogic/gdx/math/Vector2;", "selectCity", "", "city", "updateWhenNeeded", "", "core"})
public final class CityPresenter
implements UnitTable.Presenter {
    @NotNull
    private final UnitTable unitTable;
    @NotNull
    private final UnitPresenter unitPresenter;
    @Nullable
    private City selectedCity;

    public CityPresenter(@NotNull UnitTable unitTable, @NotNull UnitPresenter unitPresenter) {
        Intrinsics.checkNotNullParameter(unitTable, "unitTable");
        Intrinsics.checkNotNullParameter(unitPresenter, "unitPresenter");
        this.unitTable = unitTable;
        this.unitPresenter = unitPresenter;
    }

    @Nullable
    public final City getSelectedCity() {
        return this.selectedCity;
    }

    public final void setSelectedCity(@Nullable City city) {
        this.selectedCity = city;
    }

    @Override
    @Nullable
    public Vector2 getPosition() {
        City city = this.selectedCity;
        return city != null ? city.getLocation() : null;
    }

    public final boolean selectCity(@NotNull City city) {
        UnitPresenter unitPresenter;
        Intrinsics.checkNotNullParameter(city, "city");
        UnitPresenter $this$selectCity_u24lambda_u240 = unitPresenter = this.unitPresenter;
        boolean bl = false;
        if ($this$selectCity_u24lambda_u240.getSelectedUnitIsConnectingRoad()) {
            UnitPresenter.selectUnit$default($this$selectCity_u24lambda_u240, $this$selectCity_u24lambda_u240.getSelectedUnits().get(0), false, 2, null);
            $this$selectCity_u24lambda_u240.setSelectedUnitIsConnectingRoad(true);
        } else {
            UnitPresenter.selectUnit$default($this$selectCity_u24lambda_u240, null, false, 3, null);
        }
        if (Intrinsics.areEqual(city, this.selectedCity)) {
            return false;
        }
        this.selectedCity = city;
        return true;
    }

    @Override
    public void updateWhenNeeded() {
        UnitTable $this$updateWhenNeeded_u24lambda_u243 = this.unitTable;
        boolean bl = false;
        $this$updateWhenNeeded_u24lambda_u243.getSeparator$core().setVisible(true);
        City city = $this$updateWhenNeeded_u24lambda_u243.getSelectedCity();
        Intrinsics.checkNotNull(city);
        City city2 = city;
        String nameLabelText = TranslationsKt.tr$default(city2.getName(), false, false, 3, null);
        if (city2.getHealth() < city2.getMaxHealth$core()) {
            nameLabelText = nameLabelText + " (" + TranslationsKt.tr(city2.getHealth()) + ')';
        }
        $this$updateWhenNeeded_u24lambda_u243.getUnitNameLabel$core().setText(nameLabelText);
        $this$updateWhenNeeded_u24lambda_u243.getUnitNameLabel$core().clearListeners();
        ActivationExtensionsKt.onClick($this$updateWhenNeeded_u24lambda_u243.getUnitNameLabel$core(), () -> CityPresenter.updateWhenNeeded$lambda$3$lambda$2($this$updateWhenNeeded_u24lambda_u243, city2));
        $this$updateWhenNeeded_u24lambda_u243.getDescriptionTable$core().clear();
        $this$updateWhenNeeded_u24lambda_u243.getDescriptionTable$core().defaults().pad(2.0f).padRight(5.0f);
        $this$updateWhenNeeded_u24lambda_u243.getDescriptionTable$core().add(TranslationsKt.tr$default("Strength", false, false, 3, null));
        $this$updateWhenNeeded_u24lambda_u243.getDescriptionTable$core().add(TranslationsKt.tr(ICombatant.getDefendingStrength$default(new CityCombatant(city2), false, 1, null))).row();
        $this$updateWhenNeeded_u24lambda_u243.getDescriptionTable$core().add(TranslationsKt.tr$default("Bombard strength", false, false, 3, null));
        $this$updateWhenNeeded_u24lambda_u243.getDescriptionTable$core().add(TranslationsKt.tr(new CityCombatant(city2).getAttackingStrength())).row();
        $this$updateWhenNeeded_u24lambda_u243.setShouldUpdate(true);
    }

    @Override
    public void update() {
        UnitTable.Presenter.super.update();
    }

    @Override
    public boolean shouldBeShown() {
        return UnitTable.Presenter.super.shouldBeShown();
    }

    private static final Unit updateWhenNeeded$lambda$3$lambda$2$lambda$1(UnitTable $this_with, City $city) {
        $this_with.getUnitNameLabel$core().setText(TranslationsKt.tr$default($city.getName(), false, false, 3, null));
        $this_with.getWorldScreen().setShouldUpdate(true);
        return Unit.INSTANCE;
    }

    private static final Unit updateWhenNeeded$lambda$3$lambda$2(UnitTable $this_with, City $city) {
        if (!$this_with.getWorldScreen().getCanChangeState()) {
            return Unit.INSTANCE;
        }
        new CityRenamePopup($this_with.getWorldScreen(), $city, () -> CityPresenter.updateWhenNeeded$lambda$3$lambda$2$lambda$1($this_with, $city));
        return Unit.INSTANCE;
    }
}

