/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.worldscreen.topbar;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.unciv.logic.GameInfo;
import com.unciv.logic.civilization.Civilization;
import com.unciv.models.ruleset.tile.ResourceSupplyList;
import com.unciv.models.ruleset.tile.ResourceType;
import com.unciv.models.ruleset.tile.TileResource;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.components.MayaCalendar;
import com.unciv.ui.components.YearTextUtil;
import com.unciv.ui.components.extensions.FormattingExtensionsKt;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.widgets.ScalingTableWrapper;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.screens.overviewscreen.EmpireOverviewCategories;
import com.unciv.ui.screens.victoryscreen.VictoryScreen;
import com.unciv.ui.screens.worldscreen.WorldScreen;
import com.unciv.ui.screens.worldscreen.topbar.WorldScreenTopBar;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00172\u00020\u0001:\u0002\u0016\u0017B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\n0\tj\b\u0012\u0004\u0012\u00020\n`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0018"}, d2={"Lcom/unciv/ui/screens/worldscreen/topbar/WorldScreenTopBarResources;", "Lcom/unciv/ui/components/widgets/ScalingTableWrapper;", "topbar", "Lcom/unciv/ui/screens/worldscreen/topbar/WorldScreenTopBar;", "<init>", "(Lcom/unciv/ui/screens/worldscreen/topbar/WorldScreenTopBar;)V", "turnsLabel", "Lcom/badlogic/gdx/scenes/scene2d/ui/Label;", "resourceActors", "Ljava/util/ArrayList;", "Lcom/unciv/ui/screens/worldscreen/topbar/WorldScreenTopBarResources$ResourceActors;", "Lkotlin/collections/ArrayList;", "resourcesWrapper", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "worldScreen", "Lcom/unciv/ui/screens/worldscreen/WorldScreen;", "getWorldScreen", "()Lcom/unciv/ui/screens/worldscreen/WorldScreen;", "update", "", "civInfo", "Lcom/unciv/logic/civilization/Civilization;", "ResourceActors", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nWorldScreenTopBarResources.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WorldScreenTopBarResources.kt\ncom/unciv/ui/screens/worldscreen/topbar/WorldScreenTopBarResources\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,117:1\n774#2:118\n865#2,2:119\n295#2,2:121\n*S KotlinDebug\n*F\n+ 1 WorldScreenTopBarResources.kt\ncom/unciv/ui/screens/worldscreen/topbar/WorldScreenTopBarResources\n*L\n65#1:118\n65#1:119,2\n107#1:121,2\n*E\n"})
public final class WorldScreenTopBarResources
extends ScalingTableWrapper {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Label turnsLabel;
    @NotNull
    private final ArrayList<ResourceActors> resourceActors;
    @NotNull
    private final Table resourcesWrapper;
    @NotNull
    private final WorldScreen worldScreen;
    @Deprecated
    public static final float defaultPad = 5.0f;
    @Deprecated
    public static final float extraPadBetweenLabelAndResources = 20.0f;
    @Deprecated
    public static final float bottomPad = 10.0f;
    @Deprecated
    public static final float extraPadBetweenResources = 5.0f;
    @Deprecated
    public static final float outerHorizontalPad = 2.0f;
    @Deprecated
    public static final float iconSize = 20.0f;
    @Deprecated
    public static final float resourceAmountDescentTweak = 3.0f;

    /*
     * WARNING - void declaration
     */
    public WorldScreenTopBarResources(@NotNull WorldScreenTopBar topbar) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(topbar, "topbar");
        super(0.0f, 1, null);
        this.turnsLabel = Scene2dExtensionsKt.toLabel("Turns: 0/400");
        this.resourceActors = new ArrayList(12);
        this.resourcesWrapper = new Table();
        this.worldScreen = topbar.getWorldScreen$core();
        this.defaults().space(20.0f).pad(5.0f, 2.0f, 10.0f, 2.0f);
        this.resourcesWrapper.defaults().space(5.0f);
        this.resourcesWrapper.setTouchable(Touchable.enabled);
        ActivationExtensionsKt.onClick(this.turnsLabel, () -> WorldScreenTopBarResources._init_$lambda$0(this));
        ActivationExtensionsKt.onClick(this.resourcesWrapper, () -> WorldScreenTopBarResources._init_$lambda$1(this));
        Collection<TileResource> collection = this.worldScreen.getGameInfo().getRuleset().getTileResources().values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            TileResource it = (TileResource)element$iv$iv;
            boolean bl = false;
            if (!(it.getResourceType() == ResourceType.Strategic && !it.isCityWide())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List strategicResources = (List)destination$iv$iv;
        for (Object e : strategicResources) {
            Intrinsics.checkNotNullExpressionValue(e, "next(...)");
            TileResource resource = (TileResource)e;
            Group resourceImage = ImageGetter.getResourcePortrait$default(ImageGetter.INSTANCE, resource.getName(), 20.0f, 0, 4, null);
            Label resourceLabel = Scene2dExtensionsKt.toLabel("0");
            ((Collection)this.resourceActors).add(new ResourceActors(resource, resourceLabel, resourceImage));
        }
        this.add(this.turnsLabel);
        if (!((Collection)this.resourceActors).isEmpty()) {
            this.resourcesWrapper.add((Actor)this.resourceActors.get(0).getIcon());
            this.add(this.resourcesWrapper);
        }
    }

    @NotNull
    public final WorldScreen getWorldScreen() {
        return this.worldScreen;
    }

    public final void update(@NotNull Civilization civInfo) {
        Intrinsics.checkNotNullParameter(civInfo, "civInfo");
        this.resetScale();
        String yearText = YearTextUtil.INSTANCE.toYearText(GameInfo.getYear$default(civInfo.getGameInfo(), 0, 1, null), civInfo.isLongCountDisplay());
        char c = '\u23f3';
        String string = "\u2004";
        this.turnsLabel.setText(c + string + TranslationsKt.tr(civInfo.getGameInfo().getTurns()) + "\u2004|\u2004" + yearText);
        this.resourcesWrapper.clearChildren();
        HashMap<String, Integer> civResources = civInfo.getCivResourcesByName();
        ResourceSupplyList civResourceSupply = civInfo.getCivResourceSupply();
        Iterator iterator2 = ((Iterable)this.resourceActors).iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int amount;
            int index = n++;
            ResourceActors resourceActors = (ResourceActors)iterator2.next();
            TileResource resource = resourceActors.component1();
            Label label = resourceActors.component2();
            Group icon = resourceActors.component3();
            if (resource.hasUnique(UniqueType.NotShownOnWorldScreen, civInfo.getState())) continue;
            Integer n2 = civResources.get(resource.getName());
            int n3 = amount = n2 != null ? n2 : 0;
            if (!civInfo.getTech().isRevealed(resource) && amount == 0) continue;
            this.resourcesWrapper.add((Actor)icon).padLeft(index == 0 ? 0.0f : 5.0f);
            if (!resource.isStockpiled()) {
                label.setText(TranslationsKt.tr(amount));
            } else {
                int perTurn;
                Object v2;
                block6: {
                    Iterable $this$firstOrNull$iv = civResourceSupply;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        ResourceSupplyList.ResourceSupply it = (ResourceSupplyList.ResourceSupply)element$iv;
                        boolean bl = false;
                        if (!Intrinsics.areEqual(it.getResource(), resource)) continue;
                        v2 = element$iv;
                        break block6;
                    }
                    v2 = null;
                }
                ResourceSupplyList.ResourceSupply resourceSupply = v2;
                int n4 = perTurn = resourceSupply != null ? resourceSupply.getAmount() : 0;
                if (perTurn == 0) {
                    label.setText(TranslationsKt.tr(amount));
                } else {
                    label.setText(TranslationsKt.tr(amount) + " (" + FormattingExtensionsKt.toStringSigned(perTurn) + ')');
                }
            }
            this.resourcesWrapper.add((Actor)label).padTop(3.0f);
        }
        this.scaleTo(this.worldScreen.getStage().getWidth());
    }

    private static final Unit _init_$lambda$0(WorldScreenTopBarResources this$0) {
        if (this$0.worldScreen.getSelectedCiv().isLongCountDisplay()) {
            GameInfo gameInfo = this$0.worldScreen.getSelectedCiv().getGameInfo();
            MayaCalendar.INSTANCE.openPopup(this$0.worldScreen, this$0.worldScreen.getSelectedCiv(), GameInfo.getYear$default(gameInfo, 0, 1, null));
        } else {
            this$0.worldScreen.getGame().pushScreen(new VictoryScreen(this$0.worldScreen, 0, 2, null));
        }
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1(WorldScreenTopBarResources this$0) {
        this$0.worldScreen.openEmpireOverview(EmpireOverviewCategories.Resources);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0007\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/unciv/ui/screens/worldscreen/topbar/WorldScreenTopBarResources$Companion;", "", "<init>", "()V", "defaultPad", "", "extraPadBetweenLabelAndResources", "bottomPad", "extraPadBetweenResources", "outerHorizontalPad", "iconSize", "resourceAmountDescentTweak", "core"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001b"}, d2={"Lcom/unciv/ui/screens/worldscreen/topbar/WorldScreenTopBarResources$ResourceActors;", "", "resource", "Lcom/unciv/models/ruleset/tile/TileResource;", "label", "Lcom/badlogic/gdx/scenes/scene2d/ui/Label;", "icon", "Lcom/badlogic/gdx/scenes/scene2d/Group;", "<init>", "(Lcom/unciv/models/ruleset/tile/TileResource;Lcom/badlogic/gdx/scenes/scene2d/ui/Label;Lcom/badlogic/gdx/scenes/scene2d/Group;)V", "getResource", "()Lcom/unciv/models/ruleset/tile/TileResource;", "getLabel", "()Lcom/badlogic/gdx/scenes/scene2d/ui/Label;", "getIcon", "()Lcom/badlogic/gdx/scenes/scene2d/Group;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "core"})
    private static final class ResourceActors {
        @NotNull
        private final TileResource resource;
        @NotNull
        private final Label label;
        @NotNull
        private final Group icon;

        public ResourceActors(@NotNull TileResource resource, @NotNull Label label, @NotNull Group icon) {
            Intrinsics.checkNotNullParameter(resource, "resource");
            Intrinsics.checkNotNullParameter(label, "label");
            Intrinsics.checkNotNullParameter(icon, "icon");
            this.resource = resource;
            this.label = label;
            this.icon = icon;
        }

        @NotNull
        public final TileResource getResource() {
            return this.resource;
        }

        @NotNull
        public final Label getLabel() {
            return this.label;
        }

        @NotNull
        public final Group getIcon() {
            return this.icon;
        }

        @NotNull
        public final TileResource component1() {
            return this.resource;
        }

        @NotNull
        public final Label component2() {
            return this.label;
        }

        @NotNull
        public final Group component3() {
            return this.icon;
        }

        @NotNull
        public final ResourceActors copy(@NotNull TileResource resource, @NotNull Label label, @NotNull Group icon) {
            Intrinsics.checkNotNullParameter(resource, "resource");
            Intrinsics.checkNotNullParameter(label, "label");
            Intrinsics.checkNotNullParameter(icon, "icon");
            return new ResourceActors(resource, label, icon);
        }

        public static /* synthetic */ ResourceActors copy$default(ResourceActors resourceActors, TileResource tileResource, Label label, Group group, int n, Object object) {
            if ((n & 1) != 0) {
                tileResource = resourceActors.resource;
            }
            if ((n & 2) != 0) {
                label = resourceActors.label;
            }
            if ((n & 4) != 0) {
                group = resourceActors.icon;
            }
            return resourceActors.copy(tileResource, label, group);
        }

        @NotNull
        public String toString() {
            return "ResourceActors(resource=" + this.resource + ", label=" + this.label + ", icon=" + this.icon + ')';
        }

        public int hashCode() {
            int result2 = this.resource.hashCode();
            result2 = result2 * 31 + this.label.hashCode();
            result2 = result2 * 31 + this.icon.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ResourceActors)) {
                return false;
            }
            ResourceActors resourceActors = (ResourceActors)other;
            if (!Intrinsics.areEqual(this.resource, resourceActors.resource)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.label, resourceActors.label)) {
                return false;
            }
            return Intrinsics.areEqual(this.icon, resourceActors.icon);
        }
    }
}

