/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.pickerscreens;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.unciv.models.ruleset.unit.Promotion;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.widgets.BorderedTable;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.pickerscreens.PromotionScreenColors;
import com.unciv.ui.screens.pickerscreens.PromotionTree;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ*\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00052\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00030\u0019R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u000eR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n \u0012*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\n \u0012*\u0004\u0018\u00010\u00140\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/unciv/ui/screens/pickerscreens/PromotionButton;", "Lcom/unciv/ui/components/widgets/BorderedTable;", "node", "Lcom/unciv/ui/screens/pickerscreens/PromotionTree$PromotionNode;", "isPickable", "", "adoptedLabelStyle", "Lcom/badlogic/gdx/scenes/scene2d/ui/Label$LabelStyle;", "maxWidth", "", "<init>", "(Lcom/unciv/ui/screens/pickerscreens/PromotionTree$PromotionNode;ZLcom/badlogic/gdx/scenes/scene2d/ui/Label$LabelStyle;F)V", "getNode", "()Lcom/unciv/ui/screens/pickerscreens/PromotionTree$PromotionNode;", "()Z", "label", "Lcom/badlogic/gdx/scenes/scene2d/ui/Label;", "defaultLabelStyle", "kotlin.jvm.PlatformType", "colors", "Lcom/unciv/ui/screens/pickerscreens/PromotionScreenColors;", "updateColor", "", "isSelected", "pathToSelection", "", "Lcom/unciv/models/ruleset/unit/Promotion;", "prerequisites", "core"})
public final class PromotionButton
extends BorderedTable {
    @NotNull
    private final PromotionTree.PromotionNode node;
    private final boolean isPickable;
    @NotNull
    private final Label.LabelStyle adoptedLabelStyle;
    @NotNull
    private final Label label;
    private final Label.LabelStyle defaultLabelStyle;
    private final PromotionScreenColors colors;

    public PromotionButton(@NotNull PromotionTree.PromotionNode node, boolean isPickable, @NotNull Label.LabelStyle adoptedLabelStyle, float maxWidth) {
        Intrinsics.checkNotNullParameter(node, "node");
        Intrinsics.checkNotNullParameter(adoptedLabelStyle, "adoptedLabelStyle");
        super("PromotionScreen/PromotionButton", BaseScreen.Companion.getSkinStrings().getRoundedEdgeRectangleMidShape(), BaseScreen.Companion.getSkinStrings().getRoundedEdgeRectangleMidBorderShape());
        this.node = node;
        this.isPickable = isPickable;
        this.adoptedLabelStyle = adoptedLabelStyle;
        this.label = Scene2dExtensionsKt.toLabel$default(this.node.getPromotion().getName(), null, 0, 0, true, 7, null);
        this.defaultLabelStyle = this.label.getStyle();
        this.colors = BaseScreen.Companion.getSkin().get(PromotionScreenColors.class);
        this.setTouchable(Touchable.enabled);
        this.setBorderSize(5.0f);
        this.pad(5.0f);
        this.align(8);
        this.add((Actor)ImageGetter.getPromotionPortrait$default(ImageGetter.INSTANCE, this.node.getPromotion().getName(), 0.0f, 2, null)).padRight(10.0f);
        this.label.setEllipsis(true);
        this.add((Actor)this.label).left().maxWidth(maxWidth);
        this.updateColor(false, SetsKt.emptySet(), SetsKt.emptySet());
    }

    @NotNull
    public final PromotionTree.PromotionNode getNode() {
        return this.node;
    }

    public final boolean isPickable() {
        return this.isPickable;
    }

    public final void updateColor(boolean isSelected, @NotNull Set<Promotion> pathToSelection, @NotNull Set<PromotionTree.PromotionNode> prerequisites) {
        Intrinsics.checkNotNullParameter(pathToSelection, "pathToSelection");
        Intrinsics.checkNotNullParameter(prerequisites, "prerequisites");
        this.setBgColor(isSelected ? this.colors.getSelected() : (this.node.isAdopted() ? this.colors.getPromoted() : (pathToSelection.contains(this.node.getPromotion()) ? this.colors.getPathToSelection() : (prerequisites.contains(this.node) ? this.colors.getPrerequisite() : (this.isPickable ? this.colors.getPickable() : this.colors.getDefault())))));
        this.label.setStyle(!isSelected && this.node.isAdopted() ? this.adoptedLabelStyle : this.defaultLabelStyle);
    }
}

