/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.mapeditorscreen.tabs;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.unciv.logic.map.MapParameters;
import com.unciv.logic.map.tile.Tile;
import com.unciv.logic.map.tile.TileNormalizer;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.RulesetCache;
import com.unciv.ui.components.UncivTooltip;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.widgets.TabbedPager;
import com.unciv.ui.components.widgets.TranslatedSelectBox;
import com.unciv.ui.popups.Popup;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.mapeditorscreen.MapEditorScreen;
import com.unciv.ui.screens.newgamescreen.ModCheckboxTable;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002:\u0001#B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0014\u001a\u00020\u0015H\u0002J\b\u0010\u0016\u001a\u00020\u0015H\u0002J\b\u0010\u0017\u001a\u00020\u0015H\u0002J \u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\t0\u001f2\u0006\u0010 \u001a\u00020!H\u0002J\u0010\u0010\"\u001a\u00020\u00152\u0006\u0010 \u001a\u00020!H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\t0\bj\b\u0012\u0004\u0012\u00020\t`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/unciv/ui/screens/mapeditorscreen/tabs/MapEditorModsTab;", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "Lcom/unciv/ui/components/widgets/TabbedPager$IPageExtensions;", "editorScreen", "Lcom/unciv/ui/screens/mapeditorscreen/MapEditorScreen;", "<init>", "(Lcom/unciv/ui/screens/mapeditorscreen/MapEditorScreen;)V", "mods", "Ljava/util/LinkedHashSet;", "", "Lkotlin/collections/LinkedHashSet;", "modsTable", "Lcom/unciv/ui/screens/newgamescreen/ModCheckboxTable;", "modsTableCell", "Lcom/badlogic/gdx/scenes/scene2d/ui/Cell;", "applyButton", "Lcom/badlogic/gdx/scenes/scene2d/ui/TextButton;", "revertButton", "baseRulesetSelectBox", "Lcom/unciv/ui/components/widgets/TranslatedSelectBox;", "enableApplyButton", "", "revertControls", "applyControls", "activated", "index", "", "caption", "pager", "Lcom/unciv/ui/components/widgets/TabbedPager;", "getIncompatibilities", "", "newRuleset", "Lcom/unciv/models/ruleset/Ruleset;", "fitMapToRuleset", "AskFitMapToRulesetPopup", "core"})
public final class MapEditorModsTab
extends Table
implements TabbedPager.IPageExtensions {
    @NotNull
    private final MapEditorScreen editorScreen;
    @NotNull
    private final LinkedHashSet<String> mods;
    @NotNull
    private ModCheckboxTable modsTable;
    @NotNull
    private final Cell<ModCheckboxTable> modsTableCell;
    @NotNull
    private final TextButton applyButton;
    @NotNull
    private final TextButton revertButton;
    @NotNull
    private final TranslatedSelectBox baseRulesetSelectBox;

    /*
     * WARNING - void declaration
     */
    public MapEditorModsTab(@NotNull MapEditorScreen editorScreen) {
        void $this$_init__u24lambda_u243;
        Table $this$_init__u24lambda_u242;
        Table table2;
        Intrinsics.checkNotNullParameter(editorScreen, "editorScreen");
        super(BaseScreen.Companion.getSkin());
        this.editorScreen = editorScreen;
        this.mods = this.editorScreen.getNewMapParameters().getMods();
        this.applyButton = Scene2dExtensionsKt.toTextButton$default("Change map ruleset", null, false, 3, null);
        this.revertButton = Scene2dExtensionsKt.toTextButton$default("Revert to map ruleset", null, false, 3, null);
        String rulesetName = this.editorScreen.getNewMapParameters().getBaseRuleset();
        this.modsTable = new ModCheckboxTable(new LinkedHashSet<String>(), rulesetName, this.editorScreen, false, MapEditorModsTab::_init_$lambda$0);
        List<String> baseRulesets = RulesetCache.INSTANCE.getSortedBaseRulesets();
        this.baseRulesetSelectBox = new TranslatedSelectBox((Collection<String>)baseRulesets, rulesetName);
        ActivationExtensionsKt.onChange(this.baseRulesetSelectBox, arg_0 -> MapEditorModsTab._init_$lambda$1(this, arg_0));
        this.top();
        this.pad(5.0f);
        Table table3 = table2 = new Table();
        MapEditorModsTab mapEditorModsTab = this;
        boolean bl = false;
        $this$_init__u24lambda_u242.add((Actor)Scene2dExtensionsKt.toLabel("{Base Ruleset}:"));
        $this$_init__u24lambda_u242.add((Actor)this.baseRulesetSelectBox).fillX();
        mapEditorModsTab.add((Actor)table2).fillX().padBottom(10.0f).row();
        $this$_init__u24lambda_u242 = table2 = new Table();
        mapEditorModsTab = this;
        boolean bl2 = false;
        $this$_init__u24lambda_u243.add((Actor)this.applyButton).padRight(10.0f);
        $this$_init__u24lambda_u243.add((Actor)this.revertButton);
        mapEditorModsTab.add((Actor)table2).fillX().pad(10.0f).row();
        Cell<Actor> cell = this.add((Actor)this.modsTable);
        Intrinsics.checkNotNullExpressionValue(cell, "add(...)");
        this.modsTableCell = cell;
        this.row();
        ActivationExtensionsKt.onClick(this.applyButton, new Function0<Unit>((Object)this){

            @Override
            public final void invoke() {
                ((MapEditorModsTab)this.receiver).applyControls();
            }
        });
        UncivTooltip.Companion.addTooltip$default(UncivTooltip.Companion, this.applyButton, "Change the map to use the ruleset selected on this page", 21.0f, false, 4, 0, false, null, 116, null);
        ActivationExtensionsKt.onClick(this.revertButton, new Function0<Unit>((Object)this){

            @Override
            public final void invoke() {
                ((MapEditorModsTab)this.receiver).revertControls();
            }
        });
        UncivTooltip.Companion.addTooltip$default(UncivTooltip.Companion, this.revertButton, "Reset the controls to reflect the current map ruleset", 21.0f, false, 4, 0, false, null, 116, null);
    }

    private final void enableApplyButton() {
        MapParameters currentParameters = this.editorScreen.getTileMap().getMapParameters();
        boolean enabled = !Intrinsics.areEqual(currentParameters.getMods(), this.mods) || !Intrinsics.areEqual(currentParameters.getBaseRuleset(), ((TranslatedSelectBox.TranslatedString)this.baseRulesetSelectBox.getSelected()).getValue());
        Scene2dExtensionsKt.setEnabled(this.applyButton, enabled);
        Scene2dExtensionsKt.setEnabled(this.revertButton, enabled);
    }

    private final void revertControls() {
        MapParameters currentParameters = this.editorScreen.getTileMap().getMapParameters();
        this.baseRulesetSelectBox.setSelected(currentParameters.getBaseRuleset());
        this.mods.clear();
        this.mods.addAll((Collection<String>)currentParameters.getMods());
        this.modsTable = new ModCheckboxTable(this.mods, currentParameters.getBaseRuleset(), this.editorScreen, false, arg_0 -> MapEditorModsTab.revertControls$lambda$4(this, arg_0));
        this.modsTableCell.setActor((Actor)this.modsTable);
        this.enableApplyButton();
    }

    private final void applyControls() {
        Object object;
        Ruleset newRuleset = RulesetCache.INSTANCE.getComplexRuleset(this.mods, this.editorScreen.getNewMapParameters().getBaseRuleset());
        List<String> incompatibilities = this.getIncompatibilities(newRuleset);
        if (incompatibilities.isEmpty()) {
            this.editorScreen.applyRuleset(newRuleset, this.editorScreen.getNewMapParameters().getBaseRuleset(), this.mods);
            this.enableApplyButton();
            object = Unit.INSTANCE;
        } else {
            object = new AskFitMapToRulesetPopup((BaseScreen)this.editorScreen, incompatibilities, () -> MapEditorModsTab.applyControls$lambda$5(this, newRuleset));
        }
    }

    @Override
    public void activated(int index, @NotNull String caption, @NotNull TabbedPager pager) {
        Intrinsics.checkNotNullParameter(caption, "caption");
        Intrinsics.checkNotNullParameter(pager, "pager");
        this.enableApplyButton();
        if (!this.editorScreen.getModsTabNeedsRefresh()) {
            return;
        }
        this.editorScreen.setModsTabNeedsRefresh(false);
        this.revertControls();
    }

    private final List<String> getIncompatibilities(Ruleset newRuleset) {
        HashSet incompatibilities = new HashSet();
        for (Tile tile : this.editorScreen.getTileMap().getValues()) {
            CollectionsKt.addAll((Collection)incompatibilities, (Iterable)tile.getRulesetIncompatibility(newRuleset));
        }
        incompatibilities.remove("");
        return CollectionsKt.sorted(incompatibilities);
    }

    private final void fitMapToRuleset(Ruleset newRuleset) {
        for (Tile tile : this.editorScreen.getTileMap().getValues()) {
            TileNormalizer.INSTANCE.normalizeToRuleset(tile, newRuleset);
        }
    }

    @Override
    public void deactivated(int index, @NotNull String caption, @NotNull TabbedPager pager) {
        TabbedPager.IPageExtensions.super.deactivated(index, caption, pager);
    }

    @Override
    @Nullable
    public Actor getFixedContent() {
        return TabbedPager.IPageExtensions.super.getFixedContent();
    }

    private static final Unit _init_$lambda$0(String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1(MapEditorModsTab this$0, ChangeListener.ChangeEvent it) {
        String newBaseRuleset = ((TranslatedSelectBox.TranslatedString)this$0.baseRulesetSelectBox.getSelected()).getValue();
        this$0.editorScreen.getNewMapParameters().setBaseRuleset(newBaseRuleset);
        this$0.modsTable.setBaseRuleset(newBaseRuleset);
        this$0.modsTable.disableAllCheckboxes();
        this$0.enableApplyButton();
        return Unit.INSTANCE;
    }

    private static final Unit revertControls$lambda$4(MapEditorModsTab this$0, String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        this$0.enableApplyButton();
        return Unit.INSTANCE;
    }

    private static final Unit applyControls$lambda$5(MapEditorModsTab this$0, Ruleset $newRuleset) {
        this$0.fitMapToRuleset($newRuleset);
        this$0.editorScreen.applyRuleset($newRuleset, this$0.editorScreen.getNewMapParameters().getBaseRuleset(), this$0.mods);
        this$0.enableApplyButton();
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/unciv/ui/screens/mapeditorscreen/tabs/MapEditorModsTab$AskFitMapToRulesetPopup;", "Lcom/unciv/ui/popups/Popup;", "editorScreen", "Lcom/unciv/ui/screens/basescreen/BaseScreen;", "incompatibilities", "", "", "onOK", "Lkotlin/Function0;", "", "<init>", "(Lcom/unciv/ui/screens/basescreen/BaseScreen;Ljava/util/List;Lkotlin/jvm/functions/Function0;)V", "core"})
    private static final class AskFitMapToRulesetPopup
    extends Popup {
        public AskFitMapToRulesetPopup(@NotNull BaseScreen editorScreen, @NotNull List<String> incompatibilities, @NotNull Function0<Unit> onOK) {
            Table table2;
            Intrinsics.checkNotNullParameter(editorScreen, "editorScreen");
            Intrinsics.checkNotNullParameter(incompatibilities, "incompatibilities");
            Intrinsics.checkNotNullParameter(onOK, "onOK");
            super(editorScreen, null, 0.0f, 6, null);
            Table $this$_init__u24lambda_u240 = table2 = new Table();
            boolean bl = false;
            for (String inc : incompatibilities) {
                $this$_init__u24lambda_u240.add((Actor)Scene2dExtensionsKt.toLabel(inc)).row();
            }
            Table incompatibilityTable = table2;
            this.add((Actor)new ScrollPane((Actor)incompatibilityTable)).colspan(2).maxHeight(this.getStageToShowOn().getHeight() * 0.8f).row();
            Popup.addGoodSizedLabel$default(this, "Change map to fit selected ruleset?", 24, false, null, 12, null).colspan(2).row();
            Popup.addButton$default((Popup)this, "Yes", 'y', null, () -> AskFitMapToRulesetPopup._init_$lambda$1(onOK, this), 4, null);
            Popup.addButton$default((Popup)this, "No", 'n', null, () -> AskFitMapToRulesetPopup._init_$lambda$2(this), 4, null);
            this.equalizeLastTwoButtonWidths();
            this.open(true);
        }

        private static final Unit _init_$lambda$1(Function0 $onOK, AskFitMapToRulesetPopup this$0) {
            $onOK.invoke();
            this$0.close();
            return Unit.INSTANCE;
        }

        private static final Unit _init_$lambda$2(AskFitMapToRulesetPopup this$0) {
            this$0.close();
            return Unit.INSTANCE;
        }
    }
}

