/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.models.ruleset.tile;

import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.tile.TileResource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import yairm210.purity.annotations.InternalState;
import yairm210.purity.annotations.Readonly;

@InternalState
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0007\u0018\u0000 \"2\u0012\u0012\u0004\u0012\u00020\u00020\u0001j\b\u0012\u0004\u0012\u00020\u0002`\u0003:\u0002!\"B\u0011\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001a\u0010\b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\fH\u0007J\u0010\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0002H\u0016J \u0010\u0010\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\u0013\u001a\u00020\u000eJ\u000e\u0010\u0010\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0000J:\u0010\u0015\u001a\u00020\u00122\"\u0010\u0016\u001a\u001e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u000e0\u0017j\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u000e`\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\fJ\u0016\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\fJ\u000e\u0010\u001f\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\fJ\u000e\u0010 \u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/unciv/models/ruleset/tile/ResourceSupplyList;", "Ljava/util/ArrayList;", "Lcom/unciv/models/ruleset/tile/ResourceSupplyList$ResourceSupply;", "Lkotlin/collections/ArrayList;", "keepZeroAmounts", "", "<init>", "(Z)V", "get", "resource", "Lcom/unciv/models/ruleset/tile/TileResource;", "origin", "", "sumBy", "", "resourceName", "add", "element", "", "amount", "resourceSupplyList", "subtractResourceRequirements", "resourceRequirements", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "ruleset", "Lcom/unciv/models/ruleset/Ruleset;", "addByResource", "fromList", "newOrigin", "addPositiveByResource", "sumByResource", "removeAll", "ResourceSupply", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nResourceSupplyList.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResourceSupplyList.kt\ncom/unciv/models/ruleset/tile/ResourceSupplyList\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,110:1\n295#2,2:111\n774#2:114\n865#2,2:115\n1869#2,2:117\n1#3:113\n*S KotlinDebug\n*F\n+ 1 ResourceSupplyList.kt\ncom/unciv/models/ruleset/tile/ResourceSupplyList\n*L\n31#1:111,2\n102#1:114\n102#1:115,2\n102#1:117,2\n*E\n"})
public final class ResourceSupplyList
extends ArrayList<ResourceSupply> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean keepZeroAmounts;
    @NotNull
    private static final ResourceSupplyList emptyList = new ResourceSupplyList(false, 1, null);

    public ResourceSupplyList(boolean keepZeroAmounts) {
        super(24);
        this.keepZeroAmounts = keepZeroAmounts;
    }

    public /* synthetic */ ResourceSupplyList(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        this(bl);
    }

    @Readonly
    @Nullable
    public final ResourceSupply get(@NotNull TileResource resource, @NotNull String origin2) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter(resource, "resource");
            Intrinsics.checkNotNullParameter(origin2, "origin");
            Iterable $this$firstOrNull$iv = this;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ResourceSupply it = (ResourceSupply)element$iv;
                boolean bl = false;
                if (!(Intrinsics.areEqual(it.getResource().getName(), resource.getName()) && Intrinsics.areEqual(it.getOrigin(), origin2))) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    /*
     * WARNING - void declaration
     */
    @Readonly
    public final int sumBy(@NotNull String resourceName) {
        Intrinsics.checkNotNullParameter(resourceName, "resourceName");
        Sequence<ResourceSupply> sequence = SequencesKt.filter(CollectionsKt.asSequence(this), arg_0 -> ResourceSupplyList.sumBy$lambda$1(resourceName, arg_0));
        int n = 0;
        Iterator<ResourceSupply> iterator2 = sequence.iterator();
        while (iterator2.hasNext()) {
            void it;
            ResourceSupply resourceSupply;
            ResourceSupply resourceSupply2 = resourceSupply = iterator2.next();
            int n2 = n;
            boolean bl = false;
            int n3 = it.getAmount();
            n = n2 + n3;
        }
        return n;
    }

    @Override
    public boolean add(@NotNull ResourceSupply element) {
        boolean bl;
        Intrinsics.checkNotNullParameter(element, "element");
        ResourceSupply existingResourceSupply = this.get(element.getResource(), element.getOrigin());
        if (existingResourceSupply != null) {
            existingResourceSupply.setAmount(existingResourceSupply.getAmount() + element.getAmount());
            if (this.keepZeroAmounts || existingResourceSupply.getAmount() != 0) {
                return false;
            }
            bl = this.remove((Object)existingResourceSupply);
        } else {
            if (!this.keepZeroAmounts && element.getAmount() == 0) {
                return false;
            }
            bl = super.add(element);
        }
        return true;
    }

    public final void add(@NotNull TileResource resource, @NotNull String origin2, int amount) {
        Intrinsics.checkNotNullParameter(resource, "resource");
        Intrinsics.checkNotNullParameter(origin2, "origin");
        this.add(new ResourceSupply(resource, origin2, amount));
    }

    public static /* synthetic */ void add$default(ResourceSupplyList resourceSupplyList, TileResource tileResource, String string, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 1;
        }
        resourceSupplyList.add(tileResource, string, n);
    }

    public final void add(@NotNull ResourceSupplyList resourceSupplyList) {
        Intrinsics.checkNotNullParameter(resourceSupplyList, "resourceSupplyList");
        Iterator iterator2 = resourceSupplyList.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator iterator3 = iterator2;
        while (iterator3.hasNext()) {
            Object e = iterator3.next();
            Intrinsics.checkNotNullExpressionValue(e, "next(...)");
            ResourceSupply resourceSupply = (ResourceSupply)e;
            this.add(resourceSupply);
        }
    }

    public final void subtractResourceRequirements(@NotNull HashMap<String, Integer> resourceRequirements, @NotNull Ruleset ruleset, @NotNull String origin2) {
        Intrinsics.checkNotNullParameter(resourceRequirements, "resourceRequirements");
        Intrinsics.checkNotNullParameter(ruleset, "ruleset");
        Intrinsics.checkNotNullParameter(origin2, "origin");
        for (Map.Entry entry : ((Map)resourceRequirements).entrySet()) {
            TileResource resource;
            String resourceName = (String)entry.getKey();
            int amount = ((Number)entry.getValue()).intValue();
            if (ruleset.getTileResources().get(resourceName) == null) continue;
            this.add(resource, origin2, -amount);
        }
    }

    @NotNull
    public final ResourceSupplyList addByResource(@NotNull ResourceSupplyList fromList, @NotNull String newOrigin) {
        Intrinsics.checkNotNullParameter(fromList, "fromList");
        Intrinsics.checkNotNullParameter(newOrigin, "newOrigin");
        Iterator iterator2 = fromList.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator iterator3 = iterator2;
        while (iterator3.hasNext()) {
            Object e = iterator3.next();
            Intrinsics.checkNotNullExpressionValue(e, "next(...)");
            ResourceSupply resourceSupply = (ResourceSupply)e;
            this.add(resourceSupply.getResource(), newOrigin, resourceSupply.getAmount());
        }
        return this;
    }

    public final void addPositiveByResource(@NotNull ResourceSupplyList fromList, @NotNull String newOrigin) {
        Intrinsics.checkNotNullParameter(fromList, "fromList");
        Intrinsics.checkNotNullParameter(newOrigin, "newOrigin");
        Iterator iterator2 = fromList.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator iterator3 = iterator2;
        while (iterator3.hasNext()) {
            Object e = iterator3.next();
            Intrinsics.checkNotNullExpressionValue(e, "next(...)");
            ResourceSupply resourceSupply = (ResourceSupply)e;
            if (resourceSupply.getAmount() <= 0) continue;
            this.add(resourceSupply.getResource(), newOrigin, resourceSupply.getAmount());
        }
    }

    @NotNull
    public final ResourceSupplyList sumByResource(@NotNull String newOrigin) {
        Intrinsics.checkNotNullParameter(newOrigin, "newOrigin");
        return new ResourceSupplyList(this.keepZeroAmounts).addByResource(this, newOrigin);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ResourceSupplyList removeAll(@NotNull String origin2) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(origin2, "origin");
        Iterable $this$filter$iv = this;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ResourceSupply it = (ResourceSupply)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual(it.getOrigin(), origin2)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ResourceSupply it = (ResourceSupply)element$iv;
            boolean bl = false;
            this.remove((Object)it);
        }
        return this;
    }

    private static final boolean sumBy$lambda$1(String $resourceName, ResourceSupply it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return Intrinsics.areEqual(it.getResource().getName(), $resourceName);
    }

    public ResourceSupplyList() {
        this(false, 1, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/unciv/models/ruleset/tile/ResourceSupplyList$Companion;", "", "<init>", "()V", "emptyList", "Lcom/unciv/models/ruleset/tile/ResourceSupplyList;", "getEmptyList", "()Lcom/unciv/models/ruleset/tile/ResourceSupplyList;", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ResourceSupplyList getEmptyList() {
            return emptyList;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\t\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0012\u001a\u00020\u0013H\u0007J\b\u0010\u0014\u001a\u00020\u0005H\u0016J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u00132\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u0007H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001c"}, d2={"Lcom/unciv/models/ruleset/tile/ResourceSupplyList$ResourceSupply;", "", "resource", "Lcom/unciv/models/ruleset/tile/TileResource;", "origin", "", "amount", "", "<init>", "(Lcom/unciv/models/ruleset/tile/TileResource;Ljava/lang/String;I)V", "getResource", "()Lcom/unciv/models/ruleset/tile/TileResource;", "getOrigin", "()Ljava/lang/String;", "getAmount", "()I", "setAmount", "(I)V", "isCityStateOrTradeOrigin", "", "toString", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "core"})
    public static final class ResourceSupply {
        @NotNull
        private final TileResource resource;
        @NotNull
        private final String origin;
        private int amount;

        public ResourceSupply(@NotNull TileResource resource, @NotNull String origin2, int amount) {
            Intrinsics.checkNotNullParameter(resource, "resource");
            Intrinsics.checkNotNullParameter(origin2, "origin");
            this.resource = resource;
            this.origin = origin2;
            this.amount = amount;
        }

        @NotNull
        public final TileResource getResource() {
            return this.resource;
        }

        @NotNull
        public final String getOrigin() {
            return this.origin;
        }

        public final int getAmount() {
            return this.amount;
        }

        public final void setAmount(int n) {
            this.amount = n;
        }

        @Readonly
        public final boolean isCityStateOrTradeOrigin() {
            return (Intrinsics.areEqual(this.origin, "City-States") || Intrinsics.areEqual(this.origin, "Trade")) && this.amount > 0;
        }

        @NotNull
        public String toString() {
            return "" + this.amount + ' ' + this.resource.getName() + " from " + this.origin;
        }

        @NotNull
        public final TileResource component1() {
            return this.resource;
        }

        @NotNull
        public final String component2() {
            return this.origin;
        }

        public final int component3() {
            return this.amount;
        }

        @NotNull
        public final ResourceSupply copy(@NotNull TileResource resource, @NotNull String origin2, int amount) {
            Intrinsics.checkNotNullParameter(resource, "resource");
            Intrinsics.checkNotNullParameter(origin2, "origin");
            return new ResourceSupply(resource, origin2, amount);
        }

        public static /* synthetic */ ResourceSupply copy$default(ResourceSupply resourceSupply, TileResource tileResource, String string, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                tileResource = resourceSupply.resource;
            }
            if ((n2 & 2) != 0) {
                string = resourceSupply.origin;
            }
            if ((n2 & 4) != 0) {
                n = resourceSupply.amount;
            }
            return resourceSupply.copy(tileResource, string, n);
        }

        public int hashCode() {
            int result2 = this.resource.hashCode();
            result2 = result2 * 31 + this.origin.hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.amount);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ResourceSupply)) {
                return false;
            }
            ResourceSupply resourceSupply = (ResourceSupply)other;
            if (!Intrinsics.areEqual(this.resource, resourceSupply.resource)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.origin, resourceSupply.origin)) {
                return false;
            }
            return this.amount == resourceSupply.amount;
        }
    }
}

