/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.civilization.diplomacy;

import com.badlogic.gdx.math.Vector2;
import com.unciv.UncivGame;
import com.unciv.logic.GameInfo;
import com.unciv.logic.IsPartOfGameInfoSerialization;
import com.unciv.logic.city.City;
import com.unciv.logic.civilization.AlertType;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.Notification;
import com.unciv.logic.civilization.PopupAlert;
import com.unciv.logic.civilization.diplomacy.DiplomacyFlags;
import com.unciv.logic.civilization.diplomacy.DiplomacyManager;
import com.unciv.logic.civilization.diplomacy.DiplomaticModifiers;
import com.unciv.logic.civilization.diplomacy.DiplomaticStatus;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.stats.Stat;
import com.unciv.models.stats.Stats;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import yairm210.purity.annotations.Readonly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\t2\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\u000bJ\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00032\b\b\u0002\u0010\u0010\u001a\u00020\u000bJ\u001a\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00032\b\b\u0002\u0010\u0010\u001a\u00020\u000bH\u0002J\u0010\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0003H\u0007J\u0010\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0003J\b\u0010\u0016\u001a\u00020\u000bH\u0003J\u0010\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0003H\u0007J\u0010\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0003H\u0007J\u0010\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0003H\u0007J\u000e\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0003J\u0010\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0003H\u0007J\b\u0010\u001c\u001a\u00020\u000bH\u0007J\u0010\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0003H\u0007J\u0010\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0003H\u0007J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u000f\u001a\u00020\u0003H\u0007J\b\u0010!\u001a\u00020\u000bH\u0007J\u0010\u0010\"\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0003H\u0007J\u0010\u0010#\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0003H\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006$"}, d2={"Lcom/unciv/logic/civilization/diplomacy/DiplomacyFunctions;", "", "civInfo", "Lcom/unciv/logic/civilization/Civilization;", "<init>", "(Lcom/unciv/logic/civilization/Civilization;)V", "getCivInfo", "()Lcom/unciv/logic/civilization/Civilization;", "getKnownCivsSorted", "Lkotlin/sequences/Sequence;", "includeCityStates", "", "includeDefeated", "makeCivilizationsMeet", "", "otherCiv", "warOnContact", "meetCiv", "isAtWarWith", "isDenouncedThisTurn", "diploManager", "Lcom/unciv/logic/civilization/diplomacy/DiplomacyManager;", "canTradeEmbassies", "canOfferEmbassyTo", "canEstablishEmbassyWith", "hasMutualEmbassyWith", "removeEmbassies", "canSignDeclarationOfFriendshipWith", "canSignResearchAgreement", "canSignResearchAgreementNoCostWith", "canSignResearchAgreementWith", "getResearchAgreementCost", "", "canSignDefensivePact", "canSignDefensivePactWith", "canPassThroughTiles", "core"})
@SourceDebugExtension(value={"SMAP\nDiplomacyFunctions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiplomacyFunctions.kt\ncom/unciv/logic/civilization/diplomacy/DiplomacyFunctions\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,248:1\n1#2:249\n205#3,4:250\n*S KotlinDebug\n*F\n+ 1 DiplomacyFunctions.kt\ncom/unciv/logic/civilization/diplomacy/DiplomacyFunctions\n*L\n53#1:250,4\n*E\n"})
public final class DiplomacyFunctions {
    @NotNull
    private final Civilization civInfo;

    public DiplomacyFunctions(@NotNull Civilization civInfo) {
        Intrinsics.checkNotNullParameter(civInfo, "civInfo");
        this.civInfo = civInfo;
    }

    @NotNull
    public final Civilization getCivInfo() {
        return this.civInfo;
    }

    @NotNull
    public final Sequence<Civilization> getKnownCivsSorted(boolean includeCityStates, boolean includeDefeated) {
        return GameInfo.getCivsSorted$default(this.civInfo.getGameInfo(), includeCityStates, includeDefeated, null, arg_0 -> DiplomacyFunctions.getKnownCivsSorted$lambda$0(this, arg_0), 4, null);
    }

    public static /* synthetic */ Sequence getKnownCivsSorted$default(DiplomacyFunctions diplomacyFunctions, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        if ((n & 2) != 0) {
            bl2 = false;
        }
        return diplomacyFunctions.getKnownCivsSorted(bl, bl2);
    }

    public final void makeCivilizationsMeet(@NotNull Civilization otherCiv, boolean warOnContact) {
        Intrinsics.checkNotNullParameter(otherCiv, "otherCiv");
        this.meetCiv(otherCiv, warOnContact);
        otherCiv.getDiplomacyFunctions().meetCiv(this.civInfo, warOnContact);
    }

    public static /* synthetic */ void makeCivilizationsMeet$default(DiplomacyFunctions diplomacyFunctions, Civilization civilization, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        diplomacyFunctions.makeCivilizationsMeet(civilization, bl);
    }

    private final void meetCiv(Civilization otherCiv, boolean warOnContact) {
        DiplomacyManager diplomacyManager;
        Map map2 = this.civInfo.getDiplomacy();
        String string = otherCiv.getCivName();
        DiplomacyManager $this$meetCiv_u24lambda_u241 = diplomacyManager = new DiplomacyManager(this.civInfo, otherCiv.getCivName());
        boolean bl = false;
        $this$meetCiv_u24lambda_u241.setDiplomaticStatus(DiplomaticStatus.Peace);
        map2.put(string, diplomacyManager);
        if (!otherCiv.isSpectator()) {
            otherCiv.getPopupAlerts().add(new PopupAlert(AlertType.FirstContact, this.civInfo.getCivName()));
        }
        if (this.civInfo.isCurrentPlayer()) {
            UncivGame.Companion.getCurrent().getSettings().addCompletedTutorialTask("Meet another civilization");
        }
        if (this.civInfo.isCityState() && otherCiv.isMajorCiv()) {
            IsPartOfGameInfoSerialization isPartOfGameInfoSerialization;
            Object object;
            int n;
            Vector2 vector2;
            if (warOnContact || otherCiv.isMinorCivAggressor()) {
                return;
            }
            if (this.civInfo.getCities().isEmpty()) {
                vector2 = null;
            } else {
                City city = Civilization.getCapital$default(this.civInfo, false, 1, null);
                Intrinsics.checkNotNull(city);
                vector2 = city.getLocation();
            }
            Vector2 cityStateLocation = vector2;
            Stats giftAmount = new Stats(0.0f, 0.0f, 15.0f, 0.0f, 0.0f, 0.0f, 0.0f, 123, null);
            Stats faithAmount = new Stats(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 4.0f, 63, null);
            String meetString = '[' + this.civInfo.getCivName() + "] has given us [" + giftAmount.toStringForNotifications() + "] as a token of goodwill for meeting us";
            String religionMeetString = '[' + this.civInfo.getCivName() + "] has also given us [" + faithAmount.toStringForNotifications() + ']';
            Map $this$count$iv = this.civInfo.getDiplomacy();
            boolean $i$f$count = false;
            if ($this$count$iv.isEmpty()) {
                n = 0;
            } else {
                int count$iv = 0;
                Iterator iterator2 = $this$count$iv.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry element$iv;
                    Map.Entry it = element$iv = iterator2.next();
                    boolean bl2 = false;
                    if (!((DiplomacyManager)it.getValue()).otherCiv().isMajorCiv()) continue;
                    ++count$iv;
                }
                n = count$iv;
            }
            if (n == 1) {
                giftAmount.timesInPlace(2.0f);
                meetString = '[' + this.civInfo.getCivName() + "] has given us [" + giftAmount.toStringForNotifications() + "] as we are the first major civ to meet them";
            }
            if (cityStateLocation != null) {
                object = new String[]{"StatIcons/Gold"};
                otherCiv.addNotification(meetString, cityStateLocation, Notification.NotificationCategory.Diplomacy, (String[])object);
            } else {
                object = new String[]{"StatIcons/Gold"};
                otherCiv.addNotification(meetString, Notification.NotificationCategory.Diplomacy, (String[])object);
            }
            if (this.civInfo.getCityStateFunctions().canProvideStat(Stat.Faith)) {
                object = new String[]{"StatIcons/Faith"};
                otherCiv.addNotification(religionMeetString, Notification.NotificationCategory.Diplomacy, (String[])object);
                for (Stats.StatValuePair statValuePair : faithAmount) {
                    Stat key = statValuePair.component1();
                    float value = statValuePair.component2();
                    otherCiv.addStat(key, (int)value);
                }
            }
            for (Stats.StatValuePair statValuePair : giftAmount) {
                Stat key = statValuePair.component1();
                float value = statValuePair.component2();
                otherCiv.addStat(key, (int)value);
            }
            if (!((Collection)this.civInfo.getCities()).isEmpty() && (isPartOfGameInfoSerialization = Civilization.getCapital$default(this.civInfo, false, 1, null)) != null && (isPartOfGameInfoSerialization = isPartOfGameInfoSerialization.getCenterTile()) != null) {
                Tile.setExplored$default((Tile)isPartOfGameInfoSerialization, otherCiv, true, null, 4, null);
            }
            this.civInfo.getQuestManager().justMet(otherCiv);
        }
    }

    static /* synthetic */ void meetCiv$default(DiplomacyFunctions diplomacyFunctions, Civilization civilization, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        diplomacyFunctions.meetCiv(civilization, bl);
    }

    @Readonly
    public final boolean isAtWarWith(@NotNull Civilization otherCiv) {
        boolean bl;
        Intrinsics.checkNotNullParameter(otherCiv, "otherCiv");
        if (Intrinsics.areEqual(otherCiv, this.civInfo)) {
            bl = false;
        } else if (otherCiv.isBarbarian() || this.civInfo.isBarbarian()) {
            bl = true;
        } else {
            DiplomacyManager diplomacyManager = this.civInfo.getDiplomacy().get(otherCiv.getCivName());
            if (diplomacyManager == null) {
                return false;
            }
            DiplomacyManager diplomacyManager2 = diplomacyManager;
            return diplomacyManager2.getDiplomaticStatus() == DiplomaticStatus.War;
        }
        return bl;
    }

    @Readonly
    private final boolean isDenouncedThisTurn(DiplomacyManager diploManager) {
        return diploManager.getFlag(DiplomacyFlags.Denunciation) == 30 || diploManager.otherCivDiplomacy().getFlag(DiplomacyFlags.Denunciation) == 30;
    }

    @Readonly
    private final boolean canTradeEmbassies() {
        return this.civInfo.isMajorCiv() && Civilization.hasUnique$default(this.civInfo, UniqueType.EnablesEmbassies, null, 2, null) && Civilization.hasUnique$default(this.civInfo, UniqueType.RequiresEmbassiesForDiplomacy, null, 2, null);
    }

    @Readonly
    public final boolean canOfferEmbassyTo(@NotNull Civilization otherCiv) {
        Intrinsics.checkNotNullParameter(otherCiv, "otherCiv");
        if (!this.canTradeEmbassies() || !otherCiv.isMajorCiv() || Civilization.getCapital$default(this.civInfo, false, 1, null) == null) {
            return false;
        }
        DiplomacyManager diplomacyManager = otherCiv.getDiplomacyManager(this.civInfo);
        Intrinsics.checkNotNull(diplomacyManager);
        DiplomacyManager theirDiploManager = diplomacyManager;
        return !this.civInfo.isAtWarWith(otherCiv) && !this.isDenouncedThisTurn(theirDiploManager) && !theirDiploManager.hasModifier(DiplomaticModifiers.EstablishedEmbassy) && !theirDiploManager.hasModifier(DiplomaticModifiers.SharedEmbassies);
    }

    @Readonly
    public final boolean canEstablishEmbassyWith(@NotNull Civilization otherCiv) {
        Intrinsics.checkNotNullParameter(otherCiv, "otherCiv");
        if (!this.canTradeEmbassies() || !otherCiv.isMajorCiv() || Civilization.getCapital$default(otherCiv, false, 1, null) == null) {
            return false;
        }
        DiplomacyManager diplomacyManager = this.civInfo.getDiplomacyManager(otherCiv);
        Intrinsics.checkNotNull(diplomacyManager);
        DiplomacyManager ourDiploManager = diplomacyManager;
        return !this.civInfo.isAtWarWith(otherCiv) && !this.isDenouncedThisTurn(ourDiploManager) && !ourDiploManager.hasModifier(DiplomaticModifiers.EstablishedEmbassy) && !ourDiploManager.hasModifier(DiplomaticModifiers.SharedEmbassies);
    }

    @Readonly
    public final boolean hasMutualEmbassyWith(@NotNull Civilization otherCiv) {
        boolean bl;
        Intrinsics.checkNotNullParameter(otherCiv, "otherCiv");
        if (Civilization.hasUnique$default(this.civInfo, UniqueType.EnablesEmbassies, null, 2, null) && Civilization.hasUnique$default(this.civInfo, UniqueType.RequiresEmbassiesForDiplomacy, null, 2, null)) {
            DiplomacyManager diplomacyManager = this.civInfo.getDiplomacyManager(otherCiv);
            Intrinsics.checkNotNull(diplomacyManager);
            bl = diplomacyManager.hasModifier(DiplomaticModifiers.SharedEmbassies);
        } else {
            bl = true;
        }
        return bl;
    }

    public final void removeEmbassies(@NotNull Civilization otherCiv) {
        Intrinsics.checkNotNullParameter(otherCiv, "otherCiv");
        DiplomacyManager diplomacyManager = this.civInfo.getDiplomacyManager(otherCiv);
        Intrinsics.checkNotNull(diplomacyManager);
        DiplomacyManager ourDiploManager = diplomacyManager;
        ourDiploManager.removeModifier$core(DiplomaticModifiers.EstablishedEmbassy);
        ourDiploManager.removeModifier$core(DiplomaticModifiers.ReceivedEmbassy);
        ourDiploManager.removeModifier$core(DiplomaticModifiers.SharedEmbassies);
        DiplomacyManager theirDiploManager = ourDiploManager.otherCivDiplomacy();
        theirDiploManager.removeModifier$core(DiplomaticModifiers.EstablishedEmbassy);
        theirDiploManager.removeModifier$core(DiplomaticModifiers.ReceivedEmbassy);
        theirDiploManager.removeModifier$core(DiplomaticModifiers.SharedEmbassies);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Readonly
    public final boolean canSignDeclarationOfFriendshipWith(@NotNull Civilization otherCiv) {
        Intrinsics.checkNotNullParameter(otherCiv, "otherCiv");
        if (!otherCiv.isMajorCiv()) return false;
        if (otherCiv.isAtWarWith(this.civInfo)) return false;
        DiplomacyManager diplomacyManager = this.civInfo.getDiplomacyManager(otherCiv);
        Intrinsics.checkNotNull(diplomacyManager);
        if (diplomacyManager.hasFlag(DiplomacyFlags.Denunciation)) return false;
        DiplomacyManager diplomacyManager2 = this.civInfo.getDiplomacyManager(otherCiv);
        Intrinsics.checkNotNull(diplomacyManager2);
        if (diplomacyManager2.hasFlag(DiplomacyFlags.DeclarationOfFriendship)) return false;
        return true;
    }

    @Readonly
    public final boolean canSignResearchAgreement() {
        if (!this.civInfo.isMajorCiv()) {
            return false;
        }
        if (!Civilization.hasUnique$default(this.civInfo, UniqueType.EnablesResearchAgreements, null, 2, null)) {
            return false;
        }
        return !this.civInfo.getTech().allTechsAreResearched();
    }

    @Readonly
    public final boolean canSignResearchAgreementNoCostWith(@NotNull Civilization otherCiv) {
        Intrinsics.checkNotNullParameter(otherCiv, "otherCiv");
        DiplomacyManager diplomacyManager = this.civInfo.getDiplomacyManager(otherCiv);
        Intrinsics.checkNotNull(diplomacyManager);
        DiplomacyManager ourDiploManager = diplomacyManager;
        return this.canSignResearchAgreement() && otherCiv.getDiplomacyFunctions().canSignResearchAgreement() && this.hasMutualEmbassyWith(otherCiv) && ourDiploManager.hasFlag(DiplomacyFlags.DeclarationOfFriendship) && !ourDiploManager.hasFlag(DiplomacyFlags.ResearchAgreement) && !ourDiploManager.otherCivDiplomacy().hasFlag(DiplomacyFlags.ResearchAgreement);
    }

    @Readonly
    public final boolean canSignResearchAgreementWith(@NotNull Civilization otherCiv) {
        Intrinsics.checkNotNullParameter(otherCiv, "otherCiv");
        int cost = this.getResearchAgreementCost(otherCiv);
        return this.canSignResearchAgreementNoCostWith(otherCiv) && this.civInfo.getGold() >= cost && otherCiv.getGold() >= cost;
    }

    @Readonly
    public final int getResearchAgreementCost(@NotNull Civilization otherCiv) {
        Intrinsics.checkNotNullParameter(otherCiv, "otherCiv");
        return (int)((float)Math.max(this.civInfo.getEra().getResearchAgreementCost(), otherCiv.getEra().getResearchAgreementCost()) * this.civInfo.getGameInfo().getSpeed().getGoldCostModifier());
    }

    @Readonly
    public final boolean canSignDefensivePact() {
        if (!this.civInfo.isMajorCiv()) {
            return false;
        }
        return Civilization.hasUnique$default(this.civInfo, UniqueType.EnablesDefensivePacts, null, 2, null);
    }

    @Readonly
    public final boolean canSignDefensivePactWith(@NotNull Civilization otherCiv) {
        Intrinsics.checkNotNullParameter(otherCiv, "otherCiv");
        DiplomacyManager diplomacyManager = this.civInfo.getDiplomacyManager(otherCiv);
        Intrinsics.checkNotNull(diplomacyManager);
        DiplomacyManager ourDiplomacyManager = diplomacyManager;
        return this.canSignDefensivePact() && otherCiv.getDiplomacyFunctions().canSignDefensivePact() && this.hasMutualEmbassyWith(otherCiv) && ourDiplomacyManager.hasFlag(DiplomacyFlags.DeclarationOfFriendship) && !ourDiplomacyManager.hasFlag(DiplomacyFlags.DefensivePact) && !ourDiplomacyManager.otherCivDiplomacy().hasFlag(DiplomacyFlags.DefensivePact) && ourDiplomacyManager.getDiplomaticStatus() != DiplomaticStatus.DefensivePact;
    }

    @Readonly
    public final boolean canPassThroughTiles(@NotNull Civilization otherCiv) {
        Intrinsics.checkNotNullParameter(otherCiv, "otherCiv");
        if (Intrinsics.areEqual(otherCiv, this.civInfo)) {
            return true;
        }
        if (otherCiv.isBarbarian()) {
            return true;
        }
        if (this.civInfo.isBarbarian() && this.civInfo.getGameInfo().getTurns() >= this.civInfo.getGameInfo().getDifficulty().getTurnBarbariansCanEnterPlayerTiles()) {
            return true;
        }
        DiplomacyManager diplomacyManager = this.civInfo.getDiplomacy().get(otherCiv.getCivName());
        if (diplomacyManager != null && (diplomacyManager.getHasOpenBorders() || diplomacyManager.getDiplomaticStatus() == DiplomaticStatus.War)) {
            return true;
        }
        return !this.civInfo.isAIOrAutoPlaying() && otherCiv.isCityState();
    }

    private static final boolean getKnownCivsSorted$lambda$0(DiplomacyFunctions this$0, Civilization it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return !Intrinsics.areEqual(it, this$0.civInfo) && this$0.civInfo.knows(it);
    }
}

