/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.city.managers;

import com.badlogic.gdx.math.Vector2;
import com.unciv.logic.IsPartOfGameInfoSerialization;
import com.unciv.logic.automation.Automation;
import com.unciv.logic.city.City;
import com.unciv.logic.city.CityStats;
import com.unciv.logic.civilization.Notification;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.Counter;
import com.unciv.models.ruleset.Building;
import com.unciv.models.ruleset.unique.LocalUniqueCache;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.stats.Stats;
import com.unciv.ui.components.extensions.FormattingExtensionsKt;
import com.unciv.utils.CollectionExtensionsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import yairm210.purity.annotations.Readonly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014J\u0006\u0010\u0019\u001a\u00020\u0000J\b\u0010\u001a\u001a\u00020\u000bH\u0007J\b\u0010\u001b\u001a\u00020\u000bH\u0007J\b\u0010\u001c\u001a\u00020\u000bH\u0007J\u000f\u0010\u001d\u001a\u0004\u0018\u00010\u000bH\u0007\u00a2\u0006\u0002\u0010\u001eJ\u000f\u0010\u001f\u001a\u0004\u0018\u00010\u000bH\u0007\u00a2\u0006\u0002\u0010\u001eJ\u0010\u0010 \u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\u0015H\u0007J\u000e\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u000bJ\u000e\u0010%\u001a\u00020#2\u0006\u0010&\u001a\u00020\u000bJ\u000e\u0010'\u001a\u00020#2\u0006\u0010&\u001a\u00020\u000bJ\r\u0010(\u001a\u00020#H\u0000\u00a2\u0006\u0002\b)J\u000e\u0010*\u001a\u00020#2\u0006\u0010+\u001a\u00020,J\u0006\u0010-\u001a\u00020#J\u000e\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0007R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001e\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u000e\"\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006/"}, d2={"Lcom/unciv/logic/city/managers/CityPopulationManager;", "Lcom/unciv/logic/IsPartOfGameInfoSerialization;", "<init>", "()V", "city", "Lcom/unciv/logic/city/City;", "getCity", "()Lcom/unciv/logic/city/City;", "setCity", "(Lcom/unciv/logic/city/City;)V", "value", "", "population", "getPopulation", "()I", "foodStored", "getFoodStored", "setFoodStored", "(I)V", "specialistAllocations", "Lcom/unciv/models/Counter;", "", "getSpecialistAllocations", "()Lcom/unciv/models/Counter;", "getNewSpecialists", "clone", "getNumberOfSpecialists", "getFreePopulation", "getFoodToNextPopulation", "getNumTurnsToStarvation", "()Ljava/lang/Integer;", "getNumTurnsToNewPopulation", "getPopulationFilterAmount", "filter", "nextTurn", "", "food", "addPopulation", "count", "setPopulation", "autoAssignPopulation", "autoAssignPopulation$core", "stopWorkingTile", "position", "Lcom/badlogic/gdx/math/Vector2;", "unassignExtraPopulation", "getMaxSpecialists", "core"})
@SourceDebugExtension(value={"SMAP\nCityPopulationManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CityPopulationManager.kt\ncom/unciv/logic/city/managers/CityPopulationManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,290:1\n1#2:291\n767#3,2:292\n783#3,4:294\n767#3,2:298\n783#3,4:300\n767#3,2:304\n783#3,4:306\n1923#3,14:314\n1563#4:310\n1634#4,3:311\n2423#4,14:328\n2423#4,14:342\n*S KotlinDebug\n*F\n+ 1 CityPopulationManager.kt\ncom/unciv/logic/city/managers/CityPopulationManager\n*L\n177#1:292,2\n177#1:294,4\n185#1:298,2\n185#1:300,4\n197#1:304,2\n197#1:306,4\n241#1:314,14\n222#1:310\n222#1:311,3\n251#1:328,14\n273#1:342,14\n*E\n"})
public final class CityPopulationManager
implements IsPartOfGameInfoSerialization {
    public transient City city;
    private int population = 1;
    private int foodStored;
    @NotNull
    private final Counter<String> specialistAllocations = new Counter(null, 1, null);

    @NotNull
    public final City getCity() {
        City city = this.city;
        if (city != null) {
            return city;
        }
        Intrinsics.throwUninitializedPropertyAccessException("city");
        return null;
    }

    public final void setCity(@NotNull City city) {
        Intrinsics.checkNotNullParameter(city, "<set-?>");
        this.city = city;
    }

    public final int getPopulation() {
        return this.population;
    }

    public final int getFoodStored() {
        return this.foodStored;
    }

    public final void setFoodStored(int n) {
        this.foodStored = n;
    }

    @NotNull
    public final Counter<String> getSpecialistAllocations() {
        return this.specialistAllocations;
    }

    @NotNull
    public final Counter<String> getNewSpecialists() {
        return this.specialistAllocations;
    }

    @NotNull
    public final CityPopulationManager clone() {
        CityPopulationManager toReturn = new CityPopulationManager();
        toReturn.specialistAllocations.add(this.specialistAllocations);
        toReturn.population = this.population;
        toReturn.foodStored = this.foodStored;
        return toReturn;
    }

    @Readonly
    public final int getNumberOfSpecialists() {
        Collection<Integer> collection = this.getNewSpecialists().values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        return CollectionsKt.sumOfInt((Iterable<Integer>)collection);
    }

    @Readonly
    public final int getFreePopulation() {
        int workingPopulation = this.getCity().getWorkedTiles().size();
        return this.population - workingPopulation - this.getNumberOfSpecialists();
    }

    @Readonly
    public final int getFoodToNextPopulation() {
        double foodRequired = (double)(15 + 8 * (this.population - 1)) + Math.floor(Math.pow(this.population - 1, 1.5));
        foodRequired *= (double)this.getCity().getCiv().getGameInfo().getSpeed().getModifier();
        if (this.getCity().getCiv().isCityState()) {
            foodRequired *= (double)1.5f;
        }
        if (!this.getCity().getCiv().isHuman()) {
            foodRequired *= (double)this.getCity().getCiv().getGameInfo().getDifficulty().getAiCityGrowthModifier();
        }
        return (int)foodRequired;
    }

    @Readonly
    @Nullable
    public final Integer getNumTurnsToStarvation() {
        if (!this.getCity().isStarving()) {
            return null;
        }
        return this.foodStored / -this.getCity().foodForNextTurn() + 1;
    }

    @Readonly
    @Nullable
    public final Integer getNumTurnsToNewPopulation() {
        if (!this.getCity().isGrowing()) {
            return null;
        }
        float roundedFoodPerTurn = this.getCity().foodForNextTurn();
        int remainingFood = this.getFoodToNextPopulation() - this.foodStored;
        int turnsToGrowth = (int)Math.ceil((float)remainingFood / roundedFoodPerTurn);
        if (turnsToGrowth < 1) {
            turnsToGrowth = 1;
        }
        return turnsToGrowth;
    }

    @Readonly
    public final int getPopulationFilterAmount(@NotNull String filter2) {
        int n;
        Intrinsics.checkNotNullParameter(filter2, "filter");
        switch (filter2) {
            case "Specialists": {
                n = this.getNumberOfSpecialists();
                break;
            }
            case "Population": {
                n = this.population;
                break;
            }
            case "Followers of this Religion": 
            case "Followers of the Majority Religion": {
                n = this.getCity().getReligion().getFollowersOfMajorityReligion();
                break;
            }
            case "Unemployed": {
                n = this.getFreePopulation();
                break;
            }
            default: {
                n = ((Number)this.specialistAllocations.get(filter2)).intValue();
            }
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public final void nextTurn(int food) {
        int foodNeededToGrow;
        this.foodStored += food;
        if (food < 0) {
            String[] stringArray = new String[]{"StatIcons/Population", "OtherIcons/DisbandUnit"};
            this.getCity().getCiv().addNotification('[' + this.getCity().getName() + "] is starving!", this.getCity().getLocation(), Notification.NotificationCategory.Cities, stringArray);
        }
        if (this.foodStored < 0) {
            if (this.population > 1) {
                this.addPopulation(-1);
            }
            this.foodStored = 0;
        }
        if (this.foodStored < (foodNeededToGrow = this.getFoodToNextPopulation())) {
            return;
        }
        if (SequencesKt.any(City.getMatchingUniques$default(this.getCity(), UniqueType.NullifiesGrowth, null, false, 6, null))) {
            return;
        }
        if (this.getCity().getAvoidGrowth()) {
            this.foodStored = foodNeededToGrow;
            return;
        }
        this.foodStored -= foodNeededToGrow;
        String[] stringArray = SequencesKt.filter(City.getMatchingUniques$default(this.getCity(), UniqueType.CarryOverFood, null, false, 6, null), arg_0 -> CityPopulationManager.nextTurn$lambda$0(this, arg_0));
        int n = 0;
        Iterator<Unique> iterator2 = stringArray.iterator();
        while (iterator2.hasNext()) {
            void it;
            Unique unique;
            Unique unique2 = unique = iterator2.next();
            int n2 = n;
            boolean bl = false;
            int n3 = Integer.parseInt(it.getParams().get(0));
            n = n2 + n3;
        }
        int percentOfFoodCarriedOver = RangesKt.coerceAtMost(n, 95);
        this.foodStored += (int)((float)(foodNeededToGrow * percentOfFoodCarriedOver) / 100.0f);
        this.addPopulation(1);
        this.getCity().setShouldReassignPopulation(true);
        stringArray = new String[]{"StatIcons/Population"};
        this.getCity().getCiv().addNotification('[' + this.getCity().getName() + "] has grown!", this.getCity().getLocation(), Notification.NotificationCategory.Cities, stringArray);
    }

    public final void addPopulation(int count2) {
        int changedAmount = RangesKt.coerceAtLeast(count2, 1 - this.population);
        this.population += changedAmount;
        int freePopulation = this.getFreePopulation();
        if (freePopulation < 0) {
            this.unassignExtraPopulation();
            CityStats.update$default(this.getCity().getCityStats(), null, false, false, null, false, 31, null);
        } else {
            this.autoAssignPopulation$core();
        }
        if (this.getCity().getCiv().getGameInfo().isReligionEnabled()) {
            this.getCity().getReligion().updatePressureOnPopulationChange(changedAmount);
        }
    }

    public final void setPopulation(int count2) {
        this.addPopulation(-this.population + count2);
    }

    /*
     * WARNING - void declaration
     */
    public final void autoAssignPopulation$core() {
        void $this$associateWith$iv;
        CityStats.update$default(this.getCity().getCityStats(), null, false, false, null, false, 31, null);
        int freePopulation = this.getFreePopulation();
        if (freePopulation <= 0) {
            return;
        }
        Stats cityStats = this.getCity().getCityStats().getCurrentCityStats();
        this.getCity().setCurrentGPPBonus(this.getCity().getGreatPersonPercentageBonus());
        float specialistFoodBonus = 0.0f;
        specialistFoodBonus = 2.0f;
        Iterator iterator2 = City.getMatchingUniques$default(this.getCity(), UniqueType.FoodConsumptionBySpecialists, null, false, 6, null).iterator();
        while (iterator2.hasNext()) {
            Unique unique = (Unique)iterator2.next();
            if (!City.matchesFilter$default(this.getCity(), unique.getParams().get(1), null, false, 6, null)) continue;
            specialistFoodBonus *= FormattingExtensionsKt.toPercent(unique.getParams().get(0));
        }
        specialistFoodBonus = 2.0f - specialistFoodBonus;
        Sequence tilesToEvaluate = CollectionsKt.asSequence((Iterable)SequencesKt.toList(SequencesKt.filter(this.getCity().getWorkableTiles(), CityPopulationManager::autoAssignPopulation$lambda$2)));
        LocalUniqueCache localUniqueCache = new LocalUniqueCache(false, 1, null);
        Sequence<Tile> sequence = SequencesKt.filterNot(tilesToEvaluate, CityPopulationManager::autoAssignPopulation$lambda$3);
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        void $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo2 = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void it;
            Tile tile = (Tile)element$iv$iv;
            Object t = element$iv$iv;
            Map map2 = result$iv;
            boolean bl = false;
            Stats stats = it.getStats().getTileStats(this.getCity(), this.getCity().getCiv(), localUniqueCache);
            map2.put(t, stats);
        }
        Map tileStats = result$iv;
        Sequence maxSpecialists = MapsKt.asSequence((Map)this.getMaxSpecialists());
        for (int i = 0; i < freePopulation; ++i) {
            float valueBestSpecialist;
            Map.Entry bestJobAndRank;
            Map.Entry entry;
            float valueBestTile;
            Map.Entry bestTileAndRank;
            Float f;
            Map map3;
            Object t;
            Map $this$associateWith$iv2;
            int it = i;
            boolean bl = false;
            Sequence<Tile> $i$f$associateWithTo2 = SequencesKt.filterNot(tilesToEvaluate, CityPopulationManager::autoAssignPopulation$lambda$14$lambda$5);
            boolean $i$f$associateWith22 = false;
            LinkedHashMap result$iv2 = new LinkedHashMap();
            Sequence<String> $this$associateWithTo$iv$iv2 = $this$associateWith$iv2;
            boolean $i$f$associateWithTo3 = false;
            Iterator iterator3 = $this$associateWithTo$iv$iv2.iterator();
            while (iterator3.hasNext()) {
                void it2;
                Object element$iv$iv = iterator3.next();
                Tile tile = (Tile)element$iv$iv;
                t = element$iv$iv;
                map3 = result$iv2;
                boolean bl2 = false;
                Object v = tileStats.get(it2);
                Intrinsics.checkNotNull(v);
                f = Float.valueOf(Automation.INSTANCE.rankStatsForCityWork((Stats)v, this.getCity(), false, localUniqueCache));
                map3.put(t, f);
            }
            $this$associateWith$iv2 = result$iv2;
            Object $i$f$associateWith22 = new Function1[]{CityPopulationManager::autoAssignPopulation$lambda$14$lambda$7, CityPopulationManager::autoAssignPopulation$lambda$14$lambda$8, CityPopulationManager::autoAssignPopulation$lambda$14$lambda$9};
            $i$f$associateWith22 = ComparisonsKt.compareBy($i$f$associateWith22);
            Map.Entry entry2 = bestTileAndRank = (Map.Entry)CollectionsKt.maxWithOrNull($this$associateWith$iv2.entrySet(), $i$f$associateWith22);
            Tile bestTile = entry2 != null ? (Tile)entry2.getKey() : null;
            Map.Entry entry3 = bestTileAndRank;
            float f2 = valueBestTile = entry3 != null ? ((Number)entry3.getValue()).floatValue() : 0.0f;
            if (this.getCity().getManualSpecialists()) {
                entry = null;
            } else {
                Object v5;
                void $this$associateWith$iv3;
                $this$associateWithTo$iv$iv2 = SequencesKt.map(SequencesKt.filter(maxSpecialists, arg_0 -> CityPopulationManager.autoAssignPopulation$lambda$14$lambda$10(this, arg_0)), CityPopulationManager::autoAssignPopulation$lambda$14$lambda$11);
                boolean $i$f$associateWith32 = false;
                LinkedHashMap result$iv3 = new LinkedHashMap();
                void $this$associateWithTo$iv$iv3 = $this$associateWith$iv3;
                boolean $i$f$associateWithTo4 = false;
                for (Object element$iv$iv : $this$associateWithTo$iv$iv3) {
                    void it3;
                    String string = (String)element$iv$iv;
                    t = element$iv$iv;
                    map3 = result$iv3;
                    boolean bl3 = false;
                    f = Float.valueOf(Automation.INSTANCE.rankSpecialist((String)it3, this.getCity(), localUniqueCache));
                    map3.put(t, f);
                }
                Iterable $i$f$associateWith32 = ((Map)result$iv3).entrySet();
                iterator3 = $i$f$associateWith32.iterator();
                if (!iterator3.hasNext()) {
                    v5 = null;
                } else {
                    Object t2 = iterator3.next();
                    if (!iterator3.hasNext()) {
                        v5 = t2;
                    } else {
                        Map.Entry it4 = (Map.Entry)t2;
                        boolean bl4 = false;
                        float f3 = ((Number)it4.getValue()).floatValue();
                        do {
                            Object t3 = iterator3.next();
                            Map.Entry it5 = (Map.Entry)t3;
                            $i$a$-maxByOrNull-CityPopulationManager$autoAssignPopulation$1$bestJobAndRank$4 = false;
                            float f4 = ((Number)it5.getValue()).floatValue();
                            if (Float.compare(f3, f4) >= 0) continue;
                            t2 = t3;
                            f3 = f4;
                        } while (iterator3.hasNext());
                        v5 = t2;
                    }
                }
                entry = v5;
            }
            Map.Entry entry4 = bestJobAndRank = entry;
            String bestJob = entry4 != null ? (String)entry4.getKey() : null;
            Map.Entry entry5 = bestJobAndRank;
            float f5 = valueBestSpecialist = entry5 != null ? ((Number)entry5.getValue()).floatValue() : 0.0f;
            if (valueBestTile > valueBestSpecialist) {
                if (bestTile == null) continue;
                this.getCity().setWorkedTiles(CollectionExtensionsKt.withItem(this.getCity().getWorkedTiles(), bestTile.getPosition()));
                float f6 = cityStats.getFood();
                Object v = tileStats.get(bestTile);
                Intrinsics.checkNotNull(v);
                cityStats.setFood(f6 + ((Stats)v).getFood());
                continue;
            }
            if (bestJob == null) continue;
            this.specialistAllocations.add(bestJob, 1);
            cityStats.setFood(cityStats.getFood() + specialistFoodBonus);
        }
        CityStats.update$default(this.getCity().getCityStats(), null, false, false, null, false, 31, null);
    }

    public final void stopWorkingTile(@NotNull Vector2 position) {
        Intrinsics.checkNotNullParameter(position, "position");
        this.getCity().setWorkedTiles(CollectionExtensionsKt.withoutItem(this.getCity().getWorkedTiles(), position));
        this.getCity().getLockedTiles().remove(position);
    }

    /*
     * WARNING - void declaration
     */
    public final void unassignExtraPopulation() {
        void $this$mapTo$iv$iv;
        Iterable iterable = this.getCity().getWorkedTiles();
        boolean $i$f$map = false;
        Iterable iterable2 = iterable;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault(iterable, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Vector2 vector2 = (Vector2)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.getCity().getTileMap().get((Vector2)it));
        }
        for (Tile tile : (List)destination$iv$iv) {
            if (Intrinsics.areEqual(tile.getOwner(), this.getCity().getCiv()) && Intrinsics.areEqual(tile.getWorkingCity(), this.getCity()) && tile.aerialDistanceTo(this.getCity().getCenterTile()) <= this.getCity().getWorkRange()) continue;
            this.getCity().getPopulation().stopWorkingTile(tile.getPosition());
        }
        for (Map.Entry entry : ((Map)this.getMaxSpecialists()).entrySet()) {
            String specialistName = (String)entry.getKey();
            int maxAmount = ((Number)entry.getValue()).intValue();
            if (((Number)this.specialistAllocations.get(specialistName)).intValue() <= maxAmount) continue;
            ((Map)this.specialistAllocations).put(specialistName, maxAmount);
        }
        LocalUniqueCache localUniqueCache = new LocalUniqueCache(false, 1, null);
        while (this.getFreePopulation() < 0) {
            String worstJob;
            Object v9;
            String string;
            float valueWorstTile;
            Iterator<Tile> iterator$iv;
            Tile tile;
            if (this.getCity().getWorkedTiles().isEmpty()) {
                tile = null;
            } else {
                Tile tile2;
                Sequence<Tile> $this$minByOrNull$iv = SequencesKt.map(CollectionsKt.asSequence((Iterable)this.getCity().getWorkedTiles()), arg_0 -> CityPopulationManager.unassignExtraPopulation$lambda$16(this, arg_0));
                boolean $i$f$minByOrNull = false;
                iterator$iv = $this$minByOrNull$iv.iterator();
                if (!iterator$iv.hasNext()) {
                    tile2 = null;
                } else {
                    Tile minElem$iv = iterator$iv.next();
                    if (!iterator$iv.hasNext()) {
                        tile2 = minElem$iv;
                    } else {
                        Tile it = minElem$iv;
                        boolean bl = false;
                        Automation.INSTANCE.rankTileForCityWork(it, this.getCity(), localUniqueCache);
                        int minValue$iv = it.isLocked() ? 10 : 0;
                        do {
                            int v$iv;
                            Object e$iv = iterator$iv.next();
                            Tile it2 = (Tile)e$iv;
                            boolean bl2 = false;
                            Automation.INSTANCE.rankTileForCityWork(it2, this.getCity(), localUniqueCache);
                            int n = v$iv = it2.isLocked() ? 10 : 0;
                            if (minValue$iv <= v$iv) continue;
                            minElem$iv = e$iv;
                            minValue$iv = v$iv;
                        } while (iterator$iv.hasNext());
                        tile2 = minElem$iv;
                    }
                }
                Intrinsics.checkNotNull(tile2);
                tile = tile2;
            }
            Tile tile3 = tile;
            float f = valueWorstTile = tile3 == null ? 0.0f : Automation.INSTANCE.rankTileForCityWork(tile3, this.getCity(), localUniqueCache);
            if (this.getCity().getManualSpecialists()) {
                string = null;
            } else {
                Object v6;
                void $this$minByOrNull$iv;
                Set<String> set = this.specialistAllocations.keySet();
                Intrinsics.checkNotNullExpressionValue(set, "<get-keys>(...)");
                iterator$iv = set;
                boolean $i$f$minByOrNull = false;
                Iterator iterator$iv2 = $this$minByOrNull$iv.iterator();
                if (!iterator$iv2.hasNext()) {
                    v6 = null;
                } else {
                    Object minElem$iv = iterator$iv2.next();
                    if (!iterator$iv2.hasNext()) {
                        v6 = minElem$iv;
                    } else {
                        String it = (String)minElem$iv;
                        boolean bl = false;
                        Intrinsics.checkNotNull(it);
                        float minValue$iv = Automation.INSTANCE.rankSpecialist(it, this.getCity(), localUniqueCache);
                        do {
                            Object e$iv = iterator$iv2.next();
                            String it3 = (String)e$iv;
                            boolean bl3 = false;
                            Intrinsics.checkNotNull(it3);
                            float v$iv = Automation.INSTANCE.rankSpecialist(it3, this.getCity(), localUniqueCache);
                            if (Float.compare(minValue$iv, v$iv) <= 0) continue;
                            minElem$iv = e$iv;
                            minValue$iv = v$iv;
                        } while (iterator$iv2.hasNext());
                        v6 = minElem$iv;
                    }
                }
                string = v6;
            }
            String worstAutoJob = string;
            float valueWorstSpecialist = 0.0f;
            if (worstAutoJob != null) {
                valueWorstSpecialist = Automation.INSTANCE.rankSpecialist(worstAutoJob, this.getCity(), localUniqueCache);
            }
            if (worstAutoJob != null && tile3 != null) {
                if (valueWorstTile < valueWorstSpecialist) {
                    this.stopWorkingTile(tile3.getPosition());
                    continue;
                }
                this.specialistAllocations.add(worstAutoJob, -1);
                continue;
            }
            if (worstAutoJob != null) {
                this.specialistAllocations.add(worstAutoJob, -1);
                continue;
            }
            Tile tile4 = tile3;
            if (tile4 != null) {
                this.stopWorkingTile(tile4.getPosition());
                continue;
            }
            Set<String> set = this.specialistAllocations.keySet();
            Intrinsics.checkNotNullExpressionValue(set, "<get-keys>(...)");
            Iterable $this$minByOrNull$iv = set;
            boolean $i$f$minByOrNull = false;
            Iterator iterator$iv3 = $this$minByOrNull$iv.iterator();
            if (!iterator$iv3.hasNext()) {
                v9 = null;
            } else {
                Object minElem$iv = iterator$iv3.next();
                if (!iterator$iv3.hasNext()) {
                    v9 = minElem$iv;
                } else {
                    String it = (String)minElem$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull(it);
                    float minValue$iv = Automation.INSTANCE.rankSpecialist(it, this.getCity(), localUniqueCache);
                    do {
                        Object e$iv = iterator$iv3.next();
                        String it4 = (String)e$iv;
                        boolean bl4 = false;
                        Intrinsics.checkNotNull(it4);
                        float v$iv = Automation.INSTANCE.rankSpecialist(it4, this.getCity(), localUniqueCache);
                        if (Float.compare(minValue$iv, v$iv) <= 0) continue;
                        minElem$iv = e$iv;
                        minValue$iv = v$iv;
                    } while (iterator$iv3.hasNext());
                    v9 = minElem$iv;
                }
            }
            if ((String)v9 == null) break;
            this.specialistAllocations.add(worstJob, -1);
        }
    }

    @Readonly
    @NotNull
    public final Counter<String> getMaxSpecialists() {
        Counter<String> counter = new Counter<String>(null, 1, null);
        Iterator<Building> iterator2 = this.getCity().getCityConstructions().getBuiltBuildings().iterator();
        while (iterator2.hasNext()) {
            Building building;
            Intrinsics.checkNotNullExpressionValue(iterator2.next(), "next(...)");
            counter.add(building.newSpecialists());
        }
        return counter;
    }

    private static final boolean nextTurn$lambda$0(CityPopulationManager this$0, Unique it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return City.matchesFilter$default(this$0.getCity(), it.getParams().get(1), null, false, 6, null);
    }

    private static final boolean autoAssignPopulation$lambda$2(Tile it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return !it.isBlockaded();
    }

    private static final boolean autoAssignPopulation$lambda$3(Tile it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.providesYield();
    }

    private static final boolean autoAssignPopulation$lambda$14$lambda$5(Tile it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.providesYield();
    }

    private static final Comparable autoAssignPopulation$lambda$14$lambda$7(Map.Entry it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return (Comparable)it.getValue();
    }

    private static final Comparable autoAssignPopulation$lambda$14$lambda$8(Map.Entry it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return Float.valueOf(((Tile)it.getKey()).getLongitude());
    }

    private static final Comparable autoAssignPopulation$lambda$14$lambda$9(Map.Entry it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return Float.valueOf(((Tile)it.getKey()).getLatitude());
    }

    private static final boolean autoAssignPopulation$lambda$14$lambda$10(CityPopulationManager this$0, Map.Entry it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return ((Number)this$0.specialistAllocations.get(it.getKey())).intValue() < ((Number)it.getValue()).intValue();
    }

    private static final String autoAssignPopulation$lambda$14$lambda$11(Map.Entry it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return (String)it.getKey();
    }

    private static final Tile unassignExtraPopulation$lambda$16(CityPopulationManager this$0, Vector2 it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return this$0.getCity().getTileMap().get(it);
    }
}

