/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.city;

import com.unciv.logic.city.City;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.ruleset.Building;
import com.unciv.models.ruleset.RulesetStatsObject;
import com.unciv.models.ruleset.tile.ResourceSupplyList;
import com.unciv.models.ruleset.tile.ResourceType;
import com.unciv.models.ruleset.tile.TileImprovement;
import com.unciv.models.ruleset.tile.TileResource;
import com.unciv.models.ruleset.unique.GameContext;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueParameterType;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.stats.Stat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import yairm210.purity.annotations.Readonly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tH\u0007J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J$\u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tH\u0003J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\nH\u0007J$\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tH\u0003J$\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tH\u0003J\u0010\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0003J.\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t2\b\b\u0002\u0010\u0017\u001a\u00020\u0018H\u0003J\u0018\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u001bH\u0003\u00a8\u0006\u001c"}, d2={"Lcom/unciv/logic/city/CityResources;", "", "<init>", "()V", "getResourcesGeneratedByCity", "Lcom/unciv/models/ruleset/tile/ResourceSupplyList;", "city", "Lcom/unciv/logic/city/City;", "resourceModifiers", "", "", "", "getCityResourcesAvailableToCity", "getResourcesGeneratedByCityNotIncludingBuildings", "resourceModifers", "getAvailableResourceAmount", "", "resourceName", "getResourcesFromTiles", "resourceModifer", "getResourceFromUniqueImprovedTiles", "getNegativeCityResourcesRequiredByBuildings", "getCityResourcesGeneratedFromUniques", "includeCivUniques", "", "getTileResourceAmount", "tile", "Lcom/unciv/logic/map/tile/Tile;", "core"})
@SourceDebugExtension(value={"SMAP\nCityResources.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CityResources.kt\ncom/unciv/logic/city/CityResources\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,177:1\n1#2:178\n*E\n"})
public final class CityResources {
    @NotNull
    public static final CityResources INSTANCE = new CityResources();

    private CityResources() {
    }

    @Readonly
    @NotNull
    public final ResourceSupplyList getResourcesGeneratedByCity(@NotNull City city, @NotNull Map<String, Float> resourceModifiers) {
        Intrinsics.checkNotNullParameter(city, "city");
        Intrinsics.checkNotNullParameter(resourceModifiers, "resourceModifiers");
        ResourceSupplyList cityResources = this.getResourcesGeneratedByCityNotIncludingBuildings(city, resourceModifiers);
        CollectionsKt.addAll((Collection)cityResources, this.getCityResourcesGeneratedFromUniques(city, resourceModifiers, false));
        return cityResources;
    }

    @Readonly
    @NotNull
    public final ResourceSupplyList getCityResourcesAvailableToCity(@NotNull City city) {
        Intrinsics.checkNotNullParameter(city, "city");
        HashMap resourceModifers = new HashMap();
        Iterator<TileResource> iterator2 = city.getCiv().getGameInfo().getRuleset().getTileResources().values().iterator();
        while (iterator2.hasNext()) {
            TileResource resource;
            Intrinsics.checkNotNullExpressionValue(iterator2.next(), "next(...)");
            ((Map)resourceModifers).put(resource.getName(), Float.valueOf(city.getCiv().getResourceModifier(resource)));
        }
        ResourceSupplyList cityResources = this.getResourcesGeneratedByCityNotIncludingBuildings(city, resourceModifers);
        cityResources.add(this.getCityResourcesGeneratedFromUniques(city, resourceModifers, true));
        CollectionsKt.removeAll(cityResources, CityResources::getCityResourcesAvailableToCity$lambda$0);
        return cityResources;
    }

    @Readonly
    private final ResourceSupplyList getResourcesGeneratedByCityNotIncludingBuildings(City city, Map<String, Float> resourceModifers) {
        ResourceSupplyList cityResources = new ResourceSupplyList(false, 1, null);
        cityResources.add(this.getResourcesFromTiles(city, resourceModifers));
        cityResources.add(this.getResourceFromUniqueImprovedTiles(city, resourceModifers));
        cityResources.add(this.getNegativeCityResourcesRequiredByBuildings(city));
        if (city.getCiv().isCityState() && city.isCapital() && city.getCiv().getCityStateResource() != null) {
            Object v = ((Map)city.getRuleset().getTileResources()).get(city.getCiv().getCityStateResource());
            Intrinsics.checkNotNull(v);
            ResourceSupplyList.add$default(cityResources, (TileResource)v, "Mercantile City-State", 0, 4, null);
        }
        return cityResources;
    }

    /*
     * WARNING - void declaration
     */
    @Readonly
    public final int getAvailableResourceAmount(@NotNull City city, @NotNull String resourceName) {
        Intrinsics.checkNotNullParameter(city, "city");
        Intrinsics.checkNotNullParameter(resourceName, "resourceName");
        TileResource tileResource = city.getRuleset().getTileResources().get(resourceName);
        if (tileResource == null) {
            return 0;
        }
        TileResource resource = tileResource;
        if (!resource.isCityWide()) {
            return city.getCiv().getResourceAmount(resourceName);
        }
        if (resource.isStockpiled()) {
            return ((Number)city.getResourceStockpiles().get(resourceName)).intValue();
        }
        Sequence<ResourceSupplyList.ResourceSupply> sequence = SequencesKt.filter(CollectionsKt.asSequence(this.getCityResourcesAvailableToCity(city)), arg_0 -> CityResources.getAvailableResourceAmount$lambda$1(resource, arg_0));
        int n = 0;
        Iterator<ResourceSupplyList.ResourceSupply> iterator2 = sequence.iterator();
        while (iterator2.hasNext()) {
            void it;
            ResourceSupplyList.ResourceSupply resourceSupply;
            ResourceSupplyList.ResourceSupply resourceSupply2 = resourceSupply = iterator2.next();
            int n2 = n;
            boolean bl = false;
            int n3 = it.getAmount();
            n = n2 + n3;
        }
        return n;
    }

    @Readonly
    private final ResourceSupplyList getResourcesFromTiles(City city, Map<String, Float> resourceModifer) {
        ResourceSupplyList resourceSupplyList = new ResourceSupplyList(false, 1, null);
        Iterator<Tile> iterator2 = SequencesKt.filter(city.getTiles(), CityResources::getResourcesFromTiles$lambda$3).iterator();
        while (iterator2.hasNext()) {
            Tile tileInfo = iterator2.next();
            TileResource resource = tileInfo.getTileResource();
            float f = this.getTileResourceAmount(city, tileInfo);
            Float f2 = resourceModifer.get(resource.getName());
            Intrinsics.checkNotNull(f2);
            float amount = f * ((Number)f2).floatValue();
            if (!(amount > 0.0f)) continue;
            resourceSupplyList.add(resource, "Tiles", (int)amount);
        }
        return resourceSupplyList;
    }

    @Readonly
    private final ResourceSupplyList getResourceFromUniqueImprovedTiles(City city, Map<String, Float> resourceModifer) {
        ResourceSupplyList resourceSupplyList = new ResourceSupplyList(false, 1, null);
        Iterator<Tile> iterator2 = SequencesKt.filter(city.getTiles(), CityResources::getResourceFromUniqueImprovedTiles$lambda$4).iterator();
        while (iterator2.hasNext()) {
            TileResource resource;
            Unique unique;
            TileImprovement tileImprovement;
            Tile tileInfo = iterator2.next();
            GameContext gameContext = new GameContext(city.getCiv(), city, null, tileInfo, null, null, null, null, null, null, false, 2036, null);
            TileImprovement tileImprovement2 = tileImprovement = tileInfo.getUnpillagedTileImprovement();
            Intrinsics.checkNotNull(tileImprovement2);
            Iterator<Unique> iterator3 = tileImprovement2.getMatchingUniques(UniqueType.ProvidesResources, gameContext).iterator();
            while (iterator3.hasNext()) {
                unique = iterator3.next();
                if (city.getRuleset().getTileResources().get(unique.getParams().get(1)) == null) continue;
                float f = Float.parseFloat(unique.getParams().get(0));
                Float f2 = resourceModifer.get(resource.getName());
                Intrinsics.checkNotNull(f2);
                resourceSupplyList.add(resource, "Improvements", (int)(f * ((Number)f2).floatValue()));
            }
            iterator3 = tileImprovement.getMatchingUniques(UniqueType.ConsumesResources, gameContext).iterator();
            while (iterator3.hasNext()) {
                unique = iterator3.next();
                if (city.getRuleset().getTileResources().get(unique.getParams().get(1)) == null) continue;
                resourceSupplyList.add(resource, "Improvements", -1 * Integer.parseInt(unique.getParams().get(0)));
            }
        }
        return resourceSupplyList;
    }

    @Readonly
    private final ResourceSupplyList getNegativeCityResourcesRequiredByBuildings(City city) {
        ResourceSupplyList resourceSupplyList = new ResourceSupplyList(false, 1, null);
        Set<String> freeBuildings = city.getCiv().getCivConstructions().getFreeBuildingNames(city);
        Iterator<Building> iterator2 = city.getCityConstructions().getBuiltBuildings().iterator();
        while (iterator2.hasNext()) {
            Building building;
            Intrinsics.checkNotNullExpressionValue(iterator2.next(), "next(...)");
            if (freeBuildings.contains(building.getName())) continue;
            resourceSupplyList.subtractResourceRequirements((HashMap<String, Integer>)building.getResourceRequirementsPerTurn(city.getState()), city.getRuleset(), "Buildings");
        }
        return resourceSupplyList;
    }

    @Readonly
    private final ResourceSupplyList getCityResourcesGeneratedFromUniques(City city, Map<String, Float> resourceModifers, boolean includeCivUniques) {
        TileResource resource;
        Unique unique;
        ResourceSupplyList buildingResources = new ResourceSupplyList(false, 1, null);
        Iterator<Unique> iterator2 = city.getMatchingUniques(UniqueType.ProvidesResources, city.getState(), includeCivUniques).iterator();
        while (iterator2.hasNext()) {
            unique = iterator2.next();
            if (city.getRuleset().getTileResources().get(unique.getParams().get(1)) == null) continue;
            String string = unique.getSourceNameForUser();
            float f = Float.parseFloat(unique.getParams().get(0));
            Float f2 = resourceModifers.get(resource.getName());
            Intrinsics.checkNotNull(f2);
            buildingResources.add(resource, string, (int)(f * ((Number)f2).floatValue()));
        }
        iterator2 = city.getMatchingUniques(UniqueType.StatPercentFromObjectToResource, city.getState(), includeCivUniques).iterator();
        while (iterator2.hasNext()) {
            double d;
            TileImprovement it;
            double d2;
            RulesetStatsObject rulesetStatsObject;
            Iterator<RulesetStatsObject> iterator3;
            double d3;
            double d4;
            Sequence<RulesetStatsObject> sequence;
            Stat stat;
            unique = iterator2.next();
            if (city.getRuleset().getTileResources().get(unique.getParams().get(3)) == null || Stat.Companion.safeValueOf(unique.getParams().get(1)) == null) continue;
            String filter2 = unique.getParams().get(2);
            double amount = 0.0;
            if (UniqueParameterType.BuildingFilter.isKnownValue(filter2, city.getRuleset())) {
                sequence = SequencesKt.filter(city.getCityConstructions().getBuiltBuildings(), arg_0 -> CityResources.getCityResourcesGeneratedFromUniques$lambda$5(stat, filter2, city, arg_0));
                d4 = amount;
                d3 = 0.0;
                iterator3 = sequence.iterator();
                while (iterator3.hasNext()) {
                    Building building = rulesetStatsObject = iterator3.next();
                    d2 = d3;
                    boolean bl = false;
                    d = Building.getStats$default((Building)((Object)it), city, null, 2, null).get(stat);
                    d3 = d2 + d;
                }
                d2 = d3;
                amount = d4 + d2;
            }
            if (UniqueParameterType.ImprovementFilter.isKnownValue(filter2, city.getRuleset())) {
                sequence = SequencesKt.filter(SequencesKt.mapNotNull(city.getWorkedTiles(), CityResources::getCityResourcesGeneratedFromUniques$lambda$7), arg_0 -> CityResources.getCityResourcesGeneratedFromUniques$lambda$8(stat, filter2, city, arg_0));
                d4 = amount;
                d3 = 0.0;
                iterator3 = sequence.iterator();
                while (iterator3.hasNext()) {
                    rulesetStatsObject = iterator3.next();
                    it = (TileImprovement)rulesetStatsObject;
                    d2 = d3;
                    boolean bl = false;
                    d = it.get(stat);
                    d3 = d2 + d;
                }
                d2 = d3;
                amount = d4 + d2;
            }
            if (!(amount > 0.0)) continue;
            Float f = resourceModifers.get(resource.getName());
            buildingResources.add(resource, unique.getSourceNameForUser(), (int)(amount *= Double.parseDouble(unique.getParams().get(0)) / 100.0 * (double)(f != null ? f.floatValue() : 1.0f)));
        }
        return buildingResources;
    }

    static /* synthetic */ ResourceSupplyList getCityResourcesGeneratedFromUniques$default(CityResources cityResources, City city, Map map2, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        return cityResources.getCityResourcesGeneratedFromUniques(city, map2, bl);
    }

    @Readonly
    private final int getTileResourceAmount(City city, Tile tile) {
        int amountToAdd;
        if (tile.getResource() == null) {
            return 0;
        }
        if (!tile.providesResources(city.getCiv())) {
            return 0;
        }
        TileResource resource = tile.getTileResource();
        int n = amountToAdd = resource.getResourceType() == ResourceType.Strategic ? tile.getResourceAmount() : 1;
        if (resource.getResourceType() == ResourceType.Luxury && City.containsBuildingUnique$default(city, UniqueType.ProvidesExtraLuxuryFromCityResources, null, 2, null)) {
            ++amountToAdd;
        }
        return amountToAdd;
    }

    private static final boolean getCityResourcesAvailableToCity$lambda$0(ResourceSupplyList.ResourceSupply it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return !it.getResource().isCityWide();
    }

    private static final boolean getAvailableResourceAmount$lambda$1(TileResource $resource, ResourceSupplyList.ResourceSupply it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return Intrinsics.areEqual(it.getResource(), $resource);
    }

    private static final boolean getResourcesFromTiles$lambda$3(Tile it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getResource() != null;
    }

    private static final boolean getResourceFromUniqueImprovedTiles$lambda$4(Tile it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getUnpillagedImprovement() != null;
    }

    private static final boolean getCityResourcesGeneratedFromUniques$lambda$5(Stat $stat, String $filter, City $city, Building it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return Building.isStatRelated$default(it, $stat, null, 2, null) && it.matchesFilter($filter, $city.getState());
    }

    private static final TileImprovement getCityResourcesGeneratedFromUniques$lambda$7(Tile it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getUnpillagedTileImprovement();
    }

    private static final boolean getCityResourcesGeneratedFromUniques$lambda$8(Stat $stat, String $filter, City $city, TileImprovement it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.get($stat) > 0.0f && TileImprovement.matchesFilter$default(it, $filter, $city.getState(), false, 4, null);
    }
}

