/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.battle;

import com.unciv.logic.battle.AttackableTile;
import com.unciv.logic.battle.Battle;
import com.unciv.logic.battle.CityCombatant;
import com.unciv.logic.battle.CombatAction;
import com.unciv.logic.battle.ICombatant;
import com.unciv.logic.battle.MapUnitCombatant;
import com.unciv.logic.city.City;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.logic.map.mapunit.movement.PathsToTilesWithinTurn;
import com.unciv.logic.map.mapunit.movement.UnitMovement;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.ruleset.unique.GameContext;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import yairm210.purity.annotations.Readonly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JD\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u00060\u0005j\b\u0012\u0004\u0012\u00020\u0006`\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0010\b\u0002\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r2\b\b\u0002\u0010\u000f\u001a\u00020\u0010H\u0007J2\u0010\u0011\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00140\u00130\u00122\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\tH\u0003J(\u0010\u0016\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u000e2\u000e\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\rH\u0003J\u0018\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u001aH\u0007J\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00122\u0006\u0010\u001c\u001a\u00020\u001dH\u0007\u00a8\u0006\u001e"}, d2={"Lcom/unciv/logic/battle/TargetHelper;", "", "<init>", "()V", "getAttackableEnemies", "Ljava/util/ArrayList;", "Lcom/unciv/logic/battle/AttackableTile;", "Lkotlin/collections/ArrayList;", "unit", "Lcom/unciv/logic/map/mapunit/MapUnit;", "unitDistanceToTiles", "Lcom/unciv/logic/map/mapunit/movement/PathsToTilesWithinTurn;", "tilesToCheck", "", "Lcom/unciv/logic/map/tile/Tile;", "stayOnTile", "", "getTilesToAttackFromWhenUnitMoves", "Lkotlin/sequences/Sequence;", "Lkotlin/Pair;", "", "unitMustBeSetUp", "tileContainsAttackableEnemy", "tile", "containsAttackableEnemy", "combatant", "Lcom/unciv/logic/battle/ICombatant;", "getBombardableTiles", "city", "Lcom/unciv/logic/city/City;", "core"})
@SourceDebugExtension(value={"SMAP\nTargetHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TargetHelper.kt\ncom/unciv/logic/battle/TargetHelper\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,160:1\n2275#2,2:161\n2275#2,2:163\n1563#3:165\n1634#3,3:166\n*S KotlinDebug\n*F\n+ 1 TargetHelper.kt\ncom/unciv/logic/battle/TargetHelper\n*L\n131#1:161,2\n137#1:163,2\n147#1:165\n147#1:166,3\n*E\n"})
public final class TargetHelper {
    @NotNull
    public static final TargetHelper INSTANCE = new TargetHelper();

    private TargetHelper() {
    }

    @Readonly
    @NotNull
    public final ArrayList<AttackableTile> getAttackableEnemies(@NotNull MapUnit unit, @NotNull PathsToTilesWithinTurn unitDistanceToTiles, @Nullable List<Tile> tilesToCheck, boolean stayOnTile) {
        Intrinsics.checkNotNullParameter(unit, "unit");
        Intrinsics.checkNotNullParameter(unitDistanceToTiles, "unitDistanceToTiles");
        int rangeOfAttack = unit.getRange();
        ArrayList<AttackableTile> attackableTiles = new ArrayList<AttackableTile>();
        boolean unitMustBeSetUp = MapUnit.hasUnique$default(unit, UniqueType.MustSetUp, null, false, 6, null);
        Sequence<Pair<Tile, Float>> tilesToAttackFrom = stayOnTile || unit.getBaseUnit().getMovesLikeAirUnits() ? SequencesKt.sequenceOf(new Pair<Tile, Float>(unit.getCurrentTile(), Float.valueOf(unit.getCurrentMovement()))) : this.getTilesToAttackFromWhenUnitMoves(unitDistanceToTiles, unitMustBeSetUp, unit);
        HashSet tilesWithEnemies = new HashSet();
        HashSet tilesWithoutEnemies = new HashSet();
        Iterator<Pair<Tile, Float>> iterator2 = tilesToAttackFrom.iterator();
        while (iterator2.hasNext()) {
            Pair<Tile, Float> pair = iterator2.next();
            Tile reachableTile = pair.component1();
            float movementLeft = ((Number)pair.component2()).floatValue();
            if (unit.getBaseUnit().isMelee() && unit.isEscorting()) {
                MapUnit escortingUnit;
                Intrinsics.checkNotNull(unit.getOtherEscortUnit());
                if (!escortingUnit.getMovement().canReachInCurrentTurn(reachableTile)) continue;
                float f = escortingUnit.getCurrentMovement();
                Object object = UnitMovement.getDistanceToTiles$default(escortingUnit.getMovement(), false, null, null, false, 15, null).get((Object)reachableTile);
                Intrinsics.checkNotNull(object);
                if (f - ((UnitMovement.ParentTileAndTotalMovement)object).getTotalMovement() <= 0.0f) continue;
            }
            Sequence<Tile> tilesInAttackRange = unit.getBaseUnit().isMelee() ? reachableTile.getNeighbors() : (unit.getBaseUnit().getMovesLikeAirUnits() || MapUnit.hasUnique$default(unit, UniqueType.IndirectFire, null, true, 2, null) ? reachableTile.getTilesInDistance(rangeOfAttack) : CollectionsKt.asSequence((Iterable)reachableTile.getTileMap().getViewableTiles(reachableTile.getPosition(), rangeOfAttack, true)));
            Iterator<Tile> iterator3 = tilesInAttackRange.iterator();
            while (iterator3.hasNext()) {
                Tile tile = iterator3.next();
                if (Intrinsics.areEqual(tile, reachableTile)) continue;
                if (tilesWithEnemies.contains(tile)) {
                    ((Collection)attackableTiles).add(new AttackableTile(reachableTile, tile, movementLeft, Battle.INSTANCE.getMapCombatantOfTile(tile)));
                    continue;
                }
                if (tilesWithoutEnemies.contains(tile)) continue;
                if (this.tileContainsAttackableEnemy(unit, tile, tilesToCheck) || unit.isPreparingAirSweep()) {
                    ((Collection)tilesWithEnemies).add(tile);
                    ((Collection)attackableTiles).add(new AttackableTile(reachableTile, tile, movementLeft, Battle.INSTANCE.getMapCombatantOfTile(tile)));
                    continue;
                }
                ((Collection)tilesWithoutEnemies).add(tile);
            }
        }
        return attackableTiles;
    }

    public static /* synthetic */ ArrayList getAttackableEnemies$default(TargetHelper targetHelper, MapUnit mapUnit, PathsToTilesWithinTurn pathsToTilesWithinTurn, List list2, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            list2 = null;
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        return targetHelper.getAttackableEnemies(mapUnit, pathsToTilesWithinTurn, list2, bl);
    }

    @Readonly
    private final Sequence<Pair<Tile, Float>> getTilesToAttackFromWhenUnitMoves(PathsToTilesWithinTurn unitDistanceToTiles, boolean unitMustBeSetUp, MapUnit unit) {
        return SequencesKt.filter(SequencesKt.filter(SequencesKt.map(MapsKt.asSequence(unitDistanceToTiles), arg_0 -> TargetHelper.getTilesToAttackFromWhenUnitMoves$lambda$0(unitMustBeSetUp, unit, arg_0)), TargetHelper::getTilesToAttackFromWhenUnitMoves$lambda$1), arg_0 -> TargetHelper.getTilesToAttackFromWhenUnitMoves$lambda$2(unit, arg_0));
    }

    @Readonly
    private final boolean tileContainsAttackableEnemy(MapUnit unit, Tile tile, List<Tile> tilesToCheck) {
        List<Tile> list2 = tilesToCheck;
        if (!(list2 != null ? (Collection)list2 : (Collection)unit.getCiv().getViewableTiles()).contains(tile) || !this.containsAttackableEnemy(tile, new MapUnitCombatant(unit))) {
            return false;
        }
        ICombatant mapCombatant = Battle.INSTANCE.getMapCombatantOfTile(tile);
        return !unit.getBaseUnit().isMelee() || !(mapCombatant instanceof MapUnitCombatant) || !((MapUnitCombatant)mapCombatant).getUnit().isCivilian() || UnitMovement.canPassThrough$default(unit.getMovement(), tile, false, 2, null);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Readonly
    public final boolean containsAttackableEnemy(@NotNull Tile tile, @NotNull ICombatant combatant) {
        void $this$mapTo$iv$iv;
        Object $this$containsAttackableEnemy_u24lambda_u246;
        Intrinsics.checkNotNullParameter(tile, "tile");
        Intrinsics.checkNotNullParameter(combatant, "combatant");
        if (combatant instanceof MapUnitCombatant && ((MapUnitCombatant)combatant).getUnit().isEmbarked() && !MapUnitCombatant.hasUnique$default((MapUnitCombatant)combatant, UniqueType.AttackOnSea, null, 2, null)) {
            if (tile.isWater()) return false;
            if (combatant.isRanged()) {
                return false;
            }
        }
        ICombatant iCombatant = Battle.INSTANCE.getMapCombatantOfTile(tile);
        if (iCombatant == null) {
            return false;
        }
        ICombatant tileCombatant = iCombatant;
        if (Intrinsics.areEqual(tileCombatant.getCivInfo(), combatant.getCivInfo())) {
            return false;
        }
        if (tileCombatant instanceof CityCombatant && ((CityCombatant)tileCombatant).getCity().getHasJustBeenConquered()) {
            return false;
        }
        if (!combatant.getCivInfo().isAtWarWith(tileCombatant.getCivInfo())) {
            return false;
        }
        if (combatant instanceof MapUnitCombatant && combatant.isLandUnit() && combatant.isMelee() && tile.isWater() && !((MapUnitCombatant)combatant).getCivInfo().getTech().getUnitsCanEmbark() && !((MapUnitCombatant)combatant).getUnit().getCache().getCanMoveOnWater()) {
            return false;
        }
        if (combatant instanceof MapUnitCombatant) {
            Unique it;
            Iterator iterator2;
            boolean $i$f$none;
            Object $this$none$iv;
            ICombatant iCombatant2 = combatant;
            MapUnitCombatant mapUnitCombatant = iCombatant2 instanceof MapUnitCombatant ? (MapUnitCombatant)iCombatant2 : null;
            GameContext gameContext = new GameContext(null, null, mapUnitCombatant != null ? mapUnitCombatant.getUnit() : null, tile, combatant, tileCombatant, null, CombatAction.Attack, null, null, false, 1859, null);
            if (((MapUnitCombatant)combatant).hasUnique(UniqueType.CannotAttack, gameContext)) {
                return false;
            }
            Sequence $this$containsAttackableEnemy_u24lambda_u244 = MapUnit.getMatchingUniques$default(((MapUnitCombatant)combatant).getUnit(), UniqueType.CanOnlyAttackUnits, gameContext, false, 4, null);
            boolean bl = false;
            if (SequencesKt.any($this$containsAttackableEnemy_u24lambda_u244)) {
                $this$none$iv = $this$containsAttackableEnemy_u24lambda_u244;
                $i$f$none = false;
                iterator2 = $this$none$iv.iterator();
                do {
                    if (!iterator2.hasNext()) return false;
                    Object t = iterator2.next();
                    it = (Unique)t;
                    boolean bl2 = false;
                } while (!ICombatant.matchesFilter$default(tileCombatant, it.getParams().get(0), false, 2, null));
                boolean bl3 = false;
                if (bl3) {
                    return false;
                }
            }
            boolean bl4 = false;
            if (bl4) {
                return false;
            }
            $this$containsAttackableEnemy_u24lambda_u246 = MapUnit.getMatchingUniques$default(((MapUnitCombatant)combatant).getUnit(), UniqueType.CanOnlyAttackTiles, gameContext, false, 4, null);
            boolean bl5 = false;
            if (SequencesKt.any($this$containsAttackableEnemy_u24lambda_u246)) {
                $this$none$iv = $this$containsAttackableEnemy_u24lambda_u246;
                $i$f$none = false;
                iterator2 = $this$none$iv.iterator();
                do {
                    if (!iterator2.hasNext()) return false;
                    Object t = iterator2.next();
                    it = (Unique)t;
                    boolean bl6 = false;
                } while (!Tile.matchesFilter$default(tile, it.getParams().get(0), null, 2, null));
                boolean bl7 = false;
                if (bl7) {
                    return false;
                }
            }
            boolean bl8 = false;
            if (bl8) {
                return false;
            }
        }
        if (!tileCombatant.isInvisible(combatant.getCivInfo())) return true;
        if (tile.isCityCenter()) return true;
        if (!(combatant instanceof MapUnitCombatant)) return false;
        Iterable $this$map$iv = ((MapUnitCombatant)combatant).getCivInfo().getViewableInvisibleUnitsTiles();
        boolean $i$f$map = false;
        $this$containsAttackableEnemy_u24lambda_u246 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Tile tile2 = (Tile)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(tile2.getPosition());
        }
        if (!((List)destination$iv$iv).contains(tile.getPosition())) return false;
        return true;
    }

    @Readonly
    @NotNull
    public final Sequence<Tile> getBombardableTiles(@NotNull City city) {
        Intrinsics.checkNotNullParameter(city, "city");
        return SequencesKt.filter(city.getCenterTile().getTilesInDistance(city.getBombardRange()), arg_0 -> TargetHelper.getBombardableTiles$lambda$8(city, arg_0));
    }

    private static final Pair getTilesToAttackFromWhenUnitMoves$lambda$0(boolean $unitMustBeSetUp, MapUnit $unit, Map.Entry entry) {
        Intrinsics.checkNotNullParameter(entry, "<destruct>");
        Tile tile = (Tile)entry.getKey();
        UnitMovement.ParentTileAndTotalMovement distance = (UnitMovement.ParentTileAndTotalMovement)entry.getValue();
        boolean movementPointsToExpendAfterMovement = $unitMustBeSetUp;
        boolean movementPointsToExpendHere = $unitMustBeSetUp && !$unit.isSetUpForSiege();
        boolean movementPointsToExpendBeforeAttack = Intrinsics.areEqual(tile, $unit.getCurrentTile()) ? movementPointsToExpendHere : movementPointsToExpendAfterMovement;
        float movementLeft = $unit.getCurrentMovement() - distance.getTotalMovement() - (float)movementPointsToExpendBeforeAttack;
        return new Pair<Tile, Float>(tile, Float.valueOf(movementLeft));
    }

    private static final boolean getTilesToAttackFromWhenUnitMoves$lambda$1(Pair it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return ((Number)it.getSecond()).floatValue() > 0.05f;
    }

    private static final boolean getTilesToAttackFromWhenUnitMoves$lambda$2(MapUnit $unit, Pair it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return Intrinsics.areEqual(it.getFirst(), $unit.getTile()) || UnitMovement.canMoveTo$default($unit.getMovement(), (Tile)it.getFirst(), false, false, false, 14, null);
    }

    private static final boolean getBombardableTiles$lambda$8(City $city, Tile it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.isVisible($city.getCiv()) && INSTANCE.containsAttackableEnemy(it, new CityCombatant($city));
    }
}

