/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.automation.civilization;

import com.unciv.logic.IsPartOfGameInfoSerialization;
import com.unciv.logic.automation.Automation;
import com.unciv.logic.automation.ThreatLevel;
import com.unciv.logic.automation.civilization.BarbarianAutomation;
import com.unciv.logic.automation.civilization.DiplomacyAutomation;
import com.unciv.logic.automation.civilization.ReligionAutomation;
import com.unciv.logic.automation.civilization.TradeAutomation;
import com.unciv.logic.automation.civilization.UseGoldAutomation;
import com.unciv.logic.automation.unit.EspionageAutomation;
import com.unciv.logic.automation.unit.UnitAutomation;
import com.unciv.logic.battle.AttackableTile;
import com.unciv.logic.battle.Battle;
import com.unciv.logic.battle.BattleDamage;
import com.unciv.logic.battle.ICombatant;
import com.unciv.logic.battle.MapUnitCombatant;
import com.unciv.logic.battle.TargetHelper;
import com.unciv.logic.city.City;
import com.unciv.logic.civilization.AlertType;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.Notification;
import com.unciv.logic.civilization.PopupAlert;
import com.unciv.logic.civilization.diplomacy.CityStateFunctions;
import com.unciv.logic.civilization.diplomacy.Demand;
import com.unciv.logic.civilization.diplomacy.DiplomacyFlags;
import com.unciv.logic.civilization.diplomacy.DiplomacyManager;
import com.unciv.logic.civilization.diplomacy.DiplomaticStatus;
import com.unciv.logic.civilization.diplomacy.RelationshipLevel;
import com.unciv.logic.civilization.managers.GreatPersonManager;
import com.unciv.logic.civilization.managers.PolicyManager;
import com.unciv.logic.civilization.managers.ThreatManager;
import com.unciv.logic.civilization.managers.UnitManager;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.logic.map.mapunit.movement.UnitMovement;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.ruleset.Building;
import com.unciv.models.ruleset.MilestoneType;
import com.unciv.models.ruleset.Policy;
import com.unciv.models.ruleset.PolicyBranch;
import com.unciv.models.ruleset.RulesetObject;
import com.unciv.models.ruleset.Victory;
import com.unciv.models.ruleset.nation.PersonalityValue;
import com.unciv.models.ruleset.tech.Technology;
import com.unciv.models.ruleset.tile.ResourceSupplyList;
import com.unciv.models.ruleset.tile.ResourceType;
import com.unciv.models.ruleset.unique.GameContext;
import com.unciv.models.ruleset.unique.IHasUniques;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.ruleset.unit.BaseUnit;
import com.unciv.models.stats.INamed;
import com.unciv.models.stats.Stat;
import com.unciv.ui.screens.victoryscreen.RankingType;
import com.unciv.utils.CollectionExtensionsKt;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import yairm210.purity.annotations.Readonly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001.B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J'\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u00072\b\b\u0002\u0010\u000f\u001a\u00020\tH\u0001\u00a2\u0006\u0002\b\u0010J\u0010\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u000e\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0018\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0016\u0010\u001b\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\tJ\u000e\u0010\u001f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010 \u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010!\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\"\u001a\u00020\u00052\u0006\u0010#\u001a\u00020\u0007H\u0002J\u0010\u0010$\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J \u0010%\u001a\u00020\u00052\u0006\u0010&\u001a\u00020'2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010(\u001a\u00020\u0007H\u0002J\u0018\u0010)\u001a\u00020\r2\u0006\u0010*\u001a\u00020\u00072\u0006\u0010+\u001a\u00020\u0007H\u0007J\u001a\u0010,\u001a\u0004\u0018\u00010-2\u0006\u0010*\u001a\u00020\u00072\u0006\u0010+\u001a\u00020\u0007H\u0007\u00a8\u0006/"}, d2={"Lcom/unciv/logic/automation/civilization/NextTurnAutomation;", "", "<init>", "()V", "automateCivMoves", "", "civInfo", "Lcom/unciv/logic/civilization/Civilization;", "tradeAndChangeState", "", "automateGoldToSciencePercentage", "respondToPopupAlerts", "valueCityStateAlliance", "", "cityState", "includeQuests", "valueCityStateAlliance$core", "protectCityStates", "bullyCityStates", "chooseTechToResearch", "adoptPolicy", "chooseGreatPerson", "freeUpSpaceResources", "automateUnits", "automateCityConquer", "city", "Lcom/unciv/logic/city/City;", "getUnitPriority", "unit", "Lcom/unciv/logic/map/mapunit/MapUnit;", "isAtWar", "automateCityBombardment", "automateCities", "trainSettler", "tryVoteForDiplomaticVictory", "civ", "issueRequests", "onDemandViolation", "demand", "Lcom/unciv/logic/civilization/diplomacy/Demand;", "otherCiv", "getMinDistanceBetweenCities", "civ1", "civ2", "getClosestCities", "Lcom/unciv/logic/automation/civilization/NextTurnAutomation$CityDistance;", "CityDistance", "core"})
@SourceDebugExtension(value={"SMAP\nNextTurnAutomation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NextTurnAutomation.kt\ncom/unciv/logic/automation/civilization/NextTurnAutomation\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 6 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,619:1\n1788#2,3:620\n1563#2:623\n1634#2,3:624\n1791#2:627\n543#2,4:628\n1761#2,3:632\n548#2:635\n295#2:636\n1761#2,3:637\n296#2:640\n774#2:641\n865#2,2:642\n774#2:644\n865#2,2:645\n1491#2:654\n1516#2,3:655\n1519#2,3:665\n774#2:669\n865#2,2:670\n774#2:672\n865#2,2:673\n295#2,2:675\n295#2,2:677\n774#2:696\n865#2,2:697\n774#2:700\n865#2,2:701\n774#2:703\n865#2,2:704\n774#2:706\n865#2,2:707\n1068#2:709\n1969#2,14:710\n774#2:724\n865#2,2:725\n1761#2,3:729\n774#2:732\n865#2:733\n866#2:736\n827#2:740\n855#2,2:741\n1999#2,14:743\n2423#2,14:757\n1761#2,3:771\n488#3,7:647\n382#3,7:658\n382#3,7:778\n1#4:668\n630#5,3:679\n1923#6,14:682\n608#6:699\n1255#6,2:727\n2275#6,2:734\n1276#6,3:737\n996#6:774\n1025#6,3:775\n1028#6,3:785\n1276#6,3:788\n*S KotlinDebug\n*F\n+ 1 NextTurnAutomation.kt\ncom/unciv/logic/automation/civilization/NextTurnAutomation\n*L\n196#1:620,3\n198#1:623\n198#1:624,3\n196#1:627\n247#1:628,4\n249#1:632,3\n247#1:635\n258#1:636\n260#1:637,3\n258#1:640\n312#1:641\n312#1:642,2\n317#1:644\n317#1:645,2\n326#1:654\n326#1:655,3\n326#1:665,3\n331#1:669\n331#1:670,2\n343#1:672\n343#1:673,2\n348#1:675,2\n352#1:677,2\n381#1:696\n381#1:697,2\n424#1:700\n424#1:701,2\n429#1:703\n429#1:704,2\n438#1:706\n438#1:707,2\n439#1:709\n448#1:710,14\n485#1:724\n485#1:725,2\n518#1:729,3\n523#1:732\n523#1:733\n523#1:736\n531#1:740\n531#1:741,2\n532#1:743,14\n535#1:757,14\n150#1:771,3\n322#1:647,7\n326#1:658,7\n238#1:778,7\n365#1:679,3\n375#1:682,14\n398#1:699\n517#1:727,2\n525#1:734,2\n528#1:737,3\n238#1:774\n238#1:775,3\n238#1:785,3\n402#1:788,3\n*E\n"})
public final class NextTurnAutomation {
    @NotNull
    public static final NextTurnAutomation INSTANCE = new NextTurnAutomation();

    private NextTurnAutomation() {
    }

    public final void automateCivMoves(@NotNull Civilization civInfo, boolean tradeAndChangeState) {
        Intrinsics.checkNotNullParameter(civInfo, "civInfo");
        if (civInfo.isBarbarian()) {
            new BarbarianAutomation(civInfo).automate();
            return;
        }
        if (civInfo.isSpectator()) {
            return;
        }
        this.respondToPopupAlerts(civInfo);
        TradeAutomation.INSTANCE.respondToTradeRequests(civInfo, tradeAndChangeState);
        if (tradeAndChangeState && civInfo.isMajorCiv()) {
            if (!IHasUniques.hasUnique$default(civInfo.getGameInfo().getRuleset().getModOptions(), UniqueType.DiplomaticRelationshipsCannotChange, null, 2, null)) {
                DiplomacyAutomation.INSTANCE.declareWar$core(civInfo);
                DiplomacyAutomation.INSTANCE.offerPeaceTreaty$core(civInfo);
                DiplomacyAutomation.INSTANCE.askForHelp$core(civInfo);
                DiplomacyAutomation.INSTANCE.offerDeclarationOfFriendship$core(civInfo);
            }
            if (civInfo.getGameInfo().isReligionEnabled()) {
                ReligionAutomation.INSTANCE.spendFaithOnReligion(civInfo);
            }
            DiplomacyAutomation.INSTANCE.offerToEstablishEmbassy$core(civInfo);
            DiplomacyAutomation.INSTANCE.offerOpenBorders$core(civInfo);
            DiplomacyAutomation.INSTANCE.offerResearchAgreement$core(civInfo);
            DiplomacyAutomation.INSTANCE.offerDefensivePact$core(civInfo);
            TradeAutomation.INSTANCE.exchangeLuxuries(civInfo);
            this.issueRequests(civInfo);
            this.adoptPolicy(civInfo);
            this.freeUpSpaceResources(civInfo);
        } else if (civInfo.isCityState()) {
            civInfo.getCityStateFunctions().getFreeTechForCityState();
            civInfo.getCityStateFunctions().updateDiplomaticRelationshipForCityState();
        }
        this.chooseTechToResearch(civInfo);
        this.automateCityBombardment(civInfo);
        if (tradeAndChangeState) {
            UseGoldAutomation.INSTANCE.useGold(civInfo);
        }
        if (tradeAndChangeState && !civInfo.isCityState()) {
            this.protectCityStates(civInfo);
            this.bullyCityStates(civInfo);
        }
        this.automateUnits(civInfo);
        if (tradeAndChangeState && civInfo.isMajorCiv()) {
            if (civInfo.getGameInfo().isReligionEnabled()) {
                ReligionAutomation.INSTANCE.chooseReligiousBeliefs$core(civInfo);
            }
            if (civInfo.getGameInfo().isEspionageEnabled()) {
                new EspionageAutomation(civInfo).automateSpies();
            }
        }
        this.automateCities(civInfo);
        if (tradeAndChangeState) {
            this.trainSettler(civInfo);
        }
        this.tryVoteForDiplomaticVictory(civInfo);
    }

    public static /* synthetic */ void automateCivMoves$default(NextTurnAutomation nextTurnAutomation, Civilization civilization, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        nextTurnAutomation.automateCivMoves(civilization, bl);
    }

    public final void automateGoldToSciencePercentage(@NotNull Civilization civInfo) {
        Intrinsics.checkNotNullParameter(civInfo, "civInfo");
        int estimatedIncome = (int)civInfo.getStats().getStatsForNextTurn().getGold();
        int projectedGold = civInfo.getGold() + estimatedIncome;
        int pissPoor = civInfo.getTech().getEra().getBaseUnitBuyCost();
        int stinkingRich = civInfo.getTech().getEra().getStartingGold() * 10 + civInfo.getCities().size() * 2 * pissPoor;
        float maxPercent = 0.8f;
        civInfo.getTech().setGoldPercentConvertedToScience(civInfo.getGold() <= 0 ? 0.0f : (projectedGold <= pissPoor ? 0.0f : RangesKt.coerceAtMost((float)(projectedGold - pissPoor) * maxPercent / (float)stinkingRich, maxPercent)));
    }

    private final void respondToPopupAlerts(Civilization civInfo) {
        for (PopupAlert popupAlert : CollectionsKt.toList((Iterable)civInfo.getPopupAlerts())) {
            String[] stringArray;
            DiplomacyManager diploManager;
            for (Demand demand : Demand.getEntries()) {
                DiplomacyManager diploManager2;
                if (popupAlert.getType() != demand.getDemandAlert()) continue;
                Civilization demandingCiv = civInfo.getGameInfo().getCivilization(popupAlert.getValue());
                Intrinsics.checkNotNull(civInfo.getDiplomacyManager(demandingCiv));
                if (Automation.INSTANCE.threatAssessment(civInfo, demandingCiv).compareTo((Enum)ThreatLevel.High) >= 0 || diploManager2.isRelationshipLevelGT(RelationshipLevel.Ally)) {
                    diploManager2.agreeToDemand(demand);
                    continue;
                }
                diploManager2.refuseDemand(demand);
            }
            if (popupAlert.getType() != AlertType.DeclarationOfFriendship) continue;
            Civilization requestingCiv = civInfo.getGameInfo().getCivilization(popupAlert.getValue());
            Intrinsics.checkNotNull(civInfo.getDiplomacyManager(requestingCiv));
            if (civInfo.getDiplomacyFunctions().canSignDeclarationOfFriendshipWith(requestingCiv) && DiplomacyAutomation.INSTANCE.wantsToSignDeclarationOfFrienship$core(civInfo, requestingCiv)) {
                diploManager.signDeclarationOfFriendship();
                stringArray = new String[]{"OtherIcons/Diplomacy", civInfo.getCivName()};
                requestingCiv.addNotification("We have signed a Declaration of Friendship with [" + civInfo.getCivName() + "]!", Notification.NotificationCategory.Diplomacy, stringArray);
                continue;
            }
            diploManager.otherCivDiplomacy().setFlag(DiplomacyFlags.DeclinedDeclarationOfFriendship, 10);
            stringArray = new String[]{"OtherIcons/Diplomacy", civInfo.getCivName()};
            requestingCiv.addNotification('[' + civInfo.getCivName() + "] has denied our Declaration of Friendship!", Notification.NotificationCategory.Diplomacy, stringArray);
        }
        civInfo.getPopupAlerts().clear();
    }

    /*
     * Unable to fully structure code
     */
    @Readonly
    public final int valueCityStateAlliance$core(@NotNull Civilization civInfo, @NotNull Civilization cityState, boolean includeQuests) {
        block19: {
            block18: {
                Intrinsics.checkNotNullParameter(civInfo, "civInfo");
                Intrinsics.checkNotNullParameter(cityState, "cityState");
                if (!cityState.isCityState()) {
                    return 0;
                }
                value = 0;
                civPersonality = civInfo.getPersonality();
                bonuses = SequencesKt.toList(CityStateFunctions.Companion.getCityStateBonuses$default(CityStateFunctions.Companion, cityState.getCityStateType(), RelationshipLevel.Ally, null, 4, null));
                if (NextTurnAutomation.valueCityStateAlliance$canProvideStat(bonuses, Stat.Culture)) {
                    value += (int)civPersonality.get(PersonalityValue.Culture) - 5;
                }
                if (NextTurnAutomation.valueCityStateAlliance$canProvideStat(bonuses, Stat.Faith)) {
                    value += (int)civPersonality.get(PersonalityValue.Faith) - 5;
                }
                if (NextTurnAutomation.valueCityStateAlliance$canProvideStat(bonuses, Stat.Production)) {
                    value += (int)civPersonality.get(PersonalityValue.Production) - 5;
                }
                if (NextTurnAutomation.valueCityStateAlliance$canProvideStat(bonuses, Stat.Science)) {
                    value += (int)civPersonality.get(PersonalityValue.Science) - 5;
                }
                if (NextTurnAutomation.valueCityStateAlliance$canProvideStat(bonuses, Stat.Happiness)) {
                    if (civInfo.getHappiness() < 10) {
                        value += 10 - civInfo.getHappiness();
                    }
                    value += (int)civPersonality.get(PersonalityValue.Happiness) - 5;
                }
                if (NextTurnAutomation.valueCityStateAlliance$canProvideStat(bonuses, Stat.Food)) {
                    value += 5;
                    value += (int)civPersonality.get(PersonalityValue.Food) - 5;
                }
                if (!cityState.isAlive() || cityState.getCities().isEmpty() || civInfo.getCities().isEmpty()) {
                    return value;
                }
                if (civInfo.knows(cityState)) {
                    v0 = cityState.getDiplomacyManager(civInfo);
                    Intrinsics.checkNotNull(v0);
                    v1 = (int)v0.getInfluence();
                } else {
                    v1 = 0;
                }
                ourInfluence = v1;
                value += Math.min(10, ourInfluence / 10);
                if (ourInfluence < 30) {
                    value -= 5;
                }
                if (cityState.getAllyCivName() != null && !Intrinsics.areEqual(cityState.getAllyCivName(), civInfo.getCivName())) {
                    v2 = cityState.getAllyCivName();
                    Intrinsics.checkNotNull(v2);
                    v3 = cityState.getDiplomacyManager(v2);
                    Intrinsics.checkNotNull(v3);
                    thirdCivInfluence = (int)v3.getInfluence();
                    value -= (thirdCivInfluence - 30) / 10;
                }
                thirdCivInfluence = cityState.getDetailedCivResources();
                var25_10 = value;
                $i$f$count = false;
                if (!($this$count$iv instanceof Collection) || !((Collection)$this$count$iv).isEmpty()) break block18;
                v4 = 0;
                break block19;
            }
            count$iv = 0;
            for (T element$iv : $this$count$iv) {
                it = (ResourceSupplyList.ResourceSupply)element$iv;
                $i$a$-count-NextTurnAutomation$valueCityStateAlliance$1 = false;
                if (it.getResource().getResourceType() != ResourceType.Luxury) ** GOTO lbl-1000
                $this$map$iv = civInfo.getDetailedCivResources();
                $i$f$map = false;
                var17_19 = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    var22_24 = (ResourceSupplyList.ResourceSupply)item$iv$iv;
                    var23_25 = destination$iv$iv;
                    $i$a$-map-NextTurnAutomation$valueCityStateAlliance$1$1 = false;
                    var23_25.add(supply.getResource());
                }
                if (!((List)destination$iv$iv).contains(it.getResource())) {
                    v5 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v5 = false;
                }
                if (!v5 || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            v4 = count$iv;
        }
        var26_27 = v4;
        value = var25_10 + var26_27;
        if (includeQuests) {
            value += (int)(cityState.getQuestManager().getInvestmentMultiplier(civInfo.getCivName()) * (float)10) - 10;
        }
        return value;
    }

    public static /* synthetic */ int valueCityStateAlliance$core$default(NextTurnAutomation nextTurnAutomation, Civilization civilization, Civilization civilization2, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return nextTurnAutomation.valueCityStateAlliance$core(civilization, civilization2, bl);
    }

    private final void protectCityStates(Civilization civInfo) {
        Iterator<Civilization> iterator2 = SequencesKt.filter(civInfo.getKnownCivs(), NextTurnAutomation::protectCityStates$lambda$3).iterator();
        while (iterator2.hasNext()) {
            Civilization state = iterator2.next();
            if (!state.getCityStateFunctions().otherCivCanPledgeProtection(civInfo)) continue;
            state.getCityStateFunctions().addProtectorCiv(civInfo);
        }
    }

    private final void bullyCityStates(Civilization civInfo) {
        for (Civilization state : SequencesKt.toList(SequencesKt.filter(civInfo.getKnownCivs(), NextTurnAutomation::bullyCityStates$lambda$4))) {
            DiplomacyManager diplomacyManager;
            Intrinsics.checkNotNull(state.getDiplomacyManager(civInfo.getCivName()));
            if (!diplomacyManager.isRelationshipLevelLT(RelationshipLevel.Friend) || diplomacyManager.getDiplomaticStatus() != DiplomaticStatus.Peace || NextTurnAutomation.valueCityStateAlliance$core$default(this, civInfo, state, false, 4, null) > 0 || CityStateFunctions.getTributeWillingness$default(state.getCityStateFunctions(), civInfo, false, 2, null) < 0) continue;
            if (state.getCityStateFunctions().getTributeWillingness(civInfo, true) > 0) {
                state.getCityStateFunctions().tributeWorker(civInfo);
                continue;
            }
            state.getCityStateFunctions().tributeGold(civInfo);
        }
    }

    private final void chooseTechToResearch(Civilization civInfo) {
        Technology it;
        boolean $i$f$any;
        Iterable $this$any$iv;
        List<Technology> it2;
        List<Technology> element$iv;
        List<List<Technology>> costs;
        GameContext stateForConditionals = civInfo.getState();
        while (civInfo.getTech().getFreeTechs() > 0) {
            List<Technology> list2;
            List<Technology> list3;
            block17: {
                costs = NextTurnAutomation.chooseTechToResearch$getGroupedResearchableTechs(civInfo);
                if (costs.isEmpty()) {
                    return;
                }
                List<List<Technology>> $this$lastOrNull$iv = costs;
                boolean $i$f$lastOrNull = false;
                ListIterator<List<Technology>> iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
                while (iterator$iv.hasPrevious()) {
                    boolean bl;
                    block16: {
                        it2 = element$iv = iterator$iv.previous();
                        boolean bl2 = false;
                        $this$any$iv = it2;
                        $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (Object element$iv2 : $this$any$iv) {
                                it = (Technology)element$iv2;
                                boolean bl3 = false;
                                if (!(it.getWeightForAiDecision(stateForConditionals) > 0.0f)) continue;
                                bl = true;
                                break block16;
                            }
                            bl = false;
                        }
                    }
                    if (!bl) continue;
                    list3 = element$iv;
                    break block17;
                }
                list3 = null;
            }
            if ((list2 = (List<Technology>)list3) == null) {
                list2 = CollectionsKt.last(costs);
            }
            List<Technology> mostExpensiveTechs = list2;
            Technology chosenTech = (Technology)CollectionExtensionsKt.randomWeighted$default(mostExpensiveTechs, null, arg_0 -> NextTurnAutomation.chooseTechToResearch$lambda$9(stateForConditionals, arg_0), 1, null);
            civInfo.getTech().getFreeTechnology(chosenTech.getName());
        }
        if (civInfo.getTech().getTechsToResearch().isEmpty()) {
            Technology technology;
            List<Technology> cheapestTechs;
            List<Technology> list4;
            List<Technology> list5;
            block19: {
                costs = NextTurnAutomation.chooseTechToResearch$getGroupedResearchableTechs(civInfo);
                if (costs.isEmpty()) {
                    return;
                }
                Iterable $this$firstOrNull$iv = costs;
                boolean $i$f$firstOrNull = false;
                Iterator iterator2 = $this$firstOrNull$iv.iterator();
                while (iterator2.hasNext()) {
                    boolean bl;
                    block18: {
                        it2 = element$iv = iterator2.next();
                        boolean bl4 = false;
                        $this$any$iv = it2;
                        $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (Object element$iv2 : $this$any$iv) {
                                it = (Technology)element$iv2;
                                boolean bl5 = false;
                                if (!(it.getWeightForAiDecision(stateForConditionals) > 0.0f)) continue;
                                bl = true;
                                break block18;
                            }
                            bl = false;
                        }
                    }
                    if (!bl) continue;
                    list5 = element$iv;
                    break block19;
                }
                list5 = null;
            }
            if ((list4 = (List<Technology>)list5) == null) {
                list4 = CollectionsKt.first(costs);
            }
            if ((cheapestTechs = list4).size() == 1 || costs.size() == 1) {
                technology = (Technology)CollectionExtensionsKt.randomWeighted$default(cheapestTechs, null, arg_0 -> NextTurnAutomation.chooseTechToResearch$lambda$12(stateForConditionals, arg_0), 1, null);
            } else {
                List<Technology> techsAdvanced = costs.get(1);
                technology = (Technology)CollectionExtensionsKt.randomWeighted$default(CollectionsKt.plus((Collection)cheapestTechs, (Iterable)techsAdvanced), null, arg_0 -> NextTurnAutomation.chooseTechToResearch$lambda$13(stateForConditionals, arg_0), 1, null);
            }
            Technology techToResearch = technology;
            civInfo.getTech().getTechsToResearch().add(techToResearch.getName());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void adoptPolicy(Civilization civInfo) {
        while (civInfo.getPolicies().canAdoptPolicy()) {
            Policy policy;
            Object object;
            Iterator $this$groupByTo$iv$iv;
            void $this$groupBy$iv;
            Set set;
            Iterable $this$filterTo$iv$iv;
            boolean $i$f$filterTo;
            Collection destination$iv$iv;
            boolean $i$f$filter;
            Iterable $this$filter$iv;
            Set<PolicyBranch> incompleteBranches = civInfo.getPolicies().getIncompleteBranches();
            Set<PolicyBranch> adoptableBranches = civInfo.getPolicies().getAdoptableBranches();
            if (incompleteBranches.isEmpty() && adoptableBranches.isEmpty()) {
                return;
            }
            Map<PolicyBranch, Integer> priorityMap = civInfo.getPolicies().getPriorityMap();
            Integer maxIncompletePriority = null;
            maxIncompletePriority = civInfo.getPolicies().getMaxPriority(incompleteBranches);
            Integer maxAdoptablePriority = null;
            maxAdoptablePriority = civInfo.getPolicies().getMaxPriority(adoptableBranches);
            if (maxIncompletePriority == null) {
                Integer n = maxAdoptablePriority;
                Intrinsics.checkNotNull(n);
                maxIncompletePriority = ((Number)n).intValue() - 1;
            }
            if (maxAdoptablePriority == null) {
                maxAdoptablePriority = ((Number)maxIncompletePriority).intValue() - 1;
            }
            if (((Number)maxAdoptablePriority).intValue() <= ((Number)maxIncompletePriority).intValue()) {
                $this$filter$iv = incompleteBranches;
                $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                destination$iv$iv = new ArrayList();
                $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    PolicyBranch it = (PolicyBranch)element$iv$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual(priorityMap.get(it), maxIncompletePriority)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                set = CollectionsKt.toSet((List)destination$iv$iv);
            } else {
                $this$filter$iv = adoptableBranches;
                $i$f$filter = false;
                $this$filterTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList();
                $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    PolicyBranch it = (PolicyBranch)element$iv$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual(priorityMap.get(it), maxAdoptablePriority)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                set = CollectionsKt.toSet((List)destination$iv$iv);
            }
            Set candidates = set;
            Map<PolicyBranch, Integer> $this$filterKeys$iv = civInfo.getPolicies().getBranchCompletionMap();
            boolean $i$f$filterKeys22 = false;
            LinkedHashMap<PolicyBranch, Integer> result$iv = new LinkedHashMap<PolicyBranch, Integer>();
            for (Map.Entry<PolicyBranch, Integer> entry$iv : $this$filterKeys$iv.entrySet()) {
                PolicyBranch key = entry$iv.getKey();
                boolean bl = false;
                if (!candidates.contains(key)) continue;
                result$iv.put(entry$iv.getKey(), entry$iv.getValue());
            }
            Map candidateCompletionMap = result$iv;
            Iterable $i$f$filterKeys22 = candidateCompletionMap.entrySet();
            boolean $i$f$groupBy22 = false;
            Iterator<Map.Entry<PolicyBranch, Integer>> $i$f$filterTo2 = $this$groupBy$iv;
            Object destination$iv$iv2 = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            Iterator bl = $this$groupByTo$iv$iv.iterator();
            while (bl.hasNext()) {
                Object object2;
                Object element$iv$iv = bl.next();
                Map.Entry it = (Map.Entry)element$iv$iv;
                boolean bl2 = false;
                Integer key$iv$iv = ((PolicyBranch)it.getKey()).getPolicies().size() - ((Number)it.getValue()).intValue();
                Map<Integer, List> $this$getOrPut$iv$iv$iv = destination$iv$iv2;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl3 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object2 = answer$iv$iv$iv;
                } else {
                    object2 = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object2;
                list$iv$iv.add(element$iv$iv);
            }
            Iterable $i$f$groupBy22 = destination$iv$iv2.entrySet();
            $this$groupByTo$iv$iv = $i$f$groupBy22.iterator();
            if (!$this$groupByTo$iv$iv.hasNext()) {
                object = null;
            } else {
                destination$iv$iv2 = $this$groupByTo$iv$iv.next();
                if (!$this$groupByTo$iv$iv.hasNext()) {
                    object = destination$iv$iv2;
                } else {
                    Map.Entry it22 = (Map.Entry)destination$iv$iv2;
                    boolean bl42 = false;
                    int it22 = ((Number)it22.getKey()).intValue();
                    do {
                        Object bl42 = $this$groupByTo$iv$iv.next();
                        Map.Entry it = (Map.Entry)bl42;
                        boolean $i$a$-minByOrNull-NextTurnAutomation$adoptPolicy$targetBranch$3 = false;
                        int n = ((Number)it.getKey()).intValue();
                        if (it22 <= n) continue;
                        destination$iv$iv2 = bl42;
                        it22 = n;
                    } while ($this$groupByTo$iv$iv.hasNext());
                    object = destination$iv$iv2;
                }
            }
            Map.Entry entry = (Map.Entry)object;
            Intrinsics.checkNotNull(entry);
            PolicyBranch targetBranch = (PolicyBranch)((Map.Entry)CollectionsKt.random((Collection)entry.getValue(), Random.Default)).getKey();
            if (PolicyManager.isAdoptable$default(civInfo.getPolicies(), targetBranch, false, 2, null)) {
                policy = targetBranch;
            } else {
                void $this$filterTo$iv$iv2;
                Iterable $this$filter$iv2 = targetBranch.getPolicies();
                boolean $i$f$filter2 = false;
                destination$iv$iv2 = $this$filter$iv2;
                Collection destination$iv$iv3 = new ArrayList();
                boolean $i$f$filterTo3 = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                    Policy it = (Policy)element$iv$iv;
                    boolean bl5 = false;
                    if (!PolicyManager.isAdoptable$default(civInfo.getPolicies(), it, false, 2, null)) continue;
                    destination$iv$iv3.add(element$iv$iv);
                }
                policy = (Policy)CollectionExtensionsKt.randomWeighted$default((List)destination$iv$iv3, null, arg_0 -> NextTurnAutomation.adoptPolicy$lambda$20(civInfo, arg_0), 1, null);
            }
            Policy policyToAdopt = policy;
            PolicyManager.adopt$default(civInfo.getPolicies(), policyToAdopt, false, 2, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void chooseGreatPerson(@NotNull Civilization civInfo) {
        Object v3;
        UnitManager unitManager;
        BaseUnit baseUnit;
        BaseUnit greatPerson;
        Object object;
        boolean mayanGreatPerson;
        block10: {
            Object v2;
            INamed it;
            boolean $i$f$firstOrNull;
            Iterable $this$firstOrNull$iv;
            block9: {
                Collection greatPeople;
                Collection collection;
                Intrinsics.checkNotNullParameter(civInfo, "civInfo");
                if (civInfo.getGreatPeople().getFreeGreatPeople() == 0) {
                    return;
                }
                boolean bl = mayanGreatPerson = civInfo.getGreatPeople().getMayaLimitedFreeGP() > 0;
                if (mayanGreatPerson) {
                    void $this$filterTo$iv$iv;
                    Iterable $this$filter$iv = civInfo.getGreatPeople().getGreatPeople();
                    boolean $i$f$filter = false;
                    object = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        BaseUnit it2 = (BaseUnit)element$iv$iv;
                        boolean bl2 = false;
                        if (!civInfo.getGreatPeople().getLongCountGPPool().contains(it2.getName())) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    collection = (List)destination$iv$iv;
                } else {
                    collection = greatPeople = (Collection)civInfo.getGreatPeople().getGreatPeople();
                }
                if (greatPeople.isEmpty()) {
                    return;
                }
                greatPerson = (BaseUnit)CollectionsKt.random(greatPeople, Random.Default);
                $this$firstOrNull$iv = greatPeople;
                $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    it = (BaseUnit)element$iv;
                    boolean bl3 = false;
                    if (!((RulesetObject)it).getUniques().contains("Great Person - [Science]")) continue;
                    v2 = element$iv;
                    break block9;
                }
                v2 = null;
            }
            BaseUnit scienceGP = v2;
            if (scienceGP != null) {
                greatPerson = scienceGP;
            }
            $this$firstOrNull$iv = civInfo.getCities();
            baseUnit = greatPerson;
            unitManager = civInfo.getUnits();
            $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                it = (City)element$iv;
                boolean bl = false;
                if (!((City)it).isCapital()) continue;
                v3 = element$iv;
                break block10;
            }
            v3 = null;
        }
        Object var15_20 = v3;
        unitManager.addUnit(baseUnit, (City)var15_20);
        object = civInfo.getGreatPeople();
        int n = ((GreatPersonManager)object).getFreeGreatPeople();
        ((GreatPersonManager)object).setFreeGreatPeople(n + -1);
        if (mayanGreatPerson) {
            civInfo.getGreatPeople().getLongCountGPPool().remove(greatPerson.getName());
            object = civInfo.getGreatPeople();
            n = ((GreatPersonManager)object).getMayaLimitedFreeGP();
            ((GreatPersonManager)object).setMayaLimitedFreeGP(n + -1);
        }
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private final void freeUpSpaceResources(Civilization civInfo) {
        block15: {
            $this$none$iv = civInfo.getGameInfo().getRuleset().getVictories();
            $i$f$none = false;
            if ($this$none$iv.isEmpty()) {
                v0 = true;
            } else {
                for (Object element$iv : $this$none$iv.entrySet()) {
                    it = element$iv;
                    $i$a$-none-NextTurnAutomation$freeUpSpaceResources$1 = false;
                    v1 = civInfo.getVictoryManager().getNextMilestone((Victory)it.getValue());
                    if (!((v1 != null ? v1.getType() : null) == MilestoneType.AddedSSPartsInCapital)) continue;
                    v0 = false;
                    break block15;
                }
                v0 = true;
            }
        }
        if (v0) {
            return;
        }
        v2 = civInfo.getGameInfo().getSpaceResources().iterator();
        Intrinsics.checkNotNullExpressionValue(v2, "iterator(...)");
        var2_2 = v2;
        block1: while (var2_2.hasNext()) {
            Intrinsics.checkNotNullExpressionValue(var2_2.next(), "next(...)");
            if (civInfo.getResourceAmount(resource) >= 2) continue;
            element$iv = SequencesKt.filter(civInfo.getUnits().getCivUnits(), (Function1<MapUnit, Boolean>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, freeUpSpaceResources$lambda$25(java.lang.String com.unciv.logic.map.mapunit.MapUnit ), (Lcom/unciv/logic/map/mapunit/MapUnit;)Ljava/lang/Boolean;)((String)resource));
            $i$f$minByOrNull = false;
            iterator$iv = $this$minByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v3 = null;
            } else {
                minElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v3 = minElem$iv;
                } else {
                    it = (MapUnit)minElem$iv;
                    $i$a$-minByOrNull-NextTurnAutomation$freeUpSpaceResources$unitToDisband$2 = false;
                    minValue$iv = it.getForceEvaluation();
                    do {
                        e$iv /* !! */  = iterator$iv.next();
                        it = (MapUnit)e$iv /* !! */ ;
                        $i$a$-minByOrNull-NextTurnAutomation$freeUpSpaceResources$unitToDisband$2 = false;
                        v$iv = it.getForceEvaluation();
                        if (minValue$iv <= v$iv) continue;
                        minElem$iv = e$iv /* !! */ ;
                        minValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v3 = minElem$iv;
                }
            }
            v4 = unitToDisband = (MapUnit)v3;
            if (v4 != null) {
                v4.disband();
            }
            for (City city : civInfo.getCities()) {
                if (city.getHasSoldBuildingThisTurn()) continue;
                v5 = civInfo.getGameInfo().getRuleset().getBuildings().values();
                Intrinsics.checkNotNullExpressionValue(v5, "<get-values>(...)");
                $this$filter$iv = v5;
                $i$f$filter = false;
                e$iv /* !! */  = $this$filter$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    it = (Building)element$iv$iv;
                    $i$a$-filter-NextTurnAutomation$freeUpSpaceResources$buildingToSell$1 = false;
                    if (!city.getCityConstructions().isBuilt(it.getName()) || !it.requiredResources(city.getState()).contains(resource) || !it.isSellable()) ** GOTO lbl-1000
                    v6 = civInfo.getCivConstructions();
                    Intrinsics.checkNotNull(it);
                    if (!v6.hasFreeBuilding(city, it)) {
                        v7 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v7 = false;
                    }
                    if (!v7) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                buildingToSell = (Building)CollectionsKt.randomOrNull((List)destination$iv$iv, Random.Default);
                if (buildingToSell == null) continue;
                city.sellBuilding(buildingToSell);
                continue block1;
            }
        }
    }

    private final void automateUnits(Civilization civInfo) {
        boolean isAtWar = civInfo.isAtWar();
        Sequence<MapUnit> $this$sortedBy$iv = civInfo.getUnits().getCivUnits();
        boolean $i$f$sortedBy = false;
        Sequence<MapUnit> sortedUnits = SequencesKt.sortedWith($this$sortedBy$iv, new Comparator(isAtWar){
            final /* synthetic */ boolean $isAtWar$inlined;
            {
                this.$isAtWar$inlined = bl;
            }

            public final int compare(T a, T b) {
                MapUnit unit = (MapUnit)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(NextTurnAutomation.INSTANCE.getUnitPriority(unit, this.$isAtWar$inlined));
                unit = (MapUnit)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, NextTurnAutomation.INSTANCE.getUnitPriority(unit, this.$isAtWar$inlined));
            }
        });
        List<City> citiesRequiringManualPlacement = SequencesKt.toList(SequencesKt.filter(SequencesKt.flatMapIterable(SequencesKt.filter(civInfo.getKnownCivs(), arg_0 -> NextTurnAutomation.automateUnits$lambda$29(civInfo, arg_0)), NextTurnAutomation::automateUnits$lambda$30), arg_0 -> NextTurnAutomation.automateUnits$lambda$32(civInfo, arg_0)));
        for (City city : citiesRequiringManualPlacement) {
            this.automateCityConquer(civInfo, city);
        }
        Iterator<IsPartOfGameInfoSerialization> iterator2 = sortedUnits.iterator();
        while (iterator2.hasNext()) {
            MapUnit unit = (MapUnit)iterator2.next();
            UnitAutomation.INSTANCE.automateUnitMoves(unit);
        }
    }

    private final void automateCityConquer(Civilization civInfo, City city) {
        boolean bl;
        MapUnit it;
        Iterable $this$filterTo$iv$iv;
        Object $this$filter$iv = NextTurnAutomation.automateCityConquer$ourUnitsInRange(city, civInfo, 7);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (MapUnit)element$iv$iv;
            bl = false;
            if (!it.getBaseUnit().isAirUnit()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (MapUnit unit : (List)destination$iv$iv) {
            UnitAutomation.INSTANCE.automateUnitMoves(unit);
        }
        if (city.getHealth() != 1) {
            $this$filter$iv = NextTurnAutomation.automateCityConquer$ourUnitsInRange(city, civInfo, 4);
            $i$f$filter = false;
            $this$filterTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (MapUnit)element$iv$iv;
                bl = false;
                if (!it.getBaseUnit().isProbablySiegeUnit()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List seigeUnits = (List)destination$iv$iv;
            for (MapUnit unit : seigeUnits) {
                if (MapUnit.hasUnique$default(unit, UniqueType.MustSetUp, null, false, 6, null) && !unit.isSetUpForSiege()) continue;
                NextTurnAutomation.automateCityConquer$attackIfPossible(unit, city.getCenterTile());
            }
        }
        $this$filter$iv = NextTurnAutomation.automateCityConquer$ourUnitsInRange(city, civInfo, 5);
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (MapUnit)element$iv$iv;
            bl = false;
            if (!it.getBaseUnit().isMelee()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List meleeUnits = (List)destination$iv$iv;
        Iterable $this$sortedByDescending$iv = meleeUnits;
        boolean $i$f$sortedByDescending = false;
        for (MapUnit unit : CollectionsKt.sortedWith($this$sortedByDescending$iv, new Comparator(){

            public final int compare(T a, T b) {
                MapUnit it = (MapUnit)b;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getBaseUnit().getForceEvaluation());
                it = (MapUnit)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, it.getBaseUnit().getForceEvaluation());
            }
        })) {
            Object t;
            if (city.getHealth() < city.getMaxHealth$core() / 5) {
                NextTurnAutomation.automateCityConquer$attackIfPossible(unit, city.getCenterTile());
            }
            List<Tile> tilesToTarget = SequencesKt.toList(city.getCenterTile().getTilesInDistance(4));
            ArrayList attackableEnemies = TargetHelper.getAttackableEnemies$default(TargetHelper.INSTANCE, unit, UnitMovement.getDistanceToTiles$default(unit.getMovement(), false, null, null, false, 15, null), tilesToTarget, false, 8, null);
            if (attackableEnemies.isEmpty()) continue;
            Iterable $this$maxBy$iv = attackableEnemies;
            boolean $i$f$maxByOrThrow = false;
            Iterator iterator$iv = $this$maxBy$iv.iterator();
            if (!iterator$iv.hasNext()) {
                throw new NoSuchElementException();
            }
            Object maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                t = maxElem$iv;
            } else {
                AttackableTile it2 = (AttackableTile)maxElem$iv;
                boolean bl2 = false;
                ICombatant iCombatant = new MapUnitCombatant(unit);
                ICombatant iCombatant2 = it2.getCombatant();
                Intrinsics.checkNotNull(iCombatant2);
                int maxValue$iv = BattleDamage.INSTANCE.calculateDamageToDefender(iCombatant, iCombatant2, it2.getTileToAttackFrom(), 0.5f);
                do {
                    Object e$iv = iterator$iv.next();
                    AttackableTile it3 = (AttackableTile)e$iv;
                    boolean bl3 = false;
                    ICombatant iCombatant3 = new MapUnitCombatant(unit);
                    ICombatant iCombatant4 = it3.getCombatant();
                    Intrinsics.checkNotNull(iCombatant4);
                    int v$iv = BattleDamage.INSTANCE.calculateDamageToDefender(iCombatant3, iCombatant4, it3.getTileToAttackFrom(), 0.5f);
                    if (maxValue$iv >= v$iv) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                t = maxElem$iv;
            }
            AttackableTile enemyWeWillDamageMost = (AttackableTile)t;
            Battle.INSTANCE.moveAndAttack(new MapUnitCombatant(unit), enemyWeWillDamageMost);
        }
    }

    public final int getUnitPriority(@NotNull MapUnit unit, boolean isAtWar) {
        Intrinsics.checkNotNullParameter(unit, "unit");
        if (MapUnit.hasUnique$default(unit, UniqueType.SpaceshipPart, null, false, 6, null)) {
            return 0;
        }
        if (unit.isCivilian() && MapUnit.hasUnique$default(unit, UniqueType.FoundCity, null, false, 6, null)) {
            return 1;
        }
        if (unit.isCivilian() && !unit.isGreatPersonOfType("War")) {
            return 2;
        }
        if (unit.getBaseUnit().isAirUnit()) {
            return unit.canIntercept() ? 2 : (unit.isNuclearWeapon() ? 3 : (!MapUnit.hasUnique$default(unit, UniqueType.SelfDestructs, null, false, 6, null) ? 4 : 5));
        }
        int distance = !isAtWar ? 0 : ThreatManager.getDistanceToClosestEnemyUnit$default(unit.getCiv().getThreatManager(), unit.getTile(), 6, false, 4, null);
        return distance + unit.getHealth() / 10 - unit.getPromotions().getNumberOfPromotions() + (unit.getBaseUnit().isRanged() ? 10 : (unit.getBaseUnit().isMelee() ? 30 : (unit.isGreatPersonOfType("War") ? 100 : 1)));
    }

    public final void automateCityBombardment(@NotNull Civilization civInfo) {
        Intrinsics.checkNotNullParameter(civInfo, "civInfo");
        for (City city : civInfo.getCities()) {
            UnitAutomation.INSTANCE.tryBombardEnemy(city);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void automateCities(@NotNull Civilization civInfo) {
        Iterator $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter(civInfo, "civInfo");
        int ownMilitaryStrength = civInfo.getStatForRanking(RankingType.Force);
        Iterable iterable = civInfo.getGameInfo().getCivilizations();
        boolean $i$f$filter = false;
        void var6_7 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo2 = false;
        Iterator iterator2 = $this$filterTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv$iv = iterator2.next();
            Civilization it = (Civilization)element$iv$iv;
            boolean bl = false;
            if (!(!Intrinsics.areEqual(it, civInfo) && !it.isBarbarian() && civInfo.isAtWarWith(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        int n = 0;
        for (Object t : $this$filter$iv) {
            void it;
            Civilization $i$f$filterTo2 = (Civilization)t;
            int n2 = n;
            boolean bl = false;
            int n3 = it.getStatForRanking(RankingType.Force);
            n = n2 + n3;
        }
        int sumOfEnemiesMilitaryStrength = n;
        boolean civHasSignificantlyWeakerMilitaryThanEnemies = (float)ownMilitaryStrength < (float)sumOfEnemiesMilitaryStrength * 0.66f;
        for (City city : civInfo.getCities()) {
            if (city.isPuppet() && city.getPopulation().getPopulation() > 9 && !city.isInResistance() && !Civilization.hasUnique$default(civInfo, UniqueType.MayNotAnnexCities, null, 2, null) && civInfo.getStats().getStatsForNextTurn().getHappiness() > (float)(city.getPopulation().getPopulation() * 2 - 8)) {
                city.annexCity();
            }
            if (city.getHealth() < city.getMaxHealth$core() || civHasSignificantlyWeakerMilitaryThanEnemies) {
                Automation.INSTANCE.tryTrainMilitaryUnit(city);
                if (!((Collection)city.getCityConstructions().getConstructionQueue()).isEmpty()) continue;
            }
            city.getCityConstructions().chooseNextConstruction();
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void trainSettler(Civilization civInfo) {
        block32: {
            block31: {
                personality = civInfo.getPersonality();
                if (civInfo.isCityState()) {
                    return;
                }
                if (civInfo.isOneCityChallenger()) {
                    return;
                }
                if (civInfo.isAtWar()) {
                    return;
                }
                if (CollectionsKt.none((Iterable)civInfo.getCities())) {
                    return;
                }
                if (civInfo.getHappiness() <= civInfo.getCities().size()) {
                    return;
                }
                $this$any$iv = civInfo.getUnits().getCivUnits();
                $i$f$any = false;
                var5_6 = $this$any$iv.iterator();
                while (var5_6.hasNext()) {
                    element$iv = var5_6.next();
                    it = element$iv;
                    $i$a$-any-NextTurnAutomation$trainSettler$1 = false;
                    if (!MapUnit.hasUnique$default((MapUnit)it, UniqueType.FoundCity, GameContext.Companion.getIgnoreConditionals(), false, 4, null)) continue;
                    v0 = true;
                    break block31;
                }
                v0 = false;
            }
            if (v0) {
                return;
            }
            $this$any$iv = civInfo.getCities();
            $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                v1 = false;
            } else {
                var5_6 = $this$any$iv.iterator();
                while (var5_6.hasNext()) {
                    element$iv = var5_6.next();
                    it = (City)element$iv;
                    $i$a$-any-NextTurnAutomation$trainSettler$2 = false;
                    currentConstruction = it.getCityConstructions().getCurrentConstruction();
                    if (!(currentConstruction instanceof BaseUnit != false && ((BaseUnit)currentConstruction).isCityFounder() != false)) continue;
                    v1 = true;
                    break block32;
                }
                v1 = false;
            }
        }
        if (v1) {
            return;
        }
        v2 = civInfo.getGameInfo().getRuleset().getUnits().values();
        Intrinsics.checkNotNullExpressionValue(v2, "<get-values>(...)");
        $i$f$any = v2;
        $i$f$filter = false;
        element$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (E element$iv$iv : $this$filterTo$iv$iv) {
            block33: {
                it = (BaseUnit)element$iv$iv;
                $i$a$-filter-NextTurnAutomation$trainSettler$settlerUnits$1 = false;
                if (!it.isCityFounder() || !it.isBuildable(civInfo)) ** GOTO lbl-1000
                var13_37 = personality.getMatchingUniques(UniqueType.WillNotBuild, civInfo.getState());
                $i$f$none = false;
                for (T element$iv : $this$none$iv) {
                    unique = (Unique)element$iv;
                    $i$a$-none-NextTurnAutomation$trainSettler$settlerUnits$1$1 = false;
                    if (!BaseUnit.matchesFilter$default(it, unique.getParams().get(0), civInfo.getState(), false, 4, null)) continue;
                    v3 = false;
                    break block33;
                }
                v3 = true;
            }
            if (v3) {
                v4 = true;
            } else lbl-1000:
            // 2 sources

            {
                v4 = false;
            }
            if (!v4) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        settlerUnits = (List)destination$iv$iv;
        if (settlerUnits.isEmpty()) {
            return;
        }
        $this$count$iv = civInfo.getUnits().getCivUnits();
        $i$f$count = false;
        count$iv = 0;
        destination$iv$iv = $this$count$iv.iterator();
        while (destination$iv$iv.hasNext()) {
            element$iv = destination$iv$iv.next();
            it = (MapUnit)element$iv;
            $i$a$-count-NextTurnAutomation$trainSettler$3 = false;
            if (!it.isMilitary() || ++count$iv >= 0) continue;
            CollectionsKt.throwCountOverflow();
        }
        if (count$iv < civInfo.getCities().size()) {
            return;
        }
        count$iv = civInfo.getCities();
        $i$f$filterNot = false;
        element$iv = $this$filterNot$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterNotTo = false;
        for (E element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (City)element$iv$iv;
            $i$a$-filterNot-NextTurnAutomation$trainSettler$bestCity$1 = false;
            if (it.isPuppet() != false || it.getPopulation().getPopulation() < 3) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterNot$iv = (List)destination$iv$iv;
        $i$f$maxByOrNull = false;
        iterator$iv = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v5 = null;
        } else {
            maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v5 = maxElem$iv;
            } else {
                it = (City)maxElem$iv;
                $i$a$-maxByOrNull-NextTurnAutomation$trainSettler$bestCity$2 = false;
                maxValue$iv = it.getCityStats().getCurrentCityStats().getProduction();
                do {
                    e$iv = iterator$iv.next();
                    it = (City)e$iv;
                    $i$a$-maxByOrNull-NextTurnAutomation$trainSettler$bestCity$2 = false;
                    v$iv = it.getCityStats().getCurrentCityStats().getProduction();
                    if (Float.compare(maxValue$iv, v$iv) >= 0) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v5 = maxElem$iv;
            }
        }
        v6 = v5;
        if (v6 == null) {
            return;
        }
        bestCity = v6;
        if (SequencesKt.count(bestCity.getCityConstructions().getBuiltBuildings()) > 1) {
            $i$f$count = settlerUnits;
            var19_44 = bestCity.getCityConstructions();
            $i$f$minByOrNull = false;
            iterator$iv = $this$minByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v7 = null;
            } else {
                minElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v7 = minElem$iv;
                } else {
                    it = (BaseUnit)minElem$iv;
                    $i$a$-minByOrNull-NextTurnAutomation$trainSettler$4 = false;
                    minValue$iv = it.getCost();
                    do {
                        e$iv = iterator$iv.next();
                        it = (BaseUnit)e$iv;
                        $i$a$-minByOrNull-NextTurnAutomation$trainSettler$4 = false;
                        v$iv = it.getCost();
                        if (minValue$iv <= v$iv) continue;
                        minElem$iv = e$iv;
                        minValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v7 = minElem$iv;
                }
            }
            Intrinsics.checkNotNull(v7);
            var19_44.setCurrentConstructionFromQueue(((BaseUnit)v7).getName());
        }
    }

    private final void tryVoteForDiplomaticVictory(Civilization civ) {
        Object object;
        if (!civ.mayVoteForDiplomaticVictory()) {
            return;
        }
        if (civ.isMajorCiv()) {
            Float highestOpinion;
            Float f;
            Sequence<Civilization> knownMajorCivs = SequencesKt.filter(civ.getKnownCivs(), NextTurnAutomation::tryVoteForDiplomaticVictory$lambda$50);
            Iterator<Civilization> iterator2 = knownMajorCivs.iterator();
            if (!iterator2.hasNext()) {
                f = null;
            } else {
                Civilization it = iterator2.next();
                boolean bl = false;
                DiplomacyManager diplomacyManager = civ.getDiplomacyManager(it);
                Intrinsics.checkNotNull(diplomacyManager);
                float f2 = diplomacyManager.opinionOfOtherCiv();
                while (iterator2.hasNext()) {
                    Civilization it2 = iterator2.next();
                    $i$a$-maxOfOrNull-NextTurnAutomation$tryVoteForDiplomaticVictory$chosenCiv$highestOpinion$1 = false;
                    DiplomacyManager diplomacyManager2 = civ.getDiplomacyManager(it2);
                    Intrinsics.checkNotNull(diplomacyManager2);
                    float f3 = diplomacyManager2.opinionOfOtherCiv();
                    f2 = Math.max(f2, f3);
                }
                f = highestOpinion = Float.valueOf(f2);
            }
            object = highestOpinion == null ? null : (highestOpinion.floatValue() < -80.0f || highestOpinion.floatValue() < -40.0f && highestOpinion.floatValue() + (float)Random.Default.nextInt(40) < -40.0f ? null : ((Civilization)CollectionsKt.random((Collection)SequencesKt.toList(SequencesKt.filter(knownMajorCivs, arg_0 -> NextTurnAutomation.tryVoteForDiplomaticVictory$lambda$52(civ, highestOpinion, arg_0))), Random.Default)).getCivName());
        } else {
            object = civ.getAllyCivName();
        }
        String chosenCiv = object;
        civ.diplomaticVoteForCiv(chosenCiv);
    }

    private final void issueRequests(Civilization civInfo) {
        Iterator<Civilization> iterator2 = SequencesKt.filter(civInfo.getKnownCivs(), arg_0 -> NextTurnAutomation.issueRequests$lambda$53(civInfo, arg_0)).iterator();
        while (iterator2.hasNext()) {
            Civilization otherCiv = iterator2.next();
            Intrinsics.checkNotNull(civInfo.getDiplomacyManager(otherCiv));
            for (Demand demand : Demand.getEntries()) {
                DiplomacyManager diploManager;
                if (!diploManager.hasFlag(demand.getViolationOccurred())) continue;
                this.onDemandViolation(demand, civInfo, otherCiv);
            }
        }
    }

    private final void onDemandViolation(Demand demand, Civilization civInfo, Civilization otherCiv) {
        DiplomacyManager diplomacyManager = civInfo.getDiplomacyManager(otherCiv);
        Intrinsics.checkNotNull(diplomacyManager);
        DiplomacyManager diplomacyManager2 = diplomacyManager;
        if (!diplomacyManager2.hasFlag(demand.getWillIgnoreViolation())) {
            if (diplomacyManager2.hasFlag(demand.getAgreedToDemand())) {
                otherCiv.getPopupAlerts().add(new PopupAlert(demand.getViolationDiscoveredAlert(), civInfo.getCivName()));
                diplomacyManager2.setFlag(demand.getWillIgnoreViolation(), 100);
                diplomacyManager2.setModifier(demand.getBetrayedPromiseDiplomacyMpodifier(), -20.0f);
                diplomacyManager2.removeFlag(demand.getAgreedToDemand());
            } else {
                ThreatLevel threatLevel = Automation.INSTANCE.threatAssessment(civInfo, otherCiv);
                if (threatLevel.compareTo((Enum)ThreatLevel.High) < 0) {
                    otherCiv.getPopupAlerts().add(new PopupAlert(demand.getDemandAlert(), civInfo.getCivName()));
                }
            }
        }
        diplomacyManager2.removeFlag(demand.getViolationOccurred());
    }

    @Readonly
    public final int getMinDistanceBetweenCities(@NotNull Civilization civ1, @NotNull Civilization civ2) {
        Intrinsics.checkNotNullParameter(civ1, "civ1");
        Intrinsics.checkNotNullParameter(civ2, "civ2");
        CityDistance cityDistance = this.getClosestCities(civ1, civ2);
        return cityDistance != null ? cityDistance.getAerialDistance() : Integer.MAX_VALUE;
    }

    @Readonly
    @Nullable
    public final CityDistance getClosestCities(@NotNull Civilization civ1, @NotNull Civilization civ2) {
        Intrinsics.checkNotNullParameter(civ1, "civ1");
        Intrinsics.checkNotNullParameter(civ2, "civ2");
        if (civ1.getCities().isEmpty() || civ2.getCities().isEmpty()) {
            return null;
        }
        CityDistance minDistance = null;
        for (City civ1city : civ1.getCities()) {
            for (City civ2city : civ2.getCities()) {
                int currentDistance = civ1city.getCenterTile().aerialDistanceTo(civ2city.getCenterTile());
                if (minDistance != null && currentDistance >= minDistance.getAerialDistance()) continue;
                minDistance = new CityDistance(civ1city, civ2city, currentDistance);
            }
        }
        return minDistance;
    }

    @Readonly
    private static final boolean valueCityStateAlliance$canProvideStat(List<Unique> bonuses, Stat stat) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = bonuses;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Unique it = (Unique)element$iv;
                    boolean bl2 = false;
                    if (!(it.getStats().get(stat) > 0.0f)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final boolean protectCityStates$lambda$3(Civilization it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return !it.isDefeated() && it.isCityState();
    }

    private static final boolean bullyCityStates$lambda$4(Civilization it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return !it.isDefeated() && it.isCityState();
    }

    private static final boolean chooseTechToResearch$getGroupedResearchableTechs$lambda$5(Civilization $civInfo, Technology it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return $civInfo.getTech().canBeResearched(it.getName());
    }

    /*
     * WARNING - void declaration
     */
    @Readonly
    private static final List<List<Technology>> chooseTechToResearch$getGroupedResearchableTechs(Civilization $civInfo) {
        void $this$groupByTo$iv$iv;
        Collection<Technology> collection = $civInfo.getGameInfo().getRuleset().getTechnologies().values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Sequence<Technology> $this$groupBy$iv = SequencesKt.filter(CollectionsKt.asSequence((Iterable)collection), arg_0 -> NextTurnAutomation.chooseTechToResearch$getGroupedResearchableTechs$lambda$5($civInfo, arg_0));
        boolean $i$f$groupBy = false;
        Sequence<Technology> sequence = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            Technology it = (Technology)element$iv$iv;
            boolean bl = false;
            Integer key$iv$iv = it.getCost();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map researchableTechs = destination$iv$iv;
        Collection collection2 = MapsKt.toSortedMap(researchableTechs).values();
        Intrinsics.checkNotNullExpressionValue(collection2, "<get-values>(...)");
        return CollectionsKt.toList(collection2);
    }

    private static final float chooseTechToResearch$lambda$9(GameContext $stateForConditionals, Technology it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getWeightForAiDecision($stateForConditionals);
    }

    private static final float chooseTechToResearch$lambda$12(GameContext $stateForConditionals, Technology it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getWeightForAiDecision($stateForConditionals);
    }

    private static final float chooseTechToResearch$lambda$13(GameContext $stateForConditionals, Technology it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getWeightForAiDecision($stateForConditionals);
    }

    private static final float adoptPolicy$lambda$20(Civilization $civInfo, Policy it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getWeightForAiDecision($civInfo.getState());
    }

    private static final boolean freeUpSpaceResources$lambda$25(String $resource, MapUnit it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.requiresResource($resource);
    }

    private static final boolean automateUnits$lambda$29(Civilization $civInfo, Civilization it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.isAtWarWith($civInfo);
    }

    private static final Iterable automateUnits$lambda$30(Civilization it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getCities();
    }

    private static final boolean automateUnits$lambda$32(Civilization $civInfo, City it) {
        Intrinsics.checkNotNullParameter(it, "it");
        Sequence<Tile> $this$count$iv = it.getCenterTile().getTilesInDistance(4);
        boolean $i$f$count = false;
        int count$iv = 0;
        Iterator<Tile> iterator2 = $this$count$iv.iterator();
        while (iterator2.hasNext()) {
            Tile element$iv;
            Tile it2 = element$iv = iterator2.next();
            boolean bl = false;
            MapUnit mapUnit = it2.getMilitaryUnit();
            if (!Intrinsics.areEqual(mapUnit != null ? mapUnit.getCiv() : null, $civInfo) || ++count$iv >= 0) continue;
            CollectionsKt.throwCountOverflow();
        }
        return count$iv > 4;
    }

    private static final MapUnit automateCityConquer$ourUnitsInRange$lambda$33(Tile it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getMilitaryUnit();
    }

    private static final boolean automateCityConquer$ourUnitsInRange$lambda$34(Civilization $civInfo, MapUnit it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return Intrinsics.areEqual(it.getCiv(), $civInfo);
    }

    @Readonly
    private static final List<MapUnit> automateCityConquer$ourUnitsInRange(City $city, Civilization $civInfo, int range) {
        return SequencesKt.toList(SequencesKt.filter(SequencesKt.mapNotNull($city.getCenterTile().getTilesInDistance(range), NextTurnAutomation::automateCityConquer$ourUnitsInRange$lambda$33), arg_0 -> NextTurnAutomation.automateCityConquer$ourUnitsInRange$lambda$34($civInfo, arg_0)));
    }

    private static final void automateCityConquer$attackIfPossible(MapUnit unit, Tile tile) {
        AttackableTile attackableTile = (AttackableTile)CollectionsKt.firstOrNull(TargetHelper.getAttackableEnemies$default(TargetHelper.INSTANCE, unit, UnitMovement.getDistanceToTiles$default(unit.getMovement(), false, null, null, false, 15, null), CollectionsKt.listOf(tile), false, 8, null));
        if (attackableTile != null) {
            Battle.INSTANCE.moveAndAttack(new MapUnitCombatant(unit), attackableTile);
        }
    }

    private static final boolean tryVoteForDiplomaticVictory$lambda$50(Civilization it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.isMajorCiv();
    }

    private static final boolean tryVoteForDiplomaticVictory$lambda$52(Civilization $civ, Float $highestOpinion, Civilization it) {
        Intrinsics.checkNotNullParameter(it, "it");
        DiplomacyManager diplomacyManager = $civ.getDiplomacyManager(it);
        Intrinsics.checkNotNull(diplomacyManager);
        return Intrinsics.areEqual(diplomacyManager.opinionOfOtherCiv(), $highestOpinion);
    }

    private static final boolean issueRequests$lambda$53(Civilization $civInfo, Civilization it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.isMajorCiv() && !$civInfo.isAtWarWith(it);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0006H\u00c6\u0003J'\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0006H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0018"}, d2={"Lcom/unciv/logic/automation/civilization/NextTurnAutomation$CityDistance;", "", "city1", "Lcom/unciv/logic/city/City;", "city2", "aerialDistance", "", "<init>", "(Lcom/unciv/logic/city/City;Lcom/unciv/logic/city/City;I)V", "getCity1", "()Lcom/unciv/logic/city/City;", "getCity2", "getAerialDistance", "()I", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "core"})
    public static final class CityDistance {
        @NotNull
        private final City city1;
        @NotNull
        private final City city2;
        private final int aerialDistance;

        public CityDistance(@NotNull City city1, @NotNull City city2, int aerialDistance) {
            Intrinsics.checkNotNullParameter(city1, "city1");
            Intrinsics.checkNotNullParameter(city2, "city2");
            this.city1 = city1;
            this.city2 = city2;
            this.aerialDistance = aerialDistance;
        }

        @NotNull
        public final City getCity1() {
            return this.city1;
        }

        @NotNull
        public final City getCity2() {
            return this.city2;
        }

        public final int getAerialDistance() {
            return this.aerialDistance;
        }

        @NotNull
        public final City component1() {
            return this.city1;
        }

        @NotNull
        public final City component2() {
            return this.city2;
        }

        public final int component3() {
            return this.aerialDistance;
        }

        @NotNull
        public final CityDistance copy(@NotNull City city1, @NotNull City city2, int aerialDistance) {
            Intrinsics.checkNotNullParameter(city1, "city1");
            Intrinsics.checkNotNullParameter(city2, "city2");
            return new CityDistance(city1, city2, aerialDistance);
        }

        public static /* synthetic */ CityDistance copy$default(CityDistance cityDistance, City city, City city2, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                city = cityDistance.city1;
            }
            if ((n2 & 2) != 0) {
                city2 = cityDistance.city2;
            }
            if ((n2 & 4) != 0) {
                n = cityDistance.aerialDistance;
            }
            return cityDistance.copy(city, city2, n);
        }

        @NotNull
        public String toString() {
            return "CityDistance(city1=" + this.city1 + ", city2=" + this.city2 + ", aerialDistance=" + this.aerialDistance + ')';
        }

        public int hashCode() {
            int result2 = this.city1.hashCode();
            result2 = result2 * 31 + this.city2.hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.aerialDistance);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CityDistance)) {
                return false;
            }
            CityDistance cityDistance = (CityDistance)other;
            if (!Intrinsics.areEqual(this.city1, cityDistance.city1)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.city2, cityDistance.city2)) {
                return false;
            }
            return this.aerialDistance == cityDistance.aerialDistance;
        }
    }
}

