/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.worldscreen.bottombar;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.map.tile.Tile;
import com.unciv.logic.map.tile.TileDescription;
import com.unciv.logic.map.tile.TileStatFunctions;
import com.unciv.models.skins.SkinStrings;
import com.unciv.models.stats.Stat;
import com.unciv.models.stats.Stats;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.components.extensions.FormattingExtensionsKt;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.tilegroups.WorldTileGroup;
import com.unciv.ui.popups.Popup;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.civilopediascreen.FormattedLine;
import com.unciv.ui.screens.civilopediascreen.MarkupRenderer;
import com.unciv.ui.screens.worldscreen.WorldScreen;
import com.unciv.utils.DebugUtils;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0017\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0000\u00a2\u0006\u0002\b\u0010J\u0010\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006\u0012"}, d2={"Lcom/unciv/ui/screens/worldscreen/bottombar/TileInfoTable;", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "worldScreen", "Lcom/unciv/ui/screens/worldscreen/WorldScreen;", "<init>", "(Lcom/unciv/ui/screens/worldscreen/WorldScreen;)V", "selectedCiv", "Lcom/unciv/logic/civilization/Civilization;", "getSelectedCiv", "()Lcom/unciv/logic/civilization/Civilization;", "setSelectedCiv", "(Lcom/unciv/logic/civilization/Civilization;)V", "updateTileTable", "", "tile", "Lcom/unciv/logic/map/tile/Tile;", "updateTileTable$core", "getStatsTable", "core"})
public final class TileInfoTable
extends Table {
    @NotNull
    private final WorldScreen worldScreen;
    @NotNull
    private Civilization selectedCiv;

    public TileInfoTable(@NotNull WorldScreen worldScreen) {
        Intrinsics.checkNotNullParameter(worldScreen, "worldScreen");
        super(BaseScreen.Companion.getSkin());
        this.worldScreen = worldScreen;
        this.selectedCiv = this.worldScreen.getSelectedCiv();
        this.setBackground(SkinStrings.getUiBackground$default(BaseScreen.Companion.getSkinStrings(), "WorldScreen/TileInfoTable", null, Scene2dExtensionsKt.darken(BaseScreen.Companion.getSkinStrings().getSkinConfig().getBaseColor(), 0.5f), 2, null));
    }

    @NotNull
    public final Civilization getSelectedCiv() {
        return this.selectedCiv;
    }

    public final void setSelectedCiv(@NotNull Civilization civilization) {
        Intrinsics.checkNotNullParameter(civilization, "<set-?>");
        this.selectedCiv = civilization;
    }

    public final void updateTileTable$core(@Nullable Tile tile) {
        this.clearChildren();
        this.pad(5.0f);
        if (tile != null && (DebugUtils.INSTANCE.getVISIBLE_MAP() || this.selectedCiv.hasExplored(tile))) {
            this.add((Actor)this.getStatsTable(tile)).left().row();
            this.add((Actor)MarkupRenderer.render$default(MarkupRenderer.INSTANCE, TileDescription.INSTANCE.toMarkup(tile, this.selectedCiv), 0.0f, 0.0f, FormattedLine.IconDisplay.None, arg_0 -> TileInfoTable.updateTileTable$lambda$0(this, arg_0), 2, null)).padTop(5.0f).row();
            if (DebugUtils.INSTANCE.getVISIBLE_MAP()) {
                this.add((Actor)Scene2dExtensionsKt.toLabel(FormattingExtensionsKt.toPrettyString(tile.getPosition()))).colspan(2).pad(5.0f);
            }
            if (DebugUtils.INSTANCE.getSHOW_TILE_IMAGE_LOCATIONS()) {
                StringBuilder stringBuilder = new StringBuilder().append("Images: ");
                WorldTileGroup worldTileGroup = this.worldScreen.getMapHolder().getTileGroups().get(tile);
                Intrinsics.checkNotNull(worldTileGroup);
                String imagesString = stringBuilder.append(CollectionsKt.joinToString$default(worldTileGroup.getLayerTerrain().getTileBaseImages(), null, null, null, 0, null, TileInfoTable::updateTileTable$lambda$1, 31, null)).toString();
                this.add((Actor)Scene2dExtensionsKt.toLabel(imagesString));
            }
        }
        this.pack();
        Group group = this;
        Color color = Color.WHITE;
        Intrinsics.checkNotNullExpressionValue(color, "WHITE");
        Scene2dExtensionsKt.addBorderAllowOpacity(group, 1.0f, color);
    }

    private final Table getStatsTable(Tile tile) {
        Table table2 = new Table();
        table2.defaults().pad(2.0f);
        for (Stats.StatValuePair statValuePair : TileStatFunctions.getTileStats$default(tile.getStats(), this.selectedCiv, null, 2, null)) {
            Stat key = statValuePair.component1();
            float value = statValuePair.component2();
            char c = key.getCharacter();
            String string = String.valueOf((int)value);
            table2.add((Actor)Scene2dExtensionsKt.toLabel(c + string)).align(8).padRight(5.0f);
        }
        table2.setTouchable(Touchable.enabled);
        ActivationExtensionsKt.onClick(table2, () -> TileInfoTable.getStatsTable$lambda$3(this, tile));
        return table2;
    }

    private static final Unit updateTileTable$lambda$0(TileInfoTable this$0, String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        this$0.worldScreen.openCivilopedia(it);
        return Unit.INSTANCE;
    }

    private static final CharSequence updateTileTable$lambda$1(Image it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return '\n' + it.getName();
    }

    private static final Unit getStatsTable$lambda$3(TileInfoTable this$0, Tile $tile) {
        Popup popup2;
        Popup $this$getStatsTable_u24lambda_u243_u24lambda_u242 = popup2 = new Popup(this$0.worldScreen, null, 0.0f, 6, null);
        boolean bl = false;
        for (Pair pair : TileStatFunctions.getTileStatsBreakdown$default($tile.getStats(), $tile.getCity(), this$0.selectedCiv, null, 4, null)) {
            String name = (String)pair.component1();
            Stats stats = (Stats)pair.component2();
            $this$getStatsTable_u24lambda_u243_u24lambda_u242.add((Actor)Scene2dExtensionsKt.toLabel(TranslationsKt.tr$default(name, false, false, 3, null) + ": {" + stats.clone() + '}')).row();
        }
        Popup.addCloseButton$default($this$getStatsTable_u24lambda_u243_u24lambda_u242, null, null, null, null, 15, null);
        Popup.open$default(popup2, false, 1, null);
        return Unit.INSTANCE;
    }
}

