/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.overviewscreen;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.unciv.GUI;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.UnitAction;
import com.unciv.models.UnitActionType;
import com.unciv.models.UpgradeUnitAction;
import com.unciv.models.ruleset.RulesetObject;
import com.unciv.models.ruleset.tile.TileImprovement;
import com.unciv.models.ruleset.unit.BaseUnit;
import com.unciv.models.ruleset.unit.Promotion;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.components.UncivTooltip;
import com.unciv.ui.components.extensions.FormattingExtensionsKt;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.popups.UnitUpgradeMenu;
import com.unciv.ui.screens.overviewscreen.EmpireOverviewCategories;
import com.unciv.ui.screens.overviewscreen.UnitOverviewTab;
import com.unciv.ui.screens.pickerscreens.PromotionPickerScreen;
import com.unciv.ui.screens.worldscreen.unit.actions.UnitActionsUpgrade;
import com.unciv.ui.screens.worldscreen.worldmap.WorldMapHolder;
import java.util.Iterator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import yairm210.purity.annotations.Readonly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J!\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\tH\u0000\u00a2\u0006\u0002\b\nJ\u001a\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0004J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0004J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0003J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0005J\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0016H\u0004J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0005J\u0018\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0016H\u0004J \u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u001cH\u0002\u00a8\u0006\u001d\u00b2\u0006\f\u0010\u001e\u001a\u0004\u0018\u00010\u0005X\u008a\u0084\u0002"}, d2={"Lcom/unciv/ui/screens/overviewscreen/UnitOverviewTabHelpers;", "", "<init>", "()V", "getUnitIdentifier", "", "unit", "Lcom/unciv/logic/map/mapunit/MapUnit;", "unitToUpgradeTo", "Lcom/unciv/models/ruleset/unit/BaseUnit;", "getUnitIdentifier$core", "showWorldScreenAt", "", "position", "Lcom/badlogic/gdx/math/Vector2;", "tile", "Lcom/unciv/logic/map/tile/Tile;", "getWorkerActionText", "getActionText", "getUpgradeTable", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "actionContext", "Lcom/unciv/ui/screens/overviewscreen/UnitOverviewTab;", "getUpgradeSortString", "getPromotionsTable", "updatePromotionsTable", "table", "canEnable", "", "core", "workerText"})
public class UnitOverviewTabHelpers {
    @NotNull
    public final String getUnitIdentifier$core(@NotNull MapUnit unit, @Nullable BaseUnit unitToUpgradeTo) {
        Intrinsics.checkNotNullParameter(unit, "unit");
        Object object = unitToUpgradeTo;
        if (object == null || (object = ((RulesetObject)object).getName()) == null) {
            object = unit.getName();
        }
        Object name = object;
        return (String)name + '@' + FormattingExtensionsKt.toPrettyString(unit.getTile().getPosition());
    }

    public static /* synthetic */ String getUnitIdentifier$core$default(UnitOverviewTabHelpers unitOverviewTabHelpers, MapUnit mapUnit, BaseUnit baseUnit, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getUnitIdentifier");
        }
        if ((n & 2) != 0) {
            baseUnit = null;
        }
        return unitOverviewTabHelpers.getUnitIdentifier$core(mapUnit, baseUnit);
    }

    private final void showWorldScreenAt(Vector2 position, MapUnit unit) {
        GUI.INSTANCE.resetToWorldScreen();
        WorldMapHolder.setCenterPosition$default(GUI.INSTANCE.getMap(), position, false, false, unit, 6, null);
    }

    protected final void showWorldScreenAt(@NotNull MapUnit unit) {
        Intrinsics.checkNotNullParameter(unit, "unit");
        this.showWorldScreenAt(unit.getCurrentTile().getPosition(), unit);
    }

    protected final void showWorldScreenAt(@NotNull Tile tile) {
        Intrinsics.checkNotNullParameter(tile, "tile");
        this.showWorldScreenAt(tile.getPosition(), null);
    }

    @Readonly
    private final String getWorkerActionText(MapUnit unit) {
        String string;
        if (!unit.getCache().getHasUniqueToBuildImprovements()) {
            string = null;
        } else if (!unit.hasMovement()) {
            string = null;
        } else if (unit.getCurrentTile().getImprovementInProgress() == null) {
            string = null;
        } else {
            TileImprovement tileImprovement = unit.getTile().getTileImprovementInProgress();
            Intrinsics.checkNotNull(tileImprovement);
            string = !MapUnit.canBuildImprovement$default(unit, tileImprovement, null, 2, null) ? null : unit.getCurrentTile().getImprovementInProgress();
        }
        return string;
    }

    @Readonly
    @Nullable
    protected final String getActionText(@NotNull MapUnit unit) {
        Intrinsics.checkNotNullParameter(unit, "unit");
        Lazy<String> workerText$delegate = LazyKt.lazy(() -> UnitOverviewTabHelpers.getActionText$lambda$0(this, unit));
        return unit.getAction() == null ? UnitOverviewTabHelpers.getActionText$lambda$1(workerText$delegate) : (unit.isFortified() ? UnitActionType.Fortify.getValue() : (unit.isGuarding() ? UnitActionType.Guard.getValue() : (unit.isMoving() ? "Moving" : (unit.isAutomated() && UnitOverviewTabHelpers.getActionText$lambda$1(workerText$delegate) != null ? '[' + UnitOverviewTabHelpers.getActionText$lambda$1(workerText$delegate) + "] \u26cf" : unit.getAction()))));
    }

    @Nullable
    protected final Table getUpgradeTable(@NotNull MapUnit unit, @NotNull UnitOverviewTab actionContext) {
        Intrinsics.checkNotNullParameter(unit, "unit");
        Intrinsics.checkNotNullParameter(actionContext, "actionContext");
        Table table2 = new Table();
        Sequence<UnitAction> unitActions = UnitActionsUpgrade.INSTANCE.getUpgradeActionAnywhere(unit);
        if (SequencesKt.none(unitActions)) {
            return null;
        }
        boolean canEnable = actionContext.getViewingPlayer().isCurrentPlayer() && GUI.INSTANCE.isAllowedChangeState();
        Iterator<UnitAction> iterator2 = unitActions.iterator();
        while (iterator2.hasNext()) {
            Color color;
            UnitAction unitAction = iterator2.next();
            boolean enable = canEnable && unitAction.getAction() != null;
            Intrinsics.checkNotNull(unitAction, "null cannot be cast to non-null type com.unciv.models.UpgradeUnitAction");
            BaseUnit unitToUpgradeTo = ((UpgradeUnitAction)unitAction).getUnitToUpgradeTo();
            String selectKey = this.getUnitIdentifier$core(unit, unitToUpgradeTo);
            if (enable) {
                color = Color.GREEN;
            } else {
                Color color2 = Color.GREEN;
                Intrinsics.checkNotNullExpressionValue(color2, "GREEN");
                color = Scene2dExtensionsKt.darken(color2, 0.5f);
            }
            Color color3 = color;
            Intrinsics.checkNotNull(color3);
            Image upgradeIcon = ImageGetter.INSTANCE.getUnitIcon(unitToUpgradeTo, color3);
            ActivationExtensionsKt.onClick(upgradeIcon, () -> UnitOverviewTabHelpers.getUpgradeTable$lambda$3(actionContext, upgradeIcon, unit, unitAction, enable, selectKey));
            UncivTooltip.Companion.addTooltip$default(UncivTooltip.Companion, upgradeIcon, unitToUpgradeTo.getName(), 24.0f, false, 0, 12, false, null, 108, null);
            table2.add((Actor)upgradeIcon).size(28.0f);
        }
        return table2;
    }

    @Readonly
    @Nullable
    protected final String getUpgradeSortString(@NotNull MapUnit unit) {
        Intrinsics.checkNotNullParameter(unit, "unit");
        UnitAction unitAction = SequencesKt.firstOrNull(UnitActionsUpgrade.INSTANCE.getUpgradeActionAnywhere(unit));
        if (unitAction == null) {
            return null;
        }
        UnitAction upgrade = unitAction;
        return TranslationsKt.tr$default(((UpgradeUnitAction)upgrade).getUnitToUpgradeTo().getName(), true, false, 2, null);
    }

    @NotNull
    protected final Table getPromotionsTable(@NotNull MapUnit unit, @NotNull UnitOverviewTab actionContext) {
        Intrinsics.checkNotNullParameter(unit, "unit");
        Intrinsics.checkNotNullParameter(actionContext, "actionContext");
        Table promotionsTable = new Table();
        boolean canEnable = actionContext.getViewingPlayer().isCurrentPlayer() && GUI.INSTANCE.isAllowedChangeState();
        this.updatePromotionsTable(promotionsTable, unit, canEnable);
        String selectKey = UnitOverviewTabHelpers.getUnitIdentifier$core$default(this, unit, null, 2, null);
        ActivationExtensionsKt.onClick(promotionsTable, new Function0<Unit>(canEnable, unit, actionContext, selectKey){
            final /* synthetic */ boolean $canEnable;
            final /* synthetic */ MapUnit $unit;
            final /* synthetic */ UnitOverviewTab $actionContext;
            final /* synthetic */ String $selectKey;
            {
                this.$canEnable = $canEnable;
                this.$unit = $unit;
                this.$actionContext = $actionContext;
                this.$selectKey = $selectKey;
                super(0, Intrinsics.Kotlin.class, "onPromotionsTableClick", "getPromotionsTable$onPromotionsTableClick(ZLcom/unciv/logic/map/mapunit/MapUnit;Lcom/unciv/ui/screens/overviewscreen/UnitOverviewTab;Ljava/lang/String;)V", 0);
            }

            public final void invoke() {
                UnitOverviewTabHelpers.access$getPromotionsTable$onPromotionsTableClick(this.$canEnable, this.$unit, this.$actionContext, this.$selectKey);
            }
        });
        return promotionsTable;
    }

    /*
     * WARNING - void declaration
     */
    private final void updatePromotionsTable(Table table2, MapUnit unit, boolean canEnable) {
        void $this$updatePromotionsTable_u24lambda_u245;
        Color color;
        Image image;
        table2.clearChildren();
        Sequence<Promotion> promotions = unit.getPromotions().getPromotions(true);
        boolean showPromoteStar = unit.getPromotions().canBePromoted();
        if (SequencesKt.any(promotions)) {
            int iconCount = SequencesKt.count(promotions) + (showPromoteStar ? 1 : 0);
            int numberOfLines = (iconCount - 1) / 8 + 1;
            int promotionsPerLine = (iconCount - 1) / numberOfLines + 1;
            Iterator<List<Promotion>> iterator2 = SequencesKt.chunked(promotions, promotionsPerLine).iterator();
            while (iterator2.hasNext()) {
                List<Promotion> linePromotions = iterator2.next();
                for (Promotion promotion : linePromotions) {
                    table2.add((Actor)ImageGetter.getPromotionPortrait$default(ImageGetter.INSTANCE, promotion.getName(), 0.0f, 2, null));
                }
                if (linePromotions.size() != promotionsPerLine) continue;
                table2.row();
            }
        }
        if (!showPromoteStar) {
            return;
        }
        Image numberOfLines = image = ImageGetter.getImage$default(ImageGetter.INSTANCE, "OtherIcons/Star", null, 2, null);
        Table table3 = table2;
        boolean bl = false;
        if (canEnable && unit.hasMovement() && unit.getAttacksThisTurn() == 0) {
            color = Color.GOLDENROD;
        } else {
            Color color2 = Color.GOLDENROD;
            Intrinsics.checkNotNullExpressionValue(color2, "GOLDENROD");
            color = Scene2dExtensionsKt.darken(color2, 0.25f);
        }
        $this$updatePromotionsTable_u24lambda_u245.setColor(color);
        table3.add((Actor)image).size(24.0f).padLeft(8.0f);
    }

    private static final String getActionText$lambda$0(UnitOverviewTabHelpers this$0, MapUnit $unit) {
        return this$0.getWorkerActionText($unit);
    }

    private static final String getActionText$lambda$1(Lazy<String> $workerText$delegate) {
        Lazy<String> lazy = $workerText$delegate;
        return lazy.getValue();
    }

    private static final Unit getUpgradeTable$lambda$3$lambda$2(UnitOverviewTab $actionContext, String $selectKey) {
        $actionContext.update$core();
        $actionContext.getOverviewScreen().select(EmpireOverviewCategories.Units, $selectKey);
        return Unit.INSTANCE;
    }

    private static final Unit getUpgradeTable$lambda$3(UnitOverviewTab $actionContext, Image $upgradeIcon, MapUnit $unit, UnitAction $unitAction, boolean $enable, String $selectKey) {
        new UnitUpgradeMenu($actionContext.getOverviewScreen().getStage(), (Actor)$upgradeIcon, $unit, (UpgradeUnitAction)$unitAction, $enable, false, () -> UnitOverviewTabHelpers.getUpgradeTable$lambda$3$lambda$2($actionContext, $selectKey), 32, null);
        return Unit.INSTANCE;
    }

    private static final Unit getPromotionsTable$onPromotionsTableClick$lambda$4(UnitOverviewTab $actionContext, String $selectKey) {
        $actionContext.update$core();
        $actionContext.getOverviewScreen().select(EmpireOverviewCategories.Units, $selectKey);
        return Unit.INSTANCE;
    }

    private static final void getPromotionsTable$onPromotionsTableClick(boolean canEnable, MapUnit $unit, UnitOverviewTab $actionContext, String selectKey) {
        boolean canPromote;
        boolean bl = canPromote = canEnable && $unit.getPromotions().canBePromoted();
        if (!canPromote && $unit.getPromotions().getPromotions().isEmpty()) {
            return;
        }
        $actionContext.getOverviewScreen().getGame().pushScreen(new PromotionPickerScreen($unit, false, () -> UnitOverviewTabHelpers.getPromotionsTable$onPromotionsTableClick$lambda$4($actionContext, selectKey), 2, null));
    }

    public static final /* synthetic */ void access$getPromotionsTable$onPromotionsTableClick(boolean canEnable, MapUnit $unit, UnitOverviewTab $actionContext, String selectKey) {
        UnitOverviewTabHelpers.getPromotionsTable$onPromotionsTableClick(canEnable, $unit, $actionContext, selectKey);
    }
}

