/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.overviewscreen;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.unciv.UncivGame;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.diplomacy.DiplomacyManager;
import com.unciv.logic.trade.Trade;
import com.unciv.logic.trade.TradeOffer;
import com.unciv.logic.trade.TradeOffersList;
import com.unciv.logic.trade.TradeRequest;
import com.unciv.models.skins.SkinStrings;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.overviewscreen.EmpireOverviewScreen;
import com.unciv.ui.screens.overviewscreen.EmpireOverviewTab;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0003H\u0002J \u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lcom/unciv/ui/screens/overviewscreen/TradesOverviewTab;", "Lcom/unciv/ui/screens/overviewscreen/EmpireOverviewTab;", "viewingPlayer", "Lcom/unciv/logic/civilization/Civilization;", "overviewScreen", "Lcom/unciv/ui/screens/overviewscreen/EmpireOverviewScreen;", "<init>", "(Lcom/unciv/logic/civilization/Civilization;Lcom/unciv/ui/screens/overviewscreen/EmpireOverviewScreen;)V", "game", "Lcom/unciv/UncivGame;", "getGame", "()Lcom/unciv/UncivGame;", "createTradeTable", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "trade", "Lcom/unciv/logic/trade/Trade;", "otherCiv", "createOffersTable", "civ", "offersList", "Lcom/unciv/logic/trade/TradeOffersList;", "numberOfOtherSidesOffers", "", "core"})
@SourceDebugExtension(value={"SMAP\nTradesOverviewTab.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TradesOverviewTab.kt\ncom/unciv/ui/screens/overviewscreen/TradesOverviewTab\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,74:1\n774#2:75\n865#2:76\n1761#2,3:77\n866#2:80\n774#2:81\n865#2,2:82\n774#2:84\n865#2,2:85\n1999#2,14:87\n1999#2,14:101\n*S KotlinDebug\n*F\n+ 1 TradesOverviewTab.kt\ncom/unciv/ui/screens/overviewscreen/TradesOverviewTab\n*L\n20#1:75\n20#1:76\n20#1:77,3\n20#1:80\n24#1:81\n24#1:82,2\n28#1:84\n28#1:85,2\n32#1:87,14\n33#1:101,14\n*E\n"})
public final class TradesOverviewTab
extends EmpireOverviewTab {
    @NotNull
    private final UncivGame game;

    /*
     * WARNING - void declaration
     */
    public TradesOverviewTab(@NotNull Civilization viewingPlayer, @NotNull EmpireOverviewScreen overviewScreen) {
        void $this$filterTo$iv$iv;
        Object tradeRequest2;
        Iterator $this$filterTo$iv$iv2;
        Intrinsics.checkNotNullParameter(viewingPlayer, "viewingPlayer");
        Intrinsics.checkNotNullParameter(overviewScreen, "overviewScreen");
        super(viewingPlayer, overviewScreen, null, 4, null);
        this.game = overviewScreen.getGame();
        this.defaults().pad(10.0f);
        Collection<DiplomacyManager> collection = viewingPlayer.getDiplomacy().values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Object object = $this$filterTo$iv$iv2.iterator();
        while (object.hasNext()) {
            boolean bl;
            Object element$iv$iv;
            block12: {
                element$iv$iv = object.next();
                DiplomacyManager it = (DiplomacyManager)element$iv$iv;
                boolean bl2 = false;
                Iterable $this$any$iv = it.otherCiv().getTradeRequests();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        TradeRequest it2 = (TradeRequest)element$iv;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual(it2.getRequestingCiv(), viewingPlayer.getCivName())) continue;
                        bl = true;
                        break block12;
                    }
                    bl = false;
                }
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List diplomaciesWithPendingTrade = (List)destination$iv$iv;
        if (!((Collection)diplomaciesWithPendingTrade).isEmpty()) {
            this.add((Actor)Scene2dExtensionsKt.toLabel$default("Pending trades", null, 24, 0, false, 13, null)).padTop(10.0f).row();
        }
        for (Object e : diplomaciesWithPendingTrade) {
            void $this$filterTo$iv$iv3;
            Intrinsics.checkNotNullExpressionValue(e, "next(...)");
            DiplomacyManager diplomacy = (DiplomacyManager)e;
            Iterable $this$filter$iv2 = diplomacy.otherCiv().getTradeRequests();
            boolean $i$f$filter2 = false;
            object = $this$filter$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv3) {
                TradeRequest it = (TradeRequest)element$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getRequestingCiv(), viewingPlayer.getCivName())) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            for (Object tradeRequest2 : (List)destination$iv$iv2) {
                this.add((Actor)this.createTradeTable(((TradeRequest)tradeRequest2).getTrade().reverse(), diplomacy.otherCiv())).row();
            }
        }
        Collection<DiplomacyManager> collection2 = viewingPlayer.getDiplomacy().values();
        Intrinsics.checkNotNullExpressionValue(collection2, "<get-values>(...)");
        Iterable $this$filter$iv3 = collection2;
        boolean $i$f$filter3 = false;
        tradeRequest2 = $this$filter$iv3;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$filterTo3 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            DiplomacyManager it = (DiplomacyManager)element$iv$iv;
            boolean bl = false;
            boolean bl4 = !((Collection)it.getTrades()).isEmpty();
            if (!bl4) continue;
            destination$iv$iv3.add(element$iv$iv);
        }
        List diplomaciesWithExistingTrade = CollectionsKt.sortedWith((List)destination$iv$iv3, (arg_0, arg_1) -> TradesOverviewTab._init_$lambda$7(TradesOverviewTab::_init_$lambda$6, arg_0, arg_1));
        if (!((Collection)diplomaciesWithExistingTrade).isEmpty()) {
            this.add((Actor)Scene2dExtensionsKt.toLabel$default("Current trades", null, 24, 0, false, 13, null)).padTop(10.0f).row();
        }
        for (Object t : diplomaciesWithExistingTrade) {
            Iterator<Trade> iterator2;
            Intrinsics.checkNotNullExpressionValue(t, "next(...)");
            DiplomacyManager diplomacy = (DiplomacyManager)t;
            Intrinsics.checkNotNullExpressionValue(diplomacy.getTrades().iterator(), "iterator(...)");
            while (iterator2.hasNext()) {
                Trade trade;
                Intrinsics.checkNotNullExpressionValue(iterator2.next(), "next(...)");
                this.add((Actor)this.createTradeTable(trade, diplomacy.otherCiv())).row();
            }
        }
    }

    @NotNull
    public final UncivGame getGame() {
        return this.game;
    }

    private final Table createTradeTable(Trade trade, Civilization otherCiv) {
        Table table2;
        Table $this$createTradeTable_u24lambda_u248 = table2 = new Table();
        boolean bl = false;
        $this$createTradeTable_u24lambda_u248.add((Actor)this.createOffersTable(this.getViewingPlayer(), trade.getOurOffers(), trade.getTheirOffers().size())).minWidth(this.getOverviewScreen().getStage().getWidth() / (float)4).fillY();
        $this$createTradeTable_u24lambda_u248.add((Actor)this.createOffersTable(otherCiv, trade.getTheirOffers(), trade.getOurOffers().size())).minWidth(this.getOverviewScreen().getStage().getWidth() / (float)4).fillY();
        return table2;
    }

    private final Table createOffersTable(Civilization civ, TradeOffersList offersList, int numberOfOtherSidesOffers) {
        Table table2 = new Table();
        table2.defaults().pad(10.0f);
        table2.setBackground(SkinStrings.getUiBackground$default(BaseScreen.Companion.getSkinStrings(), "OverviewScreen/TradesOverviewTab/OffersTable", null, civ.getNation().getOuterColor(), 2, null));
        table2.add((Actor)Scene2dExtensionsKt.toLabel$default(civ.getCivName(), civ.getNation().getInnerColor(), 0, 0, false, 14, null)).row();
        Scene2dExtensionsKt.addSeparator$default(table2, null, 0, 0.0f, 7, null);
        Iterator iterator2 = offersList.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator iterator3 = iterator2;
        while (iterator3.hasNext()) {
            Object e = iterator3.next();
            Intrinsics.checkNotNullExpressionValue(e, "next(...)");
            TradeOffer offer = (TradeOffer)e;
            String offerText = TradeOffer.getOfferText$default(offer, 0, 1, null);
            if (!StringsKt.contains$default((CharSequence)offerText, "\n", false, 2, null)) {
                offerText = offerText + '\n';
            }
            table2.add((Actor)Scene2dExtensionsKt.toLabel$default(offerText, civ.getNation().getInnerColor(), 0, 0, false, 14, null)).row();
        }
        int n = numberOfOtherSidesOffers - offersList.size();
        int n2 = 0;
        while (n2 < n) {
            int it = n2++;
            boolean bl = false;
            table2.add((Actor)Scene2dExtensionsKt.toLabel("\n")).row();
        }
        return table2;
    }

    private static final int _init_$lambda$6(DiplomacyManager diplomacyManager1, DiplomacyManager diplomacyManager2) {
        int n;
        int d1MaxDuration;
        int n2;
        TradeOffersList d1OffersFromFirstTrade = ((Trade)CollectionsKt.first((List)diplomacyManager1.getTrades())).getOurOffers();
        TradeOffersList d2OffersFromFirstTrade = ((Trade)CollectionsKt.first((List)diplomacyManager2.getTrades())).getOurOffers();
        if (d1OffersFromFirstTrade.isEmpty()) {
            n2 = 0;
        } else {
            Object v1;
            Iterable $this$maxByOrNull$iv = d1OffersFromFirstTrade;
            boolean $i$f$maxByOrNull = false;
            Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v1 = null;
            } else {
                Object maxElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v1 = maxElem$iv;
                } else {
                    TradeOffer it = (TradeOffer)maxElem$iv;
                    boolean bl = false;
                    int maxValue$iv = it.getDuration();
                    do {
                        Object e$iv = iterator$iv.next();
                        TradeOffer it2 = (TradeOffer)e$iv;
                        $i$a$-maxByOrNull-TradesOverviewTab$diplomaciesWithExistingTrade$2$d1MaxDuration$1 = false;
                        int v$iv = it2.getDuration();
                        if (maxValue$iv >= v$iv) continue;
                        maxElem$iv = e$iv;
                        maxValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v1 = maxElem$iv;
                }
            }
            Intrinsics.checkNotNull(v1);
            n2 = d1MaxDuration = ((TradeOffer)v1).getDuration();
        }
        if (d2OffersFromFirstTrade.isEmpty()) {
            n = 0;
        } else {
            Object v3;
            Iterable $this$maxByOrNull$iv = d2OffersFromFirstTrade;
            boolean $i$f$maxByOrNull = false;
            Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v3 = null;
            } else {
                Object maxElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v3 = maxElem$iv;
                } else {
                    TradeOffer it = (TradeOffer)maxElem$iv;
                    boolean bl = false;
                    int maxValue$iv = it.getDuration();
                    do {
                        Object e$iv = iterator$iv.next();
                        TradeOffer it3 = (TradeOffer)e$iv;
                        $i$a$-maxByOrNull-TradesOverviewTab$diplomaciesWithExistingTrade$2$d2MaxDuration$1 = false;
                        int v$iv = it3.getDuration();
                        if (maxValue$iv >= v$iv) continue;
                        maxElem$iv = e$iv;
                        maxValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v3 = maxElem$iv;
                }
            }
            Intrinsics.checkNotNull(v3);
            n = ((TradeOffer)v3).getDuration();
        }
        int d2MaxDuration = n;
        return d1MaxDuration > d2MaxDuration ? 1 : (d1MaxDuration == d2MaxDuration ? 0 : -1);
    }

    private static final int _init_$lambda$7(Function2 $tmp0, Object p0, Object p1) {
        return ((Number)$tmp0.invoke(p0, p1)).intValue();
    }
}

