/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.overviewscreen;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.ui.WidgetGroup;
import com.unciv.UncivGame;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.diplomacy.DiplomacyFlags;
import com.unciv.logic.civilization.diplomacy.DiplomacyFunctions;
import com.unciv.logic.civilization.diplomacy.DiplomacyManager;
import com.unciv.logic.civilization.diplomacy.DiplomaticModifiers;
import com.unciv.logic.civilization.diplomacy.DiplomaticStatus;
import com.unciv.logic.civilization.diplomacy.RelationshipLevel;
import com.unciv.logic.map.HexMath;
import com.unciv.models.ruleset.Policy;
import com.unciv.models.ruleset.PolicyBranch;
import com.unciv.models.ruleset.nation.NationKt;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.skins.SkinStrings;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.components.UncivTooltip;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.input.ClickableCircle;
import com.unciv.ui.components.widgets.AutoScrollPane;
import com.unciv.ui.components.widgets.ColorMarkupLabel;
import com.unciv.ui.components.widgets.ShadowedLabel;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.images.Portrait;
import com.unciv.ui.popups.AnimatedMenuPopup;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.diplomacyscreen.DiplomacyScreen;
import com.unciv.ui.screens.overviewscreen.EmpireOverviewScreen;
import com.unciv.ui.screens.overviewscreen.EmpireOverviewTab;
import com.unciv.ui.screens.overviewscreen.WonderInfo;
import com.unciv.ui.screens.worldscreen.WorldScreen;
import com.unciv.ui.screens.worldscreen.worldmap.WorldMapHolder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\b\n\u0002\b\n\u0018\u00002\u00020\u0001:\u0003234B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0019\u001a\u00020\u000fH\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0002J\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dH\u0002J\b\u0010\u001f\u001a\u00020\u001bH\u0002J\u0010\u0010 \u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\u0003H\u0002J\u0010\u0010\"\u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\u0003H\u0002J\u0010\u0010#\u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\u0003H\u0002J\u0010\u0010$\u001a\u00020\u00152\u0006\u0010%\u001a\u00020\u0003H\u0002J\u0010\u0010&\u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\u0003H\u0002J\b\u0010'\u001a\u00020\u001bH\u0002J\f\u0010(\u001a\u00020\u0017*\u00020\u0003H\u0002J\u0010\u0010)\u001a\u00020\u000f2\u0006\u0010*\u001a\u00020+H\u0002J\u0010\u0010,\u001a\u00020\u000f2\u0006\u0010-\u001a\u00020\u0003H\u0002J\u0014\u0010.\u001a\u00020\u001b*\u00020\u000f2\u0006\u0010*\u001a\u00020+H\u0002J*\u0010/\u001a\u00020\u001b*\u00020\u000f2\u0006\u0010*\u001a\u00020+2\u0006\u00100\u001a\u00020\u00152\f\u00101\u001a\b\u0012\u0004\u0012\u00020\u00030\u0012H\u0002R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00030\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00030\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lcom/unciv/ui/screens/overviewscreen/GlobalPoliticsOverviewTable;", "Lcom/unciv/ui/screens/overviewscreen/EmpireOverviewTab;", "viewingPlayer", "Lcom/unciv/logic/civilization/Civilization;", "overviewScreen", "Lcom/unciv/ui/screens/overviewscreen/EmpireOverviewScreen;", "persistedData", "Lcom/unciv/ui/screens/overviewscreen/EmpireOverviewTab$EmpireOverviewTabPersistableData;", "<init>", "(Lcom/unciv/logic/civilization/Civilization;Lcom/unciv/ui/screens/overviewscreen/EmpireOverviewScreen;Lcom/unciv/ui/screens/overviewscreen/EmpireOverviewTab$EmpireOverviewTabPersistableData;)V", "persistableData", "Lcom/unciv/ui/screens/overviewscreen/GlobalPoliticsOverviewTable$DiplomacyTabPersistableData;", "getPersistableData", "()Lcom/unciv/ui/screens/overviewscreen/GlobalPoliticsOverviewTable$DiplomacyTabPersistableData;", "fixedContent", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "civTable", "undefeatedCivs", "", "defeatedCivs", "relevantCivsCount", "", "showDiplomacyGroup", "", "portraitMode", "getFixedContent", "updatePoliticsTable", "", "createGlobalPoliticsHeader", "Lcom/badlogic/gdx/scenes/scene2d/ui/Cell;", "Lcom/badlogic/gdx/scenes/scene2d/ui/Image;", "createGlobalPoliticsTable", "getCivInfoTable", "civ", "getPoliciesTable", "getWondersOfCivTable", "getCivName", "otherciv", "getPoliticsOfCivTable", "updateDiagram", "hideCityStateCount", "updateCivTable", "columns", "", "getCivMiniTable", "civInfo", "addTitleInfo", "addCivsCategory", "aliveOrDefeated", "civs", "DiplomacyTabPersistableData", "DiplomacyGroup", "DiagramLegendPopup", "core"})
@SourceDebugExtension(value={"SMAP\nGlobalPoliticsOverviewTable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GlobalPoliticsOverviewTable.kt\ncom/unciv/ui/screens/overviewscreen/GlobalPoliticsOverviewTable\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,562:1\n1788#2,4:563\n1788#2,4:567\n1761#2,3:571\n774#2:577\n865#2,2:578\n1276#3,3:574\n*S KotlinDebug\n*F\n+ 1 GlobalPoliticsOverviewTable.kt\ncom/unciv/ui/screens/overviewscreen/GlobalPoliticsOverviewTable\n*L\n168#1:563,4\n293#1:567,4\n304#1:571,3\n349#1:577\n349#1:578,2\n340#1:574,3\n*E\n"})
public final class GlobalPoliticsOverviewTable
extends EmpireOverviewTab {
    @NotNull
    private final DiplomacyTabPersistableData persistableData;
    @NotNull
    private final Table fixedContent;
    @NotNull
    private final Table civTable;
    @NotNull
    private List<Civilization> undefeatedCivs;
    @NotNull
    private List<Civilization> defeatedCivs;
    @NotNull
    private String relevantCivsCount;
    private boolean showDiplomacyGroup;
    private boolean portraitMode;

    /*
     * WARNING - void declaration
     */
    public GlobalPoliticsOverviewTable(@NotNull Civilization viewingPlayer, @NotNull EmpireOverviewScreen overviewScreen, @Nullable EmpireOverviewTab.EmpireOverviewTabPersistableData persistedData) {
        void $this$civTable_u24lambda_u240;
        Table table2;
        Intrinsics.checkNotNullParameter(viewingPlayer, "viewingPlayer");
        Intrinsics.checkNotNullParameter(overviewScreen, "overviewScreen");
        super(viewingPlayer, overviewScreen, null, 4, null);
        DiplomacyTabPersistableData diplomacyTabPersistableData = persistedData instanceof DiplomacyTabPersistableData ? (DiplomacyTabPersistableData)persistedData : null;
        if (diplomacyTabPersistableData == null) {
            diplomacyTabPersistableData = new DiplomacyTabPersistableData(false, false, 3, null);
        }
        this.persistableData = diplomacyTabPersistableData;
        this.fixedContent = new Table();
        Table table3 = table2 = new Table();
        GlobalPoliticsOverviewTable globalPoliticsOverviewTable = this;
        boolean bl = false;
        $this$civTable_u24lambda_u240.defaults().pad(5.0f);
        $this$civTable_u24lambda_u240.setBackground(SkinStrings.getUiBackground$default(BaseScreen.Companion.getSkinStrings(), "OverviewScreen/DiplomacyOverviewTab/CivTable", null, ImageGetter.INSTANCE.getCHARCOAL(), 2, null));
        globalPoliticsOverviewTable.civTable = table2;
        this.undefeatedCivs = CollectionsKt.emptyList();
        this.defeatedCivs = CollectionsKt.emptyList();
        this.relevantCivsCount = "?";
        this.top();
        if (this.getPersistableData().getShowDiagram()) {
            this.updateDiagram();
        } else {
            this.updatePoliticsTable();
        }
    }

    public /* synthetic */ GlobalPoliticsOverviewTable(Civilization civilization, EmpireOverviewScreen empireOverviewScreen, EmpireOverviewTab.EmpireOverviewTabPersistableData empireOverviewTabPersistableData, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            empireOverviewTabPersistableData = null;
        }
        this(civilization, empireOverviewScreen, empireOverviewTabPersistableData);
    }

    @Override
    @NotNull
    public DiplomacyTabPersistableData getPersistableData() {
        return this.persistableData;
    }

    @Override
    @NotNull
    public Table getFixedContent() {
        return this.fixedContent;
    }

    private final void updatePoliticsTable() {
        this.getPersistableData().setShowDiagram(false);
        this.createGlobalPoliticsHeader();
        this.createGlobalPoliticsTable();
        Table[] tableArray = new Table[]{this.fixedContent, this};
        Scene2dExtensionsKt.equalizeColumns(tableArray);
    }

    /*
     * WARNING - void declaration
     */
    private final Cell<Image> createGlobalPoliticsHeader() {
        void $this$createGlobalPoliticsHeader_u24lambda_u242_u24lambda_u241;
        Table table2;
        Table $this$createGlobalPoliticsHeader_u24lambda_u242 = this.fixedContent;
        boolean bl = false;
        Actor diagramButton2 = ActivationExtensionsKt.onClick(Scene2dExtensionsKt.toTextButton$default("Show diagram", null, false, 3, null), new Function0<Unit>((Object)this){

            public final void invoke() {
                GlobalPoliticsOverviewTable.access$updateDiagram((GlobalPoliticsOverviewTable)this.receiver);
            }
        });
        $this$createGlobalPoliticsHeader_u24lambda_u242.clear();
        $this$createGlobalPoliticsHeader_u24lambda_u242.add();
        Color color = Color.GRAY;
        Intrinsics.checkNotNullExpressionValue(color, "GRAY");
        Scene2dExtensionsKt.addSeparatorVertical$default($this$createGlobalPoliticsHeader_u24lambda_u242, color, 0.0f, 2, null);
        $this$createGlobalPoliticsHeader_u24lambda_u242.add((Actor)Scene2dExtensionsKt.toLabel("Civilization Info"));
        Color color2 = Color.GRAY;
        Intrinsics.checkNotNullExpressionValue(color2, "GRAY");
        Scene2dExtensionsKt.addSeparatorVertical$default($this$createGlobalPoliticsHeader_u24lambda_u242, color2, 0.0f, 2, null);
        $this$createGlobalPoliticsHeader_u24lambda_u242.add((Actor)Scene2dExtensionsKt.toLabel("Social policies"));
        Color color3 = Color.GRAY;
        Intrinsics.checkNotNullExpressionValue(color3, "GRAY");
        Scene2dExtensionsKt.addSeparatorVertical$default($this$createGlobalPoliticsHeader_u24lambda_u242, color3, 0.0f, 2, null);
        $this$createGlobalPoliticsHeader_u24lambda_u242.add((Actor)Scene2dExtensionsKt.toLabel("Wonders"));
        Color color4 = Color.GRAY;
        Intrinsics.checkNotNullExpressionValue(color4, "GRAY");
        Scene2dExtensionsKt.addSeparatorVertical$default($this$createGlobalPoliticsHeader_u24lambda_u242, color4, 0.0f, 2, null);
        Table table3 = table2 = new Table();
        Table table4 = $this$createGlobalPoliticsHeader_u24lambda_u242;
        boolean bl2 = false;
        $this$createGlobalPoliticsHeader_u24lambda_u242_u24lambda_u241.add((Actor)Scene2dExtensionsKt.toLabel("Relations")).padTop(10.0f).row();
        $this$createGlobalPoliticsHeader_u24lambda_u242_u24lambda_u241.add(diagramButton2).pad(10.0f);
        table4.add((Actor)table2);
        Color color5 = Color.GRAY;
        Intrinsics.checkNotNullExpressionValue(color5, "GRAY");
        return Scene2dExtensionsKt.addSeparator$default($this$createGlobalPoliticsHeader_u24lambda_u242, color5, 0, 0.0f, 6, null);
    }

    private final void createGlobalPoliticsTable() {
        this.clear();
        Iterator<Civilization> iterator2 = SequencesKt.plus(SequencesKt.sequenceOf(this.getViewingPlayer()), DiplomacyFunctions.getKnownCivsSorted$default(this.getViewingPlayer().getDiplomacyFunctions(), false, false, 2, null)).iterator();
        while (iterator2.hasNext()) {
            Civilization civ = iterator2.next();
            if (this.getCells().size > 0) {
                Table table2 = this;
                Color color = Color.GRAY;
                Intrinsics.checkNotNullExpressionValue(color, "GRAY");
                Scene2dExtensionsKt.addSeparator$default(table2, color, 0, 0.0f, 6, null);
            }
            this.add((Actor)ImageGetter.INSTANCE.getNationPortrait(civ.getNation(), 100.0f)).pad(20.0f);
            Table table3 = this;
            Color color = Color.GRAY;
            Intrinsics.checkNotNullExpressionValue(color, "GRAY");
            Scene2dExtensionsKt.addSeparatorVertical$default(table3, color, 0.0f, 2, null);
            this.add((Actor)this.getCivInfoTable(civ)).pad(20.0f);
            Table table4 = this;
            Color color2 = Color.GRAY;
            Intrinsics.checkNotNullExpressionValue(color2, "GRAY");
            Scene2dExtensionsKt.addSeparatorVertical$default(table4, color2, 0.0f, 2, null);
            this.add((Actor)this.getPoliciesTable(civ)).pad(20.0f);
            Table table5 = this;
            Color color3 = Color.GRAY;
            Intrinsics.checkNotNullExpressionValue(color3, "GRAY");
            Scene2dExtensionsKt.addSeparatorVertical$default(table5, color3, 0.0f, 2, null);
            this.add((Actor)this.getWondersOfCivTable(civ)).pad(20.0f);
            Table table6 = this;
            Color color4 = Color.GRAY;
            Intrinsics.checkNotNullExpressionValue(color4, "GRAY");
            Scene2dExtensionsKt.addSeparatorVertical$default(table6, color4, 0.0f, 2, null);
            this.add((Actor)this.getPoliticsOfCivTable(civ)).pad(20.0f);
        }
    }

    private final Table getCivInfoTable(Civilization civ) {
        Table civInfoTable = new Table(this.getSkin());
        String leaderName = civ.getNation().getLeaderName();
        civInfoTable.add((Actor)Scene2dExtensionsKt.toLabel$default(leaderName, null, 30, 0, false, 13, null)).row();
        civInfoTable.add((Actor)Scene2dExtensionsKt.toLabel$default(civ.getCivName(), null, 0, 0, true, 7, null)).row();
        civInfoTable.add((Actor)Scene2dExtensionsKt.toLabel(civ.getTech().getEra().getName())).row();
        return civInfoTable;
    }

    /*
     * WARNING - void declaration
     */
    private final Table getPoliciesTable(Civilization civ) {
        Table policiesTable = new Table(this.getSkin());
        for (PolicyBranch branch : civ.getPolicies().getBranches()) {
            int n;
            void $this$count$iv;
            if (!civ.getPolicies().isAdopted(branch.getName())) continue;
            Iterable iterable = branch.getPolicies();
            int n2 = 1;
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    Policy it = (Policy)element$iv;
                    boolean bl = false;
                    if (!(it.getPolicyBranchType() != Policy.PolicyBranchType.BranchComplete && civ.getPolicies().isAdopted(it.getName())) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n = count$iv;
            }
            int n3 = n;
            int count2 = n2 + n3;
            policiesTable.add((Actor)Scene2dExtensionsKt.toLabel('[' + branch.getName() + "]: " + count2)).row();
        }
        return policiesTable;
    }

    private final Table getWondersOfCivTable(Civilization civ) {
        Table wonderTable = new Table(this.getSkin());
        WonderInfo wonderInfo = new WonderInfo();
        for (WonderInfo.WonderInfo wonder : wonderInfo.collectInfo(this.getViewingPlayer())) {
            Civilization civilization = wonder.getCiv();
            if (!Intrinsics.areEqual(civilization != null ? civilization.getCivName() : null, civ.getCivName())) continue;
            Label wonderName = Scene2dExtensionsKt.toLabel(wonder.getName());
            if (wonder.getLocation() != null) {
                ActivationExtensionsKt.onClick(wonderName, () -> GlobalPoliticsOverviewTable.getWondersOfCivTable$lambda$4(wonder));
            }
            wonderTable.add((Actor)wonderName).left().row();
        }
        return wonderTable;
    }

    private final String getCivName(Civilization otherciv) {
        if (this.getViewingPlayer().knows(otherciv) || Intrinsics.areEqual(otherciv.getCivName(), this.getViewingPlayer().getCivName())) {
            return otherciv.getCivName();
        }
        return "an unknown civilization";
    }

    private final Table getPoliticsOfCivTable(Civilization civ) {
        Label turnsLeftText;
        Civilization otherCiv;
        Table politicsTable = new Table(this.getSkin());
        if (!this.getViewingPlayer().knows(civ) && !Intrinsics.areEqual(civ.getCivName(), this.getViewingPlayer().getCivName())) {
            return politicsTable;
        }
        if (civ.isDefeated()) {
            politicsTable.add((Actor)Scene2dExtensionsKt.toLabel("{Defeated} \u2620"));
            return politicsTable;
        }
        Iterator<Civilization> iterator2 = civ.getKnownCivs().iterator();
        while (iterator2.hasNext()) {
            otherCiv = iterator2.next();
            if (!civ.isAtWarWith(otherCiv)) continue;
            String string = "At war with [" + this.getCivName(otherCiv) + ']';
            Color color = Color.RED;
            Intrinsics.checkNotNullExpressionValue(color, "RED");
            ColorMarkupLabel warText = new ColorMarkupLabel(string, color, null, 0, 12, null);
            politicsTable.add((Actor)warText).row();
        }
        politicsTable.row();
        iterator2 = civ.getKnownCivs().iterator();
        while (iterator2.hasNext()) {
            ColorMarkupLabel friendText;
            otherCiv = iterator2.next();
            DiplomacyManager diplomacyManager = civ.getDiplomacy().get(otherCiv.getCivName());
            boolean bl = diplomacyManager != null ? diplomacyManager.hasFlag(DiplomacyFlags.DefensivePact) : false;
            if (bl) {
                String string = "Defensive pact with [" + this.getCivName(otherCiv) + ']';
                Color color = Color.CYAN;
                Intrinsics.checkNotNullExpressionValue(color, "CYAN");
                friendText = new ColorMarkupLabel(string, color, null, 0, 12, null);
                DiplomacyManager diplomacyManager2 = civ.getDiplomacy().get(otherCiv.getCivName());
                turnsLeftText = Scene2dExtensionsKt.toLabel(" (" + (diplomacyManager2 != null ? Integer.valueOf(diplomacyManager2.getFlag(DiplomacyFlags.DefensivePact)) : null) + " \u23f3)");
                politicsTable.add((Actor)friendText);
                politicsTable.add((Actor)turnsLeftText).row();
                continue;
            }
            DiplomacyManager diplomacyManager3 = civ.getDiplomacy().get(otherCiv.getCivName());
            boolean bl2 = diplomacyManager3 != null ? diplomacyManager3.hasFlag(DiplomacyFlags.DeclarationOfFriendship) : false;
            if (!bl2) continue;
            String string = "Friends with [" + this.getCivName(otherCiv) + ']';
            Color color = Color.GREEN;
            Intrinsics.checkNotNullExpressionValue(color, "GREEN");
            friendText = new ColorMarkupLabel(string, color, null, 0, 12, null);
            DiplomacyManager diplomacyManager4 = civ.getDiplomacy().get(otherCiv.getCivName());
            turnsLeftText = Scene2dExtensionsKt.toLabel(" (" + (diplomacyManager4 != null ? Integer.valueOf(diplomacyManager4.getFlag(DiplomacyFlags.DeclarationOfFriendship)) : null) + " \u23f3)");
            politicsTable.add((Actor)friendText);
            politicsTable.add((Actor)turnsLeftText).row();
        }
        politicsTable.row();
        iterator2 = civ.getKnownCivs().iterator();
        while (iterator2.hasNext()) {
            otherCiv = iterator2.next();
            DiplomacyManager diplomacyManager = civ.getDiplomacy().get(otherCiv.getCivName());
            boolean bl = diplomacyManager != null ? diplomacyManager.hasFlag(DiplomacyFlags.Denunciation) : false;
            if (!bl) continue;
            String string = "Denounced [" + this.getCivName(otherCiv) + ']';
            Color color = Color.RED;
            Intrinsics.checkNotNullExpressionValue(color, "RED");
            ColorMarkupLabel denouncedText = new ColorMarkupLabel(string, color, null, 0, 12, null);
            DiplomacyManager diplomacyManager5 = civ.getDiplomacy().get(otherCiv.getCivName());
            turnsLeftText = Scene2dExtensionsKt.toLabel("" + '(' + (diplomacyManager5 != null ? Integer.valueOf(diplomacyManager5.getFlag(DiplomacyFlags.Denunciation)) : null) + " \u23f3)");
            politicsTable.add((Actor)denouncedText);
            politicsTable.add((Actor)turnsLeftText).row();
        }
        politicsTable.row();
        for (Civilization cityState : this.getGameInfo().getAliveCityStates()) {
            DiplomacyManager diplomacyManager = cityState.getDiplomacy().get(civ.getCivName());
            boolean bl = diplomacyManager != null ? diplomacyManager.isRelationshipLevelEQ(RelationshipLevel.Ally) : false;
            if (!bl) continue;
            String string = "Allied with [" + this.getCivName(cityState) + ']';
            Color color = Color.CYAN;
            Intrinsics.checkNotNullExpressionValue(color, "CYAN");
            ColorMarkupLabel alliedText = new ColorMarkupLabel(string, color, null, 0, 12, null);
            politicsTable.add((Actor)alliedText).row();
        }
        return politicsTable;
    }

    /*
     * WARNING - void declaration
     */
    private final void updateDiagram() {
        Table table2;
        int n;
        int n2;
        WidgetGroup floatingTable;
        WidgetGroup civTableScroll;
        TextButton toggleCityStatesButton;
        block13: {
            void $this$any$iv;
            Iterable $this$count$iv;
            GlobalPoliticsOverviewTable globalPoliticsOverviewTable;
            String string;
            this.getPersistableData().setShowDiagram(true);
            Actor politicsButton = ActivationExtensionsKt.onClick(Scene2dExtensionsKt.toTextButton$default("Show global politics", null, false, 3, null), () -> GlobalPoliticsOverviewTable.updateDiagram$lambda$5(this));
            TextButton textButton = Scene2dExtensionsKt.toTextButton$default("City-States", null, false, 3, null);
            WidgetGroup $this$updateDiagram_u24lambda_u247 = textButton;
            boolean bl = false;
            ActivationExtensionsKt.onClick($this$updateDiagram_u24lambda_u247, () -> GlobalPoliticsOverviewTable.updateDiagram$lambda$7$lambda$6(this));
            toggleCityStatesButton = textButton;
            WidgetGroup $this$updateDiagram_u24lambda_u248 = $this$updateDiagram_u24lambda_u247 = new AutoScrollPane((Actor)this.civTable, null, 2, null);
            boolean bl2 = false;
            ((ScrollPane)$this$updateDiagram_u24lambda_u248).setOverscroll(false, false);
            civTableScroll = $this$updateDiagram_u24lambda_u247;
            $this$updateDiagram_u24lambda_u248 = new Table();
            Object $this$updateDiagram_u24lambda_u249 = $this$updateDiagram_u24lambda_u248;
            boolean bl3 = false;
            ((Table)$this$updateDiagram_u24lambda_u249).add((Actor)toggleCityStatesButton).pad(10.0f).row();
            ((Table)$this$updateDiagram_u24lambda_u249).add(politicsButton).row();
            Actor actor = civTableScroll;
            Color color = Color.WHITE;
            Intrinsics.checkNotNullExpressionValue(color, "WHITE");
            ((Table)$this$updateDiagram_u24lambda_u249).add((Actor)Scene2dExtensionsKt.addBorder$default(actor, 2.0f, color, false, 4, null)).pad(10.0f);
            floatingTable = $this$updateDiagram_u24lambda_u248;
            boolean hideCivsCount = this.getViewingPlayer().shouldHideCivCount() || this.getPersistableData().getIncludeCityStates() && this.hideCityStateCount(this.getViewingPlayer());
            GlobalPoliticsOverviewTable globalPoliticsOverviewTable2 = this;
            if (hideCivsCount) {
                string = "?";
            } else {
                int n3;
                $this$updateDiagram_u24lambda_u249 = this.getGameInfo().getCivilizations();
                globalPoliticsOverviewTable = globalPoliticsOverviewTable2;
                boolean $i$f$count = false;
                if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                    n3 = 0;
                } else {
                    int count$iv = 0;
                    for (Object element$iv : $this$count$iv) {
                        Civilization it = (Civilization)element$iv;
                        boolean bl4 = false;
                        if (!(!it.isSpectator() && !it.isBarbarian() && (this.getPersistableData().getIncludeCityStates() || !it.isCityState())) || ++count$iv >= 0) continue;
                        CollectionsKt.throwCountOverflow();
                    }
                    n3 = count$iv;
                }
                n2 = n3;
                globalPoliticsOverviewTable2 = globalPoliticsOverviewTable;
                string = TranslationsKt.tr(n2);
            }
            globalPoliticsOverviewTable2.relevantCivsCount = string;
            this.undefeatedCivs = CollectionsKt.plus((Collection)CollectionsKt.listOf(this.getViewingPlayer()), DiplomacyFunctions.getKnownCivsSorted$default(this.getViewingPlayer().getDiplomacyFunctions(), this.getPersistableData().getIncludeCityStates(), false, 2, null));
            this.defeatedCivs = SequencesKt.toList(SequencesKt.filter(this.getViewingPlayer().getDiplomacyFunctions().getKnownCivsSorted(this.getPersistableData().getIncludeCityStates(), true), GlobalPoliticsOverviewTable::updateDiagram$lambda$11));
            this.clear();
            this.fixedContent.clear();
            $this$count$iv = this.undefeatedCivs;
            globalPoliticsOverviewTable = this;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                n = 0;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Civilization it = (Civilization)element$iv;
                    boolean bl5 = false;
                    if (!(!Intrinsics.areEqual(it, this.getViewingPlayer()))) continue;
                    n = 1;
                    break block13;
                }
                n = 0;
            }
        }
        n2 = n;
        globalPoliticsOverviewTable.showDiplomacyGroup = n2;
        this.updateCivTable(2);
        this.portraitMode = !this.showDiplomacyGroup || this.civTable.getMinWidth() > this.getOverviewScreen().getStage().getWidth() / (float)2 || this.getOverviewScreen().isPortrait();
        Table table3 = table2 = this.portraitMode ? (Table)this : this.fixedContent;
        if (this.showDiplomacyGroup) {
            float diplomacySize = RangesKt.coerceAtMost(this.getOverviewScreen().getStage().getWidth() - (this.portraitMode ? 0.0f : this.civTable.getMinWidth()), this.getOverviewScreen().getCenterAreaHeight$core());
            DiplomacyGroup diplomacyGroup = new DiplomacyGroup(this.undefeatedCivs, diplomacySize);
            table2.add((Actor)diplomacyGroup).top();
        }
        if (this.portraitMode) {
            int columns;
            if (this.showDiplomacyGroup) {
                table2.row();
            }
            if ((columns = 2 * MathKt.roundToInt(this.getOverviewScreen().getStage().getWidth() / this.civTable.getMinWidth())) > 2) {
                this.updateCivTable(columns);
                if (this.civTable.getMinWidth() > this.getOverviewScreen().getStage().getWidth()) {
                    this.updateCivTable(columns - 2);
                }
            }
        }
        table2.add((Actor)floatingTable);
        toggleCityStatesButton.setStyle(this.getPersistableData().getIncludeCityStates() ? BaseScreen.Companion.getSkin().get("negative", TextButton.TextButtonStyle.class) : BaseScreen.Companion.getSkin().get("positive", TextButton.TextButtonStyle.class));
        ((AutoScrollPane)civTableScroll).setScrollingDisabled(this.portraitMode, this.portraitMode);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean hideCityStateCount(Civilization $this$hideCityStateCount) {
        void $this$count$iv;
        if (!$this$hideCityStateCount.getGameInfo().getGameParameters().getRandomNumberOfCityStates()) {
            return false;
        }
        Sequence<Civilization> sequence = $this$hideCityStateCount.getKnownCivs();
        int n = 1;
        boolean $i$f$count = false;
        int count$iv = 0;
        for (Object element$iv : $this$count$iv) {
            Civilization it = (Civilization)element$iv;
            boolean bl = false;
            if (!it.isCityState() || ++count$iv >= 0) continue;
            CollectionsKt.throwCountOverflow();
        }
        int n2 = count$iv;
        int knownCivs = n + n2;
        if (knownCivs >= $this$hideCityStateCount.getGameInfo().getGameParameters().getMaxNumberOfCityStates()) {
            return false;
        }
        return !Civilization.hasUnique$default($this$hideCityStateCount, UniqueType.OneTimeRevealEntireMap, null, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    private final Table updateCivTable(int columns) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Table table2;
        Table $this$updateCivTable_u24lambda_u2415 = table2 = this.civTable;
        boolean bl = false;
        $this$updateCivTable_u24lambda_u2415.clear();
        this.addTitleInfo($this$updateCivTable_u24lambda_u2415, columns);
        Iterable iterable = this.undefeatedCivs;
        String string = "alive";
        int n = columns;
        Table table3 = $this$updateCivTable_u24lambda_u2415;
        GlobalPoliticsOverviewTable globalPoliticsOverviewTable = this;
        boolean $i$f$filter = false;
        void var11_11 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Civilization it = (Civilization)element$iv$iv;
            boolean bl2 = false;
            if (!(!Intrinsics.areEqual(it, this.getViewingPlayer()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list2 = (List)destination$iv$iv;
        globalPoliticsOverviewTable.addCivsCategory(table3, n, string, list2);
        this.addCivsCategory($this$updateCivTable_u24lambda_u2415, columns, "defeated", this.defeatedCivs);
        $this$updateCivTable_u24lambda_u2415.layout();
        return table2;
    }

    private final Table getCivMiniTable(Civilization civInfo) {
        Table table2 = new Table();
        table2.add((Actor)ImageGetter.INSTANCE.getNationPortrait(civInfo.getNation(), 25.0f)).pad(5.0f);
        table2.add((Actor)Scene2dExtensionsKt.toLabel$default(civInfo.getCivName(), null, 0, 0, true, 7, null)).left().padRight(10.0f);
        table2.setTouchable(Touchable.enabled);
        ActivationExtensionsKt.onClick(table2, () -> GlobalPoliticsOverviewTable.getCivMiniTable$lambda$16(civInfo, this));
        return table2;
    }

    private final void addTitleInfo(Table $this$addTitleInfo, int columns) {
        $this$addTitleInfo.add((Actor)Scene2dExtensionsKt.toLabel('[' + this.relevantCivsCount + "] Civilizations in the game")).colspan(columns).row();
        $this$addTitleInfo.add((Actor)Scene2dExtensionsKt.toLabel("Our Civilization:")).colspan(columns).left().padLeft(10.0f).padTop(10.0f).row();
        $this$addTitleInfo.add((Actor)this.getCivMiniTable(this.getViewingPlayer())).left();
        String scoreText = this.getViewingPlayer().isDefeated() ? "\u2620" : TranslationsKt.tr((int)this.getViewingPlayer().calculateTotalScore());
        $this$addTitleInfo.add((Actor)Scene2dExtensionsKt.toLabel(scoreText)).left().row();
        Integer n = this.getViewingPlayer().getTurnsTillNextDiplomaticVote();
        if (n == null) {
            return;
        }
        int turnsTillNextDiplomaticVote = n;
        $this$addTitleInfo.add((Actor)Scene2dExtensionsKt.toLabel("Turns until the next\ndiplomacy victory vote: [" + turnsTillNextDiplomaticVote + ']')).colspan(columns).row();
    }

    private final void addCivsCategory(Table $this$addCivsCategory, int columns, String aliveOrDefeated, List<Civilization> civs) {
        Scene2dExtensionsKt.addSeparator$default($this$addCivsCategory, null, 0, 0.0f, 7, null);
        int count2 = ((Collection)civs).size();
        $this$addCivsCategory.add((Actor)Scene2dExtensionsKt.toLabel("Known and " + aliveOrDefeated + " ([" + count2 + "])")).pad(5.0f).colspan(columns).row();
        if (count2 == 0) {
            return;
        }
        Scene2dExtensionsKt.addSeparator$default($this$addCivsCategory, null, 0, 0.0f, 7, null);
        Ref.IntRef currentColumn = new Ref.IntRef();
        Ref.BooleanRef lastCivWasMajor = new Ref.BooleanRef();
        for (Civilization civ : civs) {
            if (lastCivWasMajor.element && civ.isCityState()) {
                GlobalPoliticsOverviewTable.addCivsCategory$advanceCols(currentColumn, columns, $this$addCivsCategory, lastCivWasMajor, columns);
            }
            $this$addCivsCategory.add((Actor)this.getCivMiniTable(civ)).left();
            if (civ.isCityState()) {
                GlobalPoliticsOverviewTable.addCivsCategory$advanceCols(currentColumn, columns, $this$addCivsCategory, lastCivWasMajor, 1);
                continue;
            }
            $this$addCivsCategory.add((Actor)Scene2dExtensionsKt.toLabel((int)civ.calculateTotalScore())).left();
            GlobalPoliticsOverviewTable.addCivsCategory$advanceCols(currentColumn, columns, $this$addCivsCategory, lastCivWasMajor, 2);
        }
    }

    private static final Unit getWondersOfCivTable$lambda$4(WonderInfo.WonderInfo $wonder) {
        WorldScreen worldScreen = UncivGame.Companion.getCurrent().resetToWorldScreen();
        WorldMapHolder.setCenterPosition$default(worldScreen.getMapHolder(), $wonder.getLocation().getPosition(), false, false, null, 14, null);
        return Unit.INSTANCE;
    }

    private static final Unit updateDiagram$lambda$5(GlobalPoliticsOverviewTable this$0) {
        this$0.updatePoliticsTable();
        this$0.getOverviewScreen().resizePage(this$0);
        return Unit.INSTANCE;
    }

    private static final Unit updateDiagram$lambda$7$lambda$6(GlobalPoliticsOverviewTable this$0) {
        this$0.getPersistableData().setIncludeCityStates(!this$0.getPersistableData().getIncludeCityStates());
        this$0.updateDiagram();
        return Unit.INSTANCE;
    }

    private static final boolean updateDiagram$lambda$11(Civilization it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.isDefeated();
    }

    private static final Unit getCivMiniTable$lambda$16(Civilization $civInfo, GlobalPoliticsOverviewTable this$0) {
        if ($civInfo.isDefeated() || this$0.getViewingPlayer().isSpectator() || Intrinsics.areEqual($civInfo, this$0.getViewingPlayer())) {
            return Unit.INSTANCE;
        }
        UncivGame.Companion.getCurrent().pushScreen(new DiplomacyScreen(this$0.getViewingPlayer(), $civInfo, null, false, 12, null));
        return Unit.INSTANCE;
    }

    private static final void addCivsCategory$advanceCols(Ref.IntRef currentColumn, int $columns, Table $this_addCivsCategory, Ref.BooleanRef lastCivWasMajor, int delta) {
        currentColumn.element += delta;
        if (currentColumn.element >= $columns) {
            $this_addCivsCategory.row();
            currentColumn.element = 0;
        }
        lastCivWasMajor.element = delta == 2;
    }

    public static final /* synthetic */ void access$updateDiagram(GlobalPoliticsOverviewTable $this) {
        $this.updateDiagram();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\u001a\u0010\n\u001a\u00020\u000b*\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f\u00a8\u0006\u0011"}, d2={"Lcom/unciv/ui/screens/overviewscreen/GlobalPoliticsOverviewTable$DiagramLegendPopup;", "Lcom/unciv/ui/popups/AnimatedMenuPopup;", "stage", "Lcom/badlogic/gdx/scenes/scene2d/Stage;", "diagram", "Lcom/badlogic/gdx/scenes/scene2d/Actor;", "<init>", "(Lcom/badlogic/gdx/scenes/scene2d/Stage;Lcom/badlogic/gdx/scenes/scene2d/Actor;)V", "createContentTable", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "addLegendRow", "", "text", "", "color", "Lcom/badlogic/gdx/graphics/Color;", "Companion", "core"})
    private static final class DiagramLegendPopup
    extends AnimatedMenuPopup {
        @NotNull
        public static final Companion Companion = new Companion(null);
        public static final float lineWidth = 3.0f;
        public static final float lowContrastWidth = 4.0f;
        public static final float lineLength = 120.0f;

        public DiagramLegendPopup(@NotNull Stage stage, @NotNull Actor diagram) {
            Intrinsics.checkNotNullParameter(stage, "stage");
            Intrinsics.checkNotNullParameter(diagram, "diagram");
            super(stage, DiagramLegendPopup.Companion.getCenterInStageCoordinates(diagram));
            this.setTouchable(Touchable.enabled);
            ActivationExtensionsKt.onActivation(this, () -> DiagramLegendPopup._init_$lambda$0(this));
        }

        @Override
        @NotNull
        public Table createContentTable() {
            Table legend = new Table();
            legend.setBackground(ImageGetter.INSTANCE.getDrawable("OtherIcons/Politics-diagram-bg"));
            legend.add((Actor)new ShadowedLabel("Diagram line colors", 24, null, null, false, 0.0f, 60, null)).colspan(2).row();
            Color color = Color.RED;
            Intrinsics.checkNotNullExpressionValue(color, "RED");
            this.addLegendRow(legend, "War", color);
            Object object = RelationshipLevel.getEntries().iterator();
            while (object.hasNext()) {
                RelationshipLevel level = (RelationshipLevel)((Object)object.next());
                this.addLegendRow(legend, level.name(), level.getColor());
            }
            Color color2 = Color.PURPLE;
            Intrinsics.checkNotNullExpressionValue(color2, "PURPLE");
            this.addLegendRow(legend, "Defensive Pact", color2);
            Table table2 = super.createContentTable();
            Intrinsics.checkNotNull(table2);
            Object $this$createContentTable_u24lambda_u241 = object = table2;
            boolean bl = false;
            ((Table)$this$createContentTable_u24lambda_u241).add((Actor)legend).grow();
            return object;
        }

        public final void addLegendRow(@NotNull Table $this$addLegendRow, @NotNull String text, @NotNull Color color) {
            Intrinsics.checkNotNullParameter($this$addLegendRow, "<this>");
            Intrinsics.checkNotNullParameter(text, "text");
            Intrinsics.checkNotNullParameter(color, "color");
            Color color2 = Color.DARK_GRAY;
            Intrinsics.checkNotNullExpressionValue(color2, "DARK_GRAY");
            float contrast = (float)NationKt.getContrastRatio(color2, color);
            float width = 3.0f + 1.0f / RangesKt.coerceAtLeast(contrast, 1.0f);
            Image line = ImageGetter.INSTANCE.getLine(0.0f, width / (float)2, 120.0f, width / (float)2, width);
            line.setColor(color);
            $this$addLegendRow.add((Actor)line).size(120.0f, width).padTop(5.0f);
            $this$addLegendRow.add((Actor)new ShadowedLabel(text, 0, null, null, false, 0.0f, 62, null)).padLeft(5.0f).padTop(10.0f).row();
        }

        private static final Unit _init_$lambda$0(DiagramLegendPopup this$0) {
            this$0.close();
            return Unit.INSTANCE;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\u00020\u0005*\u00020\u0006H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/unciv/ui/screens/overviewscreen/GlobalPoliticsOverviewTable$DiagramLegendPopup$Companion;", "", "<init>", "()V", "getCenterInStageCoordinates", "Lcom/badlogic/gdx/math/Vector2;", "Lcom/badlogic/gdx/scenes/scene2d/Actor;", "lineWidth", "", "lowContrastWidth", "lineLength", "core"})
        public static final class Companion {
            private Companion() {
            }

            private final Vector2 getCenterInStageCoordinates(Actor $this$getCenterInStageCoordinates) {
                Vector2 vector2 = $this$getCenterInStageCoordinates.localToStageCoordinates(new Vector2($this$getCenterInStageCoordinates.getWidth() / (float)2, $this$getCenterInStageCoordinates.getHeight() / (float)2));
                Intrinsics.checkNotNullExpressionValue(vector2, "localToStageCoordinates(...)");
                return vector2;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ@\u0010\t\u001a\u00020\n2.\u0010\u000b\u001a*\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\fj\u0014\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e`\u00102\u0006\u0010\u0011\u001a\u00020\rH\u0002\u00a8\u0006\u0012"}, d2={"Lcom/unciv/ui/screens/overviewscreen/GlobalPoliticsOverviewTable$DiplomacyGroup;", "Lcom/badlogic/gdx/scenes/scene2d/Group;", "undefeatedCivs", "", "Lcom/unciv/logic/civilization/Civilization;", "freeSize", "", "<init>", "(Ljava/util/List;F)V", "onCivClicked", "", "civLines", "Ljava/util/HashMap;", "", "", "Lcom/badlogic/gdx/scenes/scene2d/Actor;", "Lkotlin/collections/HashMap;", "name", "core"})
    @SourceDebugExtension(value={"SMAP\nGlobalPoliticsOverviewTable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GlobalPoliticsOverviewTable.kt\ncom/unciv/ui/screens/overviewscreen/GlobalPoliticsOverviewTable$DiplomacyGroup\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,562:1\n1869#2,2:563\n1869#2,2:573\n1869#2,2:576\n536#3:565\n521#3,6:566\n216#4:572\n217#4:575\n*S KotlinDebug\n*F\n+ 1 GlobalPoliticsOverviewTable.kt\ncom/unciv/ui/screens/overviewscreen/GlobalPoliticsOverviewTable$DiplomacyGroup\n*L\n435#1:563,2\n443#1:573,2\n447#1:576,2\n442#1:565\n442#1:566,6\n443#1:572\n443#1:575\n*E\n"})
    private static final class DiplomacyGroup
    extends Group {
        public DiplomacyGroup(@NotNull List<Civilization> undefeatedCivs, float freeSize) {
            Intrinsics.checkNotNullParameter(undefeatedCivs, "undefeatedCivs");
            this.setSize(freeSize, freeSize);
            ClickableCircle clickableArea = new ClickableCircle(freeSize / 1.25f - 25.0f);
            ActivationExtensionsKt.onActivation(clickableArea, () -> DiplomacyGroup._init_$lambda$5(this));
            Scene2dExtensionsKt.center((Actor)clickableArea, this);
            this.addActor(clickableArea);
            HashMap civGroups = new HashMap();
            HashMap civLines = new HashMap();
            int civCount = ((Collection)undefeatedCivs).size();
            Iterator<Object> iterator2 = ((Iterable)undefeatedCivs).iterator();
            int n = 0;
            while (iterator2.hasNext()) {
                int i = n++;
                Civilization civ = (Civilization)iterator2.next();
                Portrait civGroup = ImageGetter.INSTANCE.getNationPortrait(civ.getNation(), 30.0f);
                Vector2 vector = HexMath.INSTANCE.getVectorForAngle((float)Math.PI * 2 * (float)i / (float)civCount);
                Scene2dExtensionsKt.center((Actor)civGroup, this);
                civGroup.moveBy(vector.x * freeSize / 2.25f, vector.y * freeSize / 2.25f);
                civGroup.setTouchable(Touchable.enabled);
                ActivationExtensionsKt.onClick(civGroup, () -> DiplomacyGroup._init_$lambda$6(this, civLines, civ));
                UncivTooltip.Companion.addTooltip$default(UncivTooltip.Companion, civGroup, civ.getCivName(), 0.0f, false, 0, 12, false, null, 110, null);
                ((Map)civGroups).put(civ.getCivName(), civGroup);
                this.addActor(civGroup);
            }
            for (Civilization civ : undefeatedCivs) {
                if (civ.isDefeated()) continue;
                Iterator<DiplomacyManager> iterator3 = civ.getDiplomacy().values().iterator();
                while (iterator3.hasNext()) {
                    DiplomacyManager diplomacy;
                    Intrinsics.checkNotNullExpressionValue(iterator3.next(), "next(...)");
                    Civilization otherCiv = diplomacy.otherCiv();
                    if (!undefeatedCivs.contains(otherCiv) || otherCiv.isDefeated()) continue;
                    Object v = civGroups.get(civ.getCivName());
                    Intrinsics.checkNotNull(v);
                    Actor civGroup = (Actor)v;
                    Object v2 = civGroups.get(diplomacy.getOtherCivName());
                    Intrinsics.checkNotNull(v2);
                    Actor otherCivGroup = (Actor)v2;
                    Image statusLine = ImageGetter.INSTANCE.getLine(civGroup.getX() + civGroup.getWidth() / (float)2, civGroup.getY() + civGroup.getHeight() / (float)2, otherCivGroup.getX() + otherCivGroup.getWidth() / (float)2, otherCivGroup.getY() + otherCivGroup.getHeight() / (float)2, 2.0f);
                    statusLine.setColor(diplomacy.getDiplomaticStatus() == DiplomaticStatus.War ? Color.RED : (diplomacy.getDiplomaticStatus() == DiplomaticStatus.DefensivePact && !civ.isCityState() && !otherCiv.isCityState() ? Color.PURPLE : (civ.isHuman() && otherCiv.isHuman() && diplomacy.hasModifier(DiplomaticModifiers.DeclarationOfFriendship) ? RelationshipLevel.Friend.getColor() : (civ.isCityState() && Intrinsics.areEqual(civ.getAllyCivName(), diplomacy.getOtherCivName()) || otherCiv.isCityState() && Intrinsics.areEqual(otherCiv.getAllyCivName(), civ.getCivName()) ? RelationshipLevel.Ally.getColor() : diplomacy.relationshipLevel().getColor()))));
                    if (!civLines.containsKey(civ.getCivName())) {
                        ((Map)civLines).put(civ.getCivName(), (Set)new LinkedHashSet());
                    }
                    Object v3 = civLines.get(civ.getCivName());
                    Intrinsics.checkNotNull(v3);
                    ((Set)v3).add(statusLine);
                    this.addActorAt(0, statusLine);
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void onCivClicked(HashMap<String, Set<Actor>> civLines, String name) {
            Iterable $this$forEach$iv;
            Set<Actor> set = civLines.get(name);
            if (set == null) {
                return;
            }
            Set<Actor> selectedLines = set;
            boolean atLeastOneLineVisible = false;
            boolean allAreLinesInvisible = true;
            Iterator<Set<Actor>> iterator2 = civLines.values().iterator();
            while (iterator2.hasNext()) {
                Set<Actor> lines2;
                Intrinsics.checkNotNullExpressionValue(iterator2.next(), "next(...)");
                if (Intrinsics.areEqual(lines2, selectedLines) || lines2.isEmpty()) continue;
                boolean visibility = ((Actor)CollectionsKt.first((Iterable)lines2)).isVisible();
                atLeastOneLineVisible = atLeastOneLineVisible || visibility;
                boolean bl = allAreLinesInvisible = allAreLinesInvisible && visibility;
                if (!atLeastOneLineVisible || allAreLinesInvisible) continue;
                Iterable $this$forEach$iv2 = selectedLines;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv2) {
                    Actor it = (Actor)element$iv;
                    boolean bl2 = false;
                    it.setVisible(!it.isVisible());
                }
                return;
            }
            if (((Actor)CollectionsKt.first((Iterable)selectedLines)).isVisible()) {
                void $this$filterTo$iv$iv;
                Map $this$filter$iv = civLines;
                boolean $i$f$filter = false;
                Map visibility = $this$filter$iv;
                Map destination$iv$iv = new LinkedHashMap();
                boolean $i$f$filterTo = false;
                Iterator iterator3 = $this$filterTo$iv$iv.entrySet().iterator();
                while (iterator3.hasNext()) {
                    Map.Entry element$iv$iv;
                    Map.Entry it = element$iv$iv = iterator3.next();
                    boolean bl = false;
                    if (!(!Intrinsics.areEqual(it.getKey(), name))) continue;
                    destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
                }
                $this$filter$iv = destination$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator4 = $this$forEach$iv.entrySet().iterator();
                while (iterator4.hasNext()) {
                    Map.Entry element$iv;
                    Map.Entry it = element$iv = iterator4.next();
                    boolean bl = false;
                    Iterable $this$forEach$iv3 = (Iterable)it.getValue();
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv2 : $this$forEach$iv3) {
                        Actor line = (Actor)element$iv2;
                        boolean bl3 = false;
                        line.setVisible(!line.isVisible());
                    }
                }
            } else {
                $this$forEach$iv = selectedLines;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Actor it = (Actor)element$iv;
                    boolean bl = false;
                    it.setVisible(!it.isVisible());
                }
            }
        }

        private static final Unit _init_$lambda$5(DiplomacyGroup this$0) {
            Stage stage = this$0.getStage();
            Intrinsics.checkNotNullExpressionValue(stage, "getStage(...)");
            new DiagramLegendPopup(stage, (Actor)this$0);
            return Unit.INSTANCE;
        }

        private static final Unit _init_$lambda$6(DiplomacyGroup this$0, HashMap $civLines, Civilization $civ) {
            this$0.onCivClicked($civLines, $civ.getCivName());
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\r\u001a\u00020\u0003H\u0016R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\b\"\u0004\b\f\u0010\n\u00a8\u0006\u000e"}, d2={"Lcom/unciv/ui/screens/overviewscreen/GlobalPoliticsOverviewTable$DiplomacyTabPersistableData;", "Lcom/unciv/ui/screens/overviewscreen/EmpireOverviewTab$EmpireOverviewTabPersistableData;", "showDiagram", "", "includeCityStates", "<init>", "(ZZ)V", "getShowDiagram", "()Z", "setShowDiagram", "(Z)V", "getIncludeCityStates", "setIncludeCityStates", "isEmpty", "core"})
    public static final class DiplomacyTabPersistableData
    extends EmpireOverviewTab.EmpireOverviewTabPersistableData {
        private boolean showDiagram;
        private boolean includeCityStates;

        public DiplomacyTabPersistableData(boolean showDiagram, boolean includeCityStates) {
            this.showDiagram = showDiagram;
            this.includeCityStates = includeCityStates;
        }

        public /* synthetic */ DiplomacyTabPersistableData(boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                bl = false;
            }
            if ((n & 2) != 0) {
                bl2 = false;
            }
            this(bl, bl2);
        }

        public final boolean getShowDiagram() {
            return this.showDiagram;
        }

        public final void setShowDiagram(boolean bl) {
            this.showDiagram = bl;
        }

        public final boolean getIncludeCityStates() {
            return this.includeCityStates;
        }

        public final void setIncludeCityStates(boolean bl) {
            this.includeCityStates = bl;
        }

        @Override
        public boolean isEmpty() {
            return !this.showDiagram && !this.includeCityStates;
        }

        public DiplomacyTabPersistableData() {
            this(false, false, 3, null);
        }
    }
}

