/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.popups.options;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.unciv.UncivGame;
import com.unciv.models.UncivSound;
import com.unciv.models.metadata.GameSettings;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.audio.MusicController;
import com.unciv.ui.audio.MusicTrackChooserFlags;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.widgets.UncivSlider;
import com.unciv.ui.components.widgets.WrappableLabel;
import com.unciv.ui.popups.Popup;
import com.unciv.ui.popups.options.OptionsPopup;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.utils.Concurrency;
import com.unciv.utils.ConcurrencyKt;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a:\u0010\u0007\u001a\u00020\u0005*\u00020\u00012\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\r2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00050\u000fH\u0002\u001a\u0018\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u001a\u0018\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u001a\u0018\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u001a \u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u001a \u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u001a\u0018\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u001a\u0018\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u001a\u001e\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017\u00a8\u0006\u001c"}, d2={"soundTab", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "optionsPopup", "Lcom/unciv/ui/popups/options/OptionsPopup;", "addDownloadMusic", "", "table", "addVolumeSlider", "text", "", "initial", "", "silent", "", "onChange", "Lkotlin/Function1;", "addSoundEffectsVolumeSlider", "settings", "Lcom/unciv/models/metadata/GameSettings;", "addCitySoundsVolumeSlider", "addVoicesVolumeSlider", "addMusicVolumeSlider", "music", "Lcom/unciv/ui/audio/MusicController;", "addMusicPauseSlider", "addMusicCurrentlyPlaying", "addSimplePlayerControls", "addMusicControls", "core"})
public final class SoundTabKt {
    @NotNull
    public static final Table soundTab(@NotNull OptionsPopup optionsPopup) {
        Table table2;
        Intrinsics.checkNotNullParameter(optionsPopup, "optionsPopup");
        Table $this$soundTab_u24lambda_u240 = table2 = new Table(BaseScreen.Companion.getSkin());
        boolean bl = false;
        $this$soundTab_u24lambda_u240.pad(10.0f);
        $this$soundTab_u24lambda_u240.defaults().pad(5.0f);
        GameSettings settings = optionsPopup.getSettings();
        MusicController music = UncivGame.Companion.getCurrent().getMusicController();
        SoundTabKt.addSoundEffectsVolumeSlider($this$soundTab_u24lambda_u240, settings);
        SoundTabKt.addCitySoundsVolumeSlider($this$soundTab_u24lambda_u240, settings);
        if (UncivGame.Companion.getCurrent().getMusicController().isVoicesAvailable()) {
            SoundTabKt.addVoicesVolumeSlider($this$soundTab_u24lambda_u240, settings);
        }
        if (UncivGame.Companion.getCurrent().getMusicController().isMusicAvailable()) {
            SoundTabKt.addMusicControls($this$soundTab_u24lambda_u240, settings, music);
        }
        if (!UncivGame.Companion.getCurrent().getMusicController().isDefaultFileAvailable()) {
            SoundTabKt.addDownloadMusic($this$soundTab_u24lambda_u240, optionsPopup);
        }
        return table2;
    }

    private static final void addDownloadMusic(Table table2, OptionsPopup optionsPopup) {
        TextButton downloadMusicButton = Scene2dExtensionsKt.toTextButton$default("Download music", null, false, 3, null);
        table2.add((Actor)downloadMusicButton).colspan(2).row();
        Table errorTable = new Table();
        table2.add((Actor)errorTable).colspan(2).row();
        ActivationExtensionsKt.onClick(downloadMusicButton, () -> SoundTabKt.addDownloadMusic$lambda$1(downloadMusicButton, errorTable, optionsPopup));
    }

    private static final void addVolumeSlider(Table $this$addVolumeSlider, String text, float initial, boolean silent, Function1<? super Float, Unit> onChange) {
        $this$addVolumeSlider.add(TranslationsKt.tr$default(text, false, false, 3, null)).left().fillX();
        UncivSlider volumeSlider2 = new UncivSlider(0.0f, 1.0f, 0.05f, false, false, initial, silent ? UncivSound.Companion.getSilent() : UncivSound.Companion.getSlider(), null, new Function1<Float, String>((Object)UncivSlider.Companion){

            public final String invoke(float p0) {
                return ((UncivSlider.Companion)this.receiver).formatPercent(p0);
            }
        }, onChange, 152, null);
        $this$addVolumeSlider.add((Actor)volumeSlider2).pad(5.0f).row();
    }

    static /* synthetic */ void addVolumeSlider$default(Table table2, String string, float f, boolean bl, Function1 function1, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        SoundTabKt.addVolumeSlider(table2, string, f, bl, function1);
    }

    private static final void addSoundEffectsVolumeSlider(Table table2, GameSettings settings) {
        SoundTabKt.addVolumeSlider$default(table2, "Sound effects volume", settings.getSoundEffectsVolume(), false, arg_0 -> SoundTabKt.addSoundEffectsVolumeSlider$lambda$2(settings, arg_0), 4, null);
    }

    private static final void addCitySoundsVolumeSlider(Table table2, GameSettings settings) {
        SoundTabKt.addVolumeSlider$default(table2, "City ambient sound volume", settings.getCitySoundsVolume(), false, arg_0 -> SoundTabKt.addCitySoundsVolumeSlider$lambda$3(settings, arg_0), 4, null);
    }

    private static final void addVoicesVolumeSlider(Table table2, GameSettings settings) {
        SoundTabKt.addVolumeSlider$default(table2, "Leader voices volume", settings.getVoicesVolume(), false, arg_0 -> SoundTabKt.addVoicesVolumeSlider$lambda$4(settings, arg_0), 4, null);
    }

    private static final void addMusicVolumeSlider(Table table2, GameSettings settings, MusicController music) {
        SoundTabKt.addVolumeSlider(table2, TranslationsKt.tr$default("Music volume", false, false, 3, null), settings.getMusicVolume(), true, arg_0 -> SoundTabKt.addMusicVolumeSlider$lambda$5(settings, music, arg_0));
    }

    private static final void addMusicPauseSlider(Table table2, GameSettings settings, MusicController music) {
        Function1<Float, String> getTipText = SoundTabKt::addMusicPauseSlider$lambda$6;
        table2.add(TranslationsKt.tr$default("Pause between tracks", false, false, 3, null)).left().fillX();
        UncivSlider pauseLengthSlider = new UncivSlider(0.0f, 30.0f, 1.0f, false, false, SoundTabKt.addMusicPauseSlider$lengthToPos(music.getSilenceLength()), UncivSound.Companion.getSilent(), null, getTipText, arg_0 -> SoundTabKt.addMusicPauseSlider$lambda$7(music, settings, arg_0), 152, null);
        table2.add((Actor)pauseLengthSlider).pad(5.0f).row();
    }

    private static final void addMusicCurrentlyPlaying(Table table2, MusicController music) {
        block0: {
            WrappableLabel label = new WrappableLabel("", table2.getWidth() - 10.0f, new Color(-3100673), 16, false, 16, null);
            label.setWrap(true);
            table2.add((Actor)label).padTop(20.0f).colspan(2).fillX().row();
            music.onChange(arg_0 -> SoundTabKt.addMusicCurrentlyPlaying$lambda$8(label, arg_0));
            Popup popup2 = table2.firstAscendant(Popup.class);
            if (popup2 == null) break block0;
            Popup $this$addMusicCurrentlyPlaying_u24lambda_u2410 = popup2;
            boolean bl = false;
            $this$addMusicCurrentlyPlaying_u24lambda_u2410.getCloseListeners().add(() -> SoundTabKt.addMusicCurrentlyPlaying$lambda$10$lambda$9(music));
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void addSimplePlayerControls(Table table2, MusicController music) {
        void $this$addSimplePlayerControls_u24lambda_u2414;
        Table table3;
        Table table4 = table3 = new Table();
        Table table5 = table2;
        boolean bl = false;
        $this$addSimplePlayerControls_u24lambda_u2414.defaults().space(25.0f);
        Color color = Color.GOLD;
        Intrinsics.checkNotNullExpressionValue(color, "GOLD");
        $this$addSimplePlayerControls_u24lambda_u2414.add(ActivationExtensionsKt.onClick(SoundTabKt.addSimplePlayerControls$toImageButton("OtherIcons/Pause", color), () -> SoundTabKt.addSimplePlayerControls$lambda$14$lambda$11(music)));
        Color color2 = Color.LIME;
        Intrinsics.checkNotNullExpressionValue(color2, "LIME");
        $this$addSimplePlayerControls_u24lambda_u2414.add(ActivationExtensionsKt.onClick(SoundTabKt.addSimplePlayerControls$toImageButton("OtherIcons/ForwardArrow", color2), () -> SoundTabKt.addSimplePlayerControls$lambda$14$lambda$12(music)));
        Color color3 = Color.VIOLET;
        Intrinsics.checkNotNullExpressionValue(color3, "VIOLET");
        $this$addSimplePlayerControls_u24lambda_u2414.add(ActivationExtensionsKt.onClick(SoundTabKt.addSimplePlayerControls$toImageButton("OtherIcons/Loading", color3), () -> SoundTabKt.addSimplePlayerControls$lambda$14$lambda$13(music)));
        table5.add((Actor)table3).colspan(2).center().row();
    }

    public static final void addMusicControls(@NotNull Table table2, @NotNull GameSettings settings, @NotNull MusicController music) {
        Intrinsics.checkNotNullParameter(table2, "table");
        Intrinsics.checkNotNullParameter(settings, "settings");
        Intrinsics.checkNotNullParameter(music, "music");
        SoundTabKt.addMusicVolumeSlider(table2, settings, music);
        SoundTabKt.addMusicPauseSlider(table2, settings, music);
        SoundTabKt.addMusicCurrentlyPlaying(table2, music);
        SoundTabKt.addSimplePlayerControls(table2, music);
    }

    private static final Unit addDownloadMusic$lambda$1(TextButton $downloadMusicButton, Table $errorTable, OptionsPopup $optionsPopup) {
        Scene2dExtensionsKt.disable($downloadMusicButton);
        $errorTable.clear();
        $errorTable.add((Actor)Scene2dExtensionsKt.toLabel("Downloading..."));
        Concurrency.run$default(Concurrency.INSTANCE, "MusicDownload", null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>($optionsPopup, $errorTable, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ OptionsPopup $optionsPopup;
            final /* synthetic */ Table $errorTable;
            {
                this.$optionsPopup = $optionsPopup;
                this.$errorTable = $errorTable;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object $result) {
                CoroutineScope coroutineScope = (CoroutineScope)this.L$0;
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$run;
                        ResultKt.throwOnFailure($result);
                        try {
                            UncivGame.Companion.getCurrent().getMusicController().downloadDefaultFile();
                            ConcurrencyKt.launchOnGLThread$default((CoroutineScope)$this$run, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$optionsPopup, null){
                                int label;
                                final /* synthetic */ OptionsPopup $optionsPopup;
                                {
                                    this.$optionsPopup = $optionsPopup;
                                    super(2, $completion);
                                }

                                public final Object invokeSuspend(Object $result) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure($result);
                                            this.$optionsPopup.getTabs().replacePage("Sound", (Actor)SoundTabKt.soundTab(this.$optionsPopup));
                                            MusicController.chooseTrack$default(UncivGame.Companion.getCurrent().getMusicController(), null, null, MusicTrackChooserFlags.Companion.getSetPlayDefault(), 3, null);
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }, 1, null);
                        }
                        catch (Exception exception2) {
                            ConcurrencyKt.launchOnGLThread$default((CoroutineScope)$this$run, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$errorTable, null){
                                int label;
                                final /* synthetic */ Table $errorTable;
                                {
                                    this.$errorTable = $errorTable;
                                    super(2, $completion);
                                }

                                public final Object invokeSuspend(Object $result) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure($result);
                                            this.$errorTable.clear();
                                            Color color = Color.RED;
                                            Intrinsics.checkNotNullExpressionValue(color, "RED");
                                            this.$errorTable.add((Actor)Scene2dExtensionsKt.toLabel$default("Could not download music!", color, 0, 0, false, 14, null));
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }, 1, null);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)((Object)function2);
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 2, null);
        return Unit.INSTANCE;
    }

    private static final Unit addSoundEffectsVolumeSlider$lambda$2(GameSettings $settings, float it) {
        $settings.setSoundEffectsVolume(it);
        return Unit.INSTANCE;
    }

    private static final Unit addCitySoundsVolumeSlider$lambda$3(GameSettings $settings, float it) {
        $settings.setCitySoundsVolume(it);
        return Unit.INSTANCE;
    }

    private static final Unit addVoicesVolumeSlider$lambda$4(GameSettings $settings, float it) {
        $settings.setVoicesVolume(it);
        return Unit.INSTANCE;
    }

    private static final Unit addMusicVolumeSlider$lambda$5(GameSettings $settings, MusicController $music, float it) {
        $settings.setMusicVolume(it);
        $music.setVolume(it);
        if (!$music.isPlaying()) {
            MusicController.chooseTrack$default($music, null, null, MusicTrackChooserFlags.Companion.getSetPlayDefault(), 3, null);
        }
        return Unit.INSTANCE;
    }

    private static final float addMusicPauseSlider$posToLength(float pos) {
        float f;
        block1: {
            float f2;
            block0: {
                f2 = pos;
                boolean bl = 0.0f <= f2 ? f2 <= 10.0f : false;
                if (!bl) break block0;
                f = pos;
                break block1;
            }
            f = (11.0f <= f2 ? f2 <= 20.0f : false) ? pos * 2.0f - 10.0f : ((21.0f <= f2 ? f2 <= 26.0f : false) ? pos * 5.0f - 70.0f : pos * 15.0f - 330.0f);
        }
        return f;
    }

    private static final float addMusicPauseSlider$lengthToPos(float length) {
        float f;
        block1: {
            float f2;
            block0: {
                f2 = length;
                boolean bl = 0.0f <= f2 ? f2 <= 10.0f : false;
                if (!bl) break block0;
                f = length;
                break block1;
            }
            f = (11.0f <= f2 ? f2 <= 30.0f : false) ? (length + 10.0f) / 2.0f : ((31.0f <= f2 ? f2 <= 60.0f : false) ? (length + 10.0f) / 5.0f : (length + 330.0f) / 15.0f);
        }
        return (float)Math.floor(f);
    }

    private static final String addMusicPauseSlider$lambda$6(float it) {
        String string = "%.0f";
        Object[] objectArray = new Object[]{Float.valueOf(SoundTabKt.addMusicPauseSlider$posToLength(it))};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
        return string2;
    }

    private static final Unit addMusicPauseSlider$lambda$7(MusicController $music, GameSettings $settings, float it) {
        $music.setSilenceLength(SoundTabKt.addMusicPauseSlider$posToLength(it));
        $settings.setPauseBetweenTracks((int)$music.getSilenceLength());
        return Unit.INSTANCE;
    }

    private static final Unit addMusicCurrentlyPlaying$lambda$8(WrappableLabel $label, MusicController.MusicTrackInfo it) {
        Intrinsics.checkNotNullParameter(it, "it");
        $label.setText(TranslationsKt.tr$default("Currently playing: [" + it + ']', false, false, 3, null));
        return Unit.INSTANCE;
    }

    private static final Unit addMusicCurrentlyPlaying$lambda$10$lambda$9(MusicController $music) {
        $music.onChange(null);
        return Unit.INSTANCE;
    }

    private static final Group addSimplePlayerControls$toImageButton(String $this$addSimplePlayerControls_u24toImageButton, Color overColor) {
        Color color = Color.CLEAR;
        Intrinsics.checkNotNullExpressionValue(color, "CLEAR");
        return Scene2dExtensionsKt.toImageButton($this$addSimplePlayerControls_u24toImageButton, 30.0f, 30.0f, color, overColor);
    }

    private static final Unit addSimplePlayerControls$lambda$14$lambda$11(MusicController $music) {
        MusicController.pause$default($music, 0.5f, false, 2, null);
        return Unit.INSTANCE;
    }

    private static final Unit addSimplePlayerControls$lambda$14$lambda$12(MusicController $music) {
        $music.resume(0.5f);
        return Unit.INSTANCE;
    }

    private static final Unit addSimplePlayerControls$lambda$14$lambda$13(MusicController $music) {
        MusicController.chooseTrack$default($music, null, null, MusicTrackChooserFlags.Companion.getNone(), 3, null);
        return Unit.INSTANCE;
    }
}

