/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.images;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.NinePatch;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.utils.NinePatchDrawable;
import com.badlogic.gdx.scenes.scene2d.utils.TextureRegionDrawable;
import com.unciv.UncivGame;
import com.unciv.json.UncivJsonKt;
import com.unciv.models.ruleset.Belief;
import com.unciv.models.ruleset.PerpetualConstruction;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.nation.Nation;
import com.unciv.models.ruleset.unit.BaseUnit;
import com.unciv.models.skins.SkinCache;
import com.unciv.models.skins.SkinStrings;
import com.unciv.models.tilesets.TileSetCache;
import com.unciv.ui.components.NonTransformGroup;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.fonts.FontRulesetIcons;
import com.unciv.ui.images.ImageWithCustomSize;
import com.unciv.ui.images.Portrait;
import com.unciv.ui.images.PortraitBuilding;
import com.unciv.ui.images.PortraitImprovement;
import com.unciv.ui.images.PortraitNation;
import com.unciv.ui.images.PortraitPromotion;
import com.unciv.ui.images.PortraitReligion;
import com.unciv.ui.images.PortraitResource;
import com.unciv.ui.images.PortraitTech;
import com.unciv.ui.images.PortraitUnique;
import com.unciv.ui.images.PortraitUnit;
import com.unciv.ui.images.PortraitUnitAction;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.utils.LogKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00d0\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0013\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u0093\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u001e\u001a\u0004\u0018\u00010\f2\u0006\u0010\u001f\u001a\u00020\u0005J\u0006\u0010 \u001a\u00020!J\u0006\u0010\"\u001a\u00020!J\u0018\u0010#\u001a\u00020!2\u0006\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010$\u001a\u00020%J\u0018\u0010&\u001a\u00020!2\u0006\u0010'\u001a\u00020\u00052\u0006\u0010(\u001a\u00020)H\u0002J;\u0010*\u001a\u0012\u0012\u0004\u0012\u00020,0+j\b\u0012\u0004\u0012\u00020,`-2\u0006\u0010.\u001a\u00020\u00052\u0016\u0010/\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\b00\"\u0004\u0018\u00010\b\u00a2\u0006\u0002\u00101J\u0006\u00102\u001a\u00020,J\u0006\u00103\u001a\u00020\u001bJ\u000e\u00104\u001a\u00020,2\u0006\u00105\u001a\u00020\bJ\u0010\u00106\u001a\u0004\u0018\u00010)2\u0006\u0010\u001f\u001a\u00020\u0005J\u000e\u00107\u001a\u00020,2\u0006\u00108\u001a\u00020)J\u000e\u00107\u001a\u00020,2\u0006\u00109\u001a\u00020\u0005J\u001c\u0010:\u001a\u00020,2\b\u00109\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010;\u001a\u0004\u0018\u00010\bJ\u0010\u0010<\u001a\u00020\u001b2\b\u00109\u001a\u0004\u0018\u00010\u0005J\u0012\u0010=\u001a\u0004\u0018\u00010\u001b2\b\u00109\u001a\u0004\u0018\u00010\u0005J\u001c\u0010>\u001a\u00020\u001d2\b\u00109\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010;\u001a\u0004\u0018\u00010\bJ\u000e\u0010?\u001a\u00020%2\u0006\u00109\u001a\u00020\u0005J\u000e\u0010@\u001a\u00020%2\u0006\u00109\u001a\u00020\u0005J\u0018\u0010A\u001a\u00020,2\u0006\u0010B\u001a\u00020\u00052\b\b\u0002\u0010C\u001a\u00020DJ\u000e\u0010E\u001a\u00020%2\u0006\u0010F\u001a\u00020\u0005J\u000e\u0010G\u001a\u00020,2\u0006\u0010F\u001a\u00020\u0005J\u000e\u0010H\u001a\u00020,2\u0006\u0010I\u001a\u00020\u0005J\u0016\u0010J\u001a\u00020K2\u0006\u0010I\u001a\u00020L2\u0006\u0010C\u001a\u00020DJ\u000e\u0010M\u001a\u00020K2\u0006\u0010C\u001a\u00020DJ\u0018\u0010N\u001a\u00020,2\u0006\u0010O\u001a\u00020P2\b\b\u0002\u0010Q\u001a\u00020\bJ\u0016\u0010R\u001a\u00020S2\u0006\u0010T\u001a\u00020\u00052\u0006\u0010C\u001a\u00020DJ\u0016\u0010U\u001a\u00020S2\u0006\u0010V\u001a\u00020\u00052\u0006\u0010C\u001a\u00020DJ\u0018\u0010W\u001a\u00020S2\u0006\u0010X\u001a\u00020\u00052\b\b\u0002\u0010C\u001a\u00020DJ \u0010Y\u001a\u00020S2\u0006\u0010Z\u001a\u00020\u00052\u0006\u0010C\u001a\u00020D2\b\b\u0002\u0010[\u001a\u00020\\J\u0016\u0010]\u001a\u00020S2\u0006\u0010^\u001a\u00020\u00052\u0006\u0010_\u001a\u00020DJ\"\u0010`\u001a\u00020K2\u0006\u0010a\u001a\u00020\u00052\b\b\u0002\u0010C\u001a\u00020D2\b\b\u0002\u0010b\u001a\u00020%J\u0018\u0010c\u001a\u00020K2\u0006\u0010d\u001a\u00020\u00052\b\b\u0002\u0010C\u001a\u00020DJ\u000e\u0010e\u001a\u00020,2\u0006\u0010f\u001a\u00020\u0005J\u0016\u0010g\u001a\u00020K2\u0006\u0010f\u001a\u00020\u00052\u0006\u0010C\u001a\u00020DJ\u000e\u0010h\u001a\u00020%2\u0006\u0010f\u001a\u00020\u0005J \u0010i\u001a\u00020,2\u0006\u0010j\u001a\u00020\u00052\u0006\u0010C\u001a\u00020D2\b\b\u0002\u0010k\u001a\u00020\bJ\u0006\u0010l\u001a\u00020\u001bJ\u0006\u0010m\u001a\u00020,J!\u0010m\u001a\u00020,2\b\b\u0002\u0010Q\u001a\u00020\b2\n\b\u0002\u0010C\u001a\u0004\u0018\u00010D\u00a2\u0006\u0002\u0010nJ\u0006\u0010o\u001a\u00020,J\u0016\u0010p\u001a\u00020q2\u0006\u0010C\u001a\u00020D2\u0006\u0010r\u001a\u00020DJ\u0016\u0010s\u001a\u00020t2\u0006\u0010u\u001a\u00020q2\u0006\u0010v\u001a\u00020DJ\u0010\u0010w\u001a\u00020,2\b\b\u0002\u0010x\u001a\u00020\\J9\u0010y\u001a\u00020z2\u0006\u0010{\u001a\u00020D2\u0006\u0010|\u001a\u00020D2\u0006\u0010}\u001a\u00020D2\u0006\u0010~\u001a\u00020\b2\u0006\u0010\u007f\u001a\u00020\b2\t\b\u0002\u0010\u0080\u0001\u001a\u00020DJ-\u0010\u0081\u0001\u001a\u00030\u0082\u00012\u0007\u0010\u0083\u0001\u001a\u00020D2\u0007\u0010\u0084\u0001\u001a\u00020D2\u0007\u0010\u0085\u0001\u001a\u00020D2\b\b\u0002\u0010|\u001a\u00020DJ3\u0010\u0086\u0001\u001a\u00020,2\u0007\u0010\u0087\u0001\u001a\u00020D2\u0007\u0010\u0088\u0001\u001a\u00020D2\u0007\u0010\u0089\u0001\u001a\u00020D2\u0007\u0010\u008a\u0001\u001a\u00020D2\u0006\u0010{\u001a\u00020DJ\u000f\u0010\u008b\u0001\u001a\u00020,2\u0006\u0010Q\u001a\u00020\bJ\u0014\u0010\u008c\u0001\u001a\u000f\u0012\n\u0012\b0\u0005\u00a2\u0006\u0003\b\u008e\u00010\u008d\u0001J\u000e\u0010\u008f\u0001\u001a\t\u0012\u0004\u0012\u00020\u00050\u0090\u0001J\u000e\u0010\u0091\u0001\u001a\t\u0012\u0004\u0012\u00020\u00050\u0090\u0001J\u000e\u0010\u0092\u0001\u001a\t\u0012\u0004\u0012\u00020\u00050\u0090\u0001R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R*\u0010\u0011\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\f0\u0012j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\f`\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R*\u0010\u001a\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u001b0\u0012j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u001b`\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u001c\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u001d0\u0012j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u001d`\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0094\u0001"}, d2={"Lcom/unciv/ui/images/ImageGetter;", "", "<init>", "()V", "whiteDotLocation", "", "circleLocation", "CHARCOAL", "Lcom/badlogic/gdx/graphics/Color;", "getCHARCOAL", "()Lcom/badlogic/gdx/graphics/Color;", "atlas", "Lcom/badlogic/gdx/graphics/g2d/TextureAtlas;", "getAtlas", "()Lcom/badlogic/gdx/graphics/g2d/TextureAtlas;", "setAtlas", "(Lcom/badlogic/gdx/graphics/g2d/TextureAtlas;)V", "atlases", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "ruleset", "Lcom/unciv/models/ruleset/Ruleset;", "getRuleset", "()Lcom/unciv/models/ruleset/Ruleset;", "setRuleset", "(Lcom/unciv/models/ruleset/Ruleset;)V", "textureRegionDrawables", "Lcom/badlogic/gdx/scenes/scene2d/utils/TextureRegionDrawable;", "ninePatchDrawables", "Lcom/badlogic/gdx/scenes/scene2d/utils/NinePatchDrawable;", "getSpecificAtlas", "name", "resetAtlases", "", "reloadImages", "setNewRuleset", "ignoreIfModsAreEqual", "", "loadModAtlases", "mod", "folder", "Lcom/badlogic/gdx/files/FileHandle;", "getLayeredImageColored", "Ljava/util/ArrayList;", "Lcom/badlogic/gdx/scenes/scene2d/ui/Image;", "Lkotlin/collections/ArrayList;", "baseFileName", "colors", "", "(Ljava/lang/String;[Lcom/badlogic/gdx/graphics/Color;)Ljava/util/ArrayList;", "getWhiteDot", "getWhiteDotDrawable", "getDot", "dotColor", "findExternalImage", "getExternalImage", "file", "fileName", "getImage", "tintColor", "getDrawable", "getDrawableOrNull", "getNinePatch", "imageExists", "ninePatchImageExists", "getStatIcon", "statName", "size", "", "wonderImageExists", "wonderName", "getWonderImage", "getNationIcon", "nation", "getNationPortrait", "Lcom/unciv/ui/images/Portrait;", "Lcom/unciv/models/ruleset/nation/Nation;", "getRandomNationPortrait", "getUnitIcon", "unit", "Lcom/unciv/models/ruleset/unit/BaseUnit;", "color", "getConstructionPortrait", "Lcom/badlogic/gdx/scenes/scene2d/Group;", "construction", "getUniquePortrait", "uniqueName", "getPromotionPortrait", "promotionName", "getResourcePortrait", "resourceName", "amount", "", "getTechIconPortrait", "techName", "circleSize", "getImprovementPortrait", "improvementName", "isPillaged", "getUnitActionPortrait", "actionName", "getReligionIcon", "iconName", "getReligionPortrait", "religionIconExists", "getVictoryTypeIcon", "victoryType", "tint", "getCircleDrawable", "getCircle", "(Lcom/badlogic/gdx/graphics/Color;Ljava/lang/Float;)Lcom/badlogic/gdx/scenes/scene2d/ui/Image;", "getTriangle", "getRedCross", "Lcom/badlogic/gdx/scenes/scene2d/Actor;", "alpha", "getCrossedImage", "Lcom/unciv/ui/components/NonTransformGroup;", "image", "iconSize", "getArrowImage", "align", "getProgressBarVertical", "Lcom/unciv/ui/images/ImageGetter$ProgressBar;", "width", "height", "percentComplete", "progressColor", "backgroundColor", "progressPadding", "getHealthBar", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "currentHealth", "maxHealth", "healthBarSize", "getLine", "startX", "startY", "endX", "endY", "getSpecialistIcon", "getAllImageNames", "", "Lkotlin/jvm/internal/EnhancedNullability;", "getAvailableSkins", "Lkotlin/sequences/Sequence;", "getAvailableTilesets", "getAvailableUnitsets", "ProgressBar", "core"})
@SourceDebugExtension(value={"SMAP\nImageGetter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImageGetter.kt\ncom/unciv/ui/images/ImageGetter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,503:1\n1869#2,2:504\n1#3:506\n183#4,2:507\n*S KotlinDebug\n*F\n+ 1 ImageGetter.kt\ncom/unciv/ui/images/ImageGetter\n*L\n54#1:504,2\n194#1:507,2\n*E\n"})
public final class ImageGetter {
    @NotNull
    public static final ImageGetter INSTANCE = new ImageGetter();
    @NotNull
    public static final String whiteDotLocation = "OtherIcons/whiteDot";
    @NotNull
    public static final String circleLocation = "OtherIcons/Circle";
    @NotNull
    private static final Color CHARCOAL = new Color(0x111111FF);
    public static TextureAtlas atlas;
    @NotNull
    private static final HashMap<String, TextureAtlas> atlases;
    @NotNull
    private static Ruleset ruleset;
    @NotNull
    private static final HashMap<String, TextureRegionDrawable> textureRegionDrawables;
    @NotNull
    private static final HashMap<String, NinePatchDrawable> ninePatchDrawables;

    private ImageGetter() {
    }

    @NotNull
    public final Color getCHARCOAL() {
        return CHARCOAL;
    }

    @NotNull
    public final TextureAtlas getAtlas() {
        TextureAtlas textureAtlas = atlas;
        if (textureAtlas != null) {
            return textureAtlas;
        }
        Intrinsics.throwUninitializedPropertyAccessException("atlas");
        return null;
    }

    public final void setAtlas(@NotNull TextureAtlas textureAtlas) {
        Intrinsics.checkNotNullParameter(textureAtlas, "<set-?>");
        atlas = textureAtlas;
    }

    @NotNull
    public final Ruleset getRuleset() {
        return ruleset;
    }

    public final void setRuleset(@NotNull Ruleset ruleset) {
        Intrinsics.checkNotNullParameter(ruleset, "<set-?>");
        ImageGetter.ruleset = ruleset;
    }

    @Nullable
    public final TextureAtlas getSpecificAtlas(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        return atlases.get(name);
    }

    public final void resetAtlases() {
        Collection<TextureAtlas> collection = atlases.values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TextureAtlas it = (TextureAtlas)element$iv;
            boolean bl = false;
            it.dispose();
        }
        atlases.clear();
    }

    public final void reloadImages() {
        ImageGetter.setNewRuleset$default(this, ruleset, false, 2, null);
    }

    public final void setNewRuleset(@NotNull Ruleset ruleset, boolean ignoreIfModsAreEqual) {
        Intrinsics.checkNotNullParameter(ruleset, "ruleset");
        if (ignoreIfModsAreEqual) {
            if (Intrinsics.areEqual(ruleset.getMods(), ImageGetter.ruleset.getMods())) {
                return;
            }
        }
        ImageGetter.ruleset = ruleset;
        textureRegionDrawables.clear();
        FileHandle fileHandle = Gdx.files.internal("");
        Intrinsics.checkNotNullExpressionValue(fileHandle, "internal(...)");
        this.loadModAtlases("", fileHandle);
        Set<String> visualMods = SetsKt.plus((Set)UncivGame.Companion.getCurrent().getSettings().getVisualMods(), (Iterable)ruleset.getMods());
        for (String mod : visualMods) {
            this.loadModAtlases(mod, UncivGame.Companion.getCurrent().getFiles().getModFolder(mod));
        }
        TileSetCache.INSTANCE.assembleTileSetConfigs((Set<String>)ruleset.getMods());
        SkinCache.INSTANCE.assembleSkinConfigs((Set<String>)ruleset.getMods());
        BaseScreen.Companion.setSkin();
        FontRulesetIcons.INSTANCE.addRulesetImages(ruleset);
    }

    public static /* synthetic */ void setNewRuleset$default(ImageGetter imageGetter, Ruleset ruleset, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        imageGetter.setNewRuleset(ruleset, bl);
    }

    private final void loadModAtlases(String mod, FileHandle folder) {
        FileHandle controlFile = folder.child("Atlases.json");
        String[] stringArray = controlFile.exists() ? UncivJsonKt.json().fromJson(String[].class, controlFile) : new String[]{};
        Intrinsics.checkNotNull(stringArray);
        Set<Object> fileNames = ArraysKt.toMutableSet((Object[])stringArray);
        if (((CharSequence)mod).length() > 0) {
            ((Collection)fileNames).add("game");
        }
        for (Object e : fileNames) {
            Object[] objectArray;
            Intrinsics.checkNotNullExpressionValue(e, "next(...)");
            String fileName = (String)e;
            FileHandle file = folder.child(fileName + ".atlas");
            if (!file.exists()) continue;
            String extraAtlas = ((CharSequence)mod).length() == 0 ? fileName : (Intrinsics.areEqual(fileName, "game") ? mod : mod + '/' + fileName);
            TextureAtlas tempAtlas = atlases.get(extraAtlas);
            if (tempAtlas == null) {
                try {
                    objectArray = new Object[]{extraAtlas, file.path()};
                    LogKt.debug("Loading %s = %s", objectArray);
                    tempAtlas = new TextureAtlas(file);
                    ((Map)atlases).put(extraAtlas, tempAtlas);
                }
                catch (Exception ex) {
                    LogKt.debug("Could not load file " + file, new Object[0]);
                    continue;
                }
            }
            Intrinsics.checkNotNullExpressionValue(tempAtlas.getRegions().iterator(), "iterator(...)");
            while (objectArray.hasNext()) {
                TextureAtlas.AtlasRegion region = (TextureAtlas.AtlasRegion)objectArray.next();
                String string = region.name;
                Intrinsics.checkNotNullExpressionValue(string, "name");
                if (StringsKt.startsWith$default(string, "Skins", false, 2, null)) {
                    NinePatch ninePatch = tempAtlas.createPatch(region.name);
                    ((Map)ninePatchDrawables).put(region.name, new NinePatchDrawable(ninePatch));
                    continue;
                }
                TextureRegionDrawable drawable = new TextureRegionDrawable(region);
                ((Map)textureRegionDrawables).put(region.name, drawable);
            }
        }
    }

    @NotNull
    public final ArrayList<Image> getLayeredImageColored(@NotNull String baseFileName, Color ... colors) {
        Intrinsics.checkNotNullParameter(baseFileName, "baseFileName");
        Intrinsics.checkNotNullParameter(colors, "colors");
        if (!this.imageExists(baseFileName)) {
            return new ArrayList<Image>();
        }
        String[] stringArray = new String[]{baseFileName};
        List<String> layerNames = CollectionsKt.mutableListOf(stringArray);
        ArrayList<Image> layerList = new ArrayList<Image>();
        int number = 1;
        while (this.imageExists(baseFileName + '-' + number)) {
            layerNames.add(baseFileName + '-' + number);
            ++number;
        }
        int n = ((Collection)layerNames).size();
        for (int i = 0; i < n; ++i) {
            Image image = ImageGetter.getImage$default(this, layerNames.get(i), null, 2, null);
            if (i < colors.length && colors[i] != null) {
                image.setColor(colors[i]);
            }
            layerList.add(image);
        }
        return layerList;
    }

    @NotNull
    public final Image getWhiteDot() {
        Image image;
        Image $this$getWhiteDot_u24lambda_u241 = image = ImageGetter.getImage$default(this, whiteDotLocation, null, 2, null);
        boolean bl = false;
        Scene2dExtensionsKt.setSize($this$getWhiteDot_u24lambda_u241, 1.0f);
        return image;
    }

    @NotNull
    public final TextureRegionDrawable getWhiteDotDrawable() {
        TextureRegionDrawable textureRegionDrawable = textureRegionDrawables.get(whiteDotLocation);
        Intrinsics.checkNotNull(textureRegionDrawable);
        return textureRegionDrawable;
    }

    @NotNull
    public final Image getDot(@NotNull Color dotColor) {
        Image image;
        Intrinsics.checkNotNullParameter(dotColor, "dotColor");
        Image $this$getDot_u24lambda_u242 = image = this.getWhiteDot();
        boolean bl = false;
        $this$getDot_u24lambda_u242.setColor(dotColor);
        return image;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final FileHandle findExternalImage(@NotNull String name) {
        Object v0;
        block3: {
            void $this$firstOrNull$iv;
            Sequence<FileHandle> sequence;
            Intrinsics.checkNotNullParameter(name, "name");
            try {
                sequence = SequencesKt.plus(SequencesKt.map(CollectionsKt.asSequence((Iterable)ruleset.getMods()), ImageGetter::findExternalImage$lambda$3), SequencesKt.sequenceOf(Gdx.files.internal("ExtraImages")));
            }
            catch (Exception e) {
                LogKt.debug("Error loading mods: " + e, new Object[0]);
                sequence = SequencesKt.emptySequence();
            }
            Sequence<FileHandle> folders = sequence;
            Object e = new String[]{"", ".png", ".jpg"};
            Sequence<String[]> extensions = SequencesKt.sequenceOf(e);
            e = SequencesKt.flatMap(folders, arg_0 -> ImageGetter.findExternalImage$lambda$5(extensions, name, arg_0));
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                FileHandle it = (FileHandle)element$iv;
                boolean bl = false;
                if (!it.exists()) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        return v0;
    }

    @NotNull
    public final Image getExternalImage(@NotNull FileHandle file) {
        Intrinsics.checkNotNullParameter(file, "file");
        Texture texture = new Texture(file);
        texture.setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
        return new ImageWithCustomSize(new TextureRegion(texture));
    }

    @NotNull
    public final Image getExternalImage(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter(fileName, "fileName");
        FileHandle fileHandle = Gdx.files.internal("ExtraImages/" + fileName);
        Intrinsics.checkNotNullExpressionValue(fileHandle, "internal(...)");
        return this.getExternalImage(fileHandle);
    }

    @NotNull
    public final Image getImage(@Nullable String fileName, @Nullable Color tintColor) {
        ImageWithCustomSize imageWithCustomSize;
        ImageWithCustomSize $this$getImage_u24lambda_u247 = imageWithCustomSize = new ImageWithCustomSize(this.getDrawable(fileName));
        boolean bl = false;
        Color color = tintColor;
        if (color == null) {
            color = Color.WHITE;
        }
        $this$getImage_u24lambda_u247.setColor(color);
        return imageWithCustomSize;
    }

    public static /* synthetic */ Image getImage$default(ImageGetter imageGetter, String string, Color color, int n, Object object) {
        if ((n & 2) != 0) {
            color = null;
        }
        return imageGetter.getImage(string, color);
    }

    @NotNull
    public final TextureRegionDrawable getDrawable(@Nullable String fileName) {
        TextureRegionDrawable textureRegionDrawable = (TextureRegionDrawable)((Map)textureRegionDrawables).get(fileName);
        if (textureRegionDrawable == null) {
            TextureRegionDrawable textureRegionDrawable2 = textureRegionDrawables.get(whiteDotLocation);
            Intrinsics.checkNotNull(textureRegionDrawable2);
            textureRegionDrawable = textureRegionDrawable2;
        }
        return textureRegionDrawable;
    }

    @Nullable
    public final TextureRegionDrawable getDrawableOrNull(@Nullable String fileName) {
        if (fileName == null) {
            return null;
        }
        return textureRegionDrawables.get(fileName);
    }

    @NotNull
    public final NinePatchDrawable getNinePatch(@Nullable String fileName, @Nullable Color tintColor) {
        NinePatchDrawable drawable;
        NinePatchDrawable ninePatchDrawable = (NinePatchDrawable)((Map)ninePatchDrawables).get(fileName);
        if (ninePatchDrawable == null) {
            TextureRegionDrawable textureRegionDrawable = textureRegionDrawables.get(whiteDotLocation);
            Intrinsics.checkNotNull(textureRegionDrawable);
            ninePatchDrawable = drawable = new NinePatchDrawable(new NinePatch(textureRegionDrawable.getRegion()));
        }
        if (fileName == null || ninePatchDrawables.get(fileName) == null) {
            drawable.setMinHeight(0.0f);
            drawable.setMinWidth(0.0f);
        }
        if (tintColor == null) {
            return drawable;
        }
        NinePatchDrawable ninePatchDrawable2 = drawable.tint(tintColor);
        Intrinsics.checkNotNullExpressionValue(ninePatchDrawable2, "tint(...)");
        return ninePatchDrawable2;
    }

    public static /* synthetic */ NinePatchDrawable getNinePatch$default(ImageGetter imageGetter, String string, Color color, int n, Object object) {
        if ((n & 2) != 0) {
            color = null;
        }
        return imageGetter.getNinePatch(string, color);
    }

    public final boolean imageExists(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter(fileName, "fileName");
        return textureRegionDrawables.containsKey(fileName);
    }

    public final boolean ninePatchImageExists(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter(fileName, "fileName");
        return ninePatchDrawables.containsKey(fileName);
    }

    @NotNull
    public final Image getStatIcon(@NotNull String statName, float size) {
        Image image;
        Intrinsics.checkNotNullParameter(statName, "statName");
        Image $this$getStatIcon_u24lambda_u248 = image = ImageGetter.getImage$default(this, "StatIcons/" + statName, null, 2, null);
        boolean bl = false;
        $this$getStatIcon_u24lambda_u248.setSize(size, size);
        return image;
    }

    public static /* synthetic */ Image getStatIcon$default(ImageGetter imageGetter, String string, float f, int n, Object object) {
        if ((n & 2) != 0) {
            f = 20.0f;
        }
        return imageGetter.getStatIcon(string, f);
    }

    public final boolean wonderImageExists(@NotNull String wonderName) {
        Intrinsics.checkNotNullParameter(wonderName, "wonderName");
        return this.imageExists("WonderImages/" + wonderName);
    }

    @NotNull
    public final Image getWonderImage(@NotNull String wonderName) {
        Intrinsics.checkNotNullParameter(wonderName, "wonderName");
        return ImageGetter.getImage$default(this, "WonderImages/" + wonderName, null, 2, null);
    }

    @NotNull
    public final Image getNationIcon(@NotNull String nation) {
        Intrinsics.checkNotNullParameter(nation, "nation");
        return ImageGetter.getImage$default(this, "NationIcons/" + nation, null, 2, null);
    }

    @NotNull
    public final Portrait getNationPortrait(@NotNull Nation nation, float size) {
        Intrinsics.checkNotNullParameter(nation, "nation");
        return new PortraitNation(nation.getName(), size);
    }

    @NotNull
    public final Portrait getRandomNationPortrait(float size) {
        return new PortraitNation("Random", size);
    }

    @NotNull
    public final Image getUnitIcon(@NotNull BaseUnit unit, @NotNull Color color) {
        Image image;
        Intrinsics.checkNotNullParameter(unit, "unit");
        Intrinsics.checkNotNullParameter(color, "color");
        if (this.imageExists("UnitIcons/" + unit.getName())) {
            Image image2;
            Image $this$getUnitIcon_u24lambda_u249 = image2 = ImageGetter.getImage$default(this, "UnitIcons/" + unit.getName(), null, 2, null);
            boolean bl = false;
            $this$getUnitIcon_u24lambda_u249.setColor(color);
            image = image2;
        } else {
            Image image3;
            Image $this$getUnitIcon_u24lambda_u2410 = image3 = ImageGetter.getImage$default(this, "UnitTypeIcons/" + unit.getType(), null, 2, null);
            boolean bl = false;
            $this$getUnitIcon_u24lambda_u2410.setColor(color);
            image = image3;
        }
        return image;
    }

    public static /* synthetic */ Image getUnitIcon$default(ImageGetter imageGetter, BaseUnit baseUnit, Color color, int n, Object object) {
        if ((n & 2) != 0) {
            color = CHARCOAL;
        }
        return imageGetter.getUnitIcon(baseUnit, color);
    }

    @NotNull
    public final Group getConstructionPortrait(@NotNull String construction, float size) {
        Intrinsics.checkNotNullParameter(construction, "construction");
        if (ruleset.getBuildings().containsKey(construction)) {
            return new PortraitBuilding(construction, size);
        }
        if (ruleset.getUnits().containsKey(construction)) {
            return new PortraitUnit(construction, size);
        }
        if (PerpetualConstruction.Companion.getPerpetualConstructionsMap().containsKey(construction)) {
            return Scene2dExtensionsKt.toGroup(ImageGetter.getImage$default(this, "OtherIcons/Convert" + construction, null, 2, null), size);
        }
        return Scene2dExtensionsKt.surroundWithThinCircle$default(Scene2dExtensionsKt.surroundWithCircle$default(ImageGetter.getStatIcon$default(this, construction, 0.0f, 2, null), size, false, null, null, 14, null), null, 1, null);
    }

    @NotNull
    public final Group getUniquePortrait(@NotNull String uniqueName, float size) {
        Intrinsics.checkNotNullParameter(uniqueName, "uniqueName");
        return new PortraitUnique(uniqueName, size);
    }

    @NotNull
    public final Group getPromotionPortrait(@NotNull String promotionName, float size) {
        Intrinsics.checkNotNullParameter(promotionName, "promotionName");
        return new PortraitPromotion(promotionName, size);
    }

    public static /* synthetic */ Group getPromotionPortrait$default(ImageGetter imageGetter, String string, float f, int n, Object object) {
        if ((n & 2) != 0) {
            f = 30.0f;
        }
        return imageGetter.getPromotionPortrait(string, f);
    }

    @NotNull
    public final Group getResourcePortrait(@NotNull String resourceName, float size, int amount) {
        Intrinsics.checkNotNullParameter(resourceName, "resourceName");
        return new PortraitResource(resourceName, size, amount);
    }

    public static /* synthetic */ Group getResourcePortrait$default(ImageGetter imageGetter, String string, float f, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 0;
        }
        return imageGetter.getResourcePortrait(string, f, n);
    }

    @NotNull
    public final Group getTechIconPortrait(@NotNull String techName, float circleSize) {
        Intrinsics.checkNotNullParameter(techName, "techName");
        return new PortraitTech(techName, circleSize);
    }

    @NotNull
    public final Portrait getImprovementPortrait(@NotNull String improvementName, float size, boolean isPillaged) {
        Intrinsics.checkNotNullParameter(improvementName, "improvementName");
        return new PortraitImprovement(improvementName, size, false, isPillaged);
    }

    public static /* synthetic */ Portrait getImprovementPortrait$default(ImageGetter imageGetter, String string, float f, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            f = 20.0f;
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        return imageGetter.getImprovementPortrait(string, f, bl);
    }

    @NotNull
    public final Portrait getUnitActionPortrait(@NotNull String actionName, float size) {
        Intrinsics.checkNotNullParameter(actionName, "actionName");
        return new PortraitUnitAction(actionName, size);
    }

    public static /* synthetic */ Portrait getUnitActionPortrait$default(ImageGetter imageGetter, String string, float f, int n, Object object) {
        if ((n & 2) != 0) {
            f = 20.0f;
        }
        return imageGetter.getUnitActionPortrait(string, f);
    }

    @NotNull
    public final Image getReligionIcon(@NotNull String iconName) {
        Intrinsics.checkNotNullParameter(iconName, "iconName");
        return ImageGetter.getImage$default(this, "ReligionIcons/" + iconName, null, 2, null);
    }

    @NotNull
    public final Portrait getReligionPortrait(@NotNull String iconName, float size) {
        String typeName;
        Intrinsics.checkNotNullParameter(iconName, "iconName");
        if (this.religionIconExists(iconName)) {
            return new PortraitReligion(iconName, size);
        }
        Object object = ruleset.getBeliefs().get(iconName);
        String string = object != null && (object = ((Belief)object).getType()) != null ? ((Enum)object).name() : (typeName = null);
        if (typeName != null && this.religionIconExists(typeName)) {
            return new PortraitReligion(typeName, size);
        }
        return new PortraitReligion(iconName, size);
    }

    public final boolean religionIconExists(@NotNull String iconName) {
        Intrinsics.checkNotNullParameter(iconName, "iconName");
        return this.imageExists("ReligionIcons/" + iconName);
    }

    @NotNull
    public final Image getVictoryTypeIcon(@NotNull String victoryType, float size, @NotNull Color tint) {
        Image image;
        Intrinsics.checkNotNullParameter(victoryType, "victoryType");
        Intrinsics.checkNotNullParameter(tint, "tint");
        if (this.imageExists("VictoryTypeIcons/" + victoryType)) {
            Image image2;
            Image $this$getVictoryTypeIcon_u24lambda_u2411 = image2 = ImageGetter.getImage$default(this, "VictoryTypeIcons/" + victoryType, null, 2, null);
            boolean bl = false;
            $this$getVictoryTypeIcon_u24lambda_u2411.setSize(size, size);
            image = image2;
        } else {
            Image image3;
            Image $this$getVictoryTypeIcon_u24lambda_u2412 = image3 = ImageGetter.getImage$default(this, "OtherIcons/Score", null, 2, null);
            boolean bl = false;
            $this$getVictoryTypeIcon_u24lambda_u2412.setSize(size, size);
            $this$getVictoryTypeIcon_u24lambda_u2412.setColor(tint);
            image = image3;
        }
        return image;
    }

    public static /* synthetic */ Image getVictoryTypeIcon$default(ImageGetter imageGetter, String string, float f, Color color, int n, Object object) {
        if ((n & 4) != 0) {
            color = CHARCOAL;
        }
        return imageGetter.getVictoryTypeIcon(string, f, color);
    }

    @NotNull
    public final TextureRegionDrawable getCircleDrawable() {
        return this.getDrawable(circleLocation);
    }

    @NotNull
    public final Image getCircle() {
        return ImageGetter.getImage$default(this, circleLocation, null, 2, null);
    }

    @NotNull
    public final Image getCircle(@NotNull Color color, @Nullable Float size) {
        Image image;
        Intrinsics.checkNotNullParameter(color, "color");
        Image $this$getCircle_u24lambda_u2413 = image = this.getCircle();
        boolean bl = false;
        $this$getCircle_u24lambda_u2413.setColor(color);
        if (size != null) {
            $this$getCircle_u24lambda_u2413.setSize(size.floatValue(), size.floatValue());
        }
        return image;
    }

    public static /* synthetic */ Image getCircle$default(ImageGetter imageGetter, Color color, Float f, int n, Object object) {
        if ((n & 1) != 0) {
            Color color2 = Color.WHITE;
            Intrinsics.checkNotNullExpressionValue(color2, "WHITE");
            color = color2;
        }
        if ((n & 2) != 0) {
            f = null;
        }
        return imageGetter.getCircle(color, f);
    }

    @NotNull
    public final Image getTriangle() {
        return ImageGetter.getImage$default(this, "OtherIcons/Triangle", null, 2, null);
    }

    @NotNull
    public final Actor getRedCross(float size, float alpha) {
        Color color;
        Image redCross = ImageGetter.getImage$default(this, "OtherIcons/Close", null, 2, null);
        redCross.setSize(size, size);
        Color color2 = color = Color.RED.cpy();
        Image image = redCross;
        boolean bl = false;
        $this$getRedCross_u24lambda_u2414.a = alpha;
        image.setColor(color);
        return redCross;
    }

    @NotNull
    public final NonTransformGroup getCrossedImage(@NotNull Actor image, float iconSize) {
        NonTransformGroup nonTransformGroup;
        Intrinsics.checkNotNullParameter(image, "image");
        NonTransformGroup $this$getCrossedImage_u24lambda_u2415 = nonTransformGroup = new NonTransformGroup();
        boolean bl = false;
        $this$getCrossedImage_u24lambda_u2415.setSize(iconSize, iconSize);
        Scene2dExtensionsKt.center(image, $this$getCrossedImage_u24lambda_u2415);
        $this$getCrossedImage_u24lambda_u2415.addActor(image);
        Actor cross = INSTANCE.getRedCross(iconSize * 0.7f, 0.7f);
        Scene2dExtensionsKt.center(cross, $this$getCrossedImage_u24lambda_u2415);
        $this$getCrossedImage_u24lambda_u2415.addActor(cross);
        return nonTransformGroup;
    }

    @NotNull
    public final Image getArrowImage(int align) {
        Image image = ImageGetter.getImage$default(this, "OtherIcons/ArrowRight", null, 2, null);
        image.setOrigin(1);
        if (align == 8) {
            image.setRotation(180.0f);
        }
        if (align == 4) {
            image.setRotation(-90.0f);
        }
        if (align == 2) {
            image.setRotation(90.0f);
        }
        return image;
    }

    public static /* synthetic */ Image getArrowImage$default(ImageGetter imageGetter, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 16;
        }
        return imageGetter.getArrowImage(n);
    }

    @NotNull
    public final ProgressBar getProgressBarVertical(float width, float height, float percentComplete, @NotNull Color progressColor, @NotNull Color backgroundColor, float progressPadding) {
        Intrinsics.checkNotNullParameter(progressColor, "progressColor");
        Intrinsics.checkNotNullParameter(backgroundColor, "backgroundColor");
        return new ProgressBar(width, height, true).setBackground(backgroundColor).setProgress(progressColor, percentComplete, progressPadding);
    }

    public static /* synthetic */ ProgressBar getProgressBarVertical$default(ImageGetter imageGetter, float f, float f2, float f3, Color color, Color color2, float f4, int n, Object object) {
        if ((n & 0x20) != 0) {
            f4 = 0.0f;
        }
        return imageGetter.getProgressBarVertical(f, f2, f3, color, color2, f4);
    }

    @NotNull
    public final Table getHealthBar(float currentHealth, float maxHealth, float healthBarSize, float height) {
        float healthPercent = currentHealth / maxHealth;
        Table healthBar = new Table();
        Image healthPartOfBar = this.getWhiteDot();
        healthPartOfBar.setColor(healthPercent > 0.6666667f ? Color.GREEN : (healthPercent > 0.33333334f ? Color.ORANGE : Color.RED));
        healthBar.add((Actor)healthPartOfBar).size(healthBarSize * healthPercent, height);
        Image emptyPartOfBar = this.getDot(CHARCOAL);
        healthBar.add((Actor)emptyPartOfBar).size(healthBarSize * (1.0f - healthPercent), height);
        healthBar.pad(1.0f);
        healthBar.pack();
        healthBar.setBackground(SkinStrings.getUiBackground$default(BaseScreen.Companion.getSkinStrings(), "General/HealthBar", null, CHARCOAL, 2, null));
        return healthBar;
    }

    public static /* synthetic */ Table getHealthBar$default(ImageGetter imageGetter, float f, float f2, float f3, float f4, int n, Object object) {
        if ((n & 8) != 0) {
            f4 = 5.0f;
        }
        return imageGetter.getHealthBar(f, f2, f3, f4);
    }

    @NotNull
    public final Image getLine(float startX, float startY, float endX, float endY, float width) {
        Image line = this.getWhiteDot();
        double deltaX = startX - endX;
        double deltaY = startY - endY;
        line.setWidth((float)Math.sqrt(deltaX * deltaX + deltaY * deltaY));
        line.setHeight(width);
        line.setOrigin(1);
        double radiansToDegrees = 57.29577951308232;
        line.setRotation((float)(Math.atan2(deltaY, deltaX) * radiansToDegrees));
        line.setX((startX + endX) / (float)2 - line.getWidth() / (float)2);
        line.setY((startY + endY) / (float)2 - line.getHeight() / (float)2);
        return line;
    }

    @NotNull
    public final Image getSpecialistIcon(@NotNull Color color) {
        Intrinsics.checkNotNullParameter(color, "color");
        Image specialist = ImageGetter.getImage$default(this, "StatIcons/Specialist", null, 2, null);
        specialist.setColor(color);
        return specialist;
    }

    @NotNull
    public final Set<String> getAllImageNames() {
        Set<String> set = textureRegionDrawables.keySet();
        Intrinsics.checkNotNullExpressionValue(set, "<get-keys>(...)");
        return set;
    }

    @NotNull
    public final Sequence<String> getAvailableSkins() {
        Set<String> set = ninePatchDrawables.keySet();
        Intrinsics.checkNotNullExpressionValue(set, "<get-keys>(...)");
        return SequencesKt.distinct(SequencesKt.map(CollectionsKt.asSequence((Iterable)set), ImageGetter::getAvailableSkins$lambda$16));
    }

    @NotNull
    public final Sequence<String> getAvailableTilesets() {
        Set<String> set = textureRegionDrawables.keySet();
        Intrinsics.checkNotNullExpressionValue(set, "<get-keys>(...)");
        return SequencesKt.distinct(SequencesKt.map(SequencesKt.filter(CollectionsKt.asSequence((Iterable)set), ImageGetter::getAvailableTilesets$lambda$17), ImageGetter::getAvailableTilesets$lambda$18));
    }

    @NotNull
    public final Sequence<String> getAvailableUnitsets() {
        Set<String> set = textureRegionDrawables.keySet();
        Intrinsics.checkNotNullExpressionValue(set, "<get-keys>(...)");
        return SequencesKt.distinct(SequencesKt.map(SequencesKt.filter(CollectionsKt.asSequence((Iterable)set), ImageGetter::getAvailableUnitsets$lambda$19), ImageGetter::getAvailableUnitsets$lambda$20));
    }

    private static final FileHandle findExternalImage$lambda$3(String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return UncivGame.Companion.getCurrent().getFiles().getLocalFile("mods/" + it + "/ExtraImages");
    }

    private static final FileHandle findExternalImage$lambda$5$lambda$4(FileHandle $folder, String $name, String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return $folder.child($name + it);
    }

    private static final Sequence findExternalImage$lambda$5(Sequence $extensions, String $name, FileHandle folder) {
        return SequencesKt.map($extensions, arg_0 -> ImageGetter.findExternalImage$lambda$5$lambda$4(folder, $name, arg_0));
    }

    private static final String getAvailableSkins$lambda$16(String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        String[] stringArray = new String[]{"/"};
        return (String)StringsKt.split$default((CharSequence)it, stringArray, false, 0, 6, null).get(1);
    }

    private static final boolean getAvailableTilesets$lambda$17(String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return StringsKt.startsWith$default(it, "TileSets", false, 2, null) && !StringsKt.contains$default((CharSequence)it, "/Units/", false, 2, null);
    }

    private static final String getAvailableTilesets$lambda$18(String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        String[] stringArray = new String[]{"/"};
        return (String)StringsKt.split$default((CharSequence)it, stringArray, false, 0, 6, null).get(1);
    }

    private static final boolean getAvailableUnitsets$lambda$19(String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return StringsKt.startsWith$default(it, "TileSets", false, 2, null) && StringsKt.contains$default((CharSequence)it, "/Units/", false, 2, null);
    }

    private static final String getAvailableUnitsets$lambda$20(String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        String[] stringArray = new String[]{"/"};
        return (String)StringsKt.split$default((CharSequence)it, stringArray, false, 0, 6, null).get(1);
    }

    static {
        atlases = new HashMap();
        ruleset = new Ruleset();
        textureRegionDrawables = new HashMap();
        ninePatchDrawables = new HashMap();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001a\u0010%\u001a\u00020&2\b\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010)\u001a\u00020\u0003H\u0016J \u0010\u0017\u001a\u00020\u00002\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\b\b\u0002\u0010.\u001a\u00020/J\u000e\u0010\u001d\u001a\u00020\u00002\u0006\u0010*\u001a\u00020+J \u00100\u001a\u00020\u00002\u0006\u0010*\u001a\u00020+2\u0006\u00101\u001a\u00020\u00032\b\b\u0002\u00102\u001a\u00020\u0003J \u00103\u001a\u00020\u00002\u0006\u0010*\u001a\u00020+2\u0006\u00101\u001a\u00020\u00032\b\b\u0002\u00102\u001a\u00020\u0003R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\r\"\u0004\b\u0012\u0010\u000fR\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001c\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001c\u0010\u001f\u001a\u0004\u0018\u00010\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u001c\"\u0004\b!\u0010\u001eR\u001c\u0010\"\u001a\u0004\u0018\u00010\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u001c\"\u0004\b$\u0010\u001e\u00a8\u00064"}, d2={"Lcom/unciv/ui/images/ImageGetter$ProgressBar;", "Lcom/unciv/ui/components/NonTransformGroup;", "width", "", "height", "vertical", "", "<init>", "(FFZ)V", "getVertical", "()Z", "primaryPercentage", "getPrimaryPercentage", "()F", "setPrimaryPercentage", "(F)V", "secondaryPercentage", "getSecondaryPercentage", "setSecondaryPercentage", "label", "Lcom/badlogic/gdx/scenes/scene2d/ui/Label;", "getLabel", "()Lcom/badlogic/gdx/scenes/scene2d/ui/Label;", "setLabel", "(Lcom/badlogic/gdx/scenes/scene2d/ui/Label;)V", "background", "Lcom/badlogic/gdx/scenes/scene2d/ui/Image;", "getBackground", "()Lcom/badlogic/gdx/scenes/scene2d/ui/Image;", "setBackground", "(Lcom/badlogic/gdx/scenes/scene2d/ui/Image;)V", "secondaryProgress", "getSecondaryProgress", "setSecondaryProgress", "primaryProgress", "getPrimaryProgress", "setPrimaryProgress", "draw", "", "batch", "Lcom/badlogic/gdx/graphics/g2d/Batch;", "parentAlpha", "color", "Lcom/badlogic/gdx/graphics/Color;", "text", "", "fontSize", "", "setSemiProgress", "percentage", "padding", "setProgress", "core"})
    public static final class ProgressBar
    extends NonTransformGroup {
        private final boolean vertical;
        private float primaryPercentage;
        private float secondaryPercentage;
        @Nullable
        private Label label;
        @Nullable
        private Image background;
        @Nullable
        private Image secondaryProgress;
        @Nullable
        private Image primaryProgress;

        public ProgressBar(float width, float height, boolean vertical) {
            this.vertical = vertical;
            this.setSize(width, height);
        }

        public /* synthetic */ ProgressBar(float f, float f2, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                bl = true;
            }
            this(f, f2, bl);
        }

        public final boolean getVertical() {
            return this.vertical;
        }

        public final float getPrimaryPercentage() {
            return this.primaryPercentage;
        }

        public final void setPrimaryPercentage(float f) {
            this.primaryPercentage = f;
        }

        public final float getSecondaryPercentage() {
            return this.secondaryPercentage;
        }

        public final void setSecondaryPercentage(float f) {
            this.secondaryPercentage = f;
        }

        @Nullable
        public final Label getLabel() {
            return this.label;
        }

        public final void setLabel(@Nullable Label label) {
            this.label = label;
        }

        @Nullable
        public final Image getBackground() {
            return this.background;
        }

        public final void setBackground(@Nullable Image image) {
            this.background = image;
        }

        @Nullable
        public final Image getSecondaryProgress() {
            return this.secondaryProgress;
        }

        public final void setSecondaryProgress(@Nullable Image image) {
            this.secondaryProgress = image;
        }

        @Nullable
        public final Image getPrimaryProgress() {
            return this.primaryProgress;
        }

        public final void setPrimaryProgress(@Nullable Image image) {
            this.primaryProgress = image;
        }

        @Override
        public void draw(@Nullable Batch batch, float parentAlpha) {
            super.draw(batch, parentAlpha);
        }

        @NotNull
        public final ProgressBar setLabel(@NotNull Color color, @NotNull String text, int fontSize) {
            Intrinsics.checkNotNullParameter(color, "color");
            Intrinsics.checkNotNullParameter(text, "text");
            Label label = this.label = Scene2dExtensionsKt.toLabel(text);
            if (label != null) {
                label.setAlignment(1);
            }
            Label label2 = this.label;
            if (label2 != null) {
                Scene2dExtensionsKt.setFontColor(label2, color);
            }
            Label label3 = this.label;
            if (label3 != null) {
                Scene2dExtensionsKt.setFontSize(label3, fontSize);
            }
            Label label4 = this.label;
            if (label4 != null) {
                label4.toFront();
            }
            Label label5 = this.label;
            if (label5 != null) {
                Scene2dExtensionsKt.center((Actor)label5, this);
            }
            if (this.label != null) {
                this.addActor(this.label);
            }
            return this;
        }

        public static /* synthetic */ ProgressBar setLabel$default(ProgressBar progressBar, Color color, String string, int n, int n2, Object object) {
            if ((n2 & 4) != 0) {
                n = 18;
            }
            return progressBar.setLabel(color, string, n);
        }

        @NotNull
        public final ProgressBar setBackground(@NotNull Color color) {
            Intrinsics.checkNotNullParameter(color, "color");
            Image image = this.background = INSTANCE.getWhiteDot();
            if (image != null) {
                image.setColor(color.cpy());
            }
            Image image2 = this.background;
            if (image2 != null) {
                image2.setSize(this.getWidth(), this.getHeight());
            }
            Image image3 = this.background;
            if (image3 != null) {
                image3.toBack();
            }
            Image image4 = this.background;
            if (image4 != null) {
                Scene2dExtensionsKt.center((Actor)image4, this);
            }
            if (this.background != null) {
                this.addActor(this.background);
            }
            return this;
        }

        @NotNull
        public final ProgressBar setSemiProgress(@NotNull Color color, float percentage, float padding) {
            block10: {
                Intrinsics.checkNotNullParameter(color, "color");
                this.secondaryPercentage = percentage;
                Image image = this.secondaryProgress = INSTANCE.getWhiteDot();
                if (image != null) {
                    image.setColor(color.cpy());
                }
                if (this.vertical) {
                    Image image2 = this.secondaryProgress;
                    if (image2 != null) {
                        image2.setSize(this.getWidth() - padding * (float)2, this.getHeight() * Math.max(Math.min(percentage, 1.0f), 0.0f));
                    }
                } else {
                    Image image3 = this.secondaryProgress;
                    if (image3 != null) {
                        image3.setSize(this.getWidth() * Math.max(Math.min(percentage, 1.0f), 0.0f), this.getHeight() - padding * (float)2);
                    }
                }
                if (this.secondaryProgress != null) {
                    this.addActor(this.secondaryProgress);
                    if (this.vertical) {
                        Image image4 = this.secondaryProgress;
                        if (image4 != null) {
                            Scene2dExtensionsKt.centerX((Actor)image4, this);
                        }
                    } else {
                        Image image5 = this.secondaryProgress;
                        if (image5 != null) {
                            Scene2dExtensionsKt.centerY((Actor)image5, this);
                        }
                    }
                }
                Image image6 = this.primaryProgress;
                if (image6 == null) break block10;
                image6.toFront();
            }
            return this;
        }

        public static /* synthetic */ ProgressBar setSemiProgress$default(ProgressBar progressBar, Color color, float f, float f2, int n, Object object) {
            if ((n & 4) != 0) {
                f2 = 0.0f;
            }
            return progressBar.setSemiProgress(color, f, f2);
        }

        @NotNull
        public final ProgressBar setProgress(@NotNull Color color, float percentage, float padding) {
            block5: {
                block6: {
                    Intrinsics.checkNotNullParameter(color, "color");
                    this.primaryPercentage = percentage;
                    Image image = this.primaryProgress = INSTANCE.getWhiteDot();
                    if (image != null) {
                        image.setColor(color.cpy());
                    }
                    if (this.vertical) {
                        Image image2 = this.primaryProgress;
                        if (image2 != null) {
                            image2.setSize(this.getWidth() - padding * (float)2, this.getHeight() * Math.max(Math.min(percentage, 1.0f), 0.0f));
                        }
                    } else {
                        Image image3 = this.primaryProgress;
                        if (image3 != null) {
                            image3.setSize(this.getWidth() * Math.max(Math.min(percentage, 1.0f), 0.0f), this.getHeight() - padding * (float)2);
                        }
                    }
                    if (this.primaryProgress == null) break block5;
                    this.addActor(this.primaryProgress);
                    if (!this.vertical) break block6;
                    Image image4 = this.primaryProgress;
                    if (image4 == null) break block5;
                    Scene2dExtensionsKt.centerX((Actor)image4, this);
                    break block5;
                }
                Image image = this.primaryProgress;
                if (image == null) break block5;
                Scene2dExtensionsKt.centerY((Actor)image, this);
            }
            return this;
        }

        public static /* synthetic */ ProgressBar setProgress$default(ProgressBar progressBar, Color color, float f, float f2, int n, Object object) {
            if ((n & 4) != 0) {
                f2 = 0.0f;
            }
            return progressBar.setProgress(color, f, f2);
        }
    }
}

