/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.components.tilegroups.layers;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.map.HexMath;
import com.unciv.logic.map.TileMap;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.nation.Nation;
import com.unciv.models.ruleset.unique.LocalUniqueCache;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.components.MapArrowType;
import com.unciv.ui.components.extensions.FormattingExtensionsKt;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.tilegroups.TileGroup;
import com.unciv.ui.components.tilegroups.WorldTileGroup;
import com.unciv.ui.components.tilegroups.layers.MapArrow;
import com.unciv.ui.components.tilegroups.layers.TileLayer;
import com.unciv.ui.images.ImageGetter;
import com.unciv.utils.DebugUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005H\u0016J\"\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u001a\u0010\u0013\u001a\u00020\u000b2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0005H\u0016J\b\u0010#\u001a\u00020\u000bH\u0002J\b\u0010$\u001a\u00020\u000bH\u0002J\u0010\u0010%\u001a\u00020\u000b2\u0006\u0010&\u001a\u00020\u0012H\u0002J\u0006\u0010'\u001a\u00020\u000bJ\u000e\u0010(\u001a\u00020\u000b2\u0006\u0010)\u001a\u00020\u000eJ\u000e\u0010*\u001a\u00020\u000b2\u0006\u0010+\u001a\u00020,J\u0006\u0010-\u001a\u00020\u000bJ\u000e\u0010.\u001a\u00020\u000b2\u0006\u0010+\u001a\u00020,J\u0016\u0010.\u001a\u00020\u000b2\u0006\u0010+\u001a\u00020,2\u0006\u0010/\u001a\u00020\u0005J\u0010\u00100\u001a\u00020\u000b2\u0006\u0010+\u001a\u00020,H\u0002J\u0006\u00101\u001a\u00020\u000bJ\u0016\u00102\u001a\u00020\u000b2\u0006\u00103\u001a\u00020\u001d2\u0006\u00104\u001a\u000205J\u0006\u00106\u001a\u00020\u000bJ\u000e\u00107\u001a\u00020\u000b2\u0006\u00108\u001a\u00020\u0012J\u001a\u00109\u001a\u00020\u000b2\b\u0010:\u001a\u0004\u0018\u00010;2\u0006\u0010<\u001a\u00020=H\u0014J\b\u0010>\u001a\u00020\u000bH\u0014J\u0006\u0010?\u001a\u00020\u000bR\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0017\u001a\u0012\u0012\u0004\u0012\u00020\u00190\u0018j\b\u0012\u0004\u0012\u00020\u0019`\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000RJ\u0010\u001b\u001a>\u0012\u0004\u0012\u00020\u001d\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u000e0\u0018j\b\u0012\u0004\u0012\u00020\u000e`\u001a0\u001cj\u001e\u0012\u0004\u0012\u00020\u001d\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u000e0\u0018j\b\u0012\u0004\u0012\u00020\u000e`\u001a`\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001f\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010 \u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00020\u000e0\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lcom/unciv/ui/components/tilegroups/layers/TileLayerMisc;", "Lcom/unciv/ui/components/tilegroups/layers/TileLayer;", "tileGroup", "Lcom/unciv/ui/components/tilegroups/TileGroup;", "size", "", "<init>", "(Lcom/unciv/ui/components/tilegroups/TileGroup;F)V", "terrainOverlay", "Lcom/badlogic/gdx/scenes/scene2d/ui/Image;", "act", "", "delta", "hit", "Lcom/badlogic/gdx/scenes/scene2d/Actor;", "x", "y", "touchable", "", "draw", "batch", "Lcom/badlogic/gdx/graphics/g2d/Batch;", "parentAlpha", "arrowsToDraw", "Ljava/util/ArrayList;", "Lcom/unciv/ui/components/tilegroups/layers/MapArrow;", "Lkotlin/collections/ArrayList;", "arrows", "Ljava/util/HashMap;", "Lcom/unciv/logic/map/tile/Tile;", "Lkotlin/collections/HashMap;", "hexOutlineIcon", "workedIcon", "startingLocationIcons", "", "clearArrows", "updateArrows", "updateStartingLocationIcon", "show", "removeWorkedIcon", "addWorkedIcon", "icon", "addHexOutline", "color", "Lcom/badlogic/gdx/graphics/Color;", "removeHexOutline", "overlayTerrain", "alpha", "overlayTerrainInner", "hideTerrainOverlay", "addArrow", "targetTile", "type", "Lcom/unciv/ui/components/MapArrowType;", "resetArrows", "dimPopulation", "dim", "doUpdate", "viewingCiv", "Lcom/unciv/logic/civilization/Civilization;", "localUniqueCache", "Lcom/unciv/models/ruleset/unique/LocalUniqueCache;", "determineVisibility", "reset", "core"})
@SourceDebugExtension(value={"SMAP\nTileLayerMisc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TileLayerMisc.kt\ncom/unciv/ui/components/tilegroups/layers/TileLayerMisc\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,452:1\n1869#2,2:453\n1#3:455\n*S KotlinDebug\n*F\n+ 1 TileLayerMisc.kt\ncom/unciv/ui/components/tilegroups/layers/TileLayerMisc\n*L\n297#1:453,2\n*E\n"})
public final class TileLayerMisc
extends TileLayer {
    @Nullable
    private Image terrainOverlay;
    @NotNull
    private final ArrayList<MapArrow> arrowsToDraw;
    @NotNull
    private final HashMap<Tile, ArrayList<Actor>> arrows;
    @Nullable
    private Actor hexOutlineIcon;
    @Nullable
    private Actor workedIcon;
    @NotNull
    private final List<Actor> startingLocationIcons;

    public TileLayerMisc(@NotNull TileGroup tileGroup, float size) {
        Intrinsics.checkNotNullParameter(tileGroup, "tileGroup");
        super(tileGroup, size);
        this.terrainOverlay = TileLayer.setHexagonSize$default(this, ImageGetter.getImage$default(ImageGetter.INSTANCE, this.getStrings().getHexagon(), null, 2, null), null, 1, null);
        this.arrowsToDraw = new ArrayList();
        this.arrows = new HashMap();
        this.startingLocationIcons = new ArrayList();
    }

    @Override
    public void act(float delta) {
    }

    @Override
    @Nullable
    public Actor hit(float x, float y, boolean touchable) {
        Actor actor;
        if (this.workedIcon == null) {
            actor = null;
        } else {
            Vector2 coords = new Vector2(x, y);
            Actor actor2 = this.workedIcon;
            Intrinsics.checkNotNull(actor2);
            actor2.parentToLocalCoordinates(coords);
            Actor actor3 = this.workedIcon;
            Intrinsics.checkNotNull(actor3);
            actor = actor3.hit(coords.x, coords.y, touchable);
        }
        return actor;
    }

    @Override
    public void draw(@Nullable Batch batch, float parentAlpha) {
        super.draw(batch, parentAlpha);
    }

    private final void clearArrows() {
        Iterator<ArrayList<Actor>> iterator2 = this.arrows.values().iterator();
        while (iterator2.hasNext()) {
            Iterator<Actor> iterator3;
            ArrayList<Actor> actorList;
            Intrinsics.checkNotNullExpressionValue(iterator2.next(), "next(...)");
            Intrinsics.checkNotNullExpressionValue(actorList.iterator(), "iterator(...)");
            while (iterator3.hasNext()) {
                Actor actor = iterator3.next();
                actor.remove();
            }
        }
        this.arrows.clear();
    }

    private final void updateArrows() {
        this.clearArrows();
        float tileScale = 40.0f;
        Iterator<MapArrow> iterator2 = this.arrowsToDraw.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator<MapArrow> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            MapArrow arrowToAdd;
            Intrinsics.checkNotNullExpressionValue(iterator3.next(), "next(...)");
            Tile targetTile = arrowToAdd.getTargetTile();
            Vector2 targetPos = new Vector2(targetTile.getPosition());
            if (this.getTile().getTileMap().getMapParameters().getWorldWrap()) {
                targetPos = HexMath.INSTANCE.getUnwrappedNearestTo(targetPos, this.getTile().getPosition(), this.getTile().getTileMap().getMaxLongitude());
            }
            Vector2 targetRelative = HexMath.INSTANCE.hex2WorldCoords(targetPos).sub(HexMath.INSTANCE.hex2WorldCoords(this.getTile().getPosition()));
            float targetDistance = (float)Math.sqrt((float)Math.pow(targetRelative.x, 2) + (float)Math.pow(targetRelative.y, 2));
            float targetAngle = (float)Math.atan2(targetRelative.y, targetRelative.x);
            if (!((Map)this.arrows).containsKey(targetTile)) {
                ((Map)this.arrows).put(targetTile, new ArrayList());
            }
            Image arrowImage = arrowToAdd.getImage();
            arrowImage.moveBy(25.0f, -5.0f);
            arrowImage.setSize(tileScale * targetDistance, 60.0f);
            arrowImage.setOrigin(0.0f, 30.0f);
            arrowImage.setRotation(targetAngle / (float)Math.PI * (float)180);
            ArrayList<Actor> arrayList = this.arrows.get(targetTile);
            Intrinsics.checkNotNull(arrayList);
            arrayList.add(arrowImage);
            this.addActor(arrowImage);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void updateStartingLocationIcon(boolean show) {
        Object newNationIcon;
        Object nation;
        TileMap tilemap;
        Function1[] $this$updateStartingLocationIcon_u24lambda_u243;
        Unit unit;
        List<Actor> list2;
        String string;
        Iterable $this$forEach$iv = this.startingLocationIcons;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            Actor it = (Actor)element$iv;
            boolean bl = false;
            it.remove();
        }
        this.startingLocationIcons.clear();
        if (!show || this.getTileGroup().isForMapEditorIcon()) {
            return;
        }
        if (DebugUtils.INSTANCE.getSHOW_TILE_COORDS()) {
            Label $this$updateStartingLocationIcon_u24lambda_u242;
            Object element$iv;
            String label = FormattingExtensionsKt.toPrettyString(this.getTile().getPosition());
            Object object = ImageGetter.INSTANCE.getCHARCOAL().cpy();
            element$iv = object;
            string = label;
            list2 = this.startingLocationIcons;
            boolean bl = false;
            $this$updateStartingLocationIcon_u24lambda_u241.a = 0.7f;
            unit = Unit.INSTANCE;
            Object object2 = object;
            Intrinsics.checkNotNullExpressionValue(object2, "apply(...)");
            Label $i$f$forEach2 = Scene2dExtensionsKt.toLabel$default(string, (Color)object2, 14, 0, false, 12, null);
            object = $i$f$forEach2;
            boolean bl2 = false;
            this.getTileGroup().getLayerMisc().addActor($this$updateStartingLocationIcon_u24lambda_u242);
            $this$updateStartingLocationIcon_u24lambda_u242.setOrigin(1);
            Scene2dExtensionsKt.center((Actor)$this$updateStartingLocationIcon_u24lambda_u242, this.getTileGroup());
            $this$updateStartingLocationIcon_u24lambda_u242.moveBy(15.4f, -0.6f);
            list2.add($i$f$forEach2);
            Color color = Color.FIREBRICK;
            Intrinsics.checkNotNullExpressionValue(color, "FIREBRICK");
            $this$updateStartingLocationIcon_u24lambda_u242 = $i$f$forEach2 = Scene2dExtensionsKt.toLabel$default(label, color, 14, 0, false, 12, null);
            list2 = this.startingLocationIcons;
            boolean bl3 = false;
            this.getTileGroup().getLayerMisc().addActor((Actor)$this$updateStartingLocationIcon_u24lambda_u243);
            $this$updateStartingLocationIcon_u24lambda_u243.setOrigin(1);
            Scene2dExtensionsKt.center((Actor)$this$updateStartingLocationIcon_u24lambda_u243, this.getTileGroup());
            $this$updateStartingLocationIcon_u24lambda_u243.moveBy(15.0f, 0.0f);
            list2.add($i$f$forEach2);
        }
        if ((tilemap = this.getTile().getTileMap()).getStartingLocationsByNation().isEmpty()) {
            return;
        }
        $this$updateStartingLocationIcon_u24lambda_u243 = new Function1[]{TileLayerMisc::updateStartingLocationIcon$lambda$7, TileLayerMisc::updateStartingLocationIcon$lambda$8};
        List<Pair> nations = SequencesKt.toList(SequencesKt.sortedWith(SequencesKt.map(SequencesKt.filter(SequencesKt.filter(MapsKt.asSequence((Map)tilemap.getStartingLocationsByNation()), arg_0 -> TileLayerMisc.updateStartingLocationIcon$lambda$4(this, arg_0)), arg_0 -> TileLayerMisc.updateStartingLocationIcon$lambda$5(tilemap, arg_0)), arg_0 -> TileLayerMisc.updateStartingLocationIcon$lambda$6(tilemap, arg_0)), ComparisonsKt.compareBy($this$updateStartingLocationIcon_u24lambda_u243)));
        if (nations.isEmpty()) {
            return;
        }
        int displayCount = Math.min(nations.size(), 3);
        float offsetX = 0.0f;
        offsetX = (float)(displayCount - 1) * 4.0f;
        float offsetY = 0.0f;
        offsetY = (float)(displayCount - 1) * 2.0f;
        Object object = CollectionsKt.asReversed(CollectionsKt.take((Iterable)nations, 3)).iterator();
        while (object.hasNext()) {
            Color color;
            nation = (Pair)object.next();
            newNationIcon = ImageGetter.INSTANCE.getNationPortrait((Nation)((Pair)nation).getSecond(), 20.0f);
            this.getTileGroup().getLayerMisc().addActor((Actor)newNationIcon);
            Object $this$updateStartingLocationIcon_u24lambda_u2410 = newNationIcon;
            boolean bl = false;
            ((Actor)$this$updateStartingLocationIcon_u24lambda_u2410).setSize(20.0f, 20.0f);
            Scene2dExtensionsKt.center((Actor)$this$updateStartingLocationIcon_u24lambda_u2410, this.getTileGroup());
            ((Actor)$this$updateStartingLocationIcon_u24lambda_u2410).moveBy(offsetX, offsetY);
            Color color2 = color = Color.WHITE.cpy();
            Object object3 = $this$updateStartingLocationIcon_u24lambda_u2410;
            boolean bl4 = false;
            $this$updateStartingLocationIcon_u24lambda_u2410_u24lambda_u249.a = 0.6f;
            ((Actor)object3).setColor(color);
            this.startingLocationIcons.add((Actor)newNationIcon);
            offsetX -= 8.0f;
            offsetY -= 4.0f;
        }
        if (nations.size() > 3) {
            void $this$updateStartingLocationIcon_u24lambda_u2413;
            Object $this$updateStartingLocationIcon_u24lambda_u2412;
            newNationIcon = nation = ImageGetter.INSTANCE.getCHARCOAL().cpy();
            string = TranslationsKt.tr(nations.size());
            list2 = this.startingLocationIcons;
            boolean bl = false;
            $this$updateStartingLocationIcon_u24lambda_u2411.a = 0.7f;
            unit = Unit.INSTANCE;
            Object object4 = nation;
            Intrinsics.checkNotNullExpressionValue(object4, "apply(...)");
            nation = object = Scene2dExtensionsKt.toLabel$default(string, (Color)object4, 14, 0, false, 12, null);
            boolean bl5 = false;
            this.getTileGroup().getLayerMisc().addActor((Actor)$this$updateStartingLocationIcon_u24lambda_u2412);
            ((Actor)$this$updateStartingLocationIcon_u24lambda_u2412).setOrigin(1);
            Scene2dExtensionsKt.center((Actor)$this$updateStartingLocationIcon_u24lambda_u2412, this.getTileGroup());
            ((Actor)$this$updateStartingLocationIcon_u24lambda_u2412).moveBy(14.4f, -9.0f);
            list2.add((Actor)object);
            String string2 = TranslationsKt.tr(nations.size());
            Color color = Color.FIREBRICK;
            Intrinsics.checkNotNullExpressionValue(color, "FIREBRICK");
            $this$updateStartingLocationIcon_u24lambda_u2412 = object = Scene2dExtensionsKt.toLabel$default(string2, color, 14, 0, false, 12, null);
            list2 = this.startingLocationIcons;
            boolean bl6 = false;
            this.getTileGroup().getLayerMisc().addActor((Actor)$this$updateStartingLocationIcon_u24lambda_u2413);
            $this$updateStartingLocationIcon_u24lambda_u2413.setOrigin(1);
            Scene2dExtensionsKt.center((Actor)$this$updateStartingLocationIcon_u24lambda_u2413, this.getTileGroup());
            $this$updateStartingLocationIcon_u24lambda_u2413.moveBy(14.0f, -8.4f);
            list2.add((Actor)object);
        }
    }

    public final void removeWorkedIcon() {
        Actor actor = this.workedIcon;
        if (actor != null) {
            actor.remove();
        }
        this.workedIcon = null;
        this.determineVisibility();
    }

    public final void addWorkedIcon(@NotNull Actor icon) {
        Intrinsics.checkNotNullParameter(icon, "icon");
        this.workedIcon = icon;
        this.addActor(this.workedIcon);
        this.determineVisibility();
    }

    public final void addHexOutline(@NotNull Color color) {
        Intrinsics.checkNotNullParameter(color, "color");
        Actor actor = this.hexOutlineIcon;
        if (actor != null) {
            actor.remove();
        }
        Actor actor2 = this.hexOutlineIcon = (Actor)this.setHexagonSize(ImageGetter.getImage$default(ImageGetter.INSTANCE, "OtherIcons/HexagonOutline", null, 2, null), Float.valueOf(1.0f));
        Intrinsics.checkNotNull(actor2);
        actor2.setColor(color);
        this.addActor(this.hexOutlineIcon);
        Actor actor3 = this.hexOutlineIcon;
        Intrinsics.checkNotNull(actor3);
        actor3.toBack();
        this.determineVisibility();
    }

    public final void removeHexOutline() {
        Actor actor = this.hexOutlineIcon;
        if (actor != null) {
            actor.remove();
        }
        this.hexOutlineIcon = null;
        this.determineVisibility();
    }

    public final void overlayTerrain(@NotNull Color color) {
        Color color2;
        Intrinsics.checkNotNullParameter(color, "color");
        Color color3 = color2 = Scene2dExtensionsKt.brighten(color, 0.3f);
        TileLayerMisc tileLayerMisc = this;
        boolean bl = false;
        $this$overlayTerrain_u24lambda_u2414.a = 0.4f;
        tileLayerMisc.overlayTerrainInner(color2);
    }

    public final void overlayTerrain(@NotNull Color color, float alpha) {
        Color color2;
        Intrinsics.checkNotNullParameter(color, "color");
        Color color3 = color2 = color.cpy();
        TileLayerMisc tileLayerMisc = this;
        boolean bl = false;
        $this$overlayTerrain_u24lambda_u2415.a = alpha;
        Color color4 = color2;
        Intrinsics.checkNotNullExpressionValue(color4, "apply(...)");
        tileLayerMisc.overlayTerrainInner(color4);
    }

    private final void overlayTerrainInner(Color color) {
        if (this.terrainOverlay == null) {
            this.terrainOverlay = TileLayer.setHexagonSize$default(this, ImageGetter.getImage$default(ImageGetter.INSTANCE, this.getStrings().getHexagon(), null, 2, null), null, 1, null);
            this.addActor(this.terrainOverlay);
        }
        Image image = this.terrainOverlay;
        if (image != null) {
            image.setColor(color);
        }
        this.determineVisibility();
    }

    public final void hideTerrainOverlay() {
        Image image = this.terrainOverlay;
        if (image != null) {
            image.remove();
        }
        this.terrainOverlay = null;
        this.determineVisibility();
    }

    public final void addArrow(@NotNull Tile targetTile, @NotNull MapArrowType type) {
        Intrinsics.checkNotNullParameter(targetTile, "targetTile");
        Intrinsics.checkNotNullParameter(type, "type");
        if (!Intrinsics.areEqual(targetTile.getPosition(), this.getTile().getPosition())) {
            this.arrowsToDraw.add(new MapArrow(targetTile, type, this.getStrings()));
        }
    }

    public final void resetArrows() {
        this.arrowsToDraw.clear();
    }

    public final void dimPopulation(boolean dim) {
        block0: {
            Object object = this.workedIcon;
            if (object == null || (object = ((Actor)object).getColor()) == null) break block0;
            ((Color)object).a = dim ? 0.4f : 1.0f;
        }
    }

    @Override
    protected void doUpdate(@Nullable Civilization viewingCiv, @NotNull LocalUniqueCache localUniqueCache) {
        Intrinsics.checkNotNullParameter(localUniqueCache, "localUniqueCache");
        if (!(this.getTileGroup() instanceof WorldTileGroup) || DebugUtils.INSTANCE.getSHOW_TILE_COORDS()) {
            this.updateStartingLocationIcon(true);
        }
        this.updateArrows();
    }

    @Override
    protected void determineVisibility() {
        this.setVisible(this.workedIcon != null || this.hexOutlineIcon != null || !((Map)this.arrows).isEmpty() || !((Collection)this.startingLocationIcons).isEmpty() || this.terrainOverlay != null);
    }

    public final void reset() {
        this.updateStartingLocationIcon(false);
        this.clearArrows();
    }

    private static final boolean updateStartingLocationIcon$lambda$4(TileLayerMisc this$0, Map.Entry it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return ((HashSet)it.getValue()).contains(this$0.getTile());
    }

    private static final boolean updateStartingLocationIcon$lambda$5(TileMap $tilemap, Map.Entry it) {
        Intrinsics.checkNotNullParameter(it, "it");
        Ruleset ruleset = $tilemap.getRuleset();
        Intrinsics.checkNotNull(ruleset);
        return ((Map)ruleset.getNations()).containsKey(it.getKey());
    }

    private static final Pair updateStartingLocationIcon$lambda$6(TileMap $tilemap, Map.Entry it) {
        Intrinsics.checkNotNullParameter(it, "it");
        Object k = it.getKey();
        Ruleset ruleset = $tilemap.getRuleset();
        Intrinsics.checkNotNull(ruleset);
        Nation nation = ruleset.getNations().get(it.getKey());
        Intrinsics.checkNotNull(nation);
        return TuplesKt.to(k, nation);
    }

    private static final Comparable updateStartingLocationIcon$lambda$7(Pair it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return Boolean.valueOf(((Nation)it.getSecond()).isCityState());
    }

    private static final Comparable updateStartingLocationIcon$lambda$8(Pair it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return (Comparable)it.getFirst();
    }
}

