/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.multiplayer.storage;

import com.badlogic.gdx.utils.Base64Coder;
import com.unciv.logic.multiplayer.storage.AuthStatus;
import com.unciv.logic.multiplayer.storage.FileMetaData;
import com.unciv.logic.multiplayer.storage.FileStorage;
import com.unciv.logic.multiplayer.storage.MultiplayerAuthException;
import com.unciv.logic.multiplayer.storage.MultiplayerFileNotFoundException;
import com.unciv.logic.multiplayer.storage.SimpleHttp;
import com.unciv.utils.LogKt;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u0006H\u0016J\u0010\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0006H\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0018\u001a\u00020\u0006H\u0016J\u0010\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0006H\u0016J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00062\u0006\u0010!\u001a\u00020\u0006H\u0016J\u0018\u0010\"\u001a\u00020#2\u0006\u0010 \u001a\u00020\u00062\u0006\u0010!\u001a\u00020\u0006H\u0016J\u0010\u0010$\u001a\u00020\u001f2\u0006\u0010%\u001a\u00020\u0006H\u0016J\u0010\u0010&\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0006H\u0002R(\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006'"}, d2={"Lcom/unciv/logic/multiplayer/storage/UncivServerFileStorage;", "Lcom/unciv/logic/multiplayer/storage/FileStorage;", "<init>", "()V", "authHeader", "", "", "getAuthHeader", "()Ljava/util/Map;", "setAuthHeader", "(Ljava/util/Map;)V", "serverUrl", "getServerUrl", "()Ljava/lang/String;", "setServerUrl", "(Ljava/lang/String;)V", "timeout", "", "getTimeout", "()I", "setTimeout", "(I)V", "saveFileData", "", "fileName", "data", "loadFileData", "getFileMetaData", "Lcom/unciv/logic/multiplayer/storage/FileMetaData;", "deleteFile", "authenticate", "", "userId", "password", "checkAuthStatus", "Lcom/unciv/logic/multiplayer/storage/AuthStatus;", "setPassword", "newPassword", "fileUrl", "core"})
public final class UncivServerFileStorage
implements FileStorage {
    @NotNull
    public static final UncivServerFileStorage INSTANCE = new UncivServerFileStorage();
    @Nullable
    private static Map<String, String> authHeader;
    @NotNull
    private static String serverUrl;
    private static int timeout;

    private UncivServerFileStorage() {
    }

    @Nullable
    public final Map<String, String> getAuthHeader() {
        return authHeader;
    }

    public final void setAuthHeader(@Nullable Map<String, String> map2) {
        authHeader = map2;
    }

    @NotNull
    public final String getServerUrl() {
        return serverUrl;
    }

    public final void setServerUrl(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        serverUrl = string;
    }

    public final int getTimeout() {
        return timeout;
    }

    public final void setTimeout(int n) {
        timeout = n;
    }

    @Override
    public void saveFileData(@NotNull String fileName, @NotNull String data) {
        Intrinsics.checkNotNullParameter(fileName, "fileName");
        Intrinsics.checkNotNullParameter(data, "data");
        SimpleHttp.INSTANCE.sendRequest("PUT", this.fileUrl(fileName), data, timeout, authHeader, UncivServerFileStorage::saveFileData$lambda$0);
    }

    @Override
    @NotNull
    public String loadFileData(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter(fileName, "fileName");
        Ref.ObjectRef fileData = new Ref.ObjectRef();
        fileData.element = "";
        SimpleHttp.INSTANCE.sendGetRequest(this.fileUrl(fileName), timeout, authHeader, (arg_0, arg_1, arg_2) -> UncivServerFileStorage.loadFileData$lambda$1(fileData, arg_0, arg_1, arg_2));
        return (String)fileData.element;
    }

    @Override
    @NotNull
    public FileMetaData getFileMetaData(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter(fileName, "fileName");
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @Override
    public void deleteFile(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter(fileName, "fileName");
        SimpleHttp.INSTANCE.sendRequest("DELETE", this.fileUrl(fileName), "", timeout, authHeader, UncivServerFileStorage::deleteFile$lambda$2);
    }

    @Override
    public boolean authenticate(@NotNull String userId, @NotNull String password) {
        Intrinsics.checkNotNullParameter(userId, "userId");
        Intrinsics.checkNotNullParameter(password, "password");
        Ref.BooleanRef authenticated = new Ref.BooleanRef();
        String preEncodedAuthValue = userId + ':' + password;
        authHeader = MapsKt.mapOf(TuplesKt.to("Authorization", "Basic " + Base64Coder.encodeString(preEncodedAuthValue)));
        SimpleHttp.INSTANCE.sendGetRequest(serverUrl + "/auth", timeout, authHeader, (arg_0, arg_1, arg_2) -> UncivServerFileStorage.authenticate$lambda$3(authenticated, arg_0, arg_1, arg_2));
        return authenticated.element;
    }

    @Override
    @NotNull
    public AuthStatus checkAuthStatus(@NotNull String userId, @NotNull String password) {
        Intrinsics.checkNotNullParameter(userId, "userId");
        Intrinsics.checkNotNullParameter(password, "password");
        Ref.ObjectRef authStatus = new Ref.ObjectRef();
        authStatus.element = AuthStatus.UNKNOWN;
        String preEncodedAuthValue = userId + ':' + password;
        authHeader = MapsKt.mapOf(TuplesKt.to("Authorization", "Basic " + Base64Coder.encodeString(preEncodedAuthValue)));
        SimpleHttp.INSTANCE.sendGetRequest(serverUrl + "/auth", timeout, authHeader, (arg_0, arg_1, arg_2) -> UncivServerFileStorage.checkAuthStatus$lambda$4(authStatus, arg_0, arg_1, arg_2));
        return (AuthStatus)((Object)authStatus.element);
    }

    @Override
    public boolean setPassword(@NotNull String newPassword) {
        Intrinsics.checkNotNullParameter(newPassword, "newPassword");
        if (authHeader == null) {
            return false;
        }
        Ref.BooleanRef setSuccessful = new Ref.BooleanRef();
        SimpleHttp.INSTANCE.sendRequest("PUT", serverUrl + "/auth", newPassword, timeout, authHeader, (arg_0, arg_1, arg_2) -> UncivServerFileStorage.setPassword$lambda$5(setSuccessful, arg_0, arg_1, arg_2));
        return setSuccessful.element;
    }

    private final String fileUrl(String fileName) {
        return serverUrl + "/files/" + fileName;
    }

    private static final Unit saveFileData$lambda$0(boolean success, String result2, Integer code) {
        Intrinsics.checkNotNullParameter(result2, "result");
        if (!success) {
            Object[] objectArray = new Object[]{result2};
            LogKt.debug("Error from UncivServer during save: %s", objectArray);
            Integer n = code;
            int n2 = 401;
            if (n != null && n == n2) {
                throw new MultiplayerAuthException(new Exception(result2));
            }
            throw new Exception("" + code + ' ' + result2);
        }
        return Unit.INSTANCE;
    }

    private static final Unit loadFileData$lambda$1(Ref.ObjectRef $fileData, boolean success, String result2, Integer code) {
        Intrinsics.checkNotNullParameter(result2, "result");
        if (!success) {
            Object[] objectArray = new Object[]{result2};
            LogKt.debug("Error from UncivServer during load: %s", objectArray);
            Integer n = code;
            int n2 = 404;
            if (n != null && n == n2) {
                throw new MultiplayerFileNotFoundException(new Exception(result2));
            }
            throw new Exception(result2);
        }
        $fileData.element = result2;
        return Unit.INSTANCE;
    }

    private static final Unit deleteFile$lambda$2(boolean success, String result2, Integer code) {
        Intrinsics.checkNotNullParameter(result2, "result");
        if (!success) {
            Integer n = code;
            int n2 = 404;
            if (n != null && n == n2) {
                throw new MultiplayerFileNotFoundException(new Exception(result2));
            }
            throw new Exception(result2);
        }
        return Unit.INSTANCE;
    }

    private static final Unit authenticate$lambda$3(Ref.BooleanRef $authenticated, boolean success, String result2, Integer code) {
        Intrinsics.checkNotNullParameter(result2, "result");
        if (!success) {
            Object[] objectArray = new Object[]{result2};
            LogKt.debug("Error from UncivServer during authentication: %s", objectArray);
            authHeader = null;
            Integer n = code;
            int n2 = 401;
            if (n != null && n == n2) {
                throw new MultiplayerAuthException(new Exception(result2));
            }
            throw new Exception(result2);
        }
        $authenticated.element = true;
        return Unit.INSTANCE;
    }

    private static final Unit checkAuthStatus$lambda$4(Ref.ObjectRef $authStatus, boolean bl, String string, Integer code) {
        AuthStatus authStatus;
        Integer n;
        Intrinsics.checkNotNullParameter(string, "<unused var>");
        Integer n2 = n = code;
        int n3 = 200;
        if (n2 != null && n2 == n3) {
            authStatus = AuthStatus.VERIFIED;
        } else {
            Integer n4 = n;
            n3 = 204;
            if (n4 != null && n4 == n3) {
                authStatus = AuthStatus.UNREGISTERED;
            } else {
                Integer n5 = n;
                n3 = 401;
                authStatus = n5 != null && n5 == n3 ? AuthStatus.UNAUTHORIZED : AuthStatus.UNKNOWN;
            }
        }
        $authStatus.element = authStatus;
        return Unit.INSTANCE;
    }

    private static final Unit setPassword$lambda$5(Ref.BooleanRef $setSuccessful, boolean success, String result2, Integer code) {
        Intrinsics.checkNotNullParameter(result2, "result");
        if (!success) {
            Object[] objectArray = new Object[]{result2};
            LogKt.debug("Error from UncivServer during password set: %s", objectArray);
            Integer n = code;
            int n2 = 401;
            if (n != null && n == n2) {
                throw new MultiplayerAuthException(new Exception(result2));
            }
            throw new Exception(result2);
        }
        $setSuccessful.element = true;
        return Unit.INSTANCE;
    }

    static {
        serverUrl = "";
        timeout = 30000;
    }
}

