/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.files;

import com.badlogic.gdx.Files;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.scenes.scene2d.ui.TextField;
import com.badlogic.gdx.utils.JsonReader;
import com.badlogic.gdx.utils.JsonValue;
import com.badlogic.gdx.utils.SerializationException;
import com.unciv.UncivGame;
import com.unciv.json.UncivJsonKt;
import com.unciv.logic.GameInfo;
import com.unciv.logic.GameInfoPreview;
import com.unciv.logic.GameInfoSerializationVersion;
import com.unciv.logic.UncivShowableException;
import com.unciv.logic.files.Autosaves;
import com.unciv.logic.files.IncompatibleGameInfoVersionException;
import com.unciv.logic.files.PlatformSaverLoader;
import com.unciv.models.metadata.GameSettings;
import com.unciv.models.metadata.GameSettingsMigrationsKt;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.RulesetCache;
import com.unciv.ui.screens.modmanager.ModUIData;
import com.unciv.ui.screens.savescreens.Gzip;
import com.unciv.utils.Concurrency;
import com.unciv.utils.Log;
import com.unciv.utils.LogKt;
import java.io.File;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 J2\u00020\u0001:\u0001JB\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0005J\u0006\u0010\u0011\u001a\u00020\u000fJ\u000e\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0005J\u0006\u0010\u0014\u001a\u00020\u000fJ\u000e\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0005J\u000e\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0005J\u0018\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0005H\u0002J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00052\b\b\u0002\u0010\u001c\u001a\u00020\u001dJ\u000e\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u0005J\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u000f0 J\u0016\u0010!\u001a\b\u0012\u0004\u0012\u00020\u000f0 2\b\b\u0002\u0010\"\u001a\u00020\u001dJ\u0016\u0010!\u001a\b\u0012\u0004\u0012\u00020\u000f0 2\u0006\u0010\u0018\u001a\u00020\u0005H\u0002J\u000e\u0010#\u001a\u00020\u001d2\u0006\u0010\u0016\u001a\u00020\u0005J\u000e\u0010#\u001a\u00020\u001d2\u0006\u0010$\u001a\u00020\u000fJ4\u0010%\u001a\u00020\u000f2\u0006\u0010&\u001a\u00020'2\u0006\u0010\u0016\u001a\u00020\u00052\u001c\b\u0002\u0010(\u001a\u0016\u0012\f\u0012\n\u0018\u00010*j\u0004\u0018\u0001`+\u0012\u0004\u0012\u00020,0)J4\u0010%\u001a\u00020,2\u0006\u0010&\u001a\u00020'2\u0006\u0010$\u001a\u00020\u000f2\u001c\b\u0002\u0010(\u001a\u0016\u0012\f\u0012\n\u0018\u00010*j\u0004\u0018\u0001`+\u0012\u0004\u0012\u00020,0)J4\u0010-\u001a\u00020\u000f2\u0006\u0010&\u001a\u00020.2\u0006\u0010\u0016\u001a\u00020\u00052\u001c\b\u0002\u0010(\u001a\u0016\u0012\f\u0012\n\u0018\u00010*j\u0004\u0018\u0001`+\u0012\u0004\u0012\u00020,0)J4\u0010-\u001a\u00020,2\u0006\u0010&\u001a\u00020.2\u0006\u0010$\u001a\u00020\u000f2\u001c\b\u0002\u0010(\u001a\u0016\u0012\f\u0012\n\u0018\u00010*j\u0004\u0018\u0001`+\u0012\u0004\u0012\u00020,0)J<\u0010/\u001a\u00020,2\u0006\u0010&\u001a\u00020'2\u0006\u0010\u0016\u001a\u00020\u00052\f\u00100\u001a\b\u0012\u0004\u0012\u00020,012\u0016\u00102\u001a\u0012\u0012\b\u0012\u00060*j\u0002`+\u0012\u0004\u0012\u00020,0)J\u000e\u00103\u001a\u00020'2\u0006\u0010\u0016\u001a\u00020\u0005J\u000e\u00104\u001a\u00020'2\u0006\u00105\u001a\u00020\u000fJ\u000e\u00106\u001a\u00020.2\u0006\u00105\u001a\u00020\u000fJ\u0010\u00107\u001a\u0002082\u0006\u00105\u001a\u00020\u000fH\u0002J2\u00109\u001a\u00020,2\u0012\u0010:\u001a\u000e\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020,0)2\u0016\u00102\u001a\u0012\u0012\b\u0012\u00060*j\u0002`+\u0012\u0004\u0012\u00020,0)J\b\u0010;\u001a\u00020\u000fH\u0002J\u0006\u0010<\u001a\u00020=J\u000e\u0010>\u001a\u00020,2\u0006\u0010?\u001a\u00020=J \u0010A\u001a\u001c\u0012\u0018\u0012\u0016\u0012\f\u0012\n C*\u0004\u0018\u00010\u000f0\u000f\u0012\u0004\u0012\u00020D0B0 J\u0014\u0010E\u001a\u00020,2\f\u0010F\u001a\b\u0012\u0004\u0012\u00020H0GJ\f\u0010I\u001a\b\u0012\u0004\u0012\u00020H0GR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010@\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006K"}, d2={"Lcom/unciv/logic/files/UncivFiles;", "", "files", "Lcom/badlogic/gdx/Files;", "customDataDirectory", "", "<init>", "(Lcom/badlogic/gdx/Files;Ljava/lang/String;)V", "getCustomDataDirectory", "()Ljava/lang/String;", "autosaves", "Lcom/unciv/logic/files/Autosaves;", "getAutosaves", "()Lcom/unciv/logic/files/Autosaves;", "getLocalFile", "Lcom/badlogic/gdx/files/FileHandle;", "fileName", "getModsFolder", "getModFolder", "modName", "getDataFolder", "getSave", "gameName", "getMultiplayerSave", "saveFolder", "fileWriter", "Ljava/io/Writer;", "path", "append", "", "pathToFileHandler", "getMultiplayerSaves", "Lkotlin/sequences/Sequence;", "getSaves", "autoSaves", "deleteSave", "file", "saveGame", "game", "Lcom/unciv/logic/GameInfo;", "saveCompletionCallback", "Lkotlin/Function1;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "", "saveMultiplayerGamePreview", "Lcom/unciv/logic/GameInfoPreview;", "saveGameToCustomLocation", "onSaved", "Lkotlin/Function0;", "onError", "loadGameByName", "loadGameFromFile", "gameFile", "loadGamePreviewFromFile", "emptyFile", "Lcom/badlogic/gdx/utils/SerializationException;", "loadGameFromCustomLocation", "onLoaded", "getGeneralSettingsFile", "getGeneralSettings", "Lcom/unciv/models/metadata/GameSettings;", "setGeneralSettings", "gameSettings", "scenarioFolder", "getScenarioFiles", "Lkotlin/Pair;", "kotlin.jvm.PlatformType", "Lcom/unciv/models/ruleset/Ruleset;", "saveModCache", "modDataList", "", "Lcom/unciv/ui/screens/modmanager/ModUIData;", "loadModCache", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nUncivFiles.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UncivFiles.kt\ncom/unciv/logic/files/UncivFiles\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,549:1\n1#2:550\n*E\n"})
public final class UncivFiles {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Files files;
    @Nullable
    private final String customDataDirectory;
    @NotNull
    private final Autosaves autosaves;
    @NotNull
    private final String scenarioFolder;
    private static boolean saveZipped;
    private static boolean preferExternalStorage;
    @NotNull
    private static PlatformSaverLoader saverLoader;
    @NotNull
    private static final Set<Character> charsForbiddenInFileNames;
    @NotNull
    private static final TextField.TextFieldFilter _fileNameTextFieldFilter;

    public UncivFiles(@NotNull Files files, @Nullable String customDataDirectory) {
        Intrinsics.checkNotNullParameter(files, "files");
        this.files = files;
        this.customDataDirectory = customDataDirectory;
        Object[] objectArray = new Object[]{this.files.getLocalStoragePath(), this.files.getExternalStoragePath()};
        LogKt.debug("Creating UncivFiles, localStoragePath: %s, externalStoragePath: %s", objectArray);
        this.autosaves = new Autosaves(this);
        this.scenarioFolder = "scenarios";
    }

    public /* synthetic */ UncivFiles(Files files, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = null;
        }
        this(files, string);
    }

    @Nullable
    public final String getCustomDataDirectory() {
        return this.customDataDirectory;
    }

    @NotNull
    public final Autosaves getAutosaves() {
        return this.autosaves;
    }

    @NotNull
    public final FileHandle getLocalFile(@NotNull String fileName) {
        FileHandle fileHandle;
        Intrinsics.checkNotNullParameter(fileName, "fileName");
        if (this.customDataDirectory == null) {
            FileHandle fileHandle2 = this.files.local(fileName);
            fileHandle = fileHandle2;
            Intrinsics.checkNotNullExpressionValue(fileHandle2, "local(...)");
        } else {
            FileHandle fileHandle3 = this.files.absolute(this.customDataDirectory + File.separator + fileName);
            fileHandle = fileHandle3;
            Intrinsics.checkNotNullExpressionValue(fileHandle3, "absolute(...)");
        }
        return fileHandle;
    }

    @NotNull
    public final FileHandle getModsFolder() {
        return this.getLocalFile("mods");
    }

    @NotNull
    public final FileHandle getModFolder(@NotNull String modName) {
        Intrinsics.checkNotNullParameter(modName, "modName");
        FileHandle fileHandle = this.getModsFolder().child(modName);
        Intrinsics.checkNotNullExpressionValue(fileHandle, "child(...)");
        return fileHandle;
    }

    @NotNull
    public final FileHandle getDataFolder() {
        return this.getLocalFile("");
    }

    @NotNull
    public final FileHandle getSave(@NotNull String gameName) {
        Intrinsics.checkNotNullParameter(gameName, "gameName");
        return this.getSave("SaveFiles", gameName);
    }

    @NotNull
    public final FileHandle getMultiplayerSave(@NotNull String gameName) {
        Intrinsics.checkNotNullParameter(gameName, "gameName");
        return this.getSave("MultiplayerGames", gameName);
    }

    private final FileHandle getSave(String saveFolder, String gameName) {
        FileHandle fileHandle;
        Object[] objectArray = new Object[]{gameName, saveFolder, preferExternalStorage, this.files.getExternalStoragePath()};
        LogKt.debug("Getting save %s from folder %s, preferExternal: %s", objectArray);
        String location = saveFolder + '/' + gameName;
        FileHandle localFile = this.getLocalFile(location);
        FileHandle externalFile = this.files.external(location);
        if (this.files.isExternalStorageAvailable() && (externalFile.exists() && !localFile.exists() || preferExternalStorage && (externalFile.exists() || !localFile.exists()))) {
            if (externalFile.isDirectory()) {
                externalFile.deleteDirectory();
            }
            externalFile.parent().mkdirs();
            fileHandle = externalFile;
        } else {
            fileHandle = localFile;
        }
        FileHandle toReturn = fileHandle;
        Object[] objectArray2 = new Object[]{toReturn.file().getAbsolutePath()};
        LogKt.debug("Save found: %s", objectArray2);
        Intrinsics.checkNotNull(toReturn);
        return toReturn;
    }

    @NotNull
    public final Writer fileWriter(@NotNull String path, boolean append2) {
        Intrinsics.checkNotNullParameter(path, "path");
        FileHandle file = this.pathToFileHandler(path);
        Writer writer2 = file.writer(append2, Charsets.UTF_8.name());
        Intrinsics.checkNotNullExpressionValue(writer2, "writer(...)");
        return writer2;
    }

    public static /* synthetic */ Writer fileWriter$default(UncivFiles uncivFiles, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return uncivFiles.fileWriter(string, bl);
    }

    @NotNull
    public final FileHandle pathToFileHandler(@NotNull String path) {
        FileHandle fileHandle;
        Intrinsics.checkNotNullParameter(path, "path");
        if (preferExternalStorage && this.files.isExternalStorageAvailable()) {
            FileHandle fileHandle2 = this.files.external(path);
            fileHandle = fileHandle2;
            Intrinsics.checkNotNullExpressionValue(fileHandle2, "external(...)");
        } else {
            fileHandle = this.getLocalFile(path);
        }
        return fileHandle;
    }

    @NotNull
    public final Sequence<FileHandle> getMultiplayerSaves() {
        return this.getSaves("MultiplayerGames");
    }

    @NotNull
    public final Sequence<FileHandle> getSaves(boolean autoSaves) {
        Sequence<FileHandle> saves = this.getSaves("SaveFiles");
        if (autoSaves) {
            return saves;
        }
        return SequencesKt.filter(saves, UncivFiles::getSaves$lambda$0);
    }

    public static /* synthetic */ Sequence getSaves$default(UncivFiles uncivFiles, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return uncivFiles.getSaves(bl);
    }

    private final Sequence<FileHandle> getSaves(String saveFolder) {
        Object[] objectArray = new Object[]{saveFolder, this.files.getExternalStoragePath()};
        LogKt.debug("Getting saves from folder %s, externalStoragePath: %s", objectArray);
        Sequence localFiles = new Sequence<FileHandle>(this, saveFolder){
            final /* synthetic */ UncivFiles this$0;
            final /* synthetic */ String $saveFolder$inlined;
            {
                this.this$0 = uncivFiles;
                this.$saveFolder$inlined = string;
            }

            public Iterator<FileHandle> iterator() {
                boolean bl = false;
                return ArrayIteratorKt.iterator(this.this$0.getLocalFile(this.$saveFolder$inlined).list());
            }
        };
        Sequence externalFiles = !this.files.isExternalStorageAvailable() ? SequencesKt.emptySequence() : (Intrinsics.areEqual(this.getDataFolder().file().getAbsolutePath(), this.files.external("").file().getAbsolutePath()) ? SequencesKt.emptySequence() : (Sequence)new Sequence<FileHandle>(this, saveFolder){
            final /* synthetic */ UncivFiles this$0;
            final /* synthetic */ String $saveFolder$inlined;
            {
                this.this$0 = uncivFiles;
                this.$saveFolder$inlined = string;
            }

            public Iterator<FileHandle> iterator() {
                boolean bl = false;
                return ArrayIteratorKt.iterator(UncivFiles.access$getFiles$p(this.this$0).external(this.$saveFolder$inlined).list());
            }
        });
        Object[] objectArray2 = new Object[]{() -> UncivFiles.getSaves$lambda$4(localFiles), () -> UncivFiles.getSaves$lambda$6(externalFiles)};
        LogKt.debug("Local files: %s, external files: %s", objectArray2);
        return SequencesKt.plus(localFiles, externalFiles);
    }

    public final boolean deleteSave(@NotNull String gameName) {
        Intrinsics.checkNotNullParameter(gameName, "gameName");
        return this.deleteSave(this.getSave(gameName));
    }

    public final boolean deleteSave(@NotNull FileHandle file) {
        Intrinsics.checkNotNullParameter(file, "file");
        Object[] objectArray = new Object[]{file.path()};
        LogKt.debug("Deleting save %s", objectArray);
        return file.delete();
    }

    @NotNull
    public final FileHandle saveGame(@NotNull GameInfo game, @NotNull String gameName, @NotNull Function1<? super Exception, Unit> saveCompletionCallback) {
        Intrinsics.checkNotNullParameter(game, "game");
        Intrinsics.checkNotNullParameter(gameName, "gameName");
        Intrinsics.checkNotNullParameter(saveCompletionCallback, "saveCompletionCallback");
        FileHandle file = this.getSave(gameName);
        this.saveGame(game, file, saveCompletionCallback);
        return file;
    }

    public static /* synthetic */ FileHandle saveGame$default(UncivFiles uncivFiles, GameInfo gameInfo, String string, Function1 function1, int n, Object object) {
        if ((n & 4) != 0) {
            function1 = UncivFiles::saveGame$lambda$7;
        }
        return uncivFiles.saveGame(gameInfo, string, function1);
    }

    public final void saveGame(@NotNull GameInfo game, @NotNull FileHandle file, @NotNull Function1<? super Exception, Unit> saveCompletionCallback) {
        Intrinsics.checkNotNullParameter(game, "game");
        Intrinsics.checkNotNullParameter(file, "file");
        Intrinsics.checkNotNullParameter(saveCompletionCallback, "saveCompletionCallback");
        try {
            Object[] objectArray = new Object[]{game.getGameId(), file.path()};
            LogKt.debug("Saving GameInfo %s to %s", objectArray);
            String string = com.unciv.logic.files.UncivFiles$Companion.gameInfoToString$default(Companion, game, null, false, 6, null);
            file.writeString(string, false, Charsets.UTF_8.name());
            saveCompletionCallback.invoke(null);
        }
        catch (Exception ex) {
            saveCompletionCallback.invoke(ex);
        }
    }

    public static /* synthetic */ void saveGame$default(UncivFiles uncivFiles, GameInfo gameInfo, FileHandle fileHandle, Function1 function1, int n, Object object) {
        if ((n & 4) != 0) {
            function1 = UncivFiles::saveGame$lambda$8;
        }
        uncivFiles.saveGame(gameInfo, fileHandle, function1);
    }

    @NotNull
    public final FileHandle saveMultiplayerGamePreview(@NotNull GameInfoPreview game, @NotNull String gameName, @NotNull Function1<? super Exception, Unit> saveCompletionCallback) {
        Intrinsics.checkNotNullParameter(game, "game");
        Intrinsics.checkNotNullParameter(gameName, "gameName");
        Intrinsics.checkNotNullParameter(saveCompletionCallback, "saveCompletionCallback");
        FileHandle file = this.getMultiplayerSave(gameName);
        this.saveMultiplayerGamePreview(game, file, saveCompletionCallback);
        return file;
    }

    public static /* synthetic */ FileHandle saveMultiplayerGamePreview$default(UncivFiles uncivFiles, GameInfoPreview gameInfoPreview, String string, Function1 function1, int n, Object object) {
        if ((n & 4) != 0) {
            function1 = UncivFiles::saveMultiplayerGamePreview$lambda$9;
        }
        return uncivFiles.saveMultiplayerGamePreview(gameInfoPreview, string, function1);
    }

    public final void saveMultiplayerGamePreview(@NotNull GameInfoPreview game, @NotNull FileHandle file, @NotNull Function1<? super Exception, Unit> saveCompletionCallback) {
        Intrinsics.checkNotNullParameter(game, "game");
        Intrinsics.checkNotNullParameter(file, "file");
        Intrinsics.checkNotNullParameter(saveCompletionCallback, "saveCompletionCallback");
        try {
            Object[] objectArray = new Object[]{game.getGameId(), file.path()};
            LogKt.debug("Saving GameInfoPreview %s to %s", objectArray);
            UncivJsonKt.json().toJson((Object)game, file);
            saveCompletionCallback.invoke(null);
        }
        catch (Exception ex) {
            saveCompletionCallback.invoke(ex);
        }
    }

    public static /* synthetic */ void saveMultiplayerGamePreview$default(UncivFiles uncivFiles, GameInfoPreview gameInfoPreview, FileHandle fileHandle, Function1 function1, int n, Object object) {
        if ((n & 4) != 0) {
            function1 = UncivFiles::saveMultiplayerGamePreview$lambda$10;
        }
        uncivFiles.saveMultiplayerGamePreview(gameInfoPreview, fileHandle, function1);
    }

    public final void saveGameToCustomLocation(@NotNull GameInfo game, @NotNull String gameName, @NotNull Function0<Unit> onSaved, @NotNull Function1<? super Exception, Unit> onError) {
        Intrinsics.checkNotNullParameter(game, "game");
        Intrinsics.checkNotNullParameter(gameName, "gameName");
        Intrinsics.checkNotNullParameter(onSaved, "onSaved");
        Intrinsics.checkNotNullParameter(onError, "onError");
        String string = game.getCustomSaveLocation();
        if (string == null) {
            string = UncivGame.Companion.getCurrent().getFiles().getLocalFile(gameName).path();
        }
        String saveLocation = string;
        try {
            String data = com.unciv.logic.files.UncivFiles$Companion.gameInfoToString$default(Companion, game, null, false, 6, null);
            Object[] objectArray = new Object[]{game.getGameId(), saveLocation};
            LogKt.debug("Initiating UI to save GameInfo %s to custom location %s", objectArray);
            Intrinsics.checkNotNull(saveLocation);
            saverLoader.saveGame(data, saveLocation, arg_0 -> UncivFiles.saveGameToCustomLocation$lambda$11(game, onSaved, arg_0), arg_0 -> UncivFiles.saveGameToCustomLocation$lambda$12(onError, arg_0));
        }
        catch (Exception ex) {
            Concurrency.runOnGLThread$default(Concurrency.INSTANCE, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(onError, ex, null){
                int label;
                final /* synthetic */ Function1<Exception, Unit> $onError;
                final /* synthetic */ Exception $ex;
                {
                    this.$onError = $onError;
                    this.$ex = $ex;
                    super(2, $completion);
                }

                public final Object invokeSuspend(Object $result) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure($result);
                            this.$onError.invoke(this.$ex);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }, 1, null);
        }
    }

    @NotNull
    public final GameInfo loadGameByName(@NotNull String gameName) {
        Intrinsics.checkNotNullParameter(gameName, "gameName");
        return this.loadGameFromFile(this.getSave(gameName));
    }

    @NotNull
    public final GameInfo loadGameFromFile(@NotNull FileHandle gameFile) {
        Intrinsics.checkNotNullParameter(gameFile, "gameFile");
        String gameData = gameFile.readString(Charsets.UTF_8.name());
        CharSequence charSequence = gameData;
        if (charSequence == null || StringsKt.isBlank(charSequence)) {
            throw this.emptyFile(gameFile);
        }
        return Companion.gameInfoFromString(gameData);
    }

    @NotNull
    public final GameInfoPreview loadGamePreviewFromFile(@NotNull FileHandle gameFile) {
        Intrinsics.checkNotNullParameter(gameFile, "gameFile");
        GameInfoPreview gameInfoPreview = UncivJsonKt.json().fromJson(GameInfoPreview.class, gameFile);
        if (gameInfoPreview == null) {
            throw this.emptyFile(gameFile);
        }
        return gameInfoPreview;
    }

    private final SerializationException emptyFile(FileHandle gameFile) {
        return new SerializationException("The file for the game " + gameFile.name() + " is empty");
    }

    public final void loadGameFromCustomLocation(@NotNull Function1<? super GameInfo, Unit> onLoaded, @NotNull Function1<? super Exception, Unit> onError) {
        Intrinsics.checkNotNullParameter(onLoaded, "onLoaded");
        Intrinsics.checkNotNullParameter(onError, "onError");
        saverLoader.loadGame((arg_0, arg_1) -> UncivFiles.loadGameFromCustomLocation$lambda$13(onLoaded, onError, arg_0, arg_1), arg_0 -> UncivFiles.loadGameFromCustomLocation$lambda$14(onError, arg_0));
    }

    private final FileHandle getGeneralSettingsFile() {
        return UncivGame.Companion.getCurrent().isConsoleMode() ? new FileHandle("GameSettings.json") : this.getLocalFile("GameSettings.json");
    }

    @NotNull
    public final GameSettings getGeneralSettings() {
        GameSettings gameSettings;
        FileHandle settingsFile = this.getGeneralSettingsFile();
        GameSettings settings = null;
        if (settingsFile.exists()) {
            try {
                GameSettings gameSettings2 = settings = UncivJsonKt.json().fromJson(GameSettings.class, settingsFile);
                Intrinsics.checkNotNull(gameSettings2);
                if (GameSettingsMigrationsKt.isMigrationNecessary(gameSettings2)) {
                    gameSettings2 = settings;
                    Intrinsics.checkNotNull(gameSettings2);
                    JsonValue jsonValue = new JsonReader().parse(settingsFile);
                    Intrinsics.checkNotNullExpressionValue(jsonValue, "parse(...)");
                    GameSettingsMigrationsKt.doMigrations(gameSettings2, jsonValue);
                }
            }
            catch (Exception ex) {
                Log.INSTANCE.error("Error reading settings file", ex);
            }
        }
        if ((gameSettings = settings) == null) {
            GameSettings gameSettings3;
            GameSettings $this$getGeneralSettings_u24lambda_u2415 = gameSettings3 = new GameSettings();
            boolean bl = false;
            $this$getGeneralSettings_u24lambda_u2415.setFreshlyCreated(true);
            gameSettings = gameSettings3;
        }
        return gameSettings;
    }

    public final void setGeneralSettings(@NotNull GameSettings gameSettings) {
        Intrinsics.checkNotNullParameter(gameSettings, "gameSettings");
        this.getGeneralSettingsFile().writeString(UncivJsonKt.json().toJson(gameSettings), false, Charsets.UTF_8.name());
    }

    @NotNull
    public final Sequence<Pair<FileHandle, Ruleset>> getScenarioFiles() {
        return SequencesKt.sequence((Function2)new Function2<SequenceScope<? super Pair<? extends FileHandle, ? extends Ruleset>>, Continuation<? super Unit>, Object>(this, null){
            Object L$1;
            Object L$2;
            Object L$3;
            Object L$4;
            Object L$5;
            Object L$6;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ UncivFiles this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = (SequenceScope)this.L$0;
                var9_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure($result);
                        var3_4 = RulesetCache.INSTANCE.values().iterator();
                        while (var3_4.hasNext()) {
                            Intrinsics.checkNotNullExpressionValue(var3_4.next(), "next(...)");
                            if (mod.getFolderLocation() == null || !(scenarioFolder = modFolder.child(UncivFiles.access$getScenarioFolder$p(this.this$0))).exists()) continue;
                            var7_8 = ArrayIteratorKt.iterator(scenarioFolder.list());
lbl11:
                            // 3 sources

                            while (var7_8.hasNext()) {
                                file = var7_8.next();
                                this.L$0 = $this$sequence;
                                this.L$1 = var3_4;
                                this.L$2 = mod;
                                this.L$3 = SpillingKt.nullOutSpilledVariable(modFolder);
                                this.L$4 = SpillingKt.nullOutSpilledVariable(scenarioFolder);
                                this.L$5 = var7_8;
                                this.L$6 = SpillingKt.nullOutSpilledVariable(file);
                                this.label = 1;
                                v0 = $this$sequence.yield(new Pair<FileHandle, Ruleset>(file, mod), this);
                                if (v0 != var9_3) continue;
                                return var9_3;
                            }
                        }
                        break;
                    }
                    case 1: {
                        file = (FileHandle)this.L$6;
                        var7_8 = (Iterator<FileHandle>)this.L$5;
                        scenarioFolder = (FileHandle)this.L$4;
                        modFolder = (FileHandle)this.L$3;
                        mod = (Ruleset)this.L$2;
                        var3_4 = (Iterator)this.L$1;
                        ResultKt.throwOnFailure($result);
                        v0 = $result;
                        ** GOTO lbl11
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                Function2<SequenceScope<? super Pair<? extends FileHandle, ? extends Ruleset>>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)((Object)function2);
            }

            public final Object invoke(SequenceScope<? super Pair<? extends FileHandle, Ruleset>> p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    public final void saveModCache(@NotNull List<ModUIData> modDataList) {
        Intrinsics.checkNotNullParameter(modDataList, "modDataList");
        FileHandle file = this.getLocalFile("ModListCache.json");
        try {
            UncivJsonKt.json().toJson(modDataList, file);
        }
        catch (Exception ex) {
            Log.INSTANCE.error("Error saving mod cache", ex);
        }
    }

    @NotNull
    public final List<ModUIData> loadModCache() {
        FileHandle file = this.getLocalFile("ModListCache.json");
        if (!file.exists()) {
            return CollectionsKt.emptyList();
        }
        try {
            return ArraysKt.toList((Object[])UncivJsonKt.fromJsonFile(UncivJsonKt.json(), ModUIData[].class, file));
        }
        catch (Exception ex) {
            Log.INSTANCE.error("Error loading mod cache", ex);
            return CollectionsKt.emptyList();
        }
    }

    private static final boolean getSaves$lambda$0(FileHandle it) {
        Intrinsics.checkNotNullParameter(it, "it");
        String string = it.name();
        Intrinsics.checkNotNullExpressionValue(string, "name(...)");
        return !StringsKt.startsWith$default(string, "Autosave", false, 2, null);
    }

    private static final CharSequence getSaves$lambda$4$lambda$3(FileHandle it) {
        String string = it.file().getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue(string, "getAbsolutePath(...)");
        return string;
    }

    private static final String getSaves$lambda$4(Sequence $localFiles) {
        return SequencesKt.joinToString$default($localFiles, null, "[", "]", 0, null, UncivFiles::getSaves$lambda$4$lambda$3, 25, null);
    }

    private static final CharSequence getSaves$lambda$6$lambda$5(FileHandle it) {
        String string = it.file().getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue(string, "getAbsolutePath(...)");
        return string;
    }

    private static final String getSaves$lambda$6(Sequence $externalFiles) {
        return SequencesKt.joinToString$default($externalFiles, null, "[", "]", 0, null, UncivFiles::getSaves$lambda$6$lambda$5, 25, null);
    }

    private static final Unit saveGame$lambda$7(Exception it) {
        Exception exception2 = it;
        if (exception2 != null) {
            throw exception2;
        }
        return Unit.INSTANCE;
    }

    private static final Unit saveGame$lambda$8(Exception it) {
        Exception exception2 = it;
        if (exception2 != null) {
            throw exception2;
        }
        return Unit.INSTANCE;
    }

    private static final Unit saveMultiplayerGamePreview$lambda$9(Exception it) {
        Exception exception2 = it;
        if (exception2 != null) {
            throw exception2;
        }
        return Unit.INSTANCE;
    }

    private static final Unit saveMultiplayerGamePreview$lambda$10(Exception it) {
        Exception exception2 = it;
        if (exception2 != null) {
            throw exception2;
        }
        return Unit.INSTANCE;
    }

    private static final Unit saveGameToCustomLocation$lambda$11(GameInfo $game, Function0 $onSaved, String location) {
        Intrinsics.checkNotNullParameter(location, "location");
        $game.setCustomSaveLocation(location);
        Concurrency.runOnGLThread$default(Concurrency.INSTANCE, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>((Function0<Unit>)$onSaved, null){
            int label;
            final /* synthetic */ Function0<Unit> $onSaved;
            {
                this.$onSaved = $onSaved;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure($result);
                        this.$onSaved.invoke();
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 1, null);
        return Unit.INSTANCE;
    }

    private static final Unit saveGameToCustomLocation$lambda$12(Function1 $onError, Exception it) {
        Intrinsics.checkNotNullParameter(it, "it");
        Concurrency.runOnGLThread$default(Concurrency.INSTANCE, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>((Function1<? super Exception, Unit>)$onError, it, null){
            int label;
            final /* synthetic */ Function1<Exception, Unit> $onError;
            final /* synthetic */ Exception $it;
            {
                this.$onError = $onError;
                this.$it = $it;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure($result);
                        this.$onError.invoke(this.$it);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 1, null);
        return Unit.INSTANCE;
    }

    private static final Unit loadGameFromCustomLocation$lambda$13(Function1 $onLoaded, Function1 $onError, String data, String location) {
        Intrinsics.checkNotNullParameter(data, "data");
        Intrinsics.checkNotNullParameter(location, "location");
        try {
            GameInfo game = Companion.gameInfoFromString(data);
            game.setCustomSaveLocation(location);
            Concurrency.runOnGLThread$default(Concurrency.INSTANCE, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>((Function1<? super GameInfo, Unit>)$onLoaded, game, null){
                int label;
                final /* synthetic */ Function1<GameInfo, Unit> $onLoaded;
                final /* synthetic */ GameInfo $game;
                {
                    this.$onLoaded = $onLoaded;
                    this.$game = $game;
                    super(2, $completion);
                }

                public final Object invokeSuspend(Object $result) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure($result);
                            this.$onLoaded.invoke(this.$game);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }, 1, null);
        }
        catch (Exception ex) {
            Concurrency.runOnGLThread$default(Concurrency.INSTANCE, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>((Function1<? super Exception, Unit>)$onError, ex, null){
                int label;
                final /* synthetic */ Function1<Exception, Unit> $onError;
                final /* synthetic */ Exception $ex;
                {
                    this.$onError = $onError;
                    this.$ex = $ex;
                    super(2, $completion);
                }

                public final Object invokeSuspend(Object $result) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure($result);
                            this.$onError.invoke(this.$ex);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }, 1, null);
        }
        return Unit.INSTANCE;
    }

    private static final Unit loadGameFromCustomLocation$lambda$14(Function1 $onError, Exception it) {
        Intrinsics.checkNotNullParameter(it, "it");
        Concurrency.runOnGLThread$default(Concurrency.INSTANCE, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>((Function1<? super Exception, Unit>)$onError, it, null){
            int label;
            final /* synthetic */ Function1<Exception, Unit> $onError;
            final /* synthetic */ Exception $it;
            {
                this.$onError = $onError;
                this.$it = $it;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure($result);
                        this.$onError.invoke(this.$it);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 1, null);
        return Unit.INSTANCE;
    }

    private static final boolean _fileNameTextFieldFilter$lambda$16(TextField textField, char c) {
        return !charsForbiddenInFileNames.contains(Character.valueOf(c));
    }

    public static final /* synthetic */ String access$getScenarioFolder$p(UncivFiles $this) {
        return $this.scenarioFolder;
    }

    public static final /* synthetic */ Files access$getFiles$p(UncivFiles $this) {
        return $this.files;
    }

    static {
        saverLoader = PlatformSaverLoader.Companion.getNone();
        Character[] characterArray = new Character[]{Character.valueOf('\\'), Character.valueOf('/'), Character.valueOf(':')};
        charsForbiddenInFileNames = SetsKt.setOf(characterArray);
        _fileNameTextFieldFilter = UncivFiles::_fileNameTextFieldFilter$lambda$16;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\"\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0016J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0019\u001a\u00020\u0016J)\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u00182\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u001f\u001a\u00020\u0005\u00a2\u0006\u0002\u0010 J\u000e\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u001bJ\u0006\u0010&\u001a\u00020%J\u000e\u0010'\u001a\u00020\u00052\u0006\u0010(\u001a\u00020\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\tR\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/unciv/logic/files/UncivFiles$Companion;", "", "<init>", "()V", "saveZipped", "", "getSaveZipped", "()Z", "setSaveZipped", "(Z)V", "preferExternalStorage", "getPreferExternalStorage", "setPreferExternalStorage", "saverLoader", "Lcom/unciv/logic/files/PlatformSaverLoader;", "getSaverLoader", "()Lcom/unciv/logic/files/PlatformSaverLoader;", "setSaverLoader", "(Lcom/unciv/logic/files/PlatformSaverLoader;)V", "getSettingsForPlatformLaunchers", "Lcom/unciv/models/metadata/GameSettings;", "baseDirectory", "", "gameInfoFromString", "Lcom/unciv/logic/GameInfo;", "gameData", "gameInfoPreviewFromString", "Lcom/unciv/logic/GameInfoPreview;", "gameInfoToString", "game", "forceZip", "updateChecksum", "(Lcom/unciv/logic/GameInfo;Ljava/lang/Boolean;Z)Ljava/lang/String;", "charsForbiddenInFileNames", "", "", "_fileNameTextFieldFilter", "Lcom/badlogic/gdx/scenes/scene2d/ui/TextField$TextFieldFilter;", "fileNameTextFieldFilter", "isValidFileName", "fileName", "core"})
    @SourceDebugExtension(value={"SMAP\nUncivFiles.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UncivFiles.kt\ncom/unciv/logic/files/UncivFiles$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,549:1\n1#2:550\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean getSaveZipped() {
            return saveZipped;
        }

        public final void setSaveZipped(boolean bl) {
            saveZipped = bl;
        }

        public final boolean getPreferExternalStorage() {
            return preferExternalStorage;
        }

        public final void setPreferExternalStorage(boolean bl) {
            preferExternalStorage = bl;
        }

        @NotNull
        public final PlatformSaverLoader getSaverLoader() {
            return saverLoader;
        }

        public final void setSaverLoader(@NotNull PlatformSaverLoader platformSaverLoader) {
            Intrinsics.checkNotNullParameter(platformSaverLoader, "<set-?>");
            saverLoader = platformSaverLoader;
        }

        @NotNull
        public final GameSettings getSettingsForPlatformLaunchers(@NotNull String baseDirectory) {
            GameSettings gameSettings;
            Intrinsics.checkNotNullParameter(baseDirectory, "baseDirectory");
            FileHandle file = new FileHandle(baseDirectory + File.separator + "GameSettings.json");
            if (file.exists()) {
                try {
                    GameSettings gameSettings2 = UncivJsonKt.json().fromJson(GameSettings.class, file);
                    Intrinsics.checkNotNullExpressionValue(gameSettings2, "fromJson(...)");
                    return gameSettings2;
                }
                catch (Exception ex) {
                    Log.INSTANCE.error("Exception while deserializing GameSettings JSON", ex);
                }
            }
            GameSettings $this$getSettingsForPlatformLaunchers_u24lambda_u240 = gameSettings = new GameSettings();
            boolean bl = false;
            $this$getSettingsForPlatformLaunchers_u24lambda_u240.setFreshlyCreated(true);
            return gameSettings;
        }

        @NotNull
        public final GameInfo gameInfoFromString(@NotNull String gameData) {
            GameInfo gameInfo;
            String string;
            Intrinsics.checkNotNullParameter(gameData, "gameData");
            String fixedData = StringsKt.replace$default(StringsKt.replace$default(((Object)StringsKt.trim((CharSequence)gameData)).toString(), "\r", "", false, 4, null), "\n", "", false, 4, null);
            try {
                string = Gzip.INSTANCE.unzip(fixedData);
            }
            catch (Exception ex) {
                string = fixedData;
            }
            String unzippedJson = string;
            try {
                gameInfo = UncivJsonKt.json().fromJson(GameInfo.class, unzippedJson);
            }
            catch (Exception ex) {
                Log.INSTANCE.error("Exception while deserializing GameInfo JSON", ex);
                GameInfoSerializationVersion onlyVersion = UncivJsonKt.json().fromJson(GameInfoSerializationVersion.class, unzippedJson);
                throw new IncompatibleGameInfoVersionException(onlyVersion.getVersion(), (Throwable)ex);
            }
            GameInfo gameInfo2 = gameInfo;
            if (gameInfo2 == null) {
                throw new UncivShowableException("The file data seems to be corrupted.", null, 2, null);
            }
            GameInfo gameInfo3 = gameInfo2;
            if (gameInfo3.getVersion().compareTo(GameInfo.Companion.getCURRENT_COMPATIBILITY_VERSION()) > 0) {
                throw new IncompatibleGameInfoVersionException(gameInfo3.getVersion(), null, 2, null);
            }
            gameInfo3.setTransients();
            return gameInfo3;
        }

        @NotNull
        public final GameInfoPreview gameInfoPreviewFromString(@NotNull String gameData) {
            Intrinsics.checkNotNullParameter(gameData, "gameData");
            GameInfoPreview gameInfoPreview = UncivJsonKt.json().fromJson(GameInfoPreview.class, Gzip.INSTANCE.unzip(gameData));
            Intrinsics.checkNotNullExpressionValue(gameInfoPreview, "fromJson(...)");
            return gameInfoPreview;
        }

        @NotNull
        public final String gameInfoToString(@NotNull GameInfo game, @Nullable Boolean forceZip, boolean updateChecksum) {
            String string;
            Intrinsics.checkNotNullParameter(game, "game");
            game.setVersion(GameInfo.Companion.getCURRENT_COMPATIBILITY_VERSION());
            if (updateChecksum) {
                game.setChecksum(game.calculateChecksum());
            }
            String plainJson = UncivJsonKt.json().toJson(game);
            Boolean bl = forceZip;
            if (bl != null ? bl.booleanValue() : this.getSaveZipped()) {
                Intrinsics.checkNotNull(plainJson);
                string = Gzip.INSTANCE.zip(plainJson);
            } else {
                Intrinsics.checkNotNull(plainJson);
                string = plainJson;
            }
            return string;
        }

        public static /* synthetic */ String gameInfoToString$default(Companion companion, GameInfo gameInfo, Boolean bl, boolean bl2, int n, Object object) {
            if ((n & 2) != 0) {
                bl = null;
            }
            if ((n & 4) != 0) {
                bl2 = false;
            }
            return companion.gameInfoToString(gameInfo, bl, bl2);
        }

        @NotNull
        public final String gameInfoToString(@NotNull GameInfoPreview game) {
            Intrinsics.checkNotNullParameter(game, "game");
            String string = UncivJsonKt.json().toJson(game);
            Intrinsics.checkNotNullExpressionValue(string, "toJson(...)");
            return Gzip.INSTANCE.zip(string);
        }

        @NotNull
        public final TextField.TextFieldFilter fileNameTextFieldFilter() {
            return _fileNameTextFieldFilter;
        }

        public final boolean isValidFileName(@NotNull String fileName) {
            Intrinsics.checkNotNullParameter(fileName, "fileName");
            return ((CharSequence)fileName).length() > 0 && !StringsKt.endsWith$default((CharSequence)fileName, ' ', false, 2, null) && !StringsKt.startsWith$default((CharSequence)fileName, ' ', false, 2, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

