/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.event;

import com.unciv.logic.event.Event;
import com.unciv.logic.event.EventListener;
import com.unciv.logic.event.EventListenerWeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.reflect.KClassifier;
import kotlin.reflect.KType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001 B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\t\u001a\u00020\n\"\b\b\u0000\u0010\u000b*\u00020\f2\u0006\u0010\r\u001a\u0002H\u000b\u00a2\u0006\u0002\u0010\u000eJ*\u0010\u000f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00110\u0010\"\b\b\u0000\u0010\u000b*\u00020\f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u0006H\u0002J*\u0010\u0013\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0014\"\b\b\u0000\u0010\u000b*\u00020\f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u0006H\u0002J\u001e\u0010\u0015\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u00142\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0002J\u001e\u0010\u0017\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00110\u00142\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0002JL\u0010\u0018\u001a\u00020\n\"\b\b\u0000\u0010\u000b*\u00020\f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u00062\u0016\b\u0002\u0010\u0019\u001a\u0010\u0012\u0004\u0012\u0002H\u000b\u0012\u0004\u0012\u00020\u001b\u0018\u00010\u001a2\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u0002H\u000b\u0012\u0004\u0012\u00020\n0\u001aH\u0002J&\u0010\u001d\u001a\u00020\n2\u001c\u0010\u001e\u001a\u0018\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u00070\u001fH\u0002R(\u0010\u0004\u001a\u001c\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0006\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/unciv/logic/event/EventBus;", "", "<init>", "()V", "listeners", "", "Lkotlin/reflect/KClass;", "", "Lcom/unciv/logic/event/EventListenerWeakReference;", "send", "", "T", "Lcom/unciv/logic/event/Event;", "event", "(Lcom/unciv/logic/event/Event;)V", "getListeners", "", "Lcom/unciv/logic/event/EventListener;", "eventClass", "getClassesToListenTo", "", "getSuperClasses", "kClass", "updateActiveListeners", "receive", "filter", "Lkotlin/Function1;", "", "eventHandler", "cleanUp", "eventHandlers", "", "EventReceiver", "core"})
@SourceDebugExtension(value={"SMAP\nEventBus.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EventBus.kt\ncom/unciv/logic/event/EventBus\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,175:1\n1563#2:176\n1634#2,3:177\n1374#2:180\n1460#2,5:181\n774#2:186\n865#2,2:187\n*S KotlinDebug\n*F\n+ 1 EventBus.kt\ncom/unciv/logic/event/EventBus\n*L\n55#1:176\n55#1:177,3\n56#1:180\n56#1:181,5\n57#1:186\n57#1:187,2\n*E\n"})
public final class EventBus {
    @NotNull
    public static final EventBus INSTANCE = new EventBus();
    @NotNull
    private static final Map<KClass<?>, List<EventListenerWeakReference<?>>> listeners = new LinkedHashMap();

    private EventBus() {
    }

    public final <T extends Event> void send(@NotNull T event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Set<EventListener<?>> set = this.getListeners(Reflection.getOrCreateKotlinClass(event.getClass()));
        Intrinsics.checkNotNull(set, "null cannot be cast to non-null type kotlin.collections.Set<com.unciv.logic.event.EventListener<T of com.unciv.logic.event.EventBus.send>>");
        Set<EventListener<?>> eventListeners = set;
        for (EventListener<?> listener : eventListeners) {
            Function1<?, Boolean> filter2 = listener.getFilter();
            if (filter2 != null && !filter2.invoke(event).booleanValue()) continue;
            listener.getEventHandler().invoke(event);
        }
    }

    private final <T extends Event> Set<EventListener<?>> getListeners(KClass<T> eventClass) {
        Set set;
        List<KClass<?>> classesToListenTo = this.getClassesToListenTo(eventClass);
        Set $this$getListeners_u24lambda_u240 = set = SetsKt.createSetBuilder();
        boolean bl = false;
        for (KClass<?> classToListenTo : classesToListenTo) {
            $this$getListeners_u24lambda_u240.addAll(INSTANCE.updateActiveListeners(classToListenTo));
        }
        return SetsKt.build(set);
    }

    private final <T extends Event> List<KClass<?>> getClassesToListenTo(KClass<T> eventClass) {
        return CollectionsKt.plus((Collection)this.getSuperClasses(eventClass), eventClass);
    }

    /*
     * WARNING - void declaration
     */
    private final List<KClass<?>> getSuperClasses(KClass<?> kClass) {
        void $this$filterTo$iv$iv;
        Iterable $this$flatMapTo$iv$iv;
        KClass it;
        Iterable $this$mapTo$iv$iv;
        if (kClass.getSupertypes().size() == 1 && Intrinsics.areEqual(kClass.getSupertypes().get(0), Reflection.getOrCreateKotlinClass(Object.class))) {
            return CollectionsKt.emptyList();
        }
        Iterable $this$map$iv = kClass.getSupertypes();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            KType kType = (KType)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            KClassifier kClassifier = it.getClassifier();
            Intrinsics.checkNotNull(kClassifier, "null cannot be cast to non-null type kotlin.reflect.KClass<*>");
            collection.add((KClass)kClassifier);
        }
        Iterable $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$flatMap = false;
        $this$mapTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (KClass)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = CollectionsKt.plus((Collection)INSTANCE.getSuperClasses(it), it);
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$flatMapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (KClass)element$iv$iv;
            boolean bl = false;
            if (!(!Intrinsics.areEqual(it, Reflection.getOrCreateKotlinClass(Object.class)))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final List<EventListener<?>> updateActiveListeners(KClass<?> eventClass) {
        List list2;
        List $this$updateActiveListeners_u24lambda_u244 = list2 = CollectionsKt.createListBuilder();
        boolean bl = false;
        List<EventListenerWeakReference<?>> list3 = listeners.get(eventClass);
        if (list3 == null) {
            return CollectionsKt.emptyList();
        }
        List<EventListenerWeakReference<?>> listenersWeak = list3;
        ListIterator<EventListenerWeakReference<?>> iterator2 = listenersWeak.listIterator();
        while (iterator2.hasNext()) {
            EventListenerWeakReference<?> listener = iterator2.next();
            Function1 eventHandler = (Function1)listener.getEventHandler().get();
            if (eventHandler == null) {
                iterator2.remove();
                continue;
            }
            $this$updateActiveListeners_u24lambda_u244.add(new EventListener(eventHandler, (Function1)listener.getFilter().get()));
        }
        return CollectionsKt.build(list2);
    }

    private final <T extends Event> void receive(KClass<T> eventClass, Function1<? super T, Boolean> filter2, Function1<? super T, Unit> eventHandler) {
        if (listeners.get(eventClass) == null) {
            listeners.put(eventClass, new ArrayList());
        }
        List<EventListenerWeakReference<?>> list2 = listeners.get(eventClass);
        Intrinsics.checkNotNull(list2);
        list2.add(new EventListenerWeakReference<T>(eventHandler, filter2));
    }

    static /* synthetic */ void receive$default(EventBus eventBus, KClass kClass, Function1 function1, Function1 function12, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = null;
        }
        eventBus.receive(kClass, function1, function12);
    }

    private final void cleanUp(Map<KClass<?>, ? extends List<Object>> eventHandlers) {
        for (Map.Entry<KClass<?>, List<Object>> entry : eventHandlers.entrySet()) {
            List<EventListenerWeakReference<?>> registeredListeners;
            KClass<?> kClass = entry.getKey();
            List<Object> toRemove = entry.getValue();
            List<EventListenerWeakReference<?>> list2 = registeredListeners = listeners.get(kClass);
            if (list2 == null) continue;
            CollectionsKt.removeAll(list2, arg_0 -> EventBus.cleanUp$lambda$5(toRemove, arg_0));
        }
    }

    private static final boolean cleanUp$lambda$5(List $toRemove, EventListenerWeakReference it) {
        Intrinsics.checkNotNullParameter(it, "it");
        Function1 eventHandler = (Function1)it.getEventHandler().get();
        return eventHandler == null || $toRemove.contains(eventHandler);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003JJ\u0010\r\u001a\u00020\u000e\"\b\b\u0000\u0010\u000f*\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u00062\u0016\b\u0002\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u0002H\u000f\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u00132\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u0002H\u000f\u0012\u0004\u0012\u00020\u000e0\u0013J\u0006\u0010\u0016\u001a\u00020\u000eR'\u0010\u0004\u001a\u0018\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Lcom/unciv/logic/event/EventBus$EventReceiver;", "", "<init>", "()V", "eventHandlers", "", "Lkotlin/reflect/KClass;", "", "getEventHandlers", "()Ljava/util/Map;", "filters", "getFilters", "()Ljava/util/List;", "receive", "", "T", "Lcom/unciv/logic/event/Event;", "eventClass", "filter", "Lkotlin/Function1;", "", "eventHandler", "stopReceiving", "core"})
    public static final class EventReceiver {
        @NotNull
        private final Map<KClass<?>, List<Object>> eventHandlers = new LinkedHashMap();
        @NotNull
        private final List<Object> filters = new ArrayList();

        @NotNull
        public final Map<KClass<?>, List<Object>> getEventHandlers() {
            return this.eventHandlers;
        }

        @NotNull
        public final List<Object> getFilters() {
            return this.filters;
        }

        public final <T extends Event> void receive(@NotNull KClass<T> eventClass, @Nullable Function1<? super T, Boolean> filter2, @NotNull Function1<? super T, Unit> eventHandler) {
            Intrinsics.checkNotNullParameter(eventClass, "eventClass");
            Intrinsics.checkNotNullParameter(eventHandler, "eventHandler");
            if (filter2 != null) {
                this.filters.add(filter2);
            }
            if (this.eventHandlers.get(eventClass) == null) {
                this.eventHandlers.put(eventClass, new ArrayList());
            }
            List<Object> list2 = this.eventHandlers.get(eventClass);
            Intrinsics.checkNotNull(list2);
            list2.add(eventHandler);
            INSTANCE.receive(eventClass, filter2, eventHandler);
        }

        public static /* synthetic */ void receive$default(EventReceiver eventReceiver, KClass kClass, Function1 function1, Function1 function12, int n, Object object) {
            if ((n & 2) != 0) {
                function1 = null;
            }
            eventReceiver.receive(kClass, function1, function12);
        }

        public final void stopReceiving() {
            INSTANCE.cleanUp(this.eventHandlers);
            this.eventHandlers.clear();
            this.filters.clear();
        }
    }
}

