/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.civilization.managers;

import com.badlogic.gdx.math.Vector2;
import com.unciv.Constants;
import com.unciv.logic.GameInfo;
import com.unciv.logic.IsPartOfGameInfoSerialization;
import com.unciv.logic.city.City;
import com.unciv.logic.civilization.AlertType;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.LocationAction;
import com.unciv.logic.civilization.MayaLongCountAction;
import com.unciv.logic.civilization.Notification;
import com.unciv.logic.civilization.PlayerType;
import com.unciv.logic.civilization.PolicyAction;
import com.unciv.logic.civilization.PopupAlert;
import com.unciv.logic.civilization.TechAction;
import com.unciv.logic.civilization.managers.ImprovementFunctions;
import com.unciv.logic.civilization.managers.PolicyManager;
import com.unciv.logic.map.MapSize;
import com.unciv.logic.map.tile.RoadStatus;
import com.unciv.models.ruleset.INonPerpetualConstruction;
import com.unciv.models.ruleset.Policy;
import com.unciv.models.ruleset.PolicyBranch;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.tech.Era;
import com.unciv.models.ruleset.tech.TechColumn;
import com.unciv.models.ruleset.tech.Technology;
import com.unciv.models.ruleset.tile.TileImprovement;
import com.unciv.models.ruleset.tile.TileResource;
import com.unciv.models.ruleset.unique.GameContext;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueMap;
import com.unciv.models.ruleset.unique.UniqueTriggerActivation;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.ruleset.unit.BaseUnit;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.components.extensions.FormattingExtensionsKt;
import com.unciv.utils.CollectionExtensionsKt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import yairm210.purity.annotations.Readonly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00be\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0010\u0007\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0015\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010a\u001a\u00020\u0000J\b\u0010b\u001a\u00020:H\u0007J\u0006\u0010c\u001a\u00020:J\u0010\u0010d\u001a\u00020.2\u0006\u0010e\u001a\u00020MH\u0002J\b\u0010f\u001a\u00020gH\u0003J\u000e\u0010h\u001a\u00020:2\u0006\u0010e\u001a\u00020MJ\n\u0010i\u001a\u0004\u0018\u00010\u0012H\u0007J\n\u0010j\u001a\u0004\u0018\u00010MH\u0007J\u0012\u0010k\u001a\u00020:2\b\u0010e\u001a\u0004\u0018\u00010MH\u0007J\u000e\u0010l\u001a\u00020:2\u0006\u0010e\u001a\u00020MJ\u000e\u0010m\u001a\u00020M2\u0006\u0010e\u001a\u00020MJ\u0010\u0010n\u001a\u00020\u001f2\u0006\u0010e\u001a\u00020MH\u0007J\u0010\u0010n\u001a\u00020\u001f2\u0006\u0010o\u001a\u00020pH\u0007J\u0010\u0010q\u001a\u00020\u001f2\u0006\u0010r\u001a\u00020sH\u0007J\u0010\u0010t\u001a\u00020\u001f2\u0006\u0010u\u001a\u00020vH\u0007J\u0010\u0010w\u001a\u00020\u001f2\u0006\u0010x\u001a\u00020\u0012H\u0007J\u0010\u0010y\u001a\u00020\u001f2\u0006\u0010e\u001a\u00020MH\u0007J\b\u00106\u001a\u00020\u001fH\u0007J\u0014\u0010z\u001a\b\u0012\u0004\u0012\u00020\u00120{2\u0006\u0010|\u001a\u00020\u0012J\b\u0010}\u001a\u00020:H\u0007J\u0011\u0010~\u001a\u00020\u007f2\u0007\u0010\u0080\u0001\u001a\u00020:H\u0002J\u0011\u0010\u0081\u0001\u001a\u00020:2\u0006\u0010V\u001a\u00020:H\u0003J\b\u0010H\u001a\u00020:H\u0003J\u0010\u0010\u0082\u0001\u001a\u00020\u007f2\u0007\u0010\u0083\u0001\u001a\u00020:J\u0010\u0010\u0084\u0001\u001a\u00020\u007f2\u0007\u0010\u0085\u0001\u001a\u00020:J\u0007\u0010\u0086\u0001\u001a\u00020\u007fJ\u000f\u0010\u0087\u0001\u001a\u00020\u007f2\u0006\u0010e\u001a\u00020MJ\u001a\u0010\u0088\u0001\u001a\u00020\u007f2\u0006\u0010e\u001a\u00020M2\t\b\u0002\u0010\u0089\u0001\u001a\u00020\u001fJp\u0010\u008a\u0001\u001a\u0011\u0012\u0005\u0012\u0003H\u008c\u0001\u0012\u0005\u0012\u0003H\u008d\u00010\u008b\u0001\"\u0005\b\u0000\u0010\u008e\u0001\"\u0005\b\u0001\u0010\u008c\u0001\"\u0005\b\u0002\u0010\u008d\u0001*\n\u0012\u0005\u0012\u0003H\u008e\u00010\u008f\u00012\u0018\b\u0001\u0010\u0090\u0001\u001a\u0011\u0012\u0005\u0012\u0003H\u008e\u0001\u0012\u0005\u0012\u0003H\u008c\u00010\u0091\u00012\u001a\b\u0001\u0010\u0092\u0001\u001a\u0013\u0012\u0005\u0012\u0003H\u008e\u0001\u0012\u0007\u0012\u0005\u0018\u0001H\u008d\u00010\u0091\u0001H\u0083\bJ\u0011\u0010\u0093\u0001\u001a\u00020\u007f2\u0006\u0010e\u001a\u00020MH\u0002J\u0014\u0010\u0094\u0001\u001a\u00020\u007f2\t\b\u0002\u0010\u0089\u0001\u001a\u00020\u001fH\u0002J\t\u0010\u0095\u0001\u001a\u00020\u007fH\u0002J\u0011\u0010\u0096\u0001\u001a\u00020\u007f2\u0006\u0010x\u001a\u00020\u0012H\u0002J\u000f\u0010\u0097\u0001\u001a\u00020\u007f2\u0006\u0010\n\u001a\u00020\u000bJ\t\u0010\u0098\u0001\u001a\u00020\u007fH\u0002J\n\u0010\u0099\u0001\u001a\u00030\u009a\u0001H\u0007J\t\u0010\u009b\u0001\u001a\u00020\u001fH\u0007R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR*\u0010\u0010\u001a\u0012\u0012\u0004\u0012\u00020\u00120\u0011j\b\u0012\u0004\u0012\u00020\u0012`\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\u0019X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\u00020\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u001a\u0010$\u001a\u00020\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010!\"\u0004\b&\u0010#R\u001a\u0010'\u001a\u00020\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010!\"\u0004\b)\u0010#R\u001a\u0010*\u001a\u00020\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010!\"\u0004\b,\u0010#R\u001a\u0010-\u001a\u00020.X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u00100\"\u0004\b1\u00102R\u001a\u00103\u001a\u00020\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u0010!\"\u0004\b5\u0010#R\u001a\u00106\u001a\u00020\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u0010!\"\u0004\b8\u0010#R\u001a\u00109\u001a\u00020:X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b;\u0010<\"\u0004\b=\u0010>R\u001a\u0010?\u001a\u00020:X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b@\u0010<\"\u0004\bA\u0010>R\u001a\u0010B\u001a\u00020CX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bD\u0010E\"\u0004\bF\u0010GR\u001a\u0010H\u001a\u00020:X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bI\u0010<\"\u0004\bJ\u0010>R*\u0010K\u001a\u0012\u0012\u0004\u0012\u00020M0Lj\b\u0012\u0004\u0012\u00020M`NX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bO\u0010P\"\u0004\bQ\u0010RR*\u0010S\u001a\u0012\u0012\u0004\u0012\u00020M0\u0011j\b\u0012\u0004\u0012\u00020M`\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bT\u0010\u0015\"\u0004\bU\u0010\u0017R\u000e\u0010V\u001a\u00020:X\u0082\u000e\u00a2\u0006\u0002\n\u0000R6\u0010W\u001a\u001e\u0012\u0004\u0012\u00020M\u0012\u0004\u0012\u00020:0Xj\u000e\u0012\u0004\u0012\u00020M\u0012\u0004\u0012\u00020:`YX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bZ\u0010[\"\u0004\b\\\u0010]R\u001a\u0010^\u001a\u00020.X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b_\u00100\"\u0004\b`\u00102\u00a8\u0006\u009c\u0001"}, d2={"Lcom/unciv/logic/civilization/managers/TechManager;", "Lcom/unciv/logic/IsPartOfGameInfoSerialization;", "<init>", "()V", "era", "Lcom/unciv/models/ruleset/tech/Era;", "getEra", "()Lcom/unciv/models/ruleset/tech/Era;", "setEra", "(Lcom/unciv/models/ruleset/tech/Era;)V", "civInfo", "Lcom/unciv/logic/civilization/Civilization;", "getCivInfo", "()Lcom/unciv/logic/civilization/Civilization;", "setCivInfo", "(Lcom/unciv/logic/civilization/Civilization;)V", "researchedTechnologies", "Ljava/util/ArrayList;", "Lcom/unciv/models/ruleset/tech/Technology;", "Lkotlin/collections/ArrayList;", "getResearchedTechnologies", "()Ljava/util/ArrayList;", "setResearchedTechnologies", "(Ljava/util/ArrayList;)V", "techUniques", "Lcom/unciv/models/ruleset/unique/UniqueMap;", "getTechUniques$core", "()Lcom/unciv/models/ruleset/unique/UniqueMap;", "setTechUniques$core", "(Lcom/unciv/models/ruleset/unique/UniqueMap;)V", "unitsCanEmbark", "", "getUnitsCanEmbark", "()Z", "setUnitsCanEmbark", "(Z)V", "embarkedUnitsCanEnterOcean", "getEmbarkedUnitsCanEnterOcean", "setEmbarkedUnitsCanEnterOcean", "allUnitsCanEnterOcean", "getAllUnitsCanEnterOcean", "setAllUnitsCanEnterOcean", "specificUnitsCanEnterOcean", "getSpecificUnitsCanEnterOcean", "setSpecificUnitsCanEnterOcean", "movementSpeedOnRoads", "", "getMovementSpeedOnRoads", "()F", "setMovementSpeedOnRoads", "(F)V", "roadsConnectAcrossRivers", "getRoadsConnectAcrossRivers", "setRoadsConnectAcrossRivers", "allTechsAreResearched", "getAllTechsAreResearched", "setAllTechsAreResearched", "freeTechs", "", "getFreeTechs", "()I", "setFreeTechs", "(I)V", "repeatingTechsResearched", "getRepeatingTechsResearched", "setRepeatingTechsResearched", "scienceOfLast8Turns", "", "getScienceOfLast8Turns", "()[I", "setScienceOfLast8Turns", "([I)V", "scienceFromResearchAgreements", "getScienceFromResearchAgreements", "setScienceFromResearchAgreements", "techsResearched", "Ljava/util/HashSet;", "", "Lkotlin/collections/HashSet;", "getTechsResearched", "()Ljava/util/HashSet;", "setTechsResearched", "(Ljava/util/HashSet;)V", "techsToResearch", "getTechsToResearch", "setTechsToResearch", "overflowScience", "techsInProgress", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "getTechsInProgress", "()Ljava/util/HashMap;", "setTechsInProgress", "(Ljava/util/HashMap;)V", "goldPercentConvertedToScience", "getGoldPercentConvertedToScience", "setGoldPercentConvertedToScience", "clone", "getNumberOfTechsResearched", "getOverflowScience", "getScienceModifier", "techName", "getRuleset", "Lcom/unciv/models/ruleset/Ruleset;", "costOfTech", "currentTechnology", "currentTechnologyName", "researchOfTech", "remainingScienceToTech", "turnsToTech", "isResearched", "construction", "Lcom/unciv/models/ruleset/INonPerpetualConstruction;", "isRevealed", "resource", "Lcom/unciv/models/ruleset/tile/TileResource;", "isObsolete", "unit", "Lcom/unciv/models/ruleset/unit/BaseUnit;", "isUnresearchable", "tech", "canBeResearched", "getRequiredTechsToDestination", "", "destinationTech", "getScienceFromGreatScientist", "addCurrentScienceToScienceOfLast8Turns", "", "science", "limitOverflowScience", "endTurn", "scienceForNewTurn", "addScience", "scienceGet", "updateResearchProgress", "getFreeTechnology", "addTechnology", "showNotification", "associateByNotNull", "", "K", "V", "T", "", "keySelector", "Lkotlin/Function1;", "valueTransform", "obsoleteOldUnits", "moveToNewEra", "updateEra", "addTechToTransients", "setTransients", "updateTransientBooleans", "getBestRoadAvailable", "Lcom/unciv/logic/map/tile/RoadStatus;", "canResearchTech", "core"})
@SourceDebugExtension(value={"SMAP\nTechManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TechManager.kt\ncom/unciv/logic/civilization/managers/TechManager\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,565:1\n363#1,6:590\n1276#2,3:566\n1232#2,2:577\n1255#2,2:579\n1255#2,2:581\n1463#2,14:616\n1923#2,14:630\n1255#2,2:650\n1255#2,2:652\n1255#2,2:654\n1788#3,4:569\n1788#3,4:573\n1740#3,3:583\n1056#3:586\n774#3:587\n865#3,2:588\n1285#3,2:596\n1299#3,4:598\n774#3:602\n865#3,2:603\n774#3:605\n865#3,2:606\n1056#3:608\n1563#3:609\n1634#3,3:610\n1761#3,3:613\n1563#3:644\n1634#3,3:645\n1869#3,2:648\n1740#3,3:656\n1761#3,3:659\n*S KotlinDebug\n*F\n+ 1 TechManager.kt\ncom/unciv/logic/civilization/managers/TechManager\n*L\n380#1:590,6\n105#1:566,3\n160#1:577,2\n169#1:579,2\n173#1:581,2\n500#1:616,14\n508#1:630,14\n536#1:650,2\n538#1:652,2\n539#1:654,2\n107#1:569,4\n121#1:573,4\n186#1:583,3\n214#1:586\n331#1:587\n331#1:588,2\n385#1:596,2\n385#1:598,4\n448#1:602\n448#1:603,2\n462#1:605\n462#1:606,2\n463#1:608\n474#1:609\n474#1:610,3\n477#1:613,3\n527#1:644\n527#1:645,3\n528#1:648,2\n545#1:656,3\n563#1:659,3\n*E\n"})
public final class TechManager
implements IsPartOfGameInfoSerialization {
    @NotNull
    private transient Era era = new Era();
    public transient Civilization civInfo;
    @NotNull
    private transient ArrayList<Technology> researchedTechnologies = new ArrayList();
    @NotNull
    private transient UniqueMap techUniques = new UniqueMap();
    private transient boolean unitsCanEmbark;
    private transient boolean embarkedUnitsCanEnterOcean;
    private transient boolean allUnitsCanEnterOcean;
    private transient boolean specificUnitsCanEnterOcean;
    private transient float movementSpeedOnRoads = 1.0f;
    private transient boolean roadsConnectAcrossRivers;
    private transient boolean allTechsAreResearched;
    private int freeTechs;
    private int repeatingTechsResearched;
    @NotNull
    private int[] scienceOfLast8Turns;
    private int scienceFromResearchAgreements;
    @NotNull
    private HashSet<String> techsResearched;
    @NotNull
    private ArrayList<String> techsToResearch;
    private int overflowScience;
    @NotNull
    private HashMap<String, Integer> techsInProgress;
    private float goldPercentConvertedToScience;

    public TechManager() {
        int n = 0;
        int[] nArray = new int[8];
        TechManager techManager = this;
        while (n < 8) {
            int n2 = n++;
            nArray[n2] = 0;
        }
        techManager.scienceOfLast8Turns = nArray;
        this.techsResearched = new HashSet();
        this.techsToResearch = new ArrayList();
        this.techsInProgress = new HashMap();
        this.goldPercentConvertedToScience = 0.6f;
    }

    @NotNull
    public final Era getEra() {
        return this.era;
    }

    public final void setEra(@NotNull Era era) {
        Intrinsics.checkNotNullParameter(era, "<set-?>");
        this.era = era;
    }

    @NotNull
    public final Civilization getCivInfo() {
        Civilization civilization = this.civInfo;
        if (civilization != null) {
            return civilization;
        }
        Intrinsics.throwUninitializedPropertyAccessException("civInfo");
        return null;
    }

    public final void setCivInfo(@NotNull Civilization civilization) {
        Intrinsics.checkNotNullParameter(civilization, "<set-?>");
        this.civInfo = civilization;
    }

    @NotNull
    public final ArrayList<Technology> getResearchedTechnologies() {
        return this.researchedTechnologies;
    }

    public final void setResearchedTechnologies(@NotNull ArrayList<Technology> arrayList) {
        Intrinsics.checkNotNullParameter(arrayList, "<set-?>");
        this.researchedTechnologies = arrayList;
    }

    @NotNull
    public final UniqueMap getTechUniques$core() {
        return this.techUniques;
    }

    public final void setTechUniques$core(@NotNull UniqueMap uniqueMap2) {
        Intrinsics.checkNotNullParameter(uniqueMap2, "<set-?>");
        this.techUniques = uniqueMap2;
    }

    public final boolean getUnitsCanEmbark() {
        return this.unitsCanEmbark;
    }

    public final void setUnitsCanEmbark(boolean bl) {
        this.unitsCanEmbark = bl;
    }

    public final boolean getEmbarkedUnitsCanEnterOcean() {
        return this.embarkedUnitsCanEnterOcean;
    }

    public final void setEmbarkedUnitsCanEnterOcean(boolean bl) {
        this.embarkedUnitsCanEnterOcean = bl;
    }

    public final boolean getAllUnitsCanEnterOcean() {
        return this.allUnitsCanEnterOcean;
    }

    public final void setAllUnitsCanEnterOcean(boolean bl) {
        this.allUnitsCanEnterOcean = bl;
    }

    public final boolean getSpecificUnitsCanEnterOcean() {
        return this.specificUnitsCanEnterOcean;
    }

    public final void setSpecificUnitsCanEnterOcean(boolean bl) {
        this.specificUnitsCanEnterOcean = bl;
    }

    public final float getMovementSpeedOnRoads() {
        return this.movementSpeedOnRoads;
    }

    public final void setMovementSpeedOnRoads(float f) {
        this.movementSpeedOnRoads = f;
    }

    public final boolean getRoadsConnectAcrossRivers() {
        return this.roadsConnectAcrossRivers;
    }

    public final void setRoadsConnectAcrossRivers(boolean bl) {
        this.roadsConnectAcrossRivers = bl;
    }

    public final boolean getAllTechsAreResearched() {
        return this.allTechsAreResearched;
    }

    public final void setAllTechsAreResearched(boolean bl) {
        this.allTechsAreResearched = bl;
    }

    public final int getFreeTechs() {
        return this.freeTechs;
    }

    public final void setFreeTechs(int n) {
        this.freeTechs = n;
    }

    public final int getRepeatingTechsResearched() {
        return this.repeatingTechsResearched;
    }

    public final void setRepeatingTechsResearched(int n) {
        this.repeatingTechsResearched = n;
    }

    @NotNull
    public final int[] getScienceOfLast8Turns() {
        return this.scienceOfLast8Turns;
    }

    public final void setScienceOfLast8Turns(@NotNull int[] nArray) {
        Intrinsics.checkNotNullParameter(nArray, "<set-?>");
        this.scienceOfLast8Turns = nArray;
    }

    public final int getScienceFromResearchAgreements() {
        return this.scienceFromResearchAgreements;
    }

    public final void setScienceFromResearchAgreements(int n) {
        this.scienceFromResearchAgreements = n;
    }

    @NotNull
    public final HashSet<String> getTechsResearched() {
        return this.techsResearched;
    }

    public final void setTechsResearched(@NotNull HashSet<String> hashSet) {
        Intrinsics.checkNotNullParameter(hashSet, "<set-?>");
        this.techsResearched = hashSet;
    }

    @NotNull
    public final ArrayList<String> getTechsToResearch() {
        return this.techsToResearch;
    }

    public final void setTechsToResearch(@NotNull ArrayList<String> arrayList) {
        Intrinsics.checkNotNullParameter(arrayList, "<set-?>");
        this.techsToResearch = arrayList;
    }

    @NotNull
    public final HashMap<String, Integer> getTechsInProgress() {
        return this.techsInProgress;
    }

    public final void setTechsInProgress(@NotNull HashMap<String, Integer> hashMap) {
        Intrinsics.checkNotNullParameter(hashMap, "<set-?>");
        this.techsInProgress = hashMap;
    }

    public final float getGoldPercentConvertedToScience() {
        return this.goldPercentConvertedToScience;
    }

    public final void setGoldPercentConvertedToScience(float f) {
        this.goldPercentConvertedToScience = f;
    }

    @NotNull
    public final TechManager clone() {
        TechManager toReturn = new TechManager();
        toReturn.techsResearched.addAll((Collection<String>)this.techsResearched);
        toReturn.freeTechs = this.freeTechs;
        toReturn.repeatingTechsResearched = this.repeatingTechsResearched;
        toReturn.techsInProgress.putAll((Map<String, Integer>)this.techsInProgress);
        toReturn.techsToResearch.addAll((Collection<String>)this.techsToResearch);
        toReturn.scienceOfLast8Turns = (int[])this.scienceOfLast8Turns.clone();
        toReturn.scienceFromResearchAgreements = this.scienceFromResearchAgreements;
        toReturn.overflowScience = this.overflowScience;
        toReturn.goldPercentConvertedToScience = this.goldPercentConvertedToScience;
        return toReturn;
    }

    @Readonly
    public final int getNumberOfTechsResearched() {
        return this.techsResearched.size();
    }

    public final int getOverflowScience() {
        return this.overflowScience;
    }

    /*
     * WARNING - void declaration
     */
    private final float getScienceModifier(String techName) {
        int n;
        void $this$count$iv;
        Sequence<Civilization> $this$count$iv2 = this.getCivInfo().getKnownCivs();
        boolean $i$f$count22 = false;
        int count$iv = 0;
        Iterator<Civilization> iterator2 = $this$count$iv2.iterator();
        while (iterator2.hasNext()) {
            Civilization element$iv;
            Civilization it = element$iv = iterator2.next();
            boolean bl = false;
            if (!(it.isMajorCiv() && it.getTech().isResearched(techName)) || ++count$iv >= 0) continue;
            CollectionsKt.throwCountOverflow();
        }
        int numberOfCivsResearchedThisTech = count$iv;
        Iterable $i$f$count22 = this.getCivInfo().getGameInfo().getCivilizations();
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv2 = 0;
            for (Object element$iv : $this$count$iv) {
                Civilization it = (Civilization)element$iv;
                boolean bl = false;
                if (!(it.isMajorCiv() && !it.isDefeated()) || ++count$iv2 >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv2;
        }
        int numberOfCivsRemaining = n;
        return 1.0f + (float)numberOfCivsResearchedThisTech / (float)numberOfCivsRemaining * 0.3f;
    }

    @Readonly
    private final Ruleset getRuleset() {
        return this.getCivInfo().getGameInfo().getRuleset();
    }

    public final int costOfTech(@NotNull String techName) {
        int n;
        Intrinsics.checkNotNullParameter(techName, "techName");
        Technology technology = this.getRuleset().getTechnologies().get(techName);
        Intrinsics.checkNotNull(technology);
        float techCost = technology.getCost();
        if (this.getCivInfo().isHuman()) {
            techCost *= this.getCivInfo().getDifficulty().getResearchCostModifier();
        }
        techCost *= this.getCivInfo().getGameInfo().getSpeed().getScienceCostModifier();
        techCost /= this.getScienceModifier(techName);
        MapSize.Predefined mapSizePredef = this.getCivInfo().getGameInfo().getTileMap().getMapParameters().getMapSize().getPredefinedOrNextSmaller();
        techCost *= mapSizePredef.getTechCostMultiplier();
        Iterable $this$count$iv = this.getCivInfo().getCities();
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                City it = (City)element$iv;
                boolean bl = false;
                if (!(!it.isPuppet()) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        float cityModifier = (float)(n - 1) * mapSizePredef.getTechCostPerCityModifier();
        Iterator iterator2 = Civilization.getMatchingUniques$default(this.getCivInfo(), UniqueType.LessTechCostFromCities, null, 2, null).iterator();
        while (iterator2.hasNext()) {
            Unique unique = (Unique)iterator2.next();
            cityModifier *= 1.0f - Float.parseFloat(unique.getParams().get(0)) / (float)100;
        }
        iterator2 = Civilization.getMatchingUniques$default(this.getCivInfo(), UniqueType.LessTechCost, null, 2, null).iterator();
        while (iterator2.hasNext()) {
            Unique unique = (Unique)iterator2.next();
            techCost *= FormattingExtensionsKt.toPercent(unique.getParams().get(0));
        }
        return (int)(techCost *= 1.0f + cityModifier);
    }

    @Readonly
    @Nullable
    public final Technology currentTechnology() {
        String string = this.currentTechnologyName();
        if (string == null) {
            return null;
        }
        String currentTechnologyName = string;
        return this.getRuleset().getTechnologies().get(currentTechnologyName);
    }

    @Readonly
    @Nullable
    public final String currentTechnologyName() {
        return this.techsToResearch.isEmpty() ? null : this.techsToResearch.get(0);
    }

    @Readonly
    public final int researchOfTech(@Nullable String techName) {
        Integer n = (Integer)((Map)this.techsInProgress).get(techName);
        return n != null ? n : 0;
    }

    public final int remainingScienceToTech(@NotNull String techName) {
        Intrinsics.checkNotNullParameter(techName, "techName");
        int spareScience = this.canBeResearched(techName) ? this.getOverflowScience() : 0;
        return this.costOfTech(techName) - this.researchOfTech(techName) - spareScience;
    }

    @NotNull
    public final String turnsToTech(@NotNull String techName) {
        Intrinsics.checkNotNullParameter(techName, "techName");
        double remainingCost = this.remainingScienceToTech(techName);
        return remainingCost <= 0.0 ? TranslationsKt.tr(0) : (this.getCivInfo().getStats().getStatsForNextTurn().getScience() <= 0.0f ? "\u221e" : TranslationsKt.tr(Math.max(1, (int)Math.ceil(remainingCost / (double)this.getCivInfo().getStats().getStatsForNextTurn().getScience()))));
    }

    @Readonly
    public final boolean isResearched(@NotNull String techName) {
        Intrinsics.checkNotNullParameter(techName, "techName");
        return this.techsResearched.contains(techName);
    }

    @Readonly
    public final boolean isResearched(@NotNull INonPerpetualConstruction construction) {
        boolean bl;
        block1: {
            Intrinsics.checkNotNullParameter(construction, "construction");
            Sequence<String> $this$all$iv = construction.requiredTechs();
            boolean $i$f$all = false;
            Iterator<String> iterator2 = $this$all$iv.iterator();
            while (iterator2.hasNext()) {
                String element$iv;
                String requiredTech = element$iv = iterator2.next();
                boolean bl2 = false;
                if (this.isResearched(requiredTech)) continue;
                bl = false;
                break block1;
            }
            bl = true;
        }
        return bl;
    }

    @Readonly
    public final boolean isRevealed(@NotNull TileResource resource) {
        Intrinsics.checkNotNullParameter(resource, "resource");
        String string = resource.getRevealedBy();
        if (string == null) {
            return true;
        }
        String revealedBy = string;
        return this.isResearched(revealedBy);
    }

    @Readonly
    public final boolean isObsolete(@NotNull BaseUnit unit) {
        boolean bl;
        block1: {
            Intrinsics.checkNotNullParameter(unit, "unit");
            Sequence<String> $this$any$iv = unit.techsThatObsoleteThis();
            boolean $i$f$any = false;
            Iterator<String> iterator2 = $this$any$iv.iterator();
            while (iterator2.hasNext()) {
                String element$iv;
                String obsoleteTech = element$iv = iterator2.next();
                boolean bl2 = false;
                if (!this.isResearched(obsoleteTech)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    @Readonly
    public final boolean isUnresearchable(@NotNull Technology tech) {
        boolean bl;
        block2: {
            Intrinsics.checkNotNullParameter(tech, "tech");
            Sequence<Unique> $this$any$iv = tech.getMatchingUniques(UniqueType.OnlyAvailable, GameContext.Companion.getIgnoreConditionals());
            boolean $i$f$any = false;
            Iterator<Unique> iterator2 = $this$any$iv.iterator();
            while (iterator2.hasNext()) {
                Unique element$iv;
                Unique it = element$iv = iterator2.next();
                boolean bl2 = false;
                if (!(!it.conditionalsApply(this.getCivInfo().getState()))) continue;
                bl = true;
                break block2;
            }
            bl = false;
        }
        if (bl) {
            return true;
        }
        return tech.hasUnique(UniqueType.Unavailable, this.getCivInfo().getState());
    }

    @Readonly
    public final boolean canBeResearched(@NotNull String techName) {
        boolean bl;
        block5: {
            Intrinsics.checkNotNullParameter(techName, "techName");
            Technology technology = this.getRuleset().getTechnologies().get(techName);
            Intrinsics.checkNotNull(technology);
            Technology tech = technology;
            if (this.isUnresearchable(tech)) {
                return false;
            }
            if (this.isResearched(tech.getName()) && !tech.isContinuallyResearchable()) {
                return false;
            }
            Iterable $this$all$iv = tech.getPrerequisites();
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (this.isResearched(it)) continue;
                    bl = false;
                    break block5;
                }
                bl = true;
            }
        }
        return bl;
    }

    @Readonly
    public final boolean allTechsAreResearched() {
        return this.allTechsAreResearched;
    }

    @NotNull
    public final List<Technology> getRequiredTechsToDestination(@NotNull Technology destinationTech) {
        Intrinsics.checkNotNullParameter(destinationTech, "destinationTech");
        List prerequisites = new ArrayList();
        ArrayDeque<Technology> checkPrerequisites = new ArrayDeque<Technology>();
        if (this.isUnresearchable(destinationTech)) {
            return CollectionsKt.emptyList();
        }
        checkPrerequisites.add(destinationTech);
        while (!checkPrerequisites.isEmpty()) {
            Iterator<String> iterator2;
            Technology techToCheck = (Technology)checkPrerequisites.removeFirst();
            if (this.isUnresearchable(techToCheck)) {
                return CollectionsKt.emptyList();
            }
            if (!techToCheck.isContinuallyResearchable() && (this.isResearched(techToCheck.getName()) || prerequisites.contains(techToCheck))) continue;
            Intrinsics.checkNotNullExpressionValue(techToCheck.getPrerequisites().iterator(), "iterator(...)");
            while (iterator2.hasNext()) {
                String prerequisite;
                Intrinsics.checkNotNullExpressionValue(iterator2.next(), "next(...)");
                Technology technology = this.getRuleset().getTechnologies().get(prerequisite);
                Intrinsics.checkNotNull(technology);
                checkPrerequisites.add(technology);
            }
            prerequisites.add(techToCheck);
        }
        Iterable $this$sortedBy$iv = prerequisites;
        boolean $i$f$sortedBy = false;
        return CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

            public final int compare(T a, T b) {
                Technology it = (Technology)a;
                boolean bl = false;
                TechColumn techColumn = it.getColumn();
                Intrinsics.checkNotNull(techColumn);
                it = (Technology)b;
                Comparable comparable = Integer.valueOf(techColumn.getColumnNumber());
                bl = false;
                TechColumn techColumn2 = it.getColumn();
                Intrinsics.checkNotNull(techColumn2);
                return ComparisonsKt.compareValues(comparable, techColumn2.getColumnNumber());
            }
        });
    }

    @Readonly
    public final int getScienceFromGreatScientist() {
        return (int)((float)ArraysKt.sum(this.scienceOfLast8Turns) * this.getCivInfo().getGameInfo().getSpeed().getScienceCostModifier());
    }

    private final void addCurrentScienceToScienceOfLast8Turns(int science) {
        this.scienceOfLast8Turns[this.getCivInfo().getGameInfo().getTurns() % 8] = science;
    }

    @Readonly
    private final int limitOverflowScience(int overflowScience) {
        int n = (int)this.getCivInfo().getStats().getStatsForNextTurn().getScience() * 5;
        Object v = ((Map)this.getRuleset().getTechnologies()).get(this.currentTechnologyName());
        Intrinsics.checkNotNull(v);
        return Math.min(overflowScience, Math.max(n, ((Technology)v).getCost()));
    }

    @Readonly
    private final int scienceFromResearchAgreements() {
        float researchAgreementModifier = 0.5f;
        Iterator iterator2 = Civilization.getMatchingUniques$default(this.getCivInfo(), UniqueType.ScienceFromResearchAgreements, null, 2, null).iterator();
        while (iterator2.hasNext()) {
            Unique unique = (Unique)iterator2.next();
            researchAgreementModifier += Float.parseFloat(unique.getParams().get(0)) / 200.0f;
        }
        return (int)((float)(this.scienceFromResearchAgreements / 3) * researchAgreementModifier);
    }

    public final void endTurn(int scienceForNewTurn) {
        this.addCurrentScienceToScienceOfLast8Turns(scienceForNewTurn);
        if (this.currentTechnologyName() == null) {
            return;
        }
        int finalScienceToAdd = scienceForNewTurn;
        if (this.scienceFromResearchAgreements != 0) {
            int scienceBoost = this.scienceFromResearchAgreements();
            finalScienceToAdd += scienceBoost;
            this.scienceFromResearchAgreements = 0;
            String[] stringArray = new String[]{"StatIcons/Science"};
            this.getCivInfo().addNotification("We gained [" + scienceBoost + "] Science from Research Agreement", Notification.NotificationCategory.General, stringArray);
        }
        if (this.overflowScience != 0) {
            finalScienceToAdd += this.getOverflowScience();
            this.overflowScience = 0;
        }
        this.addScience(finalScienceToAdd);
    }

    public final void addScience(int scienceGet) {
        String string = this.currentTechnologyName();
        if (string == null) {
            return;
        }
        String currentTechnology = string;
        ((Map)this.techsInProgress).put(currentTechnology, this.researchOfTech(currentTechnology) + scienceGet);
        Integer n = this.techsInProgress.get(currentTechnology);
        Intrinsics.checkNotNull(n);
        if (((Number)n).intValue() < this.costOfTech(currentTechnology)) {
            return;
        }
        Integer n2 = this.techsInProgress.get(currentTechnology);
        Intrinsics.checkNotNull(n2);
        int extraScienceLeftOver = ((Number)n2).intValue() - this.costOfTech(currentTechnology);
        this.overflowScience += this.limitOverflowScience(extraScienceLeftOver);
        TechManager.addTechnology$default(this, currentTechnology, false, 2, null);
    }

    public final void updateResearchProgress() {
        String string = this.currentTechnologyName();
        if (string == null) {
            return;
        }
        String currentTechnology = string;
        int realOverflow = this.getOverflowScience();
        int scienceSpent = this.researchOfTech(currentTechnology) + realOverflow;
        if (scienceSpent >= this.costOfTech(currentTechnology)) {
            this.overflowScience = 0;
            this.addScience(realOverflow);
        }
    }

    public final void getFreeTechnology(@NotNull String techName) {
        Intrinsics.checkNotNullParameter(techName, "techName");
        int n = this.freeTechs;
        this.freeTechs = n + -1;
        TechManager.addTechnology$default(this, techName, false, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void addTechnology(@NotNull String techName, boolean showNotification) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(techName, "techName");
        boolean isNewTech = this.techsResearched.add(techName);
        Technology technology = this.getRuleset().getTechnologies().get(techName);
        Intrinsics.checkNotNull(technology);
        Technology newTech = technology;
        if (!newTech.isContinuallyResearchable()) {
            this.techsToResearch.remove(techName);
        } else {
            int n = this.repeatingTechsResearched;
            this.repeatingTechsResearched = n + 1;
        }
        this.techsInProgress.remove(techName);
        this.researchedTechnologies = CollectionExtensionsKt.withItem(this.researchedTechnologies, newTech);
        this.addTechToTransients(newTech);
        this.moveToNewEra(showNotification);
        if (!this.getCivInfo().isSpectator() && showNotification) {
            String[] stringArray = new String[]{"StatIcons/Science"};
            this.getCivInfo().addNotification("Research of [" + techName + "] has completed!", new TechAction(techName), Notification.NotificationCategory.General, stringArray);
        }
        if (isNewTech) {
            this.getCivInfo().getPopupAlerts().add(new PopupAlert(AlertType.TechResearched, techName));
        }
        String triggerNotificationText = "due to researching [" + techName + ']';
        for (Unique unique : newTech.getUniqueObjects()) {
            if (!unique.isTriggerable() || unique.hasTriggerConditional() || !unique.conditionalsApply(this.getCivInfo().getState())) continue;
            UniqueTriggerActivation.triggerUnique$default(UniqueTriggerActivation.INSTANCE, unique, this.getCivInfo(), null, null, null, null, triggerNotificationText, 60, null);
        }
        for (Unique unique : Civilization.getTriggeredUniques$default(this.getCivInfo(), UniqueType.TriggerUponResearch, null, arg_0 -> TechManager.addTechnology$lambda$8(newTech, this, arg_0), 2, null)) {
            UniqueTriggerActivation.triggerUnique$default(UniqueTriggerActivation.INSTANCE, unique, this.getCivInfo(), null, null, null, null, triggerNotificationText, 60, null);
        }
        Collection<TileResource> collection = this.getRuleset().getTileResources().values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        String[] $this$filter$iv = (String[])collection;
        boolean $i$f$filter = false;
        String[] stringArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            TileResource it = (TileResource)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual(techName, it.getRevealedBy())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List revealedResources = (List)destination$iv$iv;
        if (this.getCivInfo().getPlayerType() == PlayerType.Human) {
            for (Object e : revealedResources) {
                Intrinsics.checkNotNullExpressionValue(e, "next(...)");
                TileResource revealedResource = (TileResource)e;
                GameInfo.notifyExploredResources$default(this.getCivInfo().getGameInfo(), this.getCivInfo(), revealedResource.getName(), 5, null, 8, null);
            }
        }
        this.updateTransientBooleans();
        this.getCivInfo().getCache().updateCivResources();
        for (City city : this.getCivInfo().getCities()) {
            city.reassignPopulationDeferred();
        }
        this.obsoleteOldUnits(techName);
        Iterator<Object> iterator2 = Civilization.getMatchingUniques$default(this.getCivInfo(), UniqueType.MayanGainGreatPerson, null, 2, null).iterator();
        while (iterator2.hasNext()) {
            Unique unique = (Unique)iterator2.next();
            if (!Intrinsics.areEqual(unique.getParams().get(1), techName)) continue;
            stringArray = new String[]{"MayaCalendar/Maya"};
            this.getCivInfo().addNotification("You have unlocked [The Long Count]!", new MayaLongCountAction(), Notification.NotificationCategory.General, stringArray);
        }
        this.updateResearchProgress();
    }

    public static /* synthetic */ void addTechnology$default(TechManager techManager, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        techManager.addTechnology(string, bl);
    }

    @Readonly
    private final <T, K, V> Map<K, V> associateByNotNull(Iterable<? extends T> $this$associateByNotNull, @Readonly Function1<? super T, ? extends K> keySelector, @Readonly Function1<? super T, ? extends V> valueTransform) {
        boolean $i$f$associateByNotNull = false;
        LinkedHashMap destination = new LinkedHashMap();
        for (T element : $this$associateByNotNull) {
            V value;
            if (valueTransform.invoke(element) == null) continue;
            ((Map)destination).put(keySelector.invoke(element), value);
        }
        return destination;
    }

    /*
     * WARNING - void declaration
     */
    private final void obsoleteOldUnits(String techName) {
        Map map2;
        void $this$associateByNotNull$iv;
        TechManager techManager = this;
        Set<Map.Entry<String, BaseUnit>> set = this.getRuleset().getUnits().entrySet();
        Intrinsics.checkNotNullExpressionValue(set, "<get-entries>(...)");
        Iterator iterator2 = set;
        boolean $i$f$associateByNotNull = false;
        LinkedHashMap destination$iv = new LinkedHashMap();
        for (Object element$iv : $this$associateByNotNull$iv) {
            Object value$iv;
            void it;
            Map.Entry it2 = (Map.Entry)element$iv;
            boolean $i$a$-associateByNotNull-TechManager$obsoleteOldUnits$obsoleteUnits$32 = false;
            Object v = it2.getValue();
            Intrinsics.checkNotNullExpressionValue(v, "<get-value>(...)");
            if (TechManager.obsoleteOldUnits$getEquivalentUpgradeOrNull((BaseUnit)v, this, techName) == null) continue;
            Map.Entry $i$a$-associateByNotNull-TechManager$obsoleteOldUnits$obsoleteUnits$32 = (Map.Entry)element$iv;
            map2 = destination$iv;
            boolean bl = false;
            map2.put((String)it.getKey(), value$iv);
        }
        Map obsoleteUnits = destination$iv;
        if (obsoleteUnits.isEmpty()) {
            return;
        }
        Iterable $this$associateWith$iv = obsoleteUnits.keySet();
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateWith$iv, 10)), 16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            String bl = (String)element$iv$iv;
            Object e = element$iv$iv;
            map2 = result$iv;
            boolean bl2 = false;
            Set set2 = new LinkedHashSet();
            map2.put(e, set2);
        }
        Map unitUpgrades = result$iv;
        for (City city : this.getCivInfo().getCities()) {
            city.getCityConstructions().setConstructionQueue(SequencesKt.toMutableList(SequencesKt.mapNotNull(CollectionsKt.asSequence((Iterable)city.getCityConstructions().getConstructionQueue()), arg_0 -> TechManager.obsoleteOldUnits$lambda$13(city, unitUpgrades, obsoleteUnits, arg_0))));
        }
        for (Map.Entry entry : unitUpgrades.entrySet()) {
            String[] stringArray;
            String[] stringArray2;
            String text;
            String unit = (String)entry.getKey();
            Set cities = (Set)entry.getValue();
            if (cities.isEmpty()) continue;
            for (City city : cities) {
                city.getCityConstructions().validateInProgressConstructions();
            }
            Sequence<LocationAction> locationAction = LocationAction.Companion.invoke(SequencesKt.map(CollectionsKt.asSequence(cities), TechManager::obsoleteOldUnits$lambda$14));
            String cityText = cities.size() == 1 ? '[' + ((City)CollectionsKt.first(cities)).getName() + ']' : "" + '[' + cities.size() + "] cities";
            BaseUnit baseUnit = (BaseUnit)obsoleteUnits.get(unit);
            String newUnit = baseUnit != null ? baseUnit.getName() : null;
            String string = text = newUnit == null ? '[' + unit + "] has become obsolete and was removed from the queue in " + cityText + '!' : cityText + " changed production from [" + unit + "] to [" + newUnit + ']';
            if (newUnit == null) {
                stringArray2 = new String[]{"StatIcons/Production"};
                stringArray = stringArray2;
            } else {
                stringArray2 = new String[]{unit, "StatIcons/Production", newUnit};
                stringArray = stringArray2;
            }
            String[] icons = stringArray;
            this.getCivInfo().addNotification(text, locationAction, Notification.NotificationCategory.Production, Arrays.copyOf(icons, icons.length));
        }
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private final void moveToNewEra(boolean showNotification) {
        block19: {
            previousEra = this.getCivInfo().getEra();
            this.updateEra();
            currentEra = this.getCivInfo().getEra();
            if (Intrinsics.areEqual(previousEra, currentEra)) {
                return;
            }
            if (!showNotification) break block19;
            if (!this.getCivInfo().isSpectator()) {
                var4_4 = new String[]{"StatIcons/Science"};
                this.getCivInfo().addNotification("You have entered the [" + currentEra + "]!", Notification.NotificationCategory.General, (String[])var4_4);
            }
            if (this.getCivInfo().isMajorCiv()) {
                var4_4 = this.getCivInfo().getKnownCivsWithSpectators().iterator();
                while (var4_4.hasNext()) {
                    knownCiv = var4_4.next();
                    var6_6 = new String[]{this.getCivInfo().getCivName(), "StatIcons/Science"};
                    knownCiv.addNotification('[' + this.getCivInfo().getCivName() + "] has entered the [" + currentEra + "]!", Notification.NotificationCategory.General, var6_6);
                }
            }
            v0 = this.getRuleset().getPolicyBranches().values();
            Intrinsics.checkNotNullExpressionValue(v0, "<get-values>(...)");
            $this$filter$iv = v0;
            $i$f$filter = false;
            var7_12 = $this$filter$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterTo = false;
            var10_19 = $this$filterTo$iv$iv.iterator();
            while (var10_19.hasNext()) {
                element$iv$iv = var10_19.next();
                it = (PolicyBranch)element$iv$iv;
                $i$a$-filter-TechManager$moveToNewEra$1 = false;
                if (!Intrinsics.areEqual(it.getEra(), currentEra.getName())) ** GOTO lbl-1000
                v1 = this.getCivInfo().getPolicies();
                Intrinsics.checkNotNull(it);
                if (PolicyManager.isAdoptable$default(v1, (Policy)it, false, 2, null)) {
                    v2 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v2 = false;
                }
                if (!v2) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            for (Object policyBranch : (List)destination$iv$iv) {
                if (this.getCivInfo().isSpectator()) continue;
                $i$f$filter = new String[]{"StatIcons/Culture"};
                this.getCivInfo().addNotification('[' + policyBranch.getName() + "] policy branch unlocked!", new PolicyAction(policyBranch.getName()), Notification.NotificationCategory.General, $i$f$filter);
            }
        }
        v3 = this.getRuleset().getEras().values();
        Intrinsics.checkNotNullExpressionValue(v3, "<get-values>(...)");
        policyBranch = v3;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        var10_19 = $this$filterTo$iv$iv.iterator();
        while (var10_19.hasNext()) {
            element$iv$iv = var10_19.next();
            it = (Era)element$iv$iv;
            $i$a$-filter-TechManager$moveToNewEra$erasPassed$1 = false;
            if (!(it.getEraNumber() > previousEra.getEraNumber() && it.getEraNumber() <= currentEra.getEraNumber())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$sortedBy = false;
        erasPassed = CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

            public final int compare(T a, T b) {
                Era it = (Era)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getEraNumber());
                it = (Era)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, it.getEraNumber());
            }
        });
        for (T v4 : erasPassed) {
            Intrinsics.checkNotNullExpressionValue(v4, "next(...)");
            era = (Era)v4;
            for (Object unique : era.getUniqueObjects()) {
                if (unique.hasTriggerConditional() || !unique.conditionalsApply(this.getCivInfo().getState())) continue;
                UniqueTriggerActivation.triggerUnique$default(UniqueTriggerActivation.INSTANCE, (Unique)unique, this.getCivInfo(), null, null, null, null, "due to entering the [" + era.getName() + ']', 60, null);
            }
        }
        $this$map$iv = erasPassed;
        $i$f$map = false;
        unique = $this$map$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        $i$f$mapTo = false;
        for (E item$iv$iv : $this$mapTo$iv$iv) {
            $i$a$-filter-TechManager$moveToNewEra$erasPassed$1 = (Era)item$iv$iv;
            var16_30 = destination$iv$iv;
            $i$a$-map-TechManager$moveToNewEra$eraNames$1 = false;
            var16_30.add(it.getName());
        }
        eraNames = CollectionsKt.toHashSet((List)destination$iv$iv);
        for (Unique unique : Civilization.getTriggeredUniques$default(this.getCivInfo(), UniqueType.TriggerUponEnteringEra, null, null, 6, null)) {
            Intrinsics.checkNotNullExpressionValue(eraNames.iterator(), "iterator(...)");
            while (var8_16.hasNext()) {
                block18: {
                    v5 = var8_16.next();
                    Intrinsics.checkNotNullExpressionValue(v5, "next(...)");
                    eraName = (String)v5;
                    $this$any$iv = unique.getModifiers(UniqueType.TriggerUponEnteringEra);
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        v6 = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            it = (Unique)element$iv;
                            $i$a$-any-TechManager$moveToNewEra$2 = false;
                            if (!Intrinsics.areEqual(it.getParams().get(0), eraName)) continue;
                            v6 = true;
                            break block18;
                        }
                        v6 = false;
                    }
                }
                if (!v6) continue;
                UniqueTriggerActivation.triggerUnique$default(UniqueTriggerActivation.INSTANCE, unique, this.getCivInfo(), null, null, null, null, "due to entering the [" + eraName + ']', 60, null);
            }
        }
        for (Unique unique : Civilization.getTriggeredUniques$default(this.getCivInfo(), UniqueType.TriggerUponEnteringEraUnfiltered, null, null, 6, null)) {
            UniqueTriggerActivation.triggerUnique$default(UniqueTriggerActivation.INSTANCE, unique, this.getCivInfo(), null, null, null, null, "due to entering the [" + currentEra.getName() + ']', 60, null);
        }
    }

    static /* synthetic */ void moveToNewEra$default(TechManager techManager, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        techManager.moveToNewEra(bl);
    }

    /*
     * WARNING - void declaration
     */
    private final void updateEra() {
        String minEraOfNonResearchedTechs;
        Object v3;
        void $this$minByOrNull$iv;
        Object maxElem$iv;
        Object object;
        Ruleset ruleset = this.getCivInfo().getGameInfo().getRuleset();
        if (ruleset.getTechnologies().isEmpty() || this.researchedTechnologies.isEmpty()) {
            return;
        }
        Sequence<TechColumn> $this$maxByOrNull$iv = SequencesKt.map(CollectionsKt.asSequence((Iterable)this.researchedTechnologies), TechManager::updateEra$lambda$20);
        boolean $i$f$maxByOrNull = false;
        Iterator<TechColumn> iterator$iv = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            object = null;
        } else {
            maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                object = maxElem$iv;
            } else {
                TechColumn it = maxElem$iv;
                boolean bl = false;
                int maxValue$iv = it.getColumnNumber();
                do {
                    TechColumn e$iv;
                    TechColumn it2 = e$iv = iterator$iv.next();
                    $i$a$-maxByOrNull-TechManager$updateEra$maxEraOfResearchedTechs$2 = false;
                    int v$iv = it2.getColumnNumber();
                    if (maxValue$iv >= v$iv) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                object = maxElem$iv;
            }
        }
        Intrinsics.checkNotNull(object);
        String maxEraOfResearchedTechs = ((TechColumn)object).getEra();
        Era era = ruleset.getEras().get(maxEraOfResearchedTechs);
        Intrinsics.checkNotNull(era);
        Era maxEra = era;
        Collection<Technology> collection = ruleset.getTechnologies().values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        maxElem$iv = SequencesKt.map(SequencesKt.filter(CollectionsKt.asSequence((Iterable)collection), arg_0 -> TechManager.updateEra$lambda$22(this, arg_0)), TechManager::updateEra$lambda$23);
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv2 = $this$minByOrNull$iv.iterator();
        if (!iterator$iv2.hasNext()) {
            v3 = null;
        } else {
            Object minElem$iv = iterator$iv2.next();
            if (!iterator$iv2.hasNext()) {
                v3 = minElem$iv;
            } else {
                TechColumn it = (TechColumn)minElem$iv;
                boolean bl = false;
                int minValue$iv = it.getColumnNumber();
                do {
                    Object e$iv = iterator$iv2.next();
                    TechColumn it3 = (TechColumn)e$iv;
                    $i$a$-minByOrNull-TechManager$updateEra$minEraOfNonResearchedTechs$3 = false;
                    int v$iv = it3.getColumnNumber();
                    if (minValue$iv <= v$iv) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv2.hasNext());
                v3 = minElem$iv;
            }
        }
        iterator$iv = v3;
        String string = minEraOfNonResearchedTechs = iterator$iv != null ? ((TechColumn)((Object)iterator$iv)).getEra() : null;
        if (minEraOfNonResearchedTechs == null) {
            this.era = maxEra;
            return;
        }
        Era era2 = ruleset.getEras().get(minEraOfNonResearchedTechs);
        Intrinsics.checkNotNull(era2);
        Era minEra = era2;
        this.era = minEra.getEraNumber() <= maxEra.getEraNumber() ? maxEra : minEra;
    }

    private final void addTechToTransients(Technology tech) {
        this.techUniques.addUniques((Iterable<Unique>)tech.getUniqueObjects());
    }

    /*
     * WARNING - void declaration
     */
    public final void setTransients(@NotNull Civilization civInfo) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(civInfo, "civInfo");
        this.setCivInfo(civInfo);
        Iterable iterable = this.techsResearched;
        ArrayList<Technology> arrayList = this.researchedTechnologies;
        boolean $i$f$map = false;
        Iterator iterator2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Technology technology = this.getRuleset().getTechnologies().get(it);
            Intrinsics.checkNotNull(technology);
            collection.add(technology);
        }
        arrayList.addAll((List)destination$iv$iv);
        Iterable $this$forEach$iv = this.researchedTechnologies;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Technology it = (Technology)element$iv;
            boolean bl = false;
            this.addTechToTransients(it);
        }
        this.updateEra();
        this.updateTransientBooleans();
    }

    /*
     * Unable to fully structure code
     */
    private final void updateTransientBooleans() {
        block11: {
            block10: {
                block9: {
                    block8: {
                        this.unitsCanEmbark = Civilization.hasUnique$default(this.getCivInfo(), UniqueType.LandUnitEmbarkation, null, 2, null);
                        var2_2 = enterOceanUniques = Civilization.getMatchingUniques$default(this.getCivInfo(), UniqueType.UnitsMayEnterOcean, null, 2, null);
                        var8_3 = this;
                        $i$f$any = false;
                        var4_5 = $this$any$iv.iterator();
                        while (var4_5.hasNext()) {
                            element$iv = var4_5.next();
                            it = (Unique)element$iv;
                            $i$a$-any-TechManager$updateTransientBooleans$1 = false;
                            if (!Constants.INSTANCE.getAll().contains(it.getParams().get(0))) continue;
                            v0 = true;
                            break block8;
                        }
                        v0 = false;
                    }
                    var8_3.allUnitsCanEnterOcean = var9_9 = v0;
                    v1 = this;
                    if (this.allUnitsCanEnterOcean) ** GOTO lbl-1000
                    $this$any$iv = enterOceanUniques;
                    var8_3 = v1;
                    $i$f$any = false;
                    var4_5 = $this$any$iv.iterator();
                    while (var4_5.hasNext()) {
                        element$iv = var4_5.next();
                        it = (Unique)element$iv;
                        $i$a$-any-TechManager$updateTransientBooleans$2 = false;
                        if (!Intrinsics.areEqual(it.getParams().get(0), "Embarked")) continue;
                        v2 = true;
                        break block9;
                    }
                    v2 = false;
                }
                var9_9 = v2;
                v1 = var8_3;
                if (var9_9) lbl-1000:
                // 2 sources

                {
                    v3 = true;
                } else {
                    v3 = false;
                }
                v1.embarkedUnitsCanEnterOcean = v3;
                $this$any$iv = enterOceanUniques;
                var8_3 = this;
                $i$f$any = false;
                var4_5 = $this$any$iv.iterator();
                while (var4_5.hasNext()) {
                    element$iv = var4_5.next();
                    it = (Unique)element$iv;
                    $i$a$-any-TechManager$updateTransientBooleans$3 = false;
                    if (!(Constants.INSTANCE.getAll().contains(it.getParams().get(0)) == false && Intrinsics.areEqual(it.getParams().get(0), "Embarked") == false)) continue;
                    v4 = true;
                    break block10;
                }
                v4 = false;
            }
            var8_3.specificUnitsCanEnterOcean = var9_9 = v4;
            this.movementSpeedOnRoads = Civilization.hasUnique$default(this.getCivInfo(), UniqueType.RoadMovementSpeed, null, 2, null) != false ? RoadStatus.Road.getMovementImproved() : RoadStatus.Road.getMovement();
            this.roadsConnectAcrossRivers = Civilization.hasUnique$default(this.getCivInfo(), UniqueType.RoadsConnectAcrossRivers, null, 2, null);
            v5 = this.getCivInfo().getGameInfo().getRuleset().getTechnologies().values();
            Intrinsics.checkNotNullExpressionValue(v5, "<get-values>(...)");
            $this$any$iv = v5;
            var8_3 = this;
            $i$f$all = false;
            if (((Collection)$this$all$iv).isEmpty()) {
                v6 = true;
            } else {
                for (T element$iv : $this$all$iv) {
                    it = (Technology)element$iv;
                    $i$a$-all-TechManager$updateTransientBooleans$4 = false;
                    if (this.isResearched(it.getName()) != false || this.canBeResearched(it.getName()) == false) continue;
                    v6 = false;
                    break block11;
                }
                v6 = true;
            }
        }
        var8_3.allTechsAreResearched = var9_9 = v6;
    }

    @Readonly
    @NotNull
    public final RoadStatus getBestRoadAvailable() {
        block10: {
            TileImprovement roadImprovement;
            block11: {
                block8: {
                    TileImprovement railroadImprovement;
                    block9: {
                        railroadImprovement = this.getRuleset().getRailroadImprovement();
                        if (railroadImprovement == null) break block8;
                        if (railroadImprovement.getTechRequired() == null) break block9;
                        String string = railroadImprovement.getTechRequired();
                        Intrinsics.checkNotNull(string);
                        if (!this.isResearched(string)) break block8;
                    }
                    if (SequencesKt.none(ImprovementFunctions.getImprovementBuildingProblems$default(ImprovementFunctions.INSTANCE, railroadImprovement, this.getCivInfo().getState(), null, 4, null))) {
                        return RoadStatus.Railroad;
                    }
                }
                if ((roadImprovement = this.getRuleset().getRoadImprovement()) == null) break block10;
                if (roadImprovement.getTechRequired() == null) break block11;
                String string = roadImprovement.getTechRequired();
                Intrinsics.checkNotNull(string);
                if (!this.isResearched(string)) break block10;
            }
            if (SequencesKt.none(ImprovementFunctions.getImprovementBuildingProblems$default(ImprovementFunctions.INSTANCE, roadImprovement, this.getCivInfo().getState(), null, 4, null))) {
                return RoadStatus.Road;
            }
        }
        return RoadStatus.None;
    }

    @Readonly
    public final boolean canResearchTech() {
        boolean bl;
        block3: {
            Collection<Technology> collection = this.getRuleset().getTechnologies().values();
            Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
            Iterable $this$any$iv = collection;
            boolean $i$f$any = false;
            if (((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Technology it = (Technology)element$iv;
                    boolean bl2 = false;
                    if (!this.canBeResearched(it.getName())) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final boolean addTechnology$lambda$8(Technology $newTech, TechManager this$0, Unique it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return Technology.matchesFilter$default($newTech, it.getParams().get(0), this$0.getCivInfo().getState(), false, 4, null);
    }

    @Readonly
    private static final BaseUnit obsoleteOldUnits$getEquivalentUpgradeOrNull(BaseUnit $this$obsoleteOldUnits_u24getEquivalentUpgradeOrNull, TechManager this$0, String techName) {
        String string = $this$obsoleteOldUnits_u24getEquivalentUpgradeOrNull.automaticallyUpgradedInProductionToUnitByTech(techName);
        if (string == null) {
            return null;
        }
        String unitUpgradesTo = string;
        return this$0.getCivInfo().getEquivalentUnit(unitUpgradesTo);
    }

    private static final String obsoleteOldUnits$transformConstruction(Map<String, ? extends Set<City>> unitUpgrades, Map<String, BaseUnit> obsoleteUnits, String old, City city) {
        Set<City> set = unitUpgrades.get(old);
        if (set == null) {
            return old;
        }
        Set<City> entry = set;
        entry.add(city);
        BaseUnit baseUnit = obsoleteUnits.get(old);
        return baseUnit != null ? baseUnit.getName() : null;
    }

    private static final String obsoleteOldUnits$lambda$13(City $city, Map $unitUpgrades, Map $obsoleteUnits, String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return TechManager.obsoleteOldUnits$transformConstruction($unitUpgrades, $obsoleteUnits, it, $city);
    }

    private static final Vector2 obsoleteOldUnits$lambda$14(City it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getLocation();
    }

    private static final TechColumn updateEra$lambda$20(Technology it) {
        Intrinsics.checkNotNullParameter(it, "it");
        TechColumn techColumn = it.getColumn();
        Intrinsics.checkNotNull(techColumn);
        return techColumn;
    }

    private static final boolean updateEra$lambda$22(TechManager this$0, Technology it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return !this$0.researchedTechnologies.contains(it);
    }

    private static final TechColumn updateEra$lambda$23(Technology it) {
        Intrinsics.checkNotNullParameter(it, "it");
        TechColumn techColumn = it.getColumn();
        Intrinsics.checkNotNull(techColumn);
        return techColumn;
    }
}

