/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.app.desktop;

import com.badlogic.gdx.files.FileHandle;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J\b\u0010\u0006\u001a\u00020\u0005H\u0002J\b\u0010\u0007\u001a\u00020\u0005H\u0002\u00a8\u0006\b"}, d2={"Lcom/unciv/app/desktop/SystemUtils;", "", "<init>", "()V", "getSystemInfo", "", "getWinVer", "getLinuxDistro", "desktop"})
@SourceDebugExtension(value={"SMAP\nSystemUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SystemUtils.kt\ncom/unciv/app/desktop/SystemUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,101:1\n1617#2,9:102\n1869#2:111\n1870#2:113\n1626#2:114\n1563#2:115\n1634#2,3:116\n774#2:119\n865#2,2:120\n1193#2,2:122\n1267#2,4:124\n1563#2:129\n1634#2,3:130\n774#2:133\n865#2,2:134\n1193#2,2:136\n1267#2,4:138\n1#3:112\n1#3:128\n*S KotlinDebug\n*F\n+ 1 SystemUtils.kt\ncom/unciv/app/desktop/SystemUtils\n*L\n66#1:102,9\n66#1:111\n66#1:113\n66#1:114\n72#1:115\n72#1:116,3\n73#1:119\n73#1:120,2\n74#1:122,2\n74#1:124,4\n92#1:129\n92#1:130,3\n93#1:133\n93#1:134,2\n94#1:136,2\n94#1:138,4\n66#1:112\n*E\n"})
public final class SystemUtils {
    @NotNull
    public static final SystemUtils INSTANCE = new SystemUtils();

    private SystemUtils() {
    }

    @NotNull
    public final String getSystemInfo() {
        long l;
        String javaVendor;
        String[] stringArray;
        String osInfo;
        StringBuilder builder = new StringBuilder();
        String string = System.getProperty("os.name");
        if (string == null) {
            string = "Unknown";
        }
        String osName = string;
        boolean isWindows = StringsKt.startsWith(osName, "Windows", true);
        builder.append("OS: " + osName);
        if (!isWindows && ((CharSequence)(osInfo = CollectionsKt.joinToString$default(CollectionsKt.listOfNotNull(stringArray = new String[]{System.getProperty("os.arch"), System.getProperty("os.version")}), null, null, null, 0, null, null, 63, null))).length() > 0) {
            builder.append(" (" + osInfo + ')');
        }
        builder.append('\n');
        String osRelease = isWindows ? this.getWinVer() : this.getLinuxDistro();
        if (((CharSequence)osRelease).length() > 0) {
            builder.append('\t' + osRelease).append('\n');
        }
        if ((javaVendor = System.getProperty("java.vendor")) != null) {
            String string2 = System.getProperty("java.vendor.version");
            if (string2 == null && (string2 = System.getProperty("java.vm.version")) == null) {
                string2 = "";
            }
            String javaVersion = string2;
            builder.append("Java: " + javaVendor + ' ' + javaVersion).append('\n');
        }
        try {
            l = Runtime.getRuntime().maxMemory() / (long)1024 / (long)1024;
        }
        catch (Throwable throwable) {
            l = -1L;
        }
        long maxMemory = l;
        if (maxMemory > 0L) {
            builder.append('\t');
            builder.append("Max Memory: " + maxMemory + " MB").append('\n');
        }
        builder.append("System default encoding: " + Charset.defaultCharset().name()).append('\n');
        String string3 = builder.toString();
        Intrinsics.checkNotNullExpressionValue(string3, "toString(...)");
        return string3;
    }

    /*
     * WARNING - void declaration
     */
    private final String getWinVer() {
        String string;
        StringBuilder stringBuilder;
        block17: {
            block16: {
                void $this$getWinVer_u24lambda_u246;
                String $this$getWinVer_u24lambda_u245;
                String string2;
                StringBuilder stringBuilder2;
                Map entries2;
                Object object;
                block15: {
                    block14: {
                        Map map2;
                        String $this$associate$iv;
                        String[] stringArray = new String[]{"cmd", "/c", "reg query \"HKLM\\SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion\" /v ProductName && reg query \"HKLM\\SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion\" /v ReleaseId && reg query \"HKLM\\SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion\" /v CurrentBuild && reg query \"HKLM\\SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion\" /v DisplayVersion"};
                        String[] winVerCommand = stringArray;
                        try {
                            void $this$associateTo$iv$iv;
                            void $this$filterTo$iv$iv;
                            Iterable $this$filter$iv;
                            List it;
                            void $this$mapTo$iv$iv;
                            Object element$iv$iv;
                            Iterable $this$mapNotNullTo$iv$iv;
                            Process process2 = Runtime.getRuntime().exec(winVerCommand);
                            process2.waitFor();
                            byte[] byArray = process2.getInputStream().readAllBytes();
                            Intrinsics.checkNotNullExpressionValue(byArray, "readAllBytes(...)");
                            byte[] byArray2 = byArray;
                            Charset charset = Charset.defaultCharset();
                            Intrinsics.checkNotNullExpressionValue(charset, "defaultCharset(...)");
                            Object object2 = charset;
                            String output2 = new String(byArray2, (Charset)object2);
                            object2 = new char[1];
                            object2[0] = 10;
                            Iterable $this$mapNotNull$iv = StringsKt.split$default((CharSequence)output2, (char[])object2, false, 0, 6, null);
                            boolean $i$f$mapNotNull = false;
                            Iterable iterable = $this$mapNotNull$iv;
                            Object destination$iv$iv = new ArrayList();
                            boolean $i$f$mapNotNullTo = false;
                            Iterator $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                            boolean $i$f$forEach = false;
                            Object object3 = $this$forEach$iv$iv$iv.iterator();
                            while (object3.hasNext()) {
                                String it$iv$iv;
                                Object element$iv$iv$iv;
                                element$iv$iv = element$iv$iv$iv = object3.next();
                                boolean bl = false;
                                String it2 = (String)element$iv$iv;
                                boolean bl2 = false;
                                String $this$getWinVer_u24lambda_u241_u24lambda_u240 = StringsKt.removeSuffix(it2, (CharSequence)"\r");
                                boolean bl3 = false;
                                if ((StringsKt.startsWith$default($this$getWinVer_u24lambda_u241_u24lambda_u240, "    ", false, 2, null) || StringsKt.startsWith$default($this$getWinVer_u24lambda_u241_u24lambda_u240, "\t", false, 2, null) ? ((Object)StringsKt.trim((CharSequence)$this$getWinVer_u24lambda_u241_u24lambda_u240)).toString() : null) == null) continue;
                                it$iv$iv = it$iv$iv;
                                boolean bl4 = false;
                                destination$iv$iv.add(it$iv$iv);
                            }
                            List goodLines = (List)destination$iv$iv;
                            Iterable $this$map$iv = goodLines;
                            boolean $i$f$map = false;
                            $this$mapNotNullTo$iv$iv = $this$map$iv;
                            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                            boolean $i$f$mapTo = false;
                            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                                object3 = (String)item$iv$iv;
                                object = destination$iv$iv;
                                boolean bl = false;
                                element$iv$iv = new String[]{"REG_SZ"};
                                object.add(StringsKt.split$default((CharSequence)((Object)it), element$iv$iv, false, 0, 6, null));
                            }
                            $this$map$iv = (List)destination$iv$iv;
                            boolean $i$f$filter = false;
                            $this$mapTo$iv$iv = $this$filter$iv;
                            destination$iv$iv = new ArrayList();
                            boolean $i$f$filterTo = false;
                            for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
                                it = (List)element$iv$iv2;
                                boolean bl = false;
                                if (!(it.size() == 2)) continue;
                                destination$iv$iv.add(element$iv$iv2);
                            }
                            $this$filter$iv = (List)destination$iv$iv;
                            boolean $i$f$associate = false;
                            int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associate$iv, 10)), 16);
                            destination$iv$iv = $this$associate$iv;
                            Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
                            boolean $i$f$associateTo = false;
                            for (Object element$iv$iv3 : $this$associateTo$iv$iv) {
                                Map map3 = destination$iv$iv2;
                                List it3 = (List)element$iv$iv3;
                                boolean bl = false;
                                Pair<String, String> pair = TuplesKt.to(((Object)StringsKt.trim((CharSequence)((String)it3.get(0)))).toString(), ((Object)StringsKt.trim((CharSequence)((String)it3.get(1)))).toString());
                                map3.put(pair.getFirst(), pair.getSecond());
                            }
                            map2 = destination$iv$iv2;
                        }
                        catch (Throwable throwable) {
                            map2 = MapsKt.emptyMap();
                        }
                        entries2 = map2;
                        if (!entries2.containsKey("ProductName")) {
                            return "";
                        }
                        StringBuilder stringBuilder3 = new StringBuilder();
                        Object v = entries2.get("ProductName");
                        Intrinsics.checkNotNull(v);
                        stringBuilder2 = stringBuilder3.append((String)v);
                        String string3 = (String)entries2.get("DisplayVersion");
                        if (string3 == null) {
                            string3 = string2 = (String)entries2.get("ReleaseId");
                        }
                        if (string3 == null) break block14;
                        $this$associate$iv = string2;
                        object = stringBuilder2;
                        boolean bl = false;
                        String string4 = " Version " + $this$getWinVer_u24lambda_u245;
                        stringBuilder2 = object;
                        string2 = string4;
                        if (string4 != null) break block15;
                    }
                    string2 = "";
                }
                stringBuilder = stringBuilder2.append(string2);
                string = (String)entries2.get("CurrentBuild");
                if (string == null) break block16;
                $this$getWinVer_u24lambda_u245 = string;
                object = stringBuilder;
                boolean bl = false;
                String string5 = " (Build " + (String)$this$getWinVer_u24lambda_u246 + ')';
                stringBuilder = object;
                string = string5;
                if (string5 != null) break block17;
            }
            string = "";
        }
        return stringBuilder.append(string).toString();
    }

    /*
     * WARNING - void declaration
     */
    private final String getLinuxDistro() {
        Object object;
        try {
            void $this$associateTo$iv$iv;
            void $this$filterTo$iv$iv;
            List it;
            Object object2;
            Iterable $this$mapTo$iv$iv;
            String string = new FileHandle("/etc/os-release").readString();
            Intrinsics.checkNotNullExpressionValue(string, "readString(...)");
            object = new char[1];
            object[0] = 10;
            Iterable $this$map$iv = StringsKt.split$default((CharSequence)string, (char[])object, false, 0, 6, null);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                String string2 = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                object2 = new char[]{'='};
                collection.add(StringsKt.split$default((CharSequence)((Object)it), object2, false, 0, 6, null));
            }
            Iterable $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            $this$mapTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (List)element$iv$iv;
                boolean bl = false;
                if (!(it.size() == 2)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$associate$iv = (List)destination$iv$iv;
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associate$iv, 10)), 16);
            destination$iv$iv = $this$associate$iv;
            Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map2 = destination$iv$iv2;
                List it2 = (List)element$iv$iv;
                boolean bl = false;
                object2 = TuplesKt.to(it2.get(0), StringsKt.removePrefix(StringsKt.removeSuffix((String)it2.get(1), (CharSequence)"\""), (CharSequence)"\""));
                map2.put(object2.getFirst(), object2.getSecond());
            }
            object = destination$iv$iv2;
        }
        catch (Throwable throwable) {
            object = MapsKt.emptyMap();
        }
        Map osRelease = object;
        if (!osRelease.containsKey("NAME")) {
            return "";
        }
        String string = (String)osRelease.get("PRETTY_NAME");
        if (string == null) {
            string = (String)osRelease.get("NAME") + ' ' + (String)osRelease.get("VERSION");
        }
        return string;
    }
}

