/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.app.desktop;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Graphics;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3Application;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3ApplicationConfiguration;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3Graphics;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3Window;
import com.unciv.models.metadata.GameSettings;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.utils.ScreenMode;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.lang.reflect.Field;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0081\u0002\u0018\u0000 \u00122\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002:\u0001\u0012B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH&J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\u0013"}, d2={"Lcom/unciv/app/desktop/DesktopScreenMode;", "Lcom/unciv/utils/ScreenMode;", "", "<init>", "(Ljava/lang/String;I)V", "Windowed", "Fullscreen", "Borderless", "getId", "", "toString", "", "activate", "", "settings", "Lcom/unciv/models/metadata/GameSettings;", "setWindowedMode", "", "Companion", "desktop"})
public abstract class DesktopScreenMode
extends Enum<DesktopScreenMode>
implements ScreenMode {
    @NotNull
    public static final Companion Companion;
    public static final /* enum */ DesktopScreenMode Windowed;
    public static final /* enum */ DesktopScreenMode Fullscreen;
    public static final /* enum */ DesktopScreenMode Borderless;
    private static final /* synthetic */ DesktopScreenMode[] $VALUES;
    private static final /* synthetic */ EnumEntries $ENTRIES;

    private DesktopScreenMode() {
    }

    @Override
    public int getId() {
        return this.ordinal();
    }

    @NotNull
    public String toString() {
        return TranslationsKt.tr$default(this.name(), false, false, 3, null);
    }

    public abstract void activate(@NotNull GameSettings var1);

    protected final boolean setWindowedMode(@NotNull GameSettings settings) {
        Intrinsics.checkNotNullParameter(settings, "settings");
        Rectangle maximumWindowBounds = com.unciv.app.desktop.DesktopScreenMode$Companion.getMaximumWindowBounds$desktop$default(Companion, null, 1, null);
        GameSettings.WindowState windowState = settings.getWindowState().coerceIn(maximumWindowBounds);
        int width = windowState.component1();
        int height = windowState.component2();
        Field $this$setWindowedMode_u24lambda_u240 = Lwjgl3Application.class.getDeclaredField("config");
        boolean bl = false;
        $this$setWindowedMode_u24lambda_u240.setAccessible(true);
        Object object = $this$setWindowedMode_u24lambda_u240.get(Gdx.app);
        Intrinsics.checkNotNull(object, "null cannot be cast to non-null type com.badlogic.gdx.backends.lwjgl3.Lwjgl3ApplicationConfiguration");
        ((Lwjgl3ApplicationConfiguration)object).setWindowedMode(width, height);
        Gdx.graphics.setWindowedMode(width, height);
        int widthDiff = maximumWindowBounds.width - width;
        int heightDiff = maximumWindowBounds.height - height;
        int tolerance = 30;
        return widthDiff <= tolerance && heightDiff <= tolerance;
    }

    public static DesktopScreenMode[] values() {
        return (DesktopScreenMode[])$VALUES.clone();
    }

    public static DesktopScreenMode valueOf(String value) {
        return Enum.valueOf(DesktopScreenMode.class, value);
    }

    @NotNull
    public static EnumEntries<DesktopScreenMode> getEntries() {
        return $ENTRIES;
    }

    @Override
    public boolean hasUserSelectableSize() {
        return ScreenMode.super.hasUserSelectableSize();
    }

    public /* synthetic */ DesktopScreenMode(String $enum$name, int $enum$ordinal, DefaultConstructorMarker $constructor_marker) {
        this();
    }

    static {
        Windowed = new Windowed("Windowed", 0);
        Fullscreen = new Fullscreen("Fullscreen", 1);
        Borderless = new Borderless("Borderless", 2);
        $VALUES = desktopScreenModeArray = new DesktopScreenMode[]{DesktopScreenMode.Windowed, DesktopScreenMode.Fullscreen, DesktopScreenMode.Borderless};
        $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        Companion = new Companion(null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001d\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"com/unciv/app/desktop/DesktopScreenMode.Borderless", "Lcom/unciv/app/desktop/DesktopScreenMode;", "activate", "", "settings", "Lcom/unciv/models/metadata/GameSettings;", "hasUserSelectableSize", "", "desktop"})
    static final class Borderless
    extends DesktopScreenMode {
        /*
         * WARNING - void declaration
         */
        Borderless() {
            void var1_1;
        }

        @Override
        public void activate(@NotNull GameSettings settings) {
            Intrinsics.checkNotNullParameter(settings, "settings");
            Lwjgl3Window lwjgl3Window = Companion.getWindow();
            if (lwjgl3Window != null) {
                lwjgl3Window.restoreWindow();
            }
            Gdx.graphics.setUndecorated(true);
            this.setWindowedMode(settings);
        }

        @Override
        public boolean hasUserSelectableSize() {
            return true;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0011\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0086\u0002J\n\u0010\b\u001a\u0004\u0018\u00010\tH\u0002J\u0017\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b\u000eJ \u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000bH\u0002\u00a8\u0006\u0014"}, d2={"Lcom/unciv/app/desktop/DesktopScreenMode$Companion;", "", "<init>", "()V", "get", "Lcom/unciv/app/desktop/DesktopScreenMode;", "id", "", "getWindow", "Lcom/badlogic/gdx/backends/lwjgl3/Lwjgl3Window;", "getMaximumWindowBounds", "Ljava/awt/Rectangle;", "monitor", "Lcom/badlogic/gdx/Graphics$Monitor;", "getMaximumWindowBounds$desktop", "device", "Ljava/awt/GraphicsDevice;", "config", "Ljava/awt/GraphicsConfiguration;", "bounds", "desktop"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DesktopScreenMode get(int id) {
            return (DesktopScreenMode)DesktopScreenMode.getEntries().get(id);
        }

        private final Lwjgl3Window getWindow() {
            Graphics graphics = Gdx.graphics;
            Lwjgl3Graphics lwjgl3Graphics = graphics instanceof Lwjgl3Graphics ? (Lwjgl3Graphics)graphics : null;
            return lwjgl3Graphics != null ? lwjgl3Graphics.getWindow() : null;
        }

        @NotNull
        public final Rectangle getMaximumWindowBounds$desktop(@NotNull Graphics.Monitor monitor) {
            Intrinsics.checkNotNullParameter(monitor, "monitor");
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            Iterator<GraphicsDevice> iterator2 = ArrayIteratorKt.iterator(graphicsEnvironment.getScreenDevices());
            while (iterator2.hasNext()) {
                GraphicsDevice device = iterator2.next();
                Iterator<GraphicsConfiguration> iterator3 = ArrayIteratorKt.iterator(device.getConfigurations());
                while (iterator3.hasNext()) {
                    GraphicsConfiguration config2 = iterator3.next();
                    Rectangle bounds = config2.getBounds();
                    if (bounds.x != monitor.virtualX || bounds.y != monitor.virtualY) continue;
                    Intrinsics.checkNotNull(device);
                    Intrinsics.checkNotNull(config2);
                    Intrinsics.checkNotNull(bounds);
                    return this.getMaximumWindowBounds(device, config2, bounds);
                }
            }
            Graphics.DisplayMode mode = Lwjgl3ApplicationConfiguration.getDisplayMode(monitor);
            return new Rectangle(monitor.virtualX, monitor.virtualY, mode.width, mode.height);
        }

        public static /* synthetic */ Rectangle getMaximumWindowBounds$desktop$default(Companion companion, Graphics.Monitor monitor, int n, Object object) {
            if ((n & 1) != 0) {
                Graphics.Monitor monitor2 = Lwjgl3ApplicationConfiguration.getPrimaryMonitor();
                Intrinsics.checkNotNullExpressionValue(monitor2, "getPrimaryMonitor(...)");
                monitor = monitor2;
            }
            return companion.getMaximumWindowBounds$desktop(monitor);
        }

        private final Rectangle getMaximumWindowBounds(GraphicsDevice device, GraphicsConfiguration config2, Rectangle bounds) {
            int displayWidth = device.getDisplayMode().getWidth();
            int displayHeight = device.getDisplayMode().getHeight();
            double scalePercent = (double)MathKt.roundToInt((double)displayWidth / (double)bounds.width * (double)100) * 0.01;
            Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(config2);
            int unscaledInsetLeft = MathKt.roundToInt((double)insets.left * scalePercent);
            int unscaledInsetRight = MathKt.roundToInt((double)insets.right * scalePercent);
            int unscaledInsetTop = MathKt.roundToInt((double)insets.top * scalePercent);
            int unscaledInsetBottom = MathKt.roundToInt((double)insets.bottom * scalePercent);
            return new Rectangle(bounds.x + unscaledInsetLeft, bounds.y + unscaledInsetTop, displayWidth - unscaledInsetLeft - unscaledInsetRight, displayHeight - unscaledInsetTop - unscaledInsetBottom);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001d\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"com/unciv/app/desktop/DesktopScreenMode.Fullscreen", "Lcom/unciv/app/desktop/DesktopScreenMode;", "activate", "", "settings", "Lcom/unciv/models/metadata/GameSettings;", "hasUserSelectableSize", "", "desktop"})
    static final class Fullscreen
    extends DesktopScreenMode {
        /*
         * WARNING - void declaration
         */
        Fullscreen() {
            void var1_1;
        }

        @Override
        public void activate(@NotNull GameSettings settings) {
            Intrinsics.checkNotNullParameter(settings, "settings");
            Gdx.graphics.setFullscreenMode(Gdx.graphics.getDisplayMode());
        }

        @Override
        public boolean hasUserSelectableSize() {
            return false;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001d\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"com/unciv/app/desktop/DesktopScreenMode.Windowed", "Lcom/unciv/app/desktop/DesktopScreenMode;", "activate", "", "settings", "Lcom/unciv/models/metadata/GameSettings;", "hasUserSelectableSize", "", "desktop"})
    static final class Windowed
    extends DesktopScreenMode {
        /*
         * WARNING - void declaration
         */
        Windowed() {
            void var1_1;
        }

        @Override
        public void activate(@NotNull GameSettings settings) {
            block1: {
                Intrinsics.checkNotNullParameter(settings, "settings");
                Gdx.graphics.setUndecorated(false);
                boolean isFillingDesktop = this.setWindowedMode(settings);
                if (!isFillingDesktop) break block1;
                Lwjgl3Window lwjgl3Window = Companion.getWindow();
                if (lwjgl3Window != null) {
                    lwjgl3Window.maximizeWindow();
                }
            }
        }

        @Override
        public boolean hasUserSelectableSize() {
            return true;
        }
    }
}

