/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.net;

import com.badlogic.gdx.Net;
import com.badlogic.gdx.net.HttpStatus;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.ObjectMap;
import com.badlogic.gdx.utils.StreamUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class NetJavaImpl {
    private final ThreadPoolExecutor executorService;
    final ObjectMap<Net.HttpRequest, HttpURLConnection> connections;
    final ObjectMap<Net.HttpRequest, Net.HttpResponseListener> listeners;
    final ObjectMap<Net.HttpRequest, Future<?>> tasks;

    public NetJavaImpl() {
        this(Integer.MAX_VALUE);
    }

    public NetJavaImpl(int maxThreads) {
        boolean isCachedPool = maxThreads == Integer.MAX_VALUE;
        this.executorService = new ThreadPoolExecutor(isCachedPool ? 0 : maxThreads, maxThreads, 60L, TimeUnit.SECONDS, (BlockingQueue<Runnable>)((BlockingQueue)((Object)(isCachedPool ? new SynchronousQueue() : new LinkedBlockingQueue()))), new ThreadFactory(){
            AtomicInteger threadID = new AtomicInteger();

            @Override
            public Thread newThread(Runnable r) {
                Thread thread2 = new Thread(r, "NetThread" + this.threadID.getAndIncrement());
                thread2.setDaemon(true);
                return thread2;
            }
        });
        this.executorService.allowCoreThreadTimeOut(!isCachedPool);
        this.connections = new ObjectMap();
        this.listeners = new ObjectMap();
        this.tasks = new ObjectMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendHttpRequest(final Net.HttpRequest httpRequest, final Net.HttpResponseListener httpResponseListener) {
        if (httpRequest.getUrl() == null) {
            httpResponseListener.failed(new GdxRuntimeException("can't process a HTTP request without URL set"));
            return;
        }
        try {
            URL url;
            boolean doingOutPut;
            String method = httpRequest.getMethod();
            boolean doInput = !method.equalsIgnoreCase("HEAD");
            boolean bl = doingOutPut = method.equalsIgnoreCase("POST") || method.equalsIgnoreCase("PUT") || method.equalsIgnoreCase("PATCH");
            if (method.equalsIgnoreCase("GET") || method.equalsIgnoreCase("HEAD")) {
                String queryString = "";
                String value = httpRequest.getContent();
                if (value != null && !"".equals(value)) {
                    queryString = "?" + value;
                }
                url = new URL(httpRequest.getUrl() + queryString);
            } else {
                url = new URL(httpRequest.getUrl());
            }
            final HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setDoOutput(doingOutPut);
            connection.setDoInput(doInput);
            connection.setRequestMethod(method);
            HttpURLConnection.setFollowRedirects(httpRequest.getFollowRedirects());
            this.putIntoConnectionsAndListeners(httpRequest, httpResponseListener, connection);
            for (Map.Entry<String, String> header : httpRequest.getHeaders().entrySet()) {
                connection.addRequestProperty(header.getKey(), header.getValue());
            }
            connection.setConnectTimeout(httpRequest.getTimeOut());
            connection.setReadTimeout(httpRequest.getTimeOut());
            this.tasks.put(httpRequest, this.executorService.submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        if (doingOutPut) {
                            String contentAsString = httpRequest.getContent();
                            if (contentAsString != null) {
                                OutputStreamWriter writer2 = new OutputStreamWriter(connection.getOutputStream(), "UTF8");
                                try {
                                    writer2.write(contentAsString);
                                }
                                finally {
                                    StreamUtils.closeQuietly(writer2);
                                }
                            }
                            InputStream contentAsStream = httpRequest.getContentStream();
                            if (contentAsStream != null) {
                                OutputStream os = connection.getOutputStream();
                                try {
                                    StreamUtils.copyStream(contentAsStream, os);
                                }
                                finally {
                                    StreamUtils.closeQuietly(os);
                                }
                            }
                        }
                        connection.connect();
                        HttpClientResponse clientResponse = new HttpClientResponse(connection);
                        try {
                            Net.HttpResponseListener listener = NetJavaImpl.this.getFromListeners(httpRequest);
                            if (listener != null) {
                                listener.handleHttpResponse(clientResponse);
                            }
                        }
                        finally {
                            NetJavaImpl.this.removeFromConnectionsAndListeners(httpRequest);
                            connection.disconnect();
                        }
                    }
                    catch (Exception e) {
                        connection.disconnect();
                        try {
                            httpResponseListener.failed(e);
                        }
                        finally {
                            NetJavaImpl.this.removeFromConnectionsAndListeners(httpRequest);
                        }
                    }
                }
            }));
        }
        catch (Exception e) {
            try {
                httpResponseListener.failed(e);
            }
            finally {
                this.removeFromConnectionsAndListeners(httpRequest);
            }
            return;
        }
    }

    public void cancelHttpRequest(Net.HttpRequest httpRequest) {
        Net.HttpResponseListener httpResponseListener = this.getFromListeners(httpRequest);
        if (httpResponseListener != null) {
            httpResponseListener.cancelled();
            this.cancelTask(httpRequest);
            this.removeFromConnectionsAndListeners(httpRequest);
        }
    }

    public boolean isHttpRequestPending(Net.HttpRequest httpRequest) {
        return this.getFromListeners(httpRequest) != null;
    }

    private void cancelTask(Net.HttpRequest httpRequest) {
        Future<?> task2 = this.tasks.get(httpRequest);
        if (task2 != null) {
            task2.cancel(false);
        }
    }

    synchronized void removeFromConnectionsAndListeners(Net.HttpRequest httpRequest) {
        this.connections.remove(httpRequest);
        this.listeners.remove(httpRequest);
        this.tasks.remove(httpRequest);
    }

    synchronized void putIntoConnectionsAndListeners(Net.HttpRequest httpRequest, Net.HttpResponseListener httpResponseListener, HttpURLConnection connection) {
        this.connections.put(httpRequest, connection);
        this.listeners.put(httpRequest, httpResponseListener);
    }

    synchronized Net.HttpResponseListener getFromListeners(Net.HttpRequest httpRequest) {
        Net.HttpResponseListener httpResponseListener = this.listeners.get(httpRequest);
        return httpResponseListener;
    }

    static class HttpClientResponse
    implements Net.HttpResponse {
        private final HttpURLConnection connection;
        private HttpStatus status;

        public HttpClientResponse(HttpURLConnection connection) throws IOException {
            this.connection = connection;
            try {
                this.status = new HttpStatus(connection.getResponseCode());
            }
            catch (IOException e) {
                this.status = new HttpStatus(-1);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public byte[] getResult() {
            InputStream input2 = this.getInputStream();
            if (input2 == null) {
                return StreamUtils.EMPTY_BYTES;
            }
            try {
                byte[] byArray = StreamUtils.copyStreamToByteArray(input2, this.connection.getContentLength());
                return byArray;
            }
            catch (IOException e) {
                byte[] byArray = StreamUtils.EMPTY_BYTES;
                return byArray;
            }
            finally {
                StreamUtils.closeQuietly(input2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String getResultAsString() {
            InputStream input2 = this.getInputStream();
            if (input2 == null) {
                return "";
            }
            try {
                String string = StreamUtils.copyStreamToString(input2, this.connection.getContentLength(), "UTF8");
                return string;
            }
            catch (IOException e) {
                String string = "";
                return string;
            }
            finally {
                StreamUtils.closeQuietly(input2);
            }
        }

        @Override
        public InputStream getResultAsStream() {
            return this.getInputStream();
        }

        @Override
        public HttpStatus getStatus() {
            return this.status;
        }

        @Override
        public String getHeader(String name) {
            return this.connection.getHeaderField(name);
        }

        @Override
        public Map<String, List<String>> getHeaders() {
            return this.connection.getHeaderFields();
        }

        private InputStream getInputStream() {
            try {
                return this.connection.getInputStream();
            }
            catch (IOException e) {
                return this.connection.getErrorStream();
            }
        }
    }
}

