package com.unciv.logic

import com.unciv.logic.files.UncivFiles
import com.unciv.models.ruleset.RulesetCache
import com.unciv.testing.GdxTestRunner
import org.junit.Test
import org.junit.runner.RunWith


@RunWith(GdxTestRunner::class)
class LoadGameTest {
    // Created 2023-08, v4.7.12, vanilla base ruleset, Spectator, 4 AI, 9 CS, startingEra=Information era and advanced to turn 13:
    private val vanillaGameWithCityStates = "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"

    // Created 2023-06-23, 4.12.2-patch1, G&K base ruleset, Spectator, 3 AI, 4 CS, tiny hex map, startingEra=Renaissance and advanced to turn 60, forced a war by manipulating diplomacy flags:
    private val gnkWithReligion = "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"

    @Test
    fun loadVanillaGameFromStringTest() {
        RulesetCache.loadRulesets(noMods = true)
        UncivFiles.gameInfoFromString(vanillaGameWithCityStates)
    }

    @Test
    fun loadReligionGameFromStringTest() {
        RulesetCache.loadRulesets(noMods = true)
        UncivFiles.gameInfoFromString(gnkWithReligion)
    }
}
