/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.network.tls;

import io.ktor.network.tls.CertificateInfo;
import io.ktor.network.tls.EncryptionInfo;
import io.ktor.network.tls.extensions.HashAndSign;
import io.ktor.network.tls.extensions.NamedCurve;
import io.ktor.network.tls.extensions.SignatureAlgorithmKt;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.io.Source;
import kotlinx.io.SourcesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0013\u0010\u0002\u001a\u00020\u0001*\u00020\u0000H\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u001a\u001f\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\t\u0010\n\u001a\u0017\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\u000bH\u0000\u00a2\u0006\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Ljava/security/SecureRandom;", "", "generateClientSeed", "(Ljava/security/SecureRandom;)[B", "Lio/ktor/network/tls/extensions/NamedCurve;", "curve", "Ljava/security/spec/ECPoint;", "serverPoint", "Lio/ktor/network/tls/EncryptionInfo;", "generateECKeys", "(Lio/ktor/network/tls/extensions/NamedCurve;Ljava/security/spec/ECPoint;)Lio/ktor/network/tls/EncryptionInfo;", "Lkotlinx/io/Source;", "packet", "Lio/ktor/network/tls/CertificateInfo;", "readClientCertificateRequest", "(Lkotlinx/io/Source;)Lio/ktor/network/tls/CertificateInfo;", "ktor-network-tls"})
@SourceDebugExtension(value={"SMAP\nTLSClientHandshake.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TLSClientHandshake.kt\nio/ktor/network/tls/TLSClientHandshakeKt\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,567:1\n37#2:568\n36#2,3:569\n*S KotlinDebug\n*F\n+ 1 TLSClientHandshake.kt\nio/ktor/network/tls/TLSClientHandshakeKt\n*L\n563#1:568\n563#1:569,3\n*E\n"})
public final class TLSClientHandshakeKt {
    private static final byte[] generateClientSeed(SecureRandom $this$generateClientSeed) {
        byte[] byArray;
        byte[] seed = new byte[32];
        $this$generateClientSeed.nextBytes(seed);
        byte[] it = byArray = seed;
        boolean bl = false;
        long unixTime = System.currentTimeMillis() / 1000L;
        it[0] = (byte)(unixTime >> 24);
        it[1] = (byte)(unixTime >> 16);
        it[2] = (byte)(unixTime >> 8);
        it[3] = (byte)(unixTime >> 0);
        return byArray;
    }

    private static final EncryptionInfo generateECKeys(NamedCurve curve, ECPoint serverPoint) {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("EC");
        Intrinsics.checkNotNull(keyPairGenerator);
        KeyPairGenerator $this$generateECKeys_u24lambda_u241 = keyPairGenerator;
        boolean bl = false;
        $this$generateECKeys_u24lambda_u241.initialize(new ECGenParameterSpec(curve.name()));
        KeyPair keyPair = $this$generateECKeys_u24lambda_u241.generateKeyPair();
        Intrinsics.checkNotNull(keyPair);
        KeyPair clientKeys = keyPair;
        PublicKey publicKey = clientKeys.getPublic();
        Intrinsics.checkNotNull(publicKey, "null cannot be cast to non-null type java.security.interfaces.ECPublicKey");
        ECPublicKey publicKey2 = (ECPublicKey)publicKey;
        KeyFactory keyFactory = KeyFactory.getInstance("EC");
        Intrinsics.checkNotNull(keyFactory);
        KeyFactory factory = keyFactory;
        ECParameterSpec eCParameterSpec = publicKey2.getParams();
        Intrinsics.checkNotNull(eCParameterSpec);
        PublicKey publicKey3 = factory.generatePublic(new ECPublicKeySpec(serverPoint, eCParameterSpec));
        Intrinsics.checkNotNull(publicKey3);
        PublicKey serverPublic = publicKey3;
        PublicKey publicKey4 = clientKeys.getPublic();
        Intrinsics.checkNotNullExpressionValue(publicKey4, "getPublic(...)");
        PrivateKey privateKey = clientKeys.getPrivate();
        Intrinsics.checkNotNullExpressionValue(privateKey, "getPrivate(...)");
        return new EncryptionInfo(serverPublic, publicKey4, privateKey);
    }

    @NotNull
    public static final CertificateInfo readClientCertificateRequest(@NotNull Source packet) {
        int bytesForReadingSize;
        int size;
        Intrinsics.checkNotNullParameter(packet, "packet");
        int typeCount = packet.readByte() & 0xFF;
        byte[] types = SourcesKt.readByteArray(packet, typeCount);
        int hashAndSignCount = packet.readShort() & 0xFFFF;
        List hashAndSign = new ArrayList();
        int n = hashAndSignCount / 2;
        for (int i = 0; i < n; ++i) {
            int it = i;
            boolean bl = false;
            byte hash = packet.readByte();
            byte sign = packet.readByte();
            Collection collection = hashAndSign;
            HashAndSign hashAndSign2 = SignatureAlgorithmKt.byCode(HashAndSign.Companion, hash, sign);
            if (hashAndSign2 == null) continue;
            collection.add(hashAndSign2);
        }
        int authoritiesSize = packet.readShort() & 0xFFFF;
        Set authorities = new LinkedHashSet();
        for (int position = 0; position < authoritiesSize; position += size + bytesForReadingSize) {
            size = packet.readShort() & 0xFFFF;
            bytesForReadingSize = 2;
            byte[] authority = SourcesKt.readByteArray(packet, size);
            ((Collection)authorities).add(new X500Principal(authority));
        }
        Collection $this$toTypedArray$iv = hashAndSign;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        CertificateInfo certificateInfo = new CertificateInfo(types, thisCollection$iv.toArray(new HashAndSign[0]), authorities);
        if (!packet.exhausted()) {
            throw new IllegalStateException("Check failed.");
        }
        return certificateInfo;
    }

    public static final /* synthetic */ byte[] access$generateClientSeed(SecureRandom $receiver) {
        return TLSClientHandshakeKt.generateClientSeed($receiver);
    }

    public static final /* synthetic */ EncryptionInfo access$generateECKeys(NamedCurve curve, ECPoint serverPoint) {
        return TLSClientHandshakeKt.generateECKeys(curve, serverPoint);
    }
}

