/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.worldscreen;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.unciv.UncivGame;
import com.unciv.logic.GameInfo;
import com.unciv.logic.VictoryData;
import com.unciv.logic.battle.BattleUnitCapture;
import com.unciv.logic.city.City;
import com.unciv.logic.city.CityStats;
import com.unciv.logic.civilization.AlertType;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.CivilopediaAction;
import com.unciv.logic.civilization.DiplomacyAction;
import com.unciv.logic.civilization.LocationAction;
import com.unciv.logic.civilization.Notification;
import com.unciv.logic.civilization.NotificationAction;
import com.unciv.logic.civilization.PopupAlert;
import com.unciv.logic.civilization.diplomacy.DeclareWarReason;
import com.unciv.logic.civilization.diplomacy.Demand;
import com.unciv.logic.civilization.diplomacy.DiplomacyFlags;
import com.unciv.logic.civilization.diplomacy.DiplomacyManager;
import com.unciv.logic.civilization.diplomacy.DiplomaticModifiers;
import com.unciv.logic.civilization.diplomacy.RelationshipLevel;
import com.unciv.logic.civilization.diplomacy.WarType;
import com.unciv.logic.map.TileMap;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.ruleset.Building;
import com.unciv.models.ruleset.Event;
import com.unciv.models.ruleset.EventChoice;
import com.unciv.models.ruleset.nation.Nation;
import com.unciv.models.ruleset.tech.Technology;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.audio.MusicController;
import com.unciv.ui.audio.MusicMood;
import com.unciv.ui.audio.MusicTrackChooserFlags;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.input.KeyboardBinding;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.popups.Popup;
import com.unciv.ui.screens.diplomacyscreen.LeaderIntroTable;
import com.unciv.ui.screens.victoryscreen.VictoryScreen;
import com.unciv.ui.screens.worldscreen.RenderEvent;
import com.unciv.ui.screens.worldscreen.WorldScreen;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001cH\u0002J\u0018\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!2\b\b\u0002\u0010#\u001a\u00020\u001cH\u0002J\b\u0010$\u001a\u00020%H\u0002J\b\u0010&\u001a\u00020%H\u0002J\b\u0010'\u001a\u00020%H\u0002J\b\u0010(\u001a\u00020)H\u0002J\u0010\u0010*\u001a\u00020%2\u0006\u0010+\u001a\u00020,H\u0002J\b\u0010-\u001a\u00020)H\u0002J\b\u0010.\u001a\u00020%H\u0002J\b\u0010/\u001a\u00020)H\u0002J\u0010\u00100\u001a\u00020%2\u0006\u0010+\u001a\u00020,H\u0002J\b\u00101\u001a\u00020)H\u0002J\b\u00102\u001a\u00020)H\u0002J\b\u00103\u001a\u00020)H\u0002J\b\u00104\u001a\u00020)H\u0002J\b\u00105\u001a\u00020%H\u0002J\b\u00106\u001a\u00020)H\u0002J\b\u00107\u001a\u00020)H\u0002J\b\u00108\u001a\u00020%H\u0002J\b\u00109\u001a\u00020)H\u0002J\u0010\u0010:\u001a\u00020)2\u0006\u0010;\u001a\u00020\u0011H\u0002J\u0010\u0010<\u001a\u00020)2\u0006\u0010=\u001a\u00020\u001cH\u0002J\u0016\u0010>\u001a\u00020)2\f\u0010?\u001a\b\u0012\u0004\u0012\u00020)0@H\u0002J&\u0010A\u001a\u00020)2\u0006\u0010B\u001a\u00020\u001e2\u0006\u0010C\u001a\u00020%2\f\u0010D\u001a\b\u0012\u0004\u0012\u00020)0@H\u0002J\u001e\u0010E\u001a\u00020)2\u0006\u0010C\u001a\u00020%2\f\u0010F\u001a\b\u0012\u0004\u0012\u00020)0@H\u0002J\u0018\u0010G\u001a\u00020)2\u0006\u0010B\u001a\u00020\u001e2\u0006\u0010H\u001a\u00020\u0011H\u0002J \u0010I\u001a\u00020)2\u0006\u0010B\u001a\u00020\u001e2\u0006\u0010C\u001a\u00020%2\u0006\u0010H\u001a\u00020\u0011H\u0002J\b\u0010J\u001a\u00020%H\u0002J\b\u0010K\u001a\u00020)H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0017\u00a8\u0006L"}, d2={"Lcom/unciv/ui/screens/worldscreen/AlertPopup;", "Lcom/unciv/ui/popups/Popup;", "worldScreen", "Lcom/unciv/ui/screens/worldscreen/WorldScreen;", "popupAlert", "Lcom/unciv/logic/civilization/PopupAlert;", "<init>", "(Lcom/unciv/ui/screens/worldscreen/WorldScreen;Lcom/unciv/logic/civilization/PopupAlert;)V", "music", "Lcom/unciv/ui/audio/MusicController;", "getMusic", "()Lcom/unciv/ui/audio/MusicController;", "gameInfo", "Lcom/unciv/logic/GameInfo;", "getGameInfo", "()Lcom/unciv/logic/GameInfo;", "viewingCiv", "Lcom/unciv/logic/civilization/Civilization;", "getViewingCiv", "()Lcom/unciv/logic/civilization/Civilization;", "stageWidth", "", "getStageWidth", "()F", "stageHeight", "getStageHeight", "getCiv", "civName", "", "getCity", "Lcom/unciv/logic/city/City;", "cityId", "addCloseButton", "Lcom/badlogic/gdx/scenes/scene2d/ui/Cell;", "Lcom/badlogic/gdx/scenes/scene2d/ui/TextButton;", "text", "addBorderConflict", "", "addTilesStolen", "addBulliedOrAttackedProtectedOrAlliedMinor", "addCityConquered", "", "addDemandViolationNoticed", "demand", "Lcom/unciv/logic/civilization/diplomacy/Demand;", "addCityTraded", "addDeclarationOfFriendship", "addDefeated", "addDemand", "addDiplomaticMarriage", "addFirstContact", "addGameHasBeenWon", "addGoldenAge", "addRecapturedCivilian", "addStartIntro", "addTechResearched", "addWarDeclaration", "addWonderBuilt", "addLeaderName", "civInfo", "addQuestionAboutTheCity", "cityName", "addDestroyOption", "destroyAction", "Lkotlin/Function0;", "addAnnexOption", "city", "mayAnnex", "annexAction", "addPuppetOption", "puppetAction", "addLiberateOption", "conqueringCiv", "addRazeOption", "addEvent", "close", "core"})
@SourceDebugExtension(value={"SMAP\nAlertPopup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AlertPopup.kt\ncom/unciv/ui/screens/worldscreen/AlertPopup\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,588:1\n127#2,2:589\n1#3:591\n2423#4,14:592\n*S KotlinDebug\n*F\n+ 1 AlertPopup.kt\ncom/unciv/ui/screens/worldscreen/AlertPopup\n*L\n71#1:589,2\n358#1:592,14\n*E\n"})
public final class AlertPopup
extends Popup {
    @NotNull
    private final WorldScreen worldScreen;
    @NotNull
    private final PopupAlert popupAlert;

    public AlertPopup(@NotNull WorldScreen worldScreen, @NotNull PopupAlert popupAlert) {
        Intrinsics.checkNotNullParameter(worldScreen, "worldScreen");
        Intrinsics.checkNotNullParameter(popupAlert, "popupAlert");
        super(worldScreen, null, 0.0f, 6, null);
        this.worldScreen = worldScreen;
        this.popupAlert = popupAlert;
        boolean shouldOpen = true;
        this.getBottomTable().defaults().growX();
        switch (WhenMappings.$EnumSwitchMapping$0[this.popupAlert.getType().ordinal()]) {
            case 1: {
                this.addCityConquered();
                break;
            }
            case 2: {
                this.addCityTraded();
                break;
            }
            case 3: {
                this.addDiplomaticMarriage();
                break;
            }
            case 4: {
                this.addFirstContact();
                break;
            }
            case 5: {
                shouldOpen = this.addWarDeclaration();
                break;
            }
            case 6: {
                shouldOpen = this.addBorderConflict();
                break;
            }
            case 7: {
                shouldOpen = this.addTilesStolen();
                break;
            }
            case 8: {
                shouldOpen = this.addDemand(Demand.DoNotSettleNearUs);
                break;
            }
            case 9: {
                shouldOpen = this.addDemandViolationNoticed(Demand.DoNotSettleNearUs);
                break;
            }
            case 10: {
                shouldOpen = this.addDemand(Demand.DoNotSpreadReligion);
                break;
            }
            case 11: {
                shouldOpen = this.addDemandViolationNoticed(Demand.DoNotSpreadReligion);
                break;
            }
            case 12: {
                shouldOpen = this.addDemand(Demand.DontSpyOnUs);
                break;
            }
            case 13: {
                shouldOpen = this.addDemand(Demand.DontSpyOnUs);
                break;
            }
            case 14: {
                shouldOpen = this.addDeclarationOfFriendship();
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                shouldOpen = this.addBulliedOrAttackedProtectedOrAlliedMinor();
                break;
            }
            case 18: {
                this.addDefeated();
                break;
            }
            case 19: {
                this.addWonderBuilt();
                break;
            }
            case 20: {
                this.addTechResearched();
                break;
            }
            case 21: {
                this.addGoldenAge();
                break;
            }
            case 22: {
                this.addStartIntro();
                break;
            }
            case 23: {
                shouldOpen = this.addRecapturedCivilian();
                break;
            }
            case 24: {
                this.addGameHasBeenWon();
                break;
            }
            case 25: {
                shouldOpen = this.addEvent();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        if (shouldOpen) {
            Popup.open$default(this, false, 1, null);
        } else {
            this.getViewingCiv().getPopupAlerts().remove(this.popupAlert);
        }
    }

    private final MusicController getMusic() {
        return UncivGame.Companion.getCurrent().getMusicController();
    }

    private final GameInfo getGameInfo() {
        return this.worldScreen.getGameInfo();
    }

    private final Civilization getViewingCiv() {
        return this.worldScreen.getViewingCiv();
    }

    private final float getStageWidth() {
        return this.worldScreen.getStage().getWidth();
    }

    private final float getStageHeight() {
        return this.worldScreen.getStage().getHeight();
    }

    private final Civilization getCiv(String civName) {
        return this.getGameInfo().getCivilization(civName);
    }

    private final City getCity(String cityId) {
        City element$iv;
        block1: {
            Sequence<City> $this$first$iv = this.getGameInfo().getCities();
            boolean $i$f$first = false;
            Iterator<City> iterator2 = $this$first$iv.iterator();
            while (iterator2.hasNext()) {
                City it = element$iv = iterator2.next();
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getId(), cityId)) continue;
                break block1;
            }
            throw new NoSuchElementException("Sequence contains no element matching the predicate.");
        }
        return element$iv;
    }

    private final Cell<TextButton> addCloseButton(String text) {
        return this.addCloseButton(text, KeyboardBinding.NextTurnAlternate, null);
    }

    static /* synthetic */ Cell addCloseButton$default(AlertPopup alertPopup, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "Close";
        }
        return alertPopup.addCloseButton(string);
    }

    private final boolean addBorderConflict() {
        Civilization civInfo = this.getCiv(this.popupAlert.getValue());
        if (civInfo.isDefeated()) {
            return false;
        }
        this.addLeaderName(civInfo);
        Popup.addGoodSizedLabel$default(this, "Remove your troops in our border immediately!", 0, false, null, 14, null);
        Popup.addCloseButton$default(this, "Sorry.", KeyboardBinding.Confirm, null, 4, null);
        Popup.addCloseButton$default(this, "Never!", KeyboardBinding.Cancel, null, 4, null);
        return true;
    }

    private final boolean addTilesStolen() {
        Civilization civInfo = this.getCiv(this.popupAlert.getValue());
        if (civInfo.isDefeated()) {
            return false;
        }
        this.addLeaderName(civInfo);
        Popup.addGoodSizedLabel$default(this, "Those lands were not yours to take. This has not gone unnoticed.", 0, false, null, 14, null);
        AlertPopup.addCloseButton$default(this, null, 1, null);
        return true;
    }

    private final boolean addBulliedOrAttackedProtectedOrAlliedMinor() {
        char[] cArray = new char[]{'@'};
        List involvedCivs = StringsKt.split$default((CharSequence)this.popupAlert.getValue(), cArray, false, 0, 6, null);
        Civilization bullyOrAttacker = this.getCiv((String)involvedCivs.get(0));
        if (bullyOrAttacker.isDefeated()) {
            return false;
        }
        Civilization cityState = this.getCiv((String)involvedCivs.get(1));
        Civilization player = this.getViewingCiv();
        this.addLeaderName(bullyOrAttacker);
        DiplomacyManager diplomacyManager = bullyOrAttacker.getDiplomacyManager(player);
        Intrinsics.checkNotNull(diplomacyManager);
        boolean isAtLeastNeutral = diplomacyManager.isRelationshipLevelGE(RelationshipLevel.Neutral);
        String text = this.popupAlert.getType() == AlertType.BulliedProtectedMinor && isAtLeastNeutral ? "I've been informed that my armies have taken tribute from [" + cityState.getCivName() + "], a city-state under your protection.\nI assure you, this was quite unintentional, and I hope that this does not serve to drive us apart." : (this.popupAlert.getType() == AlertType.BulliedProtectedMinor ? "We asked [" + cityState.getCivName() + "] for a tribute recently and they gave in.\nYou promised to protect them from such things, but we both know you cannot back that up." : (isAtLeastNeutral ? "It's come to my attention that I may have attacked [" + cityState.getCivName() + "].\nWhile it was not my goal to be at odds with your empire, this was deemed a necessary course of action." : "I thought you might like to know that I've launched an invasion of one of your little pet states.\nThe lands of [" + cityState.getCivName() + "] will make a fine addition to my own."));
        Popup.addGoodSizedLabel$default(this, text, 0, false, null, 14, null).row();
        if (!player.isAtWarWith(bullyOrAttacker)) {
            this.addCloseButton("THIS MEANS WAR!", KeyboardBinding.Confirm, () -> AlertPopup.addBulliedOrAttackedProtectedOrAlliedMinor$lambda$1(player, bullyOrAttacker, this, cityState)).row();
        }
        this.addCloseButton("You'll pay for this!", KeyboardBinding.Confirm, () -> AlertPopup.addBulliedOrAttackedProtectedOrAlliedMinor$lambda$2(player, bullyOrAttacker)).row();
        this.addCloseButton("Very well.", KeyboardBinding.Cancel, () -> AlertPopup.addBulliedOrAttackedProtectedOrAlliedMinor$lambda$3(player, cityState)).row();
        return true;
    }

    private final void addCityConquered() {
        City city = this.getCity(this.popupAlert.getValue());
        this.addQuestionAboutTheCity(city.getName());
        Civilization conqueringCiv = this.getGameInfo().getCurrentPlayerCivilization();
        if (!(Intrinsics.areEqual(city.getFoundingCiv(), "") || Intrinsics.areEqual(city.getCiv().getCivName(), city.getFoundingCiv()) || Intrinsics.areEqual(conqueringCiv.getCivName(), city.getFoundingCiv()))) {
            this.addLiberateOption(city, conqueringCiv);
            Popup.addSeparator$default(this, null, 0, 0.0f, 7, null);
        }
        if (conqueringCiv.isOneCityChallenger()) {
            this.addDestroyOption(() -> AlertPopup.addCityConquered$lambda$4(city, conqueringCiv));
        } else {
            boolean mayAnnex = !Civilization.hasUnique$default(conqueringCiv, UniqueType.MayNotAnnexCities, null, 2, null);
            this.addAnnexOption(city, mayAnnex, () -> AlertPopup.addCityConquered$lambda$5(city, conqueringCiv));
            Popup.addSeparator$default(this, null, 0, 0.0f, 7, null);
            this.addPuppetOption(mayAnnex, () -> AlertPopup.addCityConquered$lambda$6(city, conqueringCiv));
            Popup.addSeparator$default(this, null, 0, 0.0f, 7, null);
            this.addRazeOption(city, mayAnnex, conqueringCiv);
        }
    }

    private final boolean addDemandViolationNoticed(Demand demand) {
        Civilization otherciv = this.getCiv(this.popupAlert.getValue());
        if (otherciv.isDefeated()) {
            return false;
        }
        this.addLeaderName(otherciv);
        Popup.addGoodSizedLabel$default(this, demand.getViolationNoticedText(), 0, false, null, 14, null).row();
        this.addCloseButton("Very well.");
        return true;
    }

    private final void addCityTraded() {
        City city = this.getCity(this.popupAlert.getValue());
        this.addQuestionAboutTheCity(city.getName());
        Civilization conqueringCiv = this.getGameInfo().getCurrentPlayerCivilization();
        if (!conqueringCiv.isAtWarWith(this.getCiv(city.getFoundingCiv()))) {
            this.addLiberateOption(city, conqueringCiv);
            Popup.addSeparator$default(this, null, 0, 0.0f, 7, null);
        }
        this.addCloseButton("Keep it").row();
    }

    private final boolean addDeclarationOfFriendship() {
        Civilization otherciv = this.getCiv(this.popupAlert.getValue());
        if (otherciv.isDefeated()) {
            return false;
        }
        DiplomacyManager diplomacyManager = this.getViewingCiv().getDiplomacyManager(otherciv);
        Intrinsics.checkNotNull(diplomacyManager);
        DiplomacyManager playerDiploManager = diplomacyManager;
        this.addLeaderName(otherciv);
        Popup.addGoodSizedLabel$default(this, ((CharSequence)otherciv.getNation().getDeclaringFriendship()).length() > 0 ? otherciv.getNation().getDeclaringFriendship() : "My friend, shall we declare our friendship to the world?", 0, false, null, 14, null).row();
        this.addCloseButton("Declare Friendship ([30] turns)", KeyboardBinding.Confirm, () -> AlertPopup.addDeclarationOfFriendship$lambda$7(playerDiploManager)).row();
        this.addCloseButton("We are not interested.", KeyboardBinding.Cancel, () -> AlertPopup.addDeclarationOfFriendship$lambda$8(playerDiploManager)).row();
        MusicController music = UncivGame.Companion.getCurrent().getMusicController();
        music.playVoice(otherciv.getNation().getName() + ".declaringFriendship");
        return true;
    }

    private final void addDefeated() {
        Civilization civInfo = this.getCiv(this.popupAlert.getValue());
        this.addLeaderName(civInfo);
        Popup.addGoodSizedLabel$default(this, civInfo.getNation().getDefeated(), 0, false, null, 14, null).row();
        this.addCloseButton("Farewell.");
        MusicController musicController = this.getMusic();
        String string = civInfo.getCivName();
        EnumSet<Enum> enumSet = EnumSet.of((Enum)MusicTrackChooserFlags.SuffixMustMatch);
        Intrinsics.checkNotNullExpressionValue(enumSet, "of(...)");
        musicController.chooseTrack(string, "Defeat", enumSet);
        this.getMusic().playVoice(civInfo.getCivName() + ".defeated");
    }

    private final boolean addDemand(Demand demand) {
        Civilization otherciv = this.getCiv(this.popupAlert.getValue());
        if (otherciv.isDefeated()) {
            return false;
        }
        DiplomacyManager diplomacyManager = this.getViewingCiv().getDiplomacyManager(otherciv);
        Intrinsics.checkNotNull(diplomacyManager);
        DiplomacyManager playerDiploManager = diplomacyManager;
        this.addLeaderName(otherciv);
        Popup.addGoodSizedLabel$default(this, demand.getDemandText(), 0, false, null, 14, null).row();
        this.addCloseButton(demand.getAcceptDemandText(), KeyboardBinding.Confirm, () -> AlertPopup.addDemand$lambda$9(playerDiploManager, demand)).row();
        this.addCloseButton(demand.getRefuseDemandText(), KeyboardBinding.Cancel, () -> AlertPopup.addDemand$lambda$10(playerDiploManager, demand));
        return true;
    }

    private final void addDiplomaticMarriage() {
        City city = this.getCity(this.popupAlert.getValue());
        Popup.addGoodSizedLabel$default(this, TranslationsKt.tr$default(city.getName(), false, false, 3, null) + ": " + TranslationsKt.tr$default("What would you like to do with the city?", false, false, 3, null), 24, false, null, 12, null).padBottom(20.0f).row();
        Civilization marryingCiv = this.getGameInfo().getCurrentPlayerCivilization();
        if (marryingCiv.isOneCityChallenger()) {
            this.addDestroyOption(() -> AlertPopup.addDiplomaticMarriage$lambda$11(city));
        } else {
            boolean mayAnnex = !Civilization.hasUnique$default(marryingCiv, UniqueType.MayNotAnnexCities, null, 2, null);
            this.addAnnexOption(city, mayAnnex, AlertPopup::addDiplomaticMarriage$lambda$12);
            Popup.addSeparator$default(this, null, 0, 0.0f, 7, null);
            this.addPuppetOption(mayAnnex, () -> AlertPopup.addDiplomaticMarriage$lambda$13(city));
        }
    }

    private final void addFirstContact() {
        Cell<TextButton> cell;
        Civilization civInfo = this.getCiv(this.popupAlert.getValue());
        Nation nation = civInfo.getNation();
        this.addLeaderName(civInfo);
        this.getMusic().chooseTrack(civInfo.getCivName(), MusicMood.INSTANCE.getThemeOrPeace(), MusicTrackChooserFlags.Companion.getSetSpecific());
        this.getMusic().playVoice(civInfo.getCivName() + ".introduction");
        if (civInfo.isCityState()) {
            Popup.addGoodSizedLabel$default(this, "We have encountered the City-State of [" + nation.getName() + "]!", 0, false, null, 14, null).row();
            cell = this.addCloseButton("Excellent!");
        } else {
            Popup.addGoodSizedLabel$default(this, nation.getIntroduction(), 0, false, null, 14, null).row();
            cell = this.addCloseButton("A pleasure to meet you.");
        }
    }

    private final void addGameHasBeenWon() {
        VictoryData victoryData = this.getGameInfo().getVictoryData();
        Intrinsics.checkNotNull(victoryData);
        VictoryData victoryData2 = victoryData;
        Popup.addGoodSizedLabel$default(this, '[' + victoryData2.getWinningCiv() + "] has won a [" + victoryData2.getVictoryType() + "] Victory!", 0, false, null, 14, null).row();
        Popup.addButton$default((Popup)this, "Victory status", null, null, () -> AlertPopup.addGameHasBeenWon$lambda$14(this), 6, null).row();
        AlertPopup.addCloseButton$default(this, null, 1, null);
    }

    private final void addGoldenAge() {
        Popup.addGoodSizedLabel$default(this, "GOLDEN AGE", 0, false, null, 14, null);
        Popup.addSeparator$default(this, null, 0, 0.0f, 7, null);
        Popup.addGoodSizedLabel$default(this, "Your citizens have been happy with your rule for so long that the empire enters a Golden Age!", 0, false, null, 14, null).row();
        AlertPopup.addCloseButton$default(this, null, 1, null);
        this.getMusic().chooseTrack(this.getViewingCiv().getCivName(), "Golden", MusicTrackChooserFlags.Companion.getSetSpecific());
    }

    private final boolean addRecapturedCivilian() {
        Vector2 position = new Vector2().fromString(this.popupAlert.getValue());
        TileMap tileMap = this.getGameInfo().getTileMap();
        Intrinsics.checkNotNull(position);
        Tile tile = tileMap.get(position);
        MapUnit mapUnit = tile.getCivilianUnit();
        if (mapUnit == null) {
            return false;
        }
        MapUnit capturedUnit = mapUnit;
        String string = capturedUnit.getOriginalOwner();
        Intrinsics.checkNotNull(string);
        Civilization originalOwner = this.getCiv(string);
        if (originalOwner.isDefeated()) {
            return false;
        }
        Civilization captor = this.getViewingCiv();
        Popup.addGoodSizedLabel$default(this, "Return [" + capturedUnit.getName() + "] to [" + originalOwner.getCivName() + "]?", 0, false, null, 14, null);
        Popup.addSeparator$default(this, null, 0, 0.0f, 7, null);
        Popup.addGoodSizedLabel$default(this, "The [" + capturedUnit.getName() + "] we liberated originally belonged to [" + originalOwner.getCivName() + "]. They will be grateful if we return it to them.", 0, false, null, 14, null).row();
        Cell cell = this.getBottomTable().defaults();
        Intrinsics.checkNotNullExpressionValue(cell, "defaults(...)");
        Scene2dExtensionsKt.pad(cell, 0.0f, 30.0f);
        this.addCloseButton("Yes", KeyboardBinding.Confirm, () -> AlertPopup.addRecapturedCivilian$lambda$16(capturedUnit, originalOwner, captor, tile));
        this.addCloseButton("No", KeyboardBinding.Cancel, () -> AlertPopup.addRecapturedCivilian$lambda$17(capturedUnit, captor));
        return true;
    }

    private final void addStartIntro() {
        Civilization civInfo = this.getViewingCiv();
        this.addLeaderName(civInfo);
        Popup.addGoodSizedLabel$default(this, civInfo.getNation().getStartIntroPart1(), 0, false, null, 14, null).row();
        Popup.addGoodSizedLabel$default(this, civInfo.getNation().getStartIntroPart2(), 0, false, null, 14, null).row();
        this.addCloseButton("Let's begin!");
        MusicController music = UncivGame.Companion.getCurrent().getMusicController();
        music.chooseTrack(civInfo.getNation().getName(), MusicMood.INSTANCE.getThemeOrPeace(), MusicTrackChooserFlags.Companion.getSetSpecific());
        music.playVoice(civInfo.getNation().getName() + ".startIntroPart1");
    }

    /*
     * WARNING - void declaration
     */
    private final void addTechResearched() {
        void $this$addTechResearched_u24lambda_u2418;
        Label label;
        Technology technology = this.getGameInfo().getRuleset().getTechnologies().get(this.popupAlert.getValue());
        Intrinsics.checkNotNull(technology);
        Technology tech = technology;
        Popup.addGoodSizedLabel$default(this, tech.getName(), 0, false, null, 14, null);
        Popup.addSeparator$default(this, null, 0, 0.0f, 7, null);
        Table centerTable = new Table();
        Label label2 = label = Scene2dExtensionsKt.toLabel(tech.getQuote());
        Table table2 = centerTable;
        boolean bl = false;
        $this$addTechResearched_u24lambda_u2418.setWrap(true);
        table2.add((Actor)label).width(this.getStageWidth() / (float)3);
        centerTable.add((Actor)ImageGetter.INSTANCE.getTechIconPortrait(tech.getName(), 100.0f)).pad(20.0f);
        Label $this$addTechResearched_u24lambda_u2419 = label2 = Scene2dExtensionsKt.toLabel(tech.getDescription(this.getViewingCiv()));
        boolean bl2 = false;
        $this$addTechResearched_u24lambda_u2419.setWrap(true);
        Actor actor = label2;
        ScrollPane descriptionScroll = new ScrollPane(actor);
        centerTable.add((Actor)descriptionScroll).width(this.getStageWidth() / (float)3).maxHeight(this.getStageHeight() / (float)2);
        this.add((Actor)centerTable).row();
        AlertPopup.addCloseButton$default(this, null, 1, null);
        this.getMusic().chooseTrack(tech.getName(), "Researched", MusicTrackChooserFlags.Companion.getSetSpecific());
    }

    private final boolean addWarDeclaration() {
        Civilization civInfo = this.getCiv(this.popupAlert.getValue());
        if (civInfo.isDefeated()) {
            return false;
        }
        this.addLeaderName(civInfo);
        Popup.addGoodSizedLabel$default(this, civInfo.getNation().getDeclaringWar(), 0, false, null, 14, null).row();
        Cell cell = this.getBottomTable().defaults();
        Intrinsics.checkNotNullExpressionValue(cell, "defaults(...)");
        Scene2dExtensionsKt.pad(cell, 0.0f, 5.0f);
        this.addCloseButton("You'll pay for this!");
        this.addCloseButton("Very well.");
        this.getMusic().chooseTrack(civInfo.getCivName(), "War", MusicTrackChooserFlags.Companion.getSetSpecific());
        this.getMusic().playVoice(civInfo.getCivName() + ".declaringWar");
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final void addWonderBuilt() {
        void $this$addWonderBuilt_u24lambda_u2421;
        Label $this$addWonderBuilt_u24lambda_u2420;
        Label label;
        Building building = this.getGameInfo().getRuleset().getBuildings().get(this.popupAlert.getValue());
        Intrinsics.checkNotNull(building);
        Building wonder = building;
        Popup.addGoodSizedLabel$default(this, wonder.getName(), 0, false, null, 14, null);
        Popup.addSeparator$default(this, null, 0, 0.0f, 7, null);
        if (ImageGetter.INSTANCE.wonderImageExists(wonder.getName())) {
            if (this.getStageHeight() * (float)3 > this.getStageWidth() * (float)4) {
                this.add((Actor)ImageGetter.INSTANCE.getWonderImage(wonder.getName())).width(this.getStageWidth() / 1.5f).height(this.getStageWidth() / (float)3).row();
            } else {
                this.add((Actor)ImageGetter.INSTANCE.getWonderImage(wonder.getName())).width(this.getStageWidth() / 2.5f).height(this.getStageWidth() / (float)5).row();
            }
        } else {
            this.add((Actor)ImageGetter.INSTANCE.getConstructionPortrait(wonder.getName(), 100.0f)).pad(20.0f).row();
        }
        Table centerTable = new Table();
        Label label2 = label = Scene2dExtensionsKt.toLabel(wonder.getQuote());
        Table table2 = centerTable;
        boolean bl = false;
        $this$addWonderBuilt_u24lambda_u2420.setWrap(true);
        table2.add((Actor)label).width(this.getStageWidth() / (float)3).pad(10.0f);
        $this$addWonderBuilt_u24lambda_u2420 = label = Scene2dExtensionsKt.toLabel(Building.getShortDescription$default(wonder, false, null, 3, null));
        table2 = centerTable;
        boolean bl2 = false;
        $this$addWonderBuilt_u24lambda_u2421.setWrap(true);
        table2.add((Actor)label).width(this.getStageWidth() / (float)3).pad(10.0f);
        this.add((Actor)centerTable).row();
        AlertPopup.addCloseButton$default(this, null, 1, null);
        this.getMusic().chooseTrack(wonder.getName(), "Wonder", MusicTrackChooserFlags.Companion.getSetSpecific());
    }

    private final void addLeaderName(Civilization civInfo) {
        this.add((Actor)new LeaderIntroTable(civInfo, null, 2, null));
        Popup.addSeparator$default(this, null, 0, 0.0f, 7, null);
    }

    private final void addQuestionAboutTheCity(String cityName) {
        Popup.addGoodSizedLabel$default(this, "What would you like to do with the city of [" + cityName + "]?", 24, true, null, 8, null).padBottom(20.0f).row();
    }

    private final void addDestroyOption(Function0<Unit> destroyAction) {
        TextButton button = Scene2dExtensionsKt.toTextButton$default("Destroy", null, false, 3, null);
        ActivationExtensionsKt.onActivation(button, () -> AlertPopup.addDestroyOption$lambda$22(destroyAction, this));
        ActivationExtensionsKt.getKeyShortcuts(button).add(Character.valueOf('d'));
        this.add((Actor)button).row();
        Popup.addGoodSizedLabel$default(this, "Destroying the city instantly razes the city to the ground.", 0, false, null, 14, null).row();
    }

    private final void addAnnexOption(City city, boolean mayAnnex, Function0<Unit> annexAction) {
        TextButton button;
        TextButton textButton;
        TextButton $this$addAnnexOption_u24lambda_u2424 = textButton = (button = Scene2dExtensionsKt.toTextButton$default("Annex", null, false, 3, null));
        boolean bl = false;
        if (!mayAnnex) {
            Scene2dExtensionsKt.disable($this$addAnnexOption_u24lambda_u2424);
        } else {
            ActivationExtensionsKt.onActivation(button, () -> AlertPopup.addAnnexOption$lambda$24$lambda$23(annexAction, city, this));
            ActivationExtensionsKt.getKeyShortcuts(button).add(Character.valueOf('a'));
        }
        this.add((Actor)button).row();
        if (mayAnnex) {
            Popup.addGoodSizedLabel$default(this, "Annexed cities become part of your regular empire.", 0, false, null, 14, null).row();
            Popup.addGoodSizedLabel$default(this, "Their citizens generate 2x the unhappiness, unless you build a courthouse.", 0, false, null, 14, null).row();
        } else {
            Popup.addGoodSizedLabel$default(this, "Your civilization may not annex this city.", 0, false, null, 14, null).row();
        }
    }

    private final void addPuppetOption(boolean mayAnnex, Function0<Unit> puppetAction) {
        TextButton button = Scene2dExtensionsKt.toTextButton$default("Puppet", null, false, 3, null);
        ActivationExtensionsKt.onActivation(button, () -> AlertPopup.addPuppetOption$lambda$25(puppetAction, this));
        ActivationExtensionsKt.getKeyShortcuts(button).add(Character.valueOf('p'));
        this.add((Actor)button).row();
        Popup.addGoodSizedLabel$default(this, "Puppeted cities do not increase your tech or policy cost.", 0, false, null, 14, null).row();
        Popup.addGoodSizedLabel$default(this, "You have no control over the the production of puppeted cities.", 0, false, null, 14, null).row();
        Popup.addGoodSizedLabel$default(this, "Puppeted cities also generate 25% less Science and Culture.", 0, false, null, 14, null).row();
        if (mayAnnex) {
            Popup.addGoodSizedLabel$default(this, "A puppeted city can be annexed at any time.", 0, false, null, 14, null).row();
        }
    }

    private final void addLiberateOption(City city, Civilization conqueringCiv) {
        String[] stringArray = new String[]{city.getFoundingCiv()};
        TextButton button = Scene2dExtensionsKt.toTextButton$default(TranslationsKt.fillPlaceholders("Liberate (city returns to [originalOwner])", stringArray), null, false, 3, null);
        ActivationExtensionsKt.onActivation(button, () -> AlertPopup.addLiberateOption$lambda$26(city, conqueringCiv, this));
        ActivationExtensionsKt.getKeyShortcuts(button).add(Character.valueOf('l'));
        this.add((Actor)button).row();
        Popup.addGoodSizedLabel$default(this, "Liberating a city returns it to its original owner, giving you a massive relationship boost with them!", 0, false, null, 14, null);
    }

    private final void addRazeOption(City city, boolean mayAnnex, Civilization conqueringCiv) {
        TextButton button;
        TextButton textButton;
        boolean canRaze = city.canBeDestroyed(true);
        TextButton $this$addRazeOption_u24lambda_u2428 = textButton = (button = Scene2dExtensionsKt.toTextButton$default("Raze", null, false, 3, null));
        boolean bl = false;
        if (!canRaze) {
            Scene2dExtensionsKt.disable($this$addRazeOption_u24lambda_u2428);
        } else {
            ActivationExtensionsKt.onActivation($this$addRazeOption_u24lambda_u2428, () -> AlertPopup.addRazeOption$lambda$28$lambda$27(city, conqueringCiv, mayAnnex, this));
            ActivationExtensionsKt.getKeyShortcuts($this$addRazeOption_u24lambda_u2428).add(Character.valueOf('r'));
        }
        this.add((Actor)button).row();
        if (canRaze) {
            if (mayAnnex) {
                Popup.addGoodSizedLabel$default(this, "Razing the city annexes it, and starts burning the city to the ground.", 0, false, null, 14, null).row();
            } else {
                Popup.addGoodSizedLabel$default(this, "Razing the city puppets it, and starts burning the city to the ground.", 0, false, null, 14, null).row();
            }
            Popup.addGoodSizedLabel$default(this, "The population will gradually dwindle until the city is destroyed.", 0, false, null, 14, null).row();
        } else {
            Popup.addGoodSizedLabel$default(this, "Original capitals and holy cities cannot be razed.", 0, false, null, 14, null).row();
        }
    }

    private final boolean addEvent() {
        char[] cArray = new char[]{'\u241f'};
        List splitString = StringsKt.split$default((CharSequence)this.popupAlert.getValue(), cArray, false, 0, 6, null);
        String eventName = (String)splitString.get(0);
        MapUnit unit = null;
        int n = splitString.size();
        for (int i = 1; i < n; ++i) {
            if (!StringsKt.startsWith$default((String)splitString.get(i), "unitId=", false, 2, null)) continue;
            int unitId = Integer.parseInt(StringsKt.substringAfter$default((String)splitString.get(i), "unitId=", null, 2, null));
            unit = this.getViewingCiv().getUnits().getUnitById(unitId);
        }
        Event event = this.getGameInfo().getRuleset().getEvents().get(eventName);
        if (event == null) {
            return false;
        }
        Event event2 = event;
        RenderEvent render = new RenderEvent(event2, this.worldScreen, unit, arg_0 -> AlertPopup.addEvent$lambda$29(this, arg_0));
        if (!render.isValid()) {
            return false;
        }
        this.add((Actor)render).pad(0.0f).row();
        return true;
    }

    @Override
    public void close() {
        this.getViewingCiv().getPopupAlerts().remove(this.popupAlert);
        this.worldScreen.setShouldUpdate(true);
        super.close();
    }

    private static final Unit addBulliedOrAttackedProtectedOrAlliedMinor$lambda$1(Civilization $player, Civilization $bullyOrAttacker, AlertPopup this$0, Civilization $cityState) {
        DiplomacyManager diplomacyManager = $player.getDiplomacyManager($bullyOrAttacker);
        Intrinsics.checkNotNull(diplomacyManager);
        diplomacyManager.sideWithCityState();
        WarType warReason = this$0.popupAlert.getType() == AlertType.AttackedAllyMinor ? WarType.AlliedCityStateWar : WarType.ProtectedCityStateWar;
        DiplomacyManager diplomacyManager2 = $player.getDiplomacyManager($bullyOrAttacker);
        Intrinsics.checkNotNull(diplomacyManager2);
        diplomacyManager2.declareWar(new DeclareWarReason(warReason, $cityState));
        DiplomacyManager diplomacyManager3 = $cityState.getDiplomacyManager($player);
        Intrinsics.checkNotNull(diplomacyManager3);
        DiplomacyManager diplomacyManager4 = diplomacyManager3;
        diplomacyManager4.setInfluence$core(diplomacyManager4.getInfluence$core() + 20.0f);
        return Unit.INSTANCE;
    }

    private static final Unit addBulliedOrAttackedProtectedOrAlliedMinor$lambda$2(Civilization $player, Civilization $bullyOrAttacker) {
        DiplomacyManager diplomacyManager = $player.getDiplomacyManager($bullyOrAttacker);
        Intrinsics.checkNotNull(diplomacyManager);
        diplomacyManager.sideWithCityState();
        return Unit.INSTANCE;
    }

    private static final Unit addBulliedOrAttackedProtectedOrAlliedMinor$lambda$3(Civilization $player, Civilization $cityState) {
        String[] stringArray = new String[]{$cityState.getCivName()};
        $player.addNotification("You have broken your Pledge to Protect [" + $cityState.getCivName() + "]!", $cityState.getCityStateFunctions().getNotificationActions(), Notification.NotificationCategory.Diplomacy, stringArray);
        $cityState.getCityStateFunctions().removeProtectorCiv($player, true);
        return Unit.INSTANCE;
    }

    private static final Unit addCityConquered$lambda$4(City $city, Civilization $conqueringCiv) {
        $city.puppetCity($conqueringCiv);
        City.destroyCity$default($city, false, 1, null);
        return Unit.INSTANCE;
    }

    private static final Unit addCityConquered$lambda$5(City $city, Civilization $conqueringCiv) {
        $city.puppetCity($conqueringCiv);
        return Unit.INSTANCE;
    }

    private static final Unit addCityConquered$lambda$6(City $city, Civilization $conqueringCiv) {
        $city.puppetCity($conqueringCiv);
        return Unit.INSTANCE;
    }

    private static final Unit addDeclarationOfFriendship$lambda$7(DiplomacyManager $playerDiploManager) {
        $playerDiploManager.signDeclarationOfFriendship();
        return Unit.INSTANCE;
    }

    private static final Unit addDeclarationOfFriendship$lambda$8(DiplomacyManager $playerDiploManager) {
        $playerDiploManager.otherCivDiplomacy().setFlag(DiplomacyFlags.DeclinedDeclarationOfFriendship, 20);
        return Unit.INSTANCE;
    }

    private static final Unit addDemand$lambda$9(DiplomacyManager $playerDiploManager, Demand $demand) {
        $playerDiploManager.agreeToDemand($demand);
        return Unit.INSTANCE;
    }

    private static final Unit addDemand$lambda$10(DiplomacyManager $playerDiploManager, Demand $demand) {
        $playerDiploManager.refuseDemand($demand);
        return Unit.INSTANCE;
    }

    private static final Unit addDiplomaticMarriage$lambda$11(City $city) {
        $city.destroyCity(true);
        return Unit.INSTANCE;
    }

    private static final Unit addDiplomaticMarriage$lambda$12() {
        return Unit.INSTANCE;
    }

    private static final Unit addDiplomaticMarriage$lambda$13(City $city) {
        $city.setPuppet(true);
        CityStats.update$default($city.getCityStats(), null, false, false, null, false, 31, null);
        return Unit.INSTANCE;
    }

    private static final Unit addGameHasBeenWon$lambda$14(AlertPopup this$0) {
        this$0.close();
        this$0.worldScreen.getGame().pushScreen(new VictoryScreen(this$0.worldScreen, 0, 2, null));
        return Unit.INSTANCE;
    }

    private static final Unit addRecapturedCivilian$lambda$16(MapUnit $capturedUnit, Civilization $originalOwner, Civilization $captor, Tile $tile) {
        Object v0;
        String unitName = $capturedUnit.getBaseUnit().getName();
        MapUnit.destroy$default($capturedUnit, false, 1, null);
        Iterable $this$minByOrNull$iv = $originalOwner.getCities();
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = minElem$iv;
            } else {
                City it = (City)minElem$iv;
                boolean bl = false;
                int minValue$iv = it.getCenterTile().aerialDistanceTo($tile);
                do {
                    Object e$iv = iterator$iv.next();
                    City it2 = (City)e$iv;
                    $i$a$-minByOrNull-AlertPopup$addRecapturedCivilian$1$closestCity$1 = false;
                    int v$iv = it2.getCenterTile().aerialDistanceTo($tile);
                    if (minValue$iv <= v$iv) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = minElem$iv;
            }
        }
        City closestCity = v0;
        if (closestCity != null) {
            $originalOwner.getUnits().placeUnitNearTile(closestCity.getLocation(), unitName);
        }
        if ($originalOwner.isCityState()) {
            $originalOwner.getDiplomacyManagerOrMeet($captor).addInfluence(45.0f);
        } else if ($originalOwner.isMajorCiv()) {
            $originalOwner.getDiplomacyManagerOrMeet($captor).setModifier(DiplomaticModifiers.ReturnedCapturedUnits, 20.0f);
        }
        Sequence notificationSequence2 = SequencesKt.sequence((Function2)new Function2<SequenceScope<? super NotificationAction>, Continuation<? super Unit>, Object>($tile, closestCity, $captor, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ Tile $tile;
            final /* synthetic */ City $closestCity;
            final /* synthetic */ Civilization $captor;
            {
                this.$tile = $tile;
                this.$closestCity = $closestCity;
                this.$captor = $captor;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = (SequenceScope)this.L$0;
                var3_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure($result);
                        this.L$0 = $this$sequence;
                        this.label = 1;
                        v0 = $this$sequence.yield(new LocationAction(this.$tile.getPosition()), this);
                        if (v0 == var3_3) {
                            return var3_3;
                        }
                        ** GOTO lbl15
                    }
                    case 1: {
                        ResultKt.throwOnFailure($result);
                        v0 = $result;
lbl15:
                        // 2 sources

                        if (this.$closestCity != null) {
                            this.L$0 = $this$sequence;
                            this.label = 2;
                            v1 = $this$sequence.yield(new LocationAction(this.$closestCity.getLocation()), this);
                            if (v1 == var3_3) {
                                return var3_3;
                            }
                        }
                        ** GOTO lbl25
                    }
                    case 2: {
                        ResultKt.throwOnFailure($result);
                        v1 = $result;
lbl25:
                        // 2 sources

                        this.L$0 = $this$sequence;
                        this.label = 3;
                        v2 = $this$sequence.yield(new DiplomacyAction(this.$captor.getCivName(), false, 2, null), this);
                        if (v2 == var3_3) {
                            return var3_3;
                        }
                        ** GOTO lbl34
                    }
                    case 3: {
                        ResultKt.throwOnFailure($result);
                        v2 = $result;
lbl34:
                        // 2 sources

                        this.L$0 = SpillingKt.nullOutSpilledVariable($this$sequence);
                        this.label = 4;
                        v3 = $this$sequence.yield(new CivilopediaAction("Tutorial/Barbarians"), this);
                        if (v3 == var3_3) {
                            return var3_3;
                        }
                        ** GOTO lbl43
                    }
                    case 4: {
                        ResultKt.throwOnFailure($result);
                        v3 = $result;
lbl43:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                Function2<SequenceScope<? super NotificationAction>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)((Object)function2);
            }

            public final Object invoke(SequenceScope<? super NotificationAction> p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        });
        String[] stringArray = new String[]{"StatIcons/Acquire", unitName, $captor.getCivName()};
        $originalOwner.addNotification("Your captured [" + unitName + "] has been returned by [" + $captor.getCivName() + ']', notificationSequence2, Notification.NotificationCategory.Diplomacy, stringArray);
        return Unit.INSTANCE;
    }

    private static final Unit addRecapturedCivilian$lambda$17(MapUnit $capturedUnit, Civilization $captor) {
        BattleUnitCapture.INSTANCE.captureOrConvertToWorker($capturedUnit, $captor);
        return Unit.INSTANCE;
    }

    private static final Unit addDestroyOption$lambda$22(Function0 $destroyAction, AlertPopup this$0) {
        $destroyAction.invoke();
        this$0.close();
        return Unit.INSTANCE;
    }

    private static final Unit addAnnexOption$lambda$24$lambda$23(Function0 $annexAction, City $city, AlertPopup this$0) {
        $annexAction.invoke();
        $city.annexCity();
        this$0.close();
        return Unit.INSTANCE;
    }

    private static final Unit addPuppetOption$lambda$25(Function0 $puppetAction, AlertPopup this$0) {
        $puppetAction.invoke();
        this$0.close();
        return Unit.INSTANCE;
    }

    private static final Unit addLiberateOption$lambda$26(City $city, Civilization $conqueringCiv, AlertPopup this$0) {
        $city.liberateCity($conqueringCiv);
        this$0.close();
        return Unit.INSTANCE;
    }

    private static final Unit addRazeOption$lambda$28$lambda$27(City $city, Civilization $conqueringCiv, boolean $mayAnnex, AlertPopup this$0) {
        $city.puppetCity($conqueringCiv);
        if ($mayAnnex) {
            $city.annexCity();
        }
        $city.setBeingRazed(true);
        this$0.close();
        return Unit.INSTANCE;
    }

    private static final Unit addEvent$lambda$29(AlertPopup this$0, EventChoice it) {
        Intrinsics.checkNotNullParameter(it, "it");
        this$0.close();
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AlertType.values().length];
            try {
                nArray[AlertType.CityConquered.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AlertType.CityTraded.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AlertType.DiplomaticMarriage.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AlertType.FirstContact.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AlertType.WarDeclaration.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AlertType.BorderConflict.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AlertType.TilesStolen.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AlertType.DemandToStopSettlingCitiesNear.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AlertType.CitySettledNearOtherCivDespiteOurPromise.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AlertType.DemandToStopSpreadingReligion.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AlertType.ReligionSpreadDespiteOurPromise.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AlertType.DemandToStopSpyingOnUs.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AlertType.SpyingOnUsDespiteOurPromise.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AlertType.DeclarationOfFriendship.ordinal()] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AlertType.BulliedProtectedMinor.ordinal()] = 15;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AlertType.AttackedProtectedMinor.ordinal()] = 16;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AlertType.AttackedAllyMinor.ordinal()] = 17;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AlertType.Defeated.ordinal()] = 18;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AlertType.WonderBuilt.ordinal()] = 19;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AlertType.TechResearched.ordinal()] = 20;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AlertType.GoldenAge.ordinal()] = 21;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AlertType.StartIntro.ordinal()] = 22;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AlertType.RecapturedCivilian.ordinal()] = 23;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AlertType.GameHasBeenWon.ordinal()] = 24;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AlertType.Event.ordinal()] = 25;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

