/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.mapeditorscreen.tabs;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.tile.Terrain;
import com.unciv.models.ruleset.tile.TerrainType;
import com.unciv.models.ruleset.unique.GameContext;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.civilopediascreen.FormattedLine;
import com.unciv.ui.screens.civilopediascreen.MarkupRenderer;
import com.unciv.ui.screens.mapeditorscreen.tabs.IMapEditorEditSubTabs;
import com.unciv.ui.screens.mapeditorscreen.tabs.MapEditorEditTab;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0013\u0010\t\u001a\r\u0012\t\u0012\u00070\u000b\u00a2\u0006\u0002\b\f0\nH\u0002J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/unciv/ui/screens/mapeditorscreen/tabs/MapEditorEditWondersTab;", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "Lcom/unciv/ui/screens/mapeditorscreen/tabs/IMapEditorEditSubTabs;", "editTab", "Lcom/unciv/ui/screens/mapeditorscreen/tabs/MapEditorEditTab;", "ruleset", "Lcom/unciv/models/ruleset/Ruleset;", "<init>", "(Lcom/unciv/ui/screens/mapeditorscreen/tabs/MapEditorEditTab;Lcom/unciv/models/ruleset/Ruleset;)V", "allowedWonders", "Lkotlin/sequences/Sequence;", "Lcom/unciv/models/ruleset/tile/Terrain;", "Lkotlin/jvm/internal/EnhancedNullability;", "getWonders", "", "Lcom/unciv/ui/screens/civilopediascreen/FormattedLine;", "isDisabled", "", "core"})
public final class MapEditorEditWondersTab
extends Table
implements IMapEditorEditSubTabs {
    @NotNull
    private final MapEditorEditTab editTab;
    @NotNull
    private final Ruleset ruleset;

    public MapEditorEditWondersTab(@NotNull MapEditorEditTab editTab, @NotNull Ruleset ruleset) {
        Intrinsics.checkNotNullParameter(editTab, "editTab");
        Intrinsics.checkNotNullParameter(ruleset, "ruleset");
        super(BaseScreen.Companion.getSkin());
        this.editTab = editTab;
        this.ruleset = ruleset;
        this.top();
        this.defaults().pad(10.0f).fillX().left();
        this.add((Actor)MarkupRenderer.render$default(MarkupRenderer.INSTANCE, this.getWonders(), 0.0f, 0.0f, FormattedLine.IconDisplay.NoLink, arg_0 -> MapEditorEditWondersTab._init_$lambda$1(this, arg_0), 6, null)).row();
    }

    private final Sequence<Terrain> allowedWonders() {
        Collection<Terrain> collection = this.ruleset.getTerrains().values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        return SequencesKt.filterNot(SequencesKt.filter(CollectionsKt.asSequence((Iterable)collection), MapEditorEditWondersTab::allowedWonders$lambda$2), MapEditorEditWondersTab::allowedWonders$lambda$3);
    }

    private final Iterable<FormattedLine> getWonders() {
        return SequencesKt.asIterable(SequencesKt.map(this.allowedWonders(), MapEditorEditWondersTab::getWonders$lambda$4));
    }

    @Override
    public boolean isDisabled() {
        return SequencesKt.none(this.allowedWonders());
    }

    private static final Unit lambda$1$lambda$0(MapEditorEditWondersTab this$0, String $it, Tile tile) {
        Intrinsics.checkNotNullParameter(tile, "tile");
        Terrain terrain = this$0.ruleset.getTerrains().get($it);
        Intrinsics.checkNotNull(terrain);
        if (terrain.getTurnsInto() != null) {
            Terrain terrain2 = this$0.ruleset.getTerrains().get($it);
            Intrinsics.checkNotNull(terrain2);
            String string = terrain2.getTurnsInto();
            Intrinsics.checkNotNull(string);
            tile.setBaseTerrain(string);
        }
        tile.removeTerrainFeatures();
        tile.setNaturalWonder($it);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1(MapEditorEditWondersTab this$0, String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        MapEditorEditTab.setBrush$default(this$0.editTab, it, "Terrain/" + it, null, null, false, arg_0 -> MapEditorEditWondersTab.lambda$1$lambda$0(this$0, it, arg_0), 28, null);
        return Unit.INSTANCE;
    }

    private static final boolean allowedWonders$lambda$2(Terrain it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getType() == TerrainType.NaturalWonder;
    }

    private static final boolean allowedWonders$lambda$3(Terrain it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.hasUnique(UniqueType.ExcludedFromMapEditor, GameContext.Companion.getIgnoreConditionals());
    }

    private static final FormattedLine getWonders$lambda$4(Terrain it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return new FormattedLine(it.getName(), it.getName(), "Terrain/" + it.getName(), null, 0.0f, 32, 0, 0, 0.0f, null, false, false, false, false, 16344, null);
    }
}

