/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.popups;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.unciv.GUI;
import com.unciv.logic.city.City;
import com.unciv.logic.city.CityConstructions;
import com.unciv.models.metadata.GameSettings;
import com.unciv.models.ruleset.Building;
import com.unciv.models.ruleset.IConstruction;
import com.unciv.models.ruleset.PerpetualConstruction;
import com.unciv.ui.components.input.KeyboardBinding;
import com.unciv.ui.popups.AnimatedMenuPopup;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import yairm210.purity.annotations.Pure;
import yairm210.purity.annotations.Readonly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00070\u0019H\u0003J\u001c\u0010\u001a\u001a\u00020\u001b2\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u001b0\u001dH\u0003J\u001c\u0010\u001e\u001a\u00020\f2\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\f0\u001dH\u0003J\n\u0010%\u001a\u0004\u0018\u00010&H\u0016J\b\u0010'\u001a\u00020\u001bH\u0003J\b\u0010(\u001a\u00020\fH\u0002J\b\u0010)\u001a\u00020\u001bH\u0003J\b\u0010*\u001a\u00020\fH\u0002J\b\u0010+\u001a\u00020\u001bH\u0003J\b\u0010,\u001a\u00020\u001bH\u0003J\b\u0010-\u001a\u00020\fH\u0002J\b\u0010.\u001a\u00020\u001bH\u0003J\b\u0010/\u001a\u00020\fH\u0002J\b\u00100\u001a\u00020\u001bH\u0003J\b\u00101\u001a\u00020\fH\u0002J\b\u00102\u001a\u00020\u001bH\u0003J\b\u00103\u001a\u00020\fH\u0002J\b\u00104\u001a\u00020\u001bH\u0003J\b\u00105\u001a\u00020\fH\u0002J\b\u00106\u001a\u00020\u001bH\u0003J\b\u00107\u001a\u00020\fH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\"\u001a\u0012\u0012\u0004\u0012\u00020\u00120#j\b\u0012\u0004\u0012\u00020\u0012`$X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lcom/unciv/ui/popups/CityScreenConstructionMenu;", "Lcom/unciv/ui/popups/AnimatedMenuPopup;", "stage", "Lcom/badlogic/gdx/scenes/scene2d/Stage;", "positionNextTo", "Lcom/badlogic/gdx/scenes/scene2d/Actor;", "city", "Lcom/unciv/logic/city/City;", "construction", "Lcom/unciv/models/ruleset/IConstruction;", "onButtonClicked", "Lkotlin/Function0;", "", "<init>", "(Lcom/badlogic/gdx/scenes/scene2d/Stage;Lcom/badlogic/gdx/scenes/scene2d/Actor;Lcom/unciv/logic/city/City;Lcom/unciv/models/ruleset/IConstruction;Lkotlin/jvm/functions/Function0;)V", "cityConstructions", "Lcom/unciv/logic/city/CityConstructions;", "constructionName", "", "queueSizeWithoutPerpetual", "", "getQueueSizeWithoutPerpetual", "()I", "myIndex", "candidateCities", "Lkotlin/sequences/Sequence;", "allCitiesEntryValid", "", "predicate", "Lkotlin/Function1;", "forAllCities", "action", "settings", "Lcom/unciv/models/metadata/GameSettings;", "disabledAutoAssignConstructions", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "createContentTable", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "canMoveQueueTop", "moveQueueTop", "canMoveQueueEnd", "moveQueueEnd", "isConstructionImprovementCreationBuilding", "canAddQueueTop", "addQueueTop", "canAddAllQueues", "addAllQueues", "canAddAllQueuesTop", "addAllQueuesTop", "canRemoveAllQueues", "removeAllQueues", "canDisable", "disableEntry", "canEnable", "enableEntry", "core"})
@SourceDebugExtension(value={"SMAP\nCityScreenConstructionMenu.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CityScreenConstructionMenu.kt\ncom/unciv/ui/popups/CityScreenConstructionMenu\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,149:1\n1788#2,4:150\n1255#3,2:154\n1321#3,2:156\n1#4:158\n*S KotlinDebug\n*F\n+ 1 CityScreenConstructionMenu.kt\ncom/unciv/ui/popups/CityScreenConstructionMenu\n*L\n39#1:150,4\n50#1:154,2\n52#1:156,2\n*E\n"})
public final class CityScreenConstructionMenu
extends AnimatedMenuPopup {
    @NotNull
    private final City city;
    @NotNull
    private final IConstruction construction;
    @NotNull
    private final Function0<Unit> onButtonClicked;
    @NotNull
    private final CityConstructions cityConstructions;
    @NotNull
    private final String constructionName;
    private final int myIndex;
    @NotNull
    private final GameSettings settings;
    @NotNull
    private final HashSet<String> disabledAutoAssignConstructions;

    public CityScreenConstructionMenu(@NotNull Stage stage, @NotNull Actor positionNextTo, @NotNull City city, @NotNull IConstruction construction, @NotNull Function0<Unit> onButtonClicked) {
        Intrinsics.checkNotNullParameter(stage, "stage");
        Intrinsics.checkNotNullParameter(positionNextTo, "positionNextTo");
        Intrinsics.checkNotNullParameter(city, "city");
        Intrinsics.checkNotNullParameter(construction, "construction");
        Intrinsics.checkNotNullParameter(onButtonClicked, "onButtonClicked");
        super(stage, AnimatedMenuPopup.Companion.getActorTopRight(positionNextTo));
        this.city = city;
        this.construction = construction;
        this.onButtonClicked = onButtonClicked;
        this.cityConstructions = this.city.getCityConstructions();
        this.constructionName = this.construction.getName();
        this.myIndex = this.cityConstructions.getConstructionQueue().indexOf(this.constructionName);
        this.settings = GUI.INSTANCE.getSettings();
        this.disabledAutoAssignConstructions = this.settings.getDisabledAutoAssignConstructions();
        this.getCloseListeners().add(() -> CityScreenConstructionMenu._init_$lambda$4(this));
    }

    /*
     * WARNING - void declaration
     */
    private final int getQueueSizeWithoutPerpetual() {
        int n;
        Iterable $this$count$iv = this.cityConstructions.getConstructionQueue();
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            void var3_3;
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                if (!(!PerpetualConstruction.Companion.getPerpetualConstructionsMap().containsKey(it)) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = var3_3;
        }
        return n;
    }

    @Readonly
    private final Sequence<City> candidateCities() {
        return SequencesKt.filterNot(CollectionsKt.asSequence((Iterable)this.city.getCiv().getCities()), CityScreenConstructionMenu::candidateCities$lambda$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Readonly
    private final boolean allCitiesEntryValid(Function1<? super CityConstructions, Boolean> predicate) {
        CityConstructions element$iv;
        boolean bl;
        if (this.city.getCiv().getCities().size() <= 1) return false;
        IConstruction iConstruction = this.construction;
        Building building = iConstruction instanceof Building ? (Building)iConstruction : null;
        if (building != null) {
            if (building.isAnyWonder()) {
                return false;
            }
            bl = false;
        } else {
            bl = false;
        }
        if (bl) return false;
        Sequence<CityConstructions> $this$any$iv = SequencesKt.map(this.candidateCities(), CityScreenConstructionMenu::allCitiesEntryValid$lambda$2);
        boolean $i$f$any = false;
        Iterator<CityConstructions> iterator2 = $this$any$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
        } while (!predicate.invoke(element$iv = iterator2.next()).booleanValue());
        return true;
    }

    @Readonly
    private final void forAllCities(Function1<? super CityConstructions, Unit> action2) {
        Sequence<CityConstructions> $this$forEach$iv = SequencesKt.map(this.candidateCities(), CityScreenConstructionMenu::forAllCities$lambda$3);
        boolean $i$f$forEach = false;
        Iterator<CityConstructions> iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            CityConstructions element$iv = iterator2.next();
            action2.invoke(element$iv);
        }
    }

    @Override
    @Nullable
    public Table createContentTable() {
        Table table2;
        Table table3 = super.createContentTable();
        Intrinsics.checkNotNull(table3);
        Table table4 = table3;
        if (this.canMoveQueueTop()) {
            table4.add((Actor)this.getButton("Move to the top of the queue", KeyboardBinding.RaisePriority, new Function0<Unit>((Object)this){

                public final void invoke() {
                    CityScreenConstructionMenu.access$moveQueueTop((CityScreenConstructionMenu)this.receiver);
                }
            })).row();
        }
        if (this.canMoveQueueEnd()) {
            table4.add((Actor)this.getButton("Move to the end of the queue", KeyboardBinding.LowerPriority, new Function0<Unit>((Object)this){

                public final void invoke() {
                    CityScreenConstructionMenu.access$moveQueueEnd((CityScreenConstructionMenu)this.receiver);
                }
            })).row();
        }
        if (this.canAddQueueTop()) {
            table4.add((Actor)this.getButton("Add to the top of the queue", KeyboardBinding.AddConstructionTop, new Function0<Unit>((Object)this){

                public final void invoke() {
                    CityScreenConstructionMenu.access$addQueueTop((CityScreenConstructionMenu)this.receiver);
                }
            })).row();
        }
        if (this.canAddAllQueues()) {
            table4.add((Actor)this.getButton("Add to the queue in all cities", KeyboardBinding.AddConstructionAll, new Function0<Unit>((Object)this){

                public final void invoke() {
                    CityScreenConstructionMenu.access$addAllQueues((CityScreenConstructionMenu)this.receiver);
                }
            })).row();
        }
        if (this.canAddAllQueuesTop()) {
            table4.add((Actor)this.getButton("Add or move to the top in all cities", KeyboardBinding.AddConstructionAllTop, new Function0<Unit>((Object)this){

                public final void invoke() {
                    CityScreenConstructionMenu.access$addAllQueuesTop((CityScreenConstructionMenu)this.receiver);
                }
            })).row();
        }
        if (this.canRemoveAllQueues()) {
            table4.add((Actor)this.getButton("Remove from the queue in all cities", KeyboardBinding.RemoveConstructionAll, new Function0<Unit>((Object)this){

                public final void invoke() {
                    CityScreenConstructionMenu.access$removeAllQueues((CityScreenConstructionMenu)this.receiver);
                }
            })).row();
        }
        if (this.canDisable()) {
            table4.add((Actor)this.getButton("Disable", KeyboardBinding.BuildDisabled, new Function0<Unit>((Object)this){

                public final void invoke() {
                    CityScreenConstructionMenu.access$disableEntry((CityScreenConstructionMenu)this.receiver);
                }
            })).row();
        }
        if (this.canEnable()) {
            table4.add((Actor)this.getButton("Enable", KeyboardBinding.BuildDisabled, new Function0<Unit>((Object)this){

                public final void invoke() {
                    CityScreenConstructionMenu.access$enableEntry((CityScreenConstructionMenu)this.receiver);
                }
            })).row();
        }
        Table it = table2 = table4;
        boolean bl = false;
        return !it.getCells().isEmpty() ? table2 : null;
    }

    @Pure
    private final boolean canMoveQueueTop() {
        if (this.construction instanceof PerpetualConstruction) {
            return false;
        }
        return this.myIndex > 0;
    }

    private final void moveQueueTop() {
        this.cityConstructions.moveEntryToTop(this.myIndex);
    }

    @Pure
    private final boolean canMoveQueueEnd() {
        if (this.construction instanceof PerpetualConstruction) {
            return false;
        }
        int n = this.getQueueSizeWithoutPerpetual() - 1;
        int n2 = this.myIndex;
        return 0 <= n2 ? n2 < n : false;
    }

    private final void moveQueueEnd() {
        this.cityConstructions.moveEntryToEnd(this.myIndex);
    }

    @Readonly
    private final boolean isConstructionImprovementCreationBuilding() {
        return this.construction instanceof Building && ((Building)this.construction).hasCreateOneImprovementUnique();
    }

    @Readonly
    private final boolean canAddQueueTop() {
        return !(this.construction instanceof PerpetualConstruction) && this.cityConstructions.canAddToQueue(this.construction) && !this.isConstructionImprovementCreationBuilding();
    }

    private final void addQueueTop() {
        this.cityConstructions.addToQueue(this.construction, true);
    }

    @Readonly
    private final boolean canAddAllQueues() {
        return this.allCitiesEntryValid(arg_0 -> CityScreenConstructionMenu.canAddAllQueues$lambda$6(this, arg_0));
    }

    private final void addAllQueues() {
        this.forAllCities(arg_0 -> CityScreenConstructionMenu.addAllQueues$lambda$7(this, arg_0));
    }

    @Readonly
    private final boolean canAddAllQueuesTop() {
        return !(this.construction instanceof PerpetualConstruction) && this.allCitiesEntryValid(arg_0 -> CityScreenConstructionMenu.canAddAllQueuesTop$lambda$8(this, arg_0));
    }

    private final void addAllQueuesTop() {
        this.forAllCities(arg_0 -> CityScreenConstructionMenu.addAllQueuesTop$lambda$9(this, arg_0));
    }

    @Readonly
    private final boolean canRemoveAllQueues() {
        return this.allCitiesEntryValid(arg_0 -> CityScreenConstructionMenu.canRemoveAllQueues$lambda$10(this, arg_0));
    }

    private final void removeAllQueues() {
        this.forAllCities(arg_0 -> CityScreenConstructionMenu.removeAllQueues$lambda$11(this, arg_0));
    }

    @Readonly
    private final boolean canDisable() {
        return !this.disabledAutoAssignConstructions.contains(this.constructionName) && !Intrinsics.areEqual(this.construction, PerpetualConstruction.Companion.getIdle());
    }

    private final void disableEntry() {
        this.disabledAutoAssignConstructions.add(this.constructionName);
        this.settings.save();
    }

    @Readonly
    private final boolean canEnable() {
        return this.disabledAutoAssignConstructions.contains(this.constructionName);
    }

    private final void enableEntry() {
        this.disabledAutoAssignConstructions.remove(this.constructionName);
        this.settings.save();
    }

    private static final boolean candidateCities$lambda$1(City it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.isPuppet() || it.isInResistance() || it.isBeingRazed();
    }

    private static final CityConstructions allCitiesEntryValid$lambda$2(City it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getCityConstructions();
    }

    private static final CityConstructions forAllCities$lambda$3(City it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getCityConstructions();
    }

    private static final Unit _init_$lambda$4(CityScreenConstructionMenu this$0) {
        if (this$0.getAnyButtonWasClicked()) {
            this$0.onButtonClicked.invoke();
        }
        return Unit.INSTANCE;
    }

    private static final boolean canAddAllQueues$lambda$6(CityScreenConstructionMenu this$0, CityConstructions it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.canAddToQueue(this$0.construction) && !this$0.isConstructionImprovementCreationBuilding() && (!(this$0.construction instanceof PerpetualConstruction) || !it.isBeingConstructedOrEnqueued(this$0.constructionName));
    }

    private static final Unit addAllQueues$lambda$7(CityScreenConstructionMenu this$0, CityConstructions it) {
        Intrinsics.checkNotNullParameter(it, "it");
        CityConstructions.addToQueue$default(it, this$0.construction, false, 2, null);
        return Unit.INSTANCE;
    }

    private static final boolean canAddAllQueuesTop$lambda$8(CityScreenConstructionMenu this$0, CityConstructions it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.canAddToQueue(this$0.construction) && !this$0.isConstructionImprovementCreationBuilding() || it.isEnqueuedForLater(this$0.constructionName);
    }

    private static final Unit addAllQueuesTop$lambda$9(CityScreenConstructionMenu this$0, CityConstructions it) {
        Intrinsics.checkNotNullParameter(it, "it");
        int index = it.getConstructionQueue().indexOf(this$0.constructionName);
        if (index > 0) {
            it.moveEntryToTop(index);
        } else {
            it.addToQueue(this$0.construction, true);
        }
        return Unit.INSTANCE;
    }

    private static final boolean canRemoveAllQueues$lambda$10(CityScreenConstructionMenu this$0, CityConstructions it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.isBeingConstructedOrEnqueued(this$0.constructionName);
    }

    private static final Unit removeAllQueues$lambda$11(CityScreenConstructionMenu this$0, CityConstructions it) {
        Intrinsics.checkNotNullParameter(it, "it");
        it.removeAllByName(this$0.constructionName);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$moveQueueTop(CityScreenConstructionMenu $this) {
        $this.moveQueueTop();
    }

    public static final /* synthetic */ void access$moveQueueEnd(CityScreenConstructionMenu $this) {
        $this.moveQueueEnd();
    }

    public static final /* synthetic */ void access$addQueueTop(CityScreenConstructionMenu $this) {
        $this.addQueueTop();
    }

    public static final /* synthetic */ void access$addAllQueues(CityScreenConstructionMenu $this) {
        $this.addAllQueues();
    }

    public static final /* synthetic */ void access$addAllQueuesTop(CityScreenConstructionMenu $this) {
        $this.addAllQueuesTop();
    }

    public static final /* synthetic */ void access$removeAllQueues(CityScreenConstructionMenu $this) {
        $this.removeAllQueues();
    }

    public static final /* synthetic */ void access$disableEntry(CityScreenConstructionMenu $this) {
        $this.disableEntry();
    }

    public static final /* synthetic */ void access$enableEntry(CityScreenConstructionMenu $this) {
        $this.enableEntry();
    }
}

